/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service.audit;

import com.provectus.kafka.ui.config.auth.AuthenticatedUser;
import com.provectus.kafka.ui.model.rbac.AccessContext;
import com.provectus.kafka.ui.service.audit.AuditRecord;
import java.io.Closeable;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
record AuditWriter(String clusterName, boolean logAlterOperationsOnly, @Nullable String targetTopic, @Nullable KafkaProducer<byte[], byte[]> producer, @Nullable Logger consoleLogger) implements Closeable
{
    private final String clusterName;
    private final boolean logAlterOperationsOnly;
    @Nullable
    private final String targetTopic;
    @Nullable
    private final KafkaProducer<byte[], byte[]> producer;
    @Nullable
    private final Logger consoleLogger;
    private static final Logger log = LoggerFactory.getLogger(AuditWriter.class);

    AuditWriter(String clusterName, boolean logAlterOperationsOnly, @Nullable String targetTopic, @Nullable KafkaProducer<byte[], byte[]> producer, @Nullable Logger consoleLogger) {
        this.clusterName = clusterName;
        this.logAlterOperationsOnly = logAlterOperationsOnly;
        this.targetTopic = targetTopic;
        this.producer = producer;
        this.consoleLogger = consoleLogger;
    }

    boolean isTopicWritingEnabled() {
        return this.producer != null;
    }

    static void writeAppOperation(Logger consoleLogger, AccessContext ctx, AuthenticatedUser user, @Nullable Throwable th) {
        consoleLogger.info(AuditWriter.createRecord((AccessContext)ctx, (AuthenticatedUser)user, (Throwable)th).toJson());
    }

    void write(AccessContext ctx, AuthenticatedUser user, @Nullable Throwable th) {
        this.write(AuditWriter.createRecord((AccessContext)ctx, (AuthenticatedUser)user, (Throwable)th));
    }

    private void write(AuditRecord rec) {
        if (this.logAlterOperationsOnly && rec.resources().stream().noneMatch(AuditRecord.AuditResource::alter)) {
            return;
        }
        String json = rec.toJson();
        if (this.consoleLogger != null) {
            this.consoleLogger.info(json);
        }
        if (this.targetTopic != null && this.producer != null) {
            this.producer.send(new ProducerRecord(this.targetTopic, null, (Object)json.getBytes(StandardCharsets.UTF_8)), (metadata, ex) -> {
                if (ex != null) {
                    log.warn("Error sending Audit record to kafka for cluster {}", (Object)this.clusterName, (Object)ex);
                }
            });
        }
    }

    private static AuditRecord createRecord(AccessContext ctx, AuthenticatedUser user, @Nullable Throwable th) {
        return new AuditRecord(DateTimeFormatter.ISO_INSTANT.format(Instant.now()), user.principal(), ctx.getCluster(), AuditRecord.AuditResource.getAccessedResources((AccessContext)ctx), ctx.getOperationName(), ctx.getOperationParams(), th == null ? AuditRecord.OperationResult.successful() : AuditRecord.OperationResult.error((Throwable)th));
    }

    @Override
    public void close() {
        Optional.ofNullable(this.producer).ifPresent(KafkaProducer::close);
    }

    public String clusterName() {
        return this.clusterName;
    }

    public boolean logAlterOperationsOnly() {
        return this.logAlterOperationsOnly;
    }

    @Nullable
    public String targetTopic() {
        return this.targetTopic;
    }

    @Nullable
    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    @Nullable
    public Logger consoleLogger() {
        return this.consoleLogger;
    }
}

