/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service.analyze;

import com.google.common.base.Throwables;
import com.provectus.kafka.ui.model.TopicAnalysisDTO;
import com.provectus.kafka.ui.model.TopicAnalysisResultDTO;
import com.provectus.kafka.ui.service.analyze.AnalysisTasksStore;
import com.provectus.kafka.ui.service.analyze.TopicAnalysisStats;
import com.provectus.kafka.ui.service.analyze.TopicIdentity;
import java.io.Closeable;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

class AnalysisTasksStore {
    private final Map<TopicIdentity, RunningAnalysis> running = new ConcurrentHashMap();
    private final Map<TopicIdentity, TopicAnalysisResultDTO> completed = new ConcurrentHashMap();

    AnalysisTasksStore() {
    }

    void setAnalysisError(TopicIdentity topicId, Instant collectionStartedAt, Throwable th) {
        this.running.remove(topicId);
        this.completed.put(topicId, new TopicAnalysisResultDTO().startedAt(Long.valueOf(collectionStartedAt.toEpochMilli())).finishedAt(Long.valueOf(System.currentTimeMillis())).error(Throwables.getStackTraceAsString((Throwable)th)));
    }

    void setAnalysisResult(TopicIdentity topicId, Instant collectionStartedAt, TopicAnalysisStats totalStats, Map<Integer, TopicAnalysisStats> partitionStats) {
        this.running.remove(topicId);
        this.completed.put(topicId, new TopicAnalysisResultDTO().startedAt(Long.valueOf(collectionStartedAt.toEpochMilli())).finishedAt(Long.valueOf(System.currentTimeMillis())).totalStats(totalStats.toDto(null)).partitionStats(partitionStats.entrySet().stream().map(e -> ((TopicAnalysisStats)e.getValue()).toDto((Integer)e.getKey())).collect(Collectors.toList())));
    }

    void updateProgress(TopicIdentity topicId, long msgsScanned, long bytesScanned, Double completeness) {
        this.running.computeIfPresent(topicId, (k, state) -> state.toBuilder().msgsScanned(msgsScanned).bytesScanned(bytesScanned).completenessPercent(completeness.doubleValue()).build());
    }

    void registerNewTask(TopicIdentity topicId, Closeable task) {
        this.running.put(topicId, new RunningAnalysis(Instant.now(), 0.0, 0L, 0L, task));
    }

    void cancelAnalysis(TopicIdentity topicId) {
        Optional.ofNullable((RunningAnalysis)this.running.remove(topicId)).ifPresent(RunningAnalysis::stopTask);
    }

    boolean isAnalysisInProgress(TopicIdentity id) {
        return this.running.containsKey(id);
    }

    Optional<TopicAnalysisDTO> getTopicAnalysis(TopicIdentity id) {
        RunningAnalysis runningState = (RunningAnalysis)this.running.get(id);
        TopicAnalysisResultDTO completedState = (TopicAnalysisResultDTO)this.completed.get(id);
        if (runningState == null && completedState == null) {
            return Optional.empty();
        }
        return Optional.of(this.createAnalysisDto(runningState, completedState));
    }

    private TopicAnalysisDTO createAnalysisDto(@Nullable RunningAnalysis runningState, @Nullable TopicAnalysisResultDTO completedState) {
        return new TopicAnalysisDTO().progress(runningState != null ? runningState.toDto() : null).result(completedState);
    }
}

