/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.provectus.kafka.ui.exception.SchemaCompatibilityException;
import com.provectus.kafka.ui.exception.SchemaNotFoundException;
import com.provectus.kafka.ui.exception.ValidationException;
import com.provectus.kafka.ui.model.KafkaCluster;
import com.provectus.kafka.ui.service.SchemaRegistryService;
import com.provectus.kafka.ui.sr.api.KafkaSrClientApi;
import com.provectus.kafka.ui.sr.model.Compatibility;
import com.provectus.kafka.ui.sr.model.CompatibilityCheckResponse;
import com.provectus.kafka.ui.sr.model.CompatibilityConfig;
import com.provectus.kafka.ui.sr.model.CompatibilityLevelChange;
import com.provectus.kafka.ui.sr.model.NewSubject;
import com.provectus.kafka.ui.sr.model.SchemaSubject;
import com.provectus.kafka.ui.util.ReactiveFailover;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class SchemaRegistryService {
    private static final Logger log = LoggerFactory.getLogger(SchemaRegistryService.class);
    private static final String LATEST = "latest";

    private ReactiveFailover<KafkaSrClientApi> api(KafkaCluster cluster) {
        return cluster.getSchemaRegistryClient();
    }

    public Mono<List<SubjectWithCompatibilityLevel>> getAllLatestVersionSchemas(KafkaCluster cluster, List<String> subjects) {
        return Flux.fromIterable(subjects).concatMap(subject -> this.getLatestSchemaVersionBySubject(cluster, subject)).collect(Collectors.toList());
    }

    public Mono<List<String>> getAllSubjectNames(KafkaCluster cluster) {
        return this.api(cluster).mono(c -> c.getAllSubjectNames(null, Boolean.valueOf(false))).flatMapIterable(arg_0 -> this.parseSubjectListString(arg_0)).collectList();
    }

    private List<String> parseSubjectListString(String subjectNamesStr) {
        return (List)new JsonMapper().readValue(subjectNamesStr, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Flux<SubjectWithCompatibilityLevel> getAllVersionsBySubject(KafkaCluster cluster, String subject) {
        Flux versions = this.getSubjectVersions(cluster, subject);
        return versions.flatMap(version -> this.getSchemaSubjectByVersion(cluster, subject, version));
    }

    private Flux<Integer> getSubjectVersions(KafkaCluster cluster, String schemaName) {
        return this.api(cluster).flux(c -> c.getSubjectVersions(schemaName));
    }

    public Mono<SubjectWithCompatibilityLevel> getSchemaSubjectByVersion(KafkaCluster cluster, String schemaName, Integer version) {
        return this.getSchemaSubject(cluster, schemaName, String.valueOf(version));
    }

    public Mono<SubjectWithCompatibilityLevel> getLatestSchemaVersionBySubject(KafkaCluster cluster, String schemaName) {
        return this.getSchemaSubject(cluster, schemaName, LATEST);
    }

    private Mono<SubjectWithCompatibilityLevel> getSchemaSubject(KafkaCluster cluster, String schemaName, String version) {
        return this.api(cluster).mono(c -> c.getSubjectVersion(schemaName, version, Boolean.valueOf(false))).zipWith(this.getSchemaCompatibilityInfoOrGlobal(cluster, schemaName)).map(t -> new SubjectWithCompatibilityLevel((SchemaSubject)t.getT1(), (Compatibility)t.getT2())).onErrorResume(WebClientResponseException.NotFound.class, th -> Mono.error((Throwable)new SchemaNotFoundException()));
    }

    public Mono<Void> deleteSchemaSubjectByVersion(KafkaCluster cluster, String schemaName, Integer version) {
        return this.deleteSchemaSubject(cluster, schemaName, String.valueOf(version));
    }

    public Mono<Void> deleteLatestSchemaSubject(KafkaCluster cluster, String schemaName) {
        return this.deleteSchemaSubject(cluster, schemaName, LATEST);
    }

    private Mono<Void> deleteSchemaSubject(KafkaCluster cluster, String schemaName, String version) {
        return this.api(cluster).mono(c -> c.deleteSubjectVersion(schemaName, version, Boolean.valueOf(false)));
    }

    public Mono<Void> deleteSchemaSubjectEntirely(KafkaCluster cluster, String schemaName) {
        return this.api(cluster).mono(c -> c.deleteAllSubjectVersions(schemaName, Boolean.valueOf(false)));
    }

    public Mono<SubjectWithCompatibilityLevel> registerNewSchema(KafkaCluster cluster, String subject, NewSubject newSchemaSubject) {
        return this.api(cluster).mono(c -> c.registerNewSchema(subject, newSchemaSubject)).onErrorMap(WebClientResponseException.Conflict.class, th -> new SchemaCompatibilityException()).onErrorMap(WebClientResponseException.UnprocessableEntity.class, th -> new ValidationException("Invalid schema. Error from registry: " + th.getResponseBodyAsString())).then(this.getLatestSchemaVersionBySubject(cluster, subject));
    }

    public Mono<Void> updateSchemaCompatibility(KafkaCluster cluster, String schemaName, Compatibility compatibility) {
        return this.api(cluster).mono(c -> c.updateSubjectCompatibilityLevel(schemaName, new CompatibilityLevelChange().compatibility(compatibility))).then();
    }

    public Mono<Void> updateGlobalSchemaCompatibility(KafkaCluster cluster, Compatibility compatibility) {
        return this.api(cluster).mono(c -> c.updateGlobalCompatibilityLevel(new CompatibilityLevelChange().compatibility(compatibility))).then();
    }

    public Mono<Compatibility> getSchemaCompatibilityLevel(KafkaCluster cluster, String schemaName) {
        return this.api(cluster).mono(c -> c.getSubjectCompatibilityLevel(schemaName, Boolean.valueOf(true))).map(CompatibilityConfig::getCompatibilityLevel).onErrorResume(error -> Mono.empty());
    }

    public Mono<Compatibility> getGlobalSchemaCompatibilityLevel(KafkaCluster cluster) {
        return this.api(cluster).mono(KafkaSrClientApi::getGlobalCompatibilityLevel).map(CompatibilityConfig::getCompatibilityLevel);
    }

    private Mono<Compatibility> getSchemaCompatibilityInfoOrGlobal(KafkaCluster cluster, String schemaName) {
        return this.getSchemaCompatibilityLevel(cluster, schemaName).switchIfEmpty(this.getGlobalSchemaCompatibilityLevel(cluster));
    }

    public Mono<CompatibilityCheckResponse> checksSchemaCompatibility(KafkaCluster cluster, String schemaName, NewSubject newSchemaSubject) {
        return this.api(cluster).mono(c -> c.checkSchemaCompatibility(schemaName, LATEST, Boolean.valueOf(true), newSchemaSubject));
    }
}

