/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service;

import com.provectus.kafka.ui.model.ClusterFeature;
import com.provectus.kafka.ui.model.KafkaCluster;
import com.provectus.kafka.ui.service.ReactiveAdminClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.kafka.common.acl.AclOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class FeatureService {
    private static final Logger log = LoggerFactory.getLogger(FeatureService.class);

    public Mono<List<ClusterFeature>> getAvailableFeatures(ReactiveAdminClient adminClient, KafkaCluster cluster, ReactiveAdminClient.ClusterDescription clusterDescription) {
        ArrayList<Mono> features = new ArrayList<Mono>();
        if (Optional.ofNullable(cluster.getConnectsClients()).filter(Predicate.not(Map::isEmpty)).isPresent()) {
            features.add(Mono.just((Object)ClusterFeature.KAFKA_CONNECT));
        }
        if (cluster.getKsqlClient() != null) {
            features.add(Mono.just((Object)ClusterFeature.KSQL_DB));
        }
        if (cluster.getSchemaRegistryClient() != null) {
            features.add(Mono.just((Object)ClusterFeature.SCHEMA_REGISTRY));
        }
        features.add(this.topicDeletionEnabled(adminClient));
        features.add(this.aclView(adminClient));
        features.add(this.aclEdit(adminClient, clusterDescription));
        return Flux.fromIterable(features).flatMap(m -> m).collectList();
    }

    private Mono<ClusterFeature> topicDeletionEnabled(ReactiveAdminClient adminClient) {
        return adminClient.isTopicDeletionEnabled() ? Mono.just((Object)ClusterFeature.TOPIC_DELETION) : Mono.empty();
    }

    private Mono<ClusterFeature> aclEdit(ReactiveAdminClient adminClient, ReactiveAdminClient.ClusterDescription clusterDescription) {
        Set authorizedOps = Optional.ofNullable(clusterDescription.getAuthorizedOperations()).orElse(Set.of());
        boolean canEdit = this.aclViewEnabled(adminClient) && (authorizedOps.contains(AclOperation.ALL) || authorizedOps.contains(AclOperation.ALTER));
        return canEdit ? Mono.just((Object)ClusterFeature.KAFKA_ACL_EDIT) : Mono.empty();
    }

    private Mono<ClusterFeature> aclView(ReactiveAdminClient adminClient) {
        return this.aclViewEnabled(adminClient) ? Mono.just((Object)ClusterFeature.KAFKA_ACL_VIEW) : Mono.empty();
    }

    private boolean aclViewEnabled(ReactiveAdminClient adminClient) {
        return adminClient.getClusterFeatures().contains(ReactiveAdminClient.SupportedFeature.AUTHORIZED_SECURITY_ENABLED);
    }
}

