/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service;

import com.provectus.kafka.ui.config.ClustersProperties;
import com.provectus.kafka.ui.model.KafkaCluster;
import com.provectus.kafka.ui.model.SerdeDescriptionDTO;
import com.provectus.kafka.ui.serde.api.SchemaDescription;
import com.provectus.kafka.ui.serde.api.Serde;
import com.provectus.kafka.ui.serdes.ClusterSerdes;
import com.provectus.kafka.ui.serdes.ConsumerRecordDeserializer;
import com.provectus.kafka.ui.serdes.ProducerRecordCreator;
import com.provectus.kafka.ui.serdes.SerdeInstance;
import com.provectus.kafka.ui.serdes.SerdesInitializer;
import com.provectus.kafka.ui.service.ClustersStorage;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.validation.ValidationException;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class DeserializationService
implements Closeable {
    private final Map<String, ClusterSerdes> clusterSerdes = new ConcurrentHashMap();

    public DeserializationService(Environment env, ClustersStorage clustersStorage, ClustersProperties clustersProperties) {
        SerdesInitializer serdesInitializer = new SerdesInitializer();
        for (int i = 0; i < clustersProperties.getClusters().size(); ++i) {
            ClustersProperties.Cluster clusterProperties = (ClustersProperties.Cluster)clustersProperties.getClusters().get(i);
            KafkaCluster cluster = (KafkaCluster)clustersStorage.getClusterByName(clusterProperties.getName()).get();
            this.clusterSerdes.put(cluster.getName(), serdesInitializer.init(env, clustersProperties, i));
        }
    }

    private ClusterSerdes getSerdesFor(KafkaCluster cluster) {
        return (ClusterSerdes)this.clusterSerdes.get(cluster.getName());
    }

    private Serde.Serializer getSerializer(KafkaCluster cluster, String topic, Serde.Target type, String serdeName) {
        ClusterSerdes serdes = this.getSerdesFor(cluster);
        SerdeInstance serde = (SerdeInstance)serdes.serdeForName(serdeName).orElseThrow(() -> new ValidationException(String.format("Serde %s not found", serdeName)));
        if (!serde.canSerialize(topic, type)) {
            throw new ValidationException(String.format("Serde %s can't be applied for '%s' topic's %s serialization", serde, topic, type));
        }
        return serde.serializer(topic, type);
    }

    private SerdeInstance getSerdeForDeserialize(KafkaCluster cluster, String topic, Serde.Target type, @Nullable String serdeName) {
        ClusterSerdes serdes = this.getSerdesFor(cluster);
        if (serdeName != null) {
            SerdeInstance serde = (SerdeInstance)serdes.serdeForName(serdeName).orElseThrow(() -> new ValidationException(String.format("Serde '%s' not found", serdeName)));
            if (!serde.canDeserialize(topic, type)) {
                throw new ValidationException(String.format("Serde '%s' can't be applied to '%s' topic %s", serdeName, topic, type));
            }
            return serde;
        }
        return serdes.suggestSerdeForDeserialize(topic, type);
    }

    public ProducerRecordCreator producerRecordCreator(KafkaCluster cluster, String topic, String keySerdeName, String valueSerdeName) {
        return new ProducerRecordCreator(this.getSerializer(cluster, topic, Serde.Target.KEY, keySerdeName), this.getSerializer(cluster, topic, Serde.Target.VALUE, valueSerdeName));
    }

    public ConsumerRecordDeserializer deserializerFor(KafkaCluster cluster, String topic, @Nullable String keySerdeName, @Nullable String valueSerdeName) {
        SerdeInstance keySerde = this.getSerdeForDeserialize(cluster, topic, Serde.Target.KEY, keySerdeName);
        SerdeInstance valueSerde = this.getSerdeForDeserialize(cluster, topic, Serde.Target.VALUE, valueSerdeName);
        SerdeInstance fallbackSerde = this.getSerdesFor(cluster).getFallbackSerde();
        return new ConsumerRecordDeserializer(keySerde.getName(), keySerde.deserializer(topic, Serde.Target.KEY), valueSerde.getName(), valueSerde.deserializer(topic, Serde.Target.VALUE), fallbackSerde.getName(), fallbackSerde.deserializer(topic, Serde.Target.KEY), fallbackSerde.deserializer(topic, Serde.Target.VALUE), cluster.getMasking().getMaskerForTopic(topic));
    }

    public List<SerdeDescriptionDTO> getSerdesForSerialize(KafkaCluster cluster, String topic, Serde.Target serdeType) {
        ClusterSerdes serdes = this.getSerdesFor(cluster);
        SerdeInstance preferred = serdes.suggestSerdeForSerialize(topic, serdeType);
        ArrayList<SerdeDescriptionDTO> result = new ArrayList<SerdeDescriptionDTO>();
        result.add(this.toDto(preferred, topic, serdeType, true));
        serdes.all().filter(s -> !s.getName().equals(preferred.getName())).filter(s -> s.canSerialize(topic, serdeType)).forEach(s -> result.add(this.toDto(s, topic, serdeType, false)));
        return result;
    }

    public List<SerdeDescriptionDTO> getSerdesForDeserialize(KafkaCluster cluster, String topic, Serde.Target serdeType) {
        ClusterSerdes serdes = this.getSerdesFor(cluster);
        SerdeInstance preferred = serdes.suggestSerdeForDeserialize(topic, serdeType);
        ArrayList<SerdeDescriptionDTO> result = new ArrayList<SerdeDescriptionDTO>();
        result.add(this.toDto(preferred, topic, serdeType, true));
        serdes.all().filter(s -> !s.getName().equals(preferred.getName())).filter(s -> s.canDeserialize(topic, serdeType)).forEach(s -> result.add(this.toDto(s, topic, serdeType, false)));
        return result;
    }

    private SerdeDescriptionDTO toDto(SerdeInstance serdeInstance, String topic, Serde.Target serdeType, boolean preferred) {
        Optional schemaOpt = serdeInstance.getSchema(topic, serdeType);
        return new SerdeDescriptionDTO().name(serdeInstance.getName()).description((String)serdeInstance.description().orElse(null)).schema((String)schemaOpt.map(SchemaDescription::getSchema).orElse(null)).additionalProperties((Map)schemaOpt.map(SchemaDescription::getAdditionalProperties).orElse(null)).preferred(Boolean.valueOf(preferred));
    }

    @Override
    public void close() {
        this.clusterSerdes.values().forEach(ClusterSerdes::close);
    }
}

