/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service;

import com.google.common.collect.ImmutableMap;
import com.provectus.kafka.ui.config.ClustersProperties;
import com.provectus.kafka.ui.model.KafkaCluster;
import com.provectus.kafka.ui.service.KafkaClusterFactory;
import java.util.Collection;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class ClustersStorage {
    private final ImmutableMap<String, KafkaCluster> kafkaClusters;

    public ClustersStorage(ClustersProperties properties, KafkaClusterFactory factory) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        properties.getClusters().forEach(c -> builder.put((Object)c.getName(), (Object)factory.create(properties, c)));
        this.kafkaClusters = builder.build();
    }

    public Collection<KafkaCluster> getKafkaClusters() {
        return this.kafkaClusters.values();
    }

    public Optional<KafkaCluster> getClusterByName(String clusterName) {
        return Optional.ofNullable((KafkaCluster)this.kafkaClusters.get((Object)clusterName));
    }
}

