/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.serdes.builtin;

import com.provectus.kafka.ui.exception.ValidationException;
import com.provectus.kafka.ui.serde.api.DeserializeResult;
import com.provectus.kafka.ui.serde.api.PropertyResolver;
import com.provectus.kafka.ui.serde.api.SchemaDescription;
import com.provectus.kafka.ui.serde.api.Serde;
import com.provectus.kafka.ui.serdes.BuiltInSerde;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class UuidBinarySerde
implements BuiltInSerde {
    private boolean mostSignificantBitsFirst = true;

    public static String name() {
        return "UUIDBinary";
    }

    public void configure(PropertyResolver serdeProperties, PropertyResolver kafkaClusterProperties, PropertyResolver globalProperties) {
        serdeProperties.getProperty("mostSignificantBitsFirst", Boolean.class).ifPresent(msb -> {
            this.mostSignificantBitsFirst = msb;
        });
    }

    public Optional<String> getDescription() {
        return Optional.empty();
    }

    public Optional<SchemaDescription> getSchema(String topic, Serde.Target type) {
        return Optional.empty();
    }

    public boolean canDeserialize(String topic, Serde.Target type) {
        return true;
    }

    public boolean canSerialize(String topic, Serde.Target type) {
        return true;
    }

    public Serde.Serializer serializer(String topic, Serde.Target type) {
        return input -> {
            UUID uuid = UUID.fromString(input);
            ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
            if (this.mostSignificantBitsFirst) {
                bb.putLong(uuid.getMostSignificantBits());
                bb.putLong(uuid.getLeastSignificantBits());
            } else {
                bb.putLong(uuid.getLeastSignificantBits());
                bb.putLong(uuid.getMostSignificantBits());
            }
            return bb.array();
        };
    }

    public Serde.Deserializer deserializer(String topic, Serde.Target type) {
        return (headers, data) -> {
            if (data.length != 16) {
                throw new ValidationException("UUID data should be 16 bytes, but it is " + data.length);
            }
            ByteBuffer bb = ByteBuffer.wrap(data);
            long msb = bb.getLong();
            long lsb = bb.getLong();
            UUID uuid = this.mostSignificantBitsFirst ? new UUID(msb, lsb) : new UUID(lsb, msb);
            return new DeserializeResult(uuid.toString(), DeserializeResult.Type.STRING, Map.of());
        };
    }
}

