/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.serdes.builtin;

import com.provectus.kafka.ui.serde.api.DeserializeResult;
import com.provectus.kafka.ui.serde.api.PropertyResolver;
import com.provectus.kafka.ui.serde.api.SchemaDescription;
import com.provectus.kafka.ui.serde.api.Serde;
import com.provectus.kafka.ui.serdes.BuiltInSerde;
import java.util.HexFormat;
import java.util.Map;
import java.util.Optional;

/*
 * Exception performing whole class analysis ignored.
 */
public class HexSerde
implements BuiltInSerde {
    private HexFormat deserializeHexFormat;

    public static String name() {
        return "Hex";
    }

    public void autoConfigure(PropertyResolver kafkaClusterProperties, PropertyResolver globalProperties) {
        this.configure(" ", true);
    }

    public void configure(PropertyResolver serdeProperties, PropertyResolver kafkaClusterProperties, PropertyResolver globalProperties) {
        String delim = serdeProperties.getProperty("delimiter", String.class).orElse(" ");
        boolean uppercase = serdeProperties.getProperty("uppercase", Boolean.class).orElse(true);
        this.configure(delim, uppercase);
    }

    private void configure(String delim, boolean uppercase) {
        this.deserializeHexFormat = HexFormat.ofDelimiter(delim);
        if (uppercase) {
            this.deserializeHexFormat = this.deserializeHexFormat.withUpperCase();
        }
    }

    public Optional<String> getDescription() {
        return Optional.empty();
    }

    public Optional<SchemaDescription> getSchema(String topic, Serde.Target type) {
        return Optional.empty();
    }

    public boolean canDeserialize(String topic, Serde.Target type) {
        return true;
    }

    public boolean canSerialize(String topic, Serde.Target type) {
        return true;
    }

    public Serde.Serializer serializer(String topic, Serde.Target type) {
        return input -> {
            if ((input = input.trim()).length() == 0) {
                return new byte[0];
            }
            return HexFormat.of().parseHex(HexSerde.prepareInputForParse((String)input));
        };
    }

    private static String prepareInputForParse(String input) {
        return input.replaceAll(" ", "").replaceAll("#", "").replaceAll(":", "");
    }

    public Serde.Deserializer deserializer(String topic, Serde.Target type) {
        return (headers, data) -> new DeserializeResult(this.deserializeHexFormat.formatHex(data), DeserializeResult.Type.STRING, Map.of());
    }
}

