/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.serdes.builtin;

import com.provectus.kafka.ui.serde.api.DeserializeResult;
import com.provectus.kafka.ui.serde.api.SchemaDescription;
import com.provectus.kafka.ui.serde.api.Serde;
import com.provectus.kafka.ui.serdes.BuiltInSerde;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;

public class Base64Serde
implements BuiltInSerde {
    public static String name() {
        return "Base64";
    }

    public Optional<String> getDescription() {
        return Optional.empty();
    }

    public Optional<SchemaDescription> getSchema(String topic, Serde.Target type) {
        return Optional.empty();
    }

    public boolean canDeserialize(String topic, Serde.Target type) {
        return true;
    }

    public boolean canSerialize(String topic, Serde.Target type) {
        return true;
    }

    public Serde.Serializer serializer(String topic, Serde.Target type) {
        Base64.Decoder decoder = Base64.getDecoder();
        return inputString -> {
            if ((inputString = inputString.trim()).length() == 0) {
                return new byte[0];
            }
            return decoder.decode(inputString);
        };
    }

    public Serde.Deserializer deserializer(String topic, Serde.Target type) {
        Base64.Encoder encoder = Base64.getEncoder();
        return (headers, data) -> new DeserializeResult(encoder.encodeToString(data), DeserializeResult.Type.STRING, Map.of());
    }
}

