/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.serdes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.provectus.kafka.ui.config.ClustersProperties;
import com.provectus.kafka.ui.exception.ValidationException;
import com.provectus.kafka.ui.serde.api.PropertyResolver;
import com.provectus.kafka.ui.serde.api.Serde;
import com.provectus.kafka.ui.serdes.BuiltInSerde;
import com.provectus.kafka.ui.serdes.ClusterSerdes;
import com.provectus.kafka.ui.serdes.CustomSerdeLoader;
import com.provectus.kafka.ui.serdes.PropertyResolverImpl;
import com.provectus.kafka.ui.serdes.SerdeInstance;
import com.provectus.kafka.ui.serdes.builtin.AvroEmbeddedSerde;
import com.provectus.kafka.ui.serdes.builtin.Base64Serde;
import com.provectus.kafka.ui.serdes.builtin.ConsumerOffsetsSerde;
import com.provectus.kafka.ui.serdes.builtin.HexSerde;
import com.provectus.kafka.ui.serdes.builtin.Int32Serde;
import com.provectus.kafka.ui.serdes.builtin.Int64Serde;
import com.provectus.kafka.ui.serdes.builtin.ProtobufFileSerde;
import com.provectus.kafka.ui.serdes.builtin.ProtobufRawSerde;
import com.provectus.kafka.ui.serdes.builtin.StringSerde;
import com.provectus.kafka.ui.serdes.builtin.UInt32Serde;
import com.provectus.kafka.ui.serdes.builtin.UInt64Serde;
import com.provectus.kafka.ui.serdes.builtin.UuidBinarySerde;
import com.provectus.kafka.ui.serdes.builtin.sr.SchemaRegistrySerde;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class SerdesInitializer {
    private static final Logger log = LoggerFactory.getLogger(SerdesInitializer.class);
    private final Map<String, Class<? extends BuiltInSerde>> builtInSerdeClasses;
    private final CustomSerdeLoader customSerdeLoader;

    public SerdesInitializer() {
        this((Map)ImmutableMap.builder().put((Object)StringSerde.name(), StringSerde.class).put((Object)SchemaRegistrySerde.name(), SchemaRegistrySerde.class).put((Object)ProtobufFileSerde.name(), ProtobufFileSerde.class).put((Object)Int32Serde.name(), Int32Serde.class).put((Object)Int64Serde.name(), Int64Serde.class).put((Object)UInt32Serde.name(), UInt32Serde.class).put((Object)UInt64Serde.name(), UInt64Serde.class).put((Object)AvroEmbeddedSerde.name(), AvroEmbeddedSerde.class).put((Object)Base64Serde.name(), Base64Serde.class).put((Object)HexSerde.name(), HexSerde.class).put((Object)UuidBinarySerde.name(), UuidBinarySerde.class).put((Object)ProtobufRawSerde.name(), ProtobufRawSerde.class).build(), new CustomSerdeLoader());
    }

    @VisibleForTesting
    SerdesInitializer(Map<String, Class<? extends BuiltInSerde>> builtInSerdeClasses, CustomSerdeLoader customSerdeLoader) {
        this.builtInSerdeClasses = builtInSerdeClasses;
        this.customSerdeLoader = customSerdeLoader;
    }

    public ClusterSerdes init(Environment env, ClustersProperties clustersProperties, int clusterIndex) {
        ClustersProperties.Cluster clusterProperties = (ClustersProperties.Cluster)clustersProperties.getClusters().get(clusterIndex);
        log.debug("Configuring serdes for cluster {}", (Object)clusterProperties.getName());
        PropertyResolverImpl globalPropertiesResolver = new PropertyResolverImpl(env);
        PropertyResolverImpl clusterPropertiesResolver = new PropertyResolverImpl(env, "kafka.clusters." + clusterIndex);
        LinkedHashMap<String, SerdeInstance> registeredSerdes = new LinkedHashMap<String, SerdeInstance>();
        if (clusterProperties.getSerde() != null) {
            for (int i = 0; i < clusterProperties.getSerde().size(); ++i) {
                ClustersProperties.SerdeConfig serdeConfig = (ClustersProperties.SerdeConfig)clusterProperties.getSerde().get(i);
                if (Strings.isNullOrEmpty((String)serdeConfig.getName())) {
                    throw new ValidationException("'name' property not set for serde: " + serdeConfig);
                }
                if (registeredSerdes.containsKey(serdeConfig.getName())) {
                    throw new ValidationException("Multiple serdes with same name: " + serdeConfig.getName());
                }
                SerdeInstance instance = this.createSerdeFromConfig(serdeConfig, (PropertyResolver)new PropertyResolverImpl(env, "kafka.clusters." + clusterIndex + ".serde." + i + ".properties"), (PropertyResolver)clusterPropertiesResolver, (PropertyResolver)globalPropertiesResolver);
                registeredSerdes.put(serdeConfig.getName(), instance);
            }
        }
        this.builtInSerdeClasses.forEach((name, clazz) -> {
            BuiltInSerde serde;
            if (!registeredSerdes.containsKey(name) && this.autoConfigureSerde(serde = (BuiltInSerde)this.createSerdeInstance(clazz), (PropertyResolver)clusterPropertiesResolver, (PropertyResolver)globalPropertiesResolver)) {
                registeredSerdes.put((String)name, new SerdeInstance(name, (Serde)serde, null, null, null));
            }
        });
        this.registerTopicRelatedSerde(registeredSerdes);
        return new ClusterSerdes(registeredSerdes, (SerdeInstance)Optional.ofNullable(clusterProperties.getDefaultKeySerde()).map(name -> (SerdeInstance)Preconditions.checkNotNull((Object)((SerdeInstance)registeredSerdes.get(name)), (Object)"Default key serde not found")).orElse(null), (SerdeInstance)Optional.ofNullable(clusterProperties.getDefaultValueSerde()).map(name -> (SerdeInstance)Preconditions.checkNotNull((Object)((SerdeInstance)registeredSerdes.get(name)), (Object)"Default value serde not found")).or(() -> Optional.ofNullable((SerdeInstance)registeredSerdes.get(SchemaRegistrySerde.name()))).or(() -> Optional.ofNullable((SerdeInstance)registeredSerdes.get(ProtobufFileSerde.name()))).orElse(null), this.createFallbackSerde());
    }

    private void registerTopicRelatedSerde(Map<String, SerdeInstance> serdes) {
        this.registerConsumerOffsetsSerde(serdes);
    }

    private void registerConsumerOffsetsSerde(Map<String, SerdeInstance> serdes) {
        Pattern pattern = Pattern.compile("__consumer_offsets");
        serdes.put(ConsumerOffsetsSerde.name(), new SerdeInstance(ConsumerOffsetsSerde.name(), (Serde)new ConsumerOffsetsSerde(), pattern, pattern, null));
    }

    private SerdeInstance createFallbackSerde() {
        StringSerde serde = new StringSerde();
        serde.configure((PropertyResolver)PropertyResolverImpl.empty(), (PropertyResolver)PropertyResolverImpl.empty(), (PropertyResolver)PropertyResolverImpl.empty());
        return new SerdeInstance("Fallback", (Serde)serde, null, null, null);
    }

    private SerdeInstance createSerdeFromConfig(ClustersProperties.SerdeConfig serdeConfig, PropertyResolver serdeProps, PropertyResolver clusterProps, PropertyResolver globalProps) {
        Optional<Class> builtInSerdeClass;
        if (this.builtInSerdeClasses.containsKey(serdeConfig.getName())) {
            return this.createSerdeWithBuiltInSerdeName(serdeConfig, serdeProps, clusterProps, globalProps);
        }
        if (serdeConfig.getClassName() != null && (builtInSerdeClass = this.builtInSerdeClasses.values().stream().filter(c -> c.getName().equals(serdeConfig.getClassName())).findAny()).isPresent()) {
            return this.createSerdeWithBuiltInClass(builtInSerdeClass.get(), serdeConfig, serdeProps, clusterProps, globalProps);
        }
        log.info("Loading custom serde {}", (Object)serdeConfig.getName());
        return this.loadAndInitCustomSerde(serdeConfig, serdeProps, clusterProps, globalProps);
    }

    private SerdeInstance createSerdeWithBuiltInSerdeName(ClustersProperties.SerdeConfig serdeConfig, PropertyResolver serdeProps, PropertyResolver clusterProps, PropertyResolver globalProps) {
        String name = serdeConfig.getName();
        if (serdeConfig.getClassName() != null) {
            throw new ValidationException("className can't be set for built-in serde");
        }
        if (serdeConfig.getFilePath() != null) {
            throw new ValidationException("filePath can't be set for built-in serde types");
        }
        Class clazz = (Class)this.builtInSerdeClasses.get(name);
        BuiltInSerde serde = (BuiltInSerde)this.createSerdeInstance(clazz);
        if (serdeConfig.getProperties() == null || serdeConfig.getProperties().isEmpty()) {
            if (!this.autoConfigureSerde(serde, clusterProps, globalProps)) {
                throw new ValidationException(name + " serde is not configured");
            }
        } else {
            serde.configure(serdeProps, clusterProps, globalProps);
        }
        return new SerdeInstance(name, (Serde)serde, this.nullablePattern(serdeConfig.getTopicKeysPattern()), this.nullablePattern(serdeConfig.getTopicValuesPattern()), null);
    }

    private boolean autoConfigureSerde(BuiltInSerde serde, PropertyResolver clusterProps, PropertyResolver globalProps) {
        if (serde.canBeAutoConfigured(clusterProps, globalProps)) {
            serde.autoConfigure(clusterProps, globalProps);
            return true;
        }
        return false;
    }

    private SerdeInstance createSerdeWithBuiltInClass(Class<? extends BuiltInSerde> clazz, ClustersProperties.SerdeConfig serdeConfig, PropertyResolver serdeProps, PropertyResolver clusterProps, PropertyResolver globalProps) {
        if (serdeConfig.getFilePath() != null) {
            throw new ValidationException("filePath can't be set for built-in serde type");
        }
        BuiltInSerde serde = (BuiltInSerde)this.createSerdeInstance(clazz);
        serde.configure(serdeProps, clusterProps, globalProps);
        return new SerdeInstance(serdeConfig.getName(), (Serde)serde, this.nullablePattern(serdeConfig.getTopicKeysPattern()), this.nullablePattern(serdeConfig.getTopicValuesPattern()), null);
    }

    private <T extends Serde> T createSerdeInstance(Class<T> clazz) {
        return (T)((Serde)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
    }

    private SerdeInstance loadAndInitCustomSerde(ClustersProperties.SerdeConfig serdeConfig, PropertyResolver serdeProps, PropertyResolver clusterProps, PropertyResolver globalProps) {
        if (Strings.isNullOrEmpty((String)serdeConfig.getClassName())) {
            throw new ValidationException("'className' property not set for custom serde " + serdeConfig.getName());
        }
        if (Strings.isNullOrEmpty((String)serdeConfig.getFilePath())) {
            throw new ValidationException("'filePath' property not set for custom serde " + serdeConfig.getName());
        }
        CustomSerdeLoader.CustomSerde loaded = this.customSerdeLoader.loadAndConfigure(serdeConfig.getClassName(), serdeConfig.getFilePath(), serdeProps, clusterProps, globalProps);
        return new SerdeInstance(serdeConfig.getName(), loaded.getSerde(), this.nullablePattern(serdeConfig.getTopicKeysPattern()), this.nullablePattern(serdeConfig.getTopicValuesPattern()), loaded.getClassLoader());
    }

    @Nullable
    private Pattern nullablePattern(@Nullable String pattern) {
        return pattern == null ? null : Pattern.compile(pattern);
    }
}

