/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.serdes;

import com.provectus.kafka.ui.serde.api.DeserializeResult;
import com.provectus.kafka.ui.serde.api.SchemaDescription;
import com.provectus.kafka.ui.serde.api.Serde;
import com.provectus.kafka.ui.serdes.ClassloaderUtil;
import java.io.Closeable;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerdeInstance
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(SerdeInstance.class);
    final String name;
    final Serde serde;
    @Nullable
    final Pattern topicKeyPattern;
    @Nullable
    final Pattern topicValuePattern;
    @Nullable
    final ClassLoader classLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T wrapWithClassloader(Supplier<T> call) {
        if (this.classLoader == null) {
            return call.get();
        }
        ClassLoader origCl = ClassloaderUtil.compareAndSwapLoaders((ClassLoader)this.classLoader);
        try {
            T t = call.get();
            return t;
        }
        finally {
            ClassloaderUtil.compareAndSwapLoaders((ClassLoader)origCl);
        }
    }

    public Optional<SchemaDescription> getSchema(String topic, Serde.Target type) {
        try {
            return (Optional)this.wrapWithClassloader(() -> this.serde.getSchema(topic, type));
        }
        catch (Exception e) {
            log.warn("Error getting schema for '{}'({}) with serde '{}'", new Object[]{topic, type, this.name, e});
            return Optional.empty();
        }
    }

    public Optional<String> description() {
        try {
            return (Optional)this.wrapWithClassloader(() -> ((Serde)this.serde).getDescription());
        }
        catch (Exception e) {
            log.warn("Error getting description serde '{}'", (Object)this.name, (Object)e);
            return Optional.empty();
        }
    }

    public boolean canSerialize(String topic, Serde.Target type) {
        try {
            return (Boolean)this.wrapWithClassloader(() -> this.serde.canSerialize(topic, type));
        }
        catch (Exception e) {
            log.warn("Error calling canSerialize for '{}'({}) with serde '{}'", new Object[]{topic, type, this.name, e});
            return false;
        }
    }

    public boolean canDeserialize(String topic, Serde.Target type) {
        try {
            return (Boolean)this.wrapWithClassloader(() -> this.serde.canDeserialize(topic, type));
        }
        catch (Exception e) {
            log.warn("Error calling canDeserialize for '{}'({}) with serde '{}'", new Object[]{topic, type, this.name, e});
            return false;
        }
    }

    public Serde.Serializer serializer(String topic, Serde.Target type) {
        return (Serde.Serializer)this.wrapWithClassloader(() -> {
            Serde.Serializer serializer = this.serde.serializer(topic, type);
            return input -> (byte[])this.wrapWithClassloader(() -> serializer.serialize(input));
        });
    }

    public Serde.Deserializer deserializer(String topic, Serde.Target type) {
        return (Serde.Deserializer)this.wrapWithClassloader(() -> {
            Serde.Deserializer deserializer = this.serde.deserializer(topic, type);
            return (headers, data) -> (DeserializeResult)this.wrapWithClassloader(() -> deserializer.deserialize(headers, data));
        });
    }

    @Override
    public void close() {
        this.wrapWithClassloader(() -> {
            try {
                this.serde.close();
            }
            catch (Exception e) {
                log.error("Error closing serde " + this.name, (Throwable)e);
            }
            return null;
        });
    }

    public SerdeInstance(String name, Serde serde, @Nullable Pattern topicKeyPattern, @Nullable Pattern topicValuePattern, @Nullable ClassLoader classLoader) {
        this.name = name;
        this.serde = serde;
        this.topicKeyPattern = topicKeyPattern;
        this.topicValuePattern = topicValuePattern;
        this.classLoader = classLoader;
    }

    public String getName() {
        return this.name;
    }
}

