/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.serdes;

import com.google.common.base.Preconditions;
import com.provectus.kafka.ui.serde.api.PropertyResolver;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;

public class PropertyResolverImpl
implements PropertyResolver {
    private final Binder binder;
    @Nullable
    private final String prefix;

    public static PropertyResolverImpl empty() {
        return new PropertyResolverImpl((Environment)new StandardEnvironment(), null);
    }

    public PropertyResolverImpl(Environment env) {
        this(env, null);
    }

    public PropertyResolverImpl(Environment env, @Nullable String prefix) {
        this.binder = Binder.get((Environment)env);
        this.prefix = prefix;
    }

    private ConfigurationPropertyName targetPropertyName(String key) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkState((!key.isBlank() ? 1 : 0) != 0);
        String propertyName = this.prefix == null ? key : this.prefix + "." + key;
        return ConfigurationPropertyName.adapt((CharSequence)propertyName, (char)'.');
    }

    public <T> Optional<T> getProperty(String key, Class<T> targetType) {
        ConfigurationPropertyName targetKey = this.targetPropertyName(key);
        BindResult result = this.binder.bind(targetKey, Bindable.of(targetType));
        return result.isBound() ? Optional.of(result.get()) : Optional.empty();
    }

    public <T> Optional<List<T>> getListProperty(String key, Class<T> itemType) {
        ConfigurationPropertyName targetKey = this.targetPropertyName(key);
        BindResult listResult = this.binder.bind(targetKey, Bindable.listOf(itemType));
        return listResult.isBound() ? Optional.of((List)listResult.get()) : Optional.empty();
    }

    public <K, V> Optional<Map<K, V>> getMapProperty(String key, Class<K> keyType, Class<V> valueType) {
        ConfigurationPropertyName targetKey = this.targetPropertyName(key);
        BindResult mapResult = this.binder.bind(targetKey, Bindable.mapOf(keyType, valueType));
        return mapResult.isBound() ? Optional.of((Map)mapResult.get()) : Optional.empty();
    }
}

