/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.serdes;

import com.provectus.kafka.ui.serde.api.Serde;
import com.provectus.kafka.ui.serdes.SerdeInstance;
import com.provectus.kafka.ui.serdes.builtin.StringSerde;
import java.io.Closeable;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterSerdes
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ClusterSerdes.class);
    final Map<String, SerdeInstance> serdes;
    @Nullable
    final SerdeInstance defaultKeySerde;
    @Nullable
    final SerdeInstance defaultValueSerde;
    final SerdeInstance fallbackSerde;

    private Optional<SerdeInstance> findSerdeByPatternsOrDefault(String topic, Serde.Target type, Predicate<SerdeInstance> additionalCheck) {
        for (SerdeInstance serdeInstance : this.serdes.values()) {
            Pattern pattern = type == Serde.Target.KEY ? serdeInstance.topicKeyPattern : serdeInstance.topicValuePattern;
            if (pattern == null || !pattern.matcher(topic).matches() || !additionalCheck.test(serdeInstance)) continue;
            return Optional.of(serdeInstance);
        }
        if (type == Serde.Target.KEY && this.defaultKeySerde != null && additionalCheck.test(this.defaultKeySerde)) {
            return Optional.of(this.defaultKeySerde);
        }
        if (type == Serde.Target.VALUE && this.defaultValueSerde != null && additionalCheck.test(this.defaultValueSerde)) {
            return Optional.of(this.defaultValueSerde);
        }
        return Optional.empty();
    }

    public Optional<SerdeInstance> serdeForName(String name) {
        return Optional.ofNullable((SerdeInstance)this.serdes.get(name));
    }

    public Stream<SerdeInstance> all() {
        return this.serdes.values().stream();
    }

    public SerdeInstance suggestSerdeForSerialize(String topic, Serde.Target type) {
        return this.findSerdeByPatternsOrDefault(topic, type, s -> s.canSerialize(topic, type)).orElse((SerdeInstance)this.serdes.get(StringSerde.name()));
    }

    public SerdeInstance suggestSerdeForDeserialize(String topic, Serde.Target type) {
        return this.findSerdeByPatternsOrDefault(topic, type, s -> s.canDeserialize(topic, type)).orElse((SerdeInstance)this.serdes.get(StringSerde.name()));
    }

    @Override
    public void close() {
        this.serdes.values().forEach(SerdeInstance::close);
    }

    public ClusterSerdes(Map<String, SerdeInstance> serdes, @Nullable SerdeInstance defaultKeySerde, @Nullable SerdeInstance defaultValueSerde, SerdeInstance fallbackSerde) {
        this.serdes = serdes;
        this.defaultKeySerde = defaultKeySerde;
        this.defaultValueSerde = defaultValueSerde;
        this.fallbackSerde = fallbackSerde;
    }

    public SerdeInstance getFallbackSerde() {
        return this.fallbackSerde;
    }
}

