/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.model.rbac;

import com.provectus.kafka.ui.model.rbac.Permission;
import com.provectus.kafka.ui.model.rbac.Resource;
import com.provectus.kafka.ui.model.rbac.permission.AclAction;
import com.provectus.kafka.ui.model.rbac.permission.ApplicationConfigAction;
import com.provectus.kafka.ui.model.rbac.permission.AuditAction;
import com.provectus.kafka.ui.model.rbac.permission.ClusterConfigAction;
import com.provectus.kafka.ui.model.rbac.permission.ConnectAction;
import com.provectus.kafka.ui.model.rbac.permission.ConsumerGroupAction;
import com.provectus.kafka.ui.model.rbac.permission.KsqlAction;
import com.provectus.kafka.ui.model.rbac.permission.SchemaAction;
import com.provectus.kafka.ui.model.rbac.permission.TopicAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.util.Assert;

public class Permission {
    private static final List<Resource> RBAC_ACTION_EXEMPT_LIST = List.of(Resource.KSQL, Resource.CLUSTERCONFIG, Resource.APPLICATIONCONFIG, Resource.ACL, Resource.AUDIT);
    Resource resource;
    List<String> actions;
    @Nullable
    String value;
    @Nullable
    transient Pattern compiledValuePattern;

    public void setResource(String resource) {
        this.resource = Resource.fromString((String)resource.toUpperCase());
    }

    public void setValue(@Nullable String value) {
        this.value = value;
    }

    public void setActions(List<String> actions) {
        this.actions = actions;
    }

    public void validate() {
        Assert.notNull((Object)this.resource, (String)"resource cannot be null");
        if (!RBAC_ACTION_EXEMPT_LIST.contains(this.resource)) {
            Assert.notNull((Object)this.value, (String)("permission value can't be empty for resource " + this.resource));
        }
    }

    public void transform() {
        if (this.value != null) {
            this.compiledValuePattern = Pattern.compile(this.value);
        }
        if (CollectionUtils.isNotEmpty((Collection)this.actions) && this.actions.stream().anyMatch("ALL"::equalsIgnoreCase)) {
            this.actions = this.getAllActionValues();
        }
    }

    private List<String> getAllActionValues() {
        if (this.resource == null) {
            return Collections.emptyList();
        }
        return switch (1.$SwitchMap$com$provectus$kafka$ui$model$rbac$Resource[this.resource.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> Arrays.stream(ApplicationConfigAction.values()).map(Enum::toString).toList();
            case 2 -> Arrays.stream(ClusterConfigAction.values()).map(Enum::toString).toList();
            case 3 -> Arrays.stream(TopicAction.values()).map(Enum::toString).toList();
            case 4 -> Arrays.stream(ConsumerGroupAction.values()).map(Enum::toString).toList();
            case 5 -> Arrays.stream(SchemaAction.values()).map(Enum::toString).toList();
            case 6 -> Arrays.stream(ConnectAction.values()).map(Enum::toString).toList();
            case 7 -> Arrays.stream(KsqlAction.values()).map(Enum::toString).toList();
            case 8 -> Arrays.stream(AclAction.values()).map(Enum::toString).toList();
            case 9 -> Arrays.stream(AuditAction.values()).map(Enum::toString).toList();
        };
    }

    public Resource getResource() {
        return this.resource;
    }

    public List<String> getActions() {
        return this.actions;
    }

    @Nullable
    public String getValue() {
        return this.value;
    }

    @Nullable
    public Pattern getCompiledValuePattern() {
        return this.compiledValuePattern;
    }

    public String toString() {
        return "Permission(resource=" + this.getResource() + ", actions=" + this.getActions() + ", value=" + this.getValue() + ", compiledValuePattern=" + this.getCompiledValuePattern() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Permission)) {
            return false;
        }
        Permission other = (Permission)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Resource this$resource = this.getResource();
        Resource other$resource = other.getResource();
        if (this$resource == null ? other$resource != null : !this$resource.equals(other$resource)) {
            return false;
        }
        List this$actions = this.getActions();
        List other$actions = other.getActions();
        if (this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Permission;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Resource $resource = this.getResource();
        result = result * 59 + ($resource == null ? 43 : $resource.hashCode());
        List $actions = this.getActions();
        result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

