/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.model;

import com.provectus.kafka.ui.config.ClustersProperties;
import com.provectus.kafka.ui.model.CleanupPolicy;
import com.provectus.kafka.ui.model.InternalLogDirStats;
import com.provectus.kafka.ui.model.InternalPartition;
import com.provectus.kafka.ui.model.InternalPartitionsOffsets;
import com.provectus.kafka.ui.model.InternalReplica;
import com.provectus.kafka.ui.model.InternalTopic;
import com.provectus.kafka.ui.model.InternalTopicConfig;
import com.provectus.kafka.ui.model.Metrics;
import com.provectus.kafka.ui.model.PartitionsStats;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;

/*
 * Exception performing whole class analysis ignored.
 */
public class InternalTopic {
    ClustersProperties clustersProperties;
    private final String name;
    private final boolean internal;
    private final int replicas;
    private final int partitionCount;
    private final int inSyncReplicas;
    private final int replicationFactor;
    private final int underReplicatedPartitions;
    private final Map<Integer, InternalPartition> partitions;
    private final List<InternalTopicConfig> topicConfigs;
    private final CleanupPolicy cleanUpPolicy;
    private final BigDecimal bytesInPerSec;
    private final BigDecimal bytesOutPerSec;
    private final long segmentSize;
    private final long segmentCount;

    public static InternalTopic from(TopicDescription topicDescription, List<ConfigEntry> configs, InternalPartitionsOffsets partitionsOffsets, Metrics metrics, InternalLogDirStats logDirInfo, @Nullable String internalTopicPrefix) {
        InternalTopicBuilder topic = InternalTopic.builder();
        internalTopicPrefix = internalTopicPrefix == null || internalTopicPrefix.isEmpty() ? "_" : internalTopicPrefix;
        topic.internal(topicDescription.isInternal() || topicDescription.name().startsWith(internalTopicPrefix));
        topic.name(topicDescription.name());
        List<InternalPartition> partitions = topicDescription.partitions().stream().map(partition -> {
            InternalPartition.InternalPartitionBuilder partitionDto = InternalPartition.builder();
            partitionDto.leader(partition.leader() != null ? Integer.valueOf(partition.leader().id()) : null);
            partitionDto.partition(partition.partition());
            partitionDto.inSyncReplicasCount(partition.isr().size());
            partitionDto.replicasCount(partition.replicas().size());
            List replicas = partition.replicas().stream().map(r -> InternalReplica.builder().broker(r.id()).inSync(partition.isr().contains(r)).leader(partition.leader() != null && partition.leader().id() == r.id()).build()).collect(Collectors.toList());
            partitionDto.replicas(replicas);
            partitionsOffsets.get(topicDescription.name(), partition.partition()).ifPresent(offsets -> {
                partitionDto.offsetMin(offsets.getEarliest());
                partitionDto.offsetMax(offsets.getLatest());
            });
            InternalLogDirStats.SegmentStats segmentStats = (InternalLogDirStats.SegmentStats)logDirInfo.getPartitionsStats().get(new TopicPartition(topicDescription.name(), partition.partition()));
            if (segmentStats != null) {
                partitionDto.segmentCount(Integer.valueOf(segmentStats.getSegmentsCount()));
                partitionDto.segmentSize(Long.valueOf(segmentStats.getSegmentSize()));
            }
            return partitionDto.build();
        }).toList();
        topic.partitions(partitions.stream().collect(Collectors.toMap(InternalPartition::getPartition, t -> t)));
        PartitionsStats partitionsStats = new PartitionsStats(topicDescription);
        topic.replicas(partitionsStats.getReplicasCount());
        topic.partitionCount(partitionsStats.getPartitionsCount());
        topic.inSyncReplicas(partitionsStats.getInSyncReplicasCount());
        topic.underReplicatedPartitions(partitionsStats.getUnderReplicatedPartitionCount());
        topic.replicationFactor(topicDescription.partitions().isEmpty() ? 0 : ((TopicPartitionInfo)topicDescription.partitions().get(0)).replicas().size());
        InternalLogDirStats.SegmentStats segmentStats = (InternalLogDirStats.SegmentStats)logDirInfo.getTopicStats().get(topicDescription.name());
        if (segmentStats != null) {
            topic.segmentCount((long)segmentStats.getSegmentsCount());
            topic.segmentSize(segmentStats.getSegmentSize());
        }
        topic.bytesInPerSec((BigDecimal)metrics.getTopicBytesInPerSec().get(topicDescription.name()));
        topic.bytesOutPerSec((BigDecimal)metrics.getTopicBytesOutPerSec().get(topicDescription.name()));
        topic.topicConfigs(configs.stream().map(InternalTopicConfig::from).collect(Collectors.toList()));
        topic.cleanUpPolicy(configs.stream().filter(config -> config.name().equals("cleanup.policy")).findFirst().map(ConfigEntry::value).map(CleanupPolicy::fromString).orElse(CleanupPolicy.UNKNOWN));
        return topic.build();
    }

    InternalTopic(ClustersProperties clustersProperties, String name, boolean internal, int replicas, int partitionCount, int inSyncReplicas, int replicationFactor, int underReplicatedPartitions, Map<Integer, InternalPartition> partitions, List<InternalTopicConfig> topicConfigs, CleanupPolicy cleanUpPolicy, BigDecimal bytesInPerSec, BigDecimal bytesOutPerSec, long segmentSize, long segmentCount) {
        this.clustersProperties = clustersProperties;
        this.name = name;
        this.internal = internal;
        this.replicas = replicas;
        this.partitionCount = partitionCount;
        this.inSyncReplicas = inSyncReplicas;
        this.replicationFactor = replicationFactor;
        this.underReplicatedPartitions = underReplicatedPartitions;
        this.partitions = partitions;
        this.topicConfigs = topicConfigs;
        this.cleanUpPolicy = cleanUpPolicy;
        this.bytesInPerSec = bytesInPerSec;
        this.bytesOutPerSec = bytesOutPerSec;
        this.segmentSize = segmentSize;
        this.segmentCount = segmentCount;
    }

    public static InternalTopicBuilder builder() {
        return new InternalTopicBuilder();
    }

    public InternalTopicBuilder toBuilder() {
        return new InternalTopicBuilder().clustersProperties(this.clustersProperties).name(this.name).internal(this.internal).replicas(this.replicas).partitionCount(this.partitionCount).inSyncReplicas(this.inSyncReplicas).replicationFactor(this.replicationFactor).underReplicatedPartitions(this.underReplicatedPartitions).partitions(this.partitions).topicConfigs(this.topicConfigs).cleanUpPolicy(this.cleanUpPolicy).bytesInPerSec(this.bytesInPerSec).bytesOutPerSec(this.bytesOutPerSec).segmentSize(this.segmentSize).segmentCount(this.segmentCount);
    }

    public ClustersProperties getClustersProperties() {
        return this.clustersProperties;
    }

    public String getName() {
        return this.name;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public int getReplicas() {
        return this.replicas;
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }

    public int getInSyncReplicas() {
        return this.inSyncReplicas;
    }

    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    public int getUnderReplicatedPartitions() {
        return this.underReplicatedPartitions;
    }

    public Map<Integer, InternalPartition> getPartitions() {
        return this.partitions;
    }

    public List<InternalTopicConfig> getTopicConfigs() {
        return this.topicConfigs;
    }

    public CleanupPolicy getCleanUpPolicy() {
        return this.cleanUpPolicy;
    }

    public BigDecimal getBytesInPerSec() {
        return this.bytesInPerSec;
    }

    public BigDecimal getBytesOutPerSec() {
        return this.bytesOutPerSec;
    }

    public long getSegmentSize() {
        return this.segmentSize;
    }

    public long getSegmentCount() {
        return this.segmentCount;
    }

    public void setClustersProperties(ClustersProperties clustersProperties) {
        this.clustersProperties = clustersProperties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InternalTopic)) {
            return false;
        }
        InternalTopic other = (InternalTopic)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isInternal() != other.isInternal()) {
            return false;
        }
        if (this.getReplicas() != other.getReplicas()) {
            return false;
        }
        if (this.getPartitionCount() != other.getPartitionCount()) {
            return false;
        }
        if (this.getInSyncReplicas() != other.getInSyncReplicas()) {
            return false;
        }
        if (this.getReplicationFactor() != other.getReplicationFactor()) {
            return false;
        }
        if (this.getUnderReplicatedPartitions() != other.getUnderReplicatedPartitions()) {
            return false;
        }
        if (this.getSegmentSize() != other.getSegmentSize()) {
            return false;
        }
        if (this.getSegmentCount() != other.getSegmentCount()) {
            return false;
        }
        ClustersProperties this$clustersProperties = this.getClustersProperties();
        ClustersProperties other$clustersProperties = other.getClustersProperties();
        if (this$clustersProperties == null ? other$clustersProperties != null : !this$clustersProperties.equals(other$clustersProperties)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map this$partitions = this.getPartitions();
        Map other$partitions = other.getPartitions();
        if (this$partitions == null ? other$partitions != null : !((Object)this$partitions).equals(other$partitions)) {
            return false;
        }
        List this$topicConfigs = this.getTopicConfigs();
        List other$topicConfigs = other.getTopicConfigs();
        if (this$topicConfigs == null ? other$topicConfigs != null : !((Object)this$topicConfigs).equals(other$topicConfigs)) {
            return false;
        }
        CleanupPolicy this$cleanUpPolicy = this.getCleanUpPolicy();
        CleanupPolicy other$cleanUpPolicy = other.getCleanUpPolicy();
        if (this$cleanUpPolicy == null ? other$cleanUpPolicy != null : !this$cleanUpPolicy.equals(other$cleanUpPolicy)) {
            return false;
        }
        BigDecimal this$bytesInPerSec = this.getBytesInPerSec();
        BigDecimal other$bytesInPerSec = other.getBytesInPerSec();
        if (this$bytesInPerSec == null ? other$bytesInPerSec != null : !((Object)this$bytesInPerSec).equals(other$bytesInPerSec)) {
            return false;
        }
        BigDecimal this$bytesOutPerSec = this.getBytesOutPerSec();
        BigDecimal other$bytesOutPerSec = other.getBytesOutPerSec();
        return !(this$bytesOutPerSec == null ? other$bytesOutPerSec != null : !((Object)this$bytesOutPerSec).equals(other$bytesOutPerSec));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InternalTopic;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isInternal() ? 79 : 97);
        result = result * 59 + this.getReplicas();
        result = result * 59 + this.getPartitionCount();
        result = result * 59 + this.getInSyncReplicas();
        result = result * 59 + this.getReplicationFactor();
        result = result * 59 + this.getUnderReplicatedPartitions();
        long $segmentSize = this.getSegmentSize();
        result = result * 59 + (int)($segmentSize >>> 32 ^ $segmentSize);
        long $segmentCount = this.getSegmentCount();
        result = result * 59 + (int)($segmentCount >>> 32 ^ $segmentCount);
        ClustersProperties $clustersProperties = this.getClustersProperties();
        result = result * 59 + ($clustersProperties == null ? 43 : $clustersProperties.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map $partitions = this.getPartitions();
        result = result * 59 + ($partitions == null ? 43 : ((Object)$partitions).hashCode());
        List $topicConfigs = this.getTopicConfigs();
        result = result * 59 + ($topicConfigs == null ? 43 : ((Object)$topicConfigs).hashCode());
        CleanupPolicy $cleanUpPolicy = this.getCleanUpPolicy();
        result = result * 59 + ($cleanUpPolicy == null ? 43 : $cleanUpPolicy.hashCode());
        BigDecimal $bytesInPerSec = this.getBytesInPerSec();
        result = result * 59 + ($bytesInPerSec == null ? 43 : ((Object)$bytesInPerSec).hashCode());
        BigDecimal $bytesOutPerSec = this.getBytesOutPerSec();
        result = result * 59 + ($bytesOutPerSec == null ? 43 : ((Object)$bytesOutPerSec).hashCode());
        return result;
    }

    public String toString() {
        return "InternalTopic(clustersProperties=" + this.getClustersProperties() + ", name=" + this.getName() + ", internal=" + this.isInternal() + ", replicas=" + this.getReplicas() + ", partitionCount=" + this.getPartitionCount() + ", inSyncReplicas=" + this.getInSyncReplicas() + ", replicationFactor=" + this.getReplicationFactor() + ", underReplicatedPartitions=" + this.getUnderReplicatedPartitions() + ", partitions=" + this.getPartitions() + ", topicConfigs=" + this.getTopicConfigs() + ", cleanUpPolicy=" + this.getCleanUpPolicy() + ", bytesInPerSec=" + this.getBytesInPerSec() + ", bytesOutPerSec=" + this.getBytesOutPerSec() + ", segmentSize=" + this.getSegmentSize() + ", segmentCount=" + this.getSegmentCount() + ")";
    }
}

