/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.model;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.provectus.kafka.ui.model.InternalPartitionsOffsets;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;

public class InternalPartitionsOffsets {
    private final Table<String, Integer, Offsets> offsets = HashBasedTable.create();

    public InternalPartitionsOffsets(Map<TopicPartition, Offsets> offsetsMap) {
        offsetsMap.forEach((tp, o) -> this.offsets.put((Object)tp.topic(), (Object)tp.partition(), o));
    }

    public static InternalPartitionsOffsets empty() {
        return new InternalPartitionsOffsets(Map.of());
    }

    public Optional<Offsets> get(String topic, int partition) {
        return Optional.ofNullable((Offsets)this.offsets.get((Object)topic, (Object)partition));
    }
}

