/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.model;

import com.provectus.kafka.ui.model.InternalPartition;
import com.provectus.kafka.ui.model.InternalReplica;
import java.util.List;

public class InternalPartition {
    private final int partition;
    private final Integer leader;
    private final List<InternalReplica> replicas;
    private final int inSyncReplicasCount;
    private final int replicasCount;
    private final Long offsetMin;
    private final Long offsetMax;
    private final Long segmentSize;
    private final Integer segmentCount;

    InternalPartition(int partition, Integer leader, List<InternalReplica> replicas, int inSyncReplicasCount, int replicasCount, Long offsetMin, Long offsetMax, Long segmentSize, Integer segmentCount) {
        this.partition = partition;
        this.leader = leader;
        this.replicas = replicas;
        this.inSyncReplicasCount = inSyncReplicasCount;
        this.replicasCount = replicasCount;
        this.offsetMin = offsetMin;
        this.offsetMax = offsetMax;
        this.segmentSize = segmentSize;
        this.segmentCount = segmentCount;
    }

    public static InternalPartitionBuilder builder() {
        return new InternalPartitionBuilder();
    }

    public InternalPartitionBuilder toBuilder() {
        return new InternalPartitionBuilder().partition(this.partition).leader(this.leader).replicas(this.replicas).inSyncReplicasCount(this.inSyncReplicasCount).replicasCount(this.replicasCount).offsetMin(this.offsetMin).offsetMax(this.offsetMax).segmentSize(this.segmentSize).segmentCount(this.segmentCount);
    }

    public int getPartition() {
        return this.partition;
    }

    public Integer getLeader() {
        return this.leader;
    }

    public List<InternalReplica> getReplicas() {
        return this.replicas;
    }

    public int getInSyncReplicasCount() {
        return this.inSyncReplicasCount;
    }

    public int getReplicasCount() {
        return this.replicasCount;
    }

    public Long getOffsetMin() {
        return this.offsetMin;
    }

    public Long getOffsetMax() {
        return this.offsetMax;
    }

    public Long getSegmentSize() {
        return this.segmentSize;
    }

    public Integer getSegmentCount() {
        return this.segmentCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InternalPartition)) {
            return false;
        }
        InternalPartition other = (InternalPartition)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getPartition() != other.getPartition()) {
            return false;
        }
        if (this.getInSyncReplicasCount() != other.getInSyncReplicasCount()) {
            return false;
        }
        if (this.getReplicasCount() != other.getReplicasCount()) {
            return false;
        }
        Integer this$leader = this.getLeader();
        Integer other$leader = other.getLeader();
        if (this$leader == null ? other$leader != null : !((Object)this$leader).equals(other$leader)) {
            return false;
        }
        Long this$offsetMin = this.getOffsetMin();
        Long other$offsetMin = other.getOffsetMin();
        if (this$offsetMin == null ? other$offsetMin != null : !((Object)this$offsetMin).equals(other$offsetMin)) {
            return false;
        }
        Long this$offsetMax = this.getOffsetMax();
        Long other$offsetMax = other.getOffsetMax();
        if (this$offsetMax == null ? other$offsetMax != null : !((Object)this$offsetMax).equals(other$offsetMax)) {
            return false;
        }
        Long this$segmentSize = this.getSegmentSize();
        Long other$segmentSize = other.getSegmentSize();
        if (this$segmentSize == null ? other$segmentSize != null : !((Object)this$segmentSize).equals(other$segmentSize)) {
            return false;
        }
        Integer this$segmentCount = this.getSegmentCount();
        Integer other$segmentCount = other.getSegmentCount();
        if (this$segmentCount == null ? other$segmentCount != null : !((Object)this$segmentCount).equals(other$segmentCount)) {
            return false;
        }
        List this$replicas = this.getReplicas();
        List other$replicas = other.getReplicas();
        return !(this$replicas == null ? other$replicas != null : !((Object)this$replicas).equals(other$replicas));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InternalPartition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPartition();
        result = result * 59 + this.getInSyncReplicasCount();
        result = result * 59 + this.getReplicasCount();
        Integer $leader = this.getLeader();
        result = result * 59 + ($leader == null ? 43 : ((Object)$leader).hashCode());
        Long $offsetMin = this.getOffsetMin();
        result = result * 59 + ($offsetMin == null ? 43 : ((Object)$offsetMin).hashCode());
        Long $offsetMax = this.getOffsetMax();
        result = result * 59 + ($offsetMax == null ? 43 : ((Object)$offsetMax).hashCode());
        Long $segmentSize = this.getSegmentSize();
        result = result * 59 + ($segmentSize == null ? 43 : ((Object)$segmentSize).hashCode());
        Integer $segmentCount = this.getSegmentCount();
        result = result * 59 + ($segmentCount == null ? 43 : ((Object)$segmentCount).hashCode());
        List $replicas = this.getReplicas();
        result = result * 59 + ($replicas == null ? 43 : ((Object)$replicas).hashCode());
        return result;
    }

    public String toString() {
        return "InternalPartition(partition=" + this.getPartition() + ", leader=" + this.getLeader() + ", replicas=" + this.getReplicas() + ", inSyncReplicasCount=" + this.getInSyncReplicasCount() + ", replicasCount=" + this.getReplicasCount() + ", offsetMin=" + this.getOffsetMin() + ", offsetMax=" + this.getOffsetMax() + ", segmentSize=" + this.getSegmentSize() + ", segmentCount=" + this.getSegmentCount() + ")";
    }
}

