/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.model;

import com.provectus.kafka.ui.model.InternalConsumerGroup;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;

/*
 * Exception performing whole class analysis ignored.
 */
public class InternalConsumerGroup {
    private final String groupId;
    private final boolean simple;
    private final Collection<InternalMember> members;
    private final Map<TopicPartition, Long> offsets;
    private final Map<TopicPartition, Long> endOffsets;
    private final Long consumerLag;
    private final Integer topicNum;
    private final String partitionAssignor;
    private final ConsumerGroupState state;
    private final Node coordinator;

    public static InternalConsumerGroup create(ConsumerGroupDescription description, Map<TopicPartition, Long> groupOffsets, Map<TopicPartition, Long> topicEndOffsets) {
        InternalConsumerGroupBuilder builder = InternalConsumerGroup.builder();
        builder.groupId(description.groupId());
        builder.simple(description.isSimpleConsumerGroup());
        builder.state(description.state());
        builder.partitionAssignor(description.partitionAssignor());
        Collection internalMembers = InternalConsumerGroup.initInternalMembers((ConsumerGroupDescription)description);
        builder.members(internalMembers);
        builder.offsets(groupOffsets);
        builder.endOffsets(topicEndOffsets);
        builder.consumerLag(InternalConsumerGroup.calculateConsumerLag(groupOffsets, topicEndOffsets));
        builder.topicNum(InternalConsumerGroup.calculateTopicNum(groupOffsets, (Collection)internalMembers));
        Optional.ofNullable(description.coordinator()).ifPresent(arg_0 -> ((InternalConsumerGroupBuilder)builder).coordinator(arg_0));
        return builder.build();
    }

    private static Long calculateConsumerLag(Map<TopicPartition, Long> offsets, Map<TopicPartition, Long> endOffsets) {
        Long consumerLag = null;
        if (!offsets.isEmpty()) {
            consumerLag = offsets.entrySet().stream().mapToLong(e -> Optional.ofNullable(endOffsets).map(o -> (Long)o.get(e.getKey())).map(o -> o - (Long)e.getValue()).orElse(0L)).sum();
        }
        return consumerLag;
    }

    private static Integer calculateTopicNum(Map<TopicPartition, Long> offsets, Collection<InternalMember> members) {
        return (int)Stream.concat(offsets.keySet().stream().map(TopicPartition::topic), members.stream().flatMap(m -> m.getAssignment().stream().map(TopicPartition::topic))).distinct().count();
    }

    private static Collection<InternalMember> initInternalMembers(ConsumerGroupDescription description) {
        return description.members().stream().map(m -> InternalMember.builder().assignment(m.assignment().topicPartitions()).clientId(m.clientId()).groupInstanceId(m.groupInstanceId().orElse("")).consumerId(m.consumerId()).clientId(m.clientId()).host(m.host()).build()).collect(Collectors.toList());
    }

    InternalConsumerGroup(String groupId, boolean simple, Collection<InternalMember> members, Map<TopicPartition, Long> offsets, Map<TopicPartition, Long> endOffsets, Long consumerLag, Integer topicNum, String partitionAssignor, ConsumerGroupState state, Node coordinator) {
        this.groupId = groupId;
        this.simple = simple;
        this.members = members;
        this.offsets = offsets;
        this.endOffsets = endOffsets;
        this.consumerLag = consumerLag;
        this.topicNum = topicNum;
        this.partitionAssignor = partitionAssignor;
        this.state = state;
        this.coordinator = coordinator;
    }

    public static InternalConsumerGroupBuilder builder() {
        return new InternalConsumerGroupBuilder();
    }

    public InternalConsumerGroupBuilder toBuilder() {
        return new InternalConsumerGroupBuilder().groupId(this.groupId).simple(this.simple).members(this.members).offsets(this.offsets).endOffsets(this.endOffsets).consumerLag(this.consumerLag).topicNum(this.topicNum).partitionAssignor(this.partitionAssignor).state(this.state).coordinator(this.coordinator);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public boolean isSimple() {
        return this.simple;
    }

    public Collection<InternalMember> getMembers() {
        return this.members;
    }

    public Map<TopicPartition, Long> getOffsets() {
        return this.offsets;
    }

    public Map<TopicPartition, Long> getEndOffsets() {
        return this.endOffsets;
    }

    public Long getConsumerLag() {
        return this.consumerLag;
    }

    public Integer getTopicNum() {
        return this.topicNum;
    }

    public String getPartitionAssignor() {
        return this.partitionAssignor;
    }

    public ConsumerGroupState getState() {
        return this.state;
    }

    public Node getCoordinator() {
        return this.coordinator;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InternalConsumerGroup)) {
            return false;
        }
        InternalConsumerGroup other = (InternalConsumerGroup)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isSimple() != other.isSimple()) {
            return false;
        }
        Long this$consumerLag = this.getConsumerLag();
        Long other$consumerLag = other.getConsumerLag();
        if (this$consumerLag == null ? other$consumerLag != null : !((Object)this$consumerLag).equals(other$consumerLag)) {
            return false;
        }
        Integer this$topicNum = this.getTopicNum();
        Integer other$topicNum = other.getTopicNum();
        if (this$topicNum == null ? other$topicNum != null : !((Object)this$topicNum).equals(other$topicNum)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        Collection this$members = this.getMembers();
        Collection other$members = other.getMembers();
        if (this$members == null ? other$members != null : !((Object)this$members).equals(other$members)) {
            return false;
        }
        Map this$offsets = this.getOffsets();
        Map other$offsets = other.getOffsets();
        if (this$offsets == null ? other$offsets != null : !((Object)this$offsets).equals(other$offsets)) {
            return false;
        }
        Map this$endOffsets = this.getEndOffsets();
        Map other$endOffsets = other.getEndOffsets();
        if (this$endOffsets == null ? other$endOffsets != null : !((Object)this$endOffsets).equals(other$endOffsets)) {
            return false;
        }
        String this$partitionAssignor = this.getPartitionAssignor();
        String other$partitionAssignor = other.getPartitionAssignor();
        if (this$partitionAssignor == null ? other$partitionAssignor != null : !this$partitionAssignor.equals(other$partitionAssignor)) {
            return false;
        }
        ConsumerGroupState this$state = this.getState();
        ConsumerGroupState other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        Node this$coordinator = this.getCoordinator();
        Node other$coordinator = other.getCoordinator();
        return !(this$coordinator == null ? other$coordinator != null : !this$coordinator.equals(other$coordinator));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InternalConsumerGroup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSimple() ? 79 : 97);
        Long $consumerLag = this.getConsumerLag();
        result = result * 59 + ($consumerLag == null ? 43 : ((Object)$consumerLag).hashCode());
        Integer $topicNum = this.getTopicNum();
        result = result * 59 + ($topicNum == null ? 43 : ((Object)$topicNum).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        Collection $members = this.getMembers();
        result = result * 59 + ($members == null ? 43 : ((Object)$members).hashCode());
        Map $offsets = this.getOffsets();
        result = result * 59 + ($offsets == null ? 43 : ((Object)$offsets).hashCode());
        Map $endOffsets = this.getEndOffsets();
        result = result * 59 + ($endOffsets == null ? 43 : ((Object)$endOffsets).hashCode());
        String $partitionAssignor = this.getPartitionAssignor();
        result = result * 59 + ($partitionAssignor == null ? 43 : $partitionAssignor.hashCode());
        ConsumerGroupState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        Node $coordinator = this.getCoordinator();
        result = result * 59 + ($coordinator == null ? 43 : $coordinator.hashCode());
        return result;
    }

    public String toString() {
        return "InternalConsumerGroup(groupId=" + this.getGroupId() + ", simple=" + this.isSimple() + ", members=" + this.getMembers() + ", offsets=" + this.getOffsets() + ", endOffsets=" + this.getEndOffsets() + ", consumerLag=" + this.getConsumerLag() + ", topicNum=" + this.getTopicNum() + ", partitionAssignor=" + this.getPartitionAssignor() + ", state=" + this.getState() + ", coordinator=" + this.getCoordinator() + ")";
    }
}

