/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.model;

import com.provectus.kafka.ui.model.PartitionDistributionStats;
import com.provectus.kafka.ui.model.Statistics;
import java.math.BigDecimal;
import javax.annotation.Nullable;
import org.apache.kafka.common.Node;

public class InternalBroker {
    private final Integer id;
    private final String host;
    private final Integer port;
    @Nullable
    private final BigDecimal bytesInPerSec;
    @Nullable
    private final BigDecimal bytesOutPerSec;
    @Nullable
    private final Integer partitionsLeader;
    @Nullable
    private final Integer partitions;
    @Nullable
    private final Integer inSyncPartitions;
    @Nullable
    private final BigDecimal leadersSkew;
    @Nullable
    private final BigDecimal partitionsSkew;

    public InternalBroker(Node node, PartitionDistributionStats partitionDistribution, Statistics statistics) {
        this.id = node.id();
        this.host = node.host();
        this.port = node.port();
        this.bytesInPerSec = (BigDecimal)statistics.getMetrics().getBrokerBytesInPerSec().get(node.id());
        this.bytesOutPerSec = (BigDecimal)statistics.getMetrics().getBrokerBytesOutPerSec().get(node.id());
        this.partitionsLeader = (Integer)partitionDistribution.getPartitionLeaders().get(node);
        this.partitions = (Integer)partitionDistribution.getPartitionsCount().get(node);
        this.inSyncPartitions = (Integer)partitionDistribution.getInSyncPartitions().get(node);
        this.leadersSkew = partitionDistribution.leadersSkew(node);
        this.partitionsSkew = partitionDistribution.partitionsSkew(node);
    }

    public Integer getId() {
        return this.id;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    @Nullable
    public BigDecimal getBytesInPerSec() {
        return this.bytesInPerSec;
    }

    @Nullable
    public BigDecimal getBytesOutPerSec() {
        return this.bytesOutPerSec;
    }

    @Nullable
    public Integer getPartitionsLeader() {
        return this.partitionsLeader;
    }

    @Nullable
    public Integer getPartitions() {
        return this.partitions;
    }

    @Nullable
    public Integer getInSyncPartitions() {
        return this.inSyncPartitions;
    }

    @Nullable
    public BigDecimal getLeadersSkew() {
        return this.leadersSkew;
    }

    @Nullable
    public BigDecimal getPartitionsSkew() {
        return this.partitionsSkew;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InternalBroker)) {
            return false;
        }
        InternalBroker other = (InternalBroker)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Integer this$partitionsLeader = this.getPartitionsLeader();
        Integer other$partitionsLeader = other.getPartitionsLeader();
        if (this$partitionsLeader == null ? other$partitionsLeader != null : !((Object)this$partitionsLeader).equals(other$partitionsLeader)) {
            return false;
        }
        Integer this$partitions = this.getPartitions();
        Integer other$partitions = other.getPartitions();
        if (this$partitions == null ? other$partitions != null : !((Object)this$partitions).equals(other$partitions)) {
            return false;
        }
        Integer this$inSyncPartitions = this.getInSyncPartitions();
        Integer other$inSyncPartitions = other.getInSyncPartitions();
        if (this$inSyncPartitions == null ? other$inSyncPartitions != null : !((Object)this$inSyncPartitions).equals(other$inSyncPartitions)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        BigDecimal this$bytesInPerSec = this.getBytesInPerSec();
        BigDecimal other$bytesInPerSec = other.getBytesInPerSec();
        if (this$bytesInPerSec == null ? other$bytesInPerSec != null : !((Object)this$bytesInPerSec).equals(other$bytesInPerSec)) {
            return false;
        }
        BigDecimal this$bytesOutPerSec = this.getBytesOutPerSec();
        BigDecimal other$bytesOutPerSec = other.getBytesOutPerSec();
        if (this$bytesOutPerSec == null ? other$bytesOutPerSec != null : !((Object)this$bytesOutPerSec).equals(other$bytesOutPerSec)) {
            return false;
        }
        BigDecimal this$leadersSkew = this.getLeadersSkew();
        BigDecimal other$leadersSkew = other.getLeadersSkew();
        if (this$leadersSkew == null ? other$leadersSkew != null : !((Object)this$leadersSkew).equals(other$leadersSkew)) {
            return false;
        }
        BigDecimal this$partitionsSkew = this.getPartitionsSkew();
        BigDecimal other$partitionsSkew = other.getPartitionsSkew();
        return !(this$partitionsSkew == null ? other$partitionsSkew != null : !((Object)this$partitionsSkew).equals(other$partitionsSkew));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InternalBroker;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Integer $partitionsLeader = this.getPartitionsLeader();
        result = result * 59 + ($partitionsLeader == null ? 43 : ((Object)$partitionsLeader).hashCode());
        Integer $partitions = this.getPartitions();
        result = result * 59 + ($partitions == null ? 43 : ((Object)$partitions).hashCode());
        Integer $inSyncPartitions = this.getInSyncPartitions();
        result = result * 59 + ($inSyncPartitions == null ? 43 : ((Object)$inSyncPartitions).hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        BigDecimal $bytesInPerSec = this.getBytesInPerSec();
        result = result * 59 + ($bytesInPerSec == null ? 43 : ((Object)$bytesInPerSec).hashCode());
        BigDecimal $bytesOutPerSec = this.getBytesOutPerSec();
        result = result * 59 + ($bytesOutPerSec == null ? 43 : ((Object)$bytesOutPerSec).hashCode());
        BigDecimal $leadersSkew = this.getLeadersSkew();
        result = result * 59 + ($leadersSkew == null ? 43 : ((Object)$leadersSkew).hashCode());
        BigDecimal $partitionsSkew = this.getPartitionsSkew();
        result = result * 59 + ($partitionsSkew == null ? 43 : ((Object)$partitionsSkew).hashCode());
        return result;
    }

    public String toString() {
        return "InternalBroker(id=" + this.getId() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", bytesInPerSec=" + this.getBytesInPerSec() + ", bytesOutPerSec=" + this.getBytesOutPerSec() + ", partitionsLeader=" + this.getPartitionsLeader() + ", partitions=" + this.getPartitions() + ", inSyncPartitions=" + this.getInSyncPartitions() + ", leadersSkew=" + this.getLeadersSkew() + ", partitionsSkew=" + this.getPartitionsSkew() + ")";
    }
}

