/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.mapper;

import com.provectus.kafka.ui.model.CompatibilityCheckResponseDTO;
import com.provectus.kafka.ui.model.CompatibilityLevelDTO;
import com.provectus.kafka.ui.model.NewSchemaSubjectDTO;
import com.provectus.kafka.ui.model.SchemaReferenceDTO;
import com.provectus.kafka.ui.model.SchemaSubjectDTO;
import com.provectus.kafka.ui.model.SchemaTypeDTO;
import com.provectus.kafka.ui.service.SchemaRegistryService;
import com.provectus.kafka.ui.sr.model.Compatibility;
import com.provectus.kafka.ui.sr.model.CompatibilityCheckResponse;
import com.provectus.kafka.ui.sr.model.NewSubject;
import com.provectus.kafka.ui.sr.model.SchemaReference;
import com.provectus.kafka.ui.sr.model.SchemaType;
import java.util.List;
import java.util.Optional;
import org.mapstruct.Mapper;

@Mapper
public interface KafkaSrMapper {
    default public SchemaSubjectDTO toDto(SchemaRegistryService.SubjectWithCompatibilityLevel s) {
        return new SchemaSubjectDTO().id(s.getId()).version(s.getVersion()).subject(s.getSubject()).schema(s.getSchema()).schemaType(SchemaTypeDTO.fromValue((String)Optional.ofNullable(s.getSchemaType()).orElse(SchemaType.AVRO).getValue())).references(this.toDto(s.getReferences())).compatibilityLevel(s.getCompatibility().toString());
    }

    public List<SchemaReferenceDTO> toDto(List<SchemaReference> var1);

    public CompatibilityCheckResponseDTO toDto(CompatibilityCheckResponse var1);

    public CompatibilityLevelDTO.CompatibilityEnum toDto(Compatibility var1);

    public NewSubject fromDto(NewSchemaSubjectDTO var1);

    public Compatibility fromDto(CompatibilityLevelDTO.CompatibilityEnum var1);
}

