/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.mapper;

import com.provectus.kafka.ui.config.ClustersProperties;
import com.provectus.kafka.ui.mapper.ClusterMapper;
import com.provectus.kafka.ui.mapper.ClusterMapperImpl;
import com.provectus.kafka.ui.model.BrokerConfigDTO;
import com.provectus.kafka.ui.model.BrokerDTO;
import com.provectus.kafka.ui.model.CleanUpPolicyDTO;
import com.provectus.kafka.ui.model.CleanupPolicy;
import com.provectus.kafka.ui.model.ClusterDTO;
import com.provectus.kafka.ui.model.ClusterFeature;
import com.provectus.kafka.ui.model.ClusterStatsDTO;
import com.provectus.kafka.ui.model.ConfigSourceDTO;
import com.provectus.kafka.ui.model.ConfigSynonymDTO;
import com.provectus.kafka.ui.model.ConnectDTO;
import com.provectus.kafka.ui.model.InternalBroker;
import com.provectus.kafka.ui.model.InternalBrokerConfig;
import com.provectus.kafka.ui.model.InternalClusterState;
import com.provectus.kafka.ui.model.InternalPartition;
import com.provectus.kafka.ui.model.InternalReplica;
import com.provectus.kafka.ui.model.InternalTopic;
import com.provectus.kafka.ui.model.InternalTopicConfig;
import com.provectus.kafka.ui.model.PartitionDTO;
import com.provectus.kafka.ui.model.ReplicaDTO;
import com.provectus.kafka.ui.model.TopicConfigDTO;
import com.provectus.kafka.ui.model.TopicDTO;
import com.provectus.kafka.ui.model.TopicDetailsDTO;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.springframework.stereotype.Component;

@Component
public class ClusterMapperImpl
implements ClusterMapper {
    public ClusterDTO toCluster(InternalClusterState clusterState) {
        if (clusterState == null) {
            return null;
        }
        ClusterDTO clusterDTO = new ClusterDTO();
        clusterDTO.setName(clusterState.getName());
        clusterDTO.setStatus(clusterState.getStatus());
        clusterDTO.setLastError(clusterState.getLastError());
        clusterDTO.setBrokerCount(clusterState.getBrokerCount());
        clusterDTO.setOnlinePartitionCount(clusterState.getOnlinePartitionCount());
        clusterDTO.setTopicCount(clusterState.getTopicCount());
        clusterDTO.setBytesInPerSec(clusterState.getBytesInPerSec());
        clusterDTO.setBytesOutPerSec(clusterState.getBytesOutPerSec());
        clusterDTO.setReadOnly(clusterState.getReadOnly());
        clusterDTO.setVersion(clusterState.getVersion());
        clusterDTO.setFeatures(this.toFeaturesEnum(clusterState.getFeatures()));
        return clusterDTO;
    }

    public ClusterStatsDTO toClusterStats(InternalClusterState clusterState) {
        if (clusterState == null) {
            return null;
        }
        ClusterStatsDTO clusterStatsDTO = new ClusterStatsDTO();
        clusterStatsDTO.setBrokerCount(clusterState.getBrokerCount());
        clusterStatsDTO.setActiveControllers(clusterState.getActiveControllers());
        clusterStatsDTO.setOnlinePartitionCount(clusterState.getOnlinePartitionCount());
        clusterStatsDTO.setOfflinePartitionCount(clusterState.getOfflinePartitionCount());
        clusterStatsDTO.setInSyncReplicasCount(clusterState.getInSyncReplicasCount());
        clusterStatsDTO.setOutOfSyncReplicasCount(clusterState.getOutOfSyncReplicasCount());
        clusterStatsDTO.setUnderReplicatedPartitionCount(clusterState.getUnderReplicatedPartitionCount());
        List list = clusterState.getDiskUsage();
        if (list != null) {
            clusterStatsDTO.setDiskUsage(new ArrayList(list));
        }
        clusterStatsDTO.setVersion(clusterState.getVersion());
        return clusterStatsDTO;
    }

    public BrokerConfigDTO toBrokerConfig(InternalBrokerConfig config) {
        if (config == null) {
            return null;
        }
        BrokerConfigDTO brokerConfigDTO = new BrokerConfigDTO();
        brokerConfigDTO.setIsSensitive(Boolean.valueOf(config.isSensitive()));
        brokerConfigDTO.setIsReadOnly(Boolean.valueOf(config.isReadOnly()));
        brokerConfigDTO.setName(config.getName());
        brokerConfigDTO.setValue(config.getValue());
        brokerConfigDTO.setSource(this.configSourceToConfigSourceDTO(config.getSource()));
        brokerConfigDTO.setSynonyms(this.configSynonymListToConfigSynonymDTOList(config.getSynonyms()));
        return brokerConfigDTO;
    }

    public TopicDTO toTopic(InternalTopic topic) {
        if (topic == null) {
            return null;
        }
        TopicDTO topicDTO = new TopicDTO();
        topicDTO.setName(topic.getName());
        topicDTO.setInternal(Boolean.valueOf(topic.isInternal()));
        topicDTO.setPartitionCount(Integer.valueOf(topic.getPartitionCount()));
        topicDTO.setReplicationFactor(Integer.valueOf(topic.getReplicationFactor()));
        topicDTO.setReplicas(Integer.valueOf(topic.getReplicas()));
        topicDTO.setInSyncReplicas(Integer.valueOf(topic.getInSyncReplicas()));
        topicDTO.setSegmentSize(Long.valueOf(topic.getSegmentSize()));
        topicDTO.setSegmentCount(Integer.valueOf((int)topic.getSegmentCount()));
        topicDTO.setBytesInPerSec(topic.getBytesInPerSec());
        topicDTO.setBytesOutPerSec(topic.getBytesOutPerSec());
        topicDTO.setUnderReplicatedPartitions(Integer.valueOf(topic.getUnderReplicatedPartitions()));
        topicDTO.setCleanUpPolicy(this.cleanupPolicyToCleanUpPolicyDTO(topic.getCleanUpPolicy()));
        topicDTO.setPartitions(this.map(topic.getPartitions()));
        return topicDTO;
    }

    public PartitionDTO toPartition(InternalPartition topic) {
        if (topic == null) {
            return null;
        }
        PartitionDTO partitionDTO = new PartitionDTO();
        partitionDTO.setPartition(Integer.valueOf(topic.getPartition()));
        partitionDTO.setLeader(topic.getLeader());
        partitionDTO.setReplicas(this.internalReplicaListToReplicaDTOList(topic.getReplicas()));
        partitionDTO.setOffsetMax(topic.getOffsetMax());
        partitionDTO.setOffsetMin(topic.getOffsetMin());
        return partitionDTO;
    }

    public BrokerDTO toBrokerDto(InternalBroker broker) {
        if (broker == null) {
            return null;
        }
        BrokerDTO brokerDTO = new BrokerDTO();
        brokerDTO.setId(broker.getId());
        brokerDTO.setHost(broker.getHost());
        brokerDTO.setPort(broker.getPort());
        brokerDTO.setBytesInPerSec(broker.getBytesInPerSec());
        brokerDTO.setBytesOutPerSec(broker.getBytesOutPerSec());
        brokerDTO.setPartitionsLeader(broker.getPartitionsLeader());
        brokerDTO.setPartitions(broker.getPartitions());
        brokerDTO.setInSyncPartitions(broker.getInSyncPartitions());
        brokerDTO.setPartitionsSkew(broker.getPartitionsSkew());
        brokerDTO.setLeadersSkew(broker.getLeadersSkew());
        return brokerDTO;
    }

    public TopicDetailsDTO toTopicDetails(InternalTopic topic) {
        if (topic == null) {
            return null;
        }
        TopicDetailsDTO topicDetailsDTO = new TopicDetailsDTO();
        topicDetailsDTO.setName(topic.getName());
        topicDetailsDTO.setInternal(Boolean.valueOf(topic.isInternal()));
        topicDetailsDTO.setPartitions(this.map(topic.getPartitions()));
        topicDetailsDTO.setPartitionCount(Integer.valueOf(topic.getPartitionCount()));
        topicDetailsDTO.setReplicationFactor(Integer.valueOf(topic.getReplicationFactor()));
        topicDetailsDTO.setReplicas(Integer.valueOf(topic.getReplicas()));
        topicDetailsDTO.setInSyncReplicas(Integer.valueOf(topic.getInSyncReplicas()));
        topicDetailsDTO.setBytesInPerSec(topic.getBytesInPerSec());
        topicDetailsDTO.setBytesOutPerSec(topic.getBytesOutPerSec());
        topicDetailsDTO.setSegmentSize(Long.valueOf(topic.getSegmentSize()));
        topicDetailsDTO.setSegmentCount(Integer.valueOf((int)topic.getSegmentCount()));
        topicDetailsDTO.setUnderReplicatedPartitions(Integer.valueOf(topic.getUnderReplicatedPartitions()));
        topicDetailsDTO.setCleanUpPolicy(this.cleanupPolicyToCleanUpPolicyDTO(topic.getCleanUpPolicy()));
        return topicDetailsDTO;
    }

    public TopicConfigDTO toTopicConfig(InternalTopicConfig topic) {
        if (topic == null) {
            return null;
        }
        TopicConfigDTO topicConfigDTO = new TopicConfigDTO();
        topicConfigDTO.setIsReadOnly(Boolean.valueOf(topic.isReadOnly()));
        topicConfigDTO.setIsSensitive(Boolean.valueOf(topic.isSensitive()));
        topicConfigDTO.setName(topic.getName());
        topicConfigDTO.setValue(topic.getValue());
        topicConfigDTO.setDefaultValue(topic.getDefaultValue());
        topicConfigDTO.setSource(this.configSourceToConfigSourceDTO(topic.getSource()));
        topicConfigDTO.setSynonyms(this.configSynonymListToConfigSynonymDTOList(topic.getSynonyms()));
        topicConfigDTO.setDoc(topic.getDoc());
        return topicConfigDTO;
    }

    public ReplicaDTO toReplica(InternalReplica replica) {
        if (replica == null) {
            return null;
        }
        ReplicaDTO replicaDTO = new ReplicaDTO();
        replicaDTO.setBroker(Integer.valueOf(replica.getBroker()));
        replicaDTO.setLeader(Boolean.valueOf(replica.isLeader()));
        replicaDTO.setInSync(Boolean.valueOf(replica.isInSync()));
        return replicaDTO;
    }

    public ConnectDTO toKafkaConnect(ClustersProperties.ConnectCluster connect) {
        if (connect == null) {
            return null;
        }
        ConnectDTO connectDTO = new ConnectDTO();
        connectDTO.setName(connect.getName());
        connectDTO.setAddress(connect.getAddress());
        return connectDTO;
    }

    public List<ClusterDTO.FeaturesEnum> toFeaturesEnum(List<ClusterFeature> features) {
        if (features == null) {
            return null;
        }
        ArrayList<ClusterDTO.FeaturesEnum> list = new ArrayList<ClusterDTO.FeaturesEnum>(features.size());
        for (ClusterFeature clusterFeature : features) {
            list.add(this.clusterFeatureToFeaturesEnum(clusterFeature));
        }
        return list;
    }

    protected ConfigSourceDTO configSourceToConfigSourceDTO(ConfigEntry.ConfigSource configSource) {
        if (configSource == null) {
            return null;
        }
        return switch (1.$SwitchMap$org$apache$kafka$clients$admin$ConfigEntry$ConfigSource[configSource.ordinal()]) {
            case 1 -> ConfigSourceDTO.DYNAMIC_TOPIC_CONFIG;
            case 2 -> ConfigSourceDTO.DYNAMIC_BROKER_LOGGER_CONFIG;
            case 3 -> ConfigSourceDTO.DYNAMIC_BROKER_CONFIG;
            case 4 -> ConfigSourceDTO.DYNAMIC_DEFAULT_BROKER_CONFIG;
            case 5 -> ConfigSourceDTO.STATIC_BROKER_CONFIG;
            case 6 -> ConfigSourceDTO.DEFAULT_CONFIG;
            case 7 -> ConfigSourceDTO.UNKNOWN;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + configSource);
        };
    }

    protected List<ConfigSynonymDTO> configSynonymListToConfigSynonymDTOList(List<ConfigEntry.ConfigSynonym> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ConfigSynonymDTO> list1 = new ArrayList<ConfigSynonymDTO>(list.size());
        for (ConfigEntry.ConfigSynonym configSynonym : list) {
            list1.add(this.toConfigSynonym(configSynonym));
        }
        return list1;
    }

    protected CleanUpPolicyDTO cleanupPolicyToCleanUpPolicyDTO(CleanupPolicy cleanupPolicy) {
        if (cleanupPolicy == null) {
            return null;
        }
        return switch (1.$SwitchMap$com$provectus$kafka$ui$model$CleanupPolicy[cleanupPolicy.ordinal()]) {
            case 1 -> CleanUpPolicyDTO.DELETE;
            case 2 -> CleanUpPolicyDTO.COMPACT;
            case 3 -> CleanUpPolicyDTO.COMPACT_DELETE;
            case 4 -> CleanUpPolicyDTO.UNKNOWN;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + cleanupPolicy);
        };
    }

    protected List<ReplicaDTO> internalReplicaListToReplicaDTOList(List<InternalReplica> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ReplicaDTO> list1 = new ArrayList<ReplicaDTO>(list.size());
        for (InternalReplica internalReplica : list) {
            list1.add(this.toReplica(internalReplica));
        }
        return list1;
    }

    protected ClusterDTO.FeaturesEnum clusterFeatureToFeaturesEnum(ClusterFeature clusterFeature) {
        if (clusterFeature == null) {
            return null;
        }
        return switch (1.$SwitchMap$com$provectus$kafka$ui$model$ClusterFeature[clusterFeature.ordinal()]) {
            case 1 -> ClusterDTO.FeaturesEnum.KAFKA_CONNECT;
            case 2 -> ClusterDTO.FeaturesEnum.KSQL_DB;
            case 3 -> ClusterDTO.FeaturesEnum.SCHEMA_REGISTRY;
            case 4 -> ClusterDTO.FeaturesEnum.TOPIC_DELETION;
            case 5 -> ClusterDTO.FeaturesEnum.KAFKA_ACL_VIEW;
            case 6 -> ClusterDTO.FeaturesEnum.KAFKA_ACL_EDIT;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + clusterFeature);
        };
    }
}

