/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.mapper;

import com.provectus.kafka.ui.config.ClustersProperties;
import com.provectus.kafka.ui.mapper.ClusterMapper;
import com.provectus.kafka.ui.model.BrokerConfigDTO;
import com.provectus.kafka.ui.model.BrokerDTO;
import com.provectus.kafka.ui.model.BrokerDiskUsageDTO;
import com.provectus.kafka.ui.model.BrokerMetricsDTO;
import com.provectus.kafka.ui.model.ClusterDTO;
import com.provectus.kafka.ui.model.ClusterFeature;
import com.provectus.kafka.ui.model.ClusterMetricsDTO;
import com.provectus.kafka.ui.model.ClusterStatsDTO;
import com.provectus.kafka.ui.model.ConfigSourceDTO;
import com.provectus.kafka.ui.model.ConfigSynonymDTO;
import com.provectus.kafka.ui.model.ConnectDTO;
import com.provectus.kafka.ui.model.InternalBroker;
import com.provectus.kafka.ui.model.InternalBrokerConfig;
import com.provectus.kafka.ui.model.InternalBrokerDiskUsage;
import com.provectus.kafka.ui.model.InternalClusterState;
import com.provectus.kafka.ui.model.InternalPartition;
import com.provectus.kafka.ui.model.InternalReplica;
import com.provectus.kafka.ui.model.InternalTopic;
import com.provectus.kafka.ui.model.InternalTopicConfig;
import com.provectus.kafka.ui.model.KafkaAclDTO;
import com.provectus.kafka.ui.model.KafkaAclNamePatternTypeDTO;
import com.provectus.kafka.ui.model.KafkaAclResourceTypeDTO;
import com.provectus.kafka.ui.model.MetricDTO;
import com.provectus.kafka.ui.model.Metrics;
import com.provectus.kafka.ui.model.PartitionDTO;
import com.provectus.kafka.ui.model.ReplicaDTO;
import com.provectus.kafka.ui.model.TopicConfigDTO;
import com.provectus.kafka.ui.model.TopicDTO;
import com.provectus.kafka.ui.model.TopicDetailsDTO;
import com.provectus.kafka.ui.model.TopicProducerStateDTO;
import com.provectus.kafka.ui.service.metrics.RawMetric;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ProducerState;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

/*
 * Exception performing whole class analysis ignored.
 */
@Mapper(componentModel="spring")
public interface ClusterMapper {
    public ClusterDTO toCluster(InternalClusterState var1);

    public ClusterStatsDTO toClusterStats(InternalClusterState var1);

    default public ClusterMetricsDTO toClusterMetrics(Metrics metrics) {
        return new ClusterMetricsDTO().items(metrics.getSummarizedMetrics().map(arg_0 -> this.convert(arg_0)).toList());
    }

    private MetricDTO convert(RawMetric rawMetric) {
        return new MetricDTO().name(rawMetric.name()).labels(rawMetric.labels()).value(rawMetric.value());
    }

    default public BrokerMetricsDTO toBrokerMetrics(List<RawMetric> metrics) {
        return new BrokerMetricsDTO().metrics(metrics.stream().map(arg_0 -> this.convert(arg_0)).toList());
    }

    @Mappings(value={@Mapping(target="isSensitive", source="sensitive"), @Mapping(target="isReadOnly", source="readOnly")})
    public BrokerConfigDTO toBrokerConfig(InternalBrokerConfig var1);

    default public ConfigSynonymDTO toConfigSynonym(ConfigEntry.ConfigSynonym config) {
        if (config == null) {
            return null;
        }
        ConfigSynonymDTO configSynonym = new ConfigSynonymDTO();
        configSynonym.setName(config.name());
        configSynonym.setValue(config.value());
        if (config.source() != null) {
            configSynonym.setSource(ConfigSourceDTO.valueOf((String)config.source().name()));
        }
        return configSynonym;
    }

    public TopicDTO toTopic(InternalTopic var1);

    public PartitionDTO toPartition(InternalPartition var1);

    public BrokerDTO toBrokerDto(InternalBroker var1);

    public TopicDetailsDTO toTopicDetails(InternalTopic var1);

    @Mappings(value={@Mapping(target="isReadOnly", source="readOnly"), @Mapping(target="isSensitive", source="sensitive")})
    public TopicConfigDTO toTopicConfig(InternalTopicConfig var1);

    public ReplicaDTO toReplica(InternalReplica var1);

    public ConnectDTO toKafkaConnect(ClustersProperties.ConnectCluster var1);

    public List<ClusterDTO.FeaturesEnum> toFeaturesEnum(List<ClusterFeature> var1);

    default public List<PartitionDTO> map(Map<Integer, InternalPartition> map) {
        return map.values().stream().map(arg_0 -> this.toPartition(arg_0)).toList();
    }

    default public BrokerDiskUsageDTO map(Integer id, InternalBrokerDiskUsage internalBrokerDiskUsage) {
        BrokerDiskUsageDTO brokerDiskUsage = new BrokerDiskUsageDTO();
        brokerDiskUsage.setBrokerId(id);
        brokerDiskUsage.segmentCount(Integer.valueOf((int)internalBrokerDiskUsage.getSegmentCount()));
        brokerDiskUsage.segmentSize(Long.valueOf(internalBrokerDiskUsage.getSegmentSize()));
        return brokerDiskUsage;
    }

    default public TopicProducerStateDTO map(int partition, ProducerState state) {
        return new TopicProducerStateDTO().partition(Integer.valueOf(partition)).producerId(Long.valueOf(state.producerId())).producerEpoch(Integer.valueOf(state.producerEpoch())).lastSequence(Integer.valueOf(state.lastSequence())).lastTimestampMs(Long.valueOf(state.lastTimestamp())).coordinatorEpoch((Integer)state.coordinatorEpoch().stream().boxed().findAny().orElse(null)).currentTransactionStartOffset((Long)state.currentTransactionStartOffset().stream().boxed().findAny().orElse(null));
    }

    public static KafkaAclDTO.OperationEnum mapAclOperation(AclOperation operation) {
        return switch (1.$SwitchMap$org$apache$kafka$common$acl$AclOperation[operation.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> KafkaAclDTO.OperationEnum.ALL;
            case 2 -> KafkaAclDTO.OperationEnum.READ;
            case 3 -> KafkaAclDTO.OperationEnum.WRITE;
            case 4 -> KafkaAclDTO.OperationEnum.CREATE;
            case 5 -> KafkaAclDTO.OperationEnum.DELETE;
            case 6 -> KafkaAclDTO.OperationEnum.ALTER;
            case 7 -> KafkaAclDTO.OperationEnum.DESCRIBE;
            case 8 -> KafkaAclDTO.OperationEnum.CLUSTER_ACTION;
            case 9 -> KafkaAclDTO.OperationEnum.DESCRIBE_CONFIGS;
            case 10 -> KafkaAclDTO.OperationEnum.ALTER_CONFIGS;
            case 11 -> KafkaAclDTO.OperationEnum.IDEMPOTENT_WRITE;
            case 12 -> KafkaAclDTO.OperationEnum.CREATE_TOKENS;
            case 13 -> KafkaAclDTO.OperationEnum.DESCRIBE_TOKENS;
            case 14 -> throw new IllegalArgumentException("ANY operation can be only part of filter");
            case 15 -> KafkaAclDTO.OperationEnum.UNKNOWN;
        };
    }

    public static KafkaAclResourceTypeDTO mapAclResourceType(ResourceType resourceType) {
        return switch (1.$SwitchMap$org$apache$kafka$common$resource$ResourceType[resourceType.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> KafkaAclResourceTypeDTO.CLUSTER;
            case 2 -> KafkaAclResourceTypeDTO.TOPIC;
            case 3 -> KafkaAclResourceTypeDTO.GROUP;
            case 4 -> KafkaAclResourceTypeDTO.DELEGATION_TOKEN;
            case 5 -> KafkaAclResourceTypeDTO.TRANSACTIONAL_ID;
            case 6 -> KafkaAclResourceTypeDTO.USER;
            case 7 -> throw new IllegalArgumentException("ANY type can be only part of filter");
            case 8 -> KafkaAclResourceTypeDTO.UNKNOWN;
        };
    }

    public static ResourceType mapAclResourceTypeDto(KafkaAclResourceTypeDTO dto) {
        return ResourceType.valueOf((String)dto.name());
    }

    public static PatternType mapPatternTypeDto(KafkaAclNamePatternTypeDTO dto) {
        return PatternType.valueOf((String)dto.name());
    }

    public static AclBinding toAclBinding(KafkaAclDTO dto) {
        return new AclBinding(new ResourcePattern(ClusterMapper.mapAclResourceTypeDto((KafkaAclResourceTypeDTO)dto.getResourceType()), dto.getResourceName(), ClusterMapper.mapPatternTypeDto((KafkaAclNamePatternTypeDTO)dto.getNamePatternType())), new AccessControlEntry(dto.getPrincipal(), dto.getHost(), AclOperation.valueOf((String)dto.getOperation().name()), AclPermissionType.valueOf((String)dto.getPermission().name())));
    }

    public static KafkaAclDTO toKafkaAclDto(AclBinding binding) {
        ResourcePattern pattern = binding.pattern();
        AccessControlEntryFilter filter = binding.toFilter().entryFilter();
        return new KafkaAclDTO().resourceType(ClusterMapper.mapAclResourceType((ResourceType)pattern.resourceType())).resourceName(pattern.name()).namePatternType(KafkaAclNamePatternTypeDTO.fromValue((String)pattern.patternType().name())).principal(filter.principal()).host(filter.host()).operation(ClusterMapper.mapAclOperation((AclOperation)filter.operation())).permission(KafkaAclDTO.PermissionEnum.fromValue((String)filter.permissionType().name()));
    }
}

