/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.emitter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.provectus.kafka.ui.emitter.OffsetsInfo;
import com.provectus.kafka.ui.emitter.SeekOperations;
import com.provectus.kafka.ui.model.ConsumerPosition;
import com.provectus.kafka.ui.model.SeekTypeDTO;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.TopicPartition;

/*
 * Exception performing whole class analysis ignored.
 */
public class SeekOperations {
    private final Consumer<?, ?> consumer;
    private final OffsetsInfo offsetsInfo;
    private final Map<TopicPartition, Long> offsetsForSeek;

    public static SeekOperations create(Consumer<?, ?> consumer, ConsumerPosition consumerPosition) {
        OffsetsInfo offsetsInfo = consumerPosition.getSeekTo() == null ? new OffsetsInfo(consumer, consumerPosition.getTopic()) : new OffsetsInfo(consumer, consumerPosition.getSeekTo().keySet());
        return new SeekOperations(consumer, offsetsInfo, SeekOperations.getOffsetsForSeek(consumer, (OffsetsInfo)offsetsInfo, (SeekTypeDTO)consumerPosition.getSeekType(), (Map)consumerPosition.getSeekTo()));
    }

    public void assignAndSeekNonEmptyPartitions() {
        this.consumer.assign(this.offsetsForSeek.keySet());
        this.offsetsForSeek.forEach((arg_0, arg_1) -> ((Consumer)this.consumer).seek(arg_0, arg_1));
    }

    public Map<TopicPartition, Long> getBeginOffsets() {
        return this.offsetsInfo.getBeginOffsets();
    }

    public Map<TopicPartition, Long> getEndOffsets() {
        return this.offsetsInfo.getEndOffsets();
    }

    public boolean assignedPartitionsFullyPolled() {
        return this.offsetsInfo.assignedPartitionsFullyPolled();
    }

    public long summaryOffsetsRange() {
        return this.offsetsInfo.summaryOffsetsRange();
    }

    public long offsetsProcessedFromSeek() {
        MutableLong count = new MutableLong();
        this.offsetsForSeek.forEach((tp, initialOffset) -> count.add(this.consumer.position(tp) - initialOffset));
        return count.getValue();
    }

    public Map<TopicPartition, Long> getOffsetsForSeek() {
        return this.offsetsForSeek;
    }

    @VisibleForTesting
    static Map<TopicPartition, Long> getOffsetsForSeek(Consumer<?, ?> consumer, OffsetsInfo offsetsInfo, SeekTypeDTO seekType, @Nullable Map<TopicPartition, Long> seekTo) {
        switch (1.$SwitchMap$com$provectus$kafka$ui$model$SeekTypeDTO[seekType.ordinal()]) {
            case 1: {
                return consumer.endOffsets((Collection)offsetsInfo.getNonEmptyPartitions());
            }
            case 2: {
                return consumer.beginningOffsets((Collection)offsetsInfo.getNonEmptyPartitions());
            }
            case 3: {
                Preconditions.checkNotNull(seekTo);
                return SeekOperations.fixOffsets((OffsetsInfo)offsetsInfo, seekTo);
            }
            case 4: {
                Preconditions.checkNotNull(seekTo);
                return SeekOperations.offsetsForTimestamp(consumer, (OffsetsInfo)offsetsInfo, seekTo);
            }
        }
        throw new IllegalStateException();
    }

    private static Map<TopicPartition, Long> fixOffsets(OffsetsInfo offsetsInfo, Map<TopicPartition, Long> offsets) {
        offsets = new HashMap<TopicPartition, Long>(offsets);
        offsets.keySet().retainAll(offsetsInfo.getNonEmptyPartitions());
        HashMap<TopicPartition, Long> result = new HashMap<TopicPartition, Long>();
        offsets.forEach((tp, targetOffset) -> {
            long endOffset = (Long)offsetsInfo.getEndOffsets().get(tp);
            long beginningOffset = (Long)offsetsInfo.getBeginOffsets().get(tp);
            if (targetOffset > endOffset) {
                targetOffset = endOffset;
            } else if (targetOffset < beginningOffset) {
                targetOffset = beginningOffset;
            }
            result.put((TopicPartition)tp, (Long)targetOffset);
        });
        return result;
    }

    private static Map<TopicPartition, Long> offsetsForTimestamp(Consumer<?, ?> consumer, OffsetsInfo offsetsInfo, Map<TopicPartition, Long> timestamps) {
        timestamps = new HashMap<TopicPartition, Long>(timestamps);
        timestamps.keySet().retainAll(offsetsInfo.getNonEmptyPartitions());
        return consumer.offsetsForTimes(timestamps).entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, e -> ((OffsetAndTimestamp)e.getValue()).offset()));
    }

    SeekOperations(Consumer<?, ?> consumer, OffsetsInfo offsetsInfo, Map<TopicPartition, Long> offsetsForSeek) {
        this.consumer = consumer;
        this.offsetsInfo = offsetsInfo;
        this.offsetsForSeek = offsetsForSeek;
    }
}

