/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.emitter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.RateLimiter;
import com.provectus.kafka.ui.config.ClustersProperties;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingThrottler {
    private static final Logger log = LoggerFactory.getLogger(PollingThrottler.class);
    private final String clusterName;
    private final RateLimiter rateLimiter;
    private boolean throttled;

    public static Supplier<PollingThrottler> throttlerSupplier(ClustersProperties.Cluster cluster) {
        Long rate = cluster.getPollingThrottleRate();
        if (rate == null || rate <= 0L) {
            return PollingThrottler::noop;
        }
        RateLimiter rateLimiter = RateLimiter.create((double)rate.longValue());
        return () -> new PollingThrottler(cluster.getName(), rateLimiter);
    }

    @VisibleForTesting
    public PollingThrottler(String clusterName, RateLimiter rateLimiter) {
        this.clusterName = clusterName;
        this.rateLimiter = rateLimiter;
    }

    public static PollingThrottler noop() {
        return new PollingThrottler("noop", RateLimiter.create((double)9.223372036854776E18));
    }

    public boolean throttleAfterPoll(int polledBytes) {
        if (polledBytes > 0) {
            double sleptSeconds = this.rateLimiter.acquire(polledBytes);
            if (!this.throttled && sleptSeconds > 0.0) {
                this.throttled = true;
                log.debug("Polling throttling enabled for cluster {} at rate {} bytes/sec", (Object)this.clusterName, (Object)this.rateLimiter.getRate());
                return true;
            }
        }
        return false;
    }
}

