/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.emitter;

import com.provectus.kafka.ui.config.ClustersProperties;
import com.provectus.kafka.ui.emitter.PollingThrottler;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Supplier;

public class PollingSettings {
    private static final Duration DEFAULT_POLL_TIMEOUT = Duration.ofMillis(1000L);
    private final Duration pollTimeout;
    private final Supplier<PollingThrottler> throttlerSupplier;

    public static PollingSettings create(ClustersProperties.Cluster cluster, ClustersProperties clustersProperties) {
        ClustersProperties.PollingProperties pollingProps = Optional.ofNullable(clustersProperties.getPolling()).orElseGet(ClustersProperties.PollingProperties::new);
        Duration pollTimeout = pollingProps.getPollTimeoutMs() != null ? Duration.ofMillis(pollingProps.getPollTimeoutMs().intValue()) : DEFAULT_POLL_TIMEOUT;
        return new PollingSettings(pollTimeout, PollingThrottler.throttlerSupplier((ClustersProperties.Cluster)cluster));
    }

    public static PollingSettings createDefault() {
        return new PollingSettings(DEFAULT_POLL_TIMEOUT, PollingThrottler::noop);
    }

    private PollingSettings(Duration pollTimeout, Supplier<PollingThrottler> throttlerSupplier) {
        this.pollTimeout = pollTimeout;
        this.throttlerSupplier = throttlerSupplier;
    }

    public Duration getPollTimeout() {
        return this.pollTimeout;
    }

    public PollingThrottler getPollingThrottler() {
        return (PollingThrottler)this.throttlerSupplier.get();
    }
}

