/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.emitter;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OffsetsInfo {
    private static final Logger log = LoggerFactory.getLogger(OffsetsInfo.class);
    private final Consumer<?, ?> consumer;
    private final Map<TopicPartition, Long> beginOffsets;
    private final Map<TopicPartition, Long> endOffsets;
    private final Set<TopicPartition> nonEmptyPartitions = new HashSet();
    private final Set<TopicPartition> emptyPartitions = new HashSet();

    OffsetsInfo(Consumer<?, ?> consumer, String topic) {
        this(consumer, consumer.partitionsFor(topic).stream().map(pi -> new TopicPartition(topic, pi.partition())).toList());
    }

    OffsetsInfo(Consumer<?, ?> consumer, Collection<TopicPartition> targetPartitions) {
        this.consumer = consumer;
        this.beginOffsets = consumer.beginningOffsets(targetPartitions);
        this.endOffsets = consumer.endOffsets(targetPartitions);
        this.endOffsets.forEach((tp, endOffset) -> {
            Long beginningOffset = (Long)this.beginOffsets.get(tp);
            if (endOffset > beginningOffset) {
                this.nonEmptyPartitions.add(tp);
            } else {
                this.emptyPartitions.add(tp);
            }
        });
    }

    boolean assignedPartitionsFullyPolled() {
        for (TopicPartition tp : this.consumer.assignment()) {
            Preconditions.checkArgument((boolean)this.endOffsets.containsKey(tp));
            if ((Long)this.endOffsets.get(tp) <= this.consumer.position(tp)) continue;
            return false;
        }
        return true;
    }

    long summaryOffsetsRange() {
        MutableLong cnt = new MutableLong();
        this.nonEmptyPartitions.forEach(tp -> cnt.add((Long)this.endOffsets.get(tp) - (Long)this.beginOffsets.get(tp)));
        return cnt.getValue();
    }

    public Consumer<?, ?> getConsumer() {
        return this.consumer;
    }

    public Map<TopicPartition, Long> getBeginOffsets() {
        return this.beginOffsets;
    }

    public Map<TopicPartition, Long> getEndOffsets() {
        return this.endOffsets;
    }

    public Set<TopicPartition> getNonEmptyPartitions() {
        return this.nonEmptyPartitions;
    }

    public Set<TopicPartition> getEmptyPartitions() {
        return this.emptyPartitions;
    }
}

