/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.emitter;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.provectus.kafka.ui.emitter.PolledRecords;
import com.provectus.kafka.ui.emitter.PollingThrottler;
import com.provectus.kafka.ui.util.ApplicationMetrics;
import java.time.Duration;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.BytesDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.Bytes;

public class EnhancedConsumer
extends KafkaConsumer<Bytes, Bytes> {
    private final PollingThrottler throttler;
    private final ApplicationMetrics metrics;
    private String pollingTopic;

    public EnhancedConsumer(Properties properties, PollingThrottler throttler, ApplicationMetrics metrics) {
        super(properties, (Deserializer)new BytesDeserializer(), (Deserializer)new BytesDeserializer());
        this.throttler = throttler;
        this.metrics = metrics;
        metrics.activeConsumers().incrementAndGet();
    }

    public PolledRecords pollEnhanced(Duration dur) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        ConsumerRecords polled = this.poll(dur);
        PolledRecords polledEnhanced = PolledRecords.create((ConsumerRecords)polled, (Duration)stopwatch.elapsed());
        boolean throttled = this.throttler.throttleAfterPoll(polledEnhanced.bytes());
        this.metrics.meterPolledRecords(this.pollingTopic, polledEnhanced, throttled);
        return polledEnhanced;
    }

    public void assign(Collection<TopicPartition> partitions) {
        super.assign(partitions);
        Set assignedTopics = partitions.stream().map(TopicPartition::topic).collect(Collectors.toSet());
        Preconditions.checkState((assignedTopics.size() == 1 ? 1 : 0) != 0);
        this.pollingTopic = (String)assignedTopics.iterator().next();
    }

    public void subscribe(Pattern pattern) {
        throw new UnsupportedOperationException();
    }

    public void subscribe(Collection<String> topics) {
        throw new UnsupportedOperationException();
    }

    public void subscribe(Pattern pattern, ConsumerRebalanceListener listener) {
        throw new UnsupportedOperationException();
    }

    public void subscribe(Collection<String> topics, ConsumerRebalanceListener listener) {
        throw new UnsupportedOperationException();
    }

    public void close(Duration timeout) {
        this.metrics.activeConsumers().decrementAndGet();
        super.close(timeout);
    }
}

