/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.emitter;

import com.provectus.kafka.ui.emitter.PolledRecords;
import com.provectus.kafka.ui.model.TopicMessageConsumingDTO;
import com.provectus.kafka.ui.model.TopicMessageEventDTO;
import reactor.core.publisher.FluxSink;

class ConsumingStats {
    private long bytes = 0L;
    private int records = 0;
    private long elapsed = 0L;
    private int filterApplyErrors = 0;

    ConsumingStats() {
    }

    void sendConsumingEvt(FluxSink<TopicMessageEventDTO> sink, PolledRecords polledRecords) {
        this.bytes += (long)polledRecords.bytes();
        this.records += polledRecords.count();
        this.elapsed += polledRecords.elapsed().toMillis();
        sink.next((Object)new TopicMessageEventDTO().type(TopicMessageEventDTO.TypeEnum.CONSUMING).consuming(this.createConsumingStats()));
    }

    void incFilterApplyError() {
        ++this.filterApplyErrors;
    }

    void sendFinishEvent(FluxSink<TopicMessageEventDTO> sink) {
        sink.next((Object)new TopicMessageEventDTO().type(TopicMessageEventDTO.TypeEnum.DONE).consuming(this.createConsumingStats()));
    }

    private TopicMessageConsumingDTO createConsumingStats() {
        return new TopicMessageConsumingDTO().bytesConsumed(Long.valueOf(this.bytes)).elapsedMs(Long.valueOf(this.elapsed)).isCancelled(Boolean.valueOf(false)).filterApplyErrors(Integer.valueOf(this.filterApplyErrors)).messagesConsumed(Integer.valueOf(this.records));
    }
}

