/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.controller;

import com.provectus.kafka.ui.util.ResourceUtil;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@RestController
public class StaticController {
    private static final Logger log = LoggerFactory.getLogger(StaticController.class);
    @Value(value="classpath:static/index.html")
    private Resource indexFile;
    @Value(value="classpath:static/manifest.json")
    private Resource manifestFile;
    private final AtomicReference<String> renderedIndexFile = new AtomicReference();
    private final AtomicReference<String> renderedManifestFile = new AtomicReference();

    @GetMapping(value={"/index.html"}, produces={"text/html"})
    public Mono<ResponseEntity<String>> getIndex(ServerWebExchange exchange) {
        return Mono.just((Object)ResponseEntity.ok((Object)this.getRenderedFile(exchange, this.renderedIndexFile, this.indexFile)));
    }

    @GetMapping(value={"/manifest.json"}, produces={"application/json"})
    public Mono<ResponseEntity<String>> getManifest(ServerWebExchange exchange) {
        return Mono.just((Object)ResponseEntity.ok((Object)this.getRenderedFile(exchange, this.renderedManifestFile, this.manifestFile)));
    }

    public String getRenderedFile(ServerWebExchange exchange, AtomicReference<String> renderedFile, Resource file) {
        String rendered = renderedFile.get();
        if (rendered == null) {
            rendered = this.buildFile(file, exchange.getRequest().getPath().contextPath().value());
            if (renderedFile.compareAndSet(null, rendered)) {
                return rendered;
            }
            return renderedFile.get();
        }
        return rendered;
    }

    private String buildFile(Resource file, String contextPath) {
        return ResourceUtil.readAsString((Resource)file).replace("\"assets/", "\"" + contextPath + "/assets/").replace("PUBLIC-PATH-VARIABLE", contextPath);
    }
}

