/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.controller;

import com.provectus.kafka.ui.api.ConsumerGroupsApi;
import com.provectus.kafka.ui.controller.AbstractController;
import com.provectus.kafka.ui.controller.ConsumerGroupsController;
import com.provectus.kafka.ui.exception.ValidationException;
import com.provectus.kafka.ui.mapper.ConsumerGroupMapper;
import com.provectus.kafka.ui.model.ConsumerGroupDTO;
import com.provectus.kafka.ui.model.ConsumerGroupDetailsDTO;
import com.provectus.kafka.ui.model.ConsumerGroupOffsetsResetDTO;
import com.provectus.kafka.ui.model.ConsumerGroupOrderingDTO;
import com.provectus.kafka.ui.model.ConsumerGroupsPageResponseDTO;
import com.provectus.kafka.ui.model.KafkaCluster;
import com.provectus.kafka.ui.model.PartitionOffsetDTO;
import com.provectus.kafka.ui.model.SortOrderDTO;
import com.provectus.kafka.ui.model.rbac.AccessContext;
import com.provectus.kafka.ui.model.rbac.permission.ConsumerGroupAction;
import com.provectus.kafka.ui.model.rbac.permission.TopicAction;
import com.provectus.kafka.ui.service.ConsumerGroupService;
import com.provectus.kafka.ui.service.OffsetsResetService;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
public class ConsumerGroupsController
extends AbstractController
implements ConsumerGroupsApi {
    private static final Logger log = LoggerFactory.getLogger(ConsumerGroupsController.class);
    private final ConsumerGroupService consumerGroupService;
    private final OffsetsResetService offsetsResetService;
    @Value(value="${consumer.groups.page.size:25}")
    private int defaultConsumerGroupsPageSize;

    public Mono<ResponseEntity<Void>> deleteConsumerGroup(String clusterName, String id, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).consumerGroup(id).consumerGroupActions(new ConsumerGroupAction[]{ConsumerGroupAction.DELETE}).operationName("deleteConsumerGroup").build();
        return this.validateAccess(context).then(this.consumerGroupService.deleteConsumerGroupById(this.getCluster(clusterName), id)).doOnEach(sig -> this.audit(context, sig)).thenReturn((Object)ResponseEntity.ok().build());
    }

    public Mono<ResponseEntity<ConsumerGroupDetailsDTO>> getConsumerGroup(String clusterName, String consumerGroupId, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).consumerGroup(consumerGroupId).consumerGroupActions(new ConsumerGroupAction[]{ConsumerGroupAction.VIEW}).operationName("getConsumerGroup").build();
        return this.validateAccess(context).then(this.consumerGroupService.getConsumerGroupDetail(this.getCluster(clusterName), consumerGroupId).map(ConsumerGroupMapper::toDetailsDto).map(ResponseEntity::ok)).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<Flux<ConsumerGroupDTO>>> getTopicConsumerGroups(String clusterName, String topicName, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).topic(topicName).topicActions(new TopicAction[]{TopicAction.VIEW}).operationName("getTopicConsumerGroups").build();
        Mono job = this.consumerGroupService.getConsumerGroupsForTopic(this.getCluster(clusterName), topicName).flatMapMany(Flux::fromIterable).filterWhen(cg -> this.accessControlService.isConsumerGroupAccessible(cg.getGroupId(), clusterName)).map(ConsumerGroupMapper::toDto).collectList().map(Flux::fromIterable).map(ResponseEntity::ok).switchIfEmpty(Mono.just((Object)ResponseEntity.notFound().build()));
        return this.validateAccess(context).then(job).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<ConsumerGroupsPageResponseDTO>> getConsumerGroupsPage(String clusterName, Integer page, Integer perPage, String search, ConsumerGroupOrderingDTO orderBy, SortOrderDTO sortOrderDto, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).operationName("getConsumerGroupsPage").build();
        return this.validateAccess(context).then(this.consumerGroupService.getConsumerGroupsPage(this.getCluster(clusterName), Optional.ofNullable(page).filter(i -> i > 0).orElse(1).intValue(), Optional.ofNullable(perPage).filter(i -> i > 0).orElse(this.defaultConsumerGroupsPageSize).intValue(), search, Optional.ofNullable(orderBy).orElse(ConsumerGroupOrderingDTO.NAME), Optional.ofNullable(sortOrderDto).orElse(SortOrderDTO.ASC)).map(arg_0 -> this.convertPage(arg_0)).map(ResponseEntity::ok)).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<Void>> resetConsumerGroupOffsets(String clusterName, String group, Mono<ConsumerGroupOffsetsResetDTO> resetDto, ServerWebExchange exchange) {
        return resetDto.flatMap(reset -> {
            AccessContext context = AccessContext.builder().cluster(clusterName).topic(reset.getTopic()).topicActions(new TopicAction[]{TopicAction.VIEW}).consumerGroupActions(new ConsumerGroupAction[]{ConsumerGroupAction.RESET_OFFSETS}).operationName("resetConsumerGroupOffsets").build();
            Supplier<Mono> mono = () -> {
                KafkaCluster cluster = this.getCluster(clusterName);
                switch (1.$SwitchMap$com$provectus$kafka$ui$model$ConsumerGroupOffsetsResetTypeDTO[reset.getResetType().ordinal()]) {
                    case 1: {
                        return this.offsetsResetService.resetToEarliest(cluster, group, reset.getTopic(), (Collection)reset.getPartitions());
                    }
                    case 2: {
                        return this.offsetsResetService.resetToLatest(cluster, group, reset.getTopic(), (Collection)reset.getPartitions());
                    }
                    case 3: {
                        if (reset.getResetToTimestamp() == null) {
                            return Mono.error((Throwable)new ValidationException("resetToTimestamp is required when TIMESTAMP reset type used"));
                        }
                        return this.offsetsResetService.resetToTimestamp(cluster, group, reset.getTopic(), (Collection)reset.getPartitions(), reset.getResetToTimestamp().longValue());
                    }
                    case 4: {
                        if (CollectionUtils.isEmpty((Collection)reset.getPartitionsOffsets())) {
                            return Mono.error((Throwable)new ValidationException("partitionsOffsets is required when OFFSET reset type used"));
                        }
                        Map<Integer, Long> offsets = reset.getPartitionsOffsets().stream().collect(Collectors.toMap(PartitionOffsetDTO::getPartition, PartitionOffsetDTO::getOffset));
                        return this.offsetsResetService.resetToOffsets(cluster, group, reset.getTopic(), offsets);
                    }
                }
                return Mono.error((Throwable)new ValidationException("Unknown resetType " + reset.getResetType()));
            };
            return this.validateAccess(context).then(mono.get()).doOnEach(sig -> this.audit(context, sig));
        }).thenReturn((Object)ResponseEntity.ok().build());
    }

    private ConsumerGroupsPageResponseDTO convertPage(ConsumerGroupService.ConsumerGroupsPage consumerGroupConsumerGroupsPage) {
        return new ConsumerGroupsPageResponseDTO().pageCount(Integer.valueOf(consumerGroupConsumerGroupsPage.totalPages())).consumerGroups(consumerGroupConsumerGroupsPage.consumerGroups().stream().map(ConsumerGroupMapper::toDto).toList());
    }

    public ConsumerGroupsController(ConsumerGroupService consumerGroupService, OffsetsResetService offsetsResetService) {
        this.consumerGroupService = consumerGroupService;
        this.offsetsResetService = offsetsResetService;
    }
}

