/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.controller;

import com.provectus.kafka.ui.api.ClustersApi;
import com.provectus.kafka.ui.controller.AbstractController;
import com.provectus.kafka.ui.model.ClusterDTO;
import com.provectus.kafka.ui.model.ClusterMetricsDTO;
import com.provectus.kafka.ui.model.ClusterStatsDTO;
import com.provectus.kafka.ui.model.rbac.AccessContext;
import com.provectus.kafka.ui.service.ClusterService;
import com.provectus.kafka.ui.service.rbac.AccessControlService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
public class ClustersController
extends AbstractController
implements ClustersApi {
    private static final Logger log = LoggerFactory.getLogger(ClustersController.class);
    private final ClusterService clusterService;

    public Mono<ResponseEntity<Flux<ClusterDTO>>> getClusters(ServerWebExchange exchange) {
        Flux job = Flux.fromIterable((Iterable)this.clusterService.getClusters()).filterWhen(arg_0 -> ((AccessControlService)this.accessControlService).isClusterAccessible(arg_0));
        return Mono.just((Object)ResponseEntity.ok((Object)job));
    }

    public Mono<ResponseEntity<ClusterMetricsDTO>> getClusterMetrics(String clusterName, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).operationName("getClusterMetrics").build();
        return this.validateAccess(context).then(this.clusterService.getClusterMetrics(this.getCluster(clusterName)).map(ResponseEntity::ok).onErrorReturn((Object)ResponseEntity.notFound().build())).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<ClusterStatsDTO>> getClusterStats(String clusterName, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).operationName("getClusterStats").build();
        return this.validateAccess(context).then(this.clusterService.getClusterStats(this.getCluster(clusterName)).map(ResponseEntity::ok).onErrorReturn((Object)ResponseEntity.notFound().build())).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<ClusterDTO>> updateClusterInfo(String clusterName, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).operationName("updateClusterInfo").build();
        return this.validateAccess(context).then(this.clusterService.updateCluster(this.getCluster(clusterName)).map(ResponseEntity::ok)).doOnEach(sig -> this.audit(context, sig));
    }

    public ClustersController(ClusterService clusterService) {
        this.clusterService = clusterService;
    }
}

