/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.controller;

import com.provectus.kafka.ui.api.BrokersApi;
import com.provectus.kafka.ui.controller.AbstractController;
import com.provectus.kafka.ui.mapper.ClusterMapper;
import com.provectus.kafka.ui.model.BrokerConfigDTO;
import com.provectus.kafka.ui.model.BrokerConfigItemDTO;
import com.provectus.kafka.ui.model.BrokerDTO;
import com.provectus.kafka.ui.model.BrokerLogdirUpdateDTO;
import com.provectus.kafka.ui.model.BrokerMetricsDTO;
import com.provectus.kafka.ui.model.BrokersLogdirsDTO;
import com.provectus.kafka.ui.model.rbac.AccessContext;
import com.provectus.kafka.ui.model.rbac.permission.ClusterConfigAction;
import com.provectus.kafka.ui.service.BrokerService;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
public class BrokersController
extends AbstractController
implements BrokersApi {
    private static final Logger log = LoggerFactory.getLogger(BrokersController.class);
    private static final String BROKER_ID = "brokerId";
    private final BrokerService brokerService;
    private final ClusterMapper clusterMapper;

    public Mono<ResponseEntity<Flux<BrokerDTO>>> getBrokers(String clusterName, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).operationName("getBrokers").build();
        Flux job = this.brokerService.getBrokers(this.getCluster(clusterName)).map(arg_0 -> ((ClusterMapper)this.clusterMapper).toBrokerDto(arg_0));
        return this.validateAccess(context).thenReturn((Object)ResponseEntity.ok((Object)job)).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<BrokerMetricsDTO>> getBrokersMetrics(String clusterName, Integer id, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).operationName("getBrokersMetrics").operationParams(Map.of("id", id)).build();
        return this.validateAccess(context).then(this.brokerService.getBrokerMetrics(this.getCluster(clusterName), id).map(arg_0 -> ((ClusterMapper)this.clusterMapper).toBrokerMetrics(arg_0)).map(ResponseEntity::ok).onErrorReturn((Object)ResponseEntity.notFound().build())).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<Flux<BrokersLogdirsDTO>>> getAllBrokersLogdirs(String clusterName, @Nullable List<Integer> brokers, ServerWebExchange exchange) {
        List<Object> brokerIds = brokers == null ? List.of() : brokers;
        AccessContext context = AccessContext.builder().cluster(clusterName).operationName("getAllBrokersLogdirs").operationParams(Map.of("brokerIds", brokerIds)).build();
        return this.validateAccess(context).thenReturn((Object)ResponseEntity.ok((Object)this.brokerService.getAllBrokersLogdirs(this.getCluster(clusterName), brokerIds))).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<Flux<BrokerConfigDTO>>> getBrokerConfig(String clusterName, Integer id, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).clusterConfigActions(new ClusterConfigAction[]{ClusterConfigAction.VIEW}).operationName("getBrokerConfig").operationParams(Map.of(BROKER_ID, id)).build();
        return this.validateAccess(context).thenReturn((Object)ResponseEntity.ok((Object)this.brokerService.getBrokerConfig(this.getCluster(clusterName), id).map(arg_0 -> ((ClusterMapper)this.clusterMapper).toBrokerConfig(arg_0)))).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<Void>> updateBrokerTopicPartitionLogDir(String clusterName, Integer id, Mono<BrokerLogdirUpdateDTO> brokerLogdir, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).clusterConfigActions(new ClusterConfigAction[]{ClusterConfigAction.VIEW, ClusterConfigAction.EDIT}).operationName("updateBrokerTopicPartitionLogDir").operationParams(Map.of(BROKER_ID, id)).build();
        return this.validateAccess(context).then(brokerLogdir.flatMap(bld -> this.brokerService.updateBrokerLogDir(this.getCluster(clusterName), id, bld)).map(ResponseEntity::ok)).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<Void>> updateBrokerConfigByName(String clusterName, Integer id, String name, Mono<BrokerConfigItemDTO> brokerConfig, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).clusterConfigActions(new ClusterConfigAction[]{ClusterConfigAction.VIEW, ClusterConfigAction.EDIT}).operationName("updateBrokerConfigByName").operationParams(Map.of(BROKER_ID, id)).build();
        return this.validateAccess(context).then(brokerConfig.flatMap(bci -> this.brokerService.updateBrokerConfigByName(this.getCluster(clusterName), id, name, bci.getValue())).map(ResponseEntity::ok)).doOnEach(sig -> this.audit(context, sig));
    }

    public BrokersController(BrokerService brokerService, ClusterMapper clusterMapper) {
        this.brokerService = brokerService;
        this.clusterMapper = clusterMapper;
    }
}

