/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.controller;

import com.provectus.kafka.ui.api.AclsApi;
import com.provectus.kafka.ui.controller.AbstractController;
import com.provectus.kafka.ui.mapper.ClusterMapper;
import com.provectus.kafka.ui.model.CreateConsumerAclDTO;
import com.provectus.kafka.ui.model.CreateProducerAclDTO;
import com.provectus.kafka.ui.model.CreateStreamAppAclDTO;
import com.provectus.kafka.ui.model.KafkaAclDTO;
import com.provectus.kafka.ui.model.KafkaAclNamePatternTypeDTO;
import com.provectus.kafka.ui.model.KafkaAclResourceTypeDTO;
import com.provectus.kafka.ui.model.rbac.AccessContext;
import com.provectus.kafka.ui.model.rbac.permission.AclAction;
import com.provectus.kafka.ui.service.acl.AclsService;
import java.util.Optional;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
public class AclsController
extends AbstractController
implements AclsApi {
    private final AclsService aclsService;

    public Mono<ResponseEntity<Void>> createAcl(String clusterName, Mono<KafkaAclDTO> kafkaAclDto, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).aclActions(new AclAction[]{AclAction.EDIT}).operationName("createAcl").build();
        return this.validateAccess(context).then(kafkaAclDto).map(ClusterMapper::toAclBinding).flatMap(binding -> this.aclsService.createAcl(this.getCluster(clusterName), binding)).doOnEach(sig -> this.audit(context, sig)).thenReturn((Object)ResponseEntity.ok().build());
    }

    public Mono<ResponseEntity<Void>> deleteAcl(String clusterName, Mono<KafkaAclDTO> kafkaAclDto, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).aclActions(new AclAction[]{AclAction.EDIT}).operationName("deleteAcl").build();
        return this.validateAccess(context).then(kafkaAclDto).map(ClusterMapper::toAclBinding).flatMap(binding -> this.aclsService.deleteAcl(this.getCluster(clusterName), binding)).doOnEach(sig -> this.audit(context, sig)).thenReturn((Object)ResponseEntity.ok().build());
    }

    public Mono<ResponseEntity<Flux<KafkaAclDTO>>> listAcls(String clusterName, KafkaAclResourceTypeDTO resourceTypeDto, String resourceName, KafkaAclNamePatternTypeDTO namePatternTypeDto, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).aclActions(new AclAction[]{AclAction.VIEW}).operationName("listAcls").build();
        ResourceType resourceType = Optional.ofNullable(resourceTypeDto).map(ClusterMapper::mapAclResourceTypeDto).orElse(ResourceType.ANY);
        PatternType namePatternType = Optional.ofNullable(namePatternTypeDto).map(ClusterMapper::mapPatternTypeDto).orElse(PatternType.ANY);
        ResourcePatternFilter filter = new ResourcePatternFilter(resourceType, resourceName, namePatternType);
        return this.validateAccess(context).then(Mono.just((Object)ResponseEntity.ok((Object)this.aclsService.listAcls(this.getCluster(clusterName), filter).map(ClusterMapper::toKafkaAclDto)))).doOnEach(sig -> this.audit(context, sig));
    }

    public Mono<ResponseEntity<String>> getAclAsCsv(String clusterName, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).aclActions(new AclAction[]{AclAction.VIEW}).operationName("getAclAsCsv").build();
        return this.validateAccess(context).then(this.aclsService.getAclAsCsvString(this.getCluster(clusterName)).map(ResponseEntity::ok).flatMap(Mono::just).doOnEach(sig -> this.audit(context, sig)));
    }

    public Mono<ResponseEntity<Void>> syncAclsCsv(String clusterName, Mono<String> csvMono, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).aclActions(new AclAction[]{AclAction.EDIT}).operationName("syncAclsCsv").build();
        return this.validateAccess(context).then(csvMono).flatMap(csv -> this.aclsService.syncAclWithAclCsv(this.getCluster(clusterName), csv)).doOnEach(sig -> this.audit(context, sig)).thenReturn((Object)ResponseEntity.ok().build());
    }

    public Mono<ResponseEntity<Void>> createConsumerAcl(String clusterName, Mono<CreateConsumerAclDTO> createConsumerAclDto, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).aclActions(new AclAction[]{AclAction.EDIT}).operationName("createConsumerAcl").build();
        return this.validateAccess(context).then(createConsumerAclDto).flatMap(req -> this.aclsService.createConsumerAcl(this.getCluster(clusterName), req)).doOnEach(sig -> this.audit(context, sig)).thenReturn((Object)ResponseEntity.ok().build());
    }

    public Mono<ResponseEntity<Void>> createProducerAcl(String clusterName, Mono<CreateProducerAclDTO> createProducerAclDto, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).aclActions(new AclAction[]{AclAction.EDIT}).operationName("createProducerAcl").build();
        return this.validateAccess(context).then(createProducerAclDto).flatMap(req -> this.aclsService.createProducerAcl(this.getCluster(clusterName), req)).doOnEach(sig -> this.audit(context, sig)).thenReturn((Object)ResponseEntity.ok().build());
    }

    public Mono<ResponseEntity<Void>> createStreamAppAcl(String clusterName, Mono<CreateStreamAppAclDTO> createStreamAppAclDto, ServerWebExchange exchange) {
        AccessContext context = AccessContext.builder().cluster(clusterName).aclActions(new AclAction[]{AclAction.EDIT}).operationName("createStreamAppAcl").build();
        return this.validateAccess(context).then(createStreamAppAclDto).flatMap(req -> this.aclsService.createStreamAppAcl(this.getCluster(clusterName), req)).doOnEach(sig -> this.audit(context, sig)).thenReturn((Object)ResponseEntity.ok().build());
    }

    public AclsController(AclsService aclsService) {
        this.aclsService = aclsService;
    }
}

