/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.config.auth.logout;

import com.provectus.kafka.ui.config.auth.OAuthProperties;
import com.provectus.kafka.ui.config.auth.condition.CognitoCondition;
import com.provectus.kafka.ui.config.auth.logout.LogoutSuccessHandler;
import com.provectus.kafka.ui.model.rbac.provider.Provider;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.web.server.WebSession;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

@Component
@Conditional(value={CognitoCondition.class})
public class CognitoLogoutSuccessHandler
implements LogoutSuccessHandler {
    public boolean isApplicable(String provider) {
        return Provider.Name.COGNITO.equalsIgnoreCase(provider);
    }

    public Mono<Void> handle(WebFilterExchange exchange, Authentication authentication, OAuthProperties.OAuth2Provider provider) {
        ServerHttpResponse response = exchange.getExchange().getResponse();
        response.setStatusCode((HttpStatusCode)HttpStatus.FOUND);
        URI requestUri = exchange.getExchange().getRequest().getURI();
        String fullUrl = UrlUtils.buildFullRequestUrl((String)requestUri.getScheme(), (String)requestUri.getHost(), (int)requestUri.getPort(), (String)requestUri.getPath(), (String)requestUri.getQuery());
        UriComponents baseUrl = UriComponentsBuilder.fromHttpUrl((String)fullUrl).replacePath("/").replaceQuery(null).fragment(null).build();
        Assert.isTrue((boolean)provider.getCustomParams().containsKey("logoutUrl"), (String)"Custom params should contain 'logoutUrl'");
        URI uri = UriComponentsBuilder.fromUri((URI)URI.create((String)provider.getCustomParams().get("logoutUrl"))).queryParam("client_id", new Object[]{provider.getClientId()}).queryParam("logout_uri", new Object[]{baseUrl}).encode(StandardCharsets.UTF_8).build().toUri();
        response.getHeaders().setLocation(uri);
        return exchange.getExchange().getSession().flatMap(WebSession::invalidate);
    }
}

