/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.config.auth;

import com.provectus.kafka.ui.config.auth.AbstractAuthSecurityConfig;
import com.provectus.kafka.ui.config.auth.OAuthProperties;
import com.provectus.kafka.ui.config.auth.OAuthPropertiesConverter;
import com.provectus.kafka.ui.config.auth.RbacOAuth2User;
import com.provectus.kafka.ui.config.auth.RbacOidcUser;
import com.provectus.kafka.ui.config.auth.logout.OAuthLogoutSuccessHandler;
import com.provectus.kafka.ui.service.rbac.AccessControlService;
import com.provectus.kafka.ui.service.rbac.extractor.ProviderAuthorityExtractor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientPropertiesMapper;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.method.configuration.EnableReactiveMethodSecurity;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcReactiveOAuth2UserService;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.web.server.logout.OidcClientInitiatedServerLogoutSuccessHandler;
import org.springframework.security.oauth2.client.registration.InMemoryReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.userinfo.DefaultReactiveOAuth2UserService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.client.userinfo.ReactiveOAuth2UserService;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.authentication.logout.ServerLogoutSuccessHandler;
import reactor.core.publisher.Mono;

@Configuration
@ConditionalOnProperty(value={"auth.type"}, havingValue="OAUTH2")
@EnableConfigurationProperties(value={OAuthProperties.class})
@EnableWebFluxSecurity
@EnableReactiveMethodSecurity
public class OAuthSecurityConfig
extends AbstractAuthSecurityConfig {
    private static final Logger log = LogManager.getLogger(OAuthSecurityConfig.class);
    private final OAuthProperties properties;

    @Bean
    public SecurityWebFilterChain configure(ServerHttpSecurity http, OAuthLogoutSuccessHandler logoutHandler) {
        log.info("Configuring OAUTH2 authentication.");
        return http.authorizeExchange(spec -> ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)spec.pathMatchers(AUTH_WHITELIST)).permitAll().anyExchange().authenticated()).oauth2Login(Customizer.withDefaults()).logout(spec -> spec.logoutSuccessHandler((ServerLogoutSuccessHandler)logoutHandler)).csrf(ServerHttpSecurity.CsrfSpec::disable).build();
    }

    @Bean
    public ReactiveOAuth2UserService<OidcUserRequest, OidcUser> customOidcUserService(AccessControlService acs) {
        OidcReactiveOAuth2UserService delegate = new OidcReactiveOAuth2UserService();
        return request -> delegate.loadUser(request).flatMap(user -> {
            OAuthProperties.OAuth2Provider provider = this.getProviderByProviderId(request.getClientRegistration().getRegistrationId());
            ProviderAuthorityExtractor extractor = this.getExtractor(provider, acs);
            if (extractor == null) {
                return Mono.just((Object)user);
            }
            return extractor.extract(acs, user, Map.of("request", request, "provider", provider)).map(groups -> new RbacOidcUser(user, (Collection)groups));
        });
    }

    @Bean
    public ReactiveOAuth2UserService<OAuth2UserRequest, OAuth2User> customOauth2UserService(AccessControlService acs) {
        DefaultReactiveOAuth2UserService delegate = new DefaultReactiveOAuth2UserService();
        return request -> delegate.loadUser(request).flatMap(user -> {
            OAuthProperties.OAuth2Provider provider = this.getProviderByProviderId(request.getClientRegistration().getRegistrationId());
            ProviderAuthorityExtractor extractor = this.getExtractor(provider, acs);
            if (extractor == null) {
                return Mono.just((Object)user);
            }
            return extractor.extract(acs, user, Map.of("request", request, "provider", provider)).map(groups -> new RbacOAuth2User(user, (Collection)groups));
        });
    }

    @Bean
    public InMemoryReactiveClientRegistrationRepository clientRegistrationRepository() {
        OAuth2ClientProperties props = OAuthPropertiesConverter.convertProperties((OAuthProperties)this.properties);
        ArrayList registrations = new ArrayList(new OAuth2ClientPropertiesMapper(props).asClientRegistrations().values());
        if (registrations.isEmpty()) {
            throw new IllegalArgumentException("OAuth2 authentication is enabled but no providers specified.");
        }
        return new InMemoryReactiveClientRegistrationRepository(registrations);
    }

    @Bean
    public ServerLogoutSuccessHandler defaultOidcLogoutHandler(ReactiveClientRegistrationRepository repository) {
        return new OidcClientInitiatedServerLogoutSuccessHandler(repository);
    }

    @Nullable
    private ProviderAuthorityExtractor getExtractor(OAuthProperties.OAuth2Provider provider, AccessControlService acs) {
        Optional<ProviderAuthorityExtractor> extractor = acs.getOauthExtractors().stream().filter(e -> e.isApplicable(provider.getProvider(), provider.getCustomParams())).findFirst();
        return extractor.orElse(null);
    }

    private OAuthProperties.OAuth2Provider getProviderByProviderId(String providerId) {
        return (OAuthProperties.OAuth2Provider)this.properties.getClient().get(providerId);
    }

    public OAuthSecurityConfig(OAuthProperties properties) {
        this.properties = properties;
    }
}

