/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.config.auth;

import com.provectus.kafka.ui.config.auth.OAuthProperties;
import jakarta.annotation.PostConstruct;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;

@ConfigurationProperties(value="auth.oauth2")
public class OAuthProperties {
    private Map<String, OAuth2Provider> client = new HashMap();

    @PostConstruct
    public void init() {
        this.getClient().values().forEach(provider -> {
            if (provider.getCustomParams() == null) {
                provider.setCustomParams(Collections.emptyMap());
            }
            if (provider.getScope() == null) {
                provider.setScope(Collections.emptySet());
            }
        });
        this.getClient().values().forEach(arg_0 -> this.validateProvider(arg_0));
    }

    private void validateProvider(OAuth2Provider provider) {
        Assert.hasText((String)provider.getClientId(), (String)"Client id must not be empty.");
        Assert.hasText((String)provider.getProvider(), (String)"Provider name must not be empty");
    }

    public Map<String, OAuth2Provider> getClient() {
        return this.client;
    }

    public void setClient(Map<String, OAuth2Provider> client) {
        this.client = client;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuthProperties)) {
            return false;
        }
        OAuthProperties other = (OAuthProperties)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Map this$client = this.getClient();
        Map other$client = other.getClient();
        return !(this$client == null ? other$client != null : !((Object)this$client).equals(other$client));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OAuthProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : ((Object)$client).hashCode());
        return result;
    }

    public String toString() {
        return "OAuthProperties(client=" + this.getClient() + ")";
    }
}

