/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.config.auth;

import com.provectus.kafka.ui.config.auth.AbstractAuthSecurityConfig;
import com.provectus.kafka.ui.config.auth.LdapProperties;
import com.provectus.kafka.ui.config.auth.LdapSecurityConfig;
import com.provectus.kafka.ui.service.rbac.AccessControlService;
import com.provectus.kafka.ui.service.rbac.extractor.RbacLdapAuthoritiesExtractor;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.ldap.LdapAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.authentication.ReactiveAuthenticationManagerAdapter;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.ldap.authentication.BindAuthenticator;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.authentication.ad.ActiveDirectoryLdapAuthenticationProvider;
import org.springframework.security.ldap.search.FilterBasedLdapUserSearch;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;
import org.springframework.security.web.server.SecurityWebFilterChain;

@Configuration
@EnableWebFluxSecurity
@ConditionalOnProperty(value={"auth.type"}, havingValue="LDAP")
@Import(value={LdapAutoConfiguration.class})
@EnableConfigurationProperties(value={LdapProperties.class})
public class LdapSecurityConfig {
    private static final Logger log = LoggerFactory.getLogger(LdapSecurityConfig.class);
    private final LdapProperties props;

    @Bean
    public ReactiveAuthenticationManager authenticationManager(BaseLdapPathContextSource contextSource, LdapAuthoritiesPopulator authoritiesExtractor, AccessControlService acs) {
        LdapAuthenticationProvider authenticationProvider;
        boolean rbacEnabled = acs.isRbacEnabled();
        BindAuthenticator ba = new BindAuthenticator(contextSource);
        if (this.props.getBase() != null) {
            ba.setUserDnPatterns(new String[]{this.props.getBase()});
        }
        if (this.props.getUserFilterSearchFilter() != null) {
            FilterBasedLdapUserSearch userSearch = new FilterBasedLdapUserSearch(this.props.getUserFilterSearchBase(), this.props.getUserFilterSearchFilter(), contextSource);
            ba.setUserSearch((LdapUserSearch)userSearch);
        }
        if (!this.props.isActiveDirectory()) {
            authenticationProvider = rbacEnabled ? new LdapAuthenticationProvider((LdapAuthenticator)ba, authoritiesExtractor) : new LdapAuthenticationProvider((LdapAuthenticator)ba);
        } else {
            authenticationProvider = new ActiveDirectoryLdapAuthenticationProvider(this.props.getActiveDirectoryDomain(), this.props.getUrls());
            authenticationProvider.setUseAuthenticationRequestCredentials(true);
        }
        if (rbacEnabled) {
            authenticationProvider.setUserDetailsContextMapper((UserDetailsContextMapper)new UserDetailsMapper());
        }
        ProviderManager am = new ProviderManager(List.of(authenticationProvider));
        return new ReactiveAuthenticationManagerAdapter((AuthenticationManager)am);
    }

    @Bean
    @Primary
    public BaseLdapPathContextSource contextSource() {
        LdapContextSource ctx = new LdapContextSource();
        ctx.setUrl(this.props.getUrls());
        ctx.setUserDn(this.props.getAdminUser());
        ctx.setPassword(this.props.getAdminPassword());
        ctx.afterPropertiesSet();
        return ctx;
    }

    @Bean
    @Primary
    public DefaultLdapAuthoritiesPopulator ldapAuthoritiesExtractor(ApplicationContext context, BaseLdapPathContextSource contextSource, AccessControlService acs) {
        boolean rbacEnabled;
        boolean bl = rbacEnabled = acs != null && acs.isRbacEnabled();
        Object extractor = rbacEnabled ? new RbacLdapAuthoritiesExtractor(context, contextSource, this.props.getGroupFilterSearchBase()) : new DefaultLdapAuthoritiesPopulator((ContextSource)contextSource, this.props.getGroupFilterSearchBase());
        Optional.ofNullable(this.props.getGroupFilterSearchFilter()).ifPresent(arg_0 -> ((DefaultLdapAuthoritiesPopulator)extractor).setGroupSearchFilter(arg_0));
        extractor.setRolePrefix("");
        extractor.setConvertToUpperCase(false);
        extractor.setSearchSubtree(true);
        return extractor;
    }

    @Bean
    public SecurityWebFilterChain configureLdap(ServerHttpSecurity http) {
        log.info("Configuring LDAP authentication.");
        if (this.props.isActiveDirectory()) {
            log.info("Active Directory support for LDAP has been enabled.");
        }
        return http.authorizeExchange(spec -> ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)spec.pathMatchers(AbstractAuthSecurityConfig.AUTH_WHITELIST)).permitAll().anyExchange().authenticated()).formLogin(Customizer.withDefaults()).logout(Customizer.withDefaults()).csrf(ServerHttpSecurity.CsrfSpec::disable).build();
    }

    public LdapSecurityConfig(LdapProperties props) {
        this.props = props;
    }
}

