/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.config.auth;

import com.provectus.kafka.ui.config.auth.AbstractAuthSecurityConfig;
import com.provectus.kafka.ui.util.EmptyRedirectStrategy;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.ServerRedirectStrategy;
import org.springframework.security.web.server.authentication.RedirectServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.ServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.logout.RedirectServerLogoutSuccessHandler;
import org.springframework.security.web.server.authentication.logout.ServerLogoutSuccessHandler;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;

@Configuration
@EnableWebFluxSecurity
@ConditionalOnProperty(value={"auth.type"}, havingValue="LOGIN_FORM")
public class BasicAuthSecurityConfig
extends AbstractAuthSecurityConfig {
    private static final Logger log = LoggerFactory.getLogger(BasicAuthSecurityConfig.class);
    public static final String LOGIN_URL = "/auth";
    public static final String LOGOUT_URL = "/auth?logout";

    @Bean
    public SecurityWebFilterChain configure(ServerHttpSecurity http) {
        log.info("Configuring LOGIN_FORM authentication.");
        RedirectServerAuthenticationSuccessHandler authHandler = new RedirectServerAuthenticationSuccessHandler();
        authHandler.setRedirectStrategy((ServerRedirectStrategy)new EmptyRedirectStrategy());
        RedirectServerLogoutSuccessHandler logoutSuccessHandler = new RedirectServerLogoutSuccessHandler();
        logoutSuccessHandler.setLogoutSuccessUrl(URI.create(LOGOUT_URL));
        return http.authorizeExchange(spec -> ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)spec.pathMatchers(AUTH_WHITELIST)).permitAll().anyExchange().authenticated()).formLogin(spec -> spec.loginPage(LOGIN_URL).authenticationSuccessHandler((ServerAuthenticationSuccessHandler)authHandler)).logout(spec -> spec.logoutSuccessHandler((ServerLogoutSuccessHandler)logoutSuccessHandler).requiresLogout(ServerWebExchangeMatchers.pathMatchers((HttpMethod)HttpMethod.GET, (String[])new String[]{"/logout"}))).csrf(ServerHttpSecurity.CsrfSpec::disable).build();
    }
}

