/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.config;

import com.provectus.kafka.ui.exception.ClusterNotFoundException;
import com.provectus.kafka.ui.exception.ReadOnlyModeException;
import com.provectus.kafka.ui.model.KafkaCluster;
import com.provectus.kafka.ui.service.ClustersStorage;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Order
@Component
public class ReadOnlyModeFilter
implements WebFilter {
    private static final Pattern CLUSTER_NAME_REGEX = Pattern.compile("/api/clusters/(?<clusterName>[^/]++)");
    private final ClustersStorage clustersStorage;

    @NotNull
    public Mono<Void> filter(ServerWebExchange exchange, @NotNull WebFilterChain chain) {
        boolean isSafeMethod;
        boolean bl = isSafeMethod = exchange.getRequest().getMethod() == HttpMethod.GET;
        if (isSafeMethod) {
            return chain.filter(exchange);
        }
        String path = exchange.getRequest().getPath().pathWithinApplication().value();
        String decodedPath = URLDecoder.decode(path, StandardCharsets.UTF_8);
        Matcher matcher = CLUSTER_NAME_REGEX.matcher(decodedPath);
        if (!matcher.find()) {
            return chain.filter(exchange);
        }
        String clusterName = matcher.group("clusterName");
        KafkaCluster kafkaCluster = (KafkaCluster)this.clustersStorage.getClusterByName(clusterName).orElseThrow(() -> new ClusterNotFoundException(String.format("No cluster for name '%s'", clusterName)));
        if (!kafkaCluster.isReadOnly()) {
            return chain.filter(exchange);
        }
        return Mono.error(ReadOnlyModeException::new);
    }

    public ReadOnlyModeFilter(ClustersStorage clustersStorage) {
        this.clustersStorage = clustersStorage;
    }
}

