/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.config;

import java.util.Collections;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullableModule;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.server.reactive.ContextPathCompositeHandler;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.jmx.export.MBeanExporter;
import org.springframework.util.StringUtils;
import org.springframework.web.server.adapter.WebHttpHandlerBuilder;

@Configuration
public class Config {
    private final ApplicationContext applicationContext;
    private final ServerProperties serverProperties;

    @Bean
    public HttpHandler httpHandler(ObjectProvider<WebFluxProperties> propsProvider) {
        String basePath = this.serverProperties.getServlet().getContextPath();
        HttpHandler httpHandler = WebHttpHandlerBuilder.applicationContext((ApplicationContext)this.applicationContext).build();
        if (StringUtils.hasText((String)basePath)) {
            Map<String, HttpHandler> handlersMap = Collections.singletonMap(basePath, httpHandler);
            return new ContextPathCompositeHandler(handlersMap);
        }
        return httpHandler;
    }

    @Bean
    public MBeanExporter exporter() {
        MBeanExporter exporter = new MBeanExporter();
        exporter.setAutodetect(true);
        exporter.setExcludedBeans(new String[]{"pool"});
        return exporter;
    }

    @Bean
    public JsonNullableModule jsonNullableModule() {
        return new JsonNullableModule();
    }

    public Config(ApplicationContext applicationContext, ServerProperties serverProperties) {
        this.applicationContext = applicationContext;
        this.serverProperties = serverProperties;
    }
}

