# Generated by Django 3.1.3 on 2020-11-15 22:54

import django.db.models.deletion
from django.db import migrations
from django.db import models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("documents", "1002_auto_20201111_1105"),
    ]

    operations = [
        migrations.CreateModel(
            name="MailAccount",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=256, unique=True)),
                ("imap_server", models.CharField(max_length=256)),
                ("imap_port", models.IntegerField(blank=True, null=True)),
                (
                    "imap_security",
                    models.PositiveIntegerField(
                        choices=[
                            (1, "No encryption"),
                            (2, "Use SSL"),
                            (3, "Use STARTTLS"),
                        ],
                        default=2,
                    ),
                ),
                ("username", models.CharField(max_length=256)),
                ("password", models.CharField(max_length=256)),
            ],
        ),
        migrations.CreateModel(
            name="MailRule",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=256)),
                ("folder", models.CharField(default="INBOX", max_length=256)),
                (
                    "filter_from",
                    models.CharField(blank=True, max_length=256, null=True),
                ),
                (
                    "filter_subject",
                    models.CharField(blank=True, max_length=256, null=True),
                ),
                (
                    "filter_body",
                    models.CharField(blank=True, max_length=256, null=True),
                ),
                ("maximum_age", models.PositiveIntegerField(default=30)),
                (
                    "action",
                    models.PositiveIntegerField(
                        choices=[
                            (1, "Delete"),
                            (2, "Move to specified folder"),
                            (3, "Mark as read, don't process read mails"),
                            (4, "Flag the mail, don't process flagged mails"),
                        ],
                        default=3,
                        help_text="The action applied to the mail. This action is only performed when documents were consumed from the mail. Mails without attachments will remain entirely untouched.",
                    ),
                ),
                (
                    "action_parameter",
                    models.CharField(
                        blank=True,
                        help_text="Additional parameter for the action selected above, i.e., the target folder of the move to folder action.",
                        max_length=256,
                        null=True,
                    ),
                ),
                (
                    "assign_title_from",
                    models.PositiveIntegerField(
                        choices=[
                            (1, "Use subject as title"),
                            (2, "Use attachment filename as title"),
                        ],
                        default=1,
                    ),
                ),
                (
                    "assign_correspondent_from",
                    models.PositiveIntegerField(
                        choices=[
                            (1, "Do not assign a correspondent"),
                            (2, "Use mail address"),
                            (3, "Use name (or mail address if not available)"),
                            (4, "Use correspondent selected below"),
                        ],
                        default=1,
                    ),
                ),
                (
                    "account",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="rules",
                        to="paperless_mail.mailaccount",
                    ),
                ),
                (
                    "assign_correspondent",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="documents.correspondent",
                    ),
                ),
                (
                    "assign_document_type",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="documents.documenttype",
                    ),
                ),
                (
                    "assign_tag",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="documents.tag",
                    ),
                ),
            ],
        ),
    ]
