# Generated by Django 5.1.6 on 2025-02-21 16:34

import multiselectfield.db.fields
from django.db import migrations
from django.db import models


# WebUI source was added, so all existing APIUpload sources should be updated to include WebUI
def update_workflow_sources(apps, schema_editor):
    WorkflowTrigger = apps.get_model("documents", "WorkflowTrigger")
    for trigger in WorkflowTrigger.objects.all():
        sources = list(trigger.sources)
        if 2 in sources:
            sources.append(4)
            trigger.sources = sources
            trigger.save()


def make_existing_tasks_consume_auto(apps, schema_editor):
    PaperlessTask = apps.get_model("documents", "PaperlessTask")
    PaperlessTask.objects.all().update(type="auto_task", task_name="consume_file")


class Migration(migrations.Migration):
    dependencies = [
        ("documents", "1062_alter_savedviewfilterrule_rule_type"),
    ]

    operations = [
        migrations.AddField(
            model_name="paperlesstask",
            name="type",
            field=models.CharField(
                choices=[
                    ("auto_task", "Auto Task"),
                    ("scheduled_task", "Scheduled Task"),
                    ("manual_task", "Manual Task"),
                ],
                default="auto_task",
                help_text="The type of task that was run",
                max_length=30,
                verbose_name="Task Type",
            ),
        ),
        migrations.AlterField(
            model_name="paperlesstask",
            name="task_name",
            field=models.CharField(
                choices=[
                    ("consume_file", "Consume File"),
                    ("train_classifier", "Train Classifier"),
                    ("check_sanity", "Check Sanity"),
                    ("index_optimize", "Index Optimize"),
                ],
                help_text="Name of the task that was run",
                max_length=255,
                null=True,
                verbose_name="Task Name",
            ),
        ),
        migrations.RunPython(
            code=make_existing_tasks_consume_auto,
            reverse_code=migrations.RunPython.noop,
        ),
        migrations.AlterField(
            model_name="workflowactionwebhook",
            name="url",
            field=models.CharField(
                help_text="The destination URL for the notification.",
                max_length=256,
                verbose_name="webhook url",
            ),
        ),
        migrations.AlterField(
            model_name="workflowtrigger",
            name="sources",
            field=multiselectfield.db.fields.MultiSelectField(
                choices=[
                    (1, "Consume Folder"),
                    (2, "Api Upload"),
                    (3, "Mail Fetch"),
                    (4, "Web UI"),
                ],
                default="1,2,3,4",
                max_length=7,
            ),
        ),
        migrations.RunPython(
            code=update_workflow_sources,
            reverse_code=migrations.RunPython.noop,
        ),
    ]
