# Generated by Django 4.2.13 on 2024-06-28 18:09

import django.db.models.deletion
from django.conf import settings
from django.db import migrations
from django.db import models


class Migration(migrations.Migration):
    replaces = [
        ("documents", "1016_auto_20210317_1351"),
        ("documents", "1017_alter_savedviewfilterrule_rule_type"),
        ("documents", "1018_alter_savedviewfilterrule_value"),
        ("documents", "1019_uisettings"),
        ("documents", "1019_storagepath_document_storage_path"),
        ("documents", "1020_merge_20220518_1839"),
    ]

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("documents", "1015_remove_null_characters"),
    ]

    operations = [
        migrations.AlterField(
            model_name="savedview",
            name="sort_field",
            field=models.CharField(
                blank=True,
                max_length=128,
                null=True,
                verbose_name="sort field",
            ),
        ),
        migrations.AlterField(
            model_name="savedviewfilterrule",
            name="rule_type",
            field=models.PositiveIntegerField(
                choices=[
                    (0, "title contains"),
                    (1, "content contains"),
                    (2, "ASN is"),
                    (3, "correspondent is"),
                    (4, "document type is"),
                    (5, "is in inbox"),
                    (6, "has tag"),
                    (7, "has any tag"),
                    (8, "created before"),
                    (9, "created after"),
                    (10, "created year is"),
                    (11, "created month is"),
                    (12, "created day is"),
                    (13, "added before"),
                    (14, "added after"),
                    (15, "modified before"),
                    (16, "modified after"),
                    (17, "does not have tag"),
                    (18, "does not have ASN"),
                    (19, "title or content contains"),
                    (20, "fulltext query"),
                    (21, "more like this"),
                ],
                verbose_name="rule type",
            ),
        ),
        migrations.AlterField(
            model_name="savedviewfilterrule",
            name="rule_type",
            field=models.PositiveIntegerField(
                choices=[
                    (0, "title contains"),
                    (1, "content contains"),
                    (2, "ASN is"),
                    (3, "correspondent is"),
                    (4, "document type is"),
                    (5, "is in inbox"),
                    (6, "has tag"),
                    (7, "has any tag"),
                    (8, "created before"),
                    (9, "created after"),
                    (10, "created year is"),
                    (11, "created month is"),
                    (12, "created day is"),
                    (13, "added before"),
                    (14, "added after"),
                    (15, "modified before"),
                    (16, "modified after"),
                    (17, "does not have tag"),
                    (18, "does not have ASN"),
                    (19, "title or content contains"),
                    (20, "fulltext query"),
                    (21, "more like this"),
                    (22, "has tags in"),
                ],
                verbose_name="rule type",
            ),
        ),
        migrations.AlterField(
            model_name="savedviewfilterrule",
            name="value",
            field=models.CharField(
                blank=True,
                max_length=255,
                null=True,
                verbose_name="value",
            ),
        ),
        migrations.CreateModel(
            name="UiSettings",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("settings", models.JSONField(null=True)),
                (
                    "user",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="ui_settings",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="StoragePath",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(max_length=128, unique=True, verbose_name="name"),
                ),
                (
                    "match",
                    models.CharField(blank=True, max_length=256, verbose_name="match"),
                ),
                (
                    "matching_algorithm",
                    models.PositiveIntegerField(
                        choices=[
                            (1, "Any word"),
                            (2, "All words"),
                            (3, "Exact match"),
                            (4, "Regular expression"),
                            (5, "Fuzzy word"),
                            (6, "Automatic"),
                        ],
                        default=1,
                        verbose_name="matching algorithm",
                    ),
                ),
                (
                    "is_insensitive",
                    models.BooleanField(default=True, verbose_name="is insensitive"),
                ),
                ("path", models.CharField(max_length=512, verbose_name="path")),
            ],
            options={
                "verbose_name": "storage path",
                "verbose_name_plural": "storage paths",
                "ordering": ("name",),
            },
        ),
        migrations.AddField(
            model_name="document",
            name="storage_path",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="documents",
                to="documents.storagepath",
                verbose_name="storage path",
            ),
        ),
    ]
