## [ torch 参数更多 ]torch.multiprocessing.spawn
### [torch.multiprocessing.spawn](https://docs.pytorch.org/docs/stable/multiprocessing.html#module-torch.multiprocessing.spawn)
```python
torch.multiprocessing.spawn(fn, args=(), nprocs=1, join=True, daemon=False, start_method='spawn')
```

### [paddle.distributed.spawn](https://www.paddlepaddle.org.cn/documentation/docs/zh/develop/api/paddle/distributed/spawn_cn.html#paddle.distributed.spawn)
```python
paddle.distributed.spawn(func, args=(), nprocs=- 1, join=True, daemon=False, **options)
```

PyTorch 相比 Paddle 支持更多其他参数，具体如下：

### 参数映射

| PyTorch      | PaddlePaddle | 备注                                                                |
| ------------ | ------------ | ------------------------------------------------------------------- |
| fn         | func         | Python 函数。                                                       |
| args       | args           | 函数 func 的输入参数。                                              |
| nprocs            | nprocs            | 启动进程的数目。Paddle 与 PyTorch 默认值不同，Paddle 应设置为 `1`。    |
| join | join            | 对所有启动的进程执行阻塞的 join，等待进程执行结束。                                   |
| start_method       | -            | 启动方式。 PyTorch 已弃用，Paddle 无此参数，对网络训练结果无影响，可直接删除。 |
| -       | **options           | 其他初始化并行执行环境的配置选项。 PyTorch 无此参数， Paddle 保持默认即可。 |
