## [ 返回参数类型不一致 ]torch.Tensor.histc
### [torch.Tensor.histc](https://docs.pytorch.org/docs/stable/generated/torch.Tensor.histc.html#torch.Tensor.histc)
```python
torch.Tensor.histc(bins=100, min=0, max=0)
```

### [paddle.Tensor.histogram](https://www.paddlepaddle.org.cn/documentation/docs/zh/develop/api/paddle/Tensor__upper_cn.html#histogram-bins-100-min-0-max-0)
```python
paddle.Tensor.histogram(bins=100, min=0, max=0, name=None)
```

返回 Tensor 的数据类型不一致，PyTorch 返回数据类型与输入 Tensor 一致， Paddle 默认返回 int64 类型。

### 参数映射

| PyTorch                           | PaddlePaddle                 | 备注                                                   |
|-----------------------------------|------------------------------| ------------------------------------------------------ |
|  bins  |  bins  | 直方图 bins(直条)的个数，默认为 100。                                     |
|  min  |  min  | range 的下边界(包含)，默认为 0。                                     |
|  max  |  max  | range 的上边界(包含)，默认为 0。                                     |
|  返回值  |  返回值  | 返回 Tensor 的数据类型不一致，需要转写。                                     |

### 转写示例
#### 返回值
```python
# PyTorch 写法
y = a.histc(bins=3, min=2, max=4)

# Paddle 写法
y = a.histogram(bins=3, min=2, max=4).astype(a.dtype)
```
