## [ 仅参数名不一致 ]torch.Tensor.ormqr
### [torch.Tensor.ormqr](https://docs.pytorch.org/docs/stable/generated/torch.Tensor.ormqr.html#torch.Tensor.ormqr)
```python
torch.Tensor.ormqr(input2, input3, left=True, transpose=False)
```

### [paddle.linalg.ormqr](https://www.paddlepaddle.org.cn/documentation/docs/zh/develop/api/paddle/linalg/ormqr_cn.html#paddle.linalg.ormqr)
```python
paddle.linalg.ormqr(x, tau, y, left=True, transpose=False)
```

两者功能一致且参数用法一致，仅参数名不一致，具体如下：

### 参数映射

| PyTorch   | PaddlePaddle | 备注                               |
| --------- | ------------ | ---------------------------------- |
| input2    | tau          | Householder 反射系数，仅参数名不同。 |
| input3    | y        | 用于矩阵乘积，仅参数名不同。         |
| left      | left         | 决定了矩阵乘积运算的顺序。    |
| transpose | transpose    | 决定矩阵 Q 是否共轭转置变换。  |
