# 2.0 升级常见问题

## 环境变化

##### 问题：paddle 2.0 是否支持 python2，python3.5 ？

+ 答复：paddle 2.0 依然提供了 python2，python3.5 的官方安装包，但未来的某个版本将不再支持 python2，python3.5。（python 官方已停止对 python2，python3.5 的更新和维护）

----------

##### 问题：paddle 2.0 是否支持 CUDA9 ？

+ 答复：本版本依然提供了 CUDA9 的官方安装包，但从未来的某个版本起，将不再支持 CUDA9。

----------

##### 问题：paddle 2.0 是否支持 CentOS6.0 ？

+ 答复：对于 CentOS6.0，本版本仅提供了有限度的支持（仅发布了 CentOS6 下，Python3.7 CUDA10.2/CUDNN7 和 CPU 的安装包）。（CentOS6 官方已宣布了停止更新和维护）

----------

##### 问题：paddle 2.0 是否支持 AVX 指令的 x86 机器 ？

+ 答复：2.0 版本依然提供了对不支持 AVX 指令的 x86 机器上运行飞桨的支持，但未来的某个版本将会废弃对不支持 AVX 指令的 x86 机器的支持。

----------


##### 问题：2.0 版本移除了哪些第三方库 ？

+ 答复：2.0 版本移除的第三方依赖库为：nltk、opencv、scipy、rarfile、prettytable、pathlib、matplotlib、graphviz、objgraph。由于某些功能依然会有对 opencv 的依赖，在使用到时，会提示用户进行安装。

具体表现为：

1. 删除依赖这些库的 API，原来 Paddle 基于这些第三方库提供了一些 API，在删除这些依赖库的同时也删除了这些 API，如：移除 matplotlib 的同时，paddle.utils.plot 也被删除了。

2. 删除依赖第三方库的数据集，如：移除 nltk 的同时，依赖 nltk 的数据集 sentiment(nltk.movie_review)也被删除了。

3. 删除依赖的第三方库后，如果需要使用这些库，需要重新安装`pip install objgraph`，直接 import objgraph 可能会报错。

----------


##### 问题：从 1.x 版本升级为 2.0 版本，哪些 API 有变动 ？

+ 答复：飞桨框架 2.0.0 版本推荐用户使用位于 paddle 根目录下的 API，同时在`paddle.fluid`目录下保留了所有的 1.x 版本的 API，保留对之前版本 API 体系的支持。

查看 API 变动的两种方法：

1. 依据 1.8 版本 API 到 2.0 版本 API 的对应关系表对 API 进行升级，请参考文档 [飞桨框架 API 映射表](https://www.paddlepaddle.org.cn/documentation/docs/zh/guides/08_api_mapping/paddle_api_mapping_cn.html)

2. 飞桨提供了迁移工具，来方便用户将旧版本的代码迁移为 2.0.1 版本的代码，详情请见：[版本迁移工具](https://www.paddlepaddle.org.cn/documentation/docs/zh/guides/01_paddle2.0_introduction/migration_cn.html)


----------


##### 问题：2.0 版本中是否有 LoDTensor ？

+ 答复：2.0 版本没有 LoDTensor 的概念，统一使用 Tensor 来表示数据。

+ 解决方案：

1. 使用 padding/bucketing 的方式对数据进行处理后，使用 Tensor 来表示数据，进行模型训练，具体示例请参考：[IMDB 数据集使用 BOW 网络的文本分类](https://www.paddlepaddle.org.cn/documentation/docs/zh/tutorial/nlp_case/imdb_bow_classification/imdb_bow_classification.html)，[使用注意力机制的 LSTM 的机器翻译](https://www.paddlepaddle.org.cn/documentation/docs/zh/tutorial/nlp_case/seq2seq_with_attention/seq2seq_with_attention.html)。

2. 在使用 padding/bucketing 方案对性能影响极大的场景下，请谨慎升级，并请期待未来的 paddle 对该功能更加易用和高效的实现。

----------

##### 问题：为什么 paddle2.0 以后的版本要废弃 LoDTensor ？

- 答复：在 2.0 之前的版本的 paddle 中，向用户暴露了以下的数据表示的概念：
  - [Tensor](https://www.paddlepaddle.org.cn/documentation/docs/zh/1.8/beginners_guide/basic_concept/tensor.html)： 类似于 numpy ndarray 的多维数组。
  - [Variable](https://www.paddlepaddle.org.cn/documentation/docs/zh/1.8/beginners_guide/basic_concept/variable.html)：可以简单理解为，在构建静态的计算图时的数据节点。
  - [LodTensor](https://www.paddlepaddle.org.cn/documentation/docs/zh/1.8/beginners_guide/basic_concept/lod_tensor.html)：用来表示嵌套的、每条数据长度不一的一组数据。（例：一个 batch 中包含了长度为 3，10，7，50 的四个句子）

这三类不同类型的概念的同时存在，让使用 paddle 的开发者容易感到混淆，需要构建 LoDTensor 类型的数据的情况在具体的实践中，通常也可以使用 padding/bucketing 的最佳实践来达到同样的目的，因此 paddle 2.0 版本起，我们把这些概念统一为 [Tensor](https://www.paddlepaddle.org.cn/documentation/docs/zh/guides/01_paddle2.0_introduction/basic_concept/tensor_introduction_cn.html) 的概念。在 paddle 2.0 版本起，对于每条数据长度不一的一组数据的处理，您可以参看这篇 Tutorial： [使用注意力机制的 LSTM 的机器翻译](https://www.paddlepaddle.org.cn/documentation/docs/zh/practices/nlp/seq2seq_with_attention.html)。

----------


##### 问题：1.8 开发的静态图代码能在 2.0 版本中运行吗 ？

+ 答复：

所有 1.8 的静态图模型在 2.0 版本中都会报错。

+ 问题分析：

2.0 版本默认开启了动态图模式。即当调用`import paddle`后，此时 Paddle 已经运行在动态图模式下。基于 1.8 开发的静态图代码，在 2.0 版本下直接执行会出错。为此，在静态图的一些入口 API 中加入了报错检查，例如直接调用`fluid.data`会遇到如下错误：

![图片](https://paddlepaddleimage.cdn.bcebos.com/faqimage%2Fbj-fcd837654fa8c5bb15b071ecaad6b92ef632d872.png)

+ 解决方案：

1. 旧版本（1.8 及之前版本）静态图下的代码，需要在`import paddle`后的头部位置加入`paddle.enable_static()`来开启静态图模式，这样才能正常运行。

2. 原来通过`dygraph guard`写的动态图代码仍然可以正常执行。但在 2.0 下可以不需要像以前写`dygraph guard`，直接按照动态图模式编写代码。

3. 同时，请注意对于 GPU 版本的 paddle，在`import paddle`时默认开启动态图会选择`CUDAPlace`作为默认 place。如果要修改 place，可以通过`paddle.set_device()`来完成。


----------


##### 问题：2.0 版本中`loss.backward()` 是否默认清空上个 step 的梯度？

+ 答复：

2.0 版本新增动态图梯度累加功能，起到变相“扩大 BatchSize”的作用，`backward()`接口默认不清空上个 step 梯度。

+ 解决方案：

调用`optimizer.minimize()`后，显式调用`optimizer.clear_grad()`来清空梯度。
