#!/bin/bash
set -x

FLUIDDOCDIR=${FLUIDDOCDIR:=/FluidDoc}

DOCROOT=${FLUIDDOCDIR}/docs/
APIROOT=${DOCROOT}/api/

SCRIPT_DIR="$( cd "$( dirname "$0" )" && pwd )"
source ${SCRIPT_DIR}/utils.sh

if [ -z ${BRANCH} ]; then
    BRANCH="develop"
fi

all_git_files=`git diff --name-only --diff-filter=ACMR upstream/${BRANCH} | sed 's#^docs/##'`
echo $all_git_files
echo "Run API_LABEL Checking"
python check_api_label_cn.py ${DOCROOT} ${APIROOT} $all_git_files
