/**
  ******************************************************************************
  * @file    stm32h733xx.h
  * @author  MCD Application Team
  * @brief   CMSIS STM32H733xx Device Peripheral Access Layer Header File.
  *
  *          This file contains:
  *           - Data structures and the address mapping for all peripherals
  *           - Peripheral's registers declarations and bits definition
  *           - Macros to access peripheral's registers hardware
  *
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2019 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */

/** @addtogroup CMSIS_Device
  * @{
  */

/** @addtogroup stm32h733xx
  * @{
  */

#ifndef STM32H733xx_H
#define STM32H733xx_H

#ifdef __cplusplus
 extern "C" {
#endif /* __cplusplus */

/** @addtogroup Peripheral_interrupt_number_definition
  * @{
  */

/**
 * @brief STM32H7XX Interrupt Number Definition, according to the selected device
 *        in @ref Library_configuration_section
 */
typedef enum
{
/******  Cortex-M Processor Exceptions Numbers *****************************************************************/
  NonMaskableInt_IRQn         = -14,    /*!< 2 Non Maskable Interrupt                                          */
  HardFault_IRQn              = -13,    /*!< 4 Cortex-M Memory Management Interrupt                            */
  MemoryManagement_IRQn       = -12,    /*!< 4 Cortex-M Memory Management Interrupt                            */
  BusFault_IRQn               = -11,    /*!< 5 Cortex-M Bus Fault Interrupt                                    */
  UsageFault_IRQn             = -10,    /*!< 6 Cortex-M Usage Fault Interrupt                                  */
  SVCall_IRQn                 = -5,     /*!< 11 Cortex-M SV Call Interrupt                                     */
  DebugMonitor_IRQn           = -4,     /*!< 12 Cortex-M Debug Monitor Interrupt                               */
  PendSV_IRQn                 = -2,     /*!< 14 Cortex-M Pend SV Interrupt                                     */
  SysTick_IRQn                = -1,     /*!< 15 Cortex-M System Tick Interrupt                                 */
/******  STM32 specific Interrupt Numbers **********************************************************************/
  WWDG_IRQn                   = 0,      /*!< Window WatchDog Interrupt ( wwdg1_it, wwdg2_it)                   */
  PVD_AVD_IRQn                = 1,      /*!< PVD/AVD through EXTI Line detection Interrupt                     */
  TAMP_STAMP_IRQn             = 2,      /*!< Tamper and TimeStamp interrupts through the EXTI line             */
  RTC_WKUP_IRQn               = 3,      /*!< RTC Wakeup interrupt through the EXTI line                        */
  FLASH_IRQn                  = 4,      /*!< FLASH global Interrupt                                            */
  RCC_IRQn                    = 5,      /*!< RCC global Interrupt                                              */
  EXTI0_IRQn                  = 6,      /*!< EXTI Line0 Interrupt                                              */
  EXTI1_IRQn                  = 7,      /*!< EXTI Line1 Interrupt                                              */
  EXTI2_IRQn                  = 8,      /*!< EXTI Line2 Interrupt                                              */
  EXTI3_IRQn                  = 9,      /*!< EXTI Line3 Interrupt                                              */
  EXTI4_IRQn                  = 10,     /*!< EXTI Line4 Interrupt                                              */
  DMA1_Stream0_IRQn           = 11,     /*!< DMA1 Stream 0 global Interrupt                                    */
  DMA1_Stream1_IRQn           = 12,     /*!< DMA1 Stream 1 global Interrupt                                    */
  DMA1_Stream2_IRQn           = 13,     /*!< DMA1 Stream 2 global Interrupt                                    */
  DMA1_Stream3_IRQn           = 14,     /*!< DMA1 Stream 3 global Interrupt                                    */
  DMA1_Stream4_IRQn           = 15,     /*!< DMA1 Stream 4 global Interrupt                                    */
  DMA1_Stream5_IRQn           = 16,     /*!< DMA1 Stream 5 global Interrupt                                    */
  DMA1_Stream6_IRQn           = 17,     /*!< DMA1 Stream 6 global Interrupt                                    */
  ADC_IRQn                    = 18,     /*!< ADC1 and  ADC2 global Interrupts                                  */
  FDCAN1_IT0_IRQn             = 19,     /*!< FDCAN1 Interrupt line 0                                           */
  FDCAN2_IT0_IRQn             = 20,     /*!< FDCAN2 Interrupt line 0                                           */
  FDCAN1_IT1_IRQn             = 21,     /*!< FDCAN1 Interrupt line 1                                           */
  FDCAN2_IT1_IRQn             = 22,     /*!< FDCAN2 Interrupt line 1                                           */
  EXTI9_5_IRQn                = 23,     /*!< External Line[9:5] Interrupts                                     */
  TIM1_BRK_IRQn               = 24,     /*!< TIM1 Break Interrupt                                              */
  TIM1_UP_IRQn                = 25,     /*!< TIM1 Update Interrupt                                             */
  TIM1_TRG_COM_IRQn           = 26,     /*!< TIM1 Trigger and Commutation Interrupt                            */
  TIM1_CC_IRQn                = 27,     /*!< TIM1 Capture Compare Interrupt                                    */
  TIM2_IRQn                   = 28,     /*!< TIM2 global Interrupt                                             */
  TIM3_IRQn                   = 29,     /*!< TIM3 global Interrupt                                             */
  TIM4_IRQn                   = 30,     /*!< TIM4 global Interrupt                                             */
  I2C1_EV_IRQn                = 31,     /*!< I2C1 Event Interrupt                                              */
  I2C1_ER_IRQn                = 32,     /*!< I2C1 Error Interrupt                                              */
  I2C2_EV_IRQn                = 33,     /*!< I2C2 Event Interrupt                                              */
  I2C2_ER_IRQn                = 34,     /*!< I2C2 Error Interrupt                                              */
  SPI1_IRQn                   = 35,     /*!< SPI1 global Interrupt                                             */
  SPI2_IRQn                   = 36,     /*!< SPI2 global Interrupt                                             */
  USART1_IRQn                 = 37,     /*!< USART1 global Interrupt                                           */
  USART2_IRQn                 = 38,     /*!< USART2 global Interrupt                                           */
  USART3_IRQn                 = 39,     /*!< USART3 global Interrupt                                           */
  EXTI15_10_IRQn              = 40,     /*!< External Line[15:10] Interrupts                                   */
  RTC_Alarm_IRQn              = 41,     /*!< RTC Alarm (A and B) through EXTI Line Interrupt                   */
  TIM8_BRK_TIM12_IRQn         = 43,     /*!< TIM8 Break Interrupt and TIM12 global interrupt                   */
  TIM8_UP_TIM13_IRQn          = 44,     /*!< TIM8 Update Interrupt and TIM13 global interrupt                  */
  TIM8_TRG_COM_TIM14_IRQn     = 45,     /*!< TIM8 Trigger and Commutation Interrupt and TIM14 global interrupt */
  TIM8_CC_IRQn                = 46,     /*!< TIM8 Capture Compare Interrupt                                    */
  DMA1_Stream7_IRQn           = 47,     /*!< DMA1 Stream7 Interrupt                                            */
  FMC_IRQn                    = 48,     /*!< FMC global Interrupt                                              */
  SDMMC1_IRQn                 = 49,     /*!< SDMMC1 global Interrupt                                           */
  TIM5_IRQn                   = 50,     /*!< TIM5 global Interrupt                                             */
  SPI3_IRQn                   = 51,     /*!< SPI3 global Interrupt                                             */
  UART4_IRQn                  = 52,     /*!< UART4 global Interrupt                                            */
  UART5_IRQn                  = 53,     /*!< UART5 global Interrupt                                            */
  TIM6_DAC_IRQn               = 54,     /*!< TIM6 global and DAC1&2 underrun error  interrupts                 */
  TIM7_IRQn                   = 55,     /*!< TIM7 global interrupt                                             */
  DMA2_Stream0_IRQn           = 56,     /*!<   DMA2 Stream 0 global Interrupt                                  */
  DMA2_Stream1_IRQn           = 57,     /*!<   DMA2 Stream 1 global Interrupt                                  */
  DMA2_Stream2_IRQn           = 58,     /*!<   DMA2 Stream 2 global Interrupt                                  */
  DMA2_Stream3_IRQn           = 59,     /*!<   DMA2 Stream 3 global Interrupt                                  */
  DMA2_Stream4_IRQn           = 60,     /*!<   DMA2 Stream 4 global Interrupt                                  */
  ETH_IRQn                    = 61,     /*!< Ethernet global Interrupt                                         */
  ETH_WKUP_IRQn               = 62,     /*!< Ethernet Wakeup through EXTI line Interrupt                       */
  FDCAN_CAL_IRQn              = 63,     /*!< FDCAN Calibration unit Interrupt                                  */
  DMA2_Stream5_IRQn           = 68,     /*!< DMA2 Stream 5 global interrupt                                    */
  DMA2_Stream6_IRQn           = 69,     /*!< DMA2 Stream 6 global interrupt                                    */
  DMA2_Stream7_IRQn           = 70,     /*!< DMA2 Stream 7 global interrupt                                    */
  USART6_IRQn                 = 71,     /*!< USART6 global interrupt                                           */
  I2C3_EV_IRQn                = 72,     /*!< I2C3 event interrupt                                              */
  I2C3_ER_IRQn                = 73,     /*!< I2C3 error interrupt                                              */
  OTG_HS_EP1_OUT_IRQn         = 74,     /*!< USB OTG HS End Point 1 Out global interrupt                       */
  OTG_HS_EP1_IN_IRQn          = 75,     /*!< USB OTG HS End Point 1 In global interrupt                        */
  OTG_HS_WKUP_IRQn            = 76,     /*!< USB OTG HS Wakeup through EXTI interrupt                          */
  OTG_HS_IRQn                 = 77,     /*!< USB OTG HS global interrupt                                       */
  DCMI_PSSI_IRQn              = 78,     /*!< DCMI and PSSI global interrupt                                    */
  CRYP_IRQn                   = 79,     /*!< CRYP crypto global interrupt                                      */
  HASH_RNG_IRQn               = 80,     /*!< HASH and RNG global interrupt                                     */
  FPU_IRQn                    = 81,     /*!< FPU global interrupt                                              */
  UART7_IRQn                  = 82,     /*!< UART7 global interrupt                                            */
  UART8_IRQn                  = 83,     /*!< UART8 global interrupt                                            */
  SPI4_IRQn                   = 84,     /*!< SPI4 global Interrupt                                             */
  SPI5_IRQn                   = 85,     /*!< SPI5 global Interrupt                                             */
  SPI6_IRQn                   = 86,     /*!< SPI6 global Interrupt                                             */
  SAI1_IRQn                   = 87,     /*!< SAI1 global Interrupt                                             */
  LTDC_IRQn                   = 88,     /*!< LTDC global Interrupt                                             */
  LTDC_ER_IRQn                = 89,     /*!< LTDC Error global Interrupt                                       */
  DMA2D_IRQn                  = 90,     /*!< DMA2D global Interrupt                                            */
  OCTOSPI1_IRQn               = 92,     /*!< OCTOSPI1 global interrupt                                         */
  LPTIM1_IRQn                 = 93,     /*!< LP TIM1 interrupt                                                 */
  CEC_IRQn                    = 94,     /*!< HDMI-CEC global Interrupt                                         */
  I2C4_EV_IRQn                = 95,     /*!< I2C4 Event Interrupt                                              */
  I2C4_ER_IRQn                = 96,     /*!< I2C4 Error Interrupt                                              */
  SPDIF_RX_IRQn               = 97,     /*!< SPDIF-RX global Interrupt                                         */
  DMAMUX1_OVR_IRQn            = 102,    /*!<DMAMUX1 Overrun interrupt                                          */
  DFSDM1_FLT0_IRQn            = 110,    /*!<DFSDM Filter1 Interrupt                                            */
  DFSDM1_FLT1_IRQn            = 111,    /*!<DFSDM Filter2 Interrupt                                            */
  DFSDM1_FLT2_IRQn            = 112,    /*!<DFSDM Filter3 Interrupt                                            */
  DFSDM1_FLT3_IRQn            = 113,    /*!<DFSDM Filter4 Interrupt                                            */
  SWPMI1_IRQn                 = 115,    /*!< Serial Wire Interface 1 global interrupt                          */
  TIM15_IRQn                  = 116,    /*!< TIM15 global Interrupt                                            */
  TIM16_IRQn                  = 117,    /*!< TIM16 global Interrupt                                            */
  TIM17_IRQn                  = 118,    /*!< TIM17 global Interrupt                                            */
  MDIOS_WKUP_IRQn             = 119,    /*!< MDIOS Wakeup  Interrupt                                           */
  MDIOS_IRQn                  = 120,    /*!< MDIOS global Interrupt                                            */
  MDMA_IRQn                   = 122,    /*!< MDMA global Interrupt                                             */
  SDMMC2_IRQn                 = 124,    /*!< SDMMC2 global Interrupt                                           */
  HSEM1_IRQn                  = 125,    /*!< HSEM1 global Interrupt                                            */
  ADC3_IRQn                   = 127,    /*!< ADC3 global Interrupt                                             */
  DMAMUX2_OVR_IRQn            = 128,    /*!<DMAMUX2 Overrun interrupt                                          */
  BDMA_Channel0_IRQn          = 129,    /*!< BDMA Channel 0 global Interrupt                                   */
  BDMA_Channel1_IRQn          = 130,    /*!< BDMA Channel 1 global Interrupt                                   */
  BDMA_Channel2_IRQn          = 131,    /*!< BDMA Channel 2 global Interrupt                                   */
  BDMA_Channel3_IRQn          = 132,    /*!< BDMA Channel 3 global Interrupt                                   */
  BDMA_Channel4_IRQn          = 133,    /*!< BDMA Channel 4 global Interrupt                                   */
  BDMA_Channel5_IRQn          = 134,    /*!< BDMA Channel 5 global Interrupt                                   */
  BDMA_Channel6_IRQn          = 135,    /*!< BDMA Channel 6 global Interrupt                                   */
  BDMA_Channel7_IRQn          = 136,    /*!< BDMA Channel 7 global Interrupt                                   */
  COMP_IRQn                   = 137 ,   /*!< COMP global Interrupt                                             */
  LPTIM2_IRQn                 = 138,    /*!< LP TIM2 global interrupt                                          */
  LPTIM3_IRQn                 = 139,    /*!< LP TIM3 global interrupt                                          */
  LPTIM4_IRQn                 = 140,    /*!< LP TIM4 global interrupt                                          */
  LPTIM5_IRQn                 = 141,    /*!< LP TIM5 global interrupt                                          */
  LPUART1_IRQn                = 142,    /*!< LP UART1 interrupt                                                */
  CRS_IRQn                    = 144,    /*!< Clock Recovery Global Interrupt                                   */
  ECC_IRQn                    = 145,    /*!< ECC diagnostic Global Interrupt                                   */
  SAI4_IRQn                   = 146,    /*!< SAI4 global interrupt                                             */
  DTS_IRQn                    = 147,    /*!< Digital Temperature Sensor Global Interrupt                       */
  WAKEUP_PIN_IRQn             = 149,    /*!< Interrupt for all 6 wake-up pins                                  */
  OCTOSPI2_IRQn               = 150,    /*!< OctoSPI2 global interrupt                                         */
  OTFDEC1_IRQn                = 151,    /*!< OTFDEC1 global interrupt                                          */
  OTFDEC2_IRQn                = 152,    /*!< OTFDEC2 global interrupt                                          */
  FMAC_IRQn                   = 153,    /*!< FMAC global interrupt                                             */
  CORDIC_IRQn                 = 154,    /*!< CORDIC global interrupt                                           */
  UART9_IRQn                  = 155,    /*!< UART9 global Interrupt                                            */
  USART10_IRQn                = 156,    /*!< USART10 global interrupt                                          */
  I2C5_EV_IRQn                = 157,    /*!< I2C5 event interrupt                                              */
  I2C5_ER_IRQn                = 158,    /*!< I2C5 error interrupt                                              */
  FDCAN3_IT0_IRQn             = 159,    /*!< FDCAN3 Interrupt line 0                                           */
  FDCAN3_IT1_IRQn             = 160,    /*!< FDCAN3 Interrupt line 1                                           */
  TIM23_IRQn                  = 161,    /*!< TIM23 global interrupt                                            */
  TIM24_IRQn                  = 162,    /*!< TIM24 global interrupt                                            */
} IRQn_Type;

/**
  * @}
  */

/** @addtogroup Configuration_section_for_CMSIS
  * @{
  */




/**
  * @brief Configuration of the Cortex-M7 Processor and Core Peripherals
   */
#define __CM7_REV               0x0100U   /*!< Cortex-M7 revision r1p0                       */
#define __MPU_PRESENT             1       /*!< CM7 provides an MPU                           */
#define __NVIC_PRIO_BITS          4       /*!< CM7 uses 4 Bits for the Priority Levels       */
#define __Vendor_SysTickConfig    0       /*!< Set to 1 if different SysTick Config is used  */
#define __FPU_PRESENT             1       /*!< FPU present                                   */
#define __ICACHE_PRESENT          1       /*!< CM7 instruction cache present                 */
#define __DCACHE_PRESENT          1       /*!< CM7 data cache present                        */
#include "core_cm7.h"                     /*!< Cortex-M7 processor and core peripherals      */

/**
  * @}
  */




#include "system_stm32h7xx.h"
#include <stdint.h>

/** @addtogroup Peripheral_registers_structures
  * @{
  */

/**
  * @brief Analog to Digital Converter
  */

typedef struct
{
  __IO uint32_t ISR;              /*!< ADC Interrupt and Status Register,                          Address offset: 0x00 */
  __IO uint32_t IER;              /*!< ADC Interrupt Enable Register,                              Address offset: 0x04 */
  __IO uint32_t CR;               /*!< ADC control register,                                       Address offset: 0x08 */
  __IO uint32_t CFGR;             /*!< ADC Configuration register,                                 Address offset: 0x0C */
  __IO uint32_t CFGR2;            /*!< ADC Configuration register 2,                               Address offset: 0x10 */
  __IO uint32_t SMPR1;            /*!< ADC sample time register 1,                                 Address offset: 0x14 */
  __IO uint32_t SMPR2;            /*!< ADC sample time register 2,                                 Address offset: 0x18 */
  __IO uint32_t PCSEL_RES0;       /*!< Rserved for ADC3, ADC1/2 pre-channel selection,             Address offset: 0x1C */
  __IO uint32_t LTR1_TR1;         /*!< ADC watchdog Lower threshold register 1,                    Address offset: 0x20 */
  __IO uint32_t HTR1_TR2;         /*!< ADC watchdog higher threshold register 1,                   Address offset: 0x24 */
  __IO uint32_t RES1_TR3;         /*!< Rserved for ADC1/2, ADC3 threshold register,                Address offset: 0x28 */
  uint32_t      RESERVED2;        /*!< Reserved, 0x02C                                                                  */
  __IO uint32_t SQR1;             /*!< ADC regular sequence register 1,                            Address offset: 0x30 */
  __IO uint32_t SQR2;             /*!< ADC regular sequence register 2,                            Address offset: 0x34 */
  __IO uint32_t SQR3;             /*!< ADC regular sequence register 3,                            Address offset: 0x38 */
  __IO uint32_t SQR4;             /*!< ADC regular sequence register 4,                            Address offset: 0x3C */
  __IO uint32_t DR;               /*!< ADC regular data register,                                  Address offset: 0x40 */
  uint32_t      RESERVED3;        /*!< Reserved, 0x044                                                                  */
  uint32_t      RESERVED4;        /*!< Reserved, 0x048                                                                  */
  __IO uint32_t JSQR;             /*!< ADC injected sequence register,                             Address offset: 0x4C */
  uint32_t      RESERVED5[4];     /*!< Reserved, 0x050 - 0x05C                                                          */
  __IO uint32_t OFR1;             /*!< ADC offset register 1,                                      Address offset: 0x60 */
  __IO uint32_t OFR2;             /*!< ADC offset register 2,                                      Address offset: 0x64 */
  __IO uint32_t OFR3;             /*!< ADC offset register 3,                                      Address offset: 0x68 */
  __IO uint32_t OFR4;             /*!< ADC offset register 4,                                      Address offset: 0x6C */
  uint32_t      RESERVED6[4];     /*!< Reserved, 0x070 - 0x07C                                                          */
  __IO uint32_t JDR1;             /*!< ADC injected data register 1,                               Address offset: 0x80 */
  __IO uint32_t JDR2;             /*!< ADC injected data register 2,                               Address offset: 0x84 */
  __IO uint32_t JDR3;             /*!< ADC injected data register 3,                               Address offset: 0x88 */
  __IO uint32_t JDR4;             /*!< ADC injected data register 4,                               Address offset: 0x8C */
  uint32_t      RESERVED7[4];     /*!< Reserved, 0x090 - 0x09C                                                          */
  __IO uint32_t AWD2CR;           /*!< ADC  Analog Watchdog 2 Configuration Register,              Address offset: 0xA0 */
  __IO uint32_t AWD3CR;           /*!< ADC  Analog Watchdog 3 Configuration Register,              Address offset: 0xA4 */
  uint32_t      RESERVED8;        /*!< Reserved, 0x0A8                                                                  */
  uint32_t      RESERVED9;        /*!< Reserved, 0x0AC                                                                  */
  __IO uint32_t LTR2_DIFSEL;      /*!< ADC watchdog Lower threshold register 2, Difsel for ADC3,   Address offset: 0xB0 */
  __IO uint32_t HTR2_CALFACT;     /*!< ADC watchdog Higher threshold register 2, Calfact for ADC3, Address offset: 0xB4 */
  __IO uint32_t LTR3_RES10;       /*!< ADC watchdog Lower threshold register 3, specific ADC1/2,   Address offset: 0xB8 */
  __IO uint32_t HTR3_RES11;       /*!< ADC watchdog Higher threshold register 3, specific ADC1/2,  Address offset: 0xBC */
  __IO uint32_t DIFSEL_RES12;     /*!< ADC Differential Mode Selection Register specific ADC1/2,   Address offset: 0xC0 */
  __IO uint32_t CALFACT_RES13;    /*!< ADC Calibration Factors specific ADC1/2,                    Address offset: 0xC4 */
  __IO uint32_t CALFACT2_RES14;   /*!< ADC Linearity Calibration Factors specific ADC1/2,          Address offset: 0xC8 */
} ADC_TypeDef;


typedef struct
{
__IO uint32_t CSR; /*!< ADC Common status register, Address offset: ADC1/3 base address + 0x300 */
uint32_t RESERVED; /*!< Reserved, ADC1/3 base address + 0x304 */
__IO uint32_t CCR; /*!< ADC common control register, Address offset: ADC1/3 base address + 0x308 */
__IO uint32_t CDR; /*!< ADC common regular data register for dual Address offset: ADC1/3 base address + 0x30C */
__IO uint32_t CDR2; /*!< ADC common regular data register for 32-bit dual mode Address offset: ADC1/3 base address + 0x310 */

} ADC_Common_TypeDef;


/**
  * @brief VREFBUF
  */

typedef struct
{
  __IO uint32_t CSR;         /*!< VREFBUF control and status register,         Address offset: 0x00 */
  __IO uint32_t CCR;         /*!< VREFBUF calibration and control register,    Address offset: 0x04 */
} VREFBUF_TypeDef;


/**
  * @brief FD Controller Area Network
  */

typedef struct
{
  __IO uint32_t CREL;         /*!< FDCAN Core Release register,                                     Address offset: 0x000 */
  __IO uint32_t ENDN;         /*!< FDCAN Endian register,                                           Address offset: 0x004 */
  __IO uint32_t RESERVED1;    /*!< Reserved,                                                                        0x008 */
  __IO uint32_t DBTP;         /*!< FDCAN Data Bit Timing & Prescaler register,                      Address offset: 0x00C */
  __IO uint32_t TEST;         /*!< FDCAN Test register,                                             Address offset: 0x010 */
  __IO uint32_t RWD;          /*!< FDCAN RAM Watchdog register,                                     Address offset: 0x014 */
  __IO uint32_t CCCR;         /*!< FDCAN CC Control register,                                       Address offset: 0x018 */
  __IO uint32_t NBTP;         /*!< FDCAN Nominal Bit Timing & Prescaler register,                   Address offset: 0x01C */
  __IO uint32_t TSCC;         /*!< FDCAN Timestamp Counter Configuration register,                  Address offset: 0x020 */
  __IO uint32_t TSCV;         /*!< FDCAN Timestamp Counter Value register,                          Address offset: 0x024 */
  __IO uint32_t TOCC;         /*!< FDCAN Timeout Counter Configuration register,                    Address offset: 0x028 */
  __IO uint32_t TOCV;         /*!< FDCAN Timeout Counter Value register,                            Address offset: 0x02C */
  __IO uint32_t RESERVED2[4]; /*!< Reserved,                                                                0x030 - 0x03C */
  __IO uint32_t ECR;          /*!< FDCAN Error Counter register,                                    Address offset: 0x040 */
  __IO uint32_t PSR;          /*!< FDCAN Protocol Status register,                                  Address offset: 0x044 */
  __IO uint32_t TDCR;         /*!< FDCAN Transmitter Delay Compensation register,                   Address offset: 0x048 */
  __IO uint32_t RESERVED3;    /*!< Reserved,                                                                        0x04C */
  __IO uint32_t IR;           /*!< FDCAN Interrupt register,                                        Address offset: 0x050 */
  __IO uint32_t IE;           /*!< FDCAN Interrupt Enable register,                                 Address offset: 0x054 */
  __IO uint32_t ILS;          /*!< FDCAN Interrupt Line Select register,                            Address offset: 0x058 */
  __IO uint32_t ILE;          /*!< FDCAN Interrupt Line Enable register,                            Address offset: 0x05C */
  __IO uint32_t RESERVED4[8]; /*!< Reserved,                                                                0x060 - 0x07C */
  __IO uint32_t GFC;          /*!< FDCAN Global Filter Configuration register,                      Address offset: 0x080 */
  __IO uint32_t SIDFC;        /*!< FDCAN Standard ID Filter Configuration register,                 Address offset: 0x084 */
  __IO uint32_t XIDFC;        /*!< FDCAN Extended ID Filter Configuration register,                 Address offset: 0x088 */
  __IO uint32_t RESERVED5;    /*!< Reserved,                                                                        0x08C */
  __IO uint32_t XIDAM;        /*!< FDCAN Extended ID AND Mask register,                             Address offset: 0x090 */
  __IO uint32_t HPMS;         /*!< FDCAN High Priority Message Status register,                     Address offset: 0x094 */
  __IO uint32_t NDAT1;        /*!< FDCAN New Data 1 register,                                       Address offset: 0x098 */
  __IO uint32_t NDAT2;        /*!< FDCAN New Data 2 register,                                       Address offset: 0x09C */
  __IO uint32_t RXF0C;        /*!< FDCAN Rx FIFO 0 Configuration register,                          Address offset: 0x0A0 */
  __IO uint32_t RXF0S;        /*!< FDCAN Rx FIFO 0 Status register,                                 Address offset: 0x0A4 */
  __IO uint32_t RXF0A;        /*!< FDCAN Rx FIFO 0 Acknowledge register,                            Address offset: 0x0A8 */
  __IO uint32_t RXBC;         /*!< FDCAN Rx Buffer Configuration register,                          Address offset: 0x0AC */
  __IO uint32_t RXF1C;        /*!< FDCAN Rx FIFO 1 Configuration register,                          Address offset: 0x0B0 */
  __IO uint32_t RXF1S;        /*!< FDCAN Rx FIFO 1 Status register,                                 Address offset: 0x0B4 */
  __IO uint32_t RXF1A;        /*!< FDCAN Rx FIFO 1 Acknowledge register,                            Address offset: 0x0B8 */
  __IO uint32_t RXESC;        /*!< FDCAN Rx Buffer/FIFO Element Size Configuration register,        Address offset: 0x0BC */
  __IO uint32_t TXBC;         /*!< FDCAN Tx Buffer Configuration register,                          Address offset: 0x0C0 */
  __IO uint32_t TXFQS;        /*!< FDCAN Tx FIFO/Queue Status register,                             Address offset: 0x0C4 */
  __IO uint32_t TXESC;        /*!< FDCAN Tx Buffer Element Size Configuration register,             Address offset: 0x0C8 */
  __IO uint32_t TXBRP;        /*!< FDCAN Tx Buffer Request Pending register,                        Address offset: 0x0CC */
  __IO uint32_t TXBAR;        /*!< FDCAN Tx Buffer Add Request register,                            Address offset: 0x0D0 */
  __IO uint32_t TXBCR;        /*!< FDCAN Tx Buffer Cancellation Request register,                   Address offset: 0x0D4 */
  __IO uint32_t TXBTO;        /*!< FDCAN Tx Buffer Transmission Occurred register,                  Address offset: 0x0D8 */
  __IO uint32_t TXBCF;        /*!< FDCAN Tx Buffer Cancellation Finished register,                  Address offset: 0x0DC */
  __IO uint32_t TXBTIE;       /*!< FDCAN Tx Buffer Transmission Interrupt Enable register,          Address offset: 0x0E0 */
  __IO uint32_t TXBCIE;       /*!< FDCAN Tx Buffer Cancellation Finished Interrupt Enable register, Address offset: 0x0E4 */
  __IO uint32_t RESERVED6[2]; /*!< Reserved,                                                                0x0E8 - 0x0EC */
  __IO uint32_t TXEFC;        /*!< FDCAN Tx Event FIFO Configuration register,                      Address offset: 0x0F0 */
  __IO uint32_t TXEFS;        /*!< FDCAN Tx Event FIFO Status register,                             Address offset: 0x0F4 */
  __IO uint32_t TXEFA;        /*!< FDCAN Tx Event FIFO Acknowledge register,                        Address offset: 0x0F8 */
  __IO uint32_t RESERVED7;    /*!< Reserved,                                                                        0x0FC */
} FDCAN_GlobalTypeDef;

/**
  * @brief TTFD Controller Area Network
  */

typedef struct
{
  __IO uint32_t TTTMC;          /*!< TT Trigger Memory Configuration register,    Address offset: 0x100 */
  __IO uint32_t TTRMC;          /*!< TT Reference Message Configuration register, Address offset: 0x104 */
  __IO uint32_t TTOCF;          /*!< TT Operation Configuration register,         Address offset: 0x108 */
  __IO uint32_t TTMLM;          /*!< TT Matrix Limits register,                   Address offset: 0x10C */
  __IO uint32_t TURCF;          /*!< TUR Configuration register,                  Address offset: 0x110 */
  __IO uint32_t TTOCN;          /*!< TT Operation Control register,               Address offset: 0x114 */
  __IO uint32_t TTGTP;          /*!< TT Global Time Preset register,              Address offset: 0x118 */
  __IO uint32_t TTTMK;          /*!< TT Time Mark register,                       Address offset: 0x11C */
  __IO uint32_t TTIR;           /*!< TT Interrupt register,                       Address offset: 0x120 */
  __IO uint32_t TTIE;           /*!< TT Interrupt Enable register,                Address offset: 0x124 */
  __IO uint32_t TTILS;          /*!< TT Interrupt Line Select register,           Address offset: 0x128 */
  __IO uint32_t TTOST;          /*!< TT Operation Status register,                Address offset: 0x12C */
  __IO uint32_t TURNA;          /*!< TT TUR Numerator Actual register,            Address offset: 0x130 */
  __IO uint32_t TTLGT;          /*!< TT Local and Global Time register,           Address offset: 0x134 */
  __IO uint32_t TTCTC;          /*!< TT Cycle Time and Count register,            Address offset: 0x138 */
  __IO uint32_t TTCPT;          /*!< TT Capture Time register,                    Address offset: 0x13C */
  __IO uint32_t TTCSM;          /*!< TT Cycle Sync Mark register,                 Address offset: 0x140 */
  __IO uint32_t RESERVED1[111]; /*!< Reserved,                                            0x144 - 0x2FC */
  __IO uint32_t TTTS;           /*!< TT Trigger Select register,                  Address offset: 0x300 */
} TTCAN_TypeDef;

/**
  * @brief FD Controller Area Network
  */

typedef struct
{
  __IO uint32_t CREL;  /*!< Clock Calibration Unit Core Release register, Address offset: 0x00 */
  __IO uint32_t CCFG;  /*!< Calibration Configuration register,           Address offset: 0x04 */
  __IO uint32_t CSTAT; /*!< Calibration Status register,                  Address offset: 0x08 */
  __IO uint32_t CWD;   /*!< Calibration Watchdog register,                Address offset: 0x0C */
  __IO uint32_t IR;    /*!< CCU Interrupt register,                       Address offset: 0x10 */
  __IO uint32_t IE;    /*!< CCU Interrupt Enable register,                Address offset: 0x14 */
} FDCAN_ClockCalibrationUnit_TypeDef;


/**
  * @brief Consumer Electronics Control
  */

typedef struct
{
  __IO uint32_t CR;           /*!< CEC control register,              Address offset:0x00 */
  __IO uint32_t CFGR;         /*!< CEC configuration register,        Address offset:0x04 */
  __IO uint32_t TXDR;         /*!< CEC Tx data register ,             Address offset:0x08 */
  __IO uint32_t RXDR;         /*!< CEC Rx Data Register,              Address offset:0x0C */
  __IO uint32_t ISR;          /*!< CEC Interrupt and Status Register, Address offset:0x10 */
  __IO uint32_t IER;          /*!< CEC interrupt enable register,     Address offset:0x14 */
}CEC_TypeDef;

/**
  * @brief COordincate Rotation DIgital Computer
  */
typedef struct
{
  __IO uint32_t CSR;          /*!< CORDIC control and status register,        Address offset: 0x00 */
  __IO uint32_t WDATA;        /*!< CORDIC argument register,                  Address offset: 0x04 */
  __IO uint32_t RDATA;        /*!< CORDIC result register,                    Address offset: 0x08 */
} CORDIC_TypeDef;

/**
  * @brief CRC calculation unit
  */

typedef struct
{
  __IO uint32_t DR;          /*!< CRC Data register,                           Address offset: 0x00 */
  __IO uint32_t IDR;         /*!< CRC Independent data register,               Address offset: 0x04 */
  __IO uint32_t CR;          /*!< CRC Control register,                        Address offset: 0x08 */
  uint32_t      RESERVED2;   /*!< Reserved,                                                    0x0C */
  __IO uint32_t INIT;        /*!< Initial CRC value register,                  Address offset: 0x10 */
  __IO uint32_t POL;         /*!< CRC polynomial register,                     Address offset: 0x14 */
} CRC_TypeDef;


/**
  * @brief Clock Recovery System
  */
typedef struct
{
__IO uint32_t CR;            /*!< CRS ccontrol register,              Address offset: 0x00 */
__IO uint32_t CFGR;          /*!< CRS configuration register,         Address offset: 0x04 */
__IO uint32_t ISR;           /*!< CRS interrupt and status register,  Address offset: 0x08 */
__IO uint32_t ICR;           /*!< CRS interrupt flag clear register,  Address offset: 0x0C */
} CRS_TypeDef;


/**
  * @brief Digital to Analog Converter
  */

typedef struct
{
  __IO uint32_t CR;       /*!< DAC control register,                                    Address offset: 0x00 */
  __IO uint32_t SWTRIGR;  /*!< DAC software trigger register,                           Address offset: 0x04 */
  __IO uint32_t DHR12R1;  /*!< DAC channel1 12-bit right-aligned data holding register, Address offset: 0x08 */
  __IO uint32_t DHR12L1;  /*!< DAC channel1 12-bit left aligned data holding register,  Address offset: 0x0C */
  __IO uint32_t DHR8R1;   /*!< DAC channel1 8-bit right aligned data holding register,  Address offset: 0x10 */
  __IO uint32_t DHR12R2;  /*!< DAC channel2 12-bit right aligned data holding register, Address offset: 0x14 */
  __IO uint32_t DHR12L2;  /*!< DAC channel2 12-bit left aligned data holding register,  Address offset: 0x18 */
  __IO uint32_t DHR8R2;   /*!< DAC channel2 8-bit right-aligned data holding register,  Address offset: 0x1C */
  __IO uint32_t DHR12RD;  /*!< Dual DAC 12-bit right-aligned data holding register,     Address offset: 0x20 */
  __IO uint32_t DHR12LD;  /*!< DUAL DAC 12-bit left aligned data holding register,      Address offset: 0x24 */
  __IO uint32_t DHR8RD;   /*!< DUAL DAC 8-bit right aligned data holding register,      Address offset: 0x28 */
  __IO uint32_t DOR1;     /*!< DAC channel1 data output register,                       Address offset: 0x2C */
  __IO uint32_t DOR2;     /*!< DAC channel2 data output register,                       Address offset: 0x30 */
  __IO uint32_t SR;       /*!< DAC status register,                                     Address offset: 0x34 */
  __IO uint32_t CCR;      /*!< DAC calibration control register,                        Address offset: 0x38 */
  __IO uint32_t MCR;      /*!< DAC mode control register,                               Address offset: 0x3C */
  __IO uint32_t SHSR1;    /*!< DAC Sample and Hold sample time register 1,              Address offset: 0x40 */
  __IO uint32_t SHSR2;    /*!< DAC Sample and Hold sample time register 2,              Address offset: 0x44 */
  __IO uint32_t SHHR;     /*!< DAC Sample and Hold hold time register,                  Address offset: 0x48 */
  __IO uint32_t SHRR;     /*!< DAC Sample and Hold refresh time register,               Address offset: 0x4C */
} DAC_TypeDef;

/**
  * @brief DFSDM module registers
  */
typedef struct
{
  __IO uint32_t FLTCR1;          /*!< DFSDM control register1,                          Address offset: 0x100 */
  __IO uint32_t FLTCR2;          /*!< DFSDM control register2,                          Address offset: 0x104 */
  __IO uint32_t FLTISR;          /*!< DFSDM interrupt and status register,              Address offset: 0x108 */
  __IO uint32_t FLTICR;          /*!< DFSDM interrupt flag clear register,              Address offset: 0x10C */
  __IO uint32_t FLTJCHGR;        /*!< DFSDM injected channel group selection register,  Address offset: 0x110 */
  __IO uint32_t FLTFCR;          /*!< DFSDM filter control register,                    Address offset: 0x114 */
  __IO uint32_t FLTJDATAR;       /*!< DFSDM data register for injected group,           Address offset: 0x118 */
  __IO uint32_t FLTRDATAR;       /*!< DFSDM data register for regular group,            Address offset: 0x11C */
  __IO uint32_t FLTAWHTR;        /*!< DFSDM analog watchdog high threshold register,    Address offset: 0x120 */
  __IO uint32_t FLTAWLTR;        /*!< DFSDM analog watchdog low threshold register,     Address offset: 0x124 */
  __IO uint32_t FLTAWSR;         /*!< DFSDM analog watchdog status register             Address offset: 0x128 */
  __IO uint32_t FLTAWCFR;        /*!< DFSDM analog watchdog clear flag register         Address offset: 0x12C */
  __IO uint32_t FLTEXMAX;        /*!< DFSDM extreme detector maximum register,          Address offset: 0x130 */
  __IO uint32_t FLTEXMIN;        /*!< DFSDM extreme detector minimum register           Address offset: 0x134 */
  __IO uint32_t FLTCNVTIMR;      /*!< DFSDM conversion timer,                           Address offset: 0x138 */
} DFSDM_Filter_TypeDef;

/**
  * @brief DFSDM channel configuration registers
  */
typedef struct
{
  __IO uint32_t CHCFGR1;      /*!< DFSDM channel configuration register1,            Address offset: 0x00 */
  __IO uint32_t CHCFGR2;      /*!< DFSDM channel configuration register2,            Address offset: 0x04 */
  __IO uint32_t CHAWSCDR;     /*!< DFSDM channel analog watchdog and
                                   short circuit detector register,                  Address offset: 0x08 */
  __IO uint32_t CHWDATAR;     /*!< DFSDM channel watchdog filter data register,      Address offset: 0x0C */
  __IO uint32_t CHDATINR;     /*!< DFSDM channel data input register,                Address offset: 0x10 */
} DFSDM_Channel_TypeDef;

/**
  * @brief Debug MCU
  */
typedef struct
{
  __IO uint32_t IDCODE;        /*!< MCU device ID code,                     Address offset: 0x00 */
  __IO uint32_t CR;            /*!< Debug MCU configuration register,       Address offset: 0x04 */
  uint32_t RESERVED4[11];      /*!< Reserved,                             Address offset: 0x08 */
  __IO uint32_t APB3FZ1;     /*!< Debug MCU APB3FZ1 freeze register,    Address offset: 0x34 */
  uint32_t RESERVED5;          /*!< Reserved,                             Address offset: 0x38 */
  __IO uint32_t APB1LFZ1;    /*!< Debug MCU APB1LFZ1 freeze register,   Address offset: 0x3C */
  uint32_t RESERVED6;          /*!< Reserved,                             Address offset: 0x40 */
  __IO uint32_t APB1HFZ1;    /*!< Debug MCU APB1LFZ1 freeze register,   Address offset: 0x44 */
  uint32_t RESERVED7;          /*!< Reserved,                             Address offset: 0x48 */
  __IO uint32_t APB2FZ1;     /*!< Debug MCU APB2FZ1 freeze register,    Address offset: 0x4C */
  uint32_t RESERVED8;          /*!< Reserved,                             Address offset: 0x50 */
  __IO uint32_t APB4FZ1;     /*!< Debug MCU APB4FZ1 freeze register,    Address offset: 0x54 */
  __IO uint32_t RESERVED9[990]; /*!< Reserved,                         Address offset: 0x58-0xFCC */
  __IO uint32_t PIDR4;       /*!< Debug MCU peripheral identity register 4,  Address offset: 0xFD0 */
  __IO uint32_t RESERVED10[3];/*!< Reserved,                            Address offset: 0xFD4-0xFDC */
  __IO uint32_t PIDR0;       /*!< Debug MCU peripheral identity register 0,  Address offset: 0xFE0 */
  __IO uint32_t PIDR1;       /*!< Debug MCU peripheral identity register 1,  Address offset: 0xFE4 */
  __IO uint32_t PIDR2;       /*!< Debug MCU peripheral identity register 2,  Address offset: 0xFE8 */
  __IO uint32_t PIDR3;       /*!< Debug MCU peripheral identity register 3,  Address offset: 0xFEC */
  __IO uint32_t CIDR0;       /*!< Debug MCU component identity register 0,   Address offset: 0xFF0 */
  __IO uint32_t CIDR1;       /*!< Debug MCU component identity register 1,   Address offset: 0xFF4 */
  __IO uint32_t CIDR2;       /*!< Debug MCU component identity register 2,   Address offset: 0xFF8 */
  __IO uint32_t CIDR3;       /*!< Debug MCU component identity register 3,   Address offset: 0xFFC */
}DBGMCU_TypeDef;
/**
  * @brief DCMI
  */

typedef struct
{
  __IO uint32_t CR;       /*!< DCMI control register 1,                       Address offset: 0x00 */
  __IO uint32_t SR;       /*!< DCMI status register,                          Address offset: 0x04 */
  __IO uint32_t RISR;     /*!< DCMI raw interrupt status register,            Address offset: 0x08 */
  __IO uint32_t IER;      /*!< DCMI interrupt enable register,                Address offset: 0x0C */
  __IO uint32_t MISR;     /*!< DCMI masked interrupt status register,         Address offset: 0x10 */
  __IO uint32_t ICR;      /*!< DCMI interrupt clear register,                 Address offset: 0x14 */
  __IO uint32_t ESCR;     /*!< DCMI embedded synchronization code register,   Address offset: 0x18 */
  __IO uint32_t ESUR;     /*!< DCMI embedded synchronization unmask register, Address offset: 0x1C */
  __IO uint32_t CWSTRTR;  /*!< DCMI crop window start,                        Address offset: 0x20 */
  __IO uint32_t CWSIZER;  /*!< DCMI crop window size,                         Address offset: 0x24 */
  __IO uint32_t DR;       /*!< DCMI data register,                            Address offset: 0x28 */
} DCMI_TypeDef;

/**
  * @brief PSSI
  */

typedef struct
{
  __IO uint32_t CR;             /*!< PSSI control register 1,               Address offset: 0x000 */
  __IO uint32_t SR;             /*!< PSSI status register,                  Address offset: 0x004 */
  __IO uint32_t RIS;            /*!< PSSI raw interrupt status register,    Address offset: 0x008 */
  __IO uint32_t IER;            /*!< PSSI interrupt enable register,        Address offset: 0x00C */
  __IO uint32_t MIS;            /*!< PSSI masked interrupt status register, Address offset: 0x010 */
  __IO uint32_t ICR;            /*!< PSSI interrupt clear register,         Address offset: 0x014 */
  __IO uint32_t RESERVED1[4];   /*!< Reserved,                                      0x018 - 0x024 */
  __IO uint32_t DR;             /*!< PSSI data register,                    Address offset: 0x028 */
  __IO uint32_t RESERVED2[241]; /*!< Reserved,                                      0x02C - 0x3EC */
  __IO uint32_t HWCFGR;         /*!< PSSI IP HW configuration register,     Address offset: 0x3F0 */
  __IO uint32_t VERR;           /*!< PSSI IP version register,              Address offset: 0x3F4 */
  __IO uint32_t IPIDR;          /*!< PSSI IP ID register,                   Address offset: 0x3F8 */
  __IO uint32_t SIDR;           /*!< PSSI SIZE ID register,                 Address offset: 0x3FC */
} PSSI_TypeDef;

/**
  * @brief DMA Controller
  */

typedef struct
{
  __IO uint32_t CR;     /*!< DMA stream x configuration register      */
  __IO uint32_t NDTR;   /*!< DMA stream x number of data register     */
  __IO uint32_t PAR;    /*!< DMA stream x peripheral address register */
  __IO uint32_t M0AR;   /*!< DMA stream x memory 0 address register   */
  __IO uint32_t M1AR;   /*!< DMA stream x memory 1 address register   */
  __IO uint32_t FCR;    /*!< DMA stream x FIFO control register       */
} DMA_Stream_TypeDef;

typedef struct
{
  __IO uint32_t LISR;   /*!< DMA low interrupt status register,      Address offset: 0x00 */
  __IO uint32_t HISR;   /*!< DMA high interrupt status register,     Address offset: 0x04 */
  __IO uint32_t LIFCR;  /*!< DMA low interrupt flag clear register,  Address offset: 0x08 */
  __IO uint32_t HIFCR;  /*!< DMA high interrupt flag clear register, Address offset: 0x0C */
} DMA_TypeDef;

typedef struct
{
  __IO uint32_t CCR;          /*!< DMA channel x configuration register          */
  __IO uint32_t CNDTR;        /*!< DMA channel x number of data register         */
  __IO uint32_t CPAR;         /*!< DMA channel x peripheral address register     */
  __IO uint32_t CM0AR;        /*!< DMA channel x memory 0 address register       */
  __IO uint32_t CM1AR;        /*!< DMA channel x memory 1 address register       */
} BDMA_Channel_TypeDef;

typedef struct
{
  __IO uint32_t ISR;          /*!< DMA interrupt status register,               Address offset: 0x00 */
  __IO uint32_t IFCR;         /*!< DMA interrupt flag clear register,           Address offset: 0x04 */
} BDMA_TypeDef;

typedef struct
{
  __IO uint32_t  CCR;        /*!< DMA Multiplexer Channel x Control Register   */
}DMAMUX_Channel_TypeDef;

typedef struct
{
  __IO uint32_t  CSR;      /*!< DMA Channel Status Register     */
  __IO uint32_t  CFR;      /*!< DMA Channel Clear Flag Register */
}DMAMUX_ChannelStatus_TypeDef;

typedef struct
{
  __IO uint32_t  RGCR;        /*!< DMA Request Generator x Control Register   */
}DMAMUX_RequestGen_TypeDef;

typedef struct
{
  __IO uint32_t  RGSR;        /*!< DMA Request Generator Status Register       */
  __IO uint32_t  RGCFR;       /*!< DMA Request Generator Clear Flag Register   */
}DMAMUX_RequestGenStatus_TypeDef;

/**
  * @brief MDMA Controller
  */
typedef struct
{
  __IO uint32_t  GISR0;   /*!< MDMA Global Interrupt/Status Register 0,          Address offset: 0x00 */
}MDMA_TypeDef;

typedef struct
{
  __IO uint32_t  CISR;      /*!< MDMA channel x interrupt/status register,             Address offset: 0x40 */
  __IO uint32_t  CIFCR;     /*!< MDMA channel x interrupt flag clear register,         Address offset: 0x44 */
  __IO uint32_t  CESR;      /*!< MDMA Channel x error status register,                 Address offset: 0x48 */
  __IO uint32_t  CCR;       /*!< MDMA channel x control register,                      Address offset: 0x4C */
  __IO uint32_t  CTCR;      /*!< MDMA channel x Transfer Configuration register,       Address offset: 0x50 */
  __IO uint32_t  CBNDTR;    /*!< MDMA Channel x block number of data register,         Address offset: 0x54 */
  __IO uint32_t  CSAR;      /*!< MDMA channel x source address register,               Address offset: 0x58 */
  __IO uint32_t  CDAR;      /*!< MDMA channel x destination address register,          Address offset: 0x5C */
  __IO uint32_t  CBRUR;     /*!< MDMA channel x Block Repeat address Update register,  Address offset: 0x60 */
  __IO uint32_t  CLAR;      /*!< MDMA channel x Link Address register,                 Address offset: 0x64 */
  __IO uint32_t  CTBR;      /*!< MDMA channel x Trigger and Bus selection Register,    Address offset: 0x68 */
  uint32_t       RESERVED0; /*!< Reserved, 0x68                                                             */
  __IO uint32_t  CMAR;      /*!< MDMA channel x Mask address register,                 Address offset: 0x70 */
  __IO uint32_t  CMDR;      /*!< MDMA channel x Mask Data register,                    Address offset: 0x74 */
}MDMA_Channel_TypeDef;

/**
  * @brief DMA2D Controller
  */

typedef struct
{
  __IO uint32_t CR;            /*!< DMA2D Control Register,                         Address offset: 0x00 */
  __IO uint32_t ISR;           /*!< DMA2D Interrupt Status Register,                Address offset: 0x04 */
  __IO uint32_t IFCR;          /*!< DMA2D Interrupt Flag Clear Register,            Address offset: 0x08 */
  __IO uint32_t FGMAR;         /*!< DMA2D Foreground Memory Address Register,       Address offset: 0x0C */
  __IO uint32_t FGOR;          /*!< DMA2D Foreground Offset Register,               Address offset: 0x10 */
  __IO uint32_t BGMAR;         /*!< DMA2D Background Memory Address Register,       Address offset: 0x14 */
  __IO uint32_t BGOR;          /*!< DMA2D Background Offset Register,               Address offset: 0x18 */
  __IO uint32_t FGPFCCR;       /*!< DMA2D Foreground PFC Control Register,          Address offset: 0x1C */
  __IO uint32_t FGCOLR;        /*!< DMA2D Foreground Color Register,                Address offset: 0x20 */
  __IO uint32_t BGPFCCR;       /*!< DMA2D Background PFC Control Register,          Address offset: 0x24 */
  __IO uint32_t BGCOLR;        /*!< DMA2D Background Color Register,                Address offset: 0x28 */
  __IO uint32_t FGCMAR;        /*!< DMA2D Foreground CLUT Memory Address Register,  Address offset: 0x2C */
  __IO uint32_t BGCMAR;        /*!< DMA2D Background CLUT Memory Address Register,  Address offset: 0x30 */
  __IO uint32_t OPFCCR;        /*!< DMA2D Output PFC Control Register,              Address offset: 0x34 */
  __IO uint32_t OCOLR;         /*!< DMA2D Output Color Register,                    Address offset: 0x38 */
  __IO uint32_t OMAR;          /*!< DMA2D Output Memory Address Register,           Address offset: 0x3C */
  __IO uint32_t OOR;           /*!< DMA2D Output Offset Register,                   Address offset: 0x40 */
  __IO uint32_t NLR;           /*!< DMA2D Number of Line Register,                  Address offset: 0x44 */
  __IO uint32_t LWR;           /*!< DMA2D Line Watermark Register,                  Address offset: 0x48 */
  __IO uint32_t AMTCR;         /*!< DMA2D AHB Master Timer Configuration Register,  Address offset: 0x4C */
  uint32_t      RESERVED[236]; /*!< Reserved, 0x50-0x3FF */
  __IO uint32_t FGCLUT[256];   /*!< DMA2D Foreground CLUT,                          Address offset:400-7FF */
  __IO uint32_t BGCLUT[256];   /*!< DMA2D Background CLUT,                          Address offset:800-BFF */
} DMA2D_TypeDef;


/**
  * @brief Ethernet MAC
  */
typedef struct
{
  __IO uint32_t MACCR;
  __IO uint32_t MACECR;
  __IO uint32_t MACPFR;
  __IO uint32_t MACWTR;
  __IO uint32_t MACHT0R;
  __IO uint32_t MACHT1R;
  uint32_t      RESERVED1[14];
  __IO uint32_t MACVTR;
  uint32_t      RESERVED2;
  __IO uint32_t MACVHTR;
  uint32_t      RESERVED3;
  __IO uint32_t MACVIR;
  __IO uint32_t MACIVIR;
  uint32_t      RESERVED4[2];
  __IO uint32_t MACTFCR;
  uint32_t      RESERVED5[7];
  __IO uint32_t MACRFCR;
  uint32_t      RESERVED6[7];
  __IO uint32_t MACISR;
  __IO uint32_t MACIER;
  __IO uint32_t MACRXTXSR;
  uint32_t      RESERVED7;
  __IO uint32_t MACPCSR;
  __IO uint32_t MACRWKPFR;
  uint32_t      RESERVED8[2];
  __IO uint32_t MACLCSR;
  __IO uint32_t MACLTCR;
  __IO uint32_t MACLETR;
  __IO uint32_t MAC1USTCR;
  uint32_t      RESERVED9[12];
  __IO uint32_t MACVR;
  __IO uint32_t MACDR;
  uint32_t      RESERVED10;
  __IO uint32_t MACHWF0R;
  __IO uint32_t MACHWF1R;
  __IO uint32_t MACHWF2R;
  uint32_t      RESERVED11[54];
  __IO uint32_t MACMDIOAR;
  __IO uint32_t MACMDIODR;
  uint32_t      RESERVED12[2];
  __IO uint32_t MACARPAR;
  uint32_t      RESERVED13[59];
  __IO uint32_t MACA0HR;
  __IO uint32_t MACA0LR;
  __IO uint32_t MACA1HR;
  __IO uint32_t MACA1LR;
  __IO uint32_t MACA2HR;
  __IO uint32_t MACA2LR;
  __IO uint32_t MACA3HR;
  __IO uint32_t MACA3LR;
  uint32_t      RESERVED14[248];
  __IO uint32_t MMCCR;
  __IO uint32_t MMCRIR;
  __IO uint32_t MMCTIR;
  __IO uint32_t MMCRIMR;
  __IO uint32_t MMCTIMR;
  uint32_t      RESERVED15[14];
  __IO uint32_t MMCTSCGPR;
  __IO uint32_t MMCTMCGPR;
  uint32_t      RESERVED16[5];
  __IO uint32_t MMCTPCGR;
  uint32_t      RESERVED17[10];
  __IO uint32_t MMCRCRCEPR;
  __IO uint32_t MMCRAEPR;
  uint32_t      RESERVED18[10];
  __IO uint32_t MMCRUPGR;
  uint32_t      RESERVED19[9];
  __IO uint32_t MMCTLPIMSTR;
  __IO uint32_t MMCTLPITCR;
  __IO uint32_t MMCRLPIMSTR;
  __IO uint32_t MMCRLPITCR;
  uint32_t      RESERVED20[65];
  __IO uint32_t MACL3L4C0R;
  __IO uint32_t MACL4A0R;
  uint32_t      RESERVED21[2];
  __IO uint32_t MACL3A0R0R;
  __IO uint32_t MACL3A1R0R;
  __IO uint32_t MACL3A2R0R;
  __IO uint32_t MACL3A3R0R;
  uint32_t      RESERVED22[4];
  __IO uint32_t MACL3L4C1R;
  __IO uint32_t MACL4A1R;
  uint32_t      RESERVED23[2];
  __IO uint32_t MACL3A0R1R;
  __IO uint32_t MACL3A1R1R;
  __IO uint32_t MACL3A2R1R;
  __IO uint32_t MACL3A3R1R;
  uint32_t      RESERVED24[108];
  __IO uint32_t MACTSCR;
  __IO uint32_t MACSSIR;
  __IO uint32_t MACSTSR;
  __IO uint32_t MACSTNR;
  __IO uint32_t MACSTSUR;
  __IO uint32_t MACSTNUR;
  __IO uint32_t MACTSAR;
  uint32_t      RESERVED25;
  __IO uint32_t MACTSSR;
  uint32_t      RESERVED26[3];
  __IO uint32_t MACTTSSNR;
  __IO uint32_t MACTTSSSR;
  uint32_t      RESERVED27[2];
  __IO uint32_t MACACR;
  uint32_t      RESERVED28;
  __IO uint32_t MACATSNR;
  __IO uint32_t MACATSSR;
  __IO uint32_t MACTSIACR;
  __IO uint32_t MACTSEACR;
  __IO uint32_t MACTSICNR;
  __IO uint32_t MACTSECNR;
  uint32_t      RESERVED29[4];
  __IO uint32_t MACPPSCR;
  uint32_t      RESERVED30[3];
  __IO uint32_t MACPPSTTSR;
  __IO uint32_t MACPPSTTNR;
  __IO uint32_t MACPPSIR;
  __IO uint32_t MACPPSWR;
  uint32_t      RESERVED31[12];
  __IO uint32_t MACPOCR;
  __IO uint32_t MACSPI0R;
  __IO uint32_t MACSPI1R;
  __IO uint32_t MACSPI2R;
  __IO uint32_t MACLMIR;
  uint32_t      RESERVED32[11];
  __IO uint32_t MTLOMR;
  uint32_t      RESERVED33[7];
  __IO uint32_t MTLISR;
  uint32_t      RESERVED34[55];
  __IO uint32_t MTLTQOMR;
  __IO uint32_t MTLTQUR;
  __IO uint32_t MTLTQDR;
  uint32_t      RESERVED35[8];
  __IO uint32_t MTLQICSR;
  __IO uint32_t MTLRQOMR;
  __IO uint32_t MTLRQMPOCR;
  __IO uint32_t MTLRQDR;
  uint32_t      RESERVED36[177];
  __IO uint32_t DMAMR;
  __IO uint32_t DMASBMR;
  __IO uint32_t DMAISR;
  __IO uint32_t DMADSR;
  uint32_t      RESERVED37[60];
  __IO uint32_t DMACCR;
  __IO uint32_t DMACTCR;
  __IO uint32_t DMACRCR;
  uint32_t      RESERVED38[2];
  __IO uint32_t DMACTDLAR;
  uint32_t      RESERVED39;
  __IO uint32_t DMACRDLAR;
  __IO uint32_t DMACTDTPR;
  uint32_t      RESERVED40;
  __IO uint32_t DMACRDTPR;
  __IO uint32_t DMACTDRLR;
  __IO uint32_t DMACRDRLR;
  __IO uint32_t DMACIER;
  __IO uint32_t DMACRIWTR;
__IO uint32_t DMACSFCSR;
  uint32_t      RESERVED41;
  __IO uint32_t DMACCATDR;
  uint32_t      RESERVED42;
  __IO uint32_t DMACCARDR;
  uint32_t      RESERVED43;
  __IO uint32_t DMACCATBR;
  uint32_t      RESERVED44;
  __IO uint32_t DMACCARBR;
  __IO uint32_t DMACSR;
uint32_t      RESERVED45[2];
__IO uint32_t DMACMFCR;
}ETH_TypeDef;
/**
  * @brief External Interrupt/Event Controller
  */

typedef struct
{
__IO uint32_t RTSR1;               /*!< EXTI Rising trigger selection register,          Address offset: 0x00 */
__IO uint32_t FTSR1;               /*!< EXTI Falling trigger selection register,         Address offset: 0x04 */
__IO uint32_t SWIER1;              /*!< EXTI Software interrupt event register,          Address offset: 0x08 */
__IO uint32_t D3PMR1;              /*!< EXTI D3 Pending mask register, (same register as to SRDPMR1) Address offset: 0x0C */
__IO uint32_t D3PCR1L;             /*!< EXTI D3 Pending clear selection register low, (same register as to SRDPCR1L)     Address offset: 0x10 */
__IO uint32_t D3PCR1H;             /*!< EXTI D3 Pending clear selection register High, (same register as to SRDPCR1H)   Address offset: 0x14 */
uint32_t      RESERVED1[2];        /*!< Reserved,                                        0x18 to 0x1C         */
__IO uint32_t RTSR2;               /*!< EXTI Rising trigger selection register,          Address offset: 0x20 */
__IO uint32_t FTSR2;               /*!< EXTI Falling trigger selection register,         Address offset: 0x24 */
__IO uint32_t SWIER2;              /*!< EXTI Software interrupt event register,          Address offset: 0x28 */
__IO uint32_t D3PMR2;              /*!< EXTI D3 Pending mask register, (same register as to SRDPMR2) Address offset: 0x2C */
__IO uint32_t D3PCR2L;             /*!< EXTI D3 Pending clear selection register low, (same register as to SRDPCR2L)  Address offset: 0x30 */
__IO uint32_t D3PCR2H;             /*!< EXTI D3 Pending clear selection register High, (same register as to SRDPCR2H) Address offset: 0x34 */
uint32_t      RESERVED2[2];        /*!< Reserved,                                        0x38 to 0x3C         */
__IO uint32_t RTSR3;               /*!< EXTI Rising trigger selection register,          Address offset: 0x40 */
__IO uint32_t FTSR3;               /*!< EXTI Falling trigger selection register,         Address offset: 0x44 */
__IO uint32_t SWIER3;              /*!< EXTI Software interrupt event register,          Address offset: 0x48 */
__IO uint32_t D3PMR3;              /*!< EXTI D3 Pending mask register, (same register as to SRDPMR3) Address offset: 0x4C */
__IO uint32_t D3PCR3L;             /*!< EXTI D3 Pending clear selection register low, (same register as to SRDPCR3L) Address offset: 0x50 */
__IO uint32_t D3PCR3H;             /*!< EXTI D3 Pending clear selection register High, (same register as to SRDPCR3H) Address offset: 0x54 */
uint32_t      RESERVED3[10];       /*!< Reserved,                                        0x58 to 0x7C         */
__IO uint32_t IMR1;                /*!< EXTI Interrupt mask register,                    Address offset: 0x80 */
__IO uint32_t EMR1;                /*!< EXTI Event mask register,                        Address offset: 0x84 */
__IO uint32_t PR1;                 /*!< EXTI Pending register,                           Address offset: 0x88 */
uint32_t      RESERVED4;           /*!< Reserved,                                        0x8C                 */
__IO uint32_t IMR2;                /*!< EXTI Interrupt mask register,                    Address offset: 0x90 */
__IO uint32_t EMR2;                /*!< EXTI Event mask register,                        Address offset: 0x94 */
__IO uint32_t PR2;                 /*!< EXTI Pending register,                           Address offset: 0x98 */
uint32_t      RESERVED5;           /*!< Reserved,                                        0x9C                 */
__IO uint32_t IMR3;                /*!< EXTI Interrupt mask register,                    Address offset: 0xA0 */
__IO uint32_t EMR3;                /*!< EXTI Event mask register,                        Address offset: 0xA4 */
__IO uint32_t PR3;                 /*!< EXTI Pending register,                           Address offset: 0xA8 */
}EXTI_TypeDef;

typedef struct
{
__IO uint32_t IMR1;                /*!< EXTI Interrupt mask register,                Address offset: 0x00 */
__IO uint32_t EMR1;                /*!< EXTI Event mask register,                    Address offset: 0x04 */
__IO uint32_t PR1;                 /*!< EXTI Pending register,                       Address offset: 0x08 */
uint32_t      RESERVED1;           /*!< Reserved, 0x0C                                                    */
__IO uint32_t IMR2;                /*!< EXTI Interrupt mask register,                Address offset: 0x10 */
__IO uint32_t EMR2;                /*!< EXTI Event mask register,                    Address offset: 0x14 */
__IO uint32_t PR2;                 /*!< EXTI Pending register,                       Address offset: 0x18 */
uint32_t      RESERVED2;           /*!< Reserved, 0x1C                                                    */
__IO uint32_t IMR3;                /*!< EXTI Interrupt mask register,                Address offset: 0x20 */
__IO uint32_t EMR3;                /*!< EXTI Event mask register,                    Address offset: 0x24 */
__IO uint32_t PR3;                 /*!< EXTI Pending register,                       Address offset: 0x28 */
}EXTI_Core_TypeDef;


/**
  * @brief FLASH Registers
  */

typedef struct
{
  __IO uint32_t ACR;             /*!< FLASH access control register,                            Address offset: 0x00  */
  __IO uint32_t KEYR1;           /*!< Flash Key Register for bank1,                             Address offset: 0x04  */
  __IO uint32_t OPTKEYR;         /*!< Flash Option Key Register,                                Address offset: 0x08  */
  __IO uint32_t CR1;             /*!< Flash Control Register for bank1,                         Address offset: 0x0C  */
  __IO uint32_t SR1;             /*!< Flash Status Register for bank1,                          Address offset: 0x10  */
  __IO uint32_t CCR1;            /*!< Flash Control Register for bank1,                         Address offset: 0x14  */
  __IO uint32_t OPTCR;           /*!< Flash Option Control Register,                            Address offset: 0x18  */
  __IO uint32_t OPTSR_CUR;       /*!< Flash Option Status Current Register,                     Address offset: 0x1C  */
  __IO uint32_t OPTSR_PRG;       /*!< Flash Option Status to Program Register,                  Address offset: 0x20  */
  __IO uint32_t OPTCCR;          /*!< Flash Option Clear Control Register,                      Address offset: 0x24  */
  __IO uint32_t PRAR_CUR1;       /*!< Flash Current Protection Address Register for bank1,      Address offset: 0x28  */
  __IO uint32_t PRAR_PRG1;       /*!< Flash Protection Address to Program Register for bank1,   Address offset: 0x2C  */
  __IO uint32_t SCAR_CUR1;       /*!< Flash Current Secure Address Register for bank1,          Address offset: 0x30  */
  __IO uint32_t SCAR_PRG1;       /*!< Flash Secure Address to Program Register for bank1,       Address offset: 0x34  */
  __IO uint32_t WPSN_CUR1;       /*!< Flash Current Write Protection Register on bank1,         Address offset: 0x38  */
  __IO uint32_t WPSN_PRG1;       /*!< Flash Write Protection to Program Register on bank1,      Address offset: 0x3C  */
  __IO uint32_t BOOT_CUR;        /*!< Flash Current Boot Address for Pelican Core Register,     Address offset: 0x40  */
  __IO uint32_t BOOT_PRG;        /*!< Flash Boot Address to Program for Pelican Core Register,  Address offset: 0x44  */
  uint32_t      RESERVED0[2];    /*!< Reserved, 0x48 to 0x4C                                                          */
  __IO uint32_t CRCCR1;          /*!< Flash CRC Control register For Bank1 Register ,           Address offset: 0x50  */
  __IO uint32_t CRCSADD1;        /*!< Flash CRC Start Address Register for Bank1 ,              Address offset: 0x54  */
  __IO uint32_t CRCEADD1;        /*!< Flash CRC End Address Register for Bank1 ,                Address offset: 0x58  */
  __IO uint32_t CRCDATA;         /*!< Flash CRC Data Register for Bank1 ,                       Address offset: 0x5C  */
  __IO uint32_t ECC_FA1;         /*!< Flash ECC Fail Address For Bank1 Register ,               Address offset: 0x60  */
  uint32_t      RESERVED[3];     /*!< Reserved, 0x64 to 0x6C                                                          */
  __IO uint32_t OPTSR2_CUR;      /*!< Flash Option Status Current Register 2,                   Address offset: 0x70  */
  __IO uint32_t OPTSR2_PRG;      /*!< Flash Option Status to Program Register 2,                Address offset: 0x74  */
} FLASH_TypeDef;

/**
  * @brief Filter and Mathematical ACcelerator
  */
typedef struct
{
  __IO uint32_t X1BUFCFG;        /*!< FMAC X1 Buffer Configuration register, Address offset: 0x00          */
  __IO uint32_t X2BUFCFG;        /*!< FMAC X2 Buffer Configuration register, Address offset: 0x04          */
  __IO uint32_t YBUFCFG;         /*!< FMAC Y Buffer Configuration register,  Address offset: 0x08          */
  __IO uint32_t PARAM;           /*!< FMAC Parameter register,               Address offset: 0x0C          */
  __IO uint32_t CR;              /*!< FMAC Control register,                 Address offset: 0x10          */
  __IO uint32_t SR;              /*!< FMAC Status register,                  Address offset: 0x14          */
  __IO uint32_t WDATA;           /*!< FMAC Write Data register,              Address offset: 0x18          */
  __IO uint32_t RDATA;           /*!< FMAC Read Data register,               Address offset: 0x1C          */
} FMAC_TypeDef;

/**
  * @brief Flexible Memory Controller
  */

typedef struct
{
  __IO uint32_t BTCR[8];    /*!< NOR/PSRAM chip-select control register(BCR) and chip-select timing register(BTR), Address offset: 0x00-1C */
} FMC_Bank1_TypeDef;

/**
  * @brief Flexible Memory Controller Bank1E
  */

typedef struct
{
  __IO uint32_t BWTR[7];    /*!< NOR/PSRAM write timing registers, Address offset: 0x104-0x11C */
} FMC_Bank1E_TypeDef;

/**
  * @brief Flexible Memory Controller Bank2
  */

typedef struct
{
  __IO uint32_t PCR2;       /*!< NAND Flash control register 2,                       Address offset: 0x60 */
  __IO uint32_t SR2;        /*!< NAND Flash FIFO status and interrupt register 2,     Address offset: 0x64 */
  __IO uint32_t PMEM2;      /*!< NAND Flash Common memory space timing register 2,    Address offset: 0x68 */
  __IO uint32_t PATT2;      /*!< NAND Flash Attribute memory space timing register 2, Address offset: 0x6C */
  uint32_t      RESERVED0;  /*!< Reserved, 0x70                                                            */
  __IO uint32_t ECCR2;      /*!< NAND Flash ECC result registers 2,                   Address offset: 0x74 */
} FMC_Bank2_TypeDef;

/**
  * @brief Flexible Memory Controller Bank3
  */

typedef struct
{
  __IO uint32_t PCR;       /*!< NAND Flash control register 3,                       Address offset: 0x80 */
  __IO uint32_t SR;        /*!< NAND Flash FIFO status and interrupt register 3,     Address offset: 0x84 */
  __IO uint32_t PMEM;      /*!< NAND Flash Common memory space timing register 3,    Address offset: 0x88 */
  __IO uint32_t PATT;      /*!< NAND Flash Attribute memory space timing register 3, Address offset: 0x8C */
  uint32_t      RESERVED;  /*!< Reserved, 0x90                                                            */
  __IO uint32_t ECCR;      /*!< NAND Flash ECC result registers 3,                   Address offset: 0x94 */
} FMC_Bank3_TypeDef;

/**
  * @brief Flexible Memory Controller Bank5 and 6
  */


typedef struct
{
  __IO uint32_t SDCR[2];        /*!< SDRAM Control registers ,      Address offset: 0x140-0x144  */
  __IO uint32_t SDTR[2];        /*!< SDRAM Timing registers ,       Address offset: 0x148-0x14C  */
  __IO uint32_t SDCMR;       /*!< SDRAM Command Mode register,    Address offset: 0x150  */
  __IO uint32_t SDRTR;       /*!< SDRAM Refresh Timer register,   Address offset: 0x154  */
  __IO uint32_t SDSR;        /*!< SDRAM Status register,          Address offset: 0x158  */
} FMC_Bank5_6_TypeDef;

/**
  * @brief General Purpose I/O
  */

typedef struct
{
  __IO uint32_t MODER;    /*!< GPIO port mode register,               Address offset: 0x00      */
  __IO uint32_t OTYPER;   /*!< GPIO port output type register,        Address offset: 0x04      */
  __IO uint32_t OSPEEDR;  /*!< GPIO port output speed register,       Address offset: 0x08      */
  __IO uint32_t PUPDR;    /*!< GPIO port pull-up/pull-down register,  Address offset: 0x0C      */
  __IO uint32_t IDR;      /*!< GPIO port input data register,         Address offset: 0x10      */
  __IO uint32_t ODR;      /*!< GPIO port output data register,        Address offset: 0x14      */
  __IO uint32_t BSRR;     /*!< GPIO port bit set/reset,               Address offset: 0x18      */
  __IO uint32_t LCKR;     /*!< GPIO port configuration lock register, Address offset: 0x1C      */
  __IO uint32_t AFR[2];   /*!< GPIO alternate function registers,     Address offset: 0x20-0x24 */
} GPIO_TypeDef;

/**
  * @brief Operational Amplifier (OPAMP)
  */

typedef struct
{
  __IO uint32_t CSR;          /*!< OPAMP control/status register,                      Address offset: 0x00 */
  __IO uint32_t OTR;          /*!< OPAMP offset trimming register for normal mode,     Address offset: 0x04 */
  __IO uint32_t HSOTR;        /*!< OPAMP offset trimming register for high speed mode, Address offset: 0x08 */
} OPAMP_TypeDef;

/**
  * @brief System configuration controller
  */

typedef struct
{
 uint32_t RESERVED1;           /*!< Reserved,                                           Address offset: 0x00        */
 __IO uint32_t PMCR;           /*!< SYSCFG peripheral mode configuration register,      Address offset: 0x04        */
 __IO uint32_t EXTICR[4];      /*!< SYSCFG external interrupt configuration registers,  Address offset: 0x08-0x14   */
 __IO uint32_t CFGR;           /*!< SYSCFG configuration registers,                     Address offset: 0x18        */
 uint32_t RESERVED2;           /*!< Reserved,                                           Address offset: 0x1C        */
 __IO uint32_t CCCSR;          /*!< SYSCFG compensation cell control/status register,   Address offset: 0x20        */
 __IO uint32_t CCVR;           /*!< SYSCFG compensation cell value register,            Address offset: 0x24        */
 __IO uint32_t CCCR;           /*!< SYSCFG compensation cell code register,             Address offset: 0x28        */
 uint32_t     RESERVED3;       /*!< Reserved,                                           Address offset: 0x2C        */
 __IO uint32_t ADC2ALT;        /*!< ADC2 internal input alternate connection register,  Address offset: 0x30        */
 uint32_t     RESERVED4[60];   /*!< Reserved, 0x34-0x120                                                            */
  __IO uint32_t PKGR;          /*!< SYSCFG package register,                            Address offset: 0x124       */
  uint32_t     RESERVED5[118]; /*!< Reserved, 0x128-0x2FC                                                           */
 __IO uint32_t UR0;            /*!< SYSCFG user register 0,                             Address offset: 0x300       */
 __IO uint32_t UR1;            /*!< SYSCFG user register 1,                             Address offset: 0x304       */
 __IO uint32_t UR2;            /*!< SYSCFG user register 2,                             Address offset: 0x308       */
 __IO uint32_t UR3;            /*!< SYSCFG user register 3,                             Address offset: 0x30C       */
 __IO uint32_t UR4;            /*!< SYSCFG user register 4,                             Address offset: 0x310       */
 __IO uint32_t UR5;            /*!< SYSCFG user register 5,                             Address offset: 0x314       */
 __IO uint32_t UR6;            /*!< SYSCFG user register 6,                             Address offset: 0x318       */
 __IO uint32_t UR7;            /*!< SYSCFG user register 7,                             Address offset: 0x31C       */
 uint32_t     RESERVED6[3];    /*!< Reserved,                                           Address offset: 0x320-0x328 */
 __IO uint32_t UR11;           /*!< SYSCFG user register 11,                            Address offset: 0x32C       */
 __IO uint32_t UR12;           /*!< SYSCFG user register 12,                            Address offset: 0x330       */
 __IO uint32_t UR13;           /*!< SYSCFG user register 13,                            Address offset: 0x334       */
 __IO uint32_t UR14;           /*!< SYSCFG user register 14,                            Address offset: 0x338       */
 __IO uint32_t UR15;           /*!< SYSCFG user register 15,                            Address offset: 0x33C       */
 __IO uint32_t UR16;           /*!< SYSCFG user register 16,                            Address offset: 0x340       */
 __IO uint32_t UR17;           /*!< SYSCFG user register 17,                            Address offset: 0x344       */
 __IO uint32_t UR18;           /*!< SYSCFG user register 18,                            Address offset: 0x348       */

} SYSCFG_TypeDef;

/**
  * @brief Inter-integrated Circuit Interface
  */

typedef struct
{
  __IO uint32_t CR1;      /*!< I2C Control register 1,            Address offset: 0x00 */
  __IO uint32_t CR2;      /*!< I2C Control register 2,            Address offset: 0x04 */
  __IO uint32_t OAR1;     /*!< I2C Own address 1 register,        Address offset: 0x08 */
  __IO uint32_t OAR2;     /*!< I2C Own address 2 register,        Address offset: 0x0C */
  __IO uint32_t TIMINGR;  /*!< I2C Timing register,               Address offset: 0x10 */
  __IO uint32_t TIMEOUTR; /*!< I2C Timeout register,              Address offset: 0x14 */
  __IO uint32_t ISR;      /*!< I2C Interrupt and status register, Address offset: 0x18 */
  __IO uint32_t ICR;      /*!< I2C Interrupt clear register,      Address offset: 0x1C */
  __IO uint32_t PECR;     /*!< I2C PEC register,                  Address offset: 0x20 */
  __IO uint32_t RXDR;     /*!< I2C Receive data register,         Address offset: 0x24 */
  __IO uint32_t TXDR;     /*!< I2C Transmit data register,        Address offset: 0x28 */
} I2C_TypeDef;

/**
  * @brief Independent WATCHDOG
  */

typedef struct
{
  __IO uint32_t KR;   /*!< IWDG Key register,       Address offset: 0x00 */
  __IO uint32_t PR;   /*!< IWDG Prescaler register, Address offset: 0x04 */
  __IO uint32_t RLR;  /*!< IWDG Reload register,    Address offset: 0x08 */
  __IO uint32_t SR;   /*!< IWDG Status register,    Address offset: 0x0C */
  __IO uint32_t WINR; /*!< IWDG Window register,    Address offset: 0x10 */
} IWDG_TypeDef;


/**
  * @brief LCD-TFT Display Controller
  */

typedef struct
{
  uint32_t      RESERVED0[2];  /*!< Reserved, 0x00-0x04                                                       */
  __IO uint32_t SSCR;          /*!< LTDC Synchronization Size Configuration Register,    Address offset: 0x08 */
  __IO uint32_t BPCR;          /*!< LTDC Back Porch Configuration Register,              Address offset: 0x0C */
  __IO uint32_t AWCR;          /*!< LTDC Active Width Configuration Register,            Address offset: 0x10 */
  __IO uint32_t TWCR;          /*!< LTDC Total Width Configuration Register,             Address offset: 0x14 */
  __IO uint32_t GCR;           /*!< LTDC Global Control Register,                        Address offset: 0x18 */
  uint32_t      RESERVED1[2];  /*!< Reserved, 0x1C-0x20                                                       */
  __IO uint32_t SRCR;          /*!< LTDC Shadow Reload Configuration Register,           Address offset: 0x24 */
  uint32_t      RESERVED2[1];  /*!< Reserved, 0x28                                                            */
  __IO uint32_t BCCR;          /*!< LTDC Background Color Configuration Register,        Address offset: 0x2C */
  uint32_t      RESERVED3[1];  /*!< Reserved, 0x30                                                            */
  __IO uint32_t IER;           /*!< LTDC Interrupt Enable Register,                      Address offset: 0x34 */
  __IO uint32_t ISR;           /*!< LTDC Interrupt Status Register,                      Address offset: 0x38 */
  __IO uint32_t ICR;           /*!< LTDC Interrupt Clear Register,                       Address offset: 0x3C */
  __IO uint32_t LIPCR;         /*!< LTDC Line Interrupt Position Configuration Register, Address offset: 0x40 */
  __IO uint32_t CPSR;          /*!< LTDC Current Position Status Register,               Address offset: 0x44 */
  __IO uint32_t CDSR;         /*!< LTDC Current Display Status Register,                 Address offset: 0x48 */
} LTDC_TypeDef;

/**
  * @brief LCD-TFT Display layer x Controller
  */

typedef struct
{
  __IO uint32_t CR;            /*!< LTDC Layerx Control Register                                  Address offset: 0x84 */
  __IO uint32_t WHPCR;         /*!< LTDC Layerx Window Horizontal Position Configuration Register Address offset: 0x88 */
  __IO uint32_t WVPCR;         /*!< LTDC Layerx Window Vertical Position Configuration Register   Address offset: 0x8C */
  __IO uint32_t CKCR;          /*!< LTDC Layerx Color Keying Configuration Register               Address offset: 0x90 */
  __IO uint32_t PFCR;          /*!< LTDC Layerx Pixel Format Configuration Register               Address offset: 0x94 */
  __IO uint32_t CACR;          /*!< LTDC Layerx Constant Alpha Configuration Register             Address offset: 0x98 */
  __IO uint32_t DCCR;          /*!< LTDC Layerx Default Color Configuration Register              Address offset: 0x9C */
  __IO uint32_t BFCR;          /*!< LTDC Layerx Blending Factors Configuration Register           Address offset: 0xA0 */
  uint32_t      RESERVED0[2];  /*!< Reserved */
  __IO uint32_t CFBAR;         /*!< LTDC Layerx Color Frame Buffer Address Register               Address offset: 0xAC */
  __IO uint32_t CFBLR;         /*!< LTDC Layerx Color Frame Buffer Length Register                Address offset: 0xB0 */
  __IO uint32_t CFBLNR;        /*!< LTDC Layerx ColorFrame Buffer Line Number Register            Address offset: 0xB4 */
  uint32_t      RESERVED1[3];  /*!< Reserved */
  __IO uint32_t CLUTWR;         /*!< LTDC Layerx CLUT Write Register                               Address offset: 0x144 */

} LTDC_Layer_TypeDef;

/**
  * @brief Power Control
  */

typedef struct
{
  __IO uint32_t CR1;       /*!< PWR power control register 1,            Address offset: 0x00 */
  __IO uint32_t CSR1;      /*!< PWR power control status register 1,     Address offset: 0x04 */
  __IO uint32_t CR2;       /*!< PWR power control register 2,            Address offset: 0x08 */
  __IO uint32_t CR3;       /*!< PWR power control register 3,            Address offset: 0x0C */
  __IO uint32_t CPUCR;     /*!< PWR CPU control register,                Address offset: 0x10 */
       uint32_t RESERVED0; /*!< Reserved,                                Address offset: 0x14 */
  __IO uint32_t D3CR;      /*!< PWR D3 domain control register,          Address offset: 0x18 */
       uint32_t RESERVED1; /*!< Reserved,                                Address offset: 0x1C */
  __IO uint32_t WKUPCR;    /*!< PWR wakeup clear register,               Address offset: 0x20 */
  __IO uint32_t WKUPFR;    /*!< PWR wakeup flag register,                Address offset: 0x24 */
  __IO uint32_t WKUPEPR;   /*!< PWR wakeup enable and polarity register, Address offset: 0x28 */
} PWR_TypeDef;

/**
  * @brief Reset and Clock Control
  */

typedef struct
{
 __IO uint32_t CR;             /*!< RCC clock control register,                                              Address offset: 0x00  */
 __IO uint32_t HSICFGR;        /*!< HSI Clock Calibration Register,                                          Address offset: 0x04  */
 __IO uint32_t CRRCR;          /*!< Clock Recovery RC  Register,                                             Address offset: 0x08  */
 __IO uint32_t CSICFGR;        /*!< CSI Clock Calibration Register,                                          Address offset: 0x0C  */
 __IO uint32_t CFGR;           /*!< RCC clock configuration register,                                        Address offset: 0x10  */
 uint32_t     RESERVED1;       /*!< Reserved,                                                                Address offset: 0x14  */
 __IO uint32_t D1CFGR;         /*!< RCC Domain 1 configuration register,                                     Address offset: 0x18  */
 __IO uint32_t D2CFGR;         /*!< RCC Domain 2 configuration register,                                     Address offset: 0x1C  */
 __IO uint32_t D3CFGR;         /*!< RCC Domain 3 configuration register,                                     Address offset: 0x20  */
 uint32_t     RESERVED2;       /*!< Reserved,                                                                Address offset: 0x24  */
 __IO uint32_t PLLCKSELR;      /*!< RCC PLLs Clock Source Selection Register,                                Address offset: 0x28  */
 __IO uint32_t PLLCFGR;        /*!< RCC PLLs  Configuration Register,                                        Address offset: 0x2C  */
 __IO uint32_t PLL1DIVR;       /*!< RCC PLL1 Dividers Configuration Register,                                Address offset: 0x30  */
 __IO uint32_t PLL1FRACR;      /*!< RCC PLL1 Fractional Divider Configuration Register,                      Address offset: 0x34  */
 __IO uint32_t PLL2DIVR;       /*!< RCC PLL2 Dividers Configuration Register,                                Address offset: 0x38  */
 __IO uint32_t PLL2FRACR;      /*!< RCC PLL2 Fractional Divider Configuration Register,                      Address offset: 0x3C  */
 __IO uint32_t PLL3DIVR;       /*!< RCC PLL3 Dividers Configuration Register,                                Address offset: 0x40  */
 __IO uint32_t PLL3FRACR;      /*!< RCC PLL3 Fractional Divider Configuration Register,                      Address offset: 0x44  */
 uint32_t      RESERVED3;      /*!< Reserved,                                                                Address offset: 0x48  */
 __IO uint32_t  D1CCIPR;       /*!< RCC Domain 1 Kernel Clock Configuration Register                         Address offset: 0x4C  */
 __IO uint32_t  D2CCIP1R;      /*!< RCC Domain 2 Kernel Clock Configuration Register                         Address offset: 0x50  */
 __IO uint32_t  D2CCIP2R;      /*!< RCC Domain 2 Kernel Clock Configuration Register                         Address offset: 0x54  */
 __IO uint32_t  D3CCIPR;       /*!< RCC Domain 3 Kernel Clock Configuration Register                         Address offset: 0x58  */
 uint32_t      RESERVED4;      /*!< Reserved,                                                                Address offset: 0x5C  */
 __IO uint32_t  CIER;          /*!< RCC Clock Source Interrupt Enable Register                               Address offset: 0x60  */
 __IO uint32_t  CIFR;          /*!< RCC Clock Source Interrupt Flag Register                                 Address offset: 0x64  */
 __IO uint32_t  CICR;          /*!< RCC Clock Source Interrupt Clear Register                                Address offset: 0x68  */
 uint32_t     RESERVED5;       /*!< Reserved,                                                                Address offset: 0x6C  */
 __IO uint32_t  BDCR;          /*!< RCC Vswitch Backup Domain Control Register,                              Address offset: 0x70  */
 __IO uint32_t  CSR;           /*!< RCC clock control & status register,                                     Address offset: 0x74  */
 uint32_t     RESERVED6;       /*!< Reserved,                                                                Address offset: 0x78  */
 __IO uint32_t AHB3RSTR;       /*!< RCC AHB3 peripheral reset register,                                      Address offset: 0x7C  */
 __IO uint32_t AHB1RSTR;       /*!< RCC AHB1 peripheral reset register,                                      Address offset: 0x80  */
 __IO uint32_t AHB2RSTR;       /*!< RCC AHB2 peripheral reset register,                                      Address offset: 0x84  */
 __IO uint32_t AHB4RSTR;       /*!< RCC AHB4 peripheral reset register,                                      Address offset: 0x88  */
 __IO uint32_t APB3RSTR;       /*!< RCC APB3 peripheral reset register,                                      Address offset: 0x8C  */
 __IO uint32_t APB1LRSTR;      /*!< RCC APB1 peripheral reset Low Word register,                             Address offset: 0x90  */
 __IO uint32_t APB1HRSTR;      /*!< RCC APB1 peripheral reset High Word register,                            Address offset: 0x94  */
 __IO uint32_t APB2RSTR;       /*!< RCC APB2 peripheral reset register,                                      Address offset: 0x98  */
 __IO uint32_t APB4RSTR;       /*!< RCC APB4 peripheral reset register,                                      Address offset: 0x9C  */
 __IO uint32_t GCR;            /*!< RCC RCC Global Control  Register,                                        Address offset: 0xA0  */
 uint32_t     RESERVED8;       /*!< Reserved,                                                                Address offset: 0xA4  */
 __IO uint32_t D3AMR;          /*!< RCC Domain 3 Autonomous Mode Register,                                   Address offset: 0xA8  */
 uint32_t     RESERVED11[9];    /*!< Reserved, 0xAC-0xCC                                                      Address offset: 0xAC  */
 __IO uint32_t RSR;            /*!< RCC Reset status register,                                               Address offset: 0xD0  */
 __IO uint32_t AHB3ENR;        /*!< RCC AHB3 peripheral clock  register,                                     Address offset: 0xD4  */
 __IO uint32_t AHB1ENR;        /*!< RCC AHB1 peripheral clock  register,                                     Address offset: 0xD8  */
 __IO uint32_t AHB2ENR;        /*!< RCC AHB2 peripheral clock  register,                                     Address offset: 0xDC  */
 __IO uint32_t AHB4ENR;        /*!< RCC AHB4 peripheral clock  register,                                     Address offset: 0xE0  */
 __IO uint32_t APB3ENR;        /*!< RCC APB3 peripheral clock  register,                                     Address offset: 0xE4  */
 __IO uint32_t APB1LENR;       /*!< RCC APB1 peripheral clock  Low Word register,                            Address offset: 0xE8  */
 __IO uint32_t APB1HENR;       /*!< RCC APB1 peripheral clock  High Word register,                           Address offset: 0xEC  */
 __IO uint32_t APB2ENR;        /*!< RCC APB2 peripheral clock  register,                                     Address offset: 0xF0  */
 __IO uint32_t APB4ENR;        /*!< RCC APB4 peripheral clock  register,                                     Address offset: 0xF4  */
 uint32_t      RESERVED12;      /*!< Reserved,                                                                Address offset: 0xF8  */
 __IO uint32_t AHB3LPENR;      /*!< RCC AHB3 peripheral sleep clock  register,                               Address offset: 0xFC  */
 __IO uint32_t AHB1LPENR;      /*!< RCC AHB1 peripheral sleep clock  register,                               Address offset: 0x100 */
 __IO uint32_t AHB2LPENR;      /*!< RCC AHB2 peripheral sleep clock  register,                               Address offset: 0x104 */
 __IO uint32_t AHB4LPENR;      /*!< RCC AHB4 peripheral sleep clock  register,                               Address offset: 0x108 */
 __IO uint32_t APB3LPENR;      /*!< RCC APB3 peripheral sleep clock  register,                               Address offset: 0x10C */
 __IO uint32_t APB1LLPENR;     /*!< RCC APB1 peripheral sleep clock  Low Word register,                      Address offset: 0x110 */
 __IO uint32_t APB1HLPENR;     /*!< RCC APB1 peripheral sleep clock  High Word register,                     Address offset: 0x114 */
 __IO uint32_t APB2LPENR;      /*!< RCC APB2 peripheral sleep clock  register,                               Address offset: 0x118 */
 __IO uint32_t APB4LPENR;      /*!< RCC APB4 peripheral sleep clock  register,                               Address offset: 0x11C */
 uint32_t     RESERVED13[4];   /*!< Reserved, 0x120-0x12C                                                    Address offset: 0x120 */

} RCC_TypeDef;


/**
  * @brief Real-Time Clock
  */
typedef struct
{
  __IO uint32_t TR;         /*!< RTC time register,                                         Address offset: 0x00 */
  __IO uint32_t DR;         /*!< RTC date register,                                         Address offset: 0x04 */
  __IO uint32_t CR;         /*!< RTC control register,                                      Address offset: 0x08 */
  __IO uint32_t ISR;        /*!< RTC initialization and status register,                    Address offset: 0x0C */
  __IO uint32_t PRER;       /*!< RTC prescaler register,                                    Address offset: 0x10 */
  __IO uint32_t WUTR;       /*!< RTC wakeup timer register,                                 Address offset: 0x14 */
       uint32_t RESERVED;   /*!< Reserved,                                                  Address offset: 0x18 */
  __IO uint32_t ALRMAR;     /*!< RTC alarm A register,                                      Address offset: 0x1C */
  __IO uint32_t ALRMBR;     /*!< RTC alarm B register,                                      Address offset: 0x20 */
  __IO uint32_t WPR;        /*!< RTC write protection register,                             Address offset: 0x24 */
  __IO uint32_t SSR;        /*!< RTC sub second register,                                   Address offset: 0x28 */
  __IO uint32_t SHIFTR;     /*!< RTC shift control register,                                Address offset: 0x2C */
  __IO uint32_t TSTR;       /*!< RTC time stamp time register,                              Address offset: 0x30 */
  __IO uint32_t TSDR;       /*!< RTC time stamp date register,                              Address offset: 0x34 */
  __IO uint32_t TSSSR;      /*!< RTC time-stamp sub second register,                        Address offset: 0x38 */
  __IO uint32_t CALR;       /*!< RTC calibration register,                                  Address offset: 0x3C */
  __IO uint32_t TAMPCR;     /*!< RTC tamper configuration register,                         Address offset: 0x40 */
  __IO uint32_t ALRMASSR;   /*!< RTC alarm A sub second register,                           Address offset: 0x44 */
  __IO uint32_t ALRMBSSR;   /*!< RTC alarm B sub second register,                           Address offset: 0x48 */
  __IO uint32_t OR;         /*!< RTC option register,                                       Address offset: 0x4C */
  __IO uint32_t BKP0R;      /*!< RTC backup register 0,                                     Address offset: 0x50 */
  __IO uint32_t BKP1R;      /*!< RTC backup register 1,                                     Address offset: 0x54 */
  __IO uint32_t BKP2R;      /*!< RTC backup register 2,                                     Address offset: 0x58 */
  __IO uint32_t BKP3R;      /*!< RTC backup register 3,                                     Address offset: 0x5C */
  __IO uint32_t BKP4R;      /*!< RTC backup register 4,                                     Address offset: 0x60 */
  __IO uint32_t BKP5R;      /*!< RTC backup register 5,                                     Address offset: 0x64 */
  __IO uint32_t BKP6R;      /*!< RTC backup register 6,                                     Address offset: 0x68 */
  __IO uint32_t BKP7R;      /*!< RTC backup register 7,                                     Address offset: 0x6C */
  __IO uint32_t BKP8R;      /*!< RTC backup register 8,                                     Address offset: 0x70 */
  __IO uint32_t BKP9R;      /*!< RTC backup register 9,                                     Address offset: 0x74 */
  __IO uint32_t BKP10R;     /*!< RTC backup register 10,                                    Address offset: 0x78 */
  __IO uint32_t BKP11R;     /*!< RTC backup register 11,                                    Address offset: 0x7C */
  __IO uint32_t BKP12R;     /*!< RTC backup register 12,                                    Address offset: 0x80 */
  __IO uint32_t BKP13R;     /*!< RTC backup register 13,                                    Address offset: 0x84 */
  __IO uint32_t BKP14R;     /*!< RTC backup register 14,                                    Address offset: 0x88 */
  __IO uint32_t BKP15R;     /*!< RTC backup register 15,                                    Address offset: 0x8C */
  __IO uint32_t BKP16R;     /*!< RTC backup register 16,                                    Address offset: 0x90 */
  __IO uint32_t BKP17R;     /*!< RTC backup register 17,                                    Address offset: 0x94 */
  __IO uint32_t BKP18R;     /*!< RTC backup register 18,                                    Address offset: 0x98 */
  __IO uint32_t BKP19R;     /*!< RTC backup register 19,                                    Address offset: 0x9C */
  __IO uint32_t BKP20R;     /*!< RTC backup register 20,                                    Address offset: 0xA0 */
  __IO uint32_t BKP21R;     /*!< RTC backup register 21,                                    Address offset: 0xA4 */
  __IO uint32_t BKP22R;     /*!< RTC backup register 22,                                    Address offset: 0xA8 */
  __IO uint32_t BKP23R;     /*!< RTC backup register 23,                                    Address offset: 0xAC */
  __IO uint32_t BKP24R;     /*!< RTC backup register 24,                                    Address offset: 0xB0 */
  __IO uint32_t BKP25R;     /*!< RTC backup register 25,                                    Address offset: 0xB4 */
  __IO uint32_t BKP26R;     /*!< RTC backup register 26,                                    Address offset: 0xB8 */
  __IO uint32_t BKP27R;     /*!< RTC backup register 27,                                    Address offset: 0xBC */
  __IO uint32_t BKP28R;     /*!< RTC backup register 28,                                    Address offset: 0xC0 */
  __IO uint32_t BKP29R;     /*!< RTC backup register 29,                                    Address offset: 0xC4 */
  __IO uint32_t BKP30R;     /*!< RTC backup register 30,                                    Address offset: 0xC8 */
  __IO uint32_t BKP31R;     /*!< RTC backup register 31,                                    Address offset: 0xCC */
} RTC_TypeDef;

/**
  * @brief Serial Audio Interface
  */

typedef struct
{
  __IO uint32_t GCR;           /*!< SAI global configuration register, Address offset: 0x00 */
  uint32_t      RESERVED0[16]; /*!< Reserved, 0x04 - 0x43                                   */
  __IO uint32_t PDMCR;         /*!< SAI PDM control register,          Address offset: 0x44 */
  __IO uint32_t PDMDLY;        /*!< SAI PDM delay register,            Address offset: 0x48 */
} SAI_TypeDef;

typedef struct
{
  __IO uint32_t CR1;      /*!< SAI block x configuration register 1,     Address offset: 0x04 */
  __IO uint32_t CR2;      /*!< SAI block x configuration register 2,     Address offset: 0x08 */
  __IO uint32_t FRCR;     /*!< SAI block x frame configuration register, Address offset: 0x0C */
  __IO uint32_t SLOTR;    /*!< SAI block x slot register,                Address offset: 0x10 */
  __IO uint32_t IMR;      /*!< SAI block x interrupt mask register,      Address offset: 0x14 */
  __IO uint32_t SR;       /*!< SAI block x status register,              Address offset: 0x18 */
  __IO uint32_t CLRFR;    /*!< SAI block x clear flag register,          Address offset: 0x1C */
  __IO uint32_t DR;       /*!< SAI block x data register,                Address offset: 0x20 */
} SAI_Block_TypeDef;

/**
  * @brief SPDIF-RX Interface
  */

typedef struct
{
  __IO uint32_t   CR;           /*!< Control register,                   Address offset: 0x00 */
  __IO uint32_t   IMR;          /*!< Interrupt mask register,            Address offset: 0x04 */
  __IO uint32_t   SR;           /*!< Status register,                    Address offset: 0x08 */
  __IO uint32_t   IFCR;         /*!< Interrupt Flag Clear register,      Address offset: 0x0C */
  __IO uint32_t   DR;           /*!< Data input register,                Address offset: 0x10 */
  __IO uint32_t   CSR;          /*!< Channel Status register,            Address offset: 0x14 */
  __IO uint32_t   DIR;          /*!< Debug Information register,         Address offset: 0x18 */
  uint32_t        RESERVED2;    /*!< Reserved,  0x1A                                          */
} SPDIFRX_TypeDef;


/**
  * @brief Secure digital input/output Interface
  */

typedef struct
{
  __IO uint32_t POWER;          /*!< SDMMC power control register,             Address offset: 0x00  */
  __IO uint32_t CLKCR;          /*!< SDMMC clock control register,             Address offset: 0x04  */
  __IO uint32_t ARG;            /*!< SDMMC argument register,                  Address offset: 0x08  */
  __IO uint32_t CMD;            /*!< SDMMC command register,                   Address offset: 0x0C  */
  __I uint32_t  RESPCMD;        /*!< SDMMC command response register,          Address offset: 0x10  */
  __I uint32_t  RESP1;          /*!< SDMMC response 1 register,                Address offset: 0x14  */
  __I uint32_t  RESP2;          /*!< SDMMC response 2 register,                Address offset: 0x18  */
  __I uint32_t  RESP3;          /*!< SDMMC response 3 register,                Address offset: 0x1C  */
  __I uint32_t  RESP4;          /*!< SDMMC response 4 register,                Address offset: 0x20  */
  __IO uint32_t DTIMER;         /*!< SDMMC data timer register,                Address offset: 0x24  */
  __IO uint32_t DLEN;           /*!< SDMMC data length register,               Address offset: 0x28  */
  __IO uint32_t DCTRL;          /*!< SDMMC data control register,              Address offset: 0x2C  */
  __I uint32_t  DCOUNT;         /*!< SDMMC data counter register,              Address offset: 0x30  */
  __I uint32_t  STA;            /*!< SDMMC status register,                    Address offset: 0x34  */
  __IO uint32_t ICR;            /*!< SDMMC interrupt clear register,           Address offset: 0x38  */
  __IO uint32_t MASK;           /*!< SDMMC mask register,                      Address offset: 0x3C  */
  __IO uint32_t ACKTIME;        /*!< SDMMC Acknowledgement timer register,     Address offset: 0x40  */
  uint32_t      RESERVED0[3];   /*!< Reserved, 0x44 - 0x4C - 0x4C                                    */
  __IO uint32_t IDMACTRL;       /*!< SDMMC DMA control register,               Address offset: 0x50  */
  __IO uint32_t IDMABSIZE;      /*!< SDMMC DMA buffer size register,           Address offset: 0x54  */
  __IO uint32_t IDMABASE0;      /*!< SDMMC DMA buffer 0 base address register, Address offset: 0x58  */
  __IO uint32_t IDMABASE1;      /*!< SDMMC DMA buffer 1 base address register, Address offset: 0x5C  */
  uint32_t      RESERVED1[8];   /*!< Reserved, 0x60-0x7C                                             */
  __IO uint32_t FIFO;           /*!< SDMMC data FIFO register,                 Address offset: 0x80  */
  uint32_t      RESERVED2[222]; /*!< Reserved, 0x84-0x3F8                                            */
  __IO uint32_t IPVR;           /*!< SDMMC data FIFO register,                 Address offset: 0x3FC */
} SDMMC_TypeDef;


/**
  * @brief Delay Block DLYB
  */

typedef struct
{
  __IO uint32_t CR;          /*!< DELAY BLOCK control register,  Address offset: 0x00 */
  __IO uint32_t CFGR;        /*!< DELAY BLOCK configuration register,  Address offset: 0x04 */
} DLYB_TypeDef;

/**
  * @brief HW Semaphore HSEM
  */

typedef struct
{
  __IO uint32_t R[32];      /*!< 2-step write lock and read back registers,     Address offset: 00h-7Ch  */
  __IO uint32_t RLR[32];    /*!< 1-step read lock registers,                    Address offset: 80h-FCh  */
  __IO uint32_t C1IER;      /*!< HSEM Interrupt enable register ,             Address offset: 100h     */
  __IO uint32_t C1ICR;      /*!< HSEM Interrupt clear register ,              Address offset: 104h     */
  __IO uint32_t C1ISR;      /*!< HSEM Interrupt Status register ,             Address offset: 108h     */
  __IO uint32_t C1MISR;     /*!< HSEM Interrupt Masked Status register ,      Address offset: 10Ch     */
  uint32_t  Reserved[12];   /* Reserved                                       Address offset: 110h-13Ch  */
  __IO uint32_t CR;         /*!< HSEM Semaphore clear register ,                Address offset: 140h      */
  __IO uint32_t KEYR;       /*!< HSEM Semaphore clear key register ,            Address offset: 144h      */

} HSEM_TypeDef;

typedef struct
{
  __IO uint32_t IER;        /*!< HSEM interrupt enable register ,                Address offset:   0h     */
  __IO uint32_t ICR;        /*!< HSEM interrupt clear register ,                 Address offset:   4h     */
  __IO uint32_t ISR;        /*!< HSEM interrupt status register ,                Address offset:   8h     */
  __IO uint32_t MISR;       /*!< HSEM masked interrupt status register ,         Address offset:   Ch     */
} HSEM_Common_TypeDef;

/**
  * @brief Serial Peripheral Interface
  */

typedef struct
{
  __IO uint32_t CR1;           /*!< SPI/I2S Control register 1,                      Address offset: 0x00 */
  __IO uint32_t CR2;           /*!< SPI Control register 2,                          Address offset: 0x04 */
  __IO uint32_t CFG1;          /*!< SPI Configuration register 1,                    Address offset: 0x08 */
  __IO uint32_t CFG2;          /*!< SPI Configuration register 2,                    Address offset: 0x0C */
  __IO uint32_t IER;           /*!< SPI/I2S Interrupt Enable register,               Address offset: 0x10 */
  __IO uint32_t SR;            /*!< SPI/I2S Status register,                         Address offset: 0x14 */
  __IO uint32_t IFCR;          /*!< SPI/I2S Interrupt/Status flags clear register,   Address offset: 0x18 */
  uint32_t      RESERVED0;     /*!< Reserved, 0x1C                                                        */
  __IO uint32_t TXDR;          /*!< SPI/I2S Transmit data register,                  Address offset: 0x20 */
  uint32_t      RESERVED1[3];  /*!< Reserved, 0x24-0x2C                                                   */
  __IO uint32_t RXDR;          /*!< SPI/I2S Receive data register,                   Address offset: 0x30 */
  uint32_t      RESERVED2[3];  /*!< Reserved, 0x34-0x3C                                                   */
  __IO uint32_t CRCPOLY;       /*!< SPI CRC Polynomial register,                     Address offset: 0x40 */
  __IO uint32_t TXCRC;         /*!< SPI Transmitter CRC register,                    Address offset: 0x44 */
  __IO uint32_t RXCRC;         /*!< SPI Receiver CRC register,                       Address offset: 0x48 */
  __IO uint32_t UDRDR;         /*!< SPI Underrun data register,                      Address offset: 0x4C */
  __IO uint32_t I2SCFGR;       /*!< I2S Configuration register,                      Address offset: 0x50 */

} SPI_TypeDef;

/**
  * @brief DTS
  */
typedef struct
{
  __IO uint32_t CFGR1;         /*!< DTS configuration register,                Address offset: 0x00 */
  uint32_t RESERVED0;          /*!< Reserved,                                  Address offset: 0x04 */
  __IO uint32_t T0VALR1;       /*!< DTS T0 Value register,                     Address offset: 0x08 */
  uint32_t RESERVED1;          /*!< Reserved,                                  Address offset: 0x0C */
  __IO uint32_t RAMPVALR;      /*!< DTS Ramp value register,                   Address offset: 0x10 */
  __IO uint32_t ITR1;          /*!< DTS Interrupt threshold register,          Address offset: 0x14 */
  uint32_t RESERVED2;          /*!< Reserved,                                  Address offset: 0x18 */
  __IO uint32_t DR;            /*!< DTS data register,                         Address offset: 0x1C */
  __IO uint32_t SR;            /*!< DTS status register                        Address offset: 0x20 */
  __IO uint32_t ITENR;         /*!< DTS Interrupt enable register,             Address offset: 0x24 */
  __IO uint32_t ICIFR;         /*!< DTS Clear Interrupt flag register,         Address offset: 0x28 */
  __IO uint32_t OR;            /*!< DTS option register 1,                     Address offset: 0x2C */
}
DTS_TypeDef;

/**
  * @brief TIM
  */

typedef struct
{
  __IO uint32_t CR1;         /*!< TIM control register 1,                   Address offset: 0x00 */
  __IO uint32_t CR2;         /*!< TIM control register 2,                   Address offset: 0x04 */
  __IO uint32_t SMCR;        /*!< TIM slave mode control register,          Address offset: 0x08 */
  __IO uint32_t DIER;        /*!< TIM DMA/interrupt enable register,        Address offset: 0x0C */
  __IO uint32_t SR;          /*!< TIM status register,                      Address offset: 0x10 */
  __IO uint32_t EGR;         /*!< TIM event generation register,            Address offset: 0x14 */
  __IO uint32_t CCMR1;       /*!< TIM capture/compare mode register 1,      Address offset: 0x18 */
  __IO uint32_t CCMR2;       /*!< TIM capture/compare mode register 2,      Address offset: 0x1C */
  __IO uint32_t CCER;        /*!< TIM capture/compare enable register,      Address offset: 0x20 */
  __IO uint32_t CNT;         /*!< TIM counter register,                     Address offset: 0x24 */
  __IO uint32_t PSC;         /*!< TIM prescaler,                            Address offset: 0x28 */
  __IO uint32_t ARR;         /*!< TIM auto-reload register,                 Address offset: 0x2C */
  __IO uint32_t RCR;         /*!< TIM repetition counter register,          Address offset: 0x30 */
  __IO uint32_t CCR1;        /*!< TIM capture/compare register 1,           Address offset: 0x34 */
  __IO uint32_t CCR2;        /*!< TIM capture/compare register 2,           Address offset: 0x38 */
  __IO uint32_t CCR3;        /*!< TIM capture/compare register 3,           Address offset: 0x3C */
  __IO uint32_t CCR4;        /*!< TIM capture/compare register 4,           Address offset: 0x40 */
  __IO uint32_t BDTR;        /*!< TIM break and dead-time register,         Address offset: 0x44 */
  __IO uint32_t DCR;         /*!< TIM DMA control register,                 Address offset: 0x48 */
  __IO uint32_t DMAR;        /*!< TIM DMA address for full transfer,        Address offset: 0x4C */
  uint32_t      RESERVED1;   /*!< Reserved, 0x50                                                 */
  __IO uint32_t CCMR3;       /*!< TIM capture/compare mode register 3,      Address offset: 0x54 */
  __IO uint32_t CCR5;        /*!< TIM capture/compare register5,            Address offset: 0x58 */
  __IO uint32_t CCR6;        /*!< TIM capture/compare register6,            Address offset: 0x5C */
  __IO uint32_t AF1;         /*!< TIM alternate function option register 1, Address offset: 0x60 */
  __IO uint32_t AF2;         /*!< TIM alternate function option register 2, Address offset: 0x64 */
  __IO uint32_t TISEL;       /*!< TIM Input Selection register,             Address offset: 0x68 */
} TIM_TypeDef;

/**
  * @brief LPTIMIMER
  */
typedef struct
{
  __IO uint32_t ISR;      /*!< LPTIM Interrupt and Status register,         Address offset: 0x00 */
  __IO uint32_t ICR;      /*!< LPTIM Interrupt Clear register,              Address offset: 0x04 */
  __IO uint32_t IER;      /*!< LPTIM Interrupt Enable register,             Address offset: 0x08 */
  __IO uint32_t CFGR;     /*!< LPTIM Configuration register,                Address offset: 0x0C */
  __IO uint32_t CR;       /*!< LPTIM Control register,                      Address offset: 0x10 */
  __IO uint32_t CMP;      /*!< LPTIM Compare register,                      Address offset: 0x14 */
  __IO uint32_t ARR;      /*!< LPTIM Autoreload register,                   Address offset: 0x18 */
  __IO uint32_t CNT;      /*!< LPTIM Counter register,                      Address offset: 0x1C */
  uint32_t  RESERVED1;    /*!< Reserved, 0x20                                                    */
  __IO uint32_t CFGR2;    /*!< LPTIM Configuration register,                Address offset: 0x24 */
} LPTIM_TypeDef;

/**
  * @brief Comparator
  */
typedef struct
{
  __IO uint32_t SR;        /*!< Comparator status register,                    Address offset: 0x00 */
  __IO uint32_t ICFR;      /*!< Comparator interrupt clear flag register,       Address offset: 0x04 */
  __IO uint32_t OR;        /*!< Comparator option register,                  Address offset: 0x08 */
} COMPOPT_TypeDef;

typedef struct
{
  __IO uint32_t CFGR;      /*!< Comparator configuration register  ,           Address offset: 0x00 */
} COMP_TypeDef;

typedef struct
{
  __IO uint32_t CFGR;       /*!< COMP control and status register, used for bits common to several COMP instances, Address offset: 0x00 */
} COMP_Common_TypeDef;
/**
  * @brief Universal Synchronous Asynchronous Receiver Transmitter
  */

typedef struct
{
  __IO uint32_t CR1;    /*!< USART Control register 1,                 Address offset: 0x00 */
  __IO uint32_t CR2;    /*!< USART Control register 2,                 Address offset: 0x04 */
  __IO uint32_t CR3;    /*!< USART Control register 3,                 Address offset: 0x08 */
  __IO uint32_t BRR;    /*!< USART Baud rate register,                 Address offset: 0x0C */
  __IO uint32_t GTPR;   /*!< USART Guard time and prescaler register,  Address offset: 0x10 */
  __IO uint32_t RTOR;   /*!< USART Receiver Time Out register,         Address offset: 0x14 */
  __IO uint32_t RQR;    /*!< USART Request register,                   Address offset: 0x18 */
  __IO uint32_t ISR;    /*!< USART Interrupt and status register,      Address offset: 0x1C */
  __IO uint32_t ICR;    /*!< USART Interrupt flag Clear register,      Address offset: 0x20 */
  __IO uint32_t RDR;    /*!< USART Receive Data register,              Address offset: 0x24 */
  __IO uint32_t TDR;    /*!< USART Transmit Data register,             Address offset: 0x28 */
  __IO uint32_t PRESC;  /*!< USART clock Prescaler register,           Address offset: 0x2C */
} USART_TypeDef;

/**
  * @brief Single Wire Protocol Master Interface SPWMI
  */
typedef struct
{
  __IO uint32_t CR;          /*!< SWPMI Configuration/Control register,     Address offset: 0x00 */
  __IO uint32_t BRR;         /*!< SWPMI bitrate register,                   Address offset: 0x04 */
    uint32_t  RESERVED1;     /*!< Reserved, 0x08                                                 */
  __IO uint32_t ISR;         /*!< SWPMI Interrupt and Status register,      Address offset: 0x0C */
  __IO uint32_t ICR;         /*!< SWPMI Interrupt Flag Clear register,      Address offset: 0x10 */
  __IO uint32_t IER;         /*!< SWPMI Interrupt Enable register,          Address offset: 0x14 */
  __IO uint32_t RFL;         /*!< SWPMI Receive Frame Length register,      Address offset: 0x18 */
  __IO uint32_t TDR;         /*!< SWPMI Transmit data register,             Address offset: 0x1C */
  __IO uint32_t RDR;         /*!< SWPMI Receive data register,              Address offset: 0x20 */
  __IO uint32_t OR;          /*!< SWPMI Option register,                    Address offset: 0x24 */
} SWPMI_TypeDef;

/**
  * @brief Window WATCHDOG
  */

typedef struct
{
  __IO uint32_t CR;   /*!< WWDG Control register,       Address offset: 0x00 */
  __IO uint32_t CFR;  /*!< WWDG Configuration register, Address offset: 0x04 */
  __IO uint32_t SR;   /*!< WWDG Status register,        Address offset: 0x08 */
} WWDG_TypeDef;


/**
  * @brief RAM_ECC_Specific_Registers
  */
typedef struct
{
  __IO uint32_t CR;           /*!< RAMECC monitor configuration register          */
  __IO uint32_t SR;           /*!< RAMECC monitor status register                 */
  __IO uint32_t FAR;          /*!< RAMECC monitor failing address register        */
  __IO uint32_t FDRL;         /*!< RAMECC monitor failing data low register       */
  __IO uint32_t FDRH;         /*!< RAMECC monitor failing data high register      */
  __IO uint32_t FECR;         /*!< RAMECC monitor failing ECC error code register */
} RAMECC_MonitorTypeDef;

typedef struct
{
  __IO uint32_t IER;          /*!< RAMECC interrupt enable register */
} RAMECC_TypeDef;
/**
  * @}
  */


/**
  * @brief Crypto Processor
  */

typedef struct
{
  __IO uint32_t CR;         /*!< CRYP control register,                                    Address offset: 0x00 */
  __IO uint32_t SR;         /*!< CRYP status register,                                     Address offset: 0x04 */
  __IO uint32_t DIN;         /*!< CRYP data input register,                                Address offset: 0x08 */
  __IO uint32_t DOUT;       /*!< CRYP data output register,                                Address offset: 0x0C */
  __IO uint32_t DMACR;      /*!< CRYP DMA control register,                                Address offset: 0x10 */
  __IO uint32_t IMSCR;      /*!< CRYP interrupt mask set/clear register,                   Address offset: 0x14 */
  __IO uint32_t RISR;       /*!< CRYP raw interrupt status register,                       Address offset: 0x18 */
  __IO uint32_t MISR;       /*!< CRYP masked interrupt status register,                    Address offset: 0x1C */
  __IO uint32_t K0LR;       /*!< CRYP key left  register 0,                                Address offset: 0x20 */
  __IO uint32_t K0RR;       /*!< CRYP key right register 0,                                Address offset: 0x24 */
  __IO uint32_t K1LR;       /*!< CRYP key left  register 1,                                Address offset: 0x28 */
  __IO uint32_t K1RR;       /*!< CRYP key right register 1,                                Address offset: 0x2C */
  __IO uint32_t K2LR;       /*!< CRYP key left  register 2,                                Address offset: 0x30 */
  __IO uint32_t K2RR;       /*!< CRYP key right register 2,                                Address offset: 0x34 */
  __IO uint32_t K3LR;       /*!< CRYP key left  register 3,                                Address offset: 0x38 */
  __IO uint32_t K3RR;       /*!< CRYP key right register 3,                                Address offset: 0x3C */
  __IO uint32_t IV0LR;      /*!< CRYP initialization vector left-word  register 0,         Address offset: 0x40 */
  __IO uint32_t IV0RR;      /*!< CRYP initialization vector right-word register 0,         Address offset: 0x44 */
  __IO uint32_t IV1LR;      /*!< CRYP initialization vector left-word  register 1,         Address offset: 0x48 */
  __IO uint32_t IV1RR;      /*!< CRYP initialization vector right-word register 1,         Address offset: 0x4C */
  __IO uint32_t CSGCMCCM0R; /*!< CRYP GCM/GMAC or CCM/CMAC context swap register 0,        Address offset: 0x50 */
  __IO uint32_t CSGCMCCM1R; /*!< CRYP GCM/GMAC or CCM/CMAC context swap register 1,        Address offset: 0x54 */
  __IO uint32_t CSGCMCCM2R; /*!< CRYP GCM/GMAC or CCM/CMAC context swap register 2,        Address offset: 0x58 */
  __IO uint32_t CSGCMCCM3R; /*!< CRYP GCM/GMAC or CCM/CMAC context swap register 3,        Address offset: 0x5C */
  __IO uint32_t CSGCMCCM4R; /*!< CRYP GCM/GMAC or CCM/CMAC context swap register 4,        Address offset: 0x60 */
  __IO uint32_t CSGCMCCM5R; /*!< CRYP GCM/GMAC or CCM/CMAC context swap register 5,        Address offset: 0x64 */
  __IO uint32_t CSGCMCCM6R; /*!< CRYP GCM/GMAC or CCM/CMAC context swap register 6,        Address offset: 0x68 */
  __IO uint32_t CSGCMCCM7R; /*!< CRYP GCM/GMAC or CCM/CMAC context swap register 7,        Address offset: 0x6C */
  __IO uint32_t CSGCM0R;    /*!< CRYP GCM/GMAC context swap register 0,                    Address offset: 0x70 */
  __IO uint32_t CSGCM1R;    /*!< CRYP GCM/GMAC context swap register 1,                    Address offset: 0x74 */
  __IO uint32_t CSGCM2R;    /*!< CRYP GCM/GMAC context swap register 2,                    Address offset: 0x78 */
  __IO uint32_t CSGCM3R;    /*!< CRYP GCM/GMAC context swap register 3,                    Address offset: 0x7C */
  __IO uint32_t CSGCM4R;    /*!< CRYP GCM/GMAC context swap register 4,                    Address offset: 0x80 */
  __IO uint32_t CSGCM5R;    /*!< CRYP GCM/GMAC context swap register 5,                    Address offset: 0x84 */
  __IO uint32_t CSGCM6R;    /*!< CRYP GCM/GMAC context swap register 6,                    Address offset: 0x88 */
  __IO uint32_t CSGCM7R;    /*!< CRYP GCM/GMAC context swap register 7,                    Address offset: 0x8C */
} CRYP_TypeDef;

/**
  * @brief HASH
  */

typedef struct
{
  __IO uint32_t CR;               /*!< HASH control register,          Address offset: 0x00        */
  __IO uint32_t DIN;              /*!< HASH data input register,       Address offset: 0x04        */
  __IO uint32_t STR;              /*!< HASH start register,            Address offset: 0x08        */
  __IO uint32_t HR[5];            /*!< HASH digest registers,          Address offset: 0x0C-0x1C   */
  __IO uint32_t IMR;              /*!< HASH interrupt enable register, Address offset: 0x20        */
  __IO uint32_t SR;               /*!< HASH status register,           Address offset: 0x24        */
       uint32_t RESERVED[52];     /*!< Reserved, 0x28-0xF4                                         */
  __IO uint32_t CSR[54];          /*!< HASH context swap registers,    Address offset: 0x0F8-0x1CC */
} HASH_TypeDef;

/**
  * @brief HASH_DIGEST
  */

typedef struct
{
  __IO uint32_t HR[8];     /*!< HASH digest registers,          Address offset: 0x310-0x32C */
} HASH_DIGEST_TypeDef;


/**
  * @brief RNG
  */

typedef struct
{
  __IO uint32_t CR;  /*!< RNG control register, Address offset: 0x00 */
  __IO uint32_t SR;  /*!< RNG status register,  Address offset: 0x04 */
  __IO uint32_t DR;  /*!< RNG data register,    Address offset: 0x08 */
  uint32_t RESERVED;
  __IO uint32_t HTCR;  /*!< RNG health test configuration register, Address offset: 0x10 */
} RNG_TypeDef;

/**
  * @brief MDIOS
  */

typedef struct
{
  __IO uint32_t CR;
  __IO uint32_t WRFR;
  __IO uint32_t CWRFR;
  __IO uint32_t RDFR;
  __IO uint32_t CRDFR;
  __IO uint32_t SR;
  __IO uint32_t CLRFR;
  uint32_t RESERVED[57];
  __IO uint32_t DINR0;
  __IO uint32_t DINR1;
  __IO uint32_t DINR2;
  __IO uint32_t DINR3;
  __IO uint32_t DINR4;
  __IO uint32_t DINR5;
  __IO uint32_t DINR6;
  __IO uint32_t DINR7;
  __IO uint32_t DINR8;
  __IO uint32_t DINR9;
  __IO uint32_t DINR10;
  __IO uint32_t DINR11;
  __IO uint32_t DINR12;
  __IO uint32_t DINR13;
  __IO uint32_t DINR14;
  __IO uint32_t DINR15;
  __IO uint32_t DINR16;
  __IO uint32_t DINR17;
  __IO uint32_t DINR18;
  __IO uint32_t DINR19;
  __IO uint32_t DINR20;
  __IO uint32_t DINR21;
  __IO uint32_t DINR22;
  __IO uint32_t DINR23;
  __IO uint32_t DINR24;
  __IO uint32_t DINR25;
  __IO uint32_t DINR26;
  __IO uint32_t DINR27;
  __IO uint32_t DINR28;
  __IO uint32_t DINR29;
  __IO uint32_t DINR30;
  __IO uint32_t DINR31;
  __IO uint32_t DOUTR0;
  __IO uint32_t DOUTR1;
  __IO uint32_t DOUTR2;
  __IO uint32_t DOUTR3;
  __IO uint32_t DOUTR4;
  __IO uint32_t DOUTR5;
  __IO uint32_t DOUTR6;
  __IO uint32_t DOUTR7;
  __IO uint32_t DOUTR8;
  __IO uint32_t DOUTR9;
  __IO uint32_t DOUTR10;
  __IO uint32_t DOUTR11;
  __IO uint32_t DOUTR12;
  __IO uint32_t DOUTR13;
  __IO uint32_t DOUTR14;
  __IO uint32_t DOUTR15;
  __IO uint32_t DOUTR16;
  __IO uint32_t DOUTR17;
  __IO uint32_t DOUTR18;
  __IO uint32_t DOUTR19;
  __IO uint32_t DOUTR20;
  __IO uint32_t DOUTR21;
  __IO uint32_t DOUTR22;
  __IO uint32_t DOUTR23;
  __IO uint32_t DOUTR24;
  __IO uint32_t DOUTR25;
  __IO uint32_t DOUTR26;
  __IO uint32_t DOUTR27;
  __IO uint32_t DOUTR28;
  __IO uint32_t DOUTR29;
  __IO uint32_t DOUTR30;
  __IO uint32_t DOUTR31;
} MDIOS_TypeDef;


/**
  * @brief USB_OTG_Core_Registers
  */
typedef struct
{
 __IO uint32_t GOTGCTL;               /*!< USB_OTG Control and Status Register          000h */
  __IO uint32_t GOTGINT;              /*!< USB_OTG Interrupt Register                   004h */
  __IO uint32_t GAHBCFG;              /*!< Core AHB Configuration Register              008h */
  __IO uint32_t GUSBCFG;              /*!< Core USB Configuration Register              00Ch */
  __IO uint32_t GRSTCTL;              /*!< Core Reset Register                          010h */
  __IO uint32_t GINTSTS;              /*!< Core Interrupt Register                      014h */
  __IO uint32_t GINTMSK;              /*!< Core Interrupt Mask Register                 018h */
  __IO uint32_t GRXSTSR;              /*!< Receive Sts Q Read Register                  01Ch */
  __IO uint32_t GRXSTSP;              /*!< Receive Sts Q Read & POP Register            020h */
  __IO uint32_t GRXFSIZ;              /*!< Receive FIFO Size Register                   024h */
  __IO uint32_t DIEPTXF0_HNPTXFSIZ;   /*!< EP0 / Non Periodic Tx FIFO Size Register     028h */
  __IO uint32_t HNPTXSTS;             /*!< Non Periodic Tx FIFO/Queue Sts reg           02Ch */
  uint32_t Reserved30[2];             /*!< Reserved                                     030h */
  __IO uint32_t GCCFG;                /*!< General Purpose IO Register                  038h */
  __IO uint32_t CID;                  /*!< User ID Register                             03Ch */
  __IO uint32_t GSNPSID;              /* USB_OTG core ID                                040h*/
  __IO uint32_t GHWCFG1;              /* User HW config1                                044h*/
  __IO uint32_t GHWCFG2;              /* User HW config2                                048h*/
  __IO uint32_t GHWCFG3;              /*!< User HW config3                              04Ch */
  uint32_t  Reserved6;                /*!< Reserved                                     050h */
  __IO uint32_t GLPMCFG;              /*!< LPM Register                                 054h */
  __IO uint32_t GPWRDN;               /*!< Power Down Register                          058h */
  __IO uint32_t GDFIFOCFG;            /*!< DFIFO Software Config Register               05Ch */
   __IO uint32_t GADPCTL;             /*!< ADP Timer, Control and Status Register       60Ch */
    uint32_t  Reserved43[39];         /*!< Reserved                                058h-0FFh */
  __IO uint32_t HPTXFSIZ;             /*!< Host Periodic Tx FIFO Size Reg               100h */
  __IO uint32_t DIEPTXF[0x0F];        /*!< dev Periodic Transmit FIFO */
} USB_OTG_GlobalTypeDef;


/**
  * @brief USB_OTG_device_Registers
  */
typedef struct
{
  __IO uint32_t DCFG;            /*!< dev Configuration Register   800h */
  __IO uint32_t DCTL;            /*!< dev Control Register         804h */
  __IO uint32_t DSTS;            /*!< dev Status Register (RO)     808h */
  uint32_t Reserved0C;           /*!< Reserved                     80Ch */
  __IO uint32_t DIEPMSK;         /*!< dev IN Endpoint Mask         810h */
  __IO uint32_t DOEPMSK;         /*!< dev OUT Endpoint Mask        814h */
  __IO uint32_t DAINT;           /*!< dev All Endpoints Itr Reg    818h */
  __IO uint32_t DAINTMSK;        /*!< dev All Endpoints Itr Mask   81Ch */
  uint32_t  Reserved20;          /*!< Reserved                     820h */
  uint32_t Reserved9;            /*!< Reserved                     824h */
  __IO uint32_t DVBUSDIS;        /*!< dev VBUS discharge Register  828h */
  __IO uint32_t DVBUSPULSE;      /*!< dev VBUS Pulse Register      82Ch */
  __IO uint32_t DTHRCTL;         /*!< dev threshold                830h */
  __IO uint32_t DIEPEMPMSK;      /*!< dev empty msk                834h */
  __IO uint32_t DEACHINT;        /*!< dedicated EP interrupt       838h */
  __IO uint32_t DEACHMSK;        /*!< dedicated EP msk             83Ch */
  uint32_t Reserved40;           /*!< dedicated EP mask            840h */
  __IO uint32_t DINEP1MSK;       /*!< dedicated EP mask            844h */
  uint32_t  Reserved44[15];      /*!< Reserved                 844-87Ch */
  __IO uint32_t DOUTEP1MSK;      /*!< dedicated EP msk             884h */
} USB_OTG_DeviceTypeDef;


/**
  * @brief USB_OTG_IN_Endpoint-Specific_Register
  */
typedef struct
{
  __IO uint32_t DIEPCTL;           /*!< dev IN Endpoint Control Reg    900h + (ep_num * 20h) + 00h */
  uint32_t Reserved04;             /*!< Reserved                       900h + (ep_num * 20h) + 04h */
  __IO uint32_t DIEPINT;           /*!< dev IN Endpoint Itr Reg        900h + (ep_num * 20h) + 08h */
  uint32_t Reserved0C;             /*!< Reserved                       900h + (ep_num * 20h) + 0Ch */
  __IO uint32_t DIEPTSIZ;          /*!< IN Endpoint Txfer Size         900h + (ep_num * 20h) + 10h */
  __IO uint32_t DIEPDMA;           /*!< IN Endpoint DMA Address Reg    900h + (ep_num * 20h) + 14h */
  __IO uint32_t DTXFSTS;           /*!< IN Endpoint Tx FIFO Status Reg 900h + (ep_num * 20h) + 18h */
  uint32_t Reserved18;             /*!< Reserved  900h+(ep_num*20h)+1Ch-900h+ (ep_num * 20h) + 1Ch */
} USB_OTG_INEndpointTypeDef;


/**
  * @brief USB_OTG_OUT_Endpoint-Specific_Registers
  */
typedef struct
{
  __IO uint32_t DOEPCTL;       /*!< dev OUT Endpoint Control Reg           B00h + (ep_num * 20h) + 00h */
  uint32_t Reserved04;         /*!< Reserved                               B00h + (ep_num * 20h) + 04h */
  __IO uint32_t DOEPINT;       /*!< dev OUT Endpoint Itr Reg               B00h + (ep_num * 20h) + 08h */
  uint32_t Reserved0C;         /*!< Reserved                               B00h + (ep_num * 20h) + 0Ch */
  __IO uint32_t DOEPTSIZ;      /*!< dev OUT Endpoint Txfer Size            B00h + (ep_num * 20h) + 10h */
  __IO uint32_t DOEPDMA;       /*!< dev OUT Endpoint DMA Address           B00h + (ep_num * 20h) + 14h */
  uint32_t Reserved18[2];      /*!< Reserved B00h + (ep_num * 20h) + 18h - B00h + (ep_num * 20h) + 1Ch */
} USB_OTG_OUTEndpointTypeDef;


/**
  * @brief USB_OTG_Host_Mode_Register_Structures
  */
typedef struct
{
  __IO uint32_t HCFG;             /*!< Host Configuration Register          400h */
  __IO uint32_t HFIR;             /*!< Host Frame Interval Register         404h */
  __IO uint32_t HFNUM;            /*!< Host Frame Nbr/Frame Remaining       408h */
  uint32_t Reserved40C;           /*!< Reserved                             40Ch */
  __IO uint32_t HPTXSTS;          /*!< Host Periodic Tx FIFO/ Queue Status  410h */
  __IO uint32_t HAINT;            /*!< Host All Channels Interrupt Register 414h */
  __IO uint32_t HAINTMSK;         /*!< Host All Channels Interrupt Mask     418h */
} USB_OTG_HostTypeDef;

/**
  * @brief USB_OTG_Host_Channel_Specific_Registers
  */
typedef struct
{
  __IO uint32_t HCCHAR;           /*!< Host Channel Characteristics Register    500h */
  __IO uint32_t HCSPLT;           /*!< Host Channel Split Control Register      504h */
  __IO uint32_t HCINT;            /*!< Host Channel Interrupt Register          508h */
  __IO uint32_t HCINTMSK;         /*!< Host Channel Interrupt Mask Register     50Ch */
  __IO uint32_t HCTSIZ;           /*!< Host Channel Transfer Size Register      510h */
  __IO uint32_t HCDMA;            /*!< Host Channel DMA Address Register        514h */
  uint32_t Reserved[2];           /*!< Reserved                                      */
} USB_OTG_HostChannelTypeDef;
/**
  * @}
  */

/**
  * @brief OCTO Serial Peripheral Interface
  */

typedef struct
{
  __IO uint32_t CR;          /*!< OCTOSPI Control register,                           Address offset: 0x000 */
  uint32_t RESERVED;         /*!< Reserved,                                           Address offset: 0x004 */
  __IO uint32_t DCR1;        /*!< OCTOSPI Device Configuration register 1,            Address offset: 0x008 */
  __IO uint32_t DCR2;        /*!< OCTOSPI Device Configuration register 2,            Address offset: 0x00C */
  __IO uint32_t DCR3;        /*!< OCTOSPI Device Configuration register 3,            Address offset: 0x010 */
  __IO uint32_t DCR4;        /*!< OCTOSPI Device Configuration register 4,            Address offset: 0x014 */
  uint32_t RESERVED1[2];     /*!< Reserved,                                           Address offset: 0x018-0x01C */
  __IO uint32_t SR;          /*!< OCTOSPI Status register,                            Address offset: 0x020 */
  __IO uint32_t FCR;         /*!< OCTOSPI Flag Clear register,                        Address offset: 0x024 */
  uint32_t RESERVED2[6];     /*!< Reserved,                                           Address offset: 0x028-0x03C */
  __IO uint32_t DLR;         /*!< OCTOSPI Data Length register,                       Address offset: 0x040 */
  uint32_t RESERVED3;        /*!< Reserved,                                           Address offset: 0x044 */
  __IO uint32_t AR;          /*!< OCTOSPI Address register,                           Address offset: 0x048 */
  uint32_t RESERVED4;        /*!< Reserved,                                           Address offset: 0x04C */
  __IO uint32_t DR;          /*!< OCTOSPI Data register,                              Address offset: 0x050 */
  uint32_t RESERVED5[11];    /*!< Reserved,                                           Address offset: 0x054-0x07C */
  __IO uint32_t PSMKR;       /*!< OCTOSPI Polling Status Mask register,               Address offset: 0x080 */
  uint32_t RESERVED6;        /*!< Reserved,                                           Address offset: 0x084 */
  __IO uint32_t PSMAR;       /*!< OCTOSPI Polling Status Match register,              Address offset: 0x088 */
  uint32_t RESERVED7;        /*!< Reserved,                                           Address offset: 0x08C */
  __IO uint32_t PIR;         /*!< OCTOSPI Polling Interval register,                  Address offset: 0x090 */
  uint32_t RESERVED8[27];    /*!< Reserved,                                           Address offset: 0x094-0x0FC */
  __IO uint32_t CCR;         /*!< OCTOSPI Communication Configuration register,       Address offset: 0x100 */
  uint32_t RESERVED9;        /*!< Reserved,                                           Address offset: 0x104 */
  __IO uint32_t TCR;         /*!< OCTOSPI Timing Configuration register,              Address offset: 0x108 */
  uint32_t RESERVED10;       /*!< Reserved,                                           Address offset: 0x10C */
  __IO uint32_t IR;          /*!< OCTOSPI Instruction register,                       Address offset: 0x110 */
  uint32_t RESERVED11[3];    /*!< Reserved,                                           Address offset: 0x114-0x11C */
  __IO uint32_t ABR;         /*!< OCTOSPI Alternate Bytes register,                   Address offset: 0x120 */
  uint32_t RESERVED12[3];    /*!< Reserved,                                           Address offset: 0x124-0x12C */
  __IO uint32_t LPTR;        /*!< OCTOSPI Low Power Timeout register,                 Address offset: 0x130 */
  uint32_t RESERVED13[3];    /*!< Reserved,                                           Address offset: 0x134-0x13C */
  __IO uint32_t WPCCR;       /*!< OCTOSPI Wrap Communication Configuration register,  Address offset: 0x140 */
  uint32_t RESERVED14;       /*!< Reserved,                                           Address offset: 0x144 */
  __IO uint32_t WPTCR;       /*!< OCTOSPI Wrap Timing Configuration register,         Address offset: 0x148 */
  uint32_t RESERVED15;       /*!< Reserved,                                           Address offset: 0x14C */
  __IO uint32_t WPIR;        /*!< OCTOSPI Wrap Instruction register,                  Address offset: 0x150 */
  uint32_t RESERVED16[3];    /*!< Reserved,                                           Address offset: 0x154-0x15C */
  __IO uint32_t WPABR;       /*!< OCTOSPI Wrap Alternate Bytes register,              Address offset: 0x160 */
  uint32_t RESERVED17[7];    /*!< Reserved,                                           Address offset: 0x164-0x17C */
  __IO uint32_t WCCR;        /*!< OCTOSPI Write Communication Configuration register, Address offset: 0x180 */
  uint32_t RESERVED18;       /*!< Reserved,                                           Address offset: 0x184 */
  __IO uint32_t WTCR;        /*!< OCTOSPI Write Timing Configuration register,        Address offset: 0x188 */
  uint32_t RESERVED19;       /*!< Reserved,                                           Address offset: 0x18C */
  __IO uint32_t WIR;         /*!< OCTOSPI Write Instruction register,                 Address offset: 0x190 */
  uint32_t RESERVED20[3];    /*!< Reserved,                                           Address offset: 0x194-0x19C */
  __IO uint32_t WABR;        /*!< OCTOSPI Write Alternate Bytes register,             Address offset: 0x1A0 */
  uint32_t RESERVED21[23];   /*!< Reserved,                                           Address offset: 0x1A4-0x1FC */
  __IO uint32_t HLCR;        /*!< OCTOSPI Hyperbus Latency Configuration register,    Address offset: 0x200 */
  uint32_t RESERVED22[122];  /*!< Reserved,                                           Address offset: 0x204-0x3EC */
  __IO uint32_t HWCFGR;      /*!< OCTOSPI HW Configuration register,                  Address offset: 0x3F0 */
  __IO uint32_t VER;         /*!< OCTOSPI Version register,                           Address offset: 0x3F4 */
  __IO uint32_t ID;          /*!< OCTOSPI Identification register,                    Address offset: 0x3F8 */
  __IO uint32_t MID;         /*!< OCTOPSI HW Magic ID register,                       Address offset: 0x3FC */
} OCTOSPI_TypeDef;

/**
  * @}
  */
/**
  * @brief OCTO Serial Peripheral Interface IO Manager
  */

typedef struct
{
  __IO uint32_t CR;          /*!< OCTOSPI IO Manager Control register,                 Address offset: 0x00 */
  __IO uint32_t PCR[3];      /*!< OCTOSPI IO Manager Port[1:3] Configuration register, Address offset: 0x04-0x20 */
} OCTOSPIM_TypeDef;

/**
  * @}
  */

/**
  * @brief OTFD register
  */
typedef struct
{
  __IO uint32_t REG_CONFIGR;
  __IO uint32_t REG_START_ADDR;
  __IO uint32_t REG_END_ADDR;
  __IO uint32_t REG_NONCER0;
  __IO uint32_t REG_NONCER1;
  __IO uint32_t REG_KEYR0;
  __IO uint32_t REG_KEYR1;
  __IO uint32_t REG_KEYR2;
  __IO uint32_t REG_KEYR3;
} OTFDEC_Region_TypeDef;

typedef struct
{
  __IO uint32_t CR;
  uint32_t RESERVED1[191];
  __IO uint32_t ISR;
  __IO uint32_t ICR;
  __IO uint32_t IER;
  uint32_t RESERVED2[56];
  __IO uint32_t HWCFGR2;
  __IO uint32_t HWCFGR1;
  __IO uint32_t VERR;
  __IO uint32_t IPIDR;
  __IO uint32_t SIDR;
} OTFDEC_TypeDef;
/**
  * @}
  */

/** @addtogroup Peripheral_memory_map
  * @{
  */
#define D1_ITCMRAM_BASE           (0x00000000UL) /*!< Base address of : 64KB RAM reserved for CPU execution/instruction accessible over ITCM  */
#define D1_ITCMICP_BASE           (0x00100000UL) /*!< Base address of : (up to 128KB) embedded Test FLASH memory accessible over ITCM         */
#define D1_DTCMRAM_BASE           (0x20000000UL) /*!< Base address of : 128KB system data RAM accessible over DTCM                            */
#define D1_AXIFLASH_BASE          (0x08000000UL) /*!< Base address of : (up to 1 MB) embedded FLASH memory accessible over AXI                */
#define D1_AXIICP_BASE            (0x1FF00000UL) /*!< Base address of : (up to 128KB) embedded Test FLASH memory accessible over AXI          */
#define D1_AXISRAM1_BASE           (0x24000000UL) /*!< Base address of : (up to 128KB) system data RAM1 accessible over over AXI                */
#define D1_AXISRAM2_BASE           (0x24020000UL) /*!< Base address of : (up to 192KB) system data RAM2 accessible over over AXI to be shared with ITCM (64K granularity)  */
#define D1_AXISRAM_BASE            D1_AXISRAM1_BASE /*!< Base address of : (up to 320KB) system data RAM1/2 accessible over over AXI             */

#define D2_AHBSRAM1_BASE          (0x30000000UL)   /*!< Base address of : (up to 16KB) system data RAM accessible over over AXI->AHB Bridge    */
#define D2_AHBSRAM2_BASE          (0x30004000UL)   /*!< Base address of : (up to 16KB) system data RAM accessible over over AXI->AHB Bridge    */
#define D2_AHBSRAM_BASE           D2_AHBSRAM1_BASE /*!< Base address of : (up to 32KB) system data RAM1/2 accessible over over AXI->AHB Bridge */

#define D3_BKPSRAM_BASE           (0x38800000UL) /*!< Base address of : Backup SRAM(4 KB) over AXI->AHB Bridge                                */
#define D3_SRAM_BASE              (0x38000000UL) /*!< Base address of : Backup SRAM(16 KB) over AXI->AHB Bridge                               */

#define PERIPH_BASE               (0x40000000UL) /*!< Base address of : AHB/APB Peripherals                                                   */
#define OCTOSPI1_BASE             (0x90000000UL) /*!< Base address of : OCTOSPI1 memories  accessible over AXI                                 */
#define OCTOSPI2_BASE             (0x70000000UL) /*!< Base address of : OCTOSPI2 memories  accessible over AXI                                 */

#define FLASH_BANK1_BASE          (0x08000000UL) /*!< Base address of : (up to 1 MB) Flash Bank1 accessible over AXI                          */
#define FLASH_END                 (0x080FFFFFUL) /*!< FLASH end address                                                                       */


/* Legacy define */
#define FLASH_BASE                FLASH_BANK1_BASE

/*!< Device electronic signature memory map */
#define UID_BASE                  (0x1FF1E800UL)            /*!< Unique device ID register base address */
#define FLASHSIZE_BASE            (0x1FF1E880UL)            /*!< FLASH Size register base address */


/*!< Peripheral memory map */
#define D2_APB1PERIPH_BASE        PERIPH_BASE
#define D2_APB2PERIPH_BASE       (PERIPH_BASE + 0x00010000UL)
#define D2_AHB1PERIPH_BASE       (PERIPH_BASE + 0x00020000UL)
#define D2_AHB2PERIPH_BASE       (PERIPH_BASE + 0x08020000UL)

#define D1_APB1PERIPH_BASE       (PERIPH_BASE + 0x10000000UL)
#define D1_AHB1PERIPH_BASE       (PERIPH_BASE + 0x12000000UL)

#define D3_APB1PERIPH_BASE       (PERIPH_BASE + 0x18000000UL)
#define D3_AHB1PERIPH_BASE       (PERIPH_BASE + 0x18020000UL)

/*!< Legacy Peripheral memory map */
#define APB1PERIPH_BASE        PERIPH_BASE
#define APB2PERIPH_BASE       (PERIPH_BASE + 0x00010000UL)
#define AHB1PERIPH_BASE       (PERIPH_BASE + 0x00020000UL)
#define AHB2PERIPH_BASE       (PERIPH_BASE + 0x08000000UL)


/*!< D1_AHB1PERIPH peripherals */

#define MDMA_BASE             (D1_AHB1PERIPH_BASE + 0x0000UL)
#define DMA2D_BASE            (D1_AHB1PERIPH_BASE + 0x1000UL)
#define FLASH_R_BASE          (D1_AHB1PERIPH_BASE + 0x2000UL)
#define FMC_R_BASE            (D1_AHB1PERIPH_BASE + 0x4000UL)
#define OCTOSPI1_R_BASE       (D1_AHB1PERIPH_BASE + 0x5000UL)
#define DLYB_OCTOSPI1_BASE    (D1_AHB1PERIPH_BASE + 0x6000UL)
#define SDMMC1_BASE           (D1_AHB1PERIPH_BASE + 0x7000UL)
#define DLYB_SDMMC1_BASE      (D1_AHB1PERIPH_BASE + 0x8000UL)
#define RAMECC1_BASE          (D1_AHB1PERIPH_BASE + 0x9000UL)
#define OCTOSPI2_R_BASE       (D1_AHB1PERIPH_BASE + 0xA000UL)
#define DLYB_OCTOSPI2_BASE    (D1_AHB1PERIPH_BASE + 0xB000UL)
#define OCTOSPIM_BASE         (D1_AHB1PERIPH_BASE + 0xB400UL)

#define OTFDEC1_BASE          (D1_AHB1PERIPH_BASE + 0xB800UL)
#define OTFDEC1_REGION1_BASE  (OTFDEC1_BASE + 0x20UL)
#define OTFDEC1_REGION2_BASE  (OTFDEC1_BASE + 0x50UL)
#define OTFDEC1_REGION3_BASE  (OTFDEC1_BASE + 0x80UL)
#define OTFDEC1_REGION4_BASE  (OTFDEC1_BASE + 0xB0UL)
#define OTFDEC2_BASE          (D1_AHB1PERIPH_BASE + 0xBC00UL)
#define OTFDEC2_REGION1_BASE  (OTFDEC2_BASE + 0x20UL)
#define OTFDEC2_REGION2_BASE  (OTFDEC2_BASE + 0x50UL)
#define OTFDEC2_REGION3_BASE  (OTFDEC2_BASE + 0x80UL)
#define OTFDEC2_REGION4_BASE  (OTFDEC2_BASE + 0xB0UL)

/*!< D2_AHB1PERIPH peripherals */

#define DMA1_BASE               (D2_AHB1PERIPH_BASE + 0x0000UL)
#define DMA2_BASE               (D2_AHB1PERIPH_BASE + 0x0400UL)
#define DMAMUX1_BASE            (D2_AHB1PERIPH_BASE + 0x0800UL)
#define ADC1_BASE               (D2_AHB1PERIPH_BASE + 0x2000UL)
#define ADC2_BASE               (D2_AHB1PERIPH_BASE + 0x2100UL)
#define ADC12_COMMON_BASE       (D2_AHB1PERIPH_BASE + 0x2300UL)
#define ETH_BASE                (D2_AHB1PERIPH_BASE + 0x8000UL)
#define ETH_MAC_BASE            (ETH_BASE)

/*!< USB registers base address */
#define USB1_OTG_HS_PERIPH_BASE              (0x40040000UL)
#define USB_OTG_GLOBAL_BASE                  (0x000UL)
#define USB_OTG_DEVICE_BASE                  (0x800UL)
#define USB_OTG_IN_ENDPOINT_BASE             (0x900UL)
#define USB_OTG_OUT_ENDPOINT_BASE            (0xB00UL)
#define USB_OTG_EP_REG_SIZE                  (0x20UL)
#define USB_OTG_HOST_BASE                    (0x400UL)
#define USB_OTG_HOST_PORT_BASE               (0x440UL)
#define USB_OTG_HOST_CHANNEL_BASE            (0x500UL)
#define USB_OTG_HOST_CHANNEL_SIZE            (0x20UL)
#define USB_OTG_PCGCCTL_BASE                 (0xE00UL)
#define USB_OTG_FIFO_BASE                    (0x1000UL)
#define USB_OTG_FIFO_SIZE                    (0x1000UL)

/*!< D2_AHB2PERIPH peripherals */

#define DCMI_BASE              (D2_AHB2PERIPH_BASE + 0x0000UL)
#define PSSI_BASE              (D2_AHB2PERIPH_BASE + 0x0400UL)
#define CRYP_BASE              (D2_AHB2PERIPH_BASE + 0x1000UL)
#define HASH_BASE              (D2_AHB2PERIPH_BASE + 0x1400UL)
#define HASH_DIGEST_BASE       (D2_AHB2PERIPH_BASE + 0x1710UL)
#define RNG_BASE               (D2_AHB2PERIPH_BASE + 0x1800UL)
#define SDMMC2_BASE            (D2_AHB2PERIPH_BASE + 0x2400UL)
#define DLYB_SDMMC2_BASE       (D2_AHB2PERIPH_BASE + 0x2800UL)
#define RAMECC2_BASE           (D2_AHB2PERIPH_BASE + 0x3000UL)
#define FMAC_BASE              (D2_AHB2PERIPH_BASE + 0x4000UL)
#define CORDIC_BASE            (D2_AHB2PERIPH_BASE + 0x4400UL)

/*!< D3_AHB1PERIPH peripherals */
#define GPIOA_BASE            (D3_AHB1PERIPH_BASE + 0x0000UL)
#define GPIOB_BASE            (D3_AHB1PERIPH_BASE + 0x0400UL)
#define GPIOC_BASE            (D3_AHB1PERIPH_BASE + 0x0800UL)
#define GPIOD_BASE            (D3_AHB1PERIPH_BASE + 0x0C00UL)
#define GPIOE_BASE            (D3_AHB1PERIPH_BASE + 0x1000UL)
#define GPIOF_BASE            (D3_AHB1PERIPH_BASE + 0x1400UL)
#define GPIOG_BASE            (D3_AHB1PERIPH_BASE + 0x1800UL)
#define GPIOH_BASE            (D3_AHB1PERIPH_BASE + 0x1C00UL)
#define GPIOJ_BASE            (D3_AHB1PERIPH_BASE + 0x2400UL)
#define GPIOK_BASE            (D3_AHB1PERIPH_BASE + 0x2800UL)
#define RCC_BASE              (D3_AHB1PERIPH_BASE + 0x4400UL)
#define PWR_BASE              (D3_AHB1PERIPH_BASE + 0x4800UL)
#define CRC_BASE              (D3_AHB1PERIPH_BASE + 0x4C00UL)
#define BDMA_BASE             (D3_AHB1PERIPH_BASE + 0x5400UL)
#define DMAMUX2_BASE          (D3_AHB1PERIPH_BASE + 0x5800UL)
#define ADC3_BASE             (D3_AHB1PERIPH_BASE + 0x6000UL)
#define ADC3_COMMON_BASE      (D3_AHB1PERIPH_BASE + 0x6300UL)
#define HSEM_BASE             (D3_AHB1PERIPH_BASE + 0x6400UL)
#define RAMECC3_BASE          (D3_AHB1PERIPH_BASE + 0x7000UL)

/*!< D1_APB1PERIPH peripherals */
#define LTDC_BASE             (D1_APB1PERIPH_BASE + 0x1000UL)
#define LTDC_Layer1_BASE      (LTDC_BASE + 0x84UL)
#define LTDC_Layer2_BASE      (LTDC_BASE + 0x104UL)
#define WWDG1_BASE            (D1_APB1PERIPH_BASE + 0x3000UL)

/*!< D2_APB1PERIPH peripherals */
#define TIM2_BASE             (D2_APB1PERIPH_BASE + 0x0000UL)
#define TIM3_BASE             (D2_APB1PERIPH_BASE + 0x0400UL)
#define TIM4_BASE             (D2_APB1PERIPH_BASE + 0x0800UL)
#define TIM5_BASE             (D2_APB1PERIPH_BASE + 0x0C00UL)
#define TIM6_BASE             (D2_APB1PERIPH_BASE + 0x1000UL)
#define TIM7_BASE             (D2_APB1PERIPH_BASE + 0x1400UL)
#define TIM12_BASE            (D2_APB1PERIPH_BASE + 0x1800UL)
#define TIM13_BASE            (D2_APB1PERIPH_BASE + 0x1C00UL)
#define TIM14_BASE            (D2_APB1PERIPH_BASE + 0x2000UL)
#define LPTIM1_BASE           (D2_APB1PERIPH_BASE + 0x2400UL)


#define SPI2_BASE             (D2_APB1PERIPH_BASE + 0x3800UL)
#define SPI3_BASE             (D2_APB1PERIPH_BASE + 0x3C00UL)
#define SPDIFRX_BASE          (D2_APB1PERIPH_BASE + 0x4000UL)
#define USART2_BASE           (D2_APB1PERIPH_BASE + 0x4400UL)
#define USART3_BASE           (D2_APB1PERIPH_BASE + 0x4800UL)
#define UART4_BASE            (D2_APB1PERIPH_BASE + 0x4C00UL)
#define UART5_BASE            (D2_APB1PERIPH_BASE + 0x5000UL)
#define I2C1_BASE             (D2_APB1PERIPH_BASE + 0x5400UL)
#define I2C2_BASE             (D2_APB1PERIPH_BASE + 0x5800UL)
#define I2C3_BASE             (D2_APB1PERIPH_BASE + 0x5C00UL)
#define I2C5_BASE             (D2_APB1PERIPH_BASE + 0x6400UL)
#define CEC_BASE              (D2_APB1PERIPH_BASE + 0x6C00UL)
#define DAC1_BASE             (D2_APB1PERIPH_BASE + 0x7400UL)
#define UART7_BASE            (D2_APB1PERIPH_BASE + 0x7800UL)
#define UART8_BASE            (D2_APB1PERIPH_BASE + 0x7C00UL)
#define CRS_BASE              (D2_APB1PERIPH_BASE + 0x8400UL)
#define SWPMI1_BASE           (D2_APB1PERIPH_BASE + 0x8800UL)
#define OPAMP_BASE            (D2_APB1PERIPH_BASE + 0x9000UL)
#define OPAMP1_BASE           (D2_APB1PERIPH_BASE + 0x9000UL)
#define OPAMP2_BASE           (D2_APB1PERIPH_BASE + 0x9010UL)
#define MDIOS_BASE            (D2_APB1PERIPH_BASE + 0x9400UL)
#define FDCAN1_BASE           (D2_APB1PERIPH_BASE + 0xA000UL)
#define FDCAN2_BASE           (D2_APB1PERIPH_BASE + 0xA400UL)
#define FDCAN_CCU_BASE        (D2_APB1PERIPH_BASE + 0xA800UL)
#define SRAMCAN_BASE          (D2_APB1PERIPH_BASE + 0xAC00UL)
#define FDCAN3_BASE           (D2_APB1PERIPH_BASE + 0xD400UL)
#define TIM23_BASE            (D2_APB1PERIPH_BASE + 0xE000UL)
#define TIM24_BASE            (D2_APB1PERIPH_BASE + 0xE400UL)

/*!< D2_APB2PERIPH peripherals */

#define TIM1_BASE             (D2_APB2PERIPH_BASE + 0x0000UL)
#define TIM8_BASE             (D2_APB2PERIPH_BASE + 0x0400UL)
#define USART1_BASE           (D2_APB2PERIPH_BASE + 0x1000UL)
#define USART6_BASE           (D2_APB2PERIPH_BASE + 0x1400UL)
#define UART9_BASE            (D2_APB2PERIPH_BASE + 0x1800UL)
#define USART10_BASE          (D2_APB2PERIPH_BASE + 0x1C00UL)
#define SPI1_BASE             (D2_APB2PERIPH_BASE + 0x3000UL)
#define SPI4_BASE             (D2_APB2PERIPH_BASE + 0x3400UL)
#define TIM15_BASE            (D2_APB2PERIPH_BASE + 0x4000UL)
#define TIM16_BASE            (D2_APB2PERIPH_BASE + 0x4400UL)
#define TIM17_BASE            (D2_APB2PERIPH_BASE + 0x4800UL)
#define SPI5_BASE             (D2_APB2PERIPH_BASE + 0x5000UL)
#define SAI1_BASE             (D2_APB2PERIPH_BASE + 0x5800UL)
#define SAI1_Block_A_BASE     (SAI1_BASE + 0x004UL)
#define SAI1_Block_B_BASE     (SAI1_BASE + 0x024UL)
#define DFSDM1_BASE           (D2_APB2PERIPH_BASE + 0x7800UL)
#define DFSDM1_Channel0_BASE  (DFSDM1_BASE + 0x00UL)
#define DFSDM1_Channel1_BASE  (DFSDM1_BASE + 0x20UL)
#define DFSDM1_Channel2_BASE  (DFSDM1_BASE + 0x40UL)
#define DFSDM1_Channel3_BASE  (DFSDM1_BASE + 0x60UL)
#define DFSDM1_Channel4_BASE  (DFSDM1_BASE + 0x80UL)
#define DFSDM1_Channel5_BASE  (DFSDM1_BASE + 0xA0UL)
#define DFSDM1_Channel6_BASE  (DFSDM1_BASE + 0xC0UL)
#define DFSDM1_Channel7_BASE  (DFSDM1_BASE + 0xE0UL)
#define DFSDM1_Filter0_BASE   (DFSDM1_BASE + 0x100UL)
#define DFSDM1_Filter1_BASE   (DFSDM1_BASE + 0x180UL)
#define DFSDM1_Filter2_BASE   (DFSDM1_BASE + 0x200UL)
#define DFSDM1_Filter3_BASE   (DFSDM1_BASE + 0x280UL)


/*!< D3_APB1PERIPH peripherals */
#define EXTI_BASE             (D3_APB1PERIPH_BASE + 0x0000UL)
#define EXTI_D1_BASE          (EXTI_BASE + 0x0080UL)
#define EXTI_D2_BASE          (EXTI_BASE + 0x00C0UL)
#define SYSCFG_BASE           (D3_APB1PERIPH_BASE + 0x0400UL)
#define LPUART1_BASE          (D3_APB1PERIPH_BASE + 0x0C00UL)
#define SPI6_BASE             (D3_APB1PERIPH_BASE + 0x1400UL)
#define I2C4_BASE             (D3_APB1PERIPH_BASE + 0x1C00UL)
#define LPTIM2_BASE           (D3_APB1PERIPH_BASE + 0x2400UL)
#define LPTIM3_BASE           (D3_APB1PERIPH_BASE + 0x2800UL)
#define LPTIM4_BASE           (D3_APB1PERIPH_BASE + 0x2C00UL)
#define LPTIM5_BASE           (D3_APB1PERIPH_BASE + 0x3000UL)
#define COMP12_BASE           (D3_APB1PERIPH_BASE + 0x3800UL)
#define COMP1_BASE            (COMP12_BASE + 0x0CUL)
#define COMP2_BASE            (COMP12_BASE + 0x10UL)
#define VREFBUF_BASE          (D3_APB1PERIPH_BASE + 0x3C00UL)
#define RTC_BASE              (D3_APB1PERIPH_BASE + 0x4000UL)
#define IWDG1_BASE            (D3_APB1PERIPH_BASE + 0x4800UL)


#define SAI4_BASE             (D3_APB1PERIPH_BASE + 0x5400UL)
#define SAI4_Block_A_BASE     (SAI4_BASE + 0x004UL)
#define SAI4_Block_B_BASE     (SAI4_BASE + 0x024UL)

#define DTS_BASE              (D3_APB1PERIPH_BASE + 0x6800UL)



#define BDMA_Channel0_BASE    (BDMA_BASE + 0x0008UL)
#define BDMA_Channel1_BASE    (BDMA_BASE + 0x001CUL)
#define BDMA_Channel2_BASE    (BDMA_BASE + 0x0030UL)
#define BDMA_Channel3_BASE    (BDMA_BASE + 0x0044UL)
#define BDMA_Channel4_BASE    (BDMA_BASE + 0x0058UL)
#define BDMA_Channel5_BASE    (BDMA_BASE + 0x006CUL)
#define BDMA_Channel6_BASE    (BDMA_BASE + 0x0080UL)
#define BDMA_Channel7_BASE    (BDMA_BASE + 0x0094UL)

#define DMAMUX2_Channel0_BASE    (DMAMUX2_BASE)
#define DMAMUX2_Channel1_BASE    (DMAMUX2_BASE + 0x0004UL)
#define DMAMUX2_Channel2_BASE    (DMAMUX2_BASE + 0x0008UL)
#define DMAMUX2_Channel3_BASE    (DMAMUX2_BASE + 0x000CUL)
#define DMAMUX2_Channel4_BASE    (DMAMUX2_BASE + 0x0010UL)
#define DMAMUX2_Channel5_BASE    (DMAMUX2_BASE + 0x0014UL)
#define DMAMUX2_Channel6_BASE    (DMAMUX2_BASE + 0x0018UL)
#define DMAMUX2_Channel7_BASE    (DMAMUX2_BASE + 0x001CUL)

#define DMAMUX2_RequestGenerator0_BASE  (DMAMUX2_BASE + 0x0100UL)
#define DMAMUX2_RequestGenerator1_BASE  (DMAMUX2_BASE + 0x0104UL)
#define DMAMUX2_RequestGenerator2_BASE  (DMAMUX2_BASE + 0x0108UL)
#define DMAMUX2_RequestGenerator3_BASE  (DMAMUX2_BASE + 0x010CUL)
#define DMAMUX2_RequestGenerator4_BASE  (DMAMUX2_BASE + 0x0110UL)
#define DMAMUX2_RequestGenerator5_BASE  (DMAMUX2_BASE + 0x0114UL)
#define DMAMUX2_RequestGenerator6_BASE  (DMAMUX2_BASE + 0x0118UL)
#define DMAMUX2_RequestGenerator7_BASE  (DMAMUX2_BASE + 0x011CUL)

#define DMAMUX2_ChannelStatus_BASE      (DMAMUX2_BASE + 0x0080UL)
#define DMAMUX2_RequestGenStatus_BASE   (DMAMUX2_BASE + 0x0140UL)

#define DMA1_Stream0_BASE     (DMA1_BASE + 0x010UL)
#define DMA1_Stream1_BASE     (DMA1_BASE + 0x028UL)
#define DMA1_Stream2_BASE     (DMA1_BASE + 0x040UL)
#define DMA1_Stream3_BASE     (DMA1_BASE + 0x058UL)
#define DMA1_Stream4_BASE     (DMA1_BASE + 0x070UL)
#define DMA1_Stream5_BASE     (DMA1_BASE + 0x088UL)
#define DMA1_Stream6_BASE     (DMA1_BASE + 0x0A0UL)
#define DMA1_Stream7_BASE     (DMA1_BASE + 0x0B8UL)

#define DMA2_Stream0_BASE     (DMA2_BASE + 0x010UL)
#define DMA2_Stream1_BASE     (DMA2_BASE + 0x028UL)
#define DMA2_Stream2_BASE     (DMA2_BASE + 0x040UL)
#define DMA2_Stream3_BASE     (DMA2_BASE + 0x058UL)
#define DMA2_Stream4_BASE     (DMA2_BASE + 0x070UL)
#define DMA2_Stream5_BASE     (DMA2_BASE + 0x088UL)
#define DMA2_Stream6_BASE     (DMA2_BASE + 0x0A0UL)
#define DMA2_Stream7_BASE     (DMA2_BASE + 0x0B8UL)

#define DMAMUX1_Channel0_BASE    (DMAMUX1_BASE)
#define DMAMUX1_Channel1_BASE    (DMAMUX1_BASE + 0x0004UL)
#define DMAMUX1_Channel2_BASE    (DMAMUX1_BASE + 0x0008UL)
#define DMAMUX1_Channel3_BASE    (DMAMUX1_BASE + 0x000CUL)
#define DMAMUX1_Channel4_BASE    (DMAMUX1_BASE + 0x0010UL)
#define DMAMUX1_Channel5_BASE    (DMAMUX1_BASE + 0x0014UL)
#define DMAMUX1_Channel6_BASE    (DMAMUX1_BASE + 0x0018UL)
#define DMAMUX1_Channel7_BASE    (DMAMUX1_BASE + 0x001CUL)
#define DMAMUX1_Channel8_BASE    (DMAMUX1_BASE + 0x0020UL)
#define DMAMUX1_Channel9_BASE    (DMAMUX1_BASE + 0x0024UL)
#define DMAMUX1_Channel10_BASE   (DMAMUX1_BASE + 0x0028UL)
#define DMAMUX1_Channel11_BASE   (DMAMUX1_BASE + 0x002CUL)
#define DMAMUX1_Channel12_BASE   (DMAMUX1_BASE + 0x0030UL)
#define DMAMUX1_Channel13_BASE   (DMAMUX1_BASE + 0x0034UL)
#define DMAMUX1_Channel14_BASE   (DMAMUX1_BASE + 0x0038UL)
#define DMAMUX1_Channel15_BASE   (DMAMUX1_BASE + 0x003CUL)

#define DMAMUX1_RequestGenerator0_BASE  (DMAMUX1_BASE + 0x0100UL)
#define DMAMUX1_RequestGenerator1_BASE  (DMAMUX1_BASE + 0x0104UL)
#define DMAMUX1_RequestGenerator2_BASE  (DMAMUX1_BASE + 0x0108UL)
#define DMAMUX1_RequestGenerator3_BASE  (DMAMUX1_BASE + 0x010CUL)
#define DMAMUX1_RequestGenerator4_BASE  (DMAMUX1_BASE + 0x0110UL)
#define DMAMUX1_RequestGenerator5_BASE  (DMAMUX1_BASE + 0x0114UL)
#define DMAMUX1_RequestGenerator6_BASE  (DMAMUX1_BASE + 0x0118UL)
#define DMAMUX1_RequestGenerator7_BASE  (DMAMUX1_BASE + 0x011CUL)

#define DMAMUX1_ChannelStatus_BASE      (DMAMUX1_BASE + 0x0080UL)
#define DMAMUX1_RequestGenStatus_BASE   (DMAMUX1_BASE + 0x0140UL)

/*!< FMC Banks registers base  address */
#define FMC_Bank1_R_BASE      (FMC_R_BASE + 0x0000UL)
#define FMC_Bank1E_R_BASE     (FMC_R_BASE + 0x0104UL)
#define FMC_Bank2_R_BASE      (FMC_R_BASE + 0x0060UL)
#define FMC_Bank3_R_BASE      (FMC_R_BASE + 0x0080UL)
#define FMC_Bank5_6_R_BASE    (FMC_R_BASE + 0x0140UL)

/* Debug MCU registers base address */
#define DBGMCU_BASE           (0x5C001000UL)

#define MDMA_Channel0_BASE    (MDMA_BASE + 0x00000040UL)
#define MDMA_Channel1_BASE    (MDMA_BASE + 0x00000080UL)
#define MDMA_Channel2_BASE    (MDMA_BASE + 0x000000C0UL)
#define MDMA_Channel3_BASE    (MDMA_BASE + 0x00000100UL)
#define MDMA_Channel4_BASE    (MDMA_BASE + 0x00000140UL)
#define MDMA_Channel5_BASE    (MDMA_BASE + 0x00000180UL)
#define MDMA_Channel6_BASE    (MDMA_BASE + 0x000001C0UL)
#define MDMA_Channel7_BASE    (MDMA_BASE + 0x00000200UL)
#define MDMA_Channel8_BASE    (MDMA_BASE + 0x00000240UL)
#define MDMA_Channel9_BASE    (MDMA_BASE + 0x00000280UL)
#define MDMA_Channel10_BASE   (MDMA_BASE + 0x000002C0UL)
#define MDMA_Channel11_BASE   (MDMA_BASE + 0x00000300UL)
#define MDMA_Channel12_BASE   (MDMA_BASE + 0x00000340UL)
#define MDMA_Channel13_BASE   (MDMA_BASE + 0x00000380UL)
#define MDMA_Channel14_BASE   (MDMA_BASE + 0x000003C0UL)
#define MDMA_Channel15_BASE   (MDMA_BASE + 0x00000400UL)

#define RAMECC1_Monitor1_BASE (RAMECC1_BASE + 0x20UL)
#define RAMECC1_Monitor2_BASE (RAMECC1_BASE + 0x40UL)
#define RAMECC1_Monitor3_BASE (RAMECC1_BASE + 0x60UL)
#define RAMECC1_Monitor4_BASE (RAMECC1_BASE + 0x80UL)
#define RAMECC1_Monitor5_BASE (RAMECC1_BASE + 0xA0UL)
#define RAMECC1_Monitor6_BASE (RAMECC1_BASE + 0xC0UL)

#define RAMECC2_Monitor1_BASE (RAMECC2_BASE + 0x20UL)
#define RAMECC2_Monitor2_BASE (RAMECC2_BASE + 0x40UL)
#define RAMECC2_Monitor3_BASE (RAMECC2_BASE + 0x60UL)

#define RAMECC3_Monitor1_BASE (RAMECC3_BASE + 0x20UL)
#define RAMECC3_Monitor2_BASE (RAMECC3_BASE + 0x40UL)


/**
  * @}
  */

/** @addtogroup Peripheral_declaration
  * @{
  */
#define TIM2                ((TIM_TypeDef *) TIM2_BASE)
#define TIM3                ((TIM_TypeDef *) TIM3_BASE)
#define TIM4                ((TIM_TypeDef *) TIM4_BASE)
#define TIM5                ((TIM_TypeDef *) TIM5_BASE)
#define TIM6                ((TIM_TypeDef *) TIM6_BASE)
#define TIM7                ((TIM_TypeDef *) TIM7_BASE)
#define TIM13               ((TIM_TypeDef *) TIM13_BASE)
#define TIM14               ((TIM_TypeDef *) TIM14_BASE)
#define VREFBUF             ((VREFBUF_TypeDef *) VREFBUF_BASE)
#define RTC                 ((RTC_TypeDef *) RTC_BASE)
#define WWDG1               ((WWDG_TypeDef *) WWDG1_BASE)


#define IWDG1               ((IWDG_TypeDef *) IWDG1_BASE)
#define SPI2                ((SPI_TypeDef *) SPI2_BASE)
#define SPI3                ((SPI_TypeDef *) SPI3_BASE)
#define SPI4                ((SPI_TypeDef *) SPI4_BASE)
#define SPI5                ((SPI_TypeDef *) SPI5_BASE)
#define SPI6                ((SPI_TypeDef *) SPI6_BASE)
#define USART2              ((USART_TypeDef *) USART2_BASE)
#define USART3              ((USART_TypeDef *) USART3_BASE)
#define USART6              ((USART_TypeDef *) USART6_BASE)
#define USART10             ((USART_TypeDef *) USART10_BASE)
#define UART7               ((USART_TypeDef *) UART7_BASE)
#define UART8               ((USART_TypeDef *) UART8_BASE)
#define UART9               ((USART_TypeDef *) UART9_BASE)
#define CRS                 ((CRS_TypeDef *) CRS_BASE)
#define UART4               ((USART_TypeDef *) UART4_BASE)
#define UART5               ((USART_TypeDef *) UART5_BASE)
#define I2C1                ((I2C_TypeDef *) I2C1_BASE)
#define I2C2                ((I2C_TypeDef *) I2C2_BASE)
#define I2C3                ((I2C_TypeDef *) I2C3_BASE)
#define I2C4                ((I2C_TypeDef *) I2C4_BASE)
#define I2C5                ((I2C_TypeDef *) I2C5_BASE)
#define FDCAN1              ((FDCAN_GlobalTypeDef *) FDCAN1_BASE)
#define FDCAN2              ((FDCAN_GlobalTypeDef *) FDCAN2_BASE)
#define FDCAN_CCU           ((FDCAN_ClockCalibrationUnit_TypeDef *) FDCAN_CCU_BASE)
#define FDCAN3              ((FDCAN_GlobalTypeDef *) FDCAN3_BASE)
#define TIM23               ((TIM_TypeDef *) TIM23_BASE)
#define TIM24               ((TIM_TypeDef *) TIM24_BASE)
#define CEC                 ((CEC_TypeDef *) CEC_BASE)
#define LPTIM1              ((LPTIM_TypeDef *) LPTIM1_BASE)
#define PWR                 ((PWR_TypeDef *) PWR_BASE)
#define DAC1                ((DAC_TypeDef *) DAC1_BASE)
#define LPUART1             ((USART_TypeDef *) LPUART1_BASE)
#define SWPMI1              ((SWPMI_TypeDef *) SWPMI1_BASE)
#define LPTIM2              ((LPTIM_TypeDef *) LPTIM2_BASE)
#define LPTIM3              ((LPTIM_TypeDef *) LPTIM3_BASE)
#define DTS                 ((DTS_TypeDef *) DTS_BASE)
#define LPTIM4              ((LPTIM_TypeDef *) LPTIM4_BASE)
#define LPTIM5              ((LPTIM_TypeDef *) LPTIM5_BASE)

#define SYSCFG              ((SYSCFG_TypeDef *) SYSCFG_BASE)
#define COMP12              ((COMPOPT_TypeDef *) COMP12_BASE)
#define COMP1               ((COMP_TypeDef *) COMP1_BASE)
#define COMP2               ((COMP_TypeDef *) COMP2_BASE)
#define COMP12_COMMON       ((COMP_Common_TypeDef *) COMP2_BASE)
#define OPAMP               ((OPAMP_TypeDef *) OPAMP_BASE)
#define OPAMP1              ((OPAMP_TypeDef *) OPAMP1_BASE)
#define OPAMP2              ((OPAMP_TypeDef *) OPAMP2_BASE)


#define EXTI                ((EXTI_TypeDef *) EXTI_BASE)
#define EXTI_D1             ((EXTI_Core_TypeDef *) EXTI_D1_BASE)
#define EXTI_D2             ((EXTI_Core_TypeDef *) EXTI_D2_BASE)
#define TIM1                ((TIM_TypeDef *) TIM1_BASE)
#define SPI1                ((SPI_TypeDef *) SPI1_BASE)
#define TIM8                ((TIM_TypeDef *) TIM8_BASE)
#define USART1              ((USART_TypeDef *) USART1_BASE)
#define TIM12               ((TIM_TypeDef *) TIM12_BASE)
#define TIM15               ((TIM_TypeDef *) TIM15_BASE)
#define TIM16               ((TIM_TypeDef *) TIM16_BASE)
#define TIM17               ((TIM_TypeDef *) TIM17_BASE)
#define SAI1                ((SAI_TypeDef *) SAI1_BASE)
#define SAI1_Block_A        ((SAI_Block_TypeDef *)SAI1_Block_A_BASE)
#define SAI1_Block_B        ((SAI_Block_TypeDef *)SAI1_Block_B_BASE)
#define SAI4                ((SAI_TypeDef *) SAI4_BASE)
#define SAI4_Block_A        ((SAI_Block_TypeDef *)SAI4_Block_A_BASE)
#define SAI4_Block_B        ((SAI_Block_TypeDef *)SAI4_Block_B_BASE)

#define SPDIFRX             ((SPDIFRX_TypeDef *) SPDIFRX_BASE)
#define DFSDM1_Channel0     ((DFSDM_Channel_TypeDef *) DFSDM1_Channel0_BASE)
#define DFSDM1_Channel1     ((DFSDM_Channel_TypeDef *) DFSDM1_Channel1_BASE)
#define DFSDM1_Channel2     ((DFSDM_Channel_TypeDef *) DFSDM1_Channel2_BASE)
#define DFSDM1_Channel3     ((DFSDM_Channel_TypeDef *) DFSDM1_Channel3_BASE)
#define DFSDM1_Channel4     ((DFSDM_Channel_TypeDef *) DFSDM1_Channel4_BASE)
#define DFSDM1_Channel5     ((DFSDM_Channel_TypeDef *) DFSDM1_Channel5_BASE)
#define DFSDM1_Channel6     ((DFSDM_Channel_TypeDef *) DFSDM1_Channel6_BASE)
#define DFSDM1_Channel7     ((DFSDM_Channel_TypeDef *) DFSDM1_Channel7_BASE)
#define DFSDM1_Filter0      ((DFSDM_Filter_TypeDef *) DFSDM1_Filter0_BASE)
#define DFSDM1_Filter1      ((DFSDM_Filter_TypeDef *) DFSDM1_Filter1_BASE)
#define DFSDM1_Filter2      ((DFSDM_Filter_TypeDef *) DFSDM1_Filter2_BASE)
#define DFSDM1_Filter3      ((DFSDM_Filter_TypeDef *) DFSDM1_Filter3_BASE)
#define DMA2D               ((DMA2D_TypeDef *) DMA2D_BASE)
#define DCMI                ((DCMI_TypeDef *) DCMI_BASE)
#define PSSI                ((PSSI_TypeDef *) PSSI_BASE)
#define RCC                 ((RCC_TypeDef *) RCC_BASE)
#define FLASH               ((FLASH_TypeDef *) FLASH_R_BASE)
#define CRC                 ((CRC_TypeDef *) CRC_BASE)

#define GPIOA               ((GPIO_TypeDef *) GPIOA_BASE)
#define GPIOB               ((GPIO_TypeDef *) GPIOB_BASE)
#define GPIOC               ((GPIO_TypeDef *) GPIOC_BASE)
#define GPIOD               ((GPIO_TypeDef *) GPIOD_BASE)
#define GPIOE               ((GPIO_TypeDef *) GPIOE_BASE)
#define GPIOF               ((GPIO_TypeDef *) GPIOF_BASE)
#define GPIOG               ((GPIO_TypeDef *) GPIOG_BASE)
#define GPIOH               ((GPIO_TypeDef *) GPIOH_BASE)
#define GPIOJ               ((GPIO_TypeDef *) GPIOJ_BASE)
#define GPIOK               ((GPIO_TypeDef *) GPIOK_BASE)

#define ADC1                ((ADC_TypeDef *) ADC1_BASE)
#define ADC2                ((ADC_TypeDef *) ADC2_BASE)
#define ADC3                ((ADC_TypeDef *) ADC3_BASE)
#define ADC3_COMMON         ((ADC_Common_TypeDef *) ADC3_COMMON_BASE)
#define ADC12_COMMON        ((ADC_Common_TypeDef *) ADC12_COMMON_BASE)

#define CRYP                ((CRYP_TypeDef *) CRYP_BASE)
#define HASH                ((HASH_TypeDef *) HASH_BASE)
#define HASH_DIGEST         ((HASH_DIGEST_TypeDef *) HASH_DIGEST_BASE)
#define RNG                 ((RNG_TypeDef *) RNG_BASE)
#define SDMMC2              ((SDMMC_TypeDef *) SDMMC2_BASE)
#define DLYB_SDMMC2         ((DLYB_TypeDef *) DLYB_SDMMC2_BASE)
#define FMAC                ((FMAC_TypeDef *) FMAC_BASE)
#define CORDIC              ((CORDIC_TypeDef *) CORDIC_BASE)

#define BDMA                ((BDMA_TypeDef *) BDMA_BASE)
#define BDMA_Channel0       ((BDMA_Channel_TypeDef *) BDMA_Channel0_BASE)
#define BDMA_Channel1       ((BDMA_Channel_TypeDef *) BDMA_Channel1_BASE)
#define BDMA_Channel2       ((BDMA_Channel_TypeDef *) BDMA_Channel2_BASE)
#define BDMA_Channel3       ((BDMA_Channel_TypeDef *) BDMA_Channel3_BASE)
#define BDMA_Channel4       ((BDMA_Channel_TypeDef *) BDMA_Channel4_BASE)
#define BDMA_Channel5       ((BDMA_Channel_TypeDef *) BDMA_Channel5_BASE)
#define BDMA_Channel6       ((BDMA_Channel_TypeDef *) BDMA_Channel6_BASE)
#define BDMA_Channel7       ((BDMA_Channel_TypeDef *) BDMA_Channel7_BASE)

#define RAMECC1              ((RAMECC_TypeDef *)RAMECC1_BASE)
#define RAMECC1_Monitor1     ((RAMECC_MonitorTypeDef *)RAMECC1_Monitor1_BASE)
#define RAMECC1_Monitor2     ((RAMECC_MonitorTypeDef *)RAMECC1_Monitor2_BASE)
#define RAMECC1_Monitor3     ((RAMECC_MonitorTypeDef *)RAMECC1_Monitor3_BASE)
#define RAMECC1_Monitor4     ((RAMECC_MonitorTypeDef *)RAMECC1_Monitor4_BASE)
#define RAMECC1_Monitor5     ((RAMECC_MonitorTypeDef *)RAMECC1_Monitor5_BASE)
#define RAMECC1_Monitor6     ((RAMECC_MonitorTypeDef *)RAMECC1_Monitor6_BASE)

#define RAMECC2              ((RAMECC_TypeDef *)RAMECC2_BASE)
#define RAMECC2_Monitor1     ((RAMECC_MonitorTypeDef *)RAMECC2_Monitor1_BASE)
#define RAMECC2_Monitor2     ((RAMECC_MonitorTypeDef *)RAMECC2_Monitor2_BASE)
#define RAMECC2_Monitor3     ((RAMECC_MonitorTypeDef *)RAMECC2_Monitor3_BASE)

#define RAMECC3              ((RAMECC_TypeDef *)RAMECC3_BASE)
#define RAMECC3_Monitor1     ((RAMECC_MonitorTypeDef *)RAMECC3_Monitor1_BASE)
#define RAMECC3_Monitor2     ((RAMECC_MonitorTypeDef *)RAMECC3_Monitor2_BASE)

#define DMAMUX2                ((DMAMUX_Channel_TypeDef *) DMAMUX2_BASE)
#define DMAMUX2_Channel0       ((DMAMUX_Channel_TypeDef *) DMAMUX2_Channel0_BASE)
#define DMAMUX2_Channel1       ((DMAMUX_Channel_TypeDef *) DMAMUX2_Channel1_BASE)
#define DMAMUX2_Channel2       ((DMAMUX_Channel_TypeDef *) DMAMUX2_Channel2_BASE)
#define DMAMUX2_Channel3       ((DMAMUX_Channel_TypeDef *) DMAMUX2_Channel3_BASE)
#define DMAMUX2_Channel4       ((DMAMUX_Channel_TypeDef *) DMAMUX2_Channel4_BASE)
#define DMAMUX2_Channel5       ((DMAMUX_Channel_TypeDef *) DMAMUX2_Channel5_BASE)
#define DMAMUX2_Channel6       ((DMAMUX_Channel_TypeDef *) DMAMUX2_Channel6_BASE)
#define DMAMUX2_Channel7       ((DMAMUX_Channel_TypeDef *) DMAMUX2_Channel7_BASE)


#define DMAMUX2_RequestGenerator0  ((DMAMUX_RequestGen_TypeDef *) DMAMUX2_RequestGenerator0_BASE)
#define DMAMUX2_RequestGenerator1  ((DMAMUX_RequestGen_TypeDef *) DMAMUX2_RequestGenerator1_BASE)
#define DMAMUX2_RequestGenerator2  ((DMAMUX_RequestGen_TypeDef *) DMAMUX2_RequestGenerator2_BASE)
#define DMAMUX2_RequestGenerator3  ((DMAMUX_RequestGen_TypeDef *) DMAMUX2_RequestGenerator3_BASE)
#define DMAMUX2_RequestGenerator4  ((DMAMUX_RequestGen_TypeDef *) DMAMUX2_RequestGenerator4_BASE)
#define DMAMUX2_RequestGenerator5  ((DMAMUX_RequestGen_TypeDef *) DMAMUX2_RequestGenerator5_BASE)
#define DMAMUX2_RequestGenerator6  ((DMAMUX_RequestGen_TypeDef *) DMAMUX2_RequestGenerator6_BASE)
#define DMAMUX2_RequestGenerator7  ((DMAMUX_RequestGen_TypeDef *) DMAMUX2_RequestGenerator7_BASE)

#define DMAMUX2_ChannelStatus      ((DMAMUX_ChannelStatus_TypeDef *) DMAMUX2_ChannelStatus_BASE)
#define DMAMUX2_RequestGenStatus   ((DMAMUX_RequestGenStatus_TypeDef *) DMAMUX2_RequestGenStatus_BASE)

#define DMA2                ((DMA_TypeDef *) DMA2_BASE)
#define DMA2_Stream0        ((DMA_Stream_TypeDef *) DMA2_Stream0_BASE)
#define DMA2_Stream1        ((DMA_Stream_TypeDef *) DMA2_Stream1_BASE)
#define DMA2_Stream2        ((DMA_Stream_TypeDef *) DMA2_Stream2_BASE)
#define DMA2_Stream3        ((DMA_Stream_TypeDef *) DMA2_Stream3_BASE)
#define DMA2_Stream4        ((DMA_Stream_TypeDef *) DMA2_Stream4_BASE)
#define DMA2_Stream5        ((DMA_Stream_TypeDef *) DMA2_Stream5_BASE)
#define DMA2_Stream6        ((DMA_Stream_TypeDef *) DMA2_Stream6_BASE)
#define DMA2_Stream7        ((DMA_Stream_TypeDef *) DMA2_Stream7_BASE)

#define DMA1                ((DMA_TypeDef *) DMA1_BASE)
#define DMA1_Stream0        ((DMA_Stream_TypeDef *) DMA1_Stream0_BASE)
#define DMA1_Stream1        ((DMA_Stream_TypeDef *) DMA1_Stream1_BASE)
#define DMA1_Stream2        ((DMA_Stream_TypeDef *) DMA1_Stream2_BASE)
#define DMA1_Stream3        ((DMA_Stream_TypeDef *) DMA1_Stream3_BASE)
#define DMA1_Stream4        ((DMA_Stream_TypeDef *) DMA1_Stream4_BASE)
#define DMA1_Stream5        ((DMA_Stream_TypeDef *) DMA1_Stream5_BASE)
#define DMA1_Stream6        ((DMA_Stream_TypeDef *) DMA1_Stream6_BASE)
#define DMA1_Stream7        ((DMA_Stream_TypeDef *) DMA1_Stream7_BASE)


#define DMAMUX1              ((DMAMUX_Channel_TypeDef *) DMAMUX1_BASE)
#define DMAMUX1_Channel0     ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel0_BASE)
#define DMAMUX1_Channel1     ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel1_BASE)
#define DMAMUX1_Channel2     ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel2_BASE)
#define DMAMUX1_Channel3     ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel3_BASE)
#define DMAMUX1_Channel4     ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel4_BASE)
#define DMAMUX1_Channel5     ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel5_BASE)
#define DMAMUX1_Channel6     ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel6_BASE)
#define DMAMUX1_Channel7     ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel7_BASE)
#define DMAMUX1_Channel8     ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel8_BASE)
#define DMAMUX1_Channel9     ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel9_BASE)
#define DMAMUX1_Channel10    ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel10_BASE)
#define DMAMUX1_Channel11    ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel11_BASE)
#define DMAMUX1_Channel12    ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel12_BASE)
#define DMAMUX1_Channel13    ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel13_BASE)
#define DMAMUX1_Channel14    ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel14_BASE)
#define DMAMUX1_Channel15    ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel15_BASE)

#define DMAMUX1_RequestGenerator0  ((DMAMUX_RequestGen_TypeDef *) DMAMUX1_RequestGenerator0_BASE)
#define DMAMUX1_RequestGenerator1  ((DMAMUX_RequestGen_TypeDef *) DMAMUX1_RequestGenerator1_BASE)
#define DMAMUX1_RequestGenerator2  ((DMAMUX_RequestGen_TypeDef *) DMAMUX1_RequestGenerator2_BASE)
#define DMAMUX1_RequestGenerator3  ((DMAMUX_RequestGen_TypeDef *) DMAMUX1_RequestGenerator3_BASE)
#define DMAMUX1_RequestGenerator4  ((DMAMUX_RequestGen_TypeDef *) DMAMUX1_RequestGenerator4_BASE)
#define DMAMUX1_RequestGenerator5  ((DMAMUX_RequestGen_TypeDef *) DMAMUX1_RequestGenerator5_BASE)
#define DMAMUX1_RequestGenerator6  ((DMAMUX_RequestGen_TypeDef *) DMAMUX1_RequestGenerator6_BASE)
#define DMAMUX1_RequestGenerator7  ((DMAMUX_RequestGen_TypeDef *) DMAMUX1_RequestGenerator7_BASE)

#define DMAMUX1_ChannelStatus      ((DMAMUX_ChannelStatus_TypeDef *)    DMAMUX1_ChannelStatus_BASE)
#define DMAMUX1_RequestGenStatus   ((DMAMUX_RequestGenStatus_TypeDef *) DMAMUX1_RequestGenStatus_BASE)


#define FMC_Bank1_R           ((FMC_Bank1_TypeDef *) FMC_Bank1_R_BASE)
#define FMC_Bank1E_R          ((FMC_Bank1E_TypeDef *) FMC_Bank1E_R_BASE)
#define FMC_Bank2_R           ((FMC_Bank2_TypeDef *) FMC_Bank2_R_BASE)
#define FMC_Bank3_R           ((FMC_Bank3_TypeDef *) FMC_Bank3_R_BASE)
#define FMC_Bank5_6_R         ((FMC_Bank5_6_TypeDef *) FMC_Bank5_6_R_BASE)

#define OCTOSPI1            ((OCTOSPI_TypeDef *) OCTOSPI1_R_BASE)
#define DLYB_OCTOSPI1       ((DLYB_TypeDef *) DLYB_OCTOSPI1_BASE)
#define OCTOSPI2            ((OCTOSPI_TypeDef *) OCTOSPI2_R_BASE)
#define DLYB_OCTOSPI2       ((DLYB_TypeDef *) DLYB_OCTOSPI2_BASE)
#define OCTOSPIM            ((OCTOSPIM_TypeDef *) OCTOSPIM_BASE)

#define OTFDEC1               ((OTFDEC_TypeDef *) OTFDEC1_BASE)
#define OTFDEC1_REGION1       ((OTFDEC_Region_TypeDef *) OTFDEC1_REGION1_BASE)
#define OTFDEC1_REGION2       ((OTFDEC_Region_TypeDef *) OTFDEC1_REGION2_BASE)
#define OTFDEC1_REGION3       ((OTFDEC_Region_TypeDef *) OTFDEC1_REGION3_BASE)
#define OTFDEC1_REGION4       ((OTFDEC_Region_TypeDef *) OTFDEC1_REGION4_BASE)

#define OTFDEC2               ((OTFDEC_TypeDef *) OTFDEC2_BASE)
#define OTFDEC2_REGION1       ((OTFDEC_Region_TypeDef *) OTFDEC2_REGION1_BASE)
#define OTFDEC2_REGION2       ((OTFDEC_Region_TypeDef *) OTFDEC2_REGION2_BASE)
#define OTFDEC2_REGION3       ((OTFDEC_Region_TypeDef *) OTFDEC2_REGION3_BASE)
#define OTFDEC2_REGION4       ((OTFDEC_Region_TypeDef *) OTFDEC2_REGION4_BASE)

#define SDMMC1                ((SDMMC_TypeDef *) SDMMC1_BASE)
#define DLYB_SDMMC1           ((DLYB_TypeDef *) DLYB_SDMMC1_BASE)

#define DBGMCU              ((DBGMCU_TypeDef *) DBGMCU_BASE)

#define HSEM                ((HSEM_TypeDef *) HSEM_BASE)
#define HSEM_COMMON         ((HSEM_Common_TypeDef *) (HSEM_BASE + 0x100UL))

#define LTDC                ((LTDC_TypeDef *)LTDC_BASE)
#define LTDC_Layer1         ((LTDC_Layer_TypeDef *)LTDC_Layer1_BASE)
#define LTDC_Layer2         ((LTDC_Layer_TypeDef *)LTDC_Layer2_BASE)

#define MDIOS               ((MDIOS_TypeDef *) MDIOS_BASE)

#define ETH                 ((ETH_TypeDef *)ETH_BASE)
#define MDMA                ((MDMA_TypeDef *)MDMA_BASE)
#define MDMA_Channel0       ((MDMA_Channel_TypeDef *)MDMA_Channel0_BASE)
#define MDMA_Channel1       ((MDMA_Channel_TypeDef *)MDMA_Channel1_BASE)
#define MDMA_Channel2       ((MDMA_Channel_TypeDef *)MDMA_Channel2_BASE)
#define MDMA_Channel3       ((MDMA_Channel_TypeDef *)MDMA_Channel3_BASE)
#define MDMA_Channel4       ((MDMA_Channel_TypeDef *)MDMA_Channel4_BASE)
#define MDMA_Channel5       ((MDMA_Channel_TypeDef *)MDMA_Channel5_BASE)
#define MDMA_Channel6       ((MDMA_Channel_TypeDef *)MDMA_Channel6_BASE)
#define MDMA_Channel7       ((MDMA_Channel_TypeDef *)MDMA_Channel7_BASE)
#define MDMA_Channel8       ((MDMA_Channel_TypeDef *)MDMA_Channel8_BASE)
#define MDMA_Channel9       ((MDMA_Channel_TypeDef *)MDMA_Channel9_BASE)
#define MDMA_Channel10      ((MDMA_Channel_TypeDef *)MDMA_Channel10_BASE)
#define MDMA_Channel11      ((MDMA_Channel_TypeDef *)MDMA_Channel11_BASE)
#define MDMA_Channel12      ((MDMA_Channel_TypeDef *)MDMA_Channel12_BASE)
#define MDMA_Channel13      ((MDMA_Channel_TypeDef *)MDMA_Channel13_BASE)
#define MDMA_Channel14      ((MDMA_Channel_TypeDef *)MDMA_Channel14_BASE)
#define MDMA_Channel15      ((MDMA_Channel_TypeDef *)MDMA_Channel15_BASE)


#define USB1_OTG_HS         ((USB_OTG_GlobalTypeDef *) USB1_OTG_HS_PERIPH_BASE)

/* Legacy defines */
#define USB_OTG_HS                   USB1_OTG_HS
#define USB_OTG_HS_PERIPH_BASE       USB1_OTG_HS_PERIPH_BASE

/**
  * @}
  */

/** @addtogroup Exported_constants
  * @{
  */

  /** @addtogroup Peripheral_Registers_Bits_Definition
  * @{
  */

/******************************************************************************/
/*                         Peripheral Registers_Bits_Definition               */
/******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*                        Analog to Digital Converter                         */
/*                                                                            */
/******************************************************************************/
/*******************************  ADC VERSION  ********************************/
#define ADC_VER_V5_V90
/********************  Bit definition for ADC_ISR register  ********************/
#define ADC_ISR_ADRDY_Pos                 (0U)
#define ADC_ISR_ADRDY_Msk                 (0x1UL << ADC_ISR_ADRDY_Pos)         /*!< 0x00000001 */
#define ADC_ISR_ADRDY                     ADC_ISR_ADRDY_Msk                    /*!< ADC Ready (ADRDY) flag  */
#define ADC_ISR_EOSMP_Pos                 (1U)
#define ADC_ISR_EOSMP_Msk                 (0x1UL << ADC_ISR_EOSMP_Pos)         /*!< 0x00000002 */
#define ADC_ISR_EOSMP                     ADC_ISR_EOSMP_Msk                    /*!< ADC End of Sampling flag */
#define ADC_ISR_EOC_Pos                   (2U)
#define ADC_ISR_EOC_Msk                   (0x1UL << ADC_ISR_EOC_Pos)           /*!< 0x00000004 */
#define ADC_ISR_EOC                       ADC_ISR_EOC_Msk                      /*!< ADC End of Regular Conversion flag */
#define ADC_ISR_EOS_Pos                   (3U)
#define ADC_ISR_EOS_Msk                   (0x1UL << ADC_ISR_EOS_Pos)           /*!< 0x00000008 */
#define ADC_ISR_EOS                       ADC_ISR_EOS_Msk                      /*!< ADC End of Regular sequence of Conversions flag */
#define ADC_ISR_OVR_Pos                   (4U)
#define ADC_ISR_OVR_Msk                   (0x1UL << ADC_ISR_OVR_Pos)           /*!< 0x00000010 */
#define ADC_ISR_OVR                       ADC_ISR_OVR_Msk                      /*!< ADC overrun flag */
#define ADC_ISR_JEOC_Pos                  (5U)
#define ADC_ISR_JEOC_Msk                  (0x1UL << ADC_ISR_JEOC_Pos)          /*!< 0x00000020 */
#define ADC_ISR_JEOC                      ADC_ISR_JEOC_Msk                     /*!< ADC End of Injected Conversion flag */
#define ADC_ISR_JEOS_Pos                  (6U)
#define ADC_ISR_JEOS_Msk                  (0x1UL << ADC_ISR_JEOS_Pos)          /*!< 0x00000040 */
#define ADC_ISR_JEOS                      ADC_ISR_JEOS_Msk                     /*!< ADC End of Injected sequence of Conversions flag */
#define ADC_ISR_AWD1_Pos                  (7U)
#define ADC_ISR_AWD1_Msk                  (0x1UL << ADC_ISR_AWD1_Pos)          /*!< 0x00000080 */
#define ADC_ISR_AWD1                      ADC_ISR_AWD1_Msk                     /*!< ADC Analog watchdog 1 flag */
#define ADC_ISR_AWD2_Pos                  (8U)
#define ADC_ISR_AWD2_Msk                  (0x1UL << ADC_ISR_AWD2_Pos)          /*!< 0x00000100 */
#define ADC_ISR_AWD2                      ADC_ISR_AWD2_Msk                     /*!< ADC Analog watchdog 2 flag */
#define ADC_ISR_AWD3_Pos                  (9U)
#define ADC_ISR_AWD3_Msk                  (0x1UL << ADC_ISR_AWD3_Pos)          /*!< 0x00000200 */
#define ADC_ISR_AWD3                      ADC_ISR_AWD3_Msk                     /*!< ADC Analog watchdog 3 flag */
#define ADC_ISR_JQOVF_Pos                 (10U)
#define ADC_ISR_JQOVF_Msk                 (0x1UL << ADC_ISR_JQOVF_Pos)         /*!< 0x00000400 */
#define ADC_ISR_JQOVF                     ADC_ISR_JQOVF_Msk                    /*!< ADC Injected Context Queue Overflow flag */

/********************  Bit definition for ADC_IER register  ********************/
#define ADC_IER_ADRDYIE_Pos               (0U)
#define ADC_IER_ADRDYIE_Msk               (0x1UL << ADC_IER_ADRDYIE_Pos)       /*!< 0x00000001 */
#define ADC_IER_ADRDYIE                   ADC_IER_ADRDYIE_Msk                  /*!< ADC Ready (ADRDY) interrupt source */
#define ADC_IER_EOSMPIE_Pos               (1U)
#define ADC_IER_EOSMPIE_Msk               (0x1UL << ADC_IER_EOSMPIE_Pos)       /*!< 0x00000002 */
#define ADC_IER_EOSMPIE                   ADC_IER_EOSMPIE_Msk                  /*!< ADC End of Sampling interrupt source */
#define ADC_IER_EOCIE_Pos                 (2U)
#define ADC_IER_EOCIE_Msk                 (0x1UL << ADC_IER_EOCIE_Pos)         /*!< 0x00000004 */
#define ADC_IER_EOCIE                     ADC_IER_EOCIE_Msk                    /*!< ADC End of Regular Conversion interrupt source */
#define ADC_IER_EOSIE_Pos                 (3U)
#define ADC_IER_EOSIE_Msk                 (0x1UL << ADC_IER_EOSIE_Pos)         /*!< 0x00000008 */
#define ADC_IER_EOSIE                     ADC_IER_EOSIE_Msk                    /*!< ADC End of Regular sequence of Conversions interrupt source */
#define ADC_IER_OVRIE_Pos                 (4U)
#define ADC_IER_OVRIE_Msk                 (0x1UL << ADC_IER_OVRIE_Pos)         /*!< 0x00000010 */
#define ADC_IER_OVRIE                     ADC_IER_OVRIE_Msk                    /*!< ADC overrun interrupt source */
#define ADC_IER_JEOCIE_Pos                (5U)
#define ADC_IER_JEOCIE_Msk                (0x1UL << ADC_IER_JEOCIE_Pos)        /*!< 0x00000020 */
#define ADC_IER_JEOCIE                    ADC_IER_JEOCIE_Msk                   /*!< ADC End of Injected Conversion interrupt source */
#define ADC_IER_JEOSIE_Pos                (6U)
#define ADC_IER_JEOSIE_Msk                (0x1UL << ADC_IER_JEOSIE_Pos)        /*!< 0x00000040 */
#define ADC_IER_JEOSIE                    ADC_IER_JEOSIE_Msk                   /*!< ADC End of Injected sequence of Conversions interrupt source */
#define ADC_IER_AWD1IE_Pos                (7U)
#define ADC_IER_AWD1IE_Msk                (0x1UL << ADC_IER_AWD1IE_Pos)        /*!< 0x00000080 */
#define ADC_IER_AWD1IE                    ADC_IER_AWD1IE_Msk                   /*!< ADC Analog watchdog 1 interrupt source */
#define ADC_IER_AWD2IE_Pos                (8U)
#define ADC_IER_AWD2IE_Msk                (0x1UL << ADC_IER_AWD2IE_Pos)        /*!< 0x00000100 */
#define ADC_IER_AWD2IE                    ADC_IER_AWD2IE_Msk                   /*!< ADC Analog watchdog 2 interrupt source */
#define ADC_IER_AWD3IE_Pos                (9U)
#define ADC_IER_AWD3IE_Msk                (0x1UL << ADC_IER_AWD3IE_Pos)        /*!< 0x00000200 */
#define ADC_IER_AWD3IE                    ADC_IER_AWD3IE_Msk                   /*!< ADC Analog watchdog 3 interrupt source */
#define ADC_IER_JQOVFIE_Pos               (10U)
#define ADC_IER_JQOVFIE_Msk               (0x1UL << ADC_IER_JQOVFIE_Pos)       /*!< 0x00000400 */
#define ADC_IER_JQOVFIE                   ADC_IER_JQOVFIE_Msk                  /*!< ADC Injected Context Queue Overflow interrupt source */

/********************  Bit definition for ADC_CR register  ********************/
#define ADC_CR_ADEN_Pos                   (0U)
#define ADC_CR_ADEN_Msk                   (0x1UL << ADC_CR_ADEN_Pos)           /*!< 0x00000001 */
#define ADC_CR_ADEN                       ADC_CR_ADEN_Msk                      /*!< ADC Enable control */
#define ADC_CR_ADDIS_Pos                  (1U)
#define ADC_CR_ADDIS_Msk                  (0x1UL << ADC_CR_ADDIS_Pos)          /*!< 0x00000002 */
#define ADC_CR_ADDIS                      ADC_CR_ADDIS_Msk                     /*!< ADC Disable command */
#define ADC_CR_ADSTART_Pos                (2U)
#define ADC_CR_ADSTART_Msk                (0x1UL << ADC_CR_ADSTART_Pos)        /*!< 0x00000004 */
#define ADC_CR_ADSTART                    ADC_CR_ADSTART_Msk                   /*!< ADC Start of Regular conversion */
#define ADC_CR_JADSTART_Pos               (3U)
#define ADC_CR_JADSTART_Msk               (0x1UL << ADC_CR_JADSTART_Pos)       /*!< 0x00000008 */
#define ADC_CR_JADSTART                   ADC_CR_JADSTART_Msk                  /*!< ADC Start of injected conversion */
#define ADC_CR_ADSTP_Pos                  (4U)
#define ADC_CR_ADSTP_Msk                  (0x1UL << ADC_CR_ADSTP_Pos)          /*!< 0x00000010 */
#define ADC_CR_ADSTP                      ADC_CR_ADSTP_Msk                     /*!< ADC Stop of Regular conversion */
#define ADC_CR_JADSTP_Pos                 (5U)
#define ADC_CR_JADSTP_Msk                 (0x1UL << ADC_CR_JADSTP_Pos)         /*!< 0x00000020 */
#define ADC_CR_JADSTP                     ADC_CR_JADSTP_Msk                    /*!< ADC Stop of injected conversion */
#define ADC_CR_BOOST_Pos                  (8U)
#define ADC_CR_BOOST_Msk                  (0x3UL << ADC_CR_BOOST_Pos)          /*!< 0x00000300 */
#define ADC_CR_BOOST                      ADC_CR_BOOST_Msk                     /*!< ADC Boost Mode configuration */
#define ADC_CR_BOOST_0                    (0x1UL << ADC_CR_BOOST_Pos)           /*!< 0x00000100 */
#define ADC_CR_BOOST_1                    (0x2UL << ADC_CR_BOOST_Pos)           /*!< 0x00000200 */
#define ADC_CR_ADCALLIN_Pos               (16U)
#define ADC_CR_ADCALLIN_Msk               (0x1UL << ADC_CR_ADCALLIN_Pos)       /*!< 0x00010000 */
#define ADC_CR_ADCALLIN                   ADC_CR_ADCALLIN_Msk                  /*!< ADC Linearity calibration */
#define ADC_CR_LINCALRDYW1_Pos            (22U)
#define ADC_CR_LINCALRDYW1_Msk            (0x1UL << ADC_CR_LINCALRDYW1_Pos)    /*!< 0x00400000 */
#define ADC_CR_LINCALRDYW1                ADC_CR_LINCALRDYW1_Msk               /*!< ADC Linearity calibration ready Word 1 */
#define ADC_CR_LINCALRDYW2_Pos            (23U)
#define ADC_CR_LINCALRDYW2_Msk            (0x1UL << ADC_CR_LINCALRDYW2_Pos)    /*!< 0x00800000 */
#define ADC_CR_LINCALRDYW2                ADC_CR_LINCALRDYW2_Msk               /*!< ADC Linearity calibration ready Word 2 */
#define ADC_CR_LINCALRDYW3_Pos            (24U)
#define ADC_CR_LINCALRDYW3_Msk            (0x1UL << ADC_CR_LINCALRDYW3_Pos)    /*!< 0x01000000 */
#define ADC_CR_LINCALRDYW3                ADC_CR_LINCALRDYW3_Msk               /*!< ADC Linearity calibration ready Word 3 */
#define ADC_CR_LINCALRDYW4_Pos            (25U)
#define ADC_CR_LINCALRDYW4_Msk            (0x1UL << ADC_CR_LINCALRDYW4_Pos)    /*!< 0x02000000 */
#define ADC_CR_LINCALRDYW4                ADC_CR_LINCALRDYW4_Msk               /*!< ADC Linearity calibration ready Word 4 */
#define ADC_CR_LINCALRDYW5_Pos            (26U)
#define ADC_CR_LINCALRDYW5_Msk            (0x1UL << ADC_CR_LINCALRDYW5_Pos)    /*!< 0x04000000 */
#define ADC_CR_LINCALRDYW5                ADC_CR_LINCALRDYW5_Msk               /*!< ADC Linearity calibration ready Word 5 */
#define ADC_CR_LINCALRDYW6_Pos            (27U)
#define ADC_CR_LINCALRDYW6_Msk            (0x1UL << ADC_CR_LINCALRDYW6_Pos)    /*!< 0x08000000 */
#define ADC_CR_LINCALRDYW6                ADC_CR_LINCALRDYW6_Msk               /*!< ADC Linearity calibration ready Word 6 */
#define ADC_CR_ADVREGEN_Pos               (28U)
#define ADC_CR_ADVREGEN_Msk               (0x1UL << ADC_CR_ADVREGEN_Pos)       /*!< 0x10000000 */
#define ADC_CR_ADVREGEN                   ADC_CR_ADVREGEN_Msk                  /*!< ADC Voltage regulator Enable */
#define ADC_CR_DEEPPWD_Pos                (29U)
#define ADC_CR_DEEPPWD_Msk                (0x1UL << ADC_CR_DEEPPWD_Pos)        /*!< 0x20000000 */
#define ADC_CR_DEEPPWD                    ADC_CR_DEEPPWD_Msk                   /*!< ADC Deep power down Enable */
#define ADC_CR_ADCALDIF_Pos               (30U)
#define ADC_CR_ADCALDIF_Msk               (0x1UL << ADC_CR_ADCALDIF_Pos)       /*!< 0x40000000 */
#define ADC_CR_ADCALDIF                   ADC_CR_ADCALDIF_Msk                  /*!< ADC Differential Mode for calibration */
#define ADC_CR_ADCAL_Pos                  (31U)
#define ADC_CR_ADCAL_Msk                  (0x1UL << ADC_CR_ADCAL_Pos)          /*!< 0x80000000 */
#define ADC_CR_ADCAL                      ADC_CR_ADCAL_Msk                     /*!< ADC Calibration */

/********************  Bit definition for ADC_CFGR register  ********************/
#define ADC_CFGR_DMNGT_Pos                (0U)
#define ADC_CFGR_DMNGT_Msk                (0x3UL << ADC_CFGR_DMNGT_Pos)        /*!< 0x00000003 */
#define ADC_CFGR_DMNGT                    ADC_CFGR_DMNGT_Msk                   /*!< ADC Data Management configuration */
#define ADC_CFGR_DMNGT_0                  (0x1UL << ADC_CFGR_DMNGT_Pos)         /*!< 0x00000001 */
#define ADC_CFGR_DMNGT_1                  (0x2UL << ADC_CFGR_DMNGT_Pos)         /*!< 0x00000002 */

#define ADC_CFGR_RES_Pos                  (2U)
#define ADC_CFGR_RES_Msk                  (0x7UL << ADC_CFGR_RES_Pos)          /*!< 0x0000001C */
#define ADC_CFGR_RES                      ADC_CFGR_RES_Msk                     /*!< ADC Data resolution */
#define ADC_CFGR_RES_0                    (0x1UL << ADC_CFGR_RES_Pos)           /*!< 0x00000004 */
#define ADC_CFGR_RES_1                    (0x2UL << ADC_CFGR_RES_Pos)           /*!< 0x00000008 */
#define ADC_CFGR_RES_2                    (0x4UL << ADC_CFGR_RES_Pos)           /*!< 0x00000010 */

#define ADC_CFGR_EXTSEL_Pos               (5U)
#define ADC_CFGR_EXTSEL_Msk               (0x1FUL << ADC_CFGR_EXTSEL_Pos)      /*!< 0x000003E0 */
#define ADC_CFGR_EXTSEL                   ADC_CFGR_EXTSEL_Msk                  /*!< ADC External trigger selection for regular group */
#define ADC_CFGR_EXTSEL_0                 (0x01UL << ADC_CFGR_EXTSEL_Pos)       /*!< 0x00000020 */
#define ADC_CFGR_EXTSEL_1                 (0x02UL << ADC_CFGR_EXTSEL_Pos)       /*!< 0x00000040 */
#define ADC_CFGR_EXTSEL_2                 (0x04UL << ADC_CFGR_EXTSEL_Pos)       /*!< 0x00000080 */
#define ADC_CFGR_EXTSEL_3                 (0x08UL << ADC_CFGR_EXTSEL_Pos)       /*!< 0x00000100 */
#define ADC_CFGR_EXTSEL_4                 (0x10UL << ADC_CFGR_EXTSEL_Pos)       /*!< 0x00000200 */

#define ADC_CFGR_EXTEN_Pos                (10U)
#define ADC_CFGR_EXTEN_Msk                (0x3UL << ADC_CFGR_EXTEN_Pos)        /*!< 0x00000C00 */
#define ADC_CFGR_EXTEN                    ADC_CFGR_EXTEN_Msk                   /*!< ADC External trigger enable and polarity selection for regular channels */
#define ADC_CFGR_EXTEN_0                  (0x1UL << ADC_CFGR_EXTEN_Pos)         /*!< 0x00000400 */
#define ADC_CFGR_EXTEN_1                  (0x2UL << ADC_CFGR_EXTEN_Pos)         /*!< 0x00000800 */

#define ADC_CFGR_OVRMOD_Pos               (12U)
#define ADC_CFGR_OVRMOD_Msk               (0x1UL << ADC_CFGR_OVRMOD_Pos)       /*!< 0x00001000 */
#define ADC_CFGR_OVRMOD                   ADC_CFGR_OVRMOD_Msk                  /*!< ADC overrun mode */
#define ADC_CFGR_CONT_Pos                 (13U)
#define ADC_CFGR_CONT_Msk                 (0x1UL << ADC_CFGR_CONT_Pos)         /*!< 0x00002000 */
#define ADC_CFGR_CONT                     ADC_CFGR_CONT_Msk                    /*!< ADC Single/continuous conversion mode for regular conversion */
#define ADC_CFGR_AUTDLY_Pos               (14U)
#define ADC_CFGR_AUTDLY_Msk               (0x1UL << ADC_CFGR_AUTDLY_Pos)       /*!< 0x00004000 */
#define ADC_CFGR_AUTDLY                   ADC_CFGR_AUTDLY_Msk                  /*!< ADC Delayed conversion mode */

#define ADC_CFGR_DISCEN_Pos               (16U)
#define ADC_CFGR_DISCEN_Msk               (0x1UL << ADC_CFGR_DISCEN_Pos)       /*!< 0x00010000 */
#define ADC_CFGR_DISCEN                   ADC_CFGR_DISCEN_Msk                  /*!< ADC Discontinuous mode for regular channels */

#define ADC_CFGR_DISCNUM_Pos              (17U)
#define ADC_CFGR_DISCNUM_Msk              (0x7UL << ADC_CFGR_DISCNUM_Pos)      /*!< 0x000E0000 */
#define ADC_CFGR_DISCNUM                  ADC_CFGR_DISCNUM_Msk                 /*!< ADC Discontinuous mode channel count */
#define ADC_CFGR_DISCNUM_0                (0x1UL << ADC_CFGR_DISCNUM_Pos)       /*!< 0x00020000 */
#define ADC_CFGR_DISCNUM_1                (0x2UL << ADC_CFGR_DISCNUM_Pos)       /*!< 0x00040000 */
#define ADC_CFGR_DISCNUM_2                (0x4UL << ADC_CFGR_DISCNUM_Pos)       /*!< 0x00080000 */

#define ADC_CFGR_JDISCEN_Pos              (20U)
#define ADC_CFGR_JDISCEN_Msk              (0x1UL << ADC_CFGR_JDISCEN_Pos)      /*!< 0x00100000 */
#define ADC_CFGR_JDISCEN                  ADC_CFGR_JDISCEN_Msk                 /*!< ADC Discontinuous mode on injected channels */
#define ADC_CFGR_JQM_Pos                  (21U)
#define ADC_CFGR_JQM_Msk                  (0x1UL << ADC_CFGR_JQM_Pos)          /*!< 0x00200000 */
#define ADC_CFGR_JQM                      ADC_CFGR_JQM_Msk                     /*!< ADC JSQR Queue mode */
#define ADC_CFGR_AWD1SGL_Pos              (22U)
#define ADC_CFGR_AWD1SGL_Msk              (0x1UL << ADC_CFGR_AWD1SGL_Pos)      /*!< 0x00400000 */
#define ADC_CFGR_AWD1SGL                  ADC_CFGR_AWD1SGL_Msk                 /*!< Enable the watchdog 1 on a single channel or on all channels */
#define ADC_CFGR_AWD1EN_Pos               (23U)
#define ADC_CFGR_AWD1EN_Msk               (0x1UL << ADC_CFGR_AWD1EN_Pos)       /*!< 0x00800000 */
#define ADC_CFGR_AWD1EN                   ADC_CFGR_AWD1EN_Msk                  /*!< ADC Analog watchdog 1 enable on regular Channels */
#define ADC_CFGR_JAWD1EN_Pos              (24U)
#define ADC_CFGR_JAWD1EN_Msk              (0x1UL << ADC_CFGR_JAWD1EN_Pos)      /*!< 0x01000000 */
#define ADC_CFGR_JAWD1EN                  ADC_CFGR_JAWD1EN_Msk                 /*!< ADC Analog watchdog 1 enable on injected Channels */
#define ADC_CFGR_JAUTO_Pos                (25U)
#define ADC_CFGR_JAUTO_Msk                (0x1UL << ADC_CFGR_JAUTO_Pos)        /*!< 0x02000000 */
#define ADC_CFGR_JAUTO                    ADC_CFGR_JAUTO_Msk                   /*!< ADC Automatic injected group conversion */

#define ADC_CFGR_AWD1CH_Pos               (26U)
#define ADC_CFGR_AWD1CH_Msk               (0x1FUL << ADC_CFGR_AWD1CH_Pos)      /*!< 0x7C000000 */
#define ADC_CFGR_AWD1CH                   ADC_CFGR_AWD1CH_Msk                  /*!< ADC Analog watchdog 1 Channel selection */
#define ADC_CFGR_AWD1CH_0                 (0x01UL << ADC_CFGR_AWD1CH_Pos)       /*!< 0x04000000 */
#define ADC_CFGR_AWD1CH_1                 (0x02UL << ADC_CFGR_AWD1CH_Pos)       /*!< 0x08000000 */
#define ADC_CFGR_AWD1CH_2                 (0x04UL << ADC_CFGR_AWD1CH_Pos)       /*!< 0x10000000 */
#define ADC_CFGR_AWD1CH_3                 (0x08UL << ADC_CFGR_AWD1CH_Pos)       /*!< 0x20000000 */
#define ADC_CFGR_AWD1CH_4                 (0x10UL << ADC_CFGR_AWD1CH_Pos)       /*!< 0x40000000 */

#define ADC_CFGR_JQDIS_Pos                (31U)
#define ADC_CFGR_JQDIS_Msk                (0x1UL << ADC_CFGR_JQDIS_Pos)        /*!< 0x80000000 */
#define ADC_CFGR_JQDIS                    ADC_CFGR_JQDIS_Msk                   /*!< ADC Injected queue disable */

#define ADC3_CFGR_DMAEN_Pos             (0U)
#define ADC3_CFGR_DMAEN_Msk             (0x1UL << ADC3_CFGR_DMAEN_Pos)           /*!< 0x00000001 */
#define ADC3_CFGR_DMAEN                 ADC3_CFGR_DMAEN_Msk                      /*!< ADC DMA transfer enable */
#define ADC3_CFGR_DMACFG_Pos            (1U)
#define ADC3_CFGR_DMACFG_Msk            (0x1UL << ADC3_CFGR_DMACFG_Pos)          /*!< 0x00000002 */
#define ADC3_CFGR_DMACFG                ADC3_CFGR_DMACFG_Msk                     /*!< ADC DMA transfer configuration */

#define ADC3_CFGR_RES_Pos               (3U)
#define ADC3_CFGR_RES_Msk               (0x3UL << ADC3_CFGR_RES_Pos)             /*!< 0x00000018 */
#define ADC3_CFGR_RES                   ADC3_CFGR_RES_Msk                        /*!< ADC data resolution */
#define ADC3_CFGR_RES_0                 (0x1UL << ADC3_CFGR_RES_Pos)             /*!< 0x00000008 */
#define ADC3_CFGR_RES_1                 (0x2UL << ADC3_CFGR_RES_Pos)             /*!< 0x00000010 */

#define ADC3_CFGR_ALIGN_Pos             (15U)
#define ADC3_CFGR_ALIGN_Msk             (0x1UL << ADC3_CFGR_ALIGN_Pos)           /*!< 0x00008000 */
#define ADC3_CFGR_ALIGN                 ADC3_CFGR_ALIGN_Msk                      /*!< ADC data alignement */
/********************  Bit definition for ADC_CFGR2 register  ********************/
#define ADC_CFGR2_ROVSE_Pos               (0U)
#define ADC_CFGR2_ROVSE_Msk               (0x1UL << ADC_CFGR2_ROVSE_Pos)       /*!< 0x00000001 */
#define ADC_CFGR2_ROVSE                   ADC_CFGR2_ROVSE_Msk                  /*!< ADC Regular group oversampler enable */
#define ADC_CFGR2_JOVSE_Pos               (1U)
#define ADC_CFGR2_JOVSE_Msk               (0x1UL << ADC_CFGR2_JOVSE_Pos)       /*!< 0x00000002 */
#define ADC_CFGR2_JOVSE                   ADC_CFGR2_JOVSE_Msk                  /*!< ADC Injected group oversampler enable */

#define ADC_CFGR2_OVSS_Pos                (5U)
#define ADC_CFGR2_OVSS_Msk                (0xFUL << ADC_CFGR2_OVSS_Pos)        /*!< 0x000001E0 */
#define ADC_CFGR2_OVSS                    ADC_CFGR2_OVSS_Msk                   /*!< ADC Regular Oversampling shift */
#define ADC_CFGR2_OVSS_0                  (0x1UL << ADC_CFGR2_OVSS_Pos)         /*!< 0x00000020 */
#define ADC_CFGR2_OVSS_1                  (0x2UL << ADC_CFGR2_OVSS_Pos)         /*!< 0x00000040 */
#define ADC_CFGR2_OVSS_2                  (0x4UL << ADC_CFGR2_OVSS_Pos)         /*!< 0x00000080 */
#define ADC_CFGR2_OVSS_3                  (0x8UL << ADC_CFGR2_OVSS_Pos)         /*!< 0x00000100 */

#define ADC_CFGR2_TROVS_Pos               (9U)
#define ADC_CFGR2_TROVS_Msk               (0x1UL << ADC_CFGR2_TROVS_Pos)       /*!< 0x00000200 */
#define ADC_CFGR2_TROVS                   ADC_CFGR2_TROVS_Msk                  /*!< ADC Triggered regular Oversampling */
#define ADC_CFGR2_ROVSM_Pos               (10U)
#define ADC_CFGR2_ROVSM_Msk               (0x1UL << ADC_CFGR2_ROVSM_Pos)       /*!< 0x00000400 */
#define ADC_CFGR2_ROVSM                   ADC_CFGR2_ROVSM_Msk                  /*!< ADC Regular oversampling mode */

#define ADC_CFGR2_RSHIFT1_Pos             (11U)
#define ADC_CFGR2_RSHIFT1_Msk             (0x1UL << ADC_CFGR2_RSHIFT1_Pos)     /*!< 0x00000800 */
#define ADC_CFGR2_RSHIFT1                 ADC_CFGR2_RSHIFT1_Msk                /*!< ADC Right-shift data after Offset 1 correction */
#define ADC_CFGR2_RSHIFT2_Pos             (12U)
#define ADC_CFGR2_RSHIFT2_Msk             (0x1UL << ADC_CFGR2_RSHIFT2_Pos)     /*!< 0x00001000 */
#define ADC_CFGR2_RSHIFT2                 ADC_CFGR2_RSHIFT2_Msk                /*!< ADC Right-shift data after Offset 2 correction */
#define ADC_CFGR2_RSHIFT3_Pos             (13U)
#define ADC_CFGR2_RSHIFT3_Msk             (0x1UL << ADC_CFGR2_RSHIFT3_Pos)     /*!< 0x00002000 */
#define ADC_CFGR2_RSHIFT3                 ADC_CFGR2_RSHIFT3_Msk                /*!< ADC Right-shift data after Offset 3 correction */
#define ADC_CFGR2_RSHIFT4_Pos             (14U)
#define ADC_CFGR2_RSHIFT4_Msk             (0x1UL << ADC_CFGR2_RSHIFT4_Pos)     /*!< 0x00004000 */
#define ADC_CFGR2_RSHIFT4                 ADC_CFGR2_RSHIFT4_Msk                /*!< ADC Right-shift data after Offset 4 correction */

#define ADC_CFGR2_OVSR_Pos                (16U)
#define ADC_CFGR2_OVSR_Msk                (0x3FFUL << ADC_CFGR2_OVSR_Pos)      /*!< 0x03FF0000 */
#define ADC_CFGR2_OVSR                    ADC_CFGR2_OVSR_Msk                   /*!< ADC oversampling Ratio */
#define ADC_CFGR2_OVSR_0                  (0x001UL << ADC_CFGR2_OVSR_Pos)       /*!< 0x00010000 */
#define ADC_CFGR2_OVSR_1                  (0x002UL << ADC_CFGR2_OVSR_Pos)       /*!< 0x00020000 */
#define ADC_CFGR2_OVSR_2                  (0x004UL << ADC_CFGR2_OVSR_Pos)       /*!< 0x00040000 */
#define ADC_CFGR2_OVSR_3                  (0x008UL << ADC_CFGR2_OVSR_Pos)       /*!< 0x00080000 */
#define ADC_CFGR2_OVSR_4                  (0x010UL << ADC_CFGR2_OVSR_Pos)       /*!< 0x00100000 */
#define ADC_CFGR2_OVSR_5                  (0x020UL << ADC_CFGR2_OVSR_Pos)       /*!< 0x00200000 */
#define ADC_CFGR2_OVSR_6                  (0x040UL << ADC_CFGR2_OVSR_Pos)       /*!< 0x00400000 */
#define ADC_CFGR2_OVSR_7                  (0x080UL << ADC_CFGR2_OVSR_Pos)       /*!< 0x00800000 */
#define ADC_CFGR2_OVSR_8                  (0x100UL << ADC_CFGR2_OVSR_Pos)       /*!< 0x01000000 */
#define ADC_CFGR2_OVSR_9                  (0x200UL << ADC_CFGR2_OVSR_Pos)       /*!< 0x02000000 */

#define ADC_CFGR2_LSHIFT_Pos              (28U)
#define ADC_CFGR2_LSHIFT_Msk              (0xFUL << ADC_CFGR2_LSHIFT_Pos)      /*!< 0xF0000000 */
#define ADC_CFGR2_LSHIFT                  ADC_CFGR2_LSHIFT_Msk                 /*!< ADC Left shift factor */
#define ADC_CFGR2_LSHIFT_0                (0x1UL << ADC_CFGR2_LSHIFT_Pos)       /*!< 0x10000000 */
#define ADC_CFGR2_LSHIFT_1                (0x2UL << ADC_CFGR2_LSHIFT_Pos)       /*!< 0x20000000 */
#define ADC_CFGR2_LSHIFT_2                (0x4UL << ADC_CFGR2_LSHIFT_Pos)       /*!< 0x40000000 */
#define ADC_CFGR2_LSHIFT_3                (0x8UL << ADC_CFGR2_LSHIFT_Pos)       /*!< 0x80000000 */

#define ADC3_CFGR2_OVSR_Pos             (2U)
#define ADC3_CFGR2_OVSR_Msk             (0x7UL << ADC3_CFGR2_OVSR_Pos)           /*!< 0x0000001C */
#define ADC3_CFGR2_OVSR                 ADC3_CFGR2_OVSR_Msk                      /*!< ADC oversampling ratio */
#define ADC3_CFGR2_OVSR_0               (0x1UL << ADC3_CFGR2_OVSR_Pos)           /*!< 0x00000004 */
#define ADC3_CFGR2_OVSR_1               (0x2UL << ADC3_CFGR2_OVSR_Pos)           /*!< 0x00000008 */
#define ADC3_CFGR2_OVSR_2               (0x4UL << ADC3_CFGR2_OVSR_Pos)           /*!< 0x00000010 */

#define ADC3_CFGR2_SWTRIG_Pos           (25U)
#define ADC3_CFGR2_SWTRIG_Msk           (0x1UL << ADC3_CFGR2_SWTRIG_Pos)         /*!< 0x02000000 */
#define ADC3_CFGR2_SWTRIG               ADC3_CFGR2_SWTRIG_Msk                    /*!< ADC Software Trigger Bit for Sample time control trigger mode */
#define ADC3_CFGR2_BULB_Pos             (26U)
#define ADC3_CFGR2_BULB_Msk             (0x1UL << ADC3_CFGR2_BULB_Pos)           /*!< 0x04000000 */
#define ADC3_CFGR2_BULB                 ADC3_CFGR2_BULB_Msk                      /*!< ADC Bulb sampling mode */
#define ADC3_CFGR2_SMPTRIG_Pos          (27U)
#define ADC3_CFGR2_SMPTRIG_Msk          (0x1UL << ADC3_CFGR2_SMPTRIG_Pos)        /*!< 0x08000000 */
#define ADC3_CFGR2_SMPTRIG              ADC3_CFGR2_SMPTRIG_Msk                   /*!< ADC Sample Time Control Trigger mode */
/********************  Bit definition for ADC_SMPR1 register  ********************/
#define ADC_SMPR1_SMP0_Pos                (0U)
#define ADC_SMPR1_SMP0_Msk                (0x7UL << ADC_SMPR1_SMP0_Pos)        /*!< 0x00000007 */
#define ADC_SMPR1_SMP0                    ADC_SMPR1_SMP0_Msk                   /*!< ADC Channel 0 Sampling time selection  */
#define ADC_SMPR1_SMP0_0                  (0x1UL << ADC_SMPR1_SMP0_Pos)         /*!< 0x00000001 */
#define ADC_SMPR1_SMP0_1                  (0x2UL << ADC_SMPR1_SMP0_Pos)         /*!< 0x00000002 */
#define ADC_SMPR1_SMP0_2                  (0x4UL << ADC_SMPR1_SMP0_Pos)         /*!< 0x00000004 */

#define ADC_SMPR1_SMP1_Pos                (3U)
#define ADC_SMPR1_SMP1_Msk                (0x7UL << ADC_SMPR1_SMP1_Pos)        /*!< 0x00000038 */
#define ADC_SMPR1_SMP1                    ADC_SMPR1_SMP1_Msk                   /*!< ADC Channel 1 Sampling time selection  */
#define ADC_SMPR1_SMP1_0                  (0x1UL << ADC_SMPR1_SMP1_Pos)         /*!< 0x00000008 */
#define ADC_SMPR1_SMP1_1                  (0x2UL << ADC_SMPR1_SMP1_Pos)         /*!< 0x00000010 */
#define ADC_SMPR1_SMP1_2                  (0x4UL << ADC_SMPR1_SMP1_Pos)         /*!< 0x00000020 */

#define ADC_SMPR1_SMP2_Pos                (6U)
#define ADC_SMPR1_SMP2_Msk                (0x7UL << ADC_SMPR1_SMP2_Pos)        /*!< 0x000001C0 */
#define ADC_SMPR1_SMP2                    ADC_SMPR1_SMP2_Msk                   /*!< ADC Channel 2 Sampling time selection  */
#define ADC_SMPR1_SMP2_0                  (0x1UL << ADC_SMPR1_SMP2_Pos)         /*!< 0x00000040 */
#define ADC_SMPR1_SMP2_1                  (0x2UL << ADC_SMPR1_SMP2_Pos)         /*!< 0x00000080 */
#define ADC_SMPR1_SMP2_2                  (0x4UL << ADC_SMPR1_SMP2_Pos)         /*!< 0x00000100 */

#define ADC_SMPR1_SMP3_Pos                (9U)
#define ADC_SMPR1_SMP3_Msk                (0x7UL << ADC_SMPR1_SMP3_Pos)        /*!< 0x00000E00 */
#define ADC_SMPR1_SMP3                    ADC_SMPR1_SMP3_Msk                   /*!< ADC Channel 3 Sampling time selection  */
#define ADC_SMPR1_SMP3_0                  (0x1UL << ADC_SMPR1_SMP3_Pos)         /*!< 0x00000200 */
#define ADC_SMPR1_SMP3_1                  (0x2UL << ADC_SMPR1_SMP3_Pos)         /*!< 0x00000400 */
#define ADC_SMPR1_SMP3_2                  (0x4UL << ADC_SMPR1_SMP3_Pos)         /*!< 0x00000800 */

#define ADC_SMPR1_SMP4_Pos                (12U)
#define ADC_SMPR1_SMP4_Msk                (0x7UL << ADC_SMPR1_SMP4_Pos)        /*!< 0x00007000 */
#define ADC_SMPR1_SMP4                    ADC_SMPR1_SMP4_Msk                   /*!< ADC Channel 4 Sampling time selection  */
#define ADC_SMPR1_SMP4_0                  (0x1UL << ADC_SMPR1_SMP4_Pos)         /*!< 0x00001000 */
#define ADC_SMPR1_SMP4_1                  (0x2UL << ADC_SMPR1_SMP4_Pos)         /*!< 0x00002000 */
#define ADC_SMPR1_SMP4_2                  (0x4UL << ADC_SMPR1_SMP4_Pos)         /*!< 0x00004000 */

#define ADC_SMPR1_SMP5_Pos                (15U)
#define ADC_SMPR1_SMP5_Msk                (0x7UL << ADC_SMPR1_SMP5_Pos)        /*!< 0x00038000 */
#define ADC_SMPR1_SMP5                    ADC_SMPR1_SMP5_Msk                   /*!< ADC Channel 5 Sampling time selection  */
#define ADC_SMPR1_SMP5_0                  (0x1UL << ADC_SMPR1_SMP5_Pos)         /*!< 0x00008000 */
#define ADC_SMPR1_SMP5_1                  (0x2UL << ADC_SMPR1_SMP5_Pos)         /*!< 0x00010000 */
#define ADC_SMPR1_SMP5_2                  (0x4UL << ADC_SMPR1_SMP5_Pos)         /*!< 0x00020000 */

#define ADC_SMPR1_SMP6_Pos                (18U)
#define ADC_SMPR1_SMP6_Msk                (0x7UL << ADC_SMPR1_SMP6_Pos)        /*!< 0x001C0000 */
#define ADC_SMPR1_SMP6                    ADC_SMPR1_SMP6_Msk                   /*!< ADC Channel 6 Sampling time selection  */
#define ADC_SMPR1_SMP6_0                  (0x1UL << ADC_SMPR1_SMP6_Pos)         /*!< 0x00040000 */
#define ADC_SMPR1_SMP6_1                  (0x2UL << ADC_SMPR1_SMP6_Pos)         /*!< 0x00080000 */
#define ADC_SMPR1_SMP6_2                  (0x4UL << ADC_SMPR1_SMP6_Pos)         /*!< 0x00100000 */

#define ADC_SMPR1_SMP7_Pos                (21U)
#define ADC_SMPR1_SMP7_Msk                (0x7UL << ADC_SMPR1_SMP7_Pos)        /*!< 0x00E00000 */
#define ADC_SMPR1_SMP7                    ADC_SMPR1_SMP7_Msk                   /*!< ADC Channel 7 Sampling time selection  */
#define ADC_SMPR1_SMP7_0                  (0x1UL << ADC_SMPR1_SMP7_Pos)         /*!< 0x00200000 */
#define ADC_SMPR1_SMP7_1                  (0x2UL << ADC_SMPR1_SMP7_Pos)         /*!< 0x00400000 */
#define ADC_SMPR1_SMP7_2                  (0x4UL << ADC_SMPR1_SMP7_Pos)         /*!< 0x00800000 */

#define ADC_SMPR1_SMP8_Pos                (24U)
#define ADC_SMPR1_SMP8_Msk                (0x7UL << ADC_SMPR1_SMP8_Pos)        /*!< 0x07000000 */
#define ADC_SMPR1_SMP8                    ADC_SMPR1_SMP8_Msk                   /*!< ADC Channel 8 Sampling time selection  */
#define ADC_SMPR1_SMP8_0                  (0x1UL << ADC_SMPR1_SMP8_Pos)         /*!< 0x01000000 */
#define ADC_SMPR1_SMP8_1                  (0x2UL << ADC_SMPR1_SMP8_Pos)         /*!< 0x02000000 */
#define ADC_SMPR1_SMP8_2                  (0x4UL << ADC_SMPR1_SMP8_Pos)         /*!< 0x04000000 */

#define ADC_SMPR1_SMP9_Pos                (27U)
#define ADC_SMPR1_SMP9_Msk                (0x7UL << ADC_SMPR1_SMP9_Pos)        /*!< 0x38000000 */
#define ADC_SMPR1_SMP9                    ADC_SMPR1_SMP9_Msk                   /*!< ADC Channel 9 Sampling time selection  */
#define ADC_SMPR1_SMP9_0                  (0x1UL << ADC_SMPR1_SMP9_Pos)         /*!< 0x08000000 */
#define ADC_SMPR1_SMP9_1                  (0x2UL << ADC_SMPR1_SMP9_Pos)         /*!< 0x10000000 */
#define ADC_SMPR1_SMP9_2                  (0x4UL << ADC_SMPR1_SMP9_Pos)         /*!< 0x20000000 */

/********************  Bit definition for ADC_SMPR2 register  ********************/
#define ADC_SMPR2_SMP10_Pos               (0U)
#define ADC_SMPR2_SMP10_Msk               (0x7UL << ADC_SMPR2_SMP10_Pos)       /*!< 0x00000007 */
#define ADC_SMPR2_SMP10                   ADC_SMPR2_SMP10_Msk                  /*!< ADC Channel 10 Sampling time selection  */
#define ADC_SMPR2_SMP10_0                 (0x1UL << ADC_SMPR2_SMP10_Pos)        /*!< 0x00000001 */
#define ADC_SMPR2_SMP10_1                 (0x2UL << ADC_SMPR2_SMP10_Pos)        /*!< 0x00000002 */
#define ADC_SMPR2_SMP10_2                 (0x4UL << ADC_SMPR2_SMP10_Pos)        /*!< 0x00000004 */

#define ADC_SMPR2_SMP11_Pos               (3U)
#define ADC_SMPR2_SMP11_Msk               (0x7UL << ADC_SMPR2_SMP11_Pos)       /*!< 0x00000038 */
#define ADC_SMPR2_SMP11                   ADC_SMPR2_SMP11_Msk                  /*!< ADC Channel 11 Sampling time selection  */
#define ADC_SMPR2_SMP11_0                 (0x1UL << ADC_SMPR2_SMP11_Pos)        /*!< 0x00000008 */
#define ADC_SMPR2_SMP11_1                 (0x2UL << ADC_SMPR2_SMP11_Pos)        /*!< 0x00000010 */
#define ADC_SMPR2_SMP11_2                 (0x4UL << ADC_SMPR2_SMP11_Pos)        /*!< 0x00000020 */

#define ADC_SMPR2_SMP12_Pos               (6U)
#define ADC_SMPR2_SMP12_Msk               (0x7UL << ADC_SMPR2_SMP12_Pos)       /*!< 0x000001C0 */
#define ADC_SMPR2_SMP12                   ADC_SMPR2_SMP12_Msk                  /*!< ADC Channel 12 Sampling time selection  */
#define ADC_SMPR2_SMP12_0                 (0x1UL << ADC_SMPR2_SMP12_Pos)        /*!< 0x00000040 */
#define ADC_SMPR2_SMP12_1                 (0x2UL << ADC_SMPR2_SMP12_Pos)        /*!< 0x00000080 */
#define ADC_SMPR2_SMP12_2                 (0x4UL << ADC_SMPR2_SMP12_Pos)        /*!< 0x00000100 */

#define ADC_SMPR2_SMP13_Pos               (9U)
#define ADC_SMPR2_SMP13_Msk               (0x7UL << ADC_SMPR2_SMP13_Pos)       /*!< 0x00000E00 */
#define ADC_SMPR2_SMP13                   ADC_SMPR2_SMP13_Msk                  /*!< ADC Channel 13 Sampling time selection  */
#define ADC_SMPR2_SMP13_0                 (0x1UL << ADC_SMPR2_SMP13_Pos)        /*!< 0x00000200 */
#define ADC_SMPR2_SMP13_1                 (0x2UL << ADC_SMPR2_SMP13_Pos)        /*!< 0x00000400 */
#define ADC_SMPR2_SMP13_2                 (0x4UL << ADC_SMPR2_SMP13_Pos)        /*!< 0x00000800 */

#define ADC_SMPR2_SMP14_Pos               (12U)
#define ADC_SMPR2_SMP14_Msk               (0x7UL << ADC_SMPR2_SMP14_Pos)       /*!< 0x00007000 */
#define ADC_SMPR2_SMP14                   ADC_SMPR2_SMP14_Msk                  /*!< ADC Channel 14 Sampling time selection  */
#define ADC_SMPR2_SMP14_0                 (0x1UL << ADC_SMPR2_SMP14_Pos)        /*!< 0x00001000 */
#define ADC_SMPR2_SMP14_1                 (0x2UL << ADC_SMPR2_SMP14_Pos)        /*!< 0x00002000 */
#define ADC_SMPR2_SMP14_2                 (0x4UL << ADC_SMPR2_SMP14_Pos)        /*!< 0x00004000 */

#define ADC_SMPR2_SMP15_Pos               (15U)
#define ADC_SMPR2_SMP15_Msk               (0x7UL << ADC_SMPR2_SMP15_Pos)       /*!< 0x00038000 */
#define ADC_SMPR2_SMP15                   ADC_SMPR2_SMP15_Msk                  /*!< ADC Channel 15 Sampling time selection  */
#define ADC_SMPR2_SMP15_0                 (0x1UL << ADC_SMPR2_SMP15_Pos)        /*!< 0x00008000 */
#define ADC_SMPR2_SMP15_1                 (0x2UL << ADC_SMPR2_SMP15_Pos)        /*!< 0x00010000 */
#define ADC_SMPR2_SMP15_2                 (0x4UL << ADC_SMPR2_SMP15_Pos)        /*!< 0x00020000 */

#define ADC_SMPR2_SMP16_Pos               (18U)
#define ADC_SMPR2_SMP16_Msk               (0x7UL << ADC_SMPR2_SMP16_Pos)       /*!< 0x001C0000 */
#define ADC_SMPR2_SMP16                   ADC_SMPR2_SMP16_Msk                  /*!< ADC Channel 16 Sampling time selection  */
#define ADC_SMPR2_SMP16_0                 (0x1UL << ADC_SMPR2_SMP16_Pos)        /*!< 0x00040000 */
#define ADC_SMPR2_SMP16_1                 (0x2UL << ADC_SMPR2_SMP16_Pos)        /*!< 0x00080000 */
#define ADC_SMPR2_SMP16_2                 (0x4UL << ADC_SMPR2_SMP16_Pos)        /*!< 0x00100000 */

#define ADC_SMPR2_SMP17_Pos               (21U)
#define ADC_SMPR2_SMP17_Msk               (0x7UL << ADC_SMPR2_SMP17_Pos)       /*!< 0x00E00000 */
#define ADC_SMPR2_SMP17                   ADC_SMPR2_SMP17_Msk                  /*!< ADC Channel 17 Sampling time selection  */
#define ADC_SMPR2_SMP17_0                 (0x1UL << ADC_SMPR2_SMP17_Pos)        /*!< 0x00200000 */
#define ADC_SMPR2_SMP17_1                 (0x2UL << ADC_SMPR2_SMP17_Pos)        /*!< 0x00400000 */
#define ADC_SMPR2_SMP17_2                 (0x4UL << ADC_SMPR2_SMP17_Pos)        /*!< 0x00800000 */

#define ADC_SMPR2_SMP18_Pos               (24U)
#define ADC_SMPR2_SMP18_Msk               (0x7UL << ADC_SMPR2_SMP18_Pos)       /*!< 0x07000000 */
#define ADC_SMPR2_SMP18                   ADC_SMPR2_SMP18_Msk                  /*!< ADC Channel 18 Sampling time selection  */
#define ADC_SMPR2_SMP18_0                 (0x1UL << ADC_SMPR2_SMP18_Pos)        /*!< 0x01000000 */
#define ADC_SMPR2_SMP18_1                 (0x2UL << ADC_SMPR2_SMP18_Pos)        /*!< 0x02000000 */
#define ADC_SMPR2_SMP18_2                 (0x4UL << ADC_SMPR2_SMP18_Pos)        /*!< 0x04000000 */

#define ADC_SMPR2_SMP19_Pos               (27U)
#define ADC_SMPR2_SMP19_Msk               (0x7UL << ADC_SMPR2_SMP19_Pos)       /*!< 0x38000000 */
#define ADC_SMPR2_SMP19                   ADC_SMPR2_SMP19_Msk                  /*!< ADC Channel 19 Sampling time selection  */
#define ADC_SMPR2_SMP19_0                 (0x1UL << ADC_SMPR2_SMP19_Pos)        /*!< 0x08000000 */
#define ADC_SMPR2_SMP19_1                 (0x2UL << ADC_SMPR2_SMP19_Pos)        /*!< 0x10000000 */
#define ADC_SMPR2_SMP19_2                 (0x4UL << ADC_SMPR2_SMP19_Pos)        /*!< 0x20000000 */

/********************  Bit definition for ADC_PCSEL register  ********************/
#define ADC_PCSEL_PCSEL_Pos               (0U)
#define ADC_PCSEL_PCSEL_Msk               (0xFFFFFUL << ADC_PCSEL_PCSEL_Pos)   /*!< 0x000FFFFF */
#define ADC_PCSEL_PCSEL                   ADC_PCSEL_PCSEL_Msk                  /*!< ADC pre channel selection */
#define ADC_PCSEL_PCSEL_0                 (0x00001UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000001 */
#define ADC_PCSEL_PCSEL_1                 (0x00002UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000002 */
#define ADC_PCSEL_PCSEL_2                 (0x00004UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000004 */
#define ADC_PCSEL_PCSEL_3                 (0x00008UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000008 */
#define ADC_PCSEL_PCSEL_4                 (0x00010UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000010 */
#define ADC_PCSEL_PCSEL_5                 (0x00020UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000020 */
#define ADC_PCSEL_PCSEL_6                 (0x00040UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000040 */
#define ADC_PCSEL_PCSEL_7                 (0x00080UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000080 */
#define ADC_PCSEL_PCSEL_8                 (0x00100UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000100 */
#define ADC_PCSEL_PCSEL_9                 (0x00200UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000200 */
#define ADC_PCSEL_PCSEL_10                (0x00400UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000400 */
#define ADC_PCSEL_PCSEL_11                (0x00800UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000800 */
#define ADC_PCSEL_PCSEL_12                (0x01000UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00001000 */
#define ADC_PCSEL_PCSEL_13                (0x02000UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00002000 */
#define ADC_PCSEL_PCSEL_14                (0x04000UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00004000 */
#define ADC_PCSEL_PCSEL_15                (0x08000UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00008000 */
#define ADC_PCSEL_PCSEL_16                (0x10000UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00010000 */
#define ADC_PCSEL_PCSEL_17                (0x20000UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00020000 */
#define ADC_PCSEL_PCSEL_18                (0x40000UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00040000 */
#define ADC_PCSEL_PCSEL_19                (0x80000UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00080000 */

/*****************  Bit definition for ADC_LTR1, 2, 3 registers *****************/
#define ADC_LTR_LT_Pos                    (0U)
#define ADC_LTR_LT_Msk                    (0x3FFFFFFUL << ADC_LTR_LT_Pos)      /*!< 0x03FFFFFF */
#define ADC_LTR_LT                        ADC_LTR_LT_Msk                       /*!< ADC Analog watchdog 1, 2 and 3 lower threshold */

/*****************  Bit definition for ADC_HTR1, 2, 3 registers  ****************/
#define ADC_HTR_HT_Pos                    (0U)
#define ADC_HTR_HT_Msk                    (0x3FFFFFFUL << ADC_HTR_HT_Pos)      /*!< 0x03FFFFFF */
#define ADC_HTR_HT                        ADC_HTR_HT_Msk                       /*!< ADC Analog watchdog 1,2 and 3 higher threshold */

/********************  Bit definition for ADC3_TR1 register  *******************/
#define ADC3_TR1_LT1_Pos                (0U)
#define ADC3_TR1_LT1_Msk                (0xFFFUL << ADC3_TR1_LT1_Pos)            /*!< 0x00000FFF */
#define ADC3_TR1_LT1                    ADC3_TR1_LT1_Msk                         /*!< ADC analog watchdog 1 threshold low */

#define ADC3_TR1_AWDFILT_Pos            (12U)
#define ADC3_TR1_AWDFILT_Msk            (0x7UL << ADC3_TR1_AWDFILT_Pos)          /*!< 0x00007000 */
#define ADC3_TR1_AWDFILT                ADC3_TR1_AWDFILT_Msk                     /*!< ADC analog watchdog filtering parameter  */
#define ADC3_TR1_AWDFILT_0              (0x1UL << ADC3_TR1_AWDFILT_Pos)          /*!< 0x00001000 */
#define ADC3_TR1_AWDFILT_1              (0x2UL << ADC3_TR1_AWDFILT_Pos)          /*!< 0x00002000 */
#define ADC3_TR1_AWDFILT_2              (0x4UL << ADC3_TR1_AWDFILT_Pos)          /*!< 0x00004000 */

#define ADC3_TR1_HT1_Pos                (16U)
#define ADC3_TR1_HT1_Msk                (0xFFFUL << ADC3_TR1_HT1_Pos)            /*!< 0x0FFF0000 */
#define ADC3_TR1_HT1                    ADC3_TR1_HT1_Msk                         /*!< ADC analog watchdog 1 threshold high */

/********************  Bit definition for ADC3_TR2 register  *******************/
#define ADC3_TR2_LT2_Pos                (0U)
#define ADC3_TR2_LT2_Msk                (0xFFUL << ADC3_TR2_LT2_Pos)             /*!< 0x000000FF */
#define ADC3_TR2_LT2                    ADC3_TR2_LT2_Msk                         /*!< ADC analog watchdog 2 threshold low */

#define ADC3_TR2_HT2_Pos                (16U)
#define ADC3_TR2_HT2_Msk                (0xFFUL << ADC3_TR2_HT2_Pos)             /*!< 0x00FF0000 */
#define ADC3_TR2_HT2                    ADC3_TR2_HT2_Msk                         /*!< ADC analog watchdog 2 threshold high */

/********************  Bit definition for ADC3_TR3 register  *******************/
#define ADC3_TR3_LT3_Pos                (0U)
#define ADC3_TR3_LT3_Msk                (0xFFUL << ADC3_TR3_LT3_Pos)             /*!< 0x000000FF */
#define ADC3_TR3_LT3                    ADC3_TR3_LT3_Msk                         /*!< ADC analog watchdog 3 threshold low */

#define ADC3_TR3_HT3_Pos                (16U)
#define ADC3_TR3_HT3_Msk                (0xFFUL << ADC3_TR3_HT3_Pos)             /*!< 0x00FF0000 */
#define ADC3_TR3_HT3                    ADC3_TR3_HT3_Msk                         /*!< ADC analog watchdog 3 threshold high */

/********************  Bit definition for ADC_SQR1 register  ********************/
#define ADC_SQR1_L_Pos                    (0U)
#define ADC_SQR1_L_Msk                    (0xFUL << ADC_SQR1_L_Pos)            /*!< 0x0000000F */
#define ADC_SQR1_L                        ADC_SQR1_L_Msk                       /*!< ADC regular channel sequence lenght */
#define ADC_SQR1_L_0                      (0x1UL << ADC_SQR1_L_Pos)             /*!< 0x00000001 */
#define ADC_SQR1_L_1                      (0x2UL << ADC_SQR1_L_Pos)             /*!< 0x00000002 */
#define ADC_SQR1_L_2                      (0x4UL << ADC_SQR1_L_Pos)             /*!< 0x00000004 */
#define ADC_SQR1_L_3                      (0x8UL << ADC_SQR1_L_Pos)             /*!< 0x00000008 */

#define ADC_SQR1_SQ1_Pos                  (6U)
#define ADC_SQR1_SQ1_Msk                  (0x1FUL << ADC_SQR1_SQ1_Pos)         /*!< 0x000007C0 */
#define ADC_SQR1_SQ1                      ADC_SQR1_SQ1_Msk                     /*!< ADC 1st conversion in regular sequence */
#define ADC_SQR1_SQ1_0                    (0x01UL << ADC_SQR1_SQ1_Pos)          /*!< 0x00000040 */
#define ADC_SQR1_SQ1_1                    (0x02UL << ADC_SQR1_SQ1_Pos)          /*!< 0x00000080 */
#define ADC_SQR1_SQ1_2                    (0x04UL << ADC_SQR1_SQ1_Pos)          /*!< 0x00000100 */
#define ADC_SQR1_SQ1_3                    (0x08UL << ADC_SQR1_SQ1_Pos)          /*!< 0x00000200 */
#define ADC_SQR1_SQ1_4                    (0x10UL << ADC_SQR1_SQ1_Pos)          /*!< 0x00000400 */

#define ADC_SQR1_SQ2_Pos                  (12U)
#define ADC_SQR1_SQ2_Msk                  (0x1FUL << ADC_SQR1_SQ2_Pos)         /*!< 0x0001F000 */
#define ADC_SQR1_SQ2                      ADC_SQR1_SQ2_Msk                     /*!< ADC 2nd conversion in regular sequence */
#define ADC_SQR1_SQ2_0                    (0x01UL << ADC_SQR1_SQ2_Pos)          /*!< 0x00001000 */
#define ADC_SQR1_SQ2_1                    (0x02UL << ADC_SQR1_SQ2_Pos)          /*!< 0x00002000 */
#define ADC_SQR1_SQ2_2                    (0x04UL << ADC_SQR1_SQ2_Pos)          /*!< 0x00004000 */
#define ADC_SQR1_SQ2_3                    (0x08UL << ADC_SQR1_SQ2_Pos)          /*!< 0x00008000 */
#define ADC_SQR1_SQ2_4                    (0x10UL << ADC_SQR1_SQ2_Pos)          /*!< 0x00010000 */

#define ADC_SQR1_SQ3_Pos                  (18U)
#define ADC_SQR1_SQ3_Msk                  (0x1FUL << ADC_SQR1_SQ3_Pos)         /*!< 0x007C0000 */
#define ADC_SQR1_SQ3                      ADC_SQR1_SQ3_Msk                     /*!< ADC 3rd conversion in regular sequence */
#define ADC_SQR1_SQ3_0                    (0x01UL << ADC_SQR1_SQ3_Pos)          /*!< 0x00040000 */
#define ADC_SQR1_SQ3_1                    (0x02UL << ADC_SQR1_SQ3_Pos)          /*!< 0x00080000 */
#define ADC_SQR1_SQ3_2                    (0x04UL << ADC_SQR1_SQ3_Pos)          /*!< 0x00100000 */
#define ADC_SQR1_SQ3_3                    (0x08UL << ADC_SQR1_SQ3_Pos)          /*!< 0x00200000 */
#define ADC_SQR1_SQ3_4                    (0x10UL << ADC_SQR1_SQ3_Pos)          /*!< 0x00400000 */

#define ADC_SQR1_SQ4_Pos                  (24U)
#define ADC_SQR1_SQ4_Msk                  (0x1FUL << ADC_SQR1_SQ4_Pos)         /*!< 0x1F000000 */
#define ADC_SQR1_SQ4                      ADC_SQR1_SQ4_Msk                     /*!< ADC 4th conversion in regular sequence */
#define ADC_SQR1_SQ4_0                    (0x01UL << ADC_SQR1_SQ4_Pos)          /*!< 0x01000000 */
#define ADC_SQR1_SQ4_1                    (0x02UL << ADC_SQR1_SQ4_Pos)          /*!< 0x02000000 */
#define ADC_SQR1_SQ4_2                    (0x04UL << ADC_SQR1_SQ4_Pos)          /*!< 0x04000000 */
#define ADC_SQR1_SQ4_3                    (0x08UL << ADC_SQR1_SQ4_Pos)          /*!< 0x08000000 */
#define ADC_SQR1_SQ4_4                    (0x10UL << ADC_SQR1_SQ4_Pos)          /*!< 0x10000000 */

/********************  Bit definition for ADC_SQR2 register  ********************/
#define ADC_SQR2_SQ5_Pos                  (0U)
#define ADC_SQR2_SQ5_Msk                  (0x1FUL << ADC_SQR2_SQ5_Pos)         /*!< 0x0000001F */
#define ADC_SQR2_SQ5                      ADC_SQR2_SQ5_Msk                     /*!< ADC 5th conversion in regular sequence */
#define ADC_SQR2_SQ5_0                    (0x01UL << ADC_SQR2_SQ5_Pos)          /*!< 0x00000001 */
#define ADC_SQR2_SQ5_1                    (0x02UL << ADC_SQR2_SQ5_Pos)          /*!< 0x00000002 */
#define ADC_SQR2_SQ5_2                    (0x04UL << ADC_SQR2_SQ5_Pos)          /*!< 0x00000004 */
#define ADC_SQR2_SQ5_3                    (0x08UL << ADC_SQR2_SQ5_Pos)          /*!< 0x00000008 */
#define ADC_SQR2_SQ5_4                    (0x10UL << ADC_SQR2_SQ5_Pos)          /*!< 0x00000010 */

#define ADC_SQR2_SQ6_Pos                  (6U)
#define ADC_SQR2_SQ6_Msk                  (0x1FUL << ADC_SQR2_SQ6_Pos)         /*!< 0x000007C0 */
#define ADC_SQR2_SQ6                      ADC_SQR2_SQ6_Msk                     /*!< ADC 6th conversion in regular sequence */
#define ADC_SQR2_SQ6_0                    (0x01UL << ADC_SQR2_SQ6_Pos)          /*!< 0x00000040 */
#define ADC_SQR2_SQ6_1                    (0x02UL << ADC_SQR2_SQ6_Pos)          /*!< 0x00000080 */
#define ADC_SQR2_SQ6_2                    (0x04UL << ADC_SQR2_SQ6_Pos)          /*!< 0x00000100 */
#define ADC_SQR2_SQ6_3                    (0x08UL << ADC_SQR2_SQ6_Pos)          /*!< 0x00000200 */
#define ADC_SQR2_SQ6_4                    (0x10UL << ADC_SQR2_SQ6_Pos)          /*!< 0x00000400 */

#define ADC_SQR2_SQ7_Pos                  (12U)
#define ADC_SQR2_SQ7_Msk                  (0x1FUL << ADC_SQR2_SQ7_Pos)         /*!< 0x0001F000 */
#define ADC_SQR2_SQ7                      ADC_SQR2_SQ7_Msk                     /*!< ADC 7th conversion in regular sequence */
#define ADC_SQR2_SQ7_0                    (0x01UL << ADC_SQR2_SQ7_Pos)          /*!< 0x00001000 */
#define ADC_SQR2_SQ7_1                    (0x02UL << ADC_SQR2_SQ7_Pos)          /*!< 0x00002000 */
#define ADC_SQR2_SQ7_2                    (0x04UL << ADC_SQR2_SQ7_Pos)          /*!< 0x00004000 */
#define ADC_SQR2_SQ7_3                    (0x08UL << ADC_SQR2_SQ7_Pos)          /*!< 0x00008000 */
#define ADC_SQR2_SQ7_4                    (0x10UL << ADC_SQR2_SQ7_Pos)          /*!< 0x00010000 */

#define ADC_SQR2_SQ8_Pos                  (18U)
#define ADC_SQR2_SQ8_Msk                  (0x1FUL << ADC_SQR2_SQ8_Pos)         /*!< 0x007C0000 */
#define ADC_SQR2_SQ8                      ADC_SQR2_SQ8_Msk                     /*!< ADC 8th conversion in regular sequence */
#define ADC_SQR2_SQ8_0                    (0x01UL << ADC_SQR2_SQ8_Pos)          /*!< 0x00040000 */
#define ADC_SQR2_SQ8_1                    (0x02UL << ADC_SQR2_SQ8_Pos)          /*!< 0x00080000 */
#define ADC_SQR2_SQ8_2                    (0x04UL << ADC_SQR2_SQ8_Pos)          /*!< 0x00100000 */
#define ADC_SQR2_SQ8_3                    (0x08UL << ADC_SQR2_SQ8_Pos)          /*!< 0x00200000 */
#define ADC_SQR2_SQ8_4                    (0x10UL << ADC_SQR2_SQ8_Pos)          /*!< 0x00400000 */

#define ADC_SQR2_SQ9_Pos                  (24U)
#define ADC_SQR2_SQ9_Msk                  (0x1FUL << ADC_SQR2_SQ9_Pos)         /*!< 0x1F000000 */
#define ADC_SQR2_SQ9                      ADC_SQR2_SQ9_Msk                     /*!< ADC 9th conversion in regular sequence */
#define ADC_SQR2_SQ9_0                    (0x01UL << ADC_SQR2_SQ9_Pos)          /*!< 0x01000000 */
#define ADC_SQR2_SQ9_1                    (0x02UL << ADC_SQR2_SQ9_Pos)          /*!< 0x02000000 */
#define ADC_SQR2_SQ9_2                    (0x04UL << ADC_SQR2_SQ9_Pos)          /*!< 0x04000000 */
#define ADC_SQR2_SQ9_3                    (0x08UL << ADC_SQR2_SQ9_Pos)          /*!< 0x08000000 */
#define ADC_SQR2_SQ9_4                    (0x10UL << ADC_SQR2_SQ9_Pos)          /*!< 0x10000000 */

/********************  Bit definition for ADC_SQR3 register  ********************/
#define ADC_SQR3_SQ10_Pos                 (0U)
#define ADC_SQR3_SQ10_Msk                 (0x1FUL << ADC_SQR3_SQ10_Pos)        /*!< 0x0000001F */
#define ADC_SQR3_SQ10                     ADC_SQR3_SQ10_Msk                    /*!< ADC 10th conversion in regular sequence */
#define ADC_SQR3_SQ10_0                   (0x01UL << ADC_SQR3_SQ10_Pos)         /*!< 0x00000001 */
#define ADC_SQR3_SQ10_1                   (0x02UL << ADC_SQR3_SQ10_Pos)         /*!< 0x00000002 */
#define ADC_SQR3_SQ10_2                   (0x04UL << ADC_SQR3_SQ10_Pos)         /*!< 0x00000004 */
#define ADC_SQR3_SQ10_3                   (0x08UL << ADC_SQR3_SQ10_Pos)         /*!< 0x00000008 */
#define ADC_SQR3_SQ10_4                   (0x10UL << ADC_SQR3_SQ10_Pos)         /*!< 0x00000010 */

#define ADC_SQR3_SQ11_Pos                 (6U)
#define ADC_SQR3_SQ11_Msk                 (0x1FUL << ADC_SQR3_SQ11_Pos)        /*!< 0x000007C0 */
#define ADC_SQR3_SQ11                     ADC_SQR3_SQ11_Msk                    /*!< ADC 11th conversion in regular sequence */
#define ADC_SQR3_SQ11_0                   (0x01UL << ADC_SQR3_SQ11_Pos)         /*!< 0x00000040 */
#define ADC_SQR3_SQ11_1                   (0x02UL << ADC_SQR3_SQ11_Pos)         /*!< 0x00000080 */
#define ADC_SQR3_SQ11_2                   (0x04UL << ADC_SQR3_SQ11_Pos)         /*!< 0x00000100 */
#define ADC_SQR3_SQ11_3                   (0x08UL << ADC_SQR3_SQ11_Pos)         /*!< 0x00000200 */
#define ADC_SQR3_SQ11_4                   (0x10UL << ADC_SQR3_SQ11_Pos)         /*!< 0x00000400 */

#define ADC_SQR3_SQ12_Pos                 (12U)
#define ADC_SQR3_SQ12_Msk                 (0x1FUL << ADC_SQR3_SQ12_Pos)        /*!< 0x0001F000 */
#define ADC_SQR3_SQ12                     ADC_SQR3_SQ12_Msk                    /*!< ADC 12th conversion in regular sequence */
#define ADC_SQR3_SQ12_0                   (0x01UL << ADC_SQR3_SQ12_Pos)         /*!< 0x00001000 */
#define ADC_SQR3_SQ12_1                   (0x02UL << ADC_SQR3_SQ12_Pos)         /*!< 0x00002000 */
#define ADC_SQR3_SQ12_2                   (0x04UL << ADC_SQR3_SQ12_Pos)         /*!< 0x00004000 */
#define ADC_SQR3_SQ12_3                   (0x08UL << ADC_SQR3_SQ12_Pos)         /*!< 0x00008000 */
#define ADC_SQR3_SQ12_4                   (0x10UL << ADC_SQR3_SQ12_Pos)         /*!< 0x00010000 */

#define ADC_SQR3_SQ13_Pos                 (18U)
#define ADC_SQR3_SQ13_Msk                 (0x1FUL << ADC_SQR3_SQ13_Pos)        /*!< 0x007C0000 */
#define ADC_SQR3_SQ13                     ADC_SQR3_SQ13_Msk                    /*!< ADC 13th conversion in regular sequence */
#define ADC_SQR3_SQ13_0                   (0x01UL << ADC_SQR3_SQ13_Pos)         /*!< 0x00040000 */
#define ADC_SQR3_SQ13_1                   (0x02UL << ADC_SQR3_SQ13_Pos)         /*!< 0x00080000 */
#define ADC_SQR3_SQ13_2                   (0x04UL << ADC_SQR3_SQ13_Pos)         /*!< 0x00100000 */
#define ADC_SQR3_SQ13_3                   (0x08UL << ADC_SQR3_SQ13_Pos)         /*!< 0x00200000 */
#define ADC_SQR3_SQ13_4                   (0x10UL << ADC_SQR3_SQ13_Pos)         /*!< 0x00400000 */

#define ADC_SQR3_SQ14_Pos                 (24U)
#define ADC_SQR3_SQ14_Msk                 (0x1FUL << ADC_SQR3_SQ14_Pos)        /*!< 0x1F000000 */
#define ADC_SQR3_SQ14                     ADC_SQR3_SQ14_Msk                    /*!< ADC 14th conversion in regular sequence */
#define ADC_SQR3_SQ14_0                   (0x01UL << ADC_SQR3_SQ14_Pos)         /*!< 0x01000000 */
#define ADC_SQR3_SQ14_1                   (0x02UL << ADC_SQR3_SQ14_Pos)         /*!< 0x02000000 */
#define ADC_SQR3_SQ14_2                   (0x04UL << ADC_SQR3_SQ14_Pos)         /*!< 0x04000000 */
#define ADC_SQR3_SQ14_3                   (0x08UL << ADC_SQR3_SQ14_Pos)         /*!< 0x08000000 */
#define ADC_SQR3_SQ14_4                   (0x10UL << ADC_SQR3_SQ14_Pos)         /*!< 0x10000000 */

/********************  Bit definition for ADC_SQR4 register  ********************/
#define ADC_SQR4_SQ15_Pos                 (0U)
#define ADC_SQR4_SQ15_Msk                 (0x1FUL << ADC_SQR4_SQ15_Pos)        /*!< 0x0000001F */
#define ADC_SQR4_SQ15                     ADC_SQR4_SQ15_Msk                    /*!< ADC 15th conversion in regular sequence */
#define ADC_SQR4_SQ15_0                   (0x01UL << ADC_SQR4_SQ15_Pos)         /*!< 0x00000001 */
#define ADC_SQR4_SQ15_1                   (0x02UL << ADC_SQR4_SQ15_Pos)         /*!< 0x00000002 */
#define ADC_SQR4_SQ15_2                   (0x04UL << ADC_SQR4_SQ15_Pos)         /*!< 0x00000004 */
#define ADC_SQR4_SQ15_3                   (0x08UL << ADC_SQR4_SQ15_Pos)         /*!< 0x00000008 */
#define ADC_SQR4_SQ15_4                   (0x10UL << ADC_SQR4_SQ15_Pos)         /*!< 0x00000010 */

#define ADC_SQR4_SQ16_Pos                 (6U)
#define ADC_SQR4_SQ16_Msk                 (0x1FUL << ADC_SQR4_SQ16_Pos)        /*!< 0x000007C0 */
#define ADC_SQR4_SQ16                     ADC_SQR4_SQ16_Msk                    /*!< ADC 16th conversion in regular sequence */
#define ADC_SQR4_SQ16_0                   (0x01UL << ADC_SQR4_SQ16_Pos)         /*!< 0x00000040 */
#define ADC_SQR4_SQ16_1                   (0x02UL << ADC_SQR4_SQ16_Pos)         /*!< 0x00000080 */
#define ADC_SQR4_SQ16_2                   (0x04UL << ADC_SQR4_SQ16_Pos)         /*!< 0x00000100 */
#define ADC_SQR4_SQ16_3                   (0x08UL << ADC_SQR4_SQ16_Pos)         /*!< 0x00000200 */
#define ADC_SQR4_SQ16_4                   (0x10UL << ADC_SQR4_SQ16_Pos)         /*!< 0x00000400 */
/********************  Bit definition for ADC_DR register  ********************/
#define ADC_DR_RDATA_Pos                  (0U)
#define ADC_DR_RDATA_Msk                  (0xFFFFFFFFUL << ADC_DR_RDATA_Pos)   /*!< 0xFFFFFFFF */
#define ADC_DR_RDATA                      ADC_DR_RDATA_Msk                     /*!< ADC regular Data converted */

/********************  Bit definition for ADC_JSQR register  ********************/
#define ADC_JSQR_JL_Pos                   (0U)
#define ADC_JSQR_JL_Msk                   (0x3UL << ADC_JSQR_JL_Pos)           /*!< 0x00000003 */
#define ADC_JSQR_JL                       ADC_JSQR_JL_Msk                      /*!< ADC injected channel sequence length */
#define ADC_JSQR_JL_0                     (0x1UL << ADC_JSQR_JL_Pos)           /*!< 0x00000001 */
#define ADC_JSQR_JL_1                     (0x2UL << ADC_JSQR_JL_Pos)           /*!< 0x00000002 */

#define ADC_JSQR_JEXTSEL_Pos              (2U)
#define ADC_JSQR_JEXTSEL_Msk              (0x1FUL << ADC_JSQR_JEXTSEL_Pos)     /*!< 0x0000007C */
#define ADC_JSQR_JEXTSEL                  ADC_JSQR_JEXTSEL_Msk                 /*!< ADC external trigger selection for injected group */
#define ADC_JSQR_JEXTSEL_0                (0x01UL << ADC_JSQR_JEXTSEL_Pos)     /*!< 0x00000004 */
#define ADC_JSQR_JEXTSEL_1                (0x02UL << ADC_JSQR_JEXTSEL_Pos)     /*!< 0x00000008 */
#define ADC_JSQR_JEXTSEL_2                (0x04UL << ADC_JSQR_JEXTSEL_Pos)     /*!< 0x00000010 */
#define ADC_JSQR_JEXTSEL_3                (0x08UL << ADC_JSQR_JEXTSEL_Pos)     /*!< 0x00000020 */
#define ADC_JSQR_JEXTSEL_4                (0x10UL << ADC_JSQR_JEXTSEL_Pos)     /*!< 0x00000040 */

#define ADC_JSQR_JEXTEN_Pos               (7U)
#define ADC_JSQR_JEXTEN_Msk               (0x3UL << ADC_JSQR_JEXTEN_Pos)       /*!< 0x00000180 */
#define ADC_JSQR_JEXTEN                   ADC_JSQR_JEXTEN_Msk                  /*!< ADC external trigger enable and polarity selection for injected channels */
#define ADC_JSQR_JEXTEN_0                 (0x1UL << ADC_JSQR_JEXTEN_Pos)       /*!< 0x00000080 */
#define ADC_JSQR_JEXTEN_1                 (0x2UL << ADC_JSQR_JEXTEN_Pos)       /*!< 0x00000100 */

#define ADC_JSQR_JSQ1_Pos                 (9U)
#define ADC_JSQR_JSQ1_Msk                 (0x1FUL << ADC_JSQR_JSQ1_Pos)        /*!< 0x00003E00 */
#define ADC_JSQR_JSQ1                     ADC_JSQR_JSQ1_Msk                    /*!< ADC 1st conversion in injected sequence */
#define ADC_JSQR_JSQ1_0                   (0x01UL << ADC_JSQR_JSQ1_Pos)        /*!< 0x00000200 */
#define ADC_JSQR_JSQ1_1                   (0x02UL << ADC_JSQR_JSQ1_Pos)        /*!< 0x00000400 */
#define ADC_JSQR_JSQ1_2                   (0x04UL << ADC_JSQR_JSQ1_Pos)        /*!< 0x00000800 */
#define ADC_JSQR_JSQ1_3                   (0x08UL << ADC_JSQR_JSQ1_Pos)        /*!< 0x00001000 */
#define ADC_JSQR_JSQ1_4                   (0x10UL << ADC_JSQR_JSQ1_Pos)        /*!< 0x00002000 */

#define ADC_JSQR_JSQ2_Pos                 (15U)
#define ADC_JSQR_JSQ2_Msk                 (0x1FUL << ADC_JSQR_JSQ2_Pos)        /*!< 0x000F8000 */
#define ADC_JSQR_JSQ2                     ADC_JSQR_JSQ2_Msk                    /*!< ADC 2nd conversion in injected sequence */
#define ADC_JSQR_JSQ2_0                   (0x01UL << ADC_JSQR_JSQ2_Pos)        /*!< 0x00008000 */
#define ADC_JSQR_JSQ2_1                   (0x02UL << ADC_JSQR_JSQ2_Pos)        /*!< 0x00010000 */
#define ADC_JSQR_JSQ2_2                   (0x04UL << ADC_JSQR_JSQ2_Pos)        /*!< 0x00020000 */
#define ADC_JSQR_JSQ2_3                   (0x08UL << ADC_JSQR_JSQ2_Pos)        /*!< 0x00040000 */
#define ADC_JSQR_JSQ2_4                   (0x10UL << ADC_JSQR_JSQ2_Pos)        /*!< 0x00080000 */

#define ADC_JSQR_JSQ3_Pos                 (21U)
#define ADC_JSQR_JSQ3_Msk                 (0x1FUL << ADC_JSQR_JSQ3_Pos)        /*!< 0x03E00000 */
#define ADC_JSQR_JSQ3                     ADC_JSQR_JSQ3_Msk                    /*!< ADC 3rd conversion in injected sequence */
#define ADC_JSQR_JSQ3_0                   (0x01UL << ADC_JSQR_JSQ3_Pos)        /*!< 0x00200000 */
#define ADC_JSQR_JSQ3_1                   (0x02UL << ADC_JSQR_JSQ3_Pos)        /*!< 0x00400000 */
#define ADC_JSQR_JSQ3_2                   (0x04UL << ADC_JSQR_JSQ3_Pos)        /*!< 0x00800000 */
#define ADC_JSQR_JSQ3_3                   (0x08UL << ADC_JSQR_JSQ3_Pos)        /*!< 0x01000000 */
#define ADC_JSQR_JSQ3_4                   (0x10UL << ADC_JSQR_JSQ3_Pos)        /*!< 0x02000000 */

#define ADC_JSQR_JSQ4_Pos                 (27U)
#define ADC_JSQR_JSQ4_Msk                 (0x1FUL << ADC_JSQR_JSQ4_Pos)        /*!< 0xF8000000 */
#define ADC_JSQR_JSQ4                     ADC_JSQR_JSQ4_Msk                    /*!< ADC 4th conversion in injected sequence */
#define ADC_JSQR_JSQ4_0                   (0x01UL << ADC_JSQR_JSQ4_Pos)        /*!< 0x08000000 */
#define ADC_JSQR_JSQ4_1                   (0x02UL << ADC_JSQR_JSQ4_Pos)        /*!< 0x10000000 */
#define ADC_JSQR_JSQ4_2                   (0x04UL << ADC_JSQR_JSQ4_Pos)        /*!< 0x20000000 */
#define ADC_JSQR_JSQ4_3                   (0x08UL << ADC_JSQR_JSQ4_Pos)        /*!< 0x40000000 */
#define ADC_JSQR_JSQ4_4                   (0x10UL << ADC_JSQR_JSQ4_Pos)        /*!< 0x80000000 */

/********************  Bit definition for ADC_OFR1 register  ********************/
#define ADC_OFR1_OFFSET1_Pos              (0U)
#define ADC_OFR1_OFFSET1_Msk              (0x3FFFFFFUL << ADC_OFR1_OFFSET1_Pos) /*!< 0x03FFFFFF */
#define ADC_OFR1_OFFSET1                  ADC_OFR1_OFFSET1_Msk                  /*!< ADC data offset 1 for channel programmed into bits OFFSET1_CH[4:0] */
#define ADC_OFR1_OFFSET1_0                (0x0000001UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000001 */
#define ADC_OFR1_OFFSET1_1                (0x0000002UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000002 */
#define ADC_OFR1_OFFSET1_2                (0x0000004UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000004 */
#define ADC_OFR1_OFFSET1_3                (0x0000008UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000008 */
#define ADC_OFR1_OFFSET1_4                (0x0000010UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000010 */
#define ADC_OFR1_OFFSET1_5                (0x0000020UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000020 */
#define ADC_OFR1_OFFSET1_6                (0x0000040UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000040 */
#define ADC_OFR1_OFFSET1_7                (0x0000080UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000080 */
#define ADC_OFR1_OFFSET1_8                (0x0000100UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000100 */
#define ADC_OFR1_OFFSET1_9                (0x0000200UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000200 */
#define ADC_OFR1_OFFSET1_10               (0x0000400UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000400 */
#define ADC_OFR1_OFFSET1_11               (0x0000800UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000800 */
#define ADC_OFR1_OFFSET1_12               (0x0001000UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00001000 */
#define ADC_OFR1_OFFSET1_13               (0x0002000UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00002000 */
#define ADC_OFR1_OFFSET1_14               (0x0004000UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00004000 */
#define ADC_OFR1_OFFSET1_15               (0x0008000UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00008000 */
#define ADC_OFR1_OFFSET1_16               (0x0010000UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00010000 */
#define ADC_OFR1_OFFSET1_17               (0x0020000UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00020000 */
#define ADC_OFR1_OFFSET1_18               (0x0040000UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00040000 */
#define ADC_OFR1_OFFSET1_19               (0x0080000UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00080000 */
#define ADC_OFR1_OFFSET1_20               (0x0100000UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00100000 */
#define ADC_OFR1_OFFSET1_21               (0x0200000UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00200000 */
#define ADC_OFR1_OFFSET1_22               (0x0400000UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00400000 */
#define ADC_OFR1_OFFSET1_23               (0x0800000UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00800000 */
#define ADC_OFR1_OFFSET1_24               (0x1000000UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x01000000 */
#define ADC_OFR1_OFFSET1_25               (0x2000000UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x02000000 */

#define ADC_OFR1_OFFSET1_CH_Pos           (26U)
#define ADC_OFR1_OFFSET1_CH_Msk           (0x1FUL << ADC_OFR1_OFFSET1_CH_Pos)   /*!< 0x7C000000 */
#define ADC_OFR1_OFFSET1_CH               ADC_OFR1_OFFSET1_CH_Msk               /*!< ADC Channel selection for the data offset 1 */
#define ADC_OFR1_OFFSET1_CH_0             (0x01UL << ADC_OFR1_OFFSET1_CH_Pos)   /*!< 0x04000000 */
#define ADC_OFR1_OFFSET1_CH_1             (0x02UL << ADC_OFR1_OFFSET1_CH_Pos)   /*!< 0x08000000 */
#define ADC_OFR1_OFFSET1_CH_2             (0x04UL << ADC_OFR1_OFFSET1_CH_Pos)   /*!< 0x10000000 */
#define ADC_OFR1_OFFSET1_CH_3             (0x08UL << ADC_OFR1_OFFSET1_CH_Pos)   /*!< 0x20000000 */
#define ADC_OFR1_OFFSET1_CH_4             (0x10UL << ADC_OFR1_OFFSET1_CH_Pos)   /*!< 0x40000000 */

#define ADC_OFR1_SSATE_Pos                (31U)
#define ADC_OFR1_SSATE_Msk                (0x1UL << ADC_OFR1_SSATE_Pos)         /*!< 0x80000000 */
#define ADC_OFR1_SSATE                    ADC_OFR1_SSATE_Msk                    /*!< ADC Signed saturation Enable */

#define ADC3_OFR1_OFFSET1_Pos              (0U)
#define ADC3_OFR1_OFFSET1_Msk              (0xFFFUL << ADC3_OFR1_OFFSET1_Pos)   /*!< 0x00000FFF */
#define ADC3_OFR1_OFFSET1                  ADC3_OFR1_OFFSET1_Msk                /*!< ADC data offset 1 for channel programmed into bits OFFSET1_CH[4:0] */

#define ADC3_OFR1_OFFSETPOS_Pos         (24U)
#define ADC3_OFR1_OFFSETPOS_Msk         (0x1UL << ADC3_OFR1_OFFSETPOS_Pos)      /*!< 0x01000000 */
#define ADC3_OFR1_OFFSETPOS             ADC3_OFR1_OFFSETPOS_Msk                 /*!< ADC offset number 1 positive */
#define ADC3_OFR1_SATEN_Pos             (25U)
#define ADC3_OFR1_SATEN_Msk             (0x1UL << ADC3_OFR1_SATEN_Pos)          /*!< 0x02000000 */
#define ADC3_OFR1_SATEN                 ADC3_OFR1_SATEN_Msk                     /*!< ADC offset number 1 saturation enable */

#define ADC3_OFR1_OFFSET1_EN_Pos        (31U)
#define ADC3_OFR1_OFFSET1_EN_Msk        (0x1UL << ADC3_OFR1_OFFSET1_EN_Pos)     /*!< 0x80000000 */
#define ADC3_OFR1_OFFSET1_EN            ADC3_OFR1_OFFSET1_EN_Msk                /*!< ADC offset number 1 enable */

/********************  Bit definition for ADC_OFR2 register  ********************/
#define ADC_OFR2_OFFSET2_Pos              (0U)
#define ADC_OFR2_OFFSET2_Msk              (0x3FFFFFFUL << ADC_OFR2_OFFSET2_Pos) /*!< 0x03FFFFFF */
#define ADC_OFR2_OFFSET2                  ADC_OFR2_OFFSET2_Msk                  /*!< ADC data offset 2 for channel programmed into bits OFFSET2_CH[4:0] */
#define ADC_OFR2_OFFSET2_0                (0x0000001UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000001 */
#define ADC_OFR2_OFFSET2_1                (0x0000002UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000002 */
#define ADC_OFR2_OFFSET2_2                (0x0000004UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000004 */
#define ADC_OFR2_OFFSET2_3                (0x0000008UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000008 */
#define ADC_OFR2_OFFSET2_4                (0x0000010UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000010 */
#define ADC_OFR2_OFFSET2_5                (0x0000020UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000020 */
#define ADC_OFR2_OFFSET2_6                (0x0000040UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000040 */
#define ADC_OFR2_OFFSET2_7                (0x0000080UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000080 */
#define ADC_OFR2_OFFSET2_8                (0x0000100UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000100 */
#define ADC_OFR2_OFFSET2_9                (0x0000200UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000200 */
#define ADC_OFR2_OFFSET2_10               (0x0000400UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000400 */
#define ADC_OFR2_OFFSET2_11               (0x0000800UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000800 */
#define ADC_OFR2_OFFSET2_12               (0x0001000UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00001000 */
#define ADC_OFR2_OFFSET2_13               (0x0002000UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00002000 */
#define ADC_OFR2_OFFSET2_14               (0x0004000UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00004000 */
#define ADC_OFR2_OFFSET2_15               (0x0008000UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00008000 */
#define ADC_OFR2_OFFSET2_16               (0x0010000UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00010000 */
#define ADC_OFR2_OFFSET2_17               (0x0020000UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00020000 */
#define ADC_OFR2_OFFSET2_18               (0x0040000UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00040000 */
#define ADC_OFR2_OFFSET2_19               (0x0080000UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00080000 */
#define ADC_OFR2_OFFSET2_20               (0x0100000UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00100000 */
#define ADC_OFR2_OFFSET2_21               (0x0200000UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00200000 */
#define ADC_OFR2_OFFSET2_22               (0x0400000UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00400000 */
#define ADC_OFR2_OFFSET2_23               (0x0800000UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00800000 */
#define ADC_OFR2_OFFSET2_24               (0x1000000UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x01000000 */
#define ADC_OFR2_OFFSET2_25               (0x2000000UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x02000000 */

#define ADC_OFR2_OFFSET2_CH_Pos           (26U)
#define ADC_OFR2_OFFSET2_CH_Msk           (0x1FUL << ADC_OFR2_OFFSET2_CH_Pos)   /*!< 0x7C000000 */
#define ADC_OFR2_OFFSET2_CH               ADC_OFR2_OFFSET2_CH_Msk               /*!< ADC Channel selection for the data offset 2 */
#define ADC_OFR2_OFFSET2_CH_0             (0x01UL << ADC_OFR2_OFFSET2_CH_Pos)   /*!< 0x04000000 */
#define ADC_OFR2_OFFSET2_CH_1             (0x02UL << ADC_OFR2_OFFSET2_CH_Pos)   /*!< 0x08000000 */
#define ADC_OFR2_OFFSET2_CH_2             (0x04UL << ADC_OFR2_OFFSET2_CH_Pos)   /*!< 0x10000000 */
#define ADC_OFR2_OFFSET2_CH_3             (0x08UL << ADC_OFR2_OFFSET2_CH_Pos)   /*!< 0x20000000 */
#define ADC_OFR2_OFFSET2_CH_4             (0x10UL << ADC_OFR2_OFFSET2_CH_Pos)   /*!< 0x40000000 */

#define ADC_OFR2_SSATE_Pos                (31U)
#define ADC_OFR2_SSATE_Msk                (0x1UL << ADC_OFR2_SSATE_Pos)         /*!< 0x80000000 */
#define ADC_OFR2_SSATE                    ADC_OFR2_SSATE_Msk                    /*!< ADC Signed saturation Enable */

#define ADC3_OFR2_OFFSET2_Pos              (0U)
#define ADC3_OFR2_OFFSET2_Msk              (0xFFFUL << ADC3_OFR2_OFFSET2_Pos)   /*!< 0x00000FFF */
#define ADC3_OFR2_OFFSET2                  ADC3_OFR2_OFFSET2_Msk                /*!< ADC data offset 2 for channel programmed into bits OFFSET1_CH[4:0] */

#define ADC3_OFR2_OFFSETPOS_Pos         (24U)
#define ADC3_OFR2_OFFSETPOS_Msk         (0x1UL << ADC3_OFR2_OFFSETPOS_Pos)      /*!< 0x01000000 */
#define ADC3_OFR2_OFFSETPOS             ADC3_OFR2_OFFSETPOS_Msk                 /*!< ADC offset number 2 positive */
#define ADC3_OFR2_SATEN_Pos             (25U)
#define ADC3_OFR2_SATEN_Msk             (0x1UL << ADC3_OFR2_SATEN_Pos)          /*!< 0x02000000 */
#define ADC3_OFR2_SATEN                 ADC3_OFR2_SATEN_Msk                     /*!< ADC offset number 2 saturation enable */

#define ADC3_OFR2_OFFSET2_EN_Pos        (31U)
#define ADC3_OFR2_OFFSET2_EN_Msk        (0x1UL << ADC3_OFR2_OFFSET2_EN_Pos)     /*!< 0x80000000 */
#define ADC3_OFR2_OFFSET2_EN            ADC3_OFR2_OFFSET2_EN_Msk                /*!< ADC offset number 2 enable */

/********************  Bit definition for ADC_OFR3 register  ********************/
#define ADC_OFR3_OFFSET3_Pos              (0U)
#define ADC_OFR3_OFFSET3_Msk              (0x3FFFFFFUL << ADC_OFR3_OFFSET3_Pos) /*!< 0x03FFFFFF */
#define ADC_OFR3_OFFSET3                  ADC_OFR3_OFFSET3_Msk                  /*!< ADC data offset 3 for channel programmed into bits OFFSET3_CH[4:0] */
#define ADC_OFR3_OFFSET3_0                (0x0000001UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000001 */
#define ADC_OFR3_OFFSET3_1                (0x0000002UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000002 */
#define ADC_OFR3_OFFSET3_2                (0x0000004UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000004 */
#define ADC_OFR3_OFFSET3_3                (0x0000008UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000008 */
#define ADC_OFR3_OFFSET3_4                (0x0000010UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000010 */
#define ADC_OFR3_OFFSET3_5                (0x0000020UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000020 */
#define ADC_OFR3_OFFSET3_6                (0x0000040UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000040 */
#define ADC_OFR3_OFFSET3_7                (0x0000080UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000080 */
#define ADC_OFR3_OFFSET3_8                (0x0000100UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000100 */
#define ADC_OFR3_OFFSET3_9                (0x0000200UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000200 */
#define ADC_OFR3_OFFSET3_10               (0x0000400UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000400 */
#define ADC_OFR3_OFFSET3_11               (0x0000800UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000800 */
#define ADC_OFR3_OFFSET3_12               (0x0001000UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00001000 */
#define ADC_OFR3_OFFSET3_13               (0x0002000UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00002000 */
#define ADC_OFR3_OFFSET3_14               (0x0004000UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00004000 */
#define ADC_OFR3_OFFSET3_15               (0x0008000UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00008000 */
#define ADC_OFR3_OFFSET3_16               (0x0010000UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00010000 */
#define ADC_OFR3_OFFSET3_17               (0x0020000UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00020000 */
#define ADC_OFR3_OFFSET3_18               (0x0040000UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00040000 */
#define ADC_OFR3_OFFSET3_19               (0x0080000UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00080000 */
#define ADC_OFR3_OFFSET3_20               (0x0100000UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00100000 */
#define ADC_OFR3_OFFSET3_21               (0x0200000UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00200000 */
#define ADC_OFR3_OFFSET3_22               (0x0400000UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00400000 */
#define ADC_OFR3_OFFSET3_23               (0x0800000UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00800000 */
#define ADC_OFR3_OFFSET3_24               (0x1000000UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x01000000 */
#define ADC_OFR3_OFFSET3_25               (0x2000000UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x02000000 */

#define ADC_OFR3_OFFSET3_CH_Pos           (26U)
#define ADC_OFR3_OFFSET3_CH_Msk           (0x1FUL << ADC_OFR3_OFFSET3_CH_Pos)   /*!< 0x7C000000 */
#define ADC_OFR3_OFFSET3_CH               ADC_OFR3_OFFSET3_CH_Msk               /*!< ADC Channel selection for the data offset 3 */
#define ADC_OFR3_OFFSET3_CH_0             (0x01UL << ADC_OFR3_OFFSET3_CH_Pos)   /*!< 0x04000000 */
#define ADC_OFR3_OFFSET3_CH_1             (0x02UL << ADC_OFR3_OFFSET3_CH_Pos)   /*!< 0x08000000 */
#define ADC_OFR3_OFFSET3_CH_2             (0x04UL << ADC_OFR3_OFFSET3_CH_Pos)   /*!< 0x10000000 */
#define ADC_OFR3_OFFSET3_CH_3             (0x08UL << ADC_OFR3_OFFSET3_CH_Pos)   /*!< 0x20000000 */
#define ADC_OFR3_OFFSET3_CH_4             (0x10UL << ADC_OFR3_OFFSET3_CH_Pos)   /*!< 0x40000000 */

#define ADC_OFR3_SSATE_Pos                (31U)
#define ADC_OFR3_SSATE_Msk                (0x1UL << ADC_OFR3_SSATE_Pos)         /*!< 0x80000000 */
#define ADC_OFR3_SSATE                    ADC_OFR3_SSATE_Msk                    /*!< ADC Signed saturation Enable */

#define ADC3_OFR3_OFFSET3_Pos              (0U)
#define ADC3_OFR3_OFFSET3_Msk              (0xFFFUL << ADC3_OFR3_OFFSET3_Pos)   /*!< 0x00000FFF */
#define ADC3_OFR3_OFFSET3                  ADC3_OFR3_OFFSET3_Msk                /*!< ADC data offset 3 for channel programmed into bits OFFSET1_CH[4:0] */

#define ADC3_OFR3_OFFSETPOS_Pos         (24U)
#define ADC3_OFR3_OFFSETPOS_Msk         (0x1UL << ADC3_OFR3_OFFSETPOS_Pos)      /*!< 0x01000000 */
#define ADC3_OFR3_OFFSETPOS             ADC3_OFR3_OFFSETPOS_Msk                 /*!< ADC offset number 3 positive */
#define ADC3_OFR3_SATEN_Pos             (25U)
#define ADC3_OFR3_SATEN_Msk             (0x1UL << ADC3_OFR3_SATEN_Pos)          /*!< 0x02000000 */
#define ADC3_OFR3_SATEN                 ADC3_OFR3_SATEN_Msk                     /*!< ADC offset number 3 saturation enable */

#define ADC3_OFR3_OFFSET3_EN_Pos        (31U)
#define ADC3_OFR3_OFFSET3_EN_Msk        (0x1UL << ADC3_OFR3_OFFSET3_EN_Pos)     /*!< 0x80000000 */
#define ADC3_OFR3_OFFSET3_EN            ADC3_OFR3_OFFSET3_EN_Msk                /*!< ADC offset number 3 enable */

/********************  Bit definition for ADC_OFR4 register  ********************/
#define ADC_OFR4_OFFSET4_Pos              (0U)
#define ADC_OFR4_OFFSET4_Msk              (0x3FFFFFFUL << ADC_OFR4_OFFSET4_Pos) /*!< 0x03FFFFFF */
#define ADC_OFR4_OFFSET4                  ADC_OFR4_OFFSET4_Msk                  /*!< ADC data offset 4 for channel programmed into bits OFFSET4_CH[4:0] */
#define ADC_OFR4_OFFSET4_0                (0x0000001UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000001 */
#define ADC_OFR4_OFFSET4_1                (0x0000002UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000002 */
#define ADC_OFR4_OFFSET4_2                (0x0000004UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000004 */
#define ADC_OFR4_OFFSET4_3                (0x0000008UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000008 */
#define ADC_OFR4_OFFSET4_4                (0x0000010UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000010 */
#define ADC_OFR4_OFFSET4_5                (0x0000020UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000020 */
#define ADC_OFR4_OFFSET4_6                (0x0000040UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000040 */
#define ADC_OFR4_OFFSET4_7                (0x0000080UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000080 */
#define ADC_OFR4_OFFSET4_8                (0x0000100UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000100 */
#define ADC_OFR4_OFFSET4_9                (0x0000200UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000200 */
#define ADC_OFR4_OFFSET4_10               (0x0000400UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000400 */
#define ADC_OFR4_OFFSET4_11               (0x0000800UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000800 */
#define ADC_OFR4_OFFSET4_12               (0x0001000UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00001000 */
#define ADC_OFR4_OFFSET4_13               (0x0002000UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00002000 */
#define ADC_OFR4_OFFSET4_14               (0x0004000UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00004000 */
#define ADC_OFR4_OFFSET4_15               (0x0008000UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00008000 */
#define ADC_OFR4_OFFSET4_16               (0x0010000UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00010000 */
#define ADC_OFR4_OFFSET4_17               (0x0020000UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00020000 */
#define ADC_OFR4_OFFSET4_18               (0x0040000UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00040000 */
#define ADC_OFR4_OFFSET4_19               (0x0080000UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00080000 */
#define ADC_OFR4_OFFSET4_20               (0x0100000UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00100000 */
#define ADC_OFR4_OFFSET4_21               (0x0200000UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00200000 */
#define ADC_OFR4_OFFSET4_22               (0x0400000UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00400000 */
#define ADC_OFR4_OFFSET4_23               (0x0800000UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00800000 */
#define ADC_OFR4_OFFSET4_24               (0x1000000UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x01000000 */
#define ADC_OFR4_OFFSET4_25               (0x2000000UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x02000000 */

#define ADC_OFR4_OFFSET4_CH_Pos           (26U)
#define ADC_OFR4_OFFSET4_CH_Msk           (0x1FUL << ADC_OFR4_OFFSET4_CH_Pos)   /*!< 0x7C000000 */
#define ADC_OFR4_OFFSET4_CH               ADC_OFR4_OFFSET4_CH_Msk               /*!< ADC Channel selection for the data offset 4 */
#define ADC_OFR4_OFFSET4_CH_0             (0x01UL << ADC_OFR4_OFFSET4_CH_Pos)   /*!< 0x04000000 */
#define ADC_OFR4_OFFSET4_CH_1             (0x02UL << ADC_OFR4_OFFSET4_CH_Pos)   /*!< 0x08000000 */
#define ADC_OFR4_OFFSET4_CH_2             (0x04UL << ADC_OFR4_OFFSET4_CH_Pos)   /*!< 0x10000000 */
#define ADC_OFR4_OFFSET4_CH_3             (0x08UL << ADC_OFR4_OFFSET4_CH_Pos)   /*!< 0x20000000 */
#define ADC_OFR4_OFFSET4_CH_4             (0x10UL << ADC_OFR4_OFFSET4_CH_Pos)   /*!< 0x40000000 */

#define ADC_OFR4_SSATE_Pos                (31U)
#define ADC_OFR4_SSATE_Msk                (0x1UL << ADC_OFR4_SSATE_Pos)         /*!< 0x80000000 */
#define ADC_OFR4_SSATE                    ADC_OFR4_SSATE_Msk                    /*!< ADC Signed saturation Enable */

#define ADC3_OFR4_OFFSET4_Pos              (0U)
#define ADC3_OFR4_OFFSET4_Msk              (0xFFFUL << ADC3_OFR4_OFFSET4_Pos)   /*!< 0x00000FFF */
#define ADC3_OFR4_OFFSET4                  ADC3_OFR4_OFFSET4_Msk                /*!< ADC data offset 4 for channel programmed into bits OFFSET1_CH[4:0] */

#define ADC3_OFR4_OFFSETPOS_Pos         (24U)
#define ADC3_OFR4_OFFSETPOS_Msk         (0x1UL << ADC3_OFR4_OFFSETPOS_Pos)      /*!< 0x01000000 */
#define ADC3_OFR4_OFFSETPOS             ADC3_OFR4_OFFSETPOS_Msk                 /*!< ADC offset number 4 positive */
#define ADC3_OFR4_SATEN_Pos             (25U)
#define ADC3_OFR4_SATEN_Msk             (0x1UL << ADC3_OFR4_SATEN_Pos)          /*!< 0x02000000 */
#define ADC3_OFR4_SATEN                 ADC3_OFR4_SATEN_Msk                     /*!< ADC offset number 4 saturation enable */

#define ADC3_OFR4_OFFSET4_EN_Pos        (31U)
#define ADC3_OFR4_OFFSET4_EN_Msk        (0x1UL << ADC3_OFR4_OFFSET4_EN_Pos)     /*!< 0x80000000 */
#define ADC3_OFR4_OFFSET4_EN            ADC3_OFR4_OFFSET4_EN_Msk                /*!< ADC offset number 4 enable */

/********************  Bit definition for ADC_JDR1 register  ********************/
#define ADC_JDR1_JDATA_Pos                (0U)
#define ADC_JDR1_JDATA_Msk                (0xFFFFFFFFUL << ADC_JDR1_JDATA_Pos)  /*!< 0xFFFFFFFF */
#define ADC_JDR1_JDATA                    ADC_JDR1_JDATA_Msk                    /*!< ADC Injected DATA */
#define ADC_JDR1_JDATA_0                  (0x00000001UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00000001 */
#define ADC_JDR1_JDATA_1                  (0x00000002UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00000002 */
#define ADC_JDR1_JDATA_2                  (0x00000004UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00000004 */
#define ADC_JDR1_JDATA_3                  (0x00000008UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00000008 */
#define ADC_JDR1_JDATA_4                  (0x00000010UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00000010 */
#define ADC_JDR1_JDATA_5                  (0x00000020UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00000020 */
#define ADC_JDR1_JDATA_6                  (0x00000040UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00000040 */
#define ADC_JDR1_JDATA_7                  (0x00000080UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00000080 */
#define ADC_JDR1_JDATA_8                  (0x00000100UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00000100 */
#define ADC_JDR1_JDATA_9                  (0x00000200UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00000200 */
#define ADC_JDR1_JDATA_10                 (0x00000400UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00000400 */
#define ADC_JDR1_JDATA_11                 (0x00000800UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00000800 */
#define ADC_JDR1_JDATA_12                 (0x00001000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00001000 */
#define ADC_JDR1_JDATA_13                 (0x00002000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00002000 */
#define ADC_JDR1_JDATA_14                 (0x00004000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00004000 */
#define ADC_JDR1_JDATA_15                 (0x00008000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00008000 */
#define ADC_JDR1_JDATA_16                 (0x00010000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00010000 */
#define ADC_JDR1_JDATA_17                 (0x00020000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00020000 */
#define ADC_JDR1_JDATA_18                 (0x00040000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00040000 */
#define ADC_JDR1_JDATA_19                 (0x00080000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00080000 */
#define ADC_JDR1_JDATA_20                 (0x00100000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00100000 */
#define ADC_JDR1_JDATA_21                 (0x00200000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00200000 */
#define ADC_JDR1_JDATA_22                 (0x00400000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00400000 */
#define ADC_JDR1_JDATA_23                 (0x00800000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00800000 */
#define ADC_JDR1_JDATA_24                 (0x01000000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x01000000 */
#define ADC_JDR1_JDATA_25                 (0x02000000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x02000000 */
#define ADC_JDR1_JDATA_26                 (0x04000000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x04000000 */
#define ADC_JDR1_JDATA_27                 (0x08000000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x08000000 */
#define ADC_JDR1_JDATA_28                 (0x10000000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x10000000 */
#define ADC_JDR1_JDATA_29                 (0x20000000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x20000000 */
#define ADC_JDR1_JDATA_30                 (0x40000000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x40000000 */
#define ADC_JDR1_JDATA_31                 (0x80000000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x80000000 */

/********************  Bit definition for ADC_JDR2 register  ********************/
#define ADC_JDR2_JDATA_Pos                (0U)
#define ADC_JDR2_JDATA_Msk                (0xFFFFFFFFUL << ADC_JDR2_JDATA_Pos)  /*!< 0xFFFFFFFF */
#define ADC_JDR2_JDATA                    ADC_JDR2_JDATA_Msk                    /*!< ADC Injected DATA */
#define ADC_JDR2_JDATA_0                  (0x00000001UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00000001 */
#define ADC_JDR2_JDATA_1                  (0x00000002UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00000002 */
#define ADC_JDR2_JDATA_2                  (0x00000004UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00000004 */
#define ADC_JDR2_JDATA_3                  (0x00000008UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00000008 */
#define ADC_JDR2_JDATA_4                  (0x00000010UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00000010 */
#define ADC_JDR2_JDATA_5                  (0x00000020UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00000020 */
#define ADC_JDR2_JDATA_6                  (0x00000040UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00000040 */
#define ADC_JDR2_JDATA_7                  (0x00000080UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00000080 */
#define ADC_JDR2_JDATA_8                  (0x00000100UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00000100 */
#define ADC_JDR2_JDATA_9                  (0x00000200UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00000200 */
#define ADC_JDR2_JDATA_10                 (0x00000400UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00000400 */
#define ADC_JDR2_JDATA_11                 (0x00000800UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00000800 */
#define ADC_JDR2_JDATA_12                 (0x00001000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00001000 */
#define ADC_JDR2_JDATA_13                 (0x00002000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00002000 */
#define ADC_JDR2_JDATA_14                 (0x00004000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00004000 */
#define ADC_JDR2_JDATA_15                 (0x00008000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00008000 */
#define ADC_JDR2_JDATA_16                 (0x00010000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00010000 */
#define ADC_JDR2_JDATA_17                 (0x00020000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00020000 */
#define ADC_JDR2_JDATA_18                 (0x00040000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00040000 */
#define ADC_JDR2_JDATA_19                 (0x00080000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00080000 */
#define ADC_JDR2_JDATA_20                 (0x00100000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00100000 */
#define ADC_JDR2_JDATA_21                 (0x00200000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00200000 */
#define ADC_JDR2_JDATA_22                 (0x00400000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00400000 */
#define ADC_JDR2_JDATA_23                 (0x00800000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00800000 */
#define ADC_JDR2_JDATA_24                 (0x01000000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x01000000 */
#define ADC_JDR2_JDATA_25                 (0x02000000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x02000000 */
#define ADC_JDR2_JDATA_26                 (0x04000000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x04000000 */
#define ADC_JDR2_JDATA_27                 (0x08000000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x08000000 */
#define ADC_JDR2_JDATA_28                 (0x10000000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x10000000 */
#define ADC_JDR2_JDATA_29                 (0x20000000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x20000000 */
#define ADC_JDR2_JDATA_30                 (0x40000000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x40000000 */
#define ADC_JDR2_JDATA_31                 (0x80000000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x80000000 */

/********************  Bit definition for ADC_JDR3 register  ********************/
#define ADC_JDR3_JDATA_Pos                (0U)
#define ADC_JDR3_JDATA_Msk                (0xFFFFFFFFUL << ADC_JDR3_JDATA_Pos)  /*!< 0xFFFFFFFF */
#define ADC_JDR3_JDATA                    ADC_JDR3_JDATA_Msk                    /*!< ADC Injected DATA */
#define ADC_JDR3_JDATA_0                  (0x00000001UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00000001 */
#define ADC_JDR3_JDATA_1                  (0x00000002UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00000002 */
#define ADC_JDR3_JDATA_2                  (0x00000004UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00000004 */
#define ADC_JDR3_JDATA_3                  (0x00000008UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00000008 */
#define ADC_JDR3_JDATA_4                  (0x00000010UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00000010 */
#define ADC_JDR3_JDATA_5                  (0x00000020UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00000020 */
#define ADC_JDR3_JDATA_6                  (0x00000040UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00000040 */
#define ADC_JDR3_JDATA_7                  (0x00000080UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00000080 */
#define ADC_JDR3_JDATA_8                  (0x00000100UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00000100 */
#define ADC_JDR3_JDATA_9                  (0x00000200UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00000200 */
#define ADC_JDR3_JDATA_10                 (0x00000400UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00000400 */
#define ADC_JDR3_JDATA_11                 (0x00000800UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00000800 */
#define ADC_JDR3_JDATA_12                 (0x00001000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00001000 */
#define ADC_JDR3_JDATA_13                 (0x00002000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00002000 */
#define ADC_JDR3_JDATA_14                 (0x00004000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00004000 */
#define ADC_JDR3_JDATA_15                 (0x00008000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00008000 */
#define ADC_JDR3_JDATA_16                 (0x00010000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00010000 */
#define ADC_JDR3_JDATA_17                 (0x00020000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00020000 */
#define ADC_JDR3_JDATA_18                 (0x00040000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00040000 */
#define ADC_JDR3_JDATA_19                 (0x00080000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00080000 */
#define ADC_JDR3_JDATA_20                 (0x00100000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00100000 */
#define ADC_JDR3_JDATA_21                 (0x00200000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00200000 */
#define ADC_JDR3_JDATA_22                 (0x00400000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00400000 */
#define ADC_JDR3_JDATA_23                 (0x00800000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00800000 */
#define ADC_JDR3_JDATA_24                 (0x01000000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x01000000 */
#define ADC_JDR3_JDATA_25                 (0x02000000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x02000000 */
#define ADC_JDR3_JDATA_26                 (0x04000000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x04000000 */
#define ADC_JDR3_JDATA_27                 (0x08000000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x08000000 */
#define ADC_JDR3_JDATA_28                 (0x10000000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x10000000 */
#define ADC_JDR3_JDATA_29                 (0x20000000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x20000000 */
#define ADC_JDR3_JDATA_30                 (0x40000000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x40000000 */
#define ADC_JDR3_JDATA_31                 (0x80000000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x80000000 */

/********************  Bit definition for ADC_JDR4 register  ********************/
#define ADC_JDR4_JDATA_Pos                (0U)
#define ADC_JDR4_JDATA_Msk                (0xFFFFFFFFUL << ADC_JDR4_JDATA_Pos)  /*!< 0xFFFFFFFF */
#define ADC_JDR4_JDATA                    ADC_JDR4_JDATA_Msk                    /*!< ADC Injected DATA */
#define ADC_JDR4_JDATA_0                  (0x00000001UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00000001 */
#define ADC_JDR4_JDATA_1                  (0x00000002UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00000002 */
#define ADC_JDR4_JDATA_2                  (0x00000004UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00000004 */
#define ADC_JDR4_JDATA_3                  (0x00000008UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00000008 */
#define ADC_JDR4_JDATA_4                  (0x00000010UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00000010 */
#define ADC_JDR4_JDATA_5                  (0x00000020UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00000020 */
#define ADC_JDR4_JDATA_6                  (0x00000040UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00000040 */
#define ADC_JDR4_JDATA_7                  (0x00000080UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00000080 */
#define ADC_JDR4_JDATA_8                  (0x00000100UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00000100 */
#define ADC_JDR4_JDATA_9                  (0x00000200UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00000200 */
#define ADC_JDR4_JDATA_10                 (0x00000400UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00000400 */
#define ADC_JDR4_JDATA_11                 (0x00000800UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00000800 */
#define ADC_JDR4_JDATA_12                 (0x00001000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00001000 */
#define ADC_JDR4_JDATA_13                 (0x00002000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00002000 */
#define ADC_JDR4_JDATA_14                 (0x00004000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00004000 */
#define ADC_JDR4_JDATA_15                 (0x00008000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00008000 */
#define ADC_JDR4_JDATA_16                 (0x00010000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00010000 */
#define ADC_JDR4_JDATA_17                 (0x00020000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00020000 */
#define ADC_JDR4_JDATA_18                 (0x00040000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00040000 */
#define ADC_JDR4_JDATA_19                 (0x00080000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00080000 */
#define ADC_JDR4_JDATA_20                 (0x00100000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00100000 */
#define ADC_JDR4_JDATA_21                 (0x00200000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00200000 */
#define ADC_JDR4_JDATA_22                 (0x00400000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00400000 */
#define ADC_JDR4_JDATA_23                 (0x00800000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00800000 */
#define ADC_JDR4_JDATA_24                 (0x01000000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x01000000 */
#define ADC_JDR4_JDATA_25                 (0x02000000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x02000000 */
#define ADC_JDR4_JDATA_26                 (0x04000000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x04000000 */
#define ADC_JDR4_JDATA_27                 (0x08000000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x08000000 */
#define ADC_JDR4_JDATA_28                 (0x10000000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x10000000 */
#define ADC_JDR4_JDATA_29                 (0x20000000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x20000000 */
#define ADC_JDR4_JDATA_30                 (0x40000000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x40000000 */
#define ADC_JDR4_JDATA_31                 (0x80000000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x80000000 */

/********************  Bit definition for ADC_AWD2CR register  ********************/
#define ADC_AWD2CR_AWD2CH_Pos             (0U)
#define ADC_AWD2CR_AWD2CH_Msk             (0xFFFFFUL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x000FFFFF */
#define ADC_AWD2CR_AWD2CH                 ADC_AWD2CR_AWD2CH_Msk                 /*!< ADC Analog watchdog 2 channel selection */
#define ADC_AWD2CR_AWD2CH_0               (0x00001UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000001 */
#define ADC_AWD2CR_AWD2CH_1               (0x00002UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000002 */
#define ADC_AWD2CR_AWD2CH_2               (0x00004UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000004 */
#define ADC_AWD2CR_AWD2CH_3               (0x00008UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000008 */
#define ADC_AWD2CR_AWD2CH_4               (0x00010UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000010 */
#define ADC_AWD2CR_AWD2CH_5               (0x00020UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000020 */
#define ADC_AWD2CR_AWD2CH_6               (0x00040UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000040 */
#define ADC_AWD2CR_AWD2CH_7               (0x00080UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000080 */
#define ADC_AWD2CR_AWD2CH_8               (0x00100UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000100 */
#define ADC_AWD2CR_AWD2CH_9               (0x00200UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000200 */
#define ADC_AWD2CR_AWD2CH_10              (0x00400UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000400 */
#define ADC_AWD2CR_AWD2CH_11              (0x00800UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000800 */
#define ADC_AWD2CR_AWD2CH_12              (0x01000UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00001000 */
#define ADC_AWD2CR_AWD2CH_13              (0x02000UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00002000 */
#define ADC_AWD2CR_AWD2CH_14              (0x04000UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00004000 */
#define ADC_AWD2CR_AWD2CH_15              (0x08000UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00008000 */
#define ADC_AWD2CR_AWD2CH_16              (0x10000UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00010000 */
#define ADC_AWD2CR_AWD2CH_17              (0x20000UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00020000 */
#define ADC_AWD2CR_AWD2CH_18              (0x40000UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00040000 */
#define ADC_AWD2CR_AWD2CH_19              (0x80000UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00080000 */

/********************  Bit definition for ADC_AWD3CR register  ********************/
#define ADC_AWD3CR_AWD3CH_Pos             (0U)
#define ADC_AWD3CR_AWD3CH_Msk             (0xFFFFFUL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x000FFFFF */
#define ADC_AWD3CR_AWD3CH                 ADC_AWD3CR_AWD3CH_Msk                 /*!< ADC Analog watchdog 2 channel selection */
#define ADC_AWD3CR_AWD3CH_0               (0x00001UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000001 */
#define ADC_AWD3CR_AWD3CH_1               (0x00002UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000002 */
#define ADC_AWD3CR_AWD3CH_2               (0x00004UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000004 */
#define ADC_AWD3CR_AWD3CH_3               (0x00008UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000008 */
#define ADC_AWD3CR_AWD3CH_4               (0x00010UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000010 */
#define ADC_AWD3CR_AWD3CH_5               (0x00020UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000020 */
#define ADC_AWD3CR_AWD3CH_6               (0x00040UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000040 */
#define ADC_AWD3CR_AWD3CH_7               (0x00080UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000080 */
#define ADC_AWD3CR_AWD3CH_8               (0x00100UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000100 */
#define ADC_AWD3CR_AWD3CH_9               (0x00200UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000200 */
#define ADC_AWD3CR_AWD3CH_10              (0x00400UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000400 */
#define ADC_AWD3CR_AWD3CH_11              (0x00800UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000800 */
#define ADC_AWD3CR_AWD3CH_12              (0x01000UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00001000 */
#define ADC_AWD3CR_AWD3CH_13              (0x02000UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00002000 */
#define ADC_AWD3CR_AWD3CH_14              (0x04000UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00004000 */
#define ADC_AWD3CR_AWD3CH_15              (0x08000UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00008000 */
#define ADC_AWD3CR_AWD3CH_16              (0x10000UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00010000 */
#define ADC_AWD3CR_AWD3CH_17              (0x20000UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00020000 */
#define ADC_AWD3CR_AWD3CH_18              (0x40000UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00040000 */
#define ADC_AWD3CR_AWD3CH_19              (0x80000UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00080000 */

/********************  Bit definition for ADC_DIFSEL register  ********************/
#define ADC_DIFSEL_DIFSEL_Pos             (0U)
#define ADC_DIFSEL_DIFSEL_Msk             (0xFFFFFUL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x000FFFFF */
#define ADC_DIFSEL_DIFSEL                 ADC_DIFSEL_DIFSEL_Msk                 /*!< ADC differential modes for channels 1 to 18 */
#define ADC_DIFSEL_DIFSEL_0               (0x00001UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000001 */
#define ADC_DIFSEL_DIFSEL_1               (0x00002UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000002 */
#define ADC_DIFSEL_DIFSEL_2               (0x00004UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000004 */
#define ADC_DIFSEL_DIFSEL_3               (0x00008UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000008 */
#define ADC_DIFSEL_DIFSEL_4               (0x00010UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000010 */
#define ADC_DIFSEL_DIFSEL_5               (0x00020UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000020 */
#define ADC_DIFSEL_DIFSEL_6               (0x00040UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000040 */
#define ADC_DIFSEL_DIFSEL_7               (0x00080UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000080 */
#define ADC_DIFSEL_DIFSEL_8               (0x00100UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000100 */
#define ADC_DIFSEL_DIFSEL_9               (0x00200UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000200 */
#define ADC_DIFSEL_DIFSEL_10              (0x00400UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000400 */
#define ADC_DIFSEL_DIFSEL_11              (0x00800UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000800 */
#define ADC_DIFSEL_DIFSEL_12              (0x01000UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00001000 */
#define ADC_DIFSEL_DIFSEL_13              (0x02000UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00002000 */
#define ADC_DIFSEL_DIFSEL_14              (0x04000UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00004000 */
#define ADC_DIFSEL_DIFSEL_15              (0x08000UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00008000 */
#define ADC_DIFSEL_DIFSEL_16              (0x10000UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00010000 */
#define ADC_DIFSEL_DIFSEL_17              (0x20000UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00020000 */
#define ADC_DIFSEL_DIFSEL_18              (0x40000UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00040000 */
#define ADC_DIFSEL_DIFSEL_19              (0x80000UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00080000 */

/********************  Bit definition for ADC_CALFACT register  ********************/
#define ADC_CALFACT_CALFACT_S_Pos         (0U)
#define ADC_CALFACT_CALFACT_S_Msk         (0x7FFUL << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x000007FF */
#define ADC_CALFACT_CALFACT_S             ADC_CALFACT_CALFACT_S_Msk              /*!< ADC calibration factors in single-ended mode */
#define ADC_CALFACT_CALFACT_S_0           (0x001UL << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x00000001 */
#define ADC_CALFACT_CALFACT_S_1           (0x002UL << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x00000002 */
#define ADC_CALFACT_CALFACT_S_2           (0x004UL << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x00000004 */
#define ADC_CALFACT_CALFACT_S_3           (0x008UL << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x00000008 */
#define ADC_CALFACT_CALFACT_S_4           (0x010UL << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x00000010 */
#define ADC_CALFACT_CALFACT_S_5           (0x020UL << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x00000020 */
#define ADC_CALFACT_CALFACT_S_6           (0x040UL << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x00000040 */
#define ADC_CALFACT_CALFACT_S_7           (0x080UL << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x00000080 */
#define ADC_CALFACT_CALFACT_S_8           (0x100UL << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x00000100 */
#define ADC_CALFACT_CALFACT_S_9           (0x200UL << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x00000200 */
#define ADC_CALFACT_CALFACT_S_10          (0x400UL << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x00000400 */
#define ADC_CALFACT_CALFACT_D_Pos         (16U)
#define ADC_CALFACT_CALFACT_D_Msk         (0x7FFUL << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x07FF0000 */
#define ADC_CALFACT_CALFACT_D             ADC_CALFACT_CALFACT_D_Msk              /*!< ADC calibration factors in differential mode */
#define ADC_CALFACT_CALFACT_D_0           (0x001UL << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x00010000 */
#define ADC_CALFACT_CALFACT_D_1           (0x002UL << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x00020000 */
#define ADC_CALFACT_CALFACT_D_2           (0x004UL << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x00040000 */
#define ADC_CALFACT_CALFACT_D_3           (0x008UL << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x00080000 */
#define ADC_CALFACT_CALFACT_D_4           (0x010UL << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x00100000 */
#define ADC_CALFACT_CALFACT_D_5           (0x020UL << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x00200000 */
#define ADC_CALFACT_CALFACT_D_6           (0x040UL << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x00400000 */
#define ADC_CALFACT_CALFACT_D_7           (0x080UL << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x00800000 */
#define ADC_CALFACT_CALFACT_D_8           (0x100UL << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x01000000 */
#define ADC_CALFACT_CALFACT_D_9           (0x200UL << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x02000000 */
#define ADC_CALFACT_CALFACT_D_10          (0x400UL << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x04000000 */

/********************  Bit definition for ADC_CALFACT2 register  ********************/
#define ADC_CALFACT2_LINCALFACT_Pos       (0U)
#define ADC_CALFACT2_LINCALFACT_Msk       (0x3FFFFFFFUL << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x3FFFFFFF */
#define ADC_CALFACT2_LINCALFACT           ADC_CALFACT2_LINCALFACT_Msk                   /*!< ADC Linearity calibration factors */
#define ADC_CALFACT2_LINCALFACT_0         (0x00000001UL << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000001 */
#define ADC_CALFACT2_LINCALFACT_1         (0x00000002UL << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000002 */
#define ADC_CALFACT2_LINCALFACT_2         (0x00000004UL << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000004 */
#define ADC_CALFACT2_LINCALFACT_3         (0x00000008UL << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000008 */
#define ADC_CALFACT2_LINCALFACT_4         (0x00000010UL << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000010 */
#define ADC_CALFACT2_LINCALFACT_5         (0x00000020UL << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000020 */
#define ADC_CALFACT2_LINCALFACT_6         (0x00000040UL << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000040 */
#define ADC_CALFACT2_LINCALFACT_7         (0x00000080UL << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000080 */
#define ADC_CALFACT2_LINCALFACT_8         (0x00000100UL << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000100 */
#define ADC_CALFACT2_LINCALFACT_9         (0x00000200UL << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000200 */
#define ADC_CALFACT2_LINCALFACT_10        (0x00000400UL << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000400 */
#define ADC_CALFACT2_LINCALFACT_11        (0x00000800UL << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000800 */
#define ADC_CALFACT2_LINCALFACT_12        (0x00001000UL << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00001000 */
#define ADC_CALFACT2_LINCALFACT_13        (0x00002000UL << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00002000 */
#define ADC_CALFACT2_LINCALFACT_14        (0x00004000UL << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00004000 */
#define ADC_CALFACT2_LINCALFACT_15        (0x00008000UL << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00008000 */
#define ADC_CALFACT2_LINCALFACT_16        (0x00010000UL << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00010000 */
#define ADC_CALFACT2_LINCALFACT_17        (0x00020000UL << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00020000 */
#define ADC_CALFACT2_LINCALFACT_18        (0x00040000UL << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00040000 */
#define ADC_CALFACT2_LINCALFACT_19        (0x00080000UL << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00080000 */
#define ADC_CALFACT2_LINCALFACT_20        (0x00100000UL << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00100000 */
#define ADC_CALFACT2_LINCALFACT_21        (0x00200000UL << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00200000 */
#define ADC_CALFACT2_LINCALFACT_22        (0x00400000UL << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00400000 */
#define ADC_CALFACT2_LINCALFACT_23        (0x00800000UL << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00800000 */
#define ADC_CALFACT2_LINCALFACT_24        (0x01000000UL << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x01000000 */
#define ADC_CALFACT2_LINCALFACT_25        (0x02000000UL << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x02000000 */
#define ADC_CALFACT2_LINCALFACT_26        (0x04000000UL << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x04000000 */
#define ADC_CALFACT2_LINCALFACT_27        (0x08000000UL << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x08000000 */
#define ADC_CALFACT2_LINCALFACT_28        (0x10000000UL << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x10000000 */
#define ADC_CALFACT2_LINCALFACT_29        (0x20000000UL << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x20000000 */

/*************************  ADC Common registers  *****************************/
/********************  Bit definition for ADC_CSR register  ********************/
#define ADC_CSR_ADRDY_MST_Pos             (0U)
#define ADC_CSR_ADRDY_MST_Msk             (0x1UL << ADC_CSR_ADRDY_MST_Pos)     /*!< 0x00000001 */
#define ADC_CSR_ADRDY_MST                 ADC_CSR_ADRDY_MST_Msk                /*!< Master ADC ready */
#define ADC_CSR_EOSMP_MST_Pos             (1U)
#define ADC_CSR_EOSMP_MST_Msk             (0x1UL << ADC_CSR_EOSMP_MST_Pos)     /*!< 0x00000002 */
#define ADC_CSR_EOSMP_MST                 ADC_CSR_EOSMP_MST_Msk                /*!< End of sampling phase flag of the master ADC */
#define ADC_CSR_EOC_MST_Pos               (2U)
#define ADC_CSR_EOC_MST_Msk               (0x1UL << ADC_CSR_EOC_MST_Pos)       /*!< 0x00000004 */
#define ADC_CSR_EOC_MST                   ADC_CSR_EOC_MST_Msk                  /*!< End of regular conversion of the master ADC */
#define ADC_CSR_EOS_MST_Pos               (3U)
#define ADC_CSR_EOS_MST_Msk               (0x1UL << ADC_CSR_EOS_MST_Pos)       /*!< 0x00000008 */
#define ADC_CSR_EOS_MST                   ADC_CSR_EOS_MST_Msk                  /*!< End of regular sequence flag of the master ADC */
#define ADC_CSR_OVR_MST_Pos               (4U)
#define ADC_CSR_OVR_MST_Msk               (0x1UL << ADC_CSR_OVR_MST_Pos)       /*!< 0x00000010 */
#define ADC_CSR_OVR_MST                   ADC_CSR_OVR_MST_Msk                  /*!< Overrun flag of the master ADC */
#define ADC_CSR_JEOC_MST_Pos              (5U)
#define ADC_CSR_JEOC_MST_Msk              (0x1UL << ADC_CSR_JEOC_MST_Pos)      /*!< 0x00000020 */
#define ADC_CSR_JEOC_MST                  ADC_CSR_JEOC_MST_Msk                 /*!< End of injected conversion of the master ADC */
#define ADC_CSR_JEOS_MST_Pos              (6U)
#define ADC_CSR_JEOS_MST_Msk              (0x1UL << ADC_CSR_JEOS_MST_Pos)      /*!< 0x00000040 */
#define ADC_CSR_JEOS_MST                  ADC_CSR_JEOS_MST_Msk                 /*!< End of injected sequence flag of the master ADC */
#define ADC_CSR_AWD1_MST_Pos              (7U)
#define ADC_CSR_AWD1_MST_Msk              (0x1UL << ADC_CSR_AWD1_MST_Pos)      /*!< 0x00000080 */
#define ADC_CSR_AWD1_MST                  ADC_CSR_AWD1_MST_Msk                 /*!< Analog watchdog 1 flag of the master ADC */
#define ADC_CSR_AWD2_MST_Pos              (8U)
#define ADC_CSR_AWD2_MST_Msk              (0x1UL << ADC_CSR_AWD2_MST_Pos)      /*!< 0x00000100 */
#define ADC_CSR_AWD2_MST                  ADC_CSR_AWD2_MST_Msk                 /*!< Analog watchdog 2 flag of the master ADC */
#define ADC_CSR_AWD3_MST_Pos              (9U)
#define ADC_CSR_AWD3_MST_Msk              (0x1UL << ADC_CSR_AWD3_MST_Pos)      /*!< 0x00000200 */
#define ADC_CSR_AWD3_MST                  ADC_CSR_AWD3_MST_Msk                 /*!< Analog watchdog 3 flag of the master ADC */
#define ADC_CSR_JQOVF_MST_Pos             (10U)
#define ADC_CSR_JQOVF_MST_Msk             (0x1UL << ADC_CSR_JQOVF_MST_Pos)     /*!< 0x00000400 */
#define ADC_CSR_JQOVF_MST                 ADC_CSR_JQOVF_MST_Msk                /*!< Injected context queue overflow flag of the master ADC */
#define ADC_CSR_ADRDY_SLV_Pos             (16U)
#define ADC_CSR_ADRDY_SLV_Msk             (0x1UL << ADC_CSR_ADRDY_SLV_Pos)     /*!< 0x00010000 */
#define ADC_CSR_ADRDY_SLV                 ADC_CSR_ADRDY_SLV_Msk                /*!< Slave ADC ready */
#define ADC_CSR_EOSMP_SLV_Pos             (17U)
#define ADC_CSR_EOSMP_SLV_Msk             (0x1UL << ADC_CSR_EOSMP_SLV_Pos)     /*!< 0x00020000 */
#define ADC_CSR_EOSMP_SLV                 ADC_CSR_EOSMP_SLV_Msk                /*!< End of sampling phase flag of the slave ADC */
#define ADC_CSR_EOC_SLV_Pos               (18U)
#define ADC_CSR_EOC_SLV_Msk               (0x1UL << ADC_CSR_EOC_SLV_Pos)       /*!< 0x00040000 */
#define ADC_CSR_EOC_SLV                   ADC_CSR_EOC_SLV_Msk                  /*!< End of regular conversion of the slave ADC */
#define ADC_CSR_EOS_SLV_Pos               (19U)
#define ADC_CSR_EOS_SLV_Msk               (0x1UL << ADC_CSR_EOS_SLV_Pos)       /*!< 0x00080000 */
#define ADC_CSR_EOS_SLV                   ADC_CSR_EOS_SLV_Msk                  /*!< End of regular sequence flag of the slave ADC */
#define ADC_CSR_OVR_SLV_Pos               (20U)
#define ADC_CSR_OVR_SLV_Msk               (0x1UL << ADC_CSR_OVR_SLV_Pos)       /*!< 0x00100000 */
#define ADC_CSR_OVR_SLV                   ADC_CSR_OVR_SLV_Msk                  /*!< Overrun flag of the slave ADC */
#define ADC_CSR_JEOC_SLV_Pos              (21U)
#define ADC_CSR_JEOC_SLV_Msk              (0x1UL << ADC_CSR_JEOC_SLV_Pos)      /*!< 0x00200000 */
#define ADC_CSR_JEOC_SLV                  ADC_CSR_JEOC_SLV_Msk                 /*!< End of injected conversion of the slave ADC */
#define ADC_CSR_JEOS_SLV_Pos              (22U)
#define ADC_CSR_JEOS_SLV_Msk              (0x1UL << ADC_CSR_JEOS_SLV_Pos)      /*!< 0x00400000 */
#define ADC_CSR_JEOS_SLV                  ADC_CSR_JEOS_SLV_Msk                 /*!< End of injected sequence flag of the slave ADC */
#define ADC_CSR_AWD1_SLV_Pos              (23U)
#define ADC_CSR_AWD1_SLV_Msk              (0x1UL << ADC_CSR_AWD1_SLV_Pos)      /*!< 0x00800000 */
#define ADC_CSR_AWD1_SLV                  ADC_CSR_AWD1_SLV_Msk                 /*!< Analog watchdog 1 flag of the slave ADC */
#define ADC_CSR_AWD2_SLV_Pos              (24U)
#define ADC_CSR_AWD2_SLV_Msk              (0x1UL << ADC_CSR_AWD2_SLV_Pos)      /*!< 0x01000000 */
#define ADC_CSR_AWD2_SLV                  ADC_CSR_AWD2_SLV_Msk                 /*!< Analog watchdog 2 flag of the slave ADC */
#define ADC_CSR_AWD3_SLV_Pos              (25U)
#define ADC_CSR_AWD3_SLV_Msk              (0x1UL << ADC_CSR_AWD3_SLV_Pos)      /*!< 0x02000000 */
#define ADC_CSR_AWD3_SLV                  ADC_CSR_AWD3_SLV_Msk                 /*!< Analog watchdog 3 flag of the slave ADC */
#define ADC_CSR_JQOVF_SLV_Pos             (26U)
#define ADC_CSR_JQOVF_SLV_Msk             (0x1UL << ADC_CSR_JQOVF_SLV_Pos)     /*!< 0x04000000 */
#define ADC_CSR_JQOVF_SLV                 ADC_CSR_JQOVF_SLV_Msk                /*!< Injected context queue overflow flag of the slave ADC */

/********************  Bit definition for ADC_CCR register  ********************/
#define ADC_CCR_DUAL_Pos                  (0U)
#define ADC_CCR_DUAL_Msk                  (0x1FUL << ADC_CCR_DUAL_Pos)          /*!< 0x0000001F */
#define ADC_CCR_DUAL                      ADC_CCR_DUAL_Msk                      /*!< Dual ADC mode selection */
#define ADC_CCR_DUAL_0                    (0x01UL << ADC_CCR_DUAL_Pos)          /*!< 0x00000001 */
#define ADC_CCR_DUAL_1                    (0x02UL << ADC_CCR_DUAL_Pos)          /*!< 0x00000002 */
#define ADC_CCR_DUAL_2                    (0x04UL << ADC_CCR_DUAL_Pos)          /*!< 0x00000004 */
#define ADC_CCR_DUAL_3                    (0x08UL << ADC_CCR_DUAL_Pos)          /*!< 0x00000008 */
#define ADC_CCR_DUAL_4                    (0x10UL << ADC_CCR_DUAL_Pos)          /*!< 0x00000010 */

#define ADC_CCR_DELAY_Pos                 (8U)
#define ADC_CCR_DELAY_Msk                 (0xFUL << ADC_CCR_DELAY_Pos)          /*!< 0x00000F00 */
#define ADC_CCR_DELAY                     ADC_CCR_DELAY_Msk                     /*!< Delay between 2 sampling phases */
#define ADC_CCR_DELAY_0                   (0x1UL << ADC_CCR_DELAY_Pos)          /*!< 0x00000100 */
#define ADC_CCR_DELAY_1                   (0x2UL << ADC_CCR_DELAY_Pos)          /*!< 0x00000200 */
#define ADC_CCR_DELAY_2                   (0x4UL << ADC_CCR_DELAY_Pos)          /*!< 0x00000400 */
#define ADC_CCR_DELAY_3                   (0x8UL << ADC_CCR_DELAY_Pos)          /*!< 0x00000800 */


#define ADC_CCR_DAMDF_Pos                 (14U)
#define ADC_CCR_DAMDF_Msk                 (0x3UL << ADC_CCR_DAMDF_Pos)          /*!< 0x0000C000 */
#define ADC_CCR_DAMDF                     ADC_CCR_DAMDF_Msk                     /*!< Dual ADC mode Data format */
#define ADC_CCR_DAMDF_0                   (0x1UL << ADC_CCR_DAMDF_Pos)          /*!< 0x00004000 */
#define ADC_CCR_DAMDF_1                   (0x2UL << ADC_CCR_DAMDF_Pos)          /*!< 0x00008000 */

#define ADC_CCR_CKMODE_Pos                (16U)
#define ADC_CCR_CKMODE_Msk                (0x3UL << ADC_CCR_CKMODE_Pos)         /*!< 0x00030000 */
#define ADC_CCR_CKMODE                    ADC_CCR_CKMODE_Msk                    /*!< ADC clock mode */
#define ADC_CCR_CKMODE_0                  (0x1UL << ADC_CCR_CKMODE_Pos)         /*!< 0x00010000 */
#define ADC_CCR_CKMODE_1                  (0x2UL << ADC_CCR_CKMODE_Pos)         /*!< 0x00020000 */

#define ADC_CCR_PRESC_Pos                 (18U)
#define ADC_CCR_PRESC_Msk                 (0xFUL << ADC_CCR_PRESC_Pos)          /*!< 0x003C0000 */
#define ADC_CCR_PRESC                     ADC_CCR_PRESC_Msk                     /*!< ADC prescaler */
#define ADC_CCR_PRESC_0                   (0x1UL << ADC_CCR_PRESC_Pos)          /*!< 0x00040000 */
#define ADC_CCR_PRESC_1                   (0x2UL << ADC_CCR_PRESC_Pos)          /*!< 0x00080000 */
#define ADC_CCR_PRESC_2                   (0x4UL << ADC_CCR_PRESC_Pos)          /*!< 0x00100000 */
#define ADC_CCR_PRESC_3                   (0x8UL << ADC_CCR_PRESC_Pos)          /*!< 0x00200000 */

#define ADC_CCR_VREFEN_Pos                (22U)
#define ADC_CCR_VREFEN_Msk                (0x1UL << ADC_CCR_VREFEN_Pos)         /*!< 0x00400000 */
#define ADC_CCR_VREFEN                    ADC_CCR_VREFEN_Msk                    /*!< VREFINT enable */
#define ADC_CCR_TSEN_Pos                  (23U)
#define ADC_CCR_TSEN_Msk                  (0x1UL << ADC_CCR_TSEN_Pos)           /*!< 0x00800000 */
#define ADC_CCR_TSEN                      ADC_CCR_TSEN_Msk                      /*!< Temperature sensor enable */
#define ADC_CCR_VBATEN_Pos                (24U)
#define ADC_CCR_VBATEN_Msk                (0x1UL << ADC_CCR_VBATEN_Pos)         /*!< 0x01000000 */
#define ADC_CCR_VBATEN                    ADC_CCR_VBATEN_Msk                    /*!< VBAT enable */

/********************  Bit definition for ADC_CDR register  *******************/
#define ADC_CDR_RDATA_MST_Pos             (0U)
#define ADC_CDR_RDATA_MST_Msk             (0xFFFFUL << ADC_CDR_RDATA_MST_Pos)   /*!< 0x0000FFFF */
#define ADC_CDR_RDATA_MST                 ADC_CDR_RDATA_MST_Msk                 /*!< ADC multimode master group regular conversion data */

#define ADC_CDR_RDATA_SLV_Pos             (16U)
#define ADC_CDR_RDATA_SLV_Msk             (0xFFFFUL << ADC_CDR_RDATA_SLV_Pos)   /*!< 0xFFFF0000 */
#define ADC_CDR_RDATA_SLV                 ADC_CDR_RDATA_SLV_Msk                 /*!< ADC multimode slave group regular conversion data */

/********************  Bit definition for ADC_CDR2 register  ******************/
#define ADC_CDR2_RDATA_ALT_Pos            (0U)
#define ADC_CDR2_RDATA_ALT_Msk            (0xFFFFFFFFUL << ADC_CDR2_RDATA_ALT_Pos) /*!< 0xFFFFFFFF */
#define ADC_CDR2_RDATA_ALT                ADC_CDR2_RDATA_ALT_Msk                   /*!< Regular data of the master/slave alternated ADCs */


/******************************************************************************/
/*                                                                            */
/*                                   VREFBUF                                  */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for VREFBUF_CSR register  ****************/
#define VREFBUF_CSR_ENVR_Pos        (0U)
#define VREFBUF_CSR_ENVR_Msk        (0x1UL << VREFBUF_CSR_ENVR_Pos)            /*!< 0x00000001 */
#define VREFBUF_CSR_ENVR            VREFBUF_CSR_ENVR_Msk                       /*!<Voltage reference buffer enable */
#define VREFBUF_CSR_HIZ_Pos         (1U)
#define VREFBUF_CSR_HIZ_Msk         (0x1UL << VREFBUF_CSR_HIZ_Pos)             /*!< 0x00000002 */
#define VREFBUF_CSR_HIZ             VREFBUF_CSR_HIZ_Msk                        /*!<High impedance mode             */
#define VREFBUF_CSR_VRR_Pos         (3U)
#define VREFBUF_CSR_VRR_Msk         (0x1UL << VREFBUF_CSR_VRR_Pos)             /*!< 0x00000008 */
#define VREFBUF_CSR_VRR             VREFBUF_CSR_VRR_Msk                        /*!<Voltage reference buffer ready  */
#define VREFBUF_CSR_VRS_Pos         (4U)
#define VREFBUF_CSR_VRS_Msk         (0x7UL << VREFBUF_CSR_VRS_Pos)             /*!< 0x00000070 */
#define VREFBUF_CSR_VRS             VREFBUF_CSR_VRS_Msk                        /*!<Voltage reference scale         */

#define VREFBUF_CSR_VRS_OUT1        ((uint32_t)0x00000000)                     /*!<Voltage reference VREF_OUT1     */
#define VREFBUF_CSR_VRS_OUT2_Pos    (4U)
#define VREFBUF_CSR_VRS_OUT2_Msk    (0x1UL << VREFBUF_CSR_VRS_OUT2_Pos)        /*!< 0x00000010 */
#define VREFBUF_CSR_VRS_OUT2        VREFBUF_CSR_VRS_OUT2_Msk                   /*!<Voltage reference VREF_OUT2     */
#define VREFBUF_CSR_VRS_OUT3_Pos    (5U)
#define VREFBUF_CSR_VRS_OUT3_Msk    (0x1UL << VREFBUF_CSR_VRS_OUT3_Pos)        /*!< 0x00000020 */
#define VREFBUF_CSR_VRS_OUT3        VREFBUF_CSR_VRS_OUT3_Msk                   /*!<Voltage reference VREF_OUT3     */
#define VREFBUF_CSR_VRS_OUT4_Pos    (4U)
#define VREFBUF_CSR_VRS_OUT4_Msk    (0x3UL << VREFBUF_CSR_VRS_OUT4_Pos)        /*!< 0x00000030 */
#define VREFBUF_CSR_VRS_OUT4        VREFBUF_CSR_VRS_OUT4_Msk                   /*!<Voltage reference VREF_OUT4     */

/*******************  Bit definition for VREFBUF_CCR register  ****************/
#define VREFBUF_CCR_TRIM_Pos        (0U)
#define VREFBUF_CCR_TRIM_Msk        (0x3FUL << VREFBUF_CCR_TRIM_Pos)           /*!< 0x0000003F */
#define VREFBUF_CCR_TRIM            VREFBUF_CCR_TRIM_Msk                       /*!<TRIM[5:0] bits (Trimming code)  */

/******************************************************************************/
/*                                                                            */
/*                 Flexible Datarate Controller Area Network                  */
/*                                                                            */
/******************************************************************************/
/*!<FDCAN control and status registers */
/*****************  Bit definition for FDCAN_CREL register  *******************/
#define FDCAN_CREL_DAY_Pos        (0U)
#define FDCAN_CREL_DAY_Msk        (0xFFUL << FDCAN_CREL_DAY_Pos)               /*!< 0x000000FF */
#define FDCAN_CREL_DAY            FDCAN_CREL_DAY_Msk                           /*!<Timestamp Day                           */
#define FDCAN_CREL_MON_Pos        (8U)
#define FDCAN_CREL_MON_Msk        (0xFFUL << FDCAN_CREL_MON_Pos)               /*!< 0x0000FF00 */
#define FDCAN_CREL_MON            FDCAN_CREL_MON_Msk                           /*!<Timestamp Month                         */
#define FDCAN_CREL_YEAR_Pos       (16U)
#define FDCAN_CREL_YEAR_Msk       (0xFUL << FDCAN_CREL_YEAR_Pos)               /*!< 0x000F0000 */
#define FDCAN_CREL_YEAR           FDCAN_CREL_YEAR_Msk                          /*!<Timestamp Year                          */
#define FDCAN_CREL_SUBSTEP_Pos    (20U)
#define FDCAN_CREL_SUBSTEP_Msk    (0xFUL << FDCAN_CREL_SUBSTEP_Pos)            /*!< 0x00F00000 */
#define FDCAN_CREL_SUBSTEP        FDCAN_CREL_SUBSTEP_Msk                       /*!<Sub-step of Core release                */
#define FDCAN_CREL_STEP_Pos       (24U)
#define FDCAN_CREL_STEP_Msk       (0xFUL << FDCAN_CREL_STEP_Pos)               /*!< 0x0F000000 */
#define FDCAN_CREL_STEP           FDCAN_CREL_STEP_Msk                          /*!<Step of Core release                    */
#define FDCAN_CREL_REL_Pos        (28U)
#define FDCAN_CREL_REL_Msk        (0xFUL << FDCAN_CREL_REL_Pos)                /*!< 0xF0000000 */
#define FDCAN_CREL_REL            FDCAN_CREL_REL_Msk                           /*!<Core release                            */

/*****************  Bit definition for FDCAN_ENDN register  *******************/
#define FDCAN_ENDN_ETV_Pos        (0U)
#define FDCAN_ENDN_ETV_Msk        (0xFFFFFFFFUL << FDCAN_ENDN_ETV_Pos)         /*!< 0xFFFFFFFF */
#define FDCAN_ENDN_ETV            FDCAN_ENDN_ETV_Msk                           /*!<Endiannes Test Value                    */

/*****************  Bit definition for FDCAN_DBTP register  *******************/
#define FDCAN_DBTP_DSJW_Pos       (0U)
#define FDCAN_DBTP_DSJW_Msk       (0xFUL << FDCAN_DBTP_DSJW_Pos)               /*!< 0x0000000F */
#define FDCAN_DBTP_DSJW           FDCAN_DBTP_DSJW_Msk                          /*!<Synchronization Jump Width              */
#define FDCAN_DBTP_DTSEG2_Pos     (4U)
#define FDCAN_DBTP_DTSEG2_Msk     (0xFUL << FDCAN_DBTP_DTSEG2_Pos)             /*!< 0x000000F0 */
#define FDCAN_DBTP_DTSEG2         FDCAN_DBTP_DTSEG2_Msk                        /*!<Data time segment after sample point    */
#define FDCAN_DBTP_DTSEG1_Pos     (8U)
#define FDCAN_DBTP_DTSEG1_Msk     (0x1FUL << FDCAN_DBTP_DTSEG1_Pos)            /*!< 0x00001F00 */
#define FDCAN_DBTP_DTSEG1         FDCAN_DBTP_DTSEG1_Msk                        /*!<Data time segment before sample point   */
#define FDCAN_DBTP_DBRP_Pos       (16U)
#define FDCAN_DBTP_DBRP_Msk       (0x1FUL << FDCAN_DBTP_DBRP_Pos)              /*!< 0x001F0000 */
#define FDCAN_DBTP_DBRP           FDCAN_DBTP_DBRP_Msk                          /*!<Data BIt Rate Prescaler                 */
#define FDCAN_DBTP_TDC_Pos        (23U)
#define FDCAN_DBTP_TDC_Msk        (0x1UL << FDCAN_DBTP_TDC_Pos)                /*!< 0x00800000 */
#define FDCAN_DBTP_TDC            FDCAN_DBTP_TDC_Msk                           /*!<Transceiver Delay Compensation          */

/*****************  Bit definition for FDCAN_TEST register  *******************/
#define FDCAN_TEST_LBCK_Pos       (4U)
#define FDCAN_TEST_LBCK_Msk       (0x1UL << FDCAN_TEST_LBCK_Pos)               /*!< 0x00000010 */
#define FDCAN_TEST_LBCK           FDCAN_TEST_LBCK_Msk                          /*!<Loop Back mode                           */
#define FDCAN_TEST_TX_Pos         (5U)
#define FDCAN_TEST_TX_Msk         (0x3UL << FDCAN_TEST_TX_Pos)                 /*!< 0x00000060 */
#define FDCAN_TEST_TX             FDCAN_TEST_TX_Msk                            /*!<Control of Transmit Pin                  */
#define FDCAN_TEST_RX_Pos         (7U)
#define FDCAN_TEST_RX_Msk         (0x1UL << FDCAN_TEST_RX_Pos)                 /*!< 0x00000080 */
#define FDCAN_TEST_RX             FDCAN_TEST_RX_Msk                            /*!<Receive Pin                              */

/*****************  Bit definition for FDCAN_RWD register  ********************/
#define FDCAN_RWD_WDC_Pos         (0U)
#define FDCAN_RWD_WDC_Msk         (0xFFUL << FDCAN_RWD_WDC_Pos)                /*!< 0x000000FF */
#define FDCAN_RWD_WDC             FDCAN_RWD_WDC_Msk                            /*!<Watchdog configuration                   */
#define FDCAN_RWD_WDV_Pos         (8U)
#define FDCAN_RWD_WDV_Msk         (0xFFUL << FDCAN_RWD_WDV_Pos)                /*!< 0x0000FF00 */
#define FDCAN_RWD_WDV             FDCAN_RWD_WDV_Msk                            /*!<Watchdog value                           */

/*****************  Bit definition for FDCAN_CCCR register  ********************/
#define FDCAN_CCCR_INIT_Pos       (0U)
#define FDCAN_CCCR_INIT_Msk       (0x1UL << FDCAN_CCCR_INIT_Pos)               /*!< 0x00000001 */
#define FDCAN_CCCR_INIT           FDCAN_CCCR_INIT_Msk                          /*!<Initialization                           */
#define FDCAN_CCCR_CCE_Pos        (1U)
#define FDCAN_CCCR_CCE_Msk        (0x1UL << FDCAN_CCCR_CCE_Pos)                /*!< 0x00000002 */
#define FDCAN_CCCR_CCE            FDCAN_CCCR_CCE_Msk                           /*!<Configuration Change Enable              */
#define FDCAN_CCCR_ASM_Pos        (2U)
#define FDCAN_CCCR_ASM_Msk        (0x1UL << FDCAN_CCCR_ASM_Pos)                /*!< 0x00000004 */
#define FDCAN_CCCR_ASM            FDCAN_CCCR_ASM_Msk                           /*!<ASM Restricted Operation Mode            */
#define FDCAN_CCCR_CSA_Pos        (3U)
#define FDCAN_CCCR_CSA_Msk        (0x1UL << FDCAN_CCCR_CSA_Pos)                /*!< 0x00000008 */
#define FDCAN_CCCR_CSA            FDCAN_CCCR_CSA_Msk                           /*!<Clock Stop Acknowledge                   */
#define FDCAN_CCCR_CSR_Pos        (4U)
#define FDCAN_CCCR_CSR_Msk        (0x1UL << FDCAN_CCCR_CSR_Pos)                /*!< 0x00000010 */
#define FDCAN_CCCR_CSR            FDCAN_CCCR_CSR_Msk                           /*!<Clock Stop Request                       */
#define FDCAN_CCCR_MON_Pos        (5U)
#define FDCAN_CCCR_MON_Msk        (0x1UL << FDCAN_CCCR_MON_Pos)                /*!< 0x00000020 */
#define FDCAN_CCCR_MON            FDCAN_CCCR_MON_Msk                           /*!<Bus Monitoring Mode                      */
#define FDCAN_CCCR_DAR_Pos        (6U)
#define FDCAN_CCCR_DAR_Msk        (0x1UL << FDCAN_CCCR_DAR_Pos)                /*!< 0x00000040 */
#define FDCAN_CCCR_DAR            FDCAN_CCCR_DAR_Msk                           /*!<Disable Automatic Retransmission         */
#define FDCAN_CCCR_TEST_Pos       (7U)
#define FDCAN_CCCR_TEST_Msk       (0x1UL << FDCAN_CCCR_TEST_Pos)               /*!< 0x00000080 */
#define FDCAN_CCCR_TEST           FDCAN_CCCR_TEST_Msk                          /*!<Test Mode Enable                         */
#define FDCAN_CCCR_FDOE_Pos       (8U)
#define FDCAN_CCCR_FDOE_Msk       (0x1UL << FDCAN_CCCR_FDOE_Pos)               /*!< 0x00000100 */
#define FDCAN_CCCR_FDOE           FDCAN_CCCR_FDOE_Msk                          /*!<FD Operation Enable                      */
#define FDCAN_CCCR_BRSE_Pos       (9U)
#define FDCAN_CCCR_BRSE_Msk       (0x1UL << FDCAN_CCCR_BRSE_Pos)               /*!< 0x00000200 */
#define FDCAN_CCCR_BRSE           FDCAN_CCCR_BRSE_Msk                          /*!<FDCAN Bit Rate Switching                 */
#define FDCAN_CCCR_PXHD_Pos       (12U)
#define FDCAN_CCCR_PXHD_Msk       (0x1UL << FDCAN_CCCR_PXHD_Pos)               /*!< 0x00001000 */
#define FDCAN_CCCR_PXHD           FDCAN_CCCR_PXHD_Msk                          /*!<Protocol Exception Handling Disable      */
#define FDCAN_CCCR_EFBI_Pos       (13U)
#define FDCAN_CCCR_EFBI_Msk       (0x1UL << FDCAN_CCCR_EFBI_Pos)               /*!< 0x00002000 */
#define FDCAN_CCCR_EFBI           FDCAN_CCCR_EFBI_Msk                          /*!<Edge Filtering during Bus Integration    */
#define FDCAN_CCCR_TXP_Pos        (14U)
#define FDCAN_CCCR_TXP_Msk        (0x1UL << FDCAN_CCCR_TXP_Pos)                /*!< 0x00004000 */
#define FDCAN_CCCR_TXP            FDCAN_CCCR_TXP_Msk                           /*!<Two CAN bit times Pause                  */
#define FDCAN_CCCR_NISO_Pos       (15U)
#define FDCAN_CCCR_NISO_Msk       (0x1UL << FDCAN_CCCR_NISO_Pos)               /*!< 0x00008000 */
#define FDCAN_CCCR_NISO           FDCAN_CCCR_NISO_Msk                          /*!<Non ISO Operation                        */

/*****************  Bit definition for FDCAN_NBTP register  ********************/
#define FDCAN_NBTP_NTSEG2_Pos     (0U)
#define FDCAN_NBTP_NTSEG2_Msk     (0x7FUL << FDCAN_NBTP_NTSEG2_Pos)            /*!< 0x0000007F */
#define FDCAN_NBTP_NTSEG2         FDCAN_NBTP_NTSEG2_Msk                        /*!<Nominal Time segment after sample point  */
#define FDCAN_NBTP_NTSEG1_Pos     (8U)
#define FDCAN_NBTP_NTSEG1_Msk     (0xFFUL << FDCAN_NBTP_NTSEG1_Pos)            /*!< 0x0000FF00 */
#define FDCAN_NBTP_NTSEG1         FDCAN_NBTP_NTSEG1_Msk                        /*!<Nominal Time segment before sample point */
#define FDCAN_NBTP_NBRP_Pos       (16U)
#define FDCAN_NBTP_NBRP_Msk       (0x1FFUL << FDCAN_NBTP_NBRP_Pos)             /*!< 0x01FF0000 */
#define FDCAN_NBTP_NBRP           FDCAN_NBTP_NBRP_Msk                          /*!<Bit Rate Prescaler                       */
#define FDCAN_NBTP_NSJW_Pos       (25U)
#define FDCAN_NBTP_NSJW_Msk       (0x7FUL << FDCAN_NBTP_NSJW_Pos)              /*!< 0xFE000000 */
#define FDCAN_NBTP_NSJW           FDCAN_NBTP_NSJW_Msk                          /*!<Nominal (Re)Synchronization Jump Width   */

/*****************  Bit definition for FDCAN_TSCC register  ********************/
#define FDCAN_TSCC_TSS_Pos        (0U)
#define FDCAN_TSCC_TSS_Msk        (0x3UL << FDCAN_TSCC_TSS_Pos)                /*!< 0x00000003 */
#define FDCAN_TSCC_TSS            FDCAN_TSCC_TSS_Msk                           /*!<Timestamp Select                         */
#define FDCAN_TSCC_TCP_Pos        (16U)
#define FDCAN_TSCC_TCP_Msk        (0xFUL << FDCAN_TSCC_TCP_Pos)                /*!< 0x000F0000 */
#define FDCAN_TSCC_TCP            FDCAN_TSCC_TCP_Msk                           /*!<Timestamp Counter Prescaler              */

/*****************  Bit definition for FDCAN_TSCV register  ********************/
#define FDCAN_TSCV_TSC_Pos        (0U)
#define FDCAN_TSCV_TSC_Msk        (0xFFFFUL << FDCAN_TSCV_TSC_Pos)             /*!< 0x0000FFFF */
#define FDCAN_TSCV_TSC            FDCAN_TSCV_TSC_Msk                           /*!<Timestamp Counter                        */

/*****************  Bit definition for FDCAN_TOCC register  ********************/
#define FDCAN_TOCC_ETOC_Pos       (0U)
#define FDCAN_TOCC_ETOC_Msk       (0x1UL << FDCAN_TOCC_ETOC_Pos)               /*!< 0x00000001 */
#define FDCAN_TOCC_ETOC           FDCAN_TOCC_ETOC_Msk                          /*!<Enable Timeout Counter                   */
#define FDCAN_TOCC_TOS_Pos        (1U)
#define FDCAN_TOCC_TOS_Msk        (0x3UL << FDCAN_TOCC_TOS_Pos)                /*!< 0x00000006 */
#define FDCAN_TOCC_TOS            FDCAN_TOCC_TOS_Msk                           /*!<Timeout Select                           */
#define FDCAN_TOCC_TOP_Pos        (16U)
#define FDCAN_TOCC_TOP_Msk        (0xFFFFUL << FDCAN_TOCC_TOP_Pos)             /*!< 0xFFFF0000 */
#define FDCAN_TOCC_TOP            FDCAN_TOCC_TOP_Msk                           /*!<Timeout Period                           */

/*****************  Bit definition for FDCAN_TOCV register  ********************/
#define FDCAN_TOCV_TOC_Pos        (0U)
#define FDCAN_TOCV_TOC_Msk        (0xFFFFUL << FDCAN_TOCV_TOC_Pos)             /*!< 0x0000FFFF */
#define FDCAN_TOCV_TOC            FDCAN_TOCV_TOC_Msk                           /*!<Timeout Counter                          */

/*****************  Bit definition for FDCAN_ECR register  *********************/
#define FDCAN_ECR_TEC_Pos         (0U)
#define FDCAN_ECR_TEC_Msk         (0xFFUL << FDCAN_ECR_TEC_Pos)                 /*!< 0x000000FF */
#define FDCAN_ECR_TEC             FDCAN_ECR_TEC_Msk                            /*!<Transmit Error Counter                   */
#define FDCAN_ECR_REC_Pos         (8U)
#define FDCAN_ECR_REC_Msk         (0x7FUL << FDCAN_ECR_REC_Pos)                /*!< 0x00007F00 */
#define FDCAN_ECR_REC             FDCAN_ECR_REC_Msk                            /*!<Receive Error Counter                    */
#define FDCAN_ECR_RP_Pos          (15U)
#define FDCAN_ECR_RP_Msk          (0x1UL << FDCAN_ECR_RP_Pos)                  /*!< 0x00008000 */
#define FDCAN_ECR_RP              FDCAN_ECR_RP_Msk                             /*!<Receive Error Passive                    */
#define FDCAN_ECR_CEL_Pos         (16U)
#define FDCAN_ECR_CEL_Msk         (0xFFUL << FDCAN_ECR_CEL_Pos)                /*!< 0x00FF0000 */
#define FDCAN_ECR_CEL             FDCAN_ECR_CEL_Msk                            /*!<CAN Error Logging                        */

/*****************  Bit definition for FDCAN_PSR register  *********************/
#define FDCAN_PSR_LEC_Pos         (0U)
#define FDCAN_PSR_LEC_Msk         (0x7UL << FDCAN_PSR_LEC_Pos)                 /*!< 0x00000007 */
#define FDCAN_PSR_LEC             FDCAN_PSR_LEC_Msk                            /*!<Last Error Code                          */
#define FDCAN_PSR_ACT_Pos         (3U)
#define FDCAN_PSR_ACT_Msk         (0x3UL << FDCAN_PSR_ACT_Pos)                 /*!< 0x00000018 */
#define FDCAN_PSR_ACT             FDCAN_PSR_ACT_Msk                            /*!<Activity                                 */
#define FDCAN_PSR_EP_Pos          (5U)
#define FDCAN_PSR_EP_Msk          (0x1UL << FDCAN_PSR_EP_Pos)                  /*!< 0x00000020 */
#define FDCAN_PSR_EP              FDCAN_PSR_EP_Msk                             /*!<Error Passive                            */
#define FDCAN_PSR_EW_Pos          (6U)
#define FDCAN_PSR_EW_Msk          (0x1UL << FDCAN_PSR_EW_Pos)                  /*!< 0x00000040 */
#define FDCAN_PSR_EW              FDCAN_PSR_EW_Msk                             /*!<Warning Status                           */
#define FDCAN_PSR_BO_Pos          (7U)
#define FDCAN_PSR_BO_Msk          (0x1UL << FDCAN_PSR_BO_Pos)                  /*!< 0x00000080 */
#define FDCAN_PSR_BO              FDCAN_PSR_BO_Msk                             /*!<Bus_Off Status                           */
#define FDCAN_PSR_DLEC_Pos        (8U)
#define FDCAN_PSR_DLEC_Msk        (0x7UL << FDCAN_PSR_DLEC_Pos)                /*!< 0x00000700 */
#define FDCAN_PSR_DLEC            FDCAN_PSR_DLEC_Msk                           /*!<Data Last Error Code                     */
#define FDCAN_PSR_RESI_Pos        (11U)
#define FDCAN_PSR_RESI_Msk        (0x1UL << FDCAN_PSR_RESI_Pos)                /*!< 0x00000800 */
#define FDCAN_PSR_RESI            FDCAN_PSR_RESI_Msk                           /*!<ESI flag of last received FDCAN Message  */
#define FDCAN_PSR_RBRS_Pos        (12U)
#define FDCAN_PSR_RBRS_Msk        (0x1UL << FDCAN_PSR_RBRS_Pos)                /*!< 0x00001000 */
#define FDCAN_PSR_RBRS            FDCAN_PSR_RBRS_Msk                           /*!<BRS flag of last received FDCAN Message  */
#define FDCAN_PSR_REDL_Pos        (13U)
#define FDCAN_PSR_REDL_Msk        (0x1UL << FDCAN_PSR_REDL_Pos)                /*!< 0x00002000 */
#define FDCAN_PSR_REDL            FDCAN_PSR_REDL_Msk                           /*!<Received FDCAN Message                   */
#define FDCAN_PSR_PXE_Pos         (14U)
#define FDCAN_PSR_PXE_Msk         (0x1UL << FDCAN_PSR_PXE_Pos)                 /*!< 0x00004000 */
#define FDCAN_PSR_PXE             FDCAN_PSR_PXE_Msk                            /*!<Protocol Exception Event                 */
#define FDCAN_PSR_TDCV_Pos        (16U)
#define FDCAN_PSR_TDCV_Msk        (0x7FUL << FDCAN_PSR_TDCV_Pos)               /*!< 0x007F0000 */
#define FDCAN_PSR_TDCV            FDCAN_PSR_TDCV_Msk                           /*!<Transmitter Delay Compensation Value     */

/*****************  Bit definition for FDCAN_TDCR register  ********************/
#define FDCAN_TDCR_TDCF_Pos       (0U)
#define FDCAN_TDCR_TDCF_Msk       (0x7FUL << FDCAN_TDCR_TDCF_Pos)              /*!< 0x0000007F */
#define FDCAN_TDCR_TDCF           FDCAN_TDCR_TDCF_Msk                          /*!<Transmitter Delay Compensation Filter    */
#define FDCAN_TDCR_TDCO_Pos       (8U)
#define FDCAN_TDCR_TDCO_Msk       (0x7FUL << FDCAN_TDCR_TDCO_Pos)              /*!< 0x00007F00 */
#define FDCAN_TDCR_TDCO           FDCAN_TDCR_TDCO_Msk                          /*!<Transmitter Delay Compensation Offset    */

/*****************  Bit definition for FDCAN_IR register  **********************/
#define FDCAN_IR_RF0N_Pos         (0U)
#define FDCAN_IR_RF0N_Msk         (0x1UL << FDCAN_IR_RF0N_Pos)                 /*!< 0x00000001 */
#define FDCAN_IR_RF0N             FDCAN_IR_RF0N_Msk                            /*!<Rx FIFO 0 New Message                    */
#define FDCAN_IR_RF0W_Pos         (1U)
#define FDCAN_IR_RF0W_Msk         (0x1UL << FDCAN_IR_RF0W_Pos)                 /*!< 0x00000002 */
#define FDCAN_IR_RF0W             FDCAN_IR_RF0W_Msk                            /*!<Rx FIFO 0 Watermark Reached              */
#define FDCAN_IR_RF0F_Pos         (2U)
#define FDCAN_IR_RF0F_Msk         (0x1UL << FDCAN_IR_RF0F_Pos)                 /*!< 0x00000004 */
#define FDCAN_IR_RF0F             FDCAN_IR_RF0F_Msk                            /*!<Rx FIFO 0 Full                           */
#define FDCAN_IR_RF0L_Pos         (3U)
#define FDCAN_IR_RF0L_Msk         (0x1UL << FDCAN_IR_RF0L_Pos)                 /*!< 0x00000008 */
#define FDCAN_IR_RF0L             FDCAN_IR_RF0L_Msk                            /*!<Rx FIFO 0 Message Lost                   */
#define FDCAN_IR_RF1N_Pos         (4U)
#define FDCAN_IR_RF1N_Msk         (0x1UL << FDCAN_IR_RF1N_Pos)                 /*!< 0x00000010 */
#define FDCAN_IR_RF1N             FDCAN_IR_RF1N_Msk                            /*!<Rx FIFO 1 New Message                    */
#define FDCAN_IR_RF1W_Pos         (5U)
#define FDCAN_IR_RF1W_Msk         (0x1UL << FDCAN_IR_RF1W_Pos)                 /*!< 0x00000020 */
#define FDCAN_IR_RF1W             FDCAN_IR_RF1W_Msk                            /*!<Rx FIFO 1 Watermark Reached              */
#define FDCAN_IR_RF1F_Pos         (6U)
#define FDCAN_IR_RF1F_Msk         (0x1UL << FDCAN_IR_RF1F_Pos)                 /*!< 0x00000040 */
#define FDCAN_IR_RF1F             FDCAN_IR_RF1F_Msk                            /*!<Rx FIFO 1 Full                           */
#define FDCAN_IR_RF1L_Pos         (7U)
#define FDCAN_IR_RF1L_Msk         (0x1UL << FDCAN_IR_RF1L_Pos)                 /*!< 0x00000080 */
#define FDCAN_IR_RF1L             FDCAN_IR_RF1L_Msk                            /*!<Rx FIFO 1 Message Lost                   */
#define FDCAN_IR_HPM_Pos          (8U)
#define FDCAN_IR_HPM_Msk          (0x1UL << FDCAN_IR_HPM_Pos)                  /*!< 0x00000100 */
#define FDCAN_IR_HPM              FDCAN_IR_HPM_Msk                             /*!<High Priority Message                    */
#define FDCAN_IR_TC_Pos           (9U)
#define FDCAN_IR_TC_Msk           (0x1UL << FDCAN_IR_TC_Pos)                   /*!< 0x00000200 */
#define FDCAN_IR_TC               FDCAN_IR_TC_Msk                              /*!<Transmission Completed                   */
#define FDCAN_IR_TCF_Pos          (10U)
#define FDCAN_IR_TCF_Msk          (0x1UL << FDCAN_IR_TCF_Pos)                  /*!< 0x00000400 */
#define FDCAN_IR_TCF              FDCAN_IR_TCF_Msk                             /*!<Transmission Cancellation Finished       */
#define FDCAN_IR_TFE_Pos          (11U)
#define FDCAN_IR_TFE_Msk          (0x1UL << FDCAN_IR_TFE_Pos)                  /*!< 0x00000800 */
#define FDCAN_IR_TFE              FDCAN_IR_TFE_Msk                             /*!<Tx FIFO Empty                            */
#define FDCAN_IR_TEFN_Pos         (12U)
#define FDCAN_IR_TEFN_Msk         (0x1UL << FDCAN_IR_TEFN_Pos)                 /*!< 0x00001000 */
#define FDCAN_IR_TEFN             FDCAN_IR_TEFN_Msk                            /*!<Tx Event FIFO New Entry                  */
#define FDCAN_IR_TEFW_Pos         (13U)
#define FDCAN_IR_TEFW_Msk         (0x1UL << FDCAN_IR_TEFW_Pos)                 /*!< 0x00002000 */
#define FDCAN_IR_TEFW             FDCAN_IR_TEFW_Msk                            /*!<Tx Event FIFO Watermark Reached          */
#define FDCAN_IR_TEFF_Pos         (14U)
#define FDCAN_IR_TEFF_Msk         (0x1UL << FDCAN_IR_TEFF_Pos)                 /*!< 0x00004000 */
#define FDCAN_IR_TEFF             FDCAN_IR_TEFF_Msk                            /*!<Tx Event FIFO Full                       */
#define FDCAN_IR_TEFL_Pos         (15U)
#define FDCAN_IR_TEFL_Msk         (0x1UL << FDCAN_IR_TEFL_Pos)                 /*!< 0x00008000 */
#define FDCAN_IR_TEFL             FDCAN_IR_TEFL_Msk                            /*!<Tx Event FIFO Element Lost               */
#define FDCAN_IR_TSW_Pos          (16U)
#define FDCAN_IR_TSW_Msk          (0x1UL << FDCAN_IR_TSW_Pos)                  /*!< 0x00010000 */
#define FDCAN_IR_TSW              FDCAN_IR_TSW_Msk                             /*!<Timestamp Wraparound                     */
#define FDCAN_IR_MRAF_Pos         (17U)
#define FDCAN_IR_MRAF_Msk         (0x1UL << FDCAN_IR_MRAF_Pos)                 /*!< 0x00020000 */
#define FDCAN_IR_MRAF             FDCAN_IR_MRAF_Msk                            /*!<Message RAM Access Failure               */
#define FDCAN_IR_TOO_Pos          (18U)
#define FDCAN_IR_TOO_Msk          (0x1UL << FDCAN_IR_TOO_Pos)                  /*!< 0x00040000 */
#define FDCAN_IR_TOO              FDCAN_IR_TOO_Msk                             /*!<Timeout Occurred                         */
#define FDCAN_IR_DRX_Pos          (19U)
#define FDCAN_IR_DRX_Msk          (0x1UL << FDCAN_IR_DRX_Pos)                  /*!< 0x00080000 */
#define FDCAN_IR_DRX              FDCAN_IR_DRX_Msk                             /*!<Message stored to Dedicated Rx Buffer    */
#define FDCAN_IR_ELO_Pos          (22U)
#define FDCAN_IR_ELO_Msk          (0x1UL << FDCAN_IR_ELO_Pos)                  /*!< 0x00400000 */
#define FDCAN_IR_ELO              FDCAN_IR_ELO_Msk                             /*!<Error Logging Overflow                   */
#define FDCAN_IR_EP_Pos           (23U)
#define FDCAN_IR_EP_Msk           (0x1UL << FDCAN_IR_EP_Pos)                   /*!< 0x00800000 */
#define FDCAN_IR_EP               FDCAN_IR_EP_Msk                              /*!<Error Passive                            */
#define FDCAN_IR_EW_Pos           (24U)
#define FDCAN_IR_EW_Msk           (0x1UL << FDCAN_IR_EW_Pos)                   /*!< 0x01000000 */
#define FDCAN_IR_EW               FDCAN_IR_EW_Msk                              /*!<Warning Status                           */
#define FDCAN_IR_BO_Pos           (25U)
#define FDCAN_IR_BO_Msk           (0x1UL << FDCAN_IR_BO_Pos)                   /*!< 0x02000000 */
#define FDCAN_IR_BO               FDCAN_IR_BO_Msk                              /*!<Bus_Off Status                           */
#define FDCAN_IR_WDI_Pos          (26U)
#define FDCAN_IR_WDI_Msk          (0x1UL << FDCAN_IR_WDI_Pos)                  /*!< 0x04000000 */
#define FDCAN_IR_WDI              FDCAN_IR_WDI_Msk                             /*!<Watchdog Interrupt                       */
#define FDCAN_IR_PEA_Pos          (27U)
#define FDCAN_IR_PEA_Msk          (0x1UL << FDCAN_IR_PEA_Pos)                  /*!< 0x08000000 */
#define FDCAN_IR_PEA              FDCAN_IR_PEA_Msk                             /*!<Protocol Error in Arbitration Phase      */
#define FDCAN_IR_PED_Pos          (28U)
#define FDCAN_IR_PED_Msk          (0x1UL << FDCAN_IR_PED_Pos)                  /*!< 0x10000000 */
#define FDCAN_IR_PED              FDCAN_IR_PED_Msk                             /*!<Protocol Error in Data Phase             */
#define FDCAN_IR_ARA_Pos          (29U)
#define FDCAN_IR_ARA_Msk          (0x1UL << FDCAN_IR_ARA_Pos)                  /*!< 0x20000000 */
#define FDCAN_IR_ARA              FDCAN_IR_ARA_Msk                             /*!<Access to Reserved Address               */

/*****************  Bit definition for FDCAN_IE register  **********************/
#define FDCAN_IE_RF0NE_Pos        (0U)
#define FDCAN_IE_RF0NE_Msk        (0x1UL << FDCAN_IE_RF0NE_Pos)                /*!< 0x00000001 */
#define FDCAN_IE_RF0NE            FDCAN_IE_RF0NE_Msk                           /*!<Rx FIFO 0 New Message Enable                 */
#define FDCAN_IE_RF0WE_Pos        (1U)
#define FDCAN_IE_RF0WE_Msk        (0x1UL << FDCAN_IE_RF0WE_Pos)                /*!< 0x00000002 */
#define FDCAN_IE_RF0WE            FDCAN_IE_RF0WE_Msk                           /*!<Rx FIFO 0 Watermark Reached Enable           */
#define FDCAN_IE_RF0FE_Pos        (2U)
#define FDCAN_IE_RF0FE_Msk        (0x1UL << FDCAN_IE_RF0FE_Pos)                /*!< 0x00000004 */
#define FDCAN_IE_RF0FE            FDCAN_IE_RF0FE_Msk                           /*!<Rx FIFO 0 Full Enable                        */
#define FDCAN_IE_RF0LE_Pos        (3U)
#define FDCAN_IE_RF0LE_Msk        (0x1UL << FDCAN_IE_RF0LE_Pos)                /*!< 0x00000008 */
#define FDCAN_IE_RF0LE            FDCAN_IE_RF0LE_Msk                           /*!<Rx FIFO 0 Message Lost Enable                */
#define FDCAN_IE_RF1NE_Pos        (4U)
#define FDCAN_IE_RF1NE_Msk        (0x1UL << FDCAN_IE_RF1NE_Pos)                /*!< 0x00000010 */
#define FDCAN_IE_RF1NE            FDCAN_IE_RF1NE_Msk                           /*!<Rx FIFO 1 New Message Enable                 */
#define FDCAN_IE_RF1WE_Pos        (5U)
#define FDCAN_IE_RF1WE_Msk        (0x1UL << FDCAN_IE_RF1WE_Pos)                /*!< 0x00000020 */
#define FDCAN_IE_RF1WE            FDCAN_IE_RF1WE_Msk                           /*!<Rx FIFO 1 Watermark Reached Enable           */
#define FDCAN_IE_RF1FE_Pos        (6U)
#define FDCAN_IE_RF1FE_Msk        (0x1UL << FDCAN_IE_RF1FE_Pos)                /*!< 0x00000040 */
#define FDCAN_IE_RF1FE            FDCAN_IE_RF1FE_Msk                           /*!<Rx FIFO 1 Full Enable                        */
#define FDCAN_IE_RF1LE_Pos        (7U)
#define FDCAN_IE_RF1LE_Msk        (0x1UL << FDCAN_IE_RF1LE_Pos)                /*!< 0x00000080 */
#define FDCAN_IE_RF1LE            FDCAN_IE_RF1LE_Msk                           /*!<Rx FIFO 1 Message Lost Enable                */
#define FDCAN_IE_HPME_Pos         (8U)
#define FDCAN_IE_HPME_Msk         (0x1UL << FDCAN_IE_HPME_Pos)                 /*!< 0x00000100 */
#define FDCAN_IE_HPME             FDCAN_IE_HPME_Msk                            /*!<High Priority Message Enable                 */
#define FDCAN_IE_TCE_Pos          (9U)
#define FDCAN_IE_TCE_Msk          (0x1UL << FDCAN_IE_TCE_Pos)                  /*!< 0x00000200 */
#define FDCAN_IE_TCE              FDCAN_IE_TCE_Msk                             /*!<Transmission Completed Enable                */
#define FDCAN_IE_TCFE_Pos         (10U)
#define FDCAN_IE_TCFE_Msk         (0x1UL << FDCAN_IE_TCFE_Pos)                 /*!< 0x00000400 */
#define FDCAN_IE_TCFE             FDCAN_IE_TCFE_Msk                            /*!<Transmission Cancellation Finished Enable    */
#define FDCAN_IE_TFEE_Pos         (11U)
#define FDCAN_IE_TFEE_Msk         (0x1UL << FDCAN_IE_TFEE_Pos)                 /*!< 0x00000800 */
#define FDCAN_IE_TFEE             FDCAN_IE_TFEE_Msk                            /*!<Tx FIFO Empty Enable                         */
#define FDCAN_IE_TEFNE_Pos        (12U)
#define FDCAN_IE_TEFNE_Msk        (0x1UL << FDCAN_IE_TEFNE_Pos)                /*!< 0x00001000 */
#define FDCAN_IE_TEFNE            FDCAN_IE_TEFNE_Msk                           /*!<Tx Event FIFO New Entry Enable               */
#define FDCAN_IE_TEFWE_Pos        (13U)
#define FDCAN_IE_TEFWE_Msk        (0x1UL << FDCAN_IE_TEFWE_Pos)                /*!< 0x00002000 */
#define FDCAN_IE_TEFWE            FDCAN_IE_TEFWE_Msk                           /*!<Tx Event FIFO Watermark Reached Enable       */
#define FDCAN_IE_TEFFE_Pos        (14U)
#define FDCAN_IE_TEFFE_Msk        (0x1UL << FDCAN_IE_TEFFE_Pos)                /*!< 0x00004000 */
#define FDCAN_IE_TEFFE            FDCAN_IE_TEFFE_Msk                           /*!<Tx Event FIFO Full Enable                    */
#define FDCAN_IE_TEFLE_Pos        (15U)
#define FDCAN_IE_TEFLE_Msk        (0x1UL << FDCAN_IE_TEFLE_Pos)                /*!< 0x00008000 */
#define FDCAN_IE_TEFLE            FDCAN_IE_TEFLE_Msk                           /*!<Tx Event FIFO Element Lost Enable            */
#define FDCAN_IE_TSWE_Pos         (16U)
#define FDCAN_IE_TSWE_Msk         (0x1UL << FDCAN_IE_TSWE_Pos)                 /*!< 0x00010000 */
#define FDCAN_IE_TSWE             FDCAN_IE_TSWE_Msk                            /*!<Timestamp Wraparound Enable                  */
#define FDCAN_IE_MRAFE_Pos        (17U)
#define FDCAN_IE_MRAFE_Msk        (0x1UL << FDCAN_IE_MRAFE_Pos)                /*!< 0x00020000 */
#define FDCAN_IE_MRAFE            FDCAN_IE_MRAFE_Msk                           /*!<Message RAM Access Failure Enable            */
#define FDCAN_IE_TOOE_Pos         (18U)
#define FDCAN_IE_TOOE_Msk         (0x1UL << FDCAN_IE_TOOE_Pos)                 /*!< 0x00040000 */
#define FDCAN_IE_TOOE             FDCAN_IE_TOOE_Msk                            /*!<Timeout Occurred Enable                      */
#define FDCAN_IE_DRXE_Pos         (19U)
#define FDCAN_IE_DRXE_Msk         (0x1UL << FDCAN_IE_DRXE_Pos)                 /*!< 0x00080000 */
#define FDCAN_IE_DRXE             FDCAN_IE_DRXE_Msk                            /*!<Message stored to Dedicated Rx Buffer Enable */
#define FDCAN_IE_BECE_Pos         (20U)
#define FDCAN_IE_BECE_Msk         (0x1UL << FDCAN_IE_BECE_Pos)                 /*!< 0x00100000 */
#define FDCAN_IE_BECE             FDCAN_IE_BECE_Msk                            /*!<Bit Error Corrected Interrupt Enable         */
#define FDCAN_IE_BEUE_Pos         (21U)
#define FDCAN_IE_BEUE_Msk         (0x1UL << FDCAN_IE_BEUE_Pos)                 /*!< 0x00200000 */
#define FDCAN_IE_BEUE             FDCAN_IE_BEUE_Msk                            /*!<Bit Error Uncorrected Interrupt Enable       */
#define FDCAN_IE_ELOE_Pos         (22U)
#define FDCAN_IE_ELOE_Msk         (0x1UL << FDCAN_IE_ELOE_Pos)                 /*!< 0x00400000 */
#define FDCAN_IE_ELOE             FDCAN_IE_ELOE_Msk                            /*!<Error Logging Overflow Enable                */
#define FDCAN_IE_EPE_Pos          (23U)
#define FDCAN_IE_EPE_Msk          (0x1UL << FDCAN_IE_EPE_Pos)                  /*!< 0x00800000 */
#define FDCAN_IE_EPE              FDCAN_IE_EPE_Msk                             /*!<Error Passive Enable                         */
#define FDCAN_IE_EWE_Pos          (24U)
#define FDCAN_IE_EWE_Msk          (0x1UL << FDCAN_IE_EWE_Pos)                  /*!< 0x01000000 */
#define FDCAN_IE_EWE              FDCAN_IE_EWE_Msk                             /*!<Warning Status Enable                        */
#define FDCAN_IE_BOE_Pos          (25U)
#define FDCAN_IE_BOE_Msk          (0x1UL << FDCAN_IE_BOE_Pos)                  /*!< 0x02000000 */
#define FDCAN_IE_BOE              FDCAN_IE_BOE_Msk                             /*!<Bus_Off Status Enable                        */
#define FDCAN_IE_WDIE_Pos         (26U)
#define FDCAN_IE_WDIE_Msk         (0x1UL << FDCAN_IE_WDIE_Pos)                 /*!< 0x04000000 */
#define FDCAN_IE_WDIE             FDCAN_IE_WDIE_Msk                            /*!<Watchdog Interrupt Enable                    */
#define FDCAN_IE_PEAE_Pos         (27U)
#define FDCAN_IE_PEAE_Msk         (0x1UL << FDCAN_IE_PEAE_Pos)                 /*!< 0x08000000 */
#define FDCAN_IE_PEAE             FDCAN_IE_PEAE_Msk                            /*!<Protocol Error in Arbitration Phase Enable   */
#define FDCAN_IE_PEDE_Pos         (28U)
#define FDCAN_IE_PEDE_Msk         (0x1UL << FDCAN_IE_PEDE_Pos)                 /*!< 0x10000000 */
#define FDCAN_IE_PEDE             FDCAN_IE_PEDE_Msk                            /*!<Protocol Error in Data Phase Enable          */
#define FDCAN_IE_ARAE_Pos         (29U)
#define FDCAN_IE_ARAE_Msk         (0x1UL << FDCAN_IE_ARAE_Pos)                 /*!< 0x20000000 */
#define FDCAN_IE_ARAE             FDCAN_IE_ARAE_Msk                            /*!<Access to Reserved Address Enable            */

/*****************  Bit definition for FDCAN_ILS register  **********************/
#define FDCAN_ILS_RF0NL_Pos       (0U)
#define FDCAN_ILS_RF0NL_Msk       (0x1UL << FDCAN_ILS_RF0NL_Pos)               /*!< 0x00000001 */
#define FDCAN_ILS_RF0NL           FDCAN_ILS_RF0NL_Msk                          /*!<Rx FIFO 0 New Message Line                  */
#define FDCAN_ILS_RF0WL_Pos       (1U)
#define FDCAN_ILS_RF0WL_Msk       (0x1UL << FDCAN_ILS_RF0WL_Pos)               /*!< 0x00000002 */
#define FDCAN_ILS_RF0WL           FDCAN_ILS_RF0WL_Msk                          /*!<Rx FIFO 0 Watermark Reached Line            */
#define FDCAN_ILS_RF0FL_Pos       (2U)
#define FDCAN_ILS_RF0FL_Msk       (0x1UL << FDCAN_ILS_RF0FL_Pos)               /*!< 0x00000004 */
#define FDCAN_ILS_RF0FL           FDCAN_ILS_RF0FL_Msk                          /*!<Rx FIFO 0 Full Line                         */
#define FDCAN_ILS_RF0LL_Pos       (3U)
#define FDCAN_ILS_RF0LL_Msk       (0x1UL << FDCAN_ILS_RF0LL_Pos)               /*!< 0x00000008 */
#define FDCAN_ILS_RF0LL           FDCAN_ILS_RF0LL_Msk                          /*!<Rx FIFO 0 Message Lost Line                 */
#define FDCAN_ILS_RF1NL_Pos       (4U)
#define FDCAN_ILS_RF1NL_Msk       (0x1UL << FDCAN_ILS_RF1NL_Pos)               /*!< 0x00000010 */
#define FDCAN_ILS_RF1NL           FDCAN_ILS_RF1NL_Msk                          /*!<Rx FIFO 1 New Message Line                  */
#define FDCAN_ILS_RF1WL_Pos       (5U)
#define FDCAN_ILS_RF1WL_Msk       (0x1UL << FDCAN_ILS_RF1WL_Pos)               /*!< 0x00000020 */
#define FDCAN_ILS_RF1WL           FDCAN_ILS_RF1WL_Msk                          /*!<Rx FIFO 1 Watermark Reached Line            */
#define FDCAN_ILS_RF1FL_Pos       (6U)
#define FDCAN_ILS_RF1FL_Msk       (0x1UL << FDCAN_ILS_RF1FL_Pos)               /*!< 0x00000040 */
#define FDCAN_ILS_RF1FL           FDCAN_ILS_RF1FL_Msk                          /*!<Rx FIFO 1 Full Line                         */
#define FDCAN_ILS_RF1LL_Pos       (7U)
#define FDCAN_ILS_RF1LL_Msk       (0x1UL << FDCAN_ILS_RF1LL_Pos)               /*!< 0x00000080 */
#define FDCAN_ILS_RF1LL           FDCAN_ILS_RF1LL_Msk                          /*!<Rx FIFO 1 Message Lost Line                 */
#define FDCAN_ILS_HPML_Pos        (8U)
#define FDCAN_ILS_HPML_Msk        (0x1UL << FDCAN_ILS_HPML_Pos)                /*!< 0x00000100 */
#define FDCAN_ILS_HPML            FDCAN_ILS_HPML_Msk                           /*!<High Priority Message Line                  */
#define FDCAN_ILS_TCL_Pos         (9U)
#define FDCAN_ILS_TCL_Msk         (0x1UL << FDCAN_ILS_TCL_Pos)                 /*!< 0x00000200 */
#define FDCAN_ILS_TCL             FDCAN_ILS_TCL_Msk                            /*!<Transmission Completed Line                 */
#define FDCAN_ILS_TCFL_Pos        (10U)
#define FDCAN_ILS_TCFL_Msk        (0x1UL << FDCAN_ILS_TCFL_Pos)                /*!< 0x00000400 */
#define FDCAN_ILS_TCFL            FDCAN_ILS_TCFL_Msk                           /*!<Transmission Cancellation Finished Line     */
#define FDCAN_ILS_TFEL_Pos        (11U)
#define FDCAN_ILS_TFEL_Msk        (0x1UL << FDCAN_ILS_TFEL_Pos)                /*!< 0x00000800 */
#define FDCAN_ILS_TFEL            FDCAN_ILS_TFEL_Msk                           /*!<Tx FIFO Empty Line                          */
#define FDCAN_ILS_TEFNL_Pos       (12U)
#define FDCAN_ILS_TEFNL_Msk       (0x1UL << FDCAN_ILS_TEFNL_Pos)               /*!< 0x00001000 */
#define FDCAN_ILS_TEFNL           FDCAN_ILS_TEFNL_Msk                          /*!<Tx Event FIFO New Entry Line                */
#define FDCAN_ILS_TEFWL_Pos       (13U)
#define FDCAN_ILS_TEFWL_Msk       (0x1UL << FDCAN_ILS_TEFWL_Pos)               /*!< 0x00002000 */
#define FDCAN_ILS_TEFWL           FDCAN_ILS_TEFWL_Msk                          /*!<Tx Event FIFO Watermark Reached Line        */
#define FDCAN_ILS_TEFFL_Pos       (14U)
#define FDCAN_ILS_TEFFL_Msk       (0x1UL << FDCAN_ILS_TEFFL_Pos)               /*!< 0x00004000 */
#define FDCAN_ILS_TEFFL           FDCAN_ILS_TEFFL_Msk                          /*!<Tx Event FIFO Full Line                     */
#define FDCAN_ILS_TEFLL_Pos       (15U)
#define FDCAN_ILS_TEFLL_Msk       (0x1UL << FDCAN_ILS_TEFLL_Pos)               /*!< 0x00008000 */
#define FDCAN_ILS_TEFLL           FDCAN_ILS_TEFLL_Msk                          /*!<Tx Event FIFO Element Lost Line             */
#define FDCAN_ILS_TSWL_Pos        (16U)
#define FDCAN_ILS_TSWL_Msk        (0x1UL << FDCAN_ILS_TSWL_Pos)                /*!< 0x00010000 */
#define FDCAN_ILS_TSWL            FDCAN_ILS_TSWL_Msk                           /*!<Timestamp Wraparound Line                   */
#define FDCAN_ILS_MRAFE_Pos       (17U)
#define FDCAN_ILS_MRAFE_Msk       (0x1UL << FDCAN_ILS_MRAFE_Pos)               /*!< 0x00020000 */
#define FDCAN_ILS_MRAFE           FDCAN_ILS_MRAFE_Msk                          /*!<Message RAM Access Failure Line             */
#define FDCAN_ILS_TOOE_Pos        (18U)
#define FDCAN_ILS_TOOE_Msk        (0x1UL << FDCAN_ILS_TOOE_Pos)                /*!< 0x00040000 */
#define FDCAN_ILS_TOOE            FDCAN_ILS_TOOE_Msk                           /*!<Timeout Occurred Line                       */
#define FDCAN_ILS_DRXE_Pos        (19U)
#define FDCAN_ILS_DRXE_Msk        (0x1UL << FDCAN_ILS_DRXE_Pos)                /*!< 0x00080000 */
#define FDCAN_ILS_DRXE            FDCAN_ILS_DRXE_Msk                           /*!<Message stored to Dedicated Rx Buffer Line  */
#define FDCAN_ILS_BECE_Pos        (20U)
#define FDCAN_ILS_BECE_Msk        (0x1UL << FDCAN_ILS_BECE_Pos)                /*!< 0x00100000 */
#define FDCAN_ILS_BECE            FDCAN_ILS_BECE_Msk                           /*!<Bit Error Corrected Interrupt Line          */
#define FDCAN_ILS_BEUE_Pos        (21U)
#define FDCAN_ILS_BEUE_Msk        (0x1UL << FDCAN_ILS_BEUE_Pos)                /*!< 0x00200000 */
#define FDCAN_ILS_BEUE            FDCAN_ILS_BEUE_Msk                           /*!<Bit Error Uncorrected Interrupt Line        */
#define FDCAN_ILS_ELOE_Pos        (22U)
#define FDCAN_ILS_ELOE_Msk        (0x1UL << FDCAN_ILS_ELOE_Pos)                /*!< 0x00400000 */
#define FDCAN_ILS_ELOE            FDCAN_ILS_ELOE_Msk                           /*!<Error Logging Overflow Line                 */
#define FDCAN_ILS_EPE_Pos         (23U)
#define FDCAN_ILS_EPE_Msk         (0x1UL << FDCAN_ILS_EPE_Pos)                 /*!< 0x00800000 */
#define FDCAN_ILS_EPE             FDCAN_ILS_EPE_Msk                            /*!<Error Passive Line                          */
#define FDCAN_ILS_EWE_Pos         (24U)
#define FDCAN_ILS_EWE_Msk         (0x1UL << FDCAN_ILS_EWE_Pos)                 /*!< 0x01000000 */
#define FDCAN_ILS_EWE             FDCAN_ILS_EWE_Msk                            /*!<Warning Status Line                         */
#define FDCAN_ILS_BOE_Pos         (25U)
#define FDCAN_ILS_BOE_Msk         (0x1UL << FDCAN_ILS_BOE_Pos)                 /*!< 0x02000000 */
#define FDCAN_ILS_BOE             FDCAN_ILS_BOE_Msk                            /*!<Bus_Off Status Line                         */
#define FDCAN_ILS_WDIE_Pos        (26U)
#define FDCAN_ILS_WDIE_Msk        (0x1UL << FDCAN_ILS_WDIE_Pos)                /*!< 0x04000000 */
#define FDCAN_ILS_WDIE            FDCAN_ILS_WDIE_Msk                           /*!<Watchdog Interrupt Line                     */
#define FDCAN_ILS_PEAE_Pos        (27U)
#define FDCAN_ILS_PEAE_Msk        (0x1UL << FDCAN_ILS_PEAE_Pos)                /*!< 0x08000000 */
#define FDCAN_ILS_PEAE            FDCAN_ILS_PEAE_Msk                           /*!<Protocol Error in Arbitration Phase Line    */
#define FDCAN_ILS_PEDE_Pos        (28U)
#define FDCAN_ILS_PEDE_Msk        (0x1UL << FDCAN_ILS_PEDE_Pos)                /*!< 0x10000000 */
#define FDCAN_ILS_PEDE            FDCAN_ILS_PEDE_Msk                           /*!<Protocol Error in Data Phase Line           */
#define FDCAN_ILS_ARAE_Pos        (29U)
#define FDCAN_ILS_ARAE_Msk        (0x1UL << FDCAN_ILS_ARAE_Pos)                /*!< 0x20000000 */
#define FDCAN_ILS_ARAE            FDCAN_ILS_ARAE_Msk                           /*!<Access to Reserved Address Line             */

/*****************  Bit definition for FDCAN_ILE register  **********************/
#define FDCAN_ILE_EINT0_Pos       (0U)
#define FDCAN_ILE_EINT0_Msk       (0x1UL << FDCAN_ILE_EINT0_Pos)               /*!< 0x00000001 */
#define FDCAN_ILE_EINT0           FDCAN_ILE_EINT0_Msk                          /*!<Enable Interrupt Line 0                   */
#define FDCAN_ILE_EINT1_Pos       (1U)
#define FDCAN_ILE_EINT1_Msk       (0x1UL << FDCAN_ILE_EINT1_Pos)               /*!< 0x00000002 */
#define FDCAN_ILE_EINT1           FDCAN_ILE_EINT1_Msk                          /*!<Enable Interrupt Line 1                   */

/*****************  Bit definition for FDCAN_GFC register  **********************/
#define FDCAN_GFC_RRFE_Pos        (0U)
#define FDCAN_GFC_RRFE_Msk        (0x1UL << FDCAN_GFC_RRFE_Pos)                /*!< 0x00000001 */
#define FDCAN_GFC_RRFE            FDCAN_GFC_RRFE_Msk                           /*!<Reject Remote Frames Extended             */
#define FDCAN_GFC_RRFS_Pos        (1U)
#define FDCAN_GFC_RRFS_Msk        (0x1UL << FDCAN_GFC_RRFS_Pos)                /*!< 0x00000002 */
#define FDCAN_GFC_RRFS            FDCAN_GFC_RRFS_Msk                           /*!<Reject Remote Frames Standard             */
#define FDCAN_GFC_ANFE_Pos        (2U)
#define FDCAN_GFC_ANFE_Msk        (0x3UL << FDCAN_GFC_ANFE_Pos)                /*!< 0x0000000C */
#define FDCAN_GFC_ANFE            FDCAN_GFC_ANFE_Msk                           /*!<Accept Non-matching Frames Extended       */
#define FDCAN_GFC_ANFS_Pos        (4U)
#define FDCAN_GFC_ANFS_Msk        (0x3UL << FDCAN_GFC_ANFS_Pos)                /*!< 0x00000030 */
#define FDCAN_GFC_ANFS            FDCAN_GFC_ANFS_Msk                           /*!<Accept Non-matching Frames Standard       */

/*****************  Bit definition for FDCAN_SIDFC register  ********************/
#define FDCAN_SIDFC_FLSSA_Pos     (2U)
#define FDCAN_SIDFC_FLSSA_Msk     (0x3FFFUL << FDCAN_SIDFC_FLSSA_Pos)          /*!< 0x0000FFFC */
#define FDCAN_SIDFC_FLSSA         FDCAN_SIDFC_FLSSA_Msk                        /*!<Filter List Standard Start Address        */
#define FDCAN_SIDFC_LSS_Pos       (16U)
#define FDCAN_SIDFC_LSS_Msk       (0xFFUL << FDCAN_SIDFC_LSS_Pos)              /*!< 0x00FF0000 */
#define FDCAN_SIDFC_LSS           FDCAN_SIDFC_LSS_Msk                          /*!<List Size Standard                        */

/*****************  Bit definition for FDCAN_XIDFC register  ********************/
#define FDCAN_XIDFC_FLESA_Pos     (2U)
#define FDCAN_XIDFC_FLESA_Msk     (0x3FFFUL << FDCAN_XIDFC_FLESA_Pos)          /*!< 0x0000FFFC */
#define FDCAN_XIDFC_FLESA         FDCAN_XIDFC_FLESA_Msk                        /*!<Filter List Standard Start Address        */
#define FDCAN_XIDFC_LSE_Pos       (16U)
#define FDCAN_XIDFC_LSE_Msk       (0x7FUL << FDCAN_XIDFC_LSE_Pos)              /*!< 0x007F0000 */
#define FDCAN_XIDFC_LSE           FDCAN_XIDFC_LSE_Msk                          /*!<List Size Extended                        */

/*****************  Bit definition for FDCAN_XIDAM register  ********************/
#define FDCAN_XIDAM_EIDM_Pos      (0U)
#define FDCAN_XIDAM_EIDM_Msk      (0x1FFFFFFFUL << FDCAN_XIDAM_EIDM_Pos)       /*!< 0x1FFFFFFF */
#define FDCAN_XIDAM_EIDM          FDCAN_XIDAM_EIDM_Msk                         /*!<Extended ID Mask                          */

/*****************  Bit definition for FDCAN_HPMS register  *********************/
#define FDCAN_HPMS_BIDX_Pos       (0U)
#define FDCAN_HPMS_BIDX_Msk       (0x3FUL << FDCAN_HPMS_BIDX_Pos)              /*!< 0x0000003F */
#define FDCAN_HPMS_BIDX           FDCAN_HPMS_BIDX_Msk                          /*!<Buffer Index                              */
#define FDCAN_HPMS_MSI_Pos        (6U)
#define FDCAN_HPMS_MSI_Msk        (0x3UL << FDCAN_HPMS_MSI_Pos)                /*!< 0x000000C0 */
#define FDCAN_HPMS_MSI            FDCAN_HPMS_MSI_Msk                           /*!<Message Storage Indicator                 */
#define FDCAN_HPMS_FIDX_Pos       (8U)
#define FDCAN_HPMS_FIDX_Msk       (0x7FUL << FDCAN_HPMS_FIDX_Pos)              /*!< 0x00007F00 */
#define FDCAN_HPMS_FIDX           FDCAN_HPMS_FIDX_Msk                          /*!<Filter Index                              */
#define FDCAN_HPMS_FLST_Pos       (15U)
#define FDCAN_HPMS_FLST_Msk       (0x1UL << FDCAN_HPMS_FLST_Pos)               /*!< 0x00008000 */
#define FDCAN_HPMS_FLST           FDCAN_HPMS_FLST_Msk                          /*!<Filter List                               */

/*****************  Bit definition for FDCAN_NDAT1 register  ********************/
#define FDCAN_NDAT1_ND0_Pos       (0U)
#define FDCAN_NDAT1_ND0_Msk       (0x1UL << FDCAN_NDAT1_ND0_Pos)               /*!< 0x00000001 */
#define FDCAN_NDAT1_ND0           FDCAN_NDAT1_ND0_Msk                          /*!<New Data flag of Rx Buffer 0              */
#define FDCAN_NDAT1_ND1_Pos       (1U)
#define FDCAN_NDAT1_ND1_Msk       (0x1UL << FDCAN_NDAT1_ND1_Pos)               /*!< 0x00000002 */
#define FDCAN_NDAT1_ND1           FDCAN_NDAT1_ND1_Msk                          /*!<New Data flag of Rx Buffer 1              */
#define FDCAN_NDAT1_ND2_Pos       (2U)
#define FDCAN_NDAT1_ND2_Msk       (0x1UL << FDCAN_NDAT1_ND2_Pos)               /*!< 0x00000004 */
#define FDCAN_NDAT1_ND2           FDCAN_NDAT1_ND2_Msk                          /*!<New Data flag of Rx Buffer 2              */
#define FDCAN_NDAT1_ND3_Pos       (3U)
#define FDCAN_NDAT1_ND3_Msk       (0x1UL << FDCAN_NDAT1_ND3_Pos)               /*!< 0x00000008 */
#define FDCAN_NDAT1_ND3           FDCAN_NDAT1_ND3_Msk                          /*!<New Data flag of Rx Buffer 3              */
#define FDCAN_NDAT1_ND4_Pos       (4U)
#define FDCAN_NDAT1_ND4_Msk       (0x1UL << FDCAN_NDAT1_ND4_Pos)               /*!< 0x00000010 */
#define FDCAN_NDAT1_ND4           FDCAN_NDAT1_ND4_Msk                          /*!<New Data flag of Rx Buffer 4              */
#define FDCAN_NDAT1_ND5_Pos       (5U)
#define FDCAN_NDAT1_ND5_Msk       (0x1UL << FDCAN_NDAT1_ND5_Pos)               /*!< 0x00000020 */
#define FDCAN_NDAT1_ND5           FDCAN_NDAT1_ND5_Msk                          /*!<New Data flag of Rx Buffer 5              */
#define FDCAN_NDAT1_ND6_Pos       (6U)
#define FDCAN_NDAT1_ND6_Msk       (0x1UL << FDCAN_NDAT1_ND6_Pos)               /*!< 0x00000040 */
#define FDCAN_NDAT1_ND6           FDCAN_NDAT1_ND6_Msk                          /*!<New Data flag of Rx Buffer 6              */
#define FDCAN_NDAT1_ND7_Pos       (7U)
#define FDCAN_NDAT1_ND7_Msk       (0x1UL << FDCAN_NDAT1_ND7_Pos)               /*!< 0x00000080 */
#define FDCAN_NDAT1_ND7           FDCAN_NDAT1_ND7_Msk                          /*!<New Data flag of Rx Buffer 7              */
#define FDCAN_NDAT1_ND8_Pos       (8U)
#define FDCAN_NDAT1_ND8_Msk       (0x1UL << FDCAN_NDAT1_ND8_Pos)               /*!< 0x00000100 */
#define FDCAN_NDAT1_ND8           FDCAN_NDAT1_ND8_Msk                          /*!<New Data flag of Rx Buffer 8              */
#define FDCAN_NDAT1_ND9_Pos       (9U)
#define FDCAN_NDAT1_ND9_Msk       (0x1UL << FDCAN_NDAT1_ND9_Pos)               /*!< 0x00000200 */
#define FDCAN_NDAT1_ND9           FDCAN_NDAT1_ND9_Msk                          /*!<New Data flag of Rx Buffer 9              */
#define FDCAN_NDAT1_ND10_Pos      (10U)
#define FDCAN_NDAT1_ND10_Msk      (0x1UL << FDCAN_NDAT1_ND10_Pos)              /*!< 0x00000400 */
#define FDCAN_NDAT1_ND10          FDCAN_NDAT1_ND10_Msk                         /*!<New Data flag of Rx Buffer 10             */
#define FDCAN_NDAT1_ND11_Pos      (11U)
#define FDCAN_NDAT1_ND11_Msk      (0x1UL << FDCAN_NDAT1_ND11_Pos)              /*!< 0x00000800 */
#define FDCAN_NDAT1_ND11          FDCAN_NDAT1_ND11_Msk                         /*!<New Data flag of Rx Buffer 11             */
#define FDCAN_NDAT1_ND12_Pos      (12U)
#define FDCAN_NDAT1_ND12_Msk      (0x1UL << FDCAN_NDAT1_ND12_Pos)              /*!< 0x00001000 */
#define FDCAN_NDAT1_ND12          FDCAN_NDAT1_ND12_Msk                         /*!<New Data flag of Rx Buffer 12             */
#define FDCAN_NDAT1_ND13_Pos      (13U)
#define FDCAN_NDAT1_ND13_Msk      (0x1UL << FDCAN_NDAT1_ND13_Pos)              /*!< 0x00002000 */
#define FDCAN_NDAT1_ND13          FDCAN_NDAT1_ND13_Msk                         /*!<New Data flag of Rx Buffer 13             */
#define FDCAN_NDAT1_ND14_Pos      (14U)
#define FDCAN_NDAT1_ND14_Msk      (0x1UL << FDCAN_NDAT1_ND14_Pos)              /*!< 0x00004000 */
#define FDCAN_NDAT1_ND14          FDCAN_NDAT1_ND14_Msk                         /*!<New Data flag of Rx Buffer 14             */
#define FDCAN_NDAT1_ND15_Pos      (15U)
#define FDCAN_NDAT1_ND15_Msk      (0x1UL << FDCAN_NDAT1_ND15_Pos)              /*!< 0x00008000 */
#define FDCAN_NDAT1_ND15          FDCAN_NDAT1_ND15_Msk                         /*!<New Data flag of Rx Buffer 15             */
#define FDCAN_NDAT1_ND16_Pos      (16U)
#define FDCAN_NDAT1_ND16_Msk      (0x1UL << FDCAN_NDAT1_ND16_Pos)              /*!< 0x00010000 */
#define FDCAN_NDAT1_ND16          FDCAN_NDAT1_ND16_Msk                         /*!<New Data flag of Rx Buffer 16             */
#define FDCAN_NDAT1_ND17_Pos      (17U)
#define FDCAN_NDAT1_ND17_Msk      (0x1UL << FDCAN_NDAT1_ND17_Pos)              /*!< 0x00020000 */
#define FDCAN_NDAT1_ND17          FDCAN_NDAT1_ND17_Msk                         /*!<New Data flag of Rx Buffer 17             */
#define FDCAN_NDAT1_ND18_Pos      (18U)
#define FDCAN_NDAT1_ND18_Msk      (0x1UL << FDCAN_NDAT1_ND18_Pos)              /*!< 0x00040000 */
#define FDCAN_NDAT1_ND18          FDCAN_NDAT1_ND18_Msk                         /*!<New Data flag of Rx Buffer 18             */
#define FDCAN_NDAT1_ND19_Pos      (19U)
#define FDCAN_NDAT1_ND19_Msk      (0x1UL << FDCAN_NDAT1_ND19_Pos)              /*!< 0x00080000 */
#define FDCAN_NDAT1_ND19          FDCAN_NDAT1_ND19_Msk                         /*!<New Data flag of Rx Buffer 19             */
#define FDCAN_NDAT1_ND20_Pos      (20U)
#define FDCAN_NDAT1_ND20_Msk      (0x1UL << FDCAN_NDAT1_ND20_Pos)              /*!< 0x00100000 */
#define FDCAN_NDAT1_ND20          FDCAN_NDAT1_ND20_Msk                         /*!<New Data flag of Rx Buffer 20             */
#define FDCAN_NDAT1_ND21_Pos      (21U)
#define FDCAN_NDAT1_ND21_Msk      (0x1UL << FDCAN_NDAT1_ND21_Pos)              /*!< 0x00200000 */
#define FDCAN_NDAT1_ND21          FDCAN_NDAT1_ND21_Msk                         /*!<New Data flag of Rx Buffer 21             */
#define FDCAN_NDAT1_ND22_Pos      (22U)
#define FDCAN_NDAT1_ND22_Msk      (0x1UL << FDCAN_NDAT1_ND22_Pos)              /*!< 0x00400000 */
#define FDCAN_NDAT1_ND22          FDCAN_NDAT1_ND22_Msk                         /*!<New Data flag of Rx Buffer 22             */
#define FDCAN_NDAT1_ND23_Pos      (23U)
#define FDCAN_NDAT1_ND23_Msk      (0x1UL << FDCAN_NDAT1_ND23_Pos)              /*!< 0x00800000 */
#define FDCAN_NDAT1_ND23          FDCAN_NDAT1_ND23_Msk                         /*!<New Data flag of Rx Buffer 23             */
#define FDCAN_NDAT1_ND24_Pos      (24U)
#define FDCAN_NDAT1_ND24_Msk      (0x1UL << FDCAN_NDAT1_ND24_Pos)              /*!< 0x01000000 */
#define FDCAN_NDAT1_ND24          FDCAN_NDAT1_ND24_Msk                         /*!<New Data flag of Rx Buffer 24             */
#define FDCAN_NDAT1_ND25_Pos      (25U)
#define FDCAN_NDAT1_ND25_Msk      (0x1UL << FDCAN_NDAT1_ND25_Pos)              /*!< 0x02000000 */
#define FDCAN_NDAT1_ND25          FDCAN_NDAT1_ND25_Msk                         /*!<New Data flag of Rx Buffer 25             */
#define FDCAN_NDAT1_ND26_Pos      (26U)
#define FDCAN_NDAT1_ND26_Msk      (0x1UL << FDCAN_NDAT1_ND26_Pos)              /*!< 0x04000000 */
#define FDCAN_NDAT1_ND26          FDCAN_NDAT1_ND26_Msk                         /*!<New Data flag of Rx Buffer 26             */
#define FDCAN_NDAT1_ND27_Pos      (27U)
#define FDCAN_NDAT1_ND27_Msk      (0x1UL << FDCAN_NDAT1_ND27_Pos)              /*!< 0x08000000 */
#define FDCAN_NDAT1_ND27          FDCAN_NDAT1_ND27_Msk                         /*!<New Data flag of Rx Buffer 27             */
#define FDCAN_NDAT1_ND28_Pos      (28U)
#define FDCAN_NDAT1_ND28_Msk      (0x1UL << FDCAN_NDAT1_ND28_Pos)              /*!< 0x10000000 */
#define FDCAN_NDAT1_ND28          FDCAN_NDAT1_ND28_Msk                         /*!<New Data flag of Rx Buffer 28             */
#define FDCAN_NDAT1_ND29_Pos      (29U)
#define FDCAN_NDAT1_ND29_Msk      (0x1UL << FDCAN_NDAT1_ND29_Pos)              /*!< 0x20000000 */
#define FDCAN_NDAT1_ND29          FDCAN_NDAT1_ND29_Msk                         /*!<New Data flag of Rx Buffer 29             */
#define FDCAN_NDAT1_ND30_Pos      (30U)
#define FDCAN_NDAT1_ND30_Msk      (0x1UL << FDCAN_NDAT1_ND30_Pos)              /*!< 0x40000000 */
#define FDCAN_NDAT1_ND30          FDCAN_NDAT1_ND30_Msk                         /*!<New Data flag of Rx Buffer 30             */
#define FDCAN_NDAT1_ND31_Pos      (31U)
#define FDCAN_NDAT1_ND31_Msk      (0x1UL << FDCAN_NDAT1_ND31_Pos)              /*!< 0x80000000 */
#define FDCAN_NDAT1_ND31          FDCAN_NDAT1_ND31_Msk                         /*!<New Data flag of Rx Buffer 31             */

/*****************  Bit definition for FDCAN_NDAT2 register  ********************/
#define FDCAN_NDAT2_ND32_Pos      (0U)
#define FDCAN_NDAT2_ND32_Msk      (0x1UL << FDCAN_NDAT2_ND32_Pos)              /*!< 0x00000001 */
#define FDCAN_NDAT2_ND32          FDCAN_NDAT2_ND32_Msk                         /*!<New Data flag of Rx Buffer 32             */
#define FDCAN_NDAT2_ND33_Pos      (1U)
#define FDCAN_NDAT2_ND33_Msk      (0x1UL << FDCAN_NDAT2_ND33_Pos)              /*!< 0x00000002 */
#define FDCAN_NDAT2_ND33          FDCAN_NDAT2_ND33_Msk                         /*!<New Data flag of Rx Buffer 33             */
#define FDCAN_NDAT2_ND34_Pos      (2U)
#define FDCAN_NDAT2_ND34_Msk      (0x1UL << FDCAN_NDAT2_ND34_Pos)              /*!< 0x00000004 */
#define FDCAN_NDAT2_ND34          FDCAN_NDAT2_ND34_Msk                         /*!<New Data flag of Rx Buffer 34             */
#define FDCAN_NDAT2_ND35_Pos      (3U)
#define FDCAN_NDAT2_ND35_Msk      (0x1UL << FDCAN_NDAT2_ND35_Pos)              /*!< 0x00000008 */
#define FDCAN_NDAT2_ND35          FDCAN_NDAT2_ND35_Msk                         /*!<New Data flag of Rx Buffer 35             */
#define FDCAN_NDAT2_ND36_Pos      (4U)
#define FDCAN_NDAT2_ND36_Msk      (0x1UL << FDCAN_NDAT2_ND36_Pos)              /*!< 0x00000010 */
#define FDCAN_NDAT2_ND36          FDCAN_NDAT2_ND36_Msk                         /*!<New Data flag of Rx Buffer 36             */
#define FDCAN_NDAT2_ND37_Pos      (5U)
#define FDCAN_NDAT2_ND37_Msk      (0x1UL << FDCAN_NDAT2_ND37_Pos)              /*!< 0x00000020 */
#define FDCAN_NDAT2_ND37          FDCAN_NDAT2_ND37_Msk                         /*!<New Data flag of Rx Buffer 37             */
#define FDCAN_NDAT2_ND38_Pos      (6U)
#define FDCAN_NDAT2_ND38_Msk      (0x1UL << FDCAN_NDAT2_ND38_Pos)              /*!< 0x00000040 */
#define FDCAN_NDAT2_ND38          FDCAN_NDAT2_ND38_Msk                         /*!<New Data flag of Rx Buffer 38             */
#define FDCAN_NDAT2_ND39_Pos      (7U)
#define FDCAN_NDAT2_ND39_Msk      (0x1UL << FDCAN_NDAT2_ND39_Pos)              /*!< 0x00000080 */
#define FDCAN_NDAT2_ND39          FDCAN_NDAT2_ND39_Msk                         /*!<New Data flag of Rx Buffer 39             */
#define FDCAN_NDAT2_ND40_Pos      (8U)
#define FDCAN_NDAT2_ND40_Msk      (0x1UL << FDCAN_NDAT2_ND40_Pos)              /*!< 0x00000100 */
#define FDCAN_NDAT2_ND40          FDCAN_NDAT2_ND40_Msk                         /*!<New Data flag of Rx Buffer 40             */
#define FDCAN_NDAT2_ND41_Pos      (9U)
#define FDCAN_NDAT2_ND41_Msk      (0x1UL << FDCAN_NDAT2_ND41_Pos)              /*!< 0x00000200 */
#define FDCAN_NDAT2_ND41          FDCAN_NDAT2_ND41_Msk                         /*!<New Data flag of Rx Buffer 41             */
#define FDCAN_NDAT2_ND42_Pos      (10U)
#define FDCAN_NDAT2_ND42_Msk      (0x1UL << FDCAN_NDAT2_ND42_Pos)              /*!< 0x00000400 */
#define FDCAN_NDAT2_ND42          FDCAN_NDAT2_ND42_Msk                         /*!<New Data flag of Rx Buffer 42             */
#define FDCAN_NDAT2_ND43_Pos      (11U)
#define FDCAN_NDAT2_ND43_Msk      (0x1UL << FDCAN_NDAT2_ND43_Pos)              /*!< 0x00000800 */
#define FDCAN_NDAT2_ND43          FDCAN_NDAT2_ND43_Msk                         /*!<New Data flag of Rx Buffer 43             */
#define FDCAN_NDAT2_ND44_Pos      (12U)
#define FDCAN_NDAT2_ND44_Msk      (0x1UL << FDCAN_NDAT2_ND44_Pos)              /*!< 0x00001000 */
#define FDCAN_NDAT2_ND44          FDCAN_NDAT2_ND44_Msk                         /*!<New Data flag of Rx Buffer 44             */
#define FDCAN_NDAT2_ND45_Pos      (13U)
#define FDCAN_NDAT2_ND45_Msk      (0x1UL << FDCAN_NDAT2_ND45_Pos)              /*!< 0x00002000 */
#define FDCAN_NDAT2_ND45          FDCAN_NDAT2_ND45_Msk                         /*!<New Data flag of Rx Buffer 45             */
#define FDCAN_NDAT2_ND46_Pos      (14U)
#define FDCAN_NDAT2_ND46_Msk      (0x1UL << FDCAN_NDAT2_ND46_Pos)              /*!< 0x00004000 */
#define FDCAN_NDAT2_ND46          FDCAN_NDAT2_ND46_Msk                         /*!<New Data flag of Rx Buffer 46             */
#define FDCAN_NDAT2_ND47_Pos      (15U)
#define FDCAN_NDAT2_ND47_Msk      (0x1UL << FDCAN_NDAT2_ND47_Pos)              /*!< 0x00008000 */
#define FDCAN_NDAT2_ND47          FDCAN_NDAT2_ND47_Msk                         /*!<New Data flag of Rx Buffer 47             */
#define FDCAN_NDAT2_ND48_Pos      (16U)
#define FDCAN_NDAT2_ND48_Msk      (0x1UL << FDCAN_NDAT2_ND48_Pos)              /*!< 0x00010000 */
#define FDCAN_NDAT2_ND48          FDCAN_NDAT2_ND48_Msk                         /*!<New Data flag of Rx Buffer 48             */
#define FDCAN_NDAT2_ND49_Pos      (17U)
#define FDCAN_NDAT2_ND49_Msk      (0x1UL << FDCAN_NDAT2_ND49_Pos)              /*!< 0x00020000 */
#define FDCAN_NDAT2_ND49          FDCAN_NDAT2_ND49_Msk                         /*!<New Data flag of Rx Buffer 49             */
#define FDCAN_NDAT2_ND50_Pos      (18U)
#define FDCAN_NDAT2_ND50_Msk      (0x1UL << FDCAN_NDAT2_ND50_Pos)              /*!< 0x00040000 */
#define FDCAN_NDAT2_ND50          FDCAN_NDAT2_ND50_Msk                         /*!<New Data flag of Rx Buffer 50             */
#define FDCAN_NDAT2_ND51_Pos      (19U)
#define FDCAN_NDAT2_ND51_Msk      (0x1UL << FDCAN_NDAT2_ND51_Pos)              /*!< 0x00080000 */
#define FDCAN_NDAT2_ND51          FDCAN_NDAT2_ND51_Msk                         /*!<New Data flag of Rx Buffer 51             */
#define FDCAN_NDAT2_ND52_Pos      (20U)
#define FDCAN_NDAT2_ND52_Msk      (0x1UL << FDCAN_NDAT2_ND52_Pos)              /*!< 0x00100000 */
#define FDCAN_NDAT2_ND52          FDCAN_NDAT2_ND52_Msk                         /*!<New Data flag of Rx Buffer 52             */
#define FDCAN_NDAT2_ND53_Pos      (21U)
#define FDCAN_NDAT2_ND53_Msk      (0x1UL << FDCAN_NDAT2_ND53_Pos)              /*!< 0x00200000 */
#define FDCAN_NDAT2_ND53          FDCAN_NDAT2_ND53_Msk                         /*!<New Data flag of Rx Buffer 53             */
#define FDCAN_NDAT2_ND54_Pos      (22U)
#define FDCAN_NDAT2_ND54_Msk      (0x1UL << FDCAN_NDAT2_ND54_Pos)              /*!< 0x00400000 */
#define FDCAN_NDAT2_ND54          FDCAN_NDAT2_ND54_Msk                         /*!<New Data flag of Rx Buffer 54             */
#define FDCAN_NDAT2_ND55_Pos      (23U)
#define FDCAN_NDAT2_ND55_Msk      (0x1UL << FDCAN_NDAT2_ND55_Pos)              /*!< 0x00800000 */
#define FDCAN_NDAT2_ND55          FDCAN_NDAT2_ND55_Msk                         /*!<New Data flag of Rx Buffer 55             */
#define FDCAN_NDAT2_ND56_Pos      (24U)
#define FDCAN_NDAT2_ND56_Msk      (0x1UL << FDCAN_NDAT2_ND56_Pos)              /*!< 0x01000000 */
#define FDCAN_NDAT2_ND56          FDCAN_NDAT2_ND56_Msk                         /*!<New Data flag of Rx Buffer 56             */
#define FDCAN_NDAT2_ND57_Pos      (25U)
#define FDCAN_NDAT2_ND57_Msk      (0x1UL << FDCAN_NDAT2_ND57_Pos)              /*!< 0x02000000 */
#define FDCAN_NDAT2_ND57          FDCAN_NDAT2_ND57_Msk                         /*!<New Data flag of Rx Buffer 57             */
#define FDCAN_NDAT2_ND58_Pos      (26U)
#define FDCAN_NDAT2_ND58_Msk      (0x1UL << FDCAN_NDAT2_ND58_Pos)              /*!< 0x04000000 */
#define FDCAN_NDAT2_ND58          FDCAN_NDAT2_ND58_Msk                         /*!<New Data flag of Rx Buffer 58             */
#define FDCAN_NDAT2_ND59_Pos      (27U)
#define FDCAN_NDAT2_ND59_Msk      (0x1UL << FDCAN_NDAT2_ND59_Pos)              /*!< 0x08000000 */
#define FDCAN_NDAT2_ND59          FDCAN_NDAT2_ND59_Msk                         /*!<New Data flag of Rx Buffer 59             */
#define FDCAN_NDAT2_ND60_Pos      (28U)
#define FDCAN_NDAT2_ND60_Msk      (0x1UL << FDCAN_NDAT2_ND60_Pos)              /*!< 0x10000000 */
#define FDCAN_NDAT2_ND60          FDCAN_NDAT2_ND60_Msk                         /*!<New Data flag of Rx Buffer 60             */
#define FDCAN_NDAT2_ND61_Pos      (29U)
#define FDCAN_NDAT2_ND61_Msk      (0x1UL << FDCAN_NDAT2_ND61_Pos)              /*!< 0x20000000 */
#define FDCAN_NDAT2_ND61          FDCAN_NDAT2_ND61_Msk                         /*!<New Data flag of Rx Buffer 61             */
#define FDCAN_NDAT2_ND62_Pos      (30U)
#define FDCAN_NDAT2_ND62_Msk      (0x1UL << FDCAN_NDAT2_ND62_Pos)              /*!< 0x40000000 */
#define FDCAN_NDAT2_ND62          FDCAN_NDAT2_ND62_Msk                         /*!<New Data flag of Rx Buffer 62             */
#define FDCAN_NDAT2_ND63_Pos      (31U)
#define FDCAN_NDAT2_ND63_Msk      (0x1UL << FDCAN_NDAT2_ND63_Pos)              /*!< 0x80000000 */
#define FDCAN_NDAT2_ND63          FDCAN_NDAT2_ND63_Msk                         /*!<New Data flag of Rx Buffer 63             */

/*****************  Bit definition for FDCAN_RXF0C register  ********************/
#define FDCAN_RXF0C_F0SA_Pos      (2U)
#define FDCAN_RXF0C_F0SA_Msk      (0x3FFFUL << FDCAN_RXF0C_F0SA_Pos)           /*!< 0x0000FFFC */
#define FDCAN_RXF0C_F0SA          FDCAN_RXF0C_F0SA_Msk                         /*!<Rx FIFO 0 Start Address                   */
#define FDCAN_RXF0C_F0S_Pos       (16U)
#define FDCAN_RXF0C_F0S_Msk       (0x7FUL << FDCAN_RXF0C_F0S_Pos)              /*!< 0x007F0000 */
#define FDCAN_RXF0C_F0S           FDCAN_RXF0C_F0S_Msk                          /*!<Number of Rx FIFO 0 elements              */
#define FDCAN_RXF0C_F0WM_Pos      (24U)
#define FDCAN_RXF0C_F0WM_Msk      (0x7FUL << FDCAN_RXF0C_F0WM_Pos)             /*!< 0x7F000000 */
#define FDCAN_RXF0C_F0WM          FDCAN_RXF0C_F0WM_Msk                         /*!<FIFO 0 Watermark                          */
#define FDCAN_RXF0C_F0OM_Pos      (31U)
#define FDCAN_RXF0C_F0OM_Msk      (0x1UL << FDCAN_RXF0C_F0OM_Pos)              /*!< 0x80000000 */
#define FDCAN_RXF0C_F0OM          FDCAN_RXF0C_F0OM_Msk                         /*!<FIFO 0 Operation Mode                     */

/*****************  Bit definition for FDCAN_RXF0S register  ********************/
#define FDCAN_RXF0S_F0FL_Pos      (0U)
#define FDCAN_RXF0S_F0FL_Msk      (0x7FUL << FDCAN_RXF0S_F0FL_Pos)             /*!< 0x0000007F */
#define FDCAN_RXF0S_F0FL          FDCAN_RXF0S_F0FL_Msk                         /*!<Rx FIFO 0 Fill Level                      */
#define FDCAN_RXF0S_F0GI_Pos      (8U)
#define FDCAN_RXF0S_F0GI_Msk      (0x3FUL << FDCAN_RXF0S_F0GI_Pos)             /*!< 0x00003F00 */
#define FDCAN_RXF0S_F0GI          FDCAN_RXF0S_F0GI_Msk                         /*!<Rx FIFO 0 Get Index                       */
#define FDCAN_RXF0S_F0PI_Pos      (16U)
#define FDCAN_RXF0S_F0PI_Msk      (0x3FUL << FDCAN_RXF0S_F0PI_Pos)             /*!< 0x003F0000 */
#define FDCAN_RXF0S_F0PI          FDCAN_RXF0S_F0PI_Msk                         /*!<Rx FIFO 0 Put Index                       */
#define FDCAN_RXF0S_F0F_Pos       (24U)
#define FDCAN_RXF0S_F0F_Msk       (0x1UL << FDCAN_RXF0S_F0F_Pos)               /*!< 0x01000000 */
#define FDCAN_RXF0S_F0F           FDCAN_RXF0S_F0F_Msk                          /*!<Rx FIFO 0 Full                            */
#define FDCAN_RXF0S_RF0L_Pos      (25U)
#define FDCAN_RXF0S_RF0L_Msk      (0x1UL << FDCAN_RXF0S_RF0L_Pos)              /*!< 0x02000000 */
#define FDCAN_RXF0S_RF0L          FDCAN_RXF0S_RF0L_Msk                         /*!<Rx FIFO 0 Message Lost                    */

/*****************  Bit definition for FDCAN_RXF0A register  ********************/
#define FDCAN_RXF0A_F0AI_Pos      (0U)
#define FDCAN_RXF0A_F0AI_Msk      (0x3FUL << FDCAN_RXF0A_F0AI_Pos)             /*!< 0x0000003F */
#define FDCAN_RXF0A_F0AI          FDCAN_RXF0A_F0AI_Msk                         /*!<Rx FIFO 0 Acknowledge Index               */

/*****************  Bit definition for FDCAN_RXBC register  ********************/
#define FDCAN_RXBC_RBSA_Pos       (2U)
#define FDCAN_RXBC_RBSA_Msk       (0x3FFFUL << FDCAN_RXBC_RBSA_Pos)            /*!< 0x0000FFFC */
#define FDCAN_RXBC_RBSA           FDCAN_RXBC_RBSA_Msk                          /*!<Rx Buffer Start Address                   */

/*****************  Bit definition for FDCAN_RXF1C register  ********************/
#define FDCAN_RXF1C_F1SA_Pos      (2U)
#define FDCAN_RXF1C_F1SA_Msk      (0x3FFFUL << FDCAN_RXF1C_F1SA_Pos)           /*!< 0x0000FFFC */
#define FDCAN_RXF1C_F1SA          FDCAN_RXF1C_F1SA_Msk                         /*!<Rx FIFO 1 Start Address                   */
#define FDCAN_RXF1C_F1S_Pos       (16U)
#define FDCAN_RXF1C_F1S_Msk       (0x7FUL << FDCAN_RXF1C_F1S_Pos)              /*!< 0x007F0000 */
#define FDCAN_RXF1C_F1S           FDCAN_RXF1C_F1S_Msk                          /*!<Number of Rx FIFO 1 elements              */
#define FDCAN_RXF1C_F1WM_Pos      (24U)
#define FDCAN_RXF1C_F1WM_Msk      (0x7FUL << FDCAN_RXF1C_F1WM_Pos)             /*!< 0x7F000000 */
#define FDCAN_RXF1C_F1WM          FDCAN_RXF1C_F1WM_Msk                         /*!<Rx FIFO 1 Watermark                       */
#define FDCAN_RXF1C_F1OM_Pos      (31U)
#define FDCAN_RXF1C_F1OM_Msk      (0x1UL << FDCAN_RXF1C_F1OM_Pos)              /*!< 0x80000000 */
#define FDCAN_RXF1C_F1OM          FDCAN_RXF1C_F1OM_Msk                         /*!<FIFO 1 Operation Mode                     */

/*****************  Bit definition for FDCAN_RXF1S register  ********************/
#define FDCAN_RXF1S_F1FL_Pos      (0U)
#define FDCAN_RXF1S_F1FL_Msk      (0x7FUL << FDCAN_RXF1S_F1FL_Pos)             /*!< 0x0000007F */
#define FDCAN_RXF1S_F1FL          FDCAN_RXF1S_F1FL_Msk                         /*!<Rx FIFO 1 Fill Level                      */
#define FDCAN_RXF1S_F1GI_Pos      (8U)
#define FDCAN_RXF1S_F1GI_Msk      (0x3FUL << FDCAN_RXF1S_F1GI_Pos)             /*!< 0x00003F00 */
#define FDCAN_RXF1S_F1GI          FDCAN_RXF1S_F1GI_Msk                         /*!<Rx FIFO 1 Get Index                       */
#define FDCAN_RXF1S_F1PI_Pos      (16U)
#define FDCAN_RXF1S_F1PI_Msk      (0x3FUL << FDCAN_RXF1S_F1PI_Pos)             /*!< 0x003F0000 */
#define FDCAN_RXF1S_F1PI          FDCAN_RXF1S_F1PI_Msk                         /*!<Rx FIFO 1 Put Index                       */
#define FDCAN_RXF1S_F1F_Pos       (24U)
#define FDCAN_RXF1S_F1F_Msk       (0x1UL << FDCAN_RXF1S_F1F_Pos)               /*!< 0x01000000 */
#define FDCAN_RXF1S_F1F           FDCAN_RXF1S_F1F_Msk                          /*!<Rx FIFO 1 Full                            */
#define FDCAN_RXF1S_RF1L_Pos      (25U)
#define FDCAN_RXF1S_RF1L_Msk      (0x1UL << FDCAN_RXF1S_RF1L_Pos)              /*!< 0x02000000 */
#define FDCAN_RXF1S_RF1L          FDCAN_RXF1S_RF1L_Msk                         /*!<Rx FIFO 1 Message Lost                    */

/*****************  Bit definition for FDCAN_RXF1A register  ********************/
#define FDCAN_RXF1A_F1AI_Pos      (0U)
#define FDCAN_RXF1A_F1AI_Msk      (0x3FUL << FDCAN_RXF1A_F1AI_Pos)             /*!< 0x0000003F */
#define FDCAN_RXF1A_F1AI          FDCAN_RXF1A_F1AI_Msk                         /*!<Rx FIFO 1 Acknowledge Index               */

/*****************  Bit definition for FDCAN_RXESC register  ********************/
#define FDCAN_RXESC_F0DS_Pos      (0U)
#define FDCAN_RXESC_F0DS_Msk      (0x7UL << FDCAN_RXESC_F0DS_Pos)              /*!< 0x00000007 */
#define FDCAN_RXESC_F0DS          FDCAN_RXESC_F0DS_Msk                         /*!<Rx FIFO 1 Data Field Size                 */
#define FDCAN_RXESC_F1DS_Pos      (4U)
#define FDCAN_RXESC_F1DS_Msk      (0x7UL << FDCAN_RXESC_F1DS_Pos)              /*!< 0x00000070 */
#define FDCAN_RXESC_F1DS          FDCAN_RXESC_F1DS_Msk                         /*!<Rx FIFO 0 Data Field Size                 */
#define FDCAN_RXESC_RBDS_Pos      (8U)
#define FDCAN_RXESC_RBDS_Msk      (0x7UL << FDCAN_RXESC_RBDS_Pos)              /*!< 0x00000700 */
#define FDCAN_RXESC_RBDS          FDCAN_RXESC_RBDS_Msk                         /*!<Rx Buffer Data Field Size                 */

/*****************  Bit definition for FDCAN_TXBC register  *********************/
#define FDCAN_TXBC_TBSA_Pos       (2U)
#define FDCAN_TXBC_TBSA_Msk       (0x3FFFUL << FDCAN_TXBC_TBSA_Pos)            /*!< 0x0000FFFC */
#define FDCAN_TXBC_TBSA           FDCAN_TXBC_TBSA_Msk                          /*!<Tx Buffers Start Address                  */
#define FDCAN_TXBC_NDTB_Pos       (16U)
#define FDCAN_TXBC_NDTB_Msk       (0x3FUL << FDCAN_TXBC_NDTB_Pos)              /*!< 0x003F0000 */
#define FDCAN_TXBC_NDTB           FDCAN_TXBC_NDTB_Msk                          /*!<Number of Dedicated Transmit Buffers      */
#define FDCAN_TXBC_TFQS_Pos       (24U)
#define FDCAN_TXBC_TFQS_Msk       (0x3FUL << FDCAN_TXBC_TFQS_Pos)              /*!< 0x3F000000 */
#define FDCAN_TXBC_TFQS           FDCAN_TXBC_TFQS_Msk                          /*!<Transmit FIFO/Queue Size                  */
#define FDCAN_TXBC_TFQM_Pos       (30U)
#define FDCAN_TXBC_TFQM_Msk       (0x1UL << FDCAN_TXBC_TFQM_Pos)               /*!< 0x40000000 */
#define FDCAN_TXBC_TFQM           FDCAN_TXBC_TFQM_Msk                          /*!<Tx FIFO/Queue Mode                        */

/*****************  Bit definition for FDCAN_TXFQS register  *********************/
#define FDCAN_TXFQS_TFFL_Pos      (0U)
#define FDCAN_TXFQS_TFFL_Msk      (0x3FUL << FDCAN_TXFQS_TFFL_Pos)             /*!< 0x0000003F */
#define FDCAN_TXFQS_TFFL          FDCAN_TXFQS_TFFL_Msk                         /*!<Tx FIFO Free Level                        */
#define FDCAN_TXFQS_TFGI_Pos      (8U)
#define FDCAN_TXFQS_TFGI_Msk      (0x1FUL << FDCAN_TXFQS_TFGI_Pos)             /*!< 0x00001F00 */
#define FDCAN_TXFQS_TFGI          FDCAN_TXFQS_TFGI_Msk                         /*!<Tx FIFO Get Index                         */
#define FDCAN_TXFQS_TFQPI_Pos     (16U)
#define FDCAN_TXFQS_TFQPI_Msk     (0x1FUL << FDCAN_TXFQS_TFQPI_Pos)            /*!< 0x001F0000 */
#define FDCAN_TXFQS_TFQPI         FDCAN_TXFQS_TFQPI_Msk                        /*!<Tx FIFO/Queue Put Index                   */
#define FDCAN_TXFQS_TFQF_Pos      (21U)
#define FDCAN_TXFQS_TFQF_Msk      (0x1UL << FDCAN_TXFQS_TFQF_Pos)              /*!< 0x00200000 */
#define FDCAN_TXFQS_TFQF          FDCAN_TXFQS_TFQF_Msk                         /*!<Tx FIFO/Queue Full                        */

/*****************  Bit definition for FDCAN_TXESC register  *********************/
#define FDCAN_TXESC_TBDS_Pos      (0U)
#define FDCAN_TXESC_TBDS_Msk      (0x7UL << FDCAN_TXESC_TBDS_Pos)              /*!< 0x00000007 */
#define FDCAN_TXESC_TBDS          FDCAN_TXESC_TBDS_Msk                         /*!<Tx Buffer Data Field Size                 */

/*****************  Bit definition for FDCAN_TXBRP register  *********************/
#define FDCAN_TXBRP_TRP_Pos       (0U)
#define FDCAN_TXBRP_TRP_Msk       (0xFFFFFFFFUL << FDCAN_TXBRP_TRP_Pos)        /*!< 0xFFFFFFFF */
#define FDCAN_TXBRP_TRP           FDCAN_TXBRP_TRP_Msk                          /*!<Transmission Request Pending              */

/*****************  Bit definition for FDCAN_TXBAR register  *********************/
#define FDCAN_TXBAR_AR_Pos        (0U)
#define FDCAN_TXBAR_AR_Msk        (0xFFFFFFFFUL << FDCAN_TXBAR_AR_Pos)         /*!< 0xFFFFFFFF */
#define FDCAN_TXBAR_AR            FDCAN_TXBAR_AR_Msk                           /*!<Add Request                               */

/*****************  Bit definition for FDCAN_TXBCR register  *********************/
#define FDCAN_TXBCR_CR_Pos        (0U)
#define FDCAN_TXBCR_CR_Msk        (0xFFFFFFFFUL << FDCAN_TXBCR_CR_Pos)         /*!< 0xFFFFFFFF */
#define FDCAN_TXBCR_CR            FDCAN_TXBCR_CR_Msk                           /*!<Cancellation Request                      */

/*****************  Bit definition for FDCAN_TXBTO register  *********************/
#define FDCAN_TXBTO_TO_Pos        (0U)
#define FDCAN_TXBTO_TO_Msk        (0xFFFFFFFFUL << FDCAN_TXBTO_TO_Pos)         /*!< 0xFFFFFFFF */
#define FDCAN_TXBTO_TO            FDCAN_TXBTO_TO_Msk                           /*!<Transmission Occurred                     */

/*****************  Bit definition for FDCAN_TXBCF register  *********************/
#define FDCAN_TXBCF_CF_Pos        (0U)
#define FDCAN_TXBCF_CF_Msk        (0xFFFFFFFFUL << FDCAN_TXBCF_CF_Pos)         /*!< 0xFFFFFFFF */
#define FDCAN_TXBCF_CF            FDCAN_TXBCF_CF_Msk                           /*!<Cancellation Finished                     */

/*****************  Bit definition for FDCAN_TXBTIE register  ********************/
#define FDCAN_TXBTIE_TIE_Pos      (0U)
#define FDCAN_TXBTIE_TIE_Msk      (0xFFFFFFFFUL << FDCAN_TXBTIE_TIE_Pos)       /*!< 0xFFFFFFFF */
#define FDCAN_TXBTIE_TIE          FDCAN_TXBTIE_TIE_Msk                         /*!<Transmission Interrupt Enable             */

/*****************  Bit definition for FDCAN_ TXBCIE register  *******************/
#define FDCAN_TXBCIE_CFIE_Pos     (0U)
#define FDCAN_TXBCIE_CFIE_Msk     (0xFFFFFFFFUL << FDCAN_TXBCIE_CFIE_Pos)      /*!< 0xFFFFFFFF */
#define FDCAN_TXBCIE_CFIE         FDCAN_TXBCIE_CFIE_Msk                        /*!<Cancellation Finished Interrupt Enable    */

/*****************  Bit definition for FDCAN_TXEFC register  *********************/
#define FDCAN_TXEFC_EFSA_Pos      (2U)
#define FDCAN_TXEFC_EFSA_Msk      (0x3FFFUL << FDCAN_TXEFC_EFSA_Pos)           /*!< 0x0000FFFC */
#define FDCAN_TXEFC_EFSA          FDCAN_TXEFC_EFSA_Msk                         /*!<Event FIFO Start Address                  */
#define FDCAN_TXEFC_EFS_Pos       (16U)
#define FDCAN_TXEFC_EFS_Msk       (0x3FUL << FDCAN_TXEFC_EFS_Pos)              /*!< 0x003F0000 */
#define FDCAN_TXEFC_EFS           FDCAN_TXEFC_EFS_Msk                          /*!<Event FIFO Size                           */
#define FDCAN_TXEFC_EFWM_Pos      (24U)
#define FDCAN_TXEFC_EFWM_Msk      (0x3FUL << FDCAN_TXEFC_EFWM_Pos)             /*!< 0x3F000000 */
#define FDCAN_TXEFC_EFWM          FDCAN_TXEFC_EFWM_Msk                         /*!<Event FIFO Watermark                      */

/*****************  Bit definition for FDCAN_TXEFS register  *********************/
#define FDCAN_TXEFS_EFFL_Pos      (0U)
#define FDCAN_TXEFS_EFFL_Msk      (0x3FUL << FDCAN_TXEFS_EFFL_Pos)             /*!< 0x0000003F */
#define FDCAN_TXEFS_EFFL          FDCAN_TXEFS_EFFL_Msk                         /*!<Event FIFO Fill Level                     */
#define FDCAN_TXEFS_EFGI_Pos      (8U)
#define FDCAN_TXEFS_EFGI_Msk      (0x1FUL << FDCAN_TXEFS_EFGI_Pos)             /*!< 0x00001F00 */
#define FDCAN_TXEFS_EFGI          FDCAN_TXEFS_EFGI_Msk                         /*!<Event FIFO Get Index                      */
#define FDCAN_TXEFS_EFPI_Pos      (16U)
#define FDCAN_TXEFS_EFPI_Msk      (0x1FUL << FDCAN_TXEFS_EFPI_Pos)             /*!< 0x001F0000 */
#define FDCAN_TXEFS_EFPI          FDCAN_TXEFS_EFPI_Msk                         /*!<Event FIFO Put Index                      */
#define FDCAN_TXEFS_EFF_Pos       (24U)
#define FDCAN_TXEFS_EFF_Msk       (0x1UL << FDCAN_TXEFS_EFF_Pos)               /*!< 0x01000000 */
#define FDCAN_TXEFS_EFF           FDCAN_TXEFS_EFF_Msk                          /*!<Event FIFO Full                           */
#define FDCAN_TXEFS_TEFL_Pos      (25U)
#define FDCAN_TXEFS_TEFL_Msk      (0x1UL << FDCAN_TXEFS_TEFL_Pos)              /*!< 0x02000000 */
#define FDCAN_TXEFS_TEFL          FDCAN_TXEFS_TEFL_Msk                         /*!<Tx Event FIFO Element Lost                */

/*****************  Bit definition for FDCAN_TXEFA register  *********************/
#define FDCAN_TXEFA_EFAI_Pos      (0U)
#define FDCAN_TXEFA_EFAI_Msk      (0x1FUL << FDCAN_TXEFA_EFAI_Pos)             /*!< 0x0000001F */
#define FDCAN_TXEFA_EFAI          FDCAN_TXEFA_EFAI_Msk                         /*!<Event FIFO Acknowledge Index              */

/*****************  Bit definition for FDCAN_TTTMC register  *********************/
#define FDCAN_TTTMC_TMSA_Pos      (2U)
#define FDCAN_TTTMC_TMSA_Msk      (0x3FFFUL << FDCAN_TTTMC_TMSA_Pos)           /*!< 0x0000FFFC */
#define FDCAN_TTTMC_TMSA          FDCAN_TTTMC_TMSA_Msk                         /*!<Trigger Memory Start Address              */
#define FDCAN_TTTMC_TME_Pos       (16U)
#define FDCAN_TTTMC_TME_Msk       (0x7FUL << FDCAN_TTTMC_TME_Pos)              /*!< 0x007F0000 */
#define FDCAN_TTTMC_TME           FDCAN_TTTMC_TME_Msk                          /*!<Trigger Memory Elements                   */

/*****************  Bit definition for FDCAN_TTRMC register  *********************/
#define FDCAN_TTRMC_RID_Pos       (0U)
#define FDCAN_TTRMC_RID_Msk       (0x1FFFFFFFUL << FDCAN_TTRMC_RID_Pos)        /*!< 0x1FFFFFFF */
#define FDCAN_TTRMC_RID           FDCAN_TTRMC_RID_Msk                          /*!<Reference Identifier                      */
#define FDCAN_TTRMC_XTD_Pos       (30U)
#define FDCAN_TTRMC_XTD_Msk       (0x1UL << FDCAN_TTRMC_XTD_Pos)               /*!< 0x40000000 */
#define FDCAN_TTRMC_XTD           FDCAN_TTRMC_XTD_Msk                          /*!< Extended Identifier                      */
#define FDCAN_TTRMC_RMPS_Pos      (31U)
#define FDCAN_TTRMC_RMPS_Msk      (0x1UL << FDCAN_TTRMC_RMPS_Pos)              /*!< 0x80000000 */
#define FDCAN_TTRMC_RMPS          FDCAN_TTRMC_RMPS_Msk                         /*!<Reference Message Payload Select          */

/*****************  Bit definition for FDCAN_TTOCF register  *********************/
#define FDCAN_TTOCF_OM_Pos        (0U)
#define FDCAN_TTOCF_OM_Msk        (0x3UL << FDCAN_TTOCF_OM_Pos)                /*!< 0x00000003 */
#define FDCAN_TTOCF_OM            FDCAN_TTOCF_OM_Msk                           /*!<Operation Mode                            */
#define FDCAN_TTOCF_GEN_Pos       (3U)
#define FDCAN_TTOCF_GEN_Msk       (0x1UL << FDCAN_TTOCF_GEN_Pos)               /*!< 0x00000008 */
#define FDCAN_TTOCF_GEN           FDCAN_TTOCF_GEN_Msk                          /*!<Gap Enable                                */
#define FDCAN_TTOCF_TM_Pos        (4U)
#define FDCAN_TTOCF_TM_Msk        (0x1UL << FDCAN_TTOCF_TM_Pos)                /*!< 0x00000010 */
#define FDCAN_TTOCF_TM            FDCAN_TTOCF_TM_Msk                           /*!<Time Master                               */
#define FDCAN_TTOCF_LDSDL_Pos     (5U)
#define FDCAN_TTOCF_LDSDL_Msk     (0x7UL << FDCAN_TTOCF_LDSDL_Pos)             /*!< 0x000000E0 */
#define FDCAN_TTOCF_LDSDL         FDCAN_TTOCF_LDSDL_Msk                        /*!<LD of Synchronization Deviation Limit     */
#define FDCAN_TTOCF_IRTO_Pos      (8U)
#define FDCAN_TTOCF_IRTO_Msk      (0x7FUL << FDCAN_TTOCF_IRTO_Pos)             /*!< 0x00007F00 */
#define FDCAN_TTOCF_IRTO          FDCAN_TTOCF_IRTO_Msk                         /*!<Initial Reference Trigger Offset          */
#define FDCAN_TTOCF_EECS_Pos      (15U)
#define FDCAN_TTOCF_EECS_Msk      (0x1UL << FDCAN_TTOCF_EECS_Pos)              /*!< 0x00008000 */
#define FDCAN_TTOCF_EECS          FDCAN_TTOCF_EECS_Msk                         /*!<Enable External Clock Synchronization     */
#define FDCAN_TTOCF_AWL_Pos       (16U)
#define FDCAN_TTOCF_AWL_Msk       (0xFFUL << FDCAN_TTOCF_AWL_Pos)              /*!< 0x00FF0000 */
#define FDCAN_TTOCF_AWL           FDCAN_TTOCF_AWL_Msk                          /*!<Application Watchdog Limit                */
#define FDCAN_TTOCF_EGTF_Pos      (24U)
#define FDCAN_TTOCF_EGTF_Msk      (0x1UL << FDCAN_TTOCF_EGTF_Pos)              /*!< 0x01000000 */
#define FDCAN_TTOCF_EGTF          FDCAN_TTOCF_EGTF_Msk                         /*!<Enable Global Time Filtering              */
#define FDCAN_TTOCF_ECC_Pos       (25U)
#define FDCAN_TTOCF_ECC_Msk       (0x1UL << FDCAN_TTOCF_ECC_Pos)               /*!< 0x02000000 */
#define FDCAN_TTOCF_ECC           FDCAN_TTOCF_ECC_Msk                          /*!<Enable Clock Calibration                  */
#define FDCAN_TTOCF_EVTP_Pos      (26U)
#define FDCAN_TTOCF_EVTP_Msk      (0x1UL << FDCAN_TTOCF_EVTP_Pos)              /*!< 0x04000000 */
#define FDCAN_TTOCF_EVTP          FDCAN_TTOCF_EVTP_Msk                         /*!<Event Trigger Polarity                    */

/*****************  Bit definition for FDCAN_TTMLM register  *********************/
#define FDCAN_TTMLM_CCM_Pos       (0U)
#define FDCAN_TTMLM_CCM_Msk       (0x3FUL << FDCAN_TTMLM_CCM_Pos)              /*!< 0x0000003F */
#define FDCAN_TTMLM_CCM           FDCAN_TTMLM_CCM_Msk                          /*!<Cycle Count Max                           */
#define FDCAN_TTMLM_CSS_Pos       (6U)
#define FDCAN_TTMLM_CSS_Msk       (0x3UL << FDCAN_TTMLM_CSS_Pos)               /*!< 0x000000C0 */
#define FDCAN_TTMLM_CSS           FDCAN_TTMLM_CSS_Msk                          /*!<Cycle Start Synchronization               */
#define FDCAN_TTMLM_TXEW_Pos      (8U)
#define FDCAN_TTMLM_TXEW_Msk      (0xFUL << FDCAN_TTMLM_TXEW_Pos)              /*!< 0x00000F00 */
#define FDCAN_TTMLM_TXEW          FDCAN_TTMLM_TXEW_Msk                         /*!<Tx Enable Window                          */
#define FDCAN_TTMLM_ENTT_Pos      (16U)
#define FDCAN_TTMLM_ENTT_Msk      (0xFFFUL << FDCAN_TTMLM_ENTT_Pos)            /*!< 0x0FFF0000 */
#define FDCAN_TTMLM_ENTT          FDCAN_TTMLM_ENTT_Msk                         /*!<Expected Number of Tx Triggers            */

/*****************  Bit definition for FDCAN_TURCF register  *********************/
#define FDCAN_TURCF_NCL_Pos       (0U)
#define FDCAN_TURCF_NCL_Msk       (0xFFFFUL << FDCAN_TURCF_NCL_Pos)            /*!< 0x0000FFFF */
#define FDCAN_TURCF_NCL           FDCAN_TURCF_NCL_Msk                          /*!<Numerator Configuration Low               */
#define FDCAN_TURCF_DC_Pos        (16U)
#define FDCAN_TURCF_DC_Msk        (0x3FFFUL << FDCAN_TURCF_DC_Pos)             /*!< 0x3FFF0000 */
#define FDCAN_TURCF_DC            FDCAN_TURCF_DC_Msk                           /*!<Denominator Configuration                 */
#define FDCAN_TURCF_ELT_Pos       (31U)
#define FDCAN_TURCF_ELT_Msk       (0x1UL << FDCAN_TURCF_ELT_Pos)               /*!< 0x80000000 */
#define FDCAN_TURCF_ELT           FDCAN_TURCF_ELT_Msk                          /*!<Enable Local Time                         */

/*****************  Bit definition for FDCAN_TTOCN register  ********************/
#define FDCAN_TTOCN_SGT_Pos       (0U)
#define FDCAN_TTOCN_SGT_Msk       (0x1UL << FDCAN_TTOCN_SGT_Pos)               /*!< 0x00000001 */
#define FDCAN_TTOCN_SGT           FDCAN_TTOCN_SGT_Msk                          /*!<Set Global time                           */
#define FDCAN_TTOCN_ECS_Pos       (1U)
#define FDCAN_TTOCN_ECS_Msk       (0x1UL << FDCAN_TTOCN_ECS_Pos)               /*!< 0x00000002 */
#define FDCAN_TTOCN_ECS           FDCAN_TTOCN_ECS_Msk                          /*!<External Clock Synchronization            */
#define FDCAN_TTOCN_SWP_Pos       (2U)
#define FDCAN_TTOCN_SWP_Msk       (0x1UL << FDCAN_TTOCN_SWP_Pos)               /*!< 0x00000004 */
#define FDCAN_TTOCN_SWP           FDCAN_TTOCN_SWP_Msk                          /*!<Stop Watch Polarity                       */
#define FDCAN_TTOCN_SWS_Pos       (3U)
#define FDCAN_TTOCN_SWS_Msk       (0x3UL << FDCAN_TTOCN_SWS_Pos)               /*!< 0x00000018 */
#define FDCAN_TTOCN_SWS           FDCAN_TTOCN_SWS_Msk                          /*!<Stop Watch Source                         */
#define FDCAN_TTOCN_RTIE_Pos      (5U)
#define FDCAN_TTOCN_RTIE_Msk      (0x1UL << FDCAN_TTOCN_RTIE_Pos)              /*!< 0x00000020 */
#define FDCAN_TTOCN_RTIE          FDCAN_TTOCN_RTIE_Msk                         /*!<Register Time Mark Interrupt Pulse Enable */
#define FDCAN_TTOCN_TMC_Pos       (6U)
#define FDCAN_TTOCN_TMC_Msk       (0x3UL << FDCAN_TTOCN_TMC_Pos)               /*!< 0x000000C0 */
#define FDCAN_TTOCN_TMC           FDCAN_TTOCN_TMC_Msk                          /*!<Register Time Mark Compare                */
#define FDCAN_TTOCN_TTIE_Pos      (8U)
#define FDCAN_TTOCN_TTIE_Msk      (0x1UL << FDCAN_TTOCN_TTIE_Pos)              /*!< 0x00000100 */
#define FDCAN_TTOCN_TTIE          FDCAN_TTOCN_TTIE_Msk                         /*!<Trigger Time Mark Interrupt Pulse Enable  */
#define FDCAN_TTOCN_GCS_Pos       (9U)
#define FDCAN_TTOCN_GCS_Msk       (0x1UL << FDCAN_TTOCN_GCS_Pos)               /*!< 0x00000200 */
#define FDCAN_TTOCN_GCS           FDCAN_TTOCN_GCS_Msk                          /*!<Gap Control Select                        */
#define FDCAN_TTOCN_FGP_Pos       (10U)
#define FDCAN_TTOCN_FGP_Msk       (0x1UL << FDCAN_TTOCN_FGP_Pos)               /*!< 0x00000400 */
#define FDCAN_TTOCN_FGP           FDCAN_TTOCN_FGP_Msk                          /*!<Finish Gap                                */
#define FDCAN_TTOCN_TMG_Pos       (11U)
#define FDCAN_TTOCN_TMG_Msk       (0x1UL << FDCAN_TTOCN_TMG_Pos)               /*!< 0x00000800 */
#define FDCAN_TTOCN_TMG           FDCAN_TTOCN_TMG_Msk                          /*!<Time Mark Gap                             */
#define FDCAN_TTOCN_NIG_Pos       (12U)
#define FDCAN_TTOCN_NIG_Msk       (0x1UL << FDCAN_TTOCN_NIG_Pos)               /*!< 0x00001000 */
#define FDCAN_TTOCN_NIG           FDCAN_TTOCN_NIG_Msk                          /*!<Next is Gap                               */
#define FDCAN_TTOCN_ESCN_Pos      (13U)
#define FDCAN_TTOCN_ESCN_Msk      (0x1UL << FDCAN_TTOCN_ESCN_Pos)              /*!< 0x00002000 */
#define FDCAN_TTOCN_ESCN          FDCAN_TTOCN_ESCN_Msk                         /*!<External Synchronization Control          */
#define FDCAN_TTOCN_LCKC_Pos      (15U)
#define FDCAN_TTOCN_LCKC_Msk      (0x1UL << FDCAN_TTOCN_LCKC_Pos)              /*!< 0x00008000 */
#define FDCAN_TTOCN_LCKC          FDCAN_TTOCN_LCKC_Msk                         /*!<TT Operation Control Register Locked      */

/*****************  Bit definition for FDCAN_TTGTP register  ********************/
#define FDCAN_TTGTP_TP_Pos        (0U)
#define FDCAN_TTGTP_TP_Msk        (0xFFFFUL << FDCAN_TTGTP_TP_Pos)             /*!< 0x0000FFFF */
#define FDCAN_TTGTP_TP            FDCAN_TTGTP_TP_Msk                           /*!<Time Preset                               */
#define FDCAN_TTGTP_CTP_Pos       (16U)
#define FDCAN_TTGTP_CTP_Msk       (0xFFFFUL << FDCAN_TTGTP_CTP_Pos)            /*!< 0xFFFF0000 */
#define FDCAN_TTGTP_CTP           FDCAN_TTGTP_CTP_Msk                          /*!<Cycle Time Target Phase                   */

/*****************  Bit definition for FDCAN_TTTMK register  ********************/
#define FDCAN_TTTMK_TM_Pos        (0U)
#define FDCAN_TTTMK_TM_Msk        (0xFFFFUL << FDCAN_TTTMK_TM_Pos)             /*!< 0x0000FFFF */
#define FDCAN_TTTMK_TM            FDCAN_TTTMK_TM_Msk                           /*!<Time Mark                                 */
#define FDCAN_TTTMK_TICC_Pos      (16U)
#define FDCAN_TTTMK_TICC_Msk      (0x7FUL << FDCAN_TTTMK_TICC_Pos)             /*!< 0x007F0000 */
#define FDCAN_TTTMK_TICC          FDCAN_TTTMK_TICC_Msk                         /*!<Time Mark Cycle Code                      */
#define FDCAN_TTTMK_LCKM_Pos      (31U)
#define FDCAN_TTTMK_LCKM_Msk      (0x1UL << FDCAN_TTTMK_LCKM_Pos)              /*!< 0x80000000 */
#define FDCAN_TTTMK_LCKM          FDCAN_TTTMK_LCKM_Msk                         /*!<TT Time Mark Register Locked              */

/*****************  Bit definition for FDCAN_TTIR register  ********************/
#define FDCAN_TTIR_SBC_Pos        (0U)
#define FDCAN_TTIR_SBC_Msk        (0x1UL << FDCAN_TTIR_SBC_Pos)                /*!< 0x00000001 */
#define FDCAN_TTIR_SBC            FDCAN_TTIR_SBC_Msk                           /*!<Start of Basic Cycle                      */
#define FDCAN_TTIR_SMC_Pos        (1U)
#define FDCAN_TTIR_SMC_Msk        (0x1UL << FDCAN_TTIR_SMC_Pos)                /*!< 0x00000002 */
#define FDCAN_TTIR_SMC            FDCAN_TTIR_SMC_Msk                           /*!<Start of Matrix Cycle                     */
#define FDCAN_TTIR_CSM_Pos        (2U)
#define FDCAN_TTIR_CSM_Msk        (0x1UL << FDCAN_TTIR_CSM_Pos)                /*!< 0x00000004 */
#define FDCAN_TTIR_CSM            FDCAN_TTIR_CSM_Msk                           /*!<Change of Synchronization Mode            */
#define FDCAN_TTIR_SOG_Pos        (3U)
#define FDCAN_TTIR_SOG_Msk        (0x1UL << FDCAN_TTIR_SOG_Pos)                /*!< 0x00000008 */
#define FDCAN_TTIR_SOG            FDCAN_TTIR_SOG_Msk                           /*!<Start of Gap                              */
#define FDCAN_TTIR_RTMI_Pos       (4U)
#define FDCAN_TTIR_RTMI_Msk       (0x1UL << FDCAN_TTIR_RTMI_Pos)               /*!< 0x00000010 */
#define FDCAN_TTIR_RTMI           FDCAN_TTIR_RTMI_Msk                          /*!<Register Time Mark Interrupt              */
#define FDCAN_TTIR_TTMI_Pos       (5U)
#define FDCAN_TTIR_TTMI_Msk       (0x1UL << FDCAN_TTIR_TTMI_Pos)               /*!< 0x00000020 */
#define FDCAN_TTIR_TTMI           FDCAN_TTIR_TTMI_Msk                          /*!<Trigger Time Mark Event Internal          */
#define FDCAN_TTIR_SWE_Pos        (6U)
#define FDCAN_TTIR_SWE_Msk        (0x1UL << FDCAN_TTIR_SWE_Pos)                /*!< 0x00000040 */
#define FDCAN_TTIR_SWE            FDCAN_TTIR_SWE_Msk                           /*!<Stop Watch Event                          */
#define FDCAN_TTIR_GTW_Pos        (7U)
#define FDCAN_TTIR_GTW_Msk        (0x1UL << FDCAN_TTIR_GTW_Pos)                /*!< 0x00000080 */
#define FDCAN_TTIR_GTW            FDCAN_TTIR_GTW_Msk                           /*!<Global Time Wrap                          */
#define FDCAN_TTIR_GTD_Pos        (8U)
#define FDCAN_TTIR_GTD_Msk        (0x1UL << FDCAN_TTIR_GTD_Pos)                /*!< 0x00000100 */
#define FDCAN_TTIR_GTD            FDCAN_TTIR_GTD_Msk                           /*!<Global Time Discontinuity                 */
#define FDCAN_TTIR_GTE_Pos        (9U)
#define FDCAN_TTIR_GTE_Msk        (0x1UL << FDCAN_TTIR_GTE_Pos)                /*!< 0x00000200 */
#define FDCAN_TTIR_GTE            FDCAN_TTIR_GTE_Msk                           /*!<Global Time Error                         */
#define FDCAN_TTIR_TXU_Pos        (10U)
#define FDCAN_TTIR_TXU_Msk        (0x1UL << FDCAN_TTIR_TXU_Pos)                /*!< 0x00000400 */
#define FDCAN_TTIR_TXU            FDCAN_TTIR_TXU_Msk                           /*!<Tx Count Underflow                        */
#define FDCAN_TTIR_TXO_Pos        (11U)
#define FDCAN_TTIR_TXO_Msk        (0x1UL << FDCAN_TTIR_TXO_Pos)                /*!< 0x00000800 */
#define FDCAN_TTIR_TXO            FDCAN_TTIR_TXO_Msk                           /*!<Tx Count Overflow                         */
#define FDCAN_TTIR_SE1_Pos        (12U)
#define FDCAN_TTIR_SE1_Msk        (0x1UL << FDCAN_TTIR_SE1_Pos)                /*!< 0x00001000 */
#define FDCAN_TTIR_SE1            FDCAN_TTIR_SE1_Msk                           /*!<Scheduling Error 1                        */
#define FDCAN_TTIR_SE2_Pos        (13U)
#define FDCAN_TTIR_SE2_Msk        (0x1UL << FDCAN_TTIR_SE2_Pos)                /*!< 0x00002000 */
#define FDCAN_TTIR_SE2            FDCAN_TTIR_SE2_Msk                           /*!<Scheduling Error 2                        */
#define FDCAN_TTIR_ELC_Pos        (14U)
#define FDCAN_TTIR_ELC_Msk        (0x1UL << FDCAN_TTIR_ELC_Pos)                /*!< 0x00004000 */
#define FDCAN_TTIR_ELC            FDCAN_TTIR_ELC_Msk                           /*!<Error Level Changed                       */
#define FDCAN_TTIR_IWT_Pos        (15U)
#define FDCAN_TTIR_IWT_Msk        (0x1UL << FDCAN_TTIR_IWT_Pos)                /*!< 0x00008000 */
#define FDCAN_TTIR_IWT            FDCAN_TTIR_IWT_Msk                           /*!<Initialization Watch Trigger              */
#define FDCAN_TTIR_WT_Pos         (16U)
#define FDCAN_TTIR_WT_Msk         (0x1UL << FDCAN_TTIR_WT_Pos)                 /*!< 0x00010000 */
#define FDCAN_TTIR_WT             FDCAN_TTIR_WT_Msk                            /*!<Watch Trigger                             */
#define FDCAN_TTIR_AW_Pos         (17U)
#define FDCAN_TTIR_AW_Msk         (0x1UL << FDCAN_TTIR_AW_Pos)                 /*!< 0x00020000 */
#define FDCAN_TTIR_AW             FDCAN_TTIR_AW_Msk                            /*!<Application Watchdog                      */
#define FDCAN_TTIR_CER_Pos        (18U)
#define FDCAN_TTIR_CER_Msk        (0x1UL << FDCAN_TTIR_CER_Pos)                /*!< 0x00040000 */
#define FDCAN_TTIR_CER            FDCAN_TTIR_CER_Msk                           /*!<Configuration Error                       */

/*****************  Bit definition for FDCAN_TTIE register  ********************/
#define FDCAN_TTIE_SBCE_Pos       (0U)
#define FDCAN_TTIE_SBCE_Msk       (0x1UL << FDCAN_TTIE_SBCE_Pos)               /*!< 0x00000001 */
#define FDCAN_TTIE_SBCE           FDCAN_TTIE_SBCE_Msk                          /*!<Start of Basic Cycle Interrupt Enable             */
#define FDCAN_TTIE_SMCE_Pos       (1U)
#define FDCAN_TTIE_SMCE_Msk       (0x1UL << FDCAN_TTIE_SMCE_Pos)               /*!< 0x00000002 */
#define FDCAN_TTIE_SMCE           FDCAN_TTIE_SMCE_Msk                          /*!<Start of Matrix Cycle Interrupt Enable            */
#define FDCAN_TTIE_CSME_Pos       (2U)
#define FDCAN_TTIE_CSME_Msk       (0x1UL << FDCAN_TTIE_CSME_Pos)               /*!< 0x00000004 */
#define FDCAN_TTIE_CSME           FDCAN_TTIE_CSME_Msk                          /*!<Change of Synchronization Mode Interrupt Enable   */
#define FDCAN_TTIE_SOGE_Pos       (3U)
#define FDCAN_TTIE_SOGE_Msk       (0x1UL << FDCAN_TTIE_SOGE_Pos)               /*!< 0x00000008 */
#define FDCAN_TTIE_SOGE           FDCAN_TTIE_SOGE_Msk                          /*!<Start of Gap Interrupt Enable                     */
#define FDCAN_TTIE_RTMIE_Pos      (4U)
#define FDCAN_TTIE_RTMIE_Msk      (0x1UL << FDCAN_TTIE_RTMIE_Pos)              /*!< 0x00000010 */
#define FDCAN_TTIE_RTMIE          FDCAN_TTIE_RTMIE_Msk                         /*!<Register Time Mark Interrupt Interrupt Enable     */
#define FDCAN_TTIE_TTMIE_Pos      (5U)
#define FDCAN_TTIE_TTMIE_Msk      (0x1UL << FDCAN_TTIE_TTMIE_Pos)              /*!< 0x00000020 */
#define FDCAN_TTIE_TTMIE          FDCAN_TTIE_TTMIE_Msk                         /*!<Trigger Time Mark Event Internal Interrupt Enable */
#define FDCAN_TTIE_SWEE_Pos       (6U)
#define FDCAN_TTIE_SWEE_Msk       (0x1UL << FDCAN_TTIE_SWEE_Pos)               /*!< 0x00000040 */
#define FDCAN_TTIE_SWEE           FDCAN_TTIE_SWEE_Msk                          /*!<Stop Watch Event Interrupt Enable                 */
#define FDCAN_TTIE_GTWE_Pos       (7U)
#define FDCAN_TTIE_GTWE_Msk       (0x1UL << FDCAN_TTIE_GTWE_Pos)               /*!< 0x00000080 */
#define FDCAN_TTIE_GTWE           FDCAN_TTIE_GTWE_Msk                          /*!<Global Time Wrap Interrupt Enable                 */
#define FDCAN_TTIE_GTDE_Pos       (8U)
#define FDCAN_TTIE_GTDE_Msk       (0x1UL << FDCAN_TTIE_GTDE_Pos)               /*!< 0x00000100 */
#define FDCAN_TTIE_GTDE           FDCAN_TTIE_GTDE_Msk                          /*!<Global Time Discontinuity Interrupt Enable        */
#define FDCAN_TTIE_GTEE_Pos       (9U)
#define FDCAN_TTIE_GTEE_Msk       (0x1UL << FDCAN_TTIE_GTEE_Pos)               /*!< 0x00000200 */
#define FDCAN_TTIE_GTEE           FDCAN_TTIE_GTEE_Msk                          /*!<Global Time Error Interrupt Enable                */
#define FDCAN_TTIE_TXUE_Pos       (10U)
#define FDCAN_TTIE_TXUE_Msk       (0x1UL << FDCAN_TTIE_TXUE_Pos)               /*!< 0x00000400 */
#define FDCAN_TTIE_TXUE           FDCAN_TTIE_TXUE_Msk                          /*!<Tx Count Underflow Interrupt Enable               */
#define FDCAN_TTIE_TXOE_Pos       (11U)
#define FDCAN_TTIE_TXOE_Msk       (0x1UL << FDCAN_TTIE_TXOE_Pos)               /*!< 0x00000800 */
#define FDCAN_TTIE_TXOE           FDCAN_TTIE_TXOE_Msk                          /*!<Tx Count Overflow Interrupt Enable                */
#define FDCAN_TTIE_SE1E_Pos       (12U)
#define FDCAN_TTIE_SE1E_Msk       (0x1UL << FDCAN_TTIE_SE1E_Pos)               /*!< 0x00001000 */
#define FDCAN_TTIE_SE1E           FDCAN_TTIE_SE1E_Msk                          /*!<Scheduling Error 1 Interrupt Enable               */
#define FDCAN_TTIE_SE2E_Pos       (13U)
#define FDCAN_TTIE_SE2E_Msk       (0x1UL << FDCAN_TTIE_SE2E_Pos)               /*!< 0x00002000 */
#define FDCAN_TTIE_SE2E           FDCAN_TTIE_SE2E_Msk                          /*!<Scheduling Error 2 Interrupt Enable               */
#define FDCAN_TTIE_ELCE_Pos       (14U)
#define FDCAN_TTIE_ELCE_Msk       (0x1UL << FDCAN_TTIE_ELCE_Pos)               /*!< 0x00004000 */
#define FDCAN_TTIE_ELCE           FDCAN_TTIE_ELCE_Msk                          /*!<Error Level Changed Interrupt Enable              */
#define FDCAN_TTIE_IWTE_Pos       (15U)
#define FDCAN_TTIE_IWTE_Msk       (0x1UL << FDCAN_TTIE_IWTE_Pos)               /*!< 0x00008000 */
#define FDCAN_TTIE_IWTE           FDCAN_TTIE_IWTE_Msk                          /*!<Initialization Watch Trigger Interrupt Enable     */
#define FDCAN_TTIE_WTE_Pos        (16U)
#define FDCAN_TTIE_WTE_Msk        (0x1UL << FDCAN_TTIE_WTE_Pos)                /*!< 0x00010000 */
#define FDCAN_TTIE_WTE            FDCAN_TTIE_WTE_Msk                           /*!<Watch Trigger Interrupt Enable                    */
#define FDCAN_TTIE_AWE_Pos        (17U)
#define FDCAN_TTIE_AWE_Msk        (0x1UL << FDCAN_TTIE_AWE_Pos)                /*!< 0x00020000 */
#define FDCAN_TTIE_AWE            FDCAN_TTIE_AWE_Msk                           /*!<Application Watchdog Interrupt Enable             */
#define FDCAN_TTIE_CERE_Pos       (18U)
#define FDCAN_TTIE_CERE_Msk       (0x1UL << FDCAN_TTIE_CERE_Pos)               /*!< 0x00040000 */
#define FDCAN_TTIE_CERE           FDCAN_TTIE_CERE_Msk                          /*!<Configuration Error Interrupt Enable              */

/*****************  Bit definition for FDCAN_TTILS register  ********************/
#define FDCAN_TTILS_SBCS_Pos      (0U)
#define FDCAN_TTILS_SBCS_Msk      (0x1UL << FDCAN_TTILS_SBCS_Pos)              /*!< 0x00000001 */
#define FDCAN_TTILS_SBCS          FDCAN_TTILS_SBCS_Msk                         /*!<Start of Basic Cycle Interrupt Line               */
#define FDCAN_TTILS_SMCS_Pos      (1U)
#define FDCAN_TTILS_SMCS_Msk      (0x1UL << FDCAN_TTILS_SMCS_Pos)              /*!< 0x00000002 */
#define FDCAN_TTILS_SMCS          FDCAN_TTILS_SMCS_Msk                         /*!<Start of Matrix Cycle Interrupt Line              */
#define FDCAN_TTILS_CSMS_Pos      (2U)
#define FDCAN_TTILS_CSMS_Msk      (0x1UL << FDCAN_TTILS_CSMS_Pos)              /*!< 0x00000004 */
#define FDCAN_TTILS_CSMS          FDCAN_TTILS_CSMS_Msk                         /*!<Change of Synchronization Mode Interrupt Line     */
#define FDCAN_TTILS_SOGS_Pos      (3U)
#define FDCAN_TTILS_SOGS_Msk      (0x1UL << FDCAN_TTILS_SOGS_Pos)              /*!< 0x00000008 */
#define FDCAN_TTILS_SOGS          FDCAN_TTILS_SOGS_Msk                         /*!<Start of Gap Interrupt Line                       */
#define FDCAN_TTILS_RTMIS_Pos     (4U)
#define FDCAN_TTILS_RTMIS_Msk     (0x1UL << FDCAN_TTILS_RTMIS_Pos)             /*!< 0x00000010 */
#define FDCAN_TTILS_RTMIS         FDCAN_TTILS_RTMIS_Msk                        /*!<Register Time Mark Interrupt Interrupt Line       */
#define FDCAN_TTILS_TTMIS_Pos     (5U)
#define FDCAN_TTILS_TTMIS_Msk     (0x1UL << FDCAN_TTILS_TTMIS_Pos)             /*!< 0x00000020 */
#define FDCAN_TTILS_TTMIS         FDCAN_TTILS_TTMIS_Msk                        /*!<Trigger Time Mark Event Internal Interrupt Line   */
#define FDCAN_TTILS_SWES_Pos      (6U)
#define FDCAN_TTILS_SWES_Msk      (0x1UL << FDCAN_TTILS_SWES_Pos)              /*!< 0x00000040 */
#define FDCAN_TTILS_SWES          FDCAN_TTILS_SWES_Msk                         /*!<Stop Watch Event Interrupt Line                   */
#define FDCAN_TTILS_GTWS_Pos      (7U)
#define FDCAN_TTILS_GTWS_Msk      (0x1UL << FDCAN_TTILS_GTWS_Pos)              /*!< 0x00000080 */
#define FDCAN_TTILS_GTWS          FDCAN_TTILS_GTWS_Msk                         /*!<Global Time Wrap Interrupt Line                   */
#define FDCAN_TTILS_GTDS_Pos      (8U)
#define FDCAN_TTILS_GTDS_Msk      (0x1UL << FDCAN_TTILS_GTDS_Pos)              /*!< 0x00000100 */
#define FDCAN_TTILS_GTDS          FDCAN_TTILS_GTDS_Msk                         /*!<Global Time Discontinuity Interrupt Line          */
#define FDCAN_TTILS_GTES_Pos      (9U)
#define FDCAN_TTILS_GTES_Msk      (0x1UL << FDCAN_TTILS_GTES_Pos)              /*!< 0x00000200 */
#define FDCAN_TTILS_GTES          FDCAN_TTILS_GTES_Msk                         /*!<Global Time Error Interrupt Line                  */
#define FDCAN_TTILS_TXUS_Pos      (10U)
#define FDCAN_TTILS_TXUS_Msk      (0x1UL << FDCAN_TTILS_TXUS_Pos)              /*!< 0x00000400 */
#define FDCAN_TTILS_TXUS          FDCAN_TTILS_TXUS_Msk                         /*!<Tx Count Underflow Interrupt Line                 */
#define FDCAN_TTILS_TXOS_Pos      (11U)
#define FDCAN_TTILS_TXOS_Msk      (0x1UL << FDCAN_TTILS_TXOS_Pos)              /*!< 0x00000800 */
#define FDCAN_TTILS_TXOS          FDCAN_TTILS_TXOS_Msk                         /*!<Tx Count Overflow Interrupt Line                  */
#define FDCAN_TTILS_SE1S_Pos      (12U)
#define FDCAN_TTILS_SE1S_Msk      (0x1UL << FDCAN_TTILS_SE1S_Pos)              /*!< 0x00001000 */
#define FDCAN_TTILS_SE1S          FDCAN_TTILS_SE1S_Msk                         /*!<Scheduling Error 1 Interrupt Line                 */
#define FDCAN_TTILS_SE2S_Pos      (13U)
#define FDCAN_TTILS_SE2S_Msk      (0x1UL << FDCAN_TTILS_SE2S_Pos)              /*!< 0x00002000 */
#define FDCAN_TTILS_SE2S          FDCAN_TTILS_SE2S_Msk                         /*!<Scheduling Error 2 Interrupt Line                 */
#define FDCAN_TTILS_ELCS_Pos      (14U)
#define FDCAN_TTILS_ELCS_Msk      (0x1UL << FDCAN_TTILS_ELCS_Pos)              /*!< 0x00004000 */
#define FDCAN_TTILS_ELCS          FDCAN_TTILS_ELCS_Msk                         /*!<Error Level Changed Interrupt Line                */
#define FDCAN_TTILS_IWTS_Pos      (15U)
#define FDCAN_TTILS_IWTS_Msk      (0x1UL << FDCAN_TTILS_IWTS_Pos)              /*!< 0x00008000 */
#define FDCAN_TTILS_IWTS          FDCAN_TTILS_IWTS_Msk                         /*!<Initialization Watch Trigger Interrupt Line       */
#define FDCAN_TTILS_WTS_Pos       (16U)
#define FDCAN_TTILS_WTS_Msk       (0x1UL << FDCAN_TTILS_WTS_Pos)               /*!< 0x00010000 */
#define FDCAN_TTILS_WTS           FDCAN_TTILS_WTS_Msk                          /*!<Watch Trigger Interrupt Line                      */
#define FDCAN_TTILS_AWS_Pos       (17U)
#define FDCAN_TTILS_AWS_Msk       (0x1UL << FDCAN_TTILS_AWS_Pos)               /*!< 0x00020000 */
#define FDCAN_TTILS_AWS           FDCAN_TTILS_AWS_Msk                          /*!<Application Watchdog Interrupt Line               */
#define FDCAN_TTILS_CERS_Pos      (18U)
#define FDCAN_TTILS_CERS_Msk      (0x1UL << FDCAN_TTILS_CERS_Pos)              /*!< 0x00040000 */
#define FDCAN_TTILS_CERS          FDCAN_TTILS_CERS_Msk                         /*!<Configuration Error Interrupt Line                */

/*****************  Bit definition for FDCAN_TTOST register  ********************/
#define FDCAN_TTOST_EL_Pos        (0U)
#define FDCAN_TTOST_EL_Msk        (0x3UL << FDCAN_TTOST_EL_Pos)                /*!< 0x00000003 */
#define FDCAN_TTOST_EL            FDCAN_TTOST_EL_Msk                           /*!<Error Level                              */
#define FDCAN_TTOST_MS_Pos        (2U)
#define FDCAN_TTOST_MS_Msk        (0x3UL << FDCAN_TTOST_MS_Pos)                /*!< 0x0000000C */
#define FDCAN_TTOST_MS            FDCAN_TTOST_MS_Msk                           /*!<Master State                             */
#define FDCAN_TTOST_SYS_Pos       (4U)
#define FDCAN_TTOST_SYS_Msk       (0x3UL << FDCAN_TTOST_SYS_Pos)               /*!< 0x00000030 */
#define FDCAN_TTOST_SYS           FDCAN_TTOST_SYS_Msk                          /*!<Synchronization State                    */
#define FDCAN_TTOST_QGTP_Pos      (6U)
#define FDCAN_TTOST_QGTP_Msk      (0x1UL << FDCAN_TTOST_QGTP_Pos)              /*!< 0x00000040 */
#define FDCAN_TTOST_QGTP          FDCAN_TTOST_QGTP_Msk                         /*!<Quality of Global Time Phase             */
#define FDCAN_TTOST_QCS_Pos       (7U)
#define FDCAN_TTOST_QCS_Msk       (0x1UL << FDCAN_TTOST_QCS_Pos)               /*!< 0x00000080 */
#define FDCAN_TTOST_QCS           FDCAN_TTOST_QCS_Msk                          /*!<Quality of Clock Speed                   */
#define FDCAN_TTOST_RTO_Pos       (8U)
#define FDCAN_TTOST_RTO_Msk       (0xFFUL << FDCAN_TTOST_RTO_Pos)              /*!< 0x0000FF00 */
#define FDCAN_TTOST_RTO           FDCAN_TTOST_RTO_Msk                          /*!<Reference Trigger Offset                 */
#define FDCAN_TTOST_WGTD_Pos      (22U)
#define FDCAN_TTOST_WGTD_Msk      (0x1UL << FDCAN_TTOST_WGTD_Pos)              /*!< 0x00400000 */
#define FDCAN_TTOST_WGTD          FDCAN_TTOST_WGTD_Msk                         /*!<Wait for Global Time Discontinuity       */
#define FDCAN_TTOST_GFI_Pos       (23U)
#define FDCAN_TTOST_GFI_Msk       (0x1UL << FDCAN_TTOST_GFI_Pos)               /*!< 0x00800000 */
#define FDCAN_TTOST_GFI           FDCAN_TTOST_GFI_Msk                          /*!<Gap Finished Indicator                   */
#define FDCAN_TTOST_TMP_Pos       (24U)
#define FDCAN_TTOST_TMP_Msk       (0x7UL << FDCAN_TTOST_TMP_Pos)               /*!< 0x07000000 */
#define FDCAN_TTOST_TMP           FDCAN_TTOST_TMP_Msk                          /*!<Time Master Priority                     */
#define FDCAN_TTOST_GSI_Pos       (27U)
#define FDCAN_TTOST_GSI_Msk       (0x1UL << FDCAN_TTOST_GSI_Pos)               /*!< 0x08000000 */
#define FDCAN_TTOST_GSI           FDCAN_TTOST_GSI_Msk                          /*!<Gap Started Indicator                    */
#define FDCAN_TTOST_WFE_Pos       (28U)
#define FDCAN_TTOST_WFE_Msk       (0x1UL << FDCAN_TTOST_WFE_Pos)               /*!< 0x10000000 */
#define FDCAN_TTOST_WFE           FDCAN_TTOST_WFE_Msk                          /*!<Wait for Event                           */
#define FDCAN_TTOST_AWE_Pos       (29U)
#define FDCAN_TTOST_AWE_Msk       (0x1UL << FDCAN_TTOST_AWE_Pos)               /*!< 0x20000000 */
#define FDCAN_TTOST_AWE           FDCAN_TTOST_AWE_Msk                          /*!<Application Watchdog Event               */
#define FDCAN_TTOST_WECS_Pos      (30U)
#define FDCAN_TTOST_WECS_Msk      (0x1UL << FDCAN_TTOST_WECS_Pos)              /*!< 0x40000000 */
#define FDCAN_TTOST_WECS          FDCAN_TTOST_WECS_Msk                         /*!<Wait for External Clock Synchronization  */
#define FDCAN_TTOST_SPL_Pos       (31U)
#define FDCAN_TTOST_SPL_Msk       (0x1UL << FDCAN_TTOST_SPL_Pos)               /*!< 0x80000000 */
#define FDCAN_TTOST_SPL           FDCAN_TTOST_SPL_Msk                          /*!<Schedule Phase Lock                      */

/*****************  Bit definition for FDCAN_TURNA register  ********************/
#define FDCAN_TURNA_NAV_Pos       (0U)
#define FDCAN_TURNA_NAV_Msk       (0x3FFFFUL << FDCAN_TURNA_NAV_Pos)           /*!< 0x0003FFFF */
#define FDCAN_TURNA_NAV           FDCAN_TURNA_NAV_Msk                          /*!<Numerator Actual Value                   */

/*****************  Bit definition for FDCAN_TTLGT register  ********************/
#define FDCAN_TTLGT_LT_Pos        (0U)
#define FDCAN_TTLGT_LT_Msk        (0xFFFFUL << FDCAN_TTLGT_LT_Pos)             /*!< 0x0000FFFF */
#define FDCAN_TTLGT_LT            FDCAN_TTLGT_LT_Msk                           /*!<Local Time                               */
#define FDCAN_TTLGT_GT_Pos        (16U)
#define FDCAN_TTLGT_GT_Msk        (0xFFFFUL << FDCAN_TTLGT_GT_Pos)             /*!< 0xFFFF0000 */
#define FDCAN_TTLGT_GT            FDCAN_TTLGT_GT_Msk                           /*!<Global Time                              */

/*****************  Bit definition for FDCAN_TTCTC register  ********************/
#define FDCAN_TTCTC_CT_Pos        (0U)
#define FDCAN_TTCTC_CT_Msk        (0xFFFFUL << FDCAN_TTCTC_CT_Pos)             /*!< 0x0000FFFF */
#define FDCAN_TTCTC_CT            FDCAN_TTCTC_CT_Msk                           /*!<Cycle Time                               */
#define FDCAN_TTCTC_CC_Pos        (16U)
#define FDCAN_TTCTC_CC_Msk        (0x3FUL << FDCAN_TTCTC_CC_Pos)               /*!< 0x003F0000 */
#define FDCAN_TTCTC_CC            FDCAN_TTCTC_CC_Msk                           /*!<Cycle Count                              */

/*****************  Bit definition for FDCAN_TTCPT register  ********************/
#define FDCAN_TTCPT_CCV_Pos       (0U)
#define FDCAN_TTCPT_CCV_Msk       (0x3FUL << FDCAN_TTCPT_CCV_Pos)              /*!< 0x0000003F */
#define FDCAN_TTCPT_CCV           FDCAN_TTCPT_CCV_Msk                          /*!<Cycle Count Value                        */
#define FDCAN_TTCPT_SWV_Pos       (16U)
#define FDCAN_TTCPT_SWV_Msk       (0xFFFFUL << FDCAN_TTCPT_SWV_Pos)            /*!< 0xFFFF0000 */
#define FDCAN_TTCPT_SWV           FDCAN_TTCPT_SWV_Msk                          /*!<Stop Watch Value                         */

/*****************  Bit definition for FDCAN_TTCSM register  ********************/
#define FDCAN_TTCSM_CSM_Pos       (0U)
#define FDCAN_TTCSM_CSM_Msk       (0xFFFFUL << FDCAN_TTCSM_CSM_Pos)            /*!< 0x0000FFFF */
#define FDCAN_TTCSM_CSM           FDCAN_TTCSM_CSM_Msk                          /*!<Cycle Sync Mark                          */

/*****************  Bit definition for FDCAN_TTTS register  *********************/
#define FDCAN_TTTS_SWTSEL_Pos     (0U)
#define FDCAN_TTTS_SWTSEL_Msk     (0x3UL << FDCAN_TTTS_SWTSEL_Pos)             /*!< 0x00000003 */
#define FDCAN_TTTS_SWTSEL         FDCAN_TTTS_SWTSEL_Msk                        /*!<Stop watch trigger input selection       */
#define FDCAN_TTTS_EVTSEL_Pos     (4U)
#define FDCAN_TTTS_EVTSEL_Msk     (0x3UL << FDCAN_TTTS_EVTSEL_Pos)             /*!< 0x00000030 */
#define FDCAN_TTTS_EVTSEL         FDCAN_TTTS_EVTSEL_Msk                        /*!<Event trigger input selection            */

/********************************************************************************/
/*                                                                              */
/*                      FDCANCCU (Clock Calibration unit)                       */
/*                                                                              */
/********************************************************************************/

/*****************  Bit definition for FDCANCCU_CREL register  ******************/
#define FDCANCCU_CREL_DAY_Pos        (0U)
#define FDCANCCU_CREL_DAY_Msk        (0xFFUL << FDCANCCU_CREL_DAY_Pos)         /*!< 0x000000FF */
#define FDCANCCU_CREL_DAY            FDCANCCU_CREL_DAY_Msk                     /*!<Timestamp Day                           */
#define FDCANCCU_CREL_MON_Pos        (8U)
#define FDCANCCU_CREL_MON_Msk        (0xFFUL << FDCANCCU_CREL_MON_Pos)         /*!< 0x0000FF00 */
#define FDCANCCU_CREL_MON            FDCANCCU_CREL_MON_Msk                     /*!<Timestamp Month                         */
#define FDCANCCU_CREL_YEAR_Pos       (16U)
#define FDCANCCU_CREL_YEAR_Msk       (0xFUL << FDCANCCU_CREL_YEAR_Pos)         /*!< 0x000F0000 */
#define FDCANCCU_CREL_YEAR           FDCANCCU_CREL_YEAR_Msk                    /*!<Timestamp Year                          */
#define FDCANCCU_CREL_SUBSTEP_Pos    (20U)
#define FDCANCCU_CREL_SUBSTEP_Msk    (0xFUL << FDCANCCU_CREL_SUBSTEP_Pos)      /*!< 0x00F00000 */
#define FDCANCCU_CREL_SUBSTEP        FDCANCCU_CREL_SUBSTEP_Msk                 /*!<Sub-step of Core release                */
#define FDCANCCU_CREL_STEP_Pos       (24U)
#define FDCANCCU_CREL_STEP_Msk       (0xFUL << FDCANCCU_CREL_STEP_Pos)         /*!< 0x0F000000 */
#define FDCANCCU_CREL_STEP           FDCANCCU_CREL_STEP_Msk                    /*!<Step of Core release                    */
#define FDCANCCU_CREL_REL_Pos        (28U)
#define FDCANCCU_CREL_REL_Msk        (0xFUL << FDCANCCU_CREL_REL_Pos)          /*!< 0xF0000000 */
#define FDCANCCU_CREL_REL            FDCANCCU_CREL_REL_Msk                     /*!<Core release                            */

/*****************  Bit definition for FDCANCCU_CCFG register  ******************/
#define FDCANCCU_CCFG_TQBT_Pos       (0U)
#define FDCANCCU_CCFG_TQBT_Msk       (0x1FUL << FDCANCCU_CCFG_TQBT_Pos)        /*!< 0x0000001F */
#define FDCANCCU_CCFG_TQBT           FDCANCCU_CCFG_TQBT_Msk                    /*!<Time Quanta per Bit Time                */
#define FDCANCCU_CCFG_BCC_Pos        (6U)
#define FDCANCCU_CCFG_BCC_Msk        (0x1UL << FDCANCCU_CCFG_BCC_Pos)          /*!< 0x00000040 */
#define FDCANCCU_CCFG_BCC            FDCANCCU_CCFG_BCC_Msk                     /*!<Bypass Clock Calibration                */
#define FDCANCCU_CCFG_CFL_Pos        (7U)
#define FDCANCCU_CCFG_CFL_Msk        (0x1UL << FDCANCCU_CCFG_CFL_Pos)          /*!< 0x00000080 */
#define FDCANCCU_CCFG_CFL            FDCANCCU_CCFG_CFL_Msk                     /*!<Calibration Field Length                */
#define FDCANCCU_CCFG_OCPM_Pos       (8U)
#define FDCANCCU_CCFG_OCPM_Msk       (0xFFUL << FDCANCCU_CCFG_OCPM_Pos)        /*!< 0x0000FF00 */
#define FDCANCCU_CCFG_OCPM           FDCANCCU_CCFG_OCPM_Msk                    /*!<Oscillator Clock Periods Minimum        */
#define FDCANCCU_CCFG_CDIV_Pos       (16U)
#define FDCANCCU_CCFG_CDIV_Msk       (0xFUL << FDCANCCU_CCFG_CDIV_Pos)         /*!< 0x000F0000 */
#define FDCANCCU_CCFG_CDIV           FDCANCCU_CCFG_CDIV_Msk                    /*!<Clock Divider                           */
#define FDCANCCU_CCFG_SWR_Pos        (31U)
#define FDCANCCU_CCFG_SWR_Msk        (0x1UL << FDCANCCU_CCFG_SWR_Pos)          /*!< 0x80000000 */
#define FDCANCCU_CCFG_SWR            FDCANCCU_CCFG_SWR_Msk                     /*!<Software Reset                          */

/*****************  Bit definition for FDCANCCU_CSTAT register  *****************/
#define FDCANCCU_CSTAT_OCPC_Pos      (0U)
#define FDCANCCU_CSTAT_OCPC_Msk      (0x3FFFFUL << FDCANCCU_CSTAT_OCPC_Pos)    /*!< 0x0003FFFF */
#define FDCANCCU_CSTAT_OCPC          FDCANCCU_CSTAT_OCPC_Msk                   /*!<Oscillator Clock Period Counter        */
#define FDCANCCU_CSTAT_TQC_Pos       (18U)
#define FDCANCCU_CSTAT_TQC_Msk       (0x7FFUL << FDCANCCU_CSTAT_TQC_Pos)       /*!< 0x1FFC0000 */
#define FDCANCCU_CSTAT_TQC           FDCANCCU_CSTAT_TQC_Msk                    /*!<Time Quanta Counter                    */
#define FDCANCCU_CSTAT_CALS_Pos      (30U)
#define FDCANCCU_CSTAT_CALS_Msk      (0x3UL << FDCANCCU_CSTAT_CALS_Pos)        /*!< 0xC0000000 */
#define FDCANCCU_CSTAT_CALS          FDCANCCU_CSTAT_CALS_Msk                   /*!<Calibration State                      */

/******************  Bit definition for FDCANCCU_CWD register  ******************/
#define FDCANCCU_CWD_WDC_Pos         (0U)
#define FDCANCCU_CWD_WDC_Msk         (0xFFFFUL << FDCANCCU_CWD_WDC_Pos)        /*!< 0x0000FFFF */
#define FDCANCCU_CWD_WDC             FDCANCCU_CWD_WDC_Msk                      /*!<Watchdog Configuration                 */
#define FDCANCCU_CWD_WDV_Pos         (16U)
#define FDCANCCU_CWD_WDV_Msk         (0xFFFFUL << FDCANCCU_CWD_WDV_Pos)        /*!< 0xFFFF0000 */
#define FDCANCCU_CWD_WDV             FDCANCCU_CWD_WDV_Msk                      /*!<Watchdog Value                         */

/******************  Bit definition for FDCANCCU_IR register  *******************/
#define FDCANCCU_IR_CWE_Pos          (0U)
#define FDCANCCU_IR_CWE_Msk          (0x1UL << FDCANCCU_IR_CWE_Pos)            /*!< 0x00000001 */
#define FDCANCCU_IR_CWE              FDCANCCU_IR_CWE_Msk                       /*!<Calibration Watchdog Event             */
#define FDCANCCU_IR_CSC_Pos          (1U)
#define FDCANCCU_IR_CSC_Msk          (0x1UL << FDCANCCU_IR_CSC_Pos)            /*!< 0x00000002 */
#define FDCANCCU_IR_CSC              FDCANCCU_IR_CSC_Msk                       /*!<Calibration State Changed              */

/******************  Bit definition for FDCANCCU_IE register  *******************/
#define FDCANCCU_IE_CWEE_Pos         (0U)
#define FDCANCCU_IE_CWEE_Msk         (0x1UL << FDCANCCU_IE_CWEE_Pos)           /*!< 0x00000001 */
#define FDCANCCU_IE_CWEE             FDCANCCU_IE_CWEE_Msk                      /*!<Calibration Watchdog Event Enable      */
#define FDCANCCU_IE_CSCE_Pos         (1U)
#define FDCANCCU_IE_CSCE_Msk         (0x1UL << FDCANCCU_IE_CSCE_Pos)           /*!< 0x00000002 */
#define FDCANCCU_IE_CSCE             FDCANCCU_IE_CSCE_Msk                      /*!<Calibration State Changed Enable       */

/******************************************************************************/
/*                                                                            */
/*                          HDMI-CEC (CEC)                                    */
/*                                                                            */
/******************************************************************************/

/*******************  Bit definition for CEC_CR register  *********************/
#define CEC_CR_CECEN_Pos         (0U)
#define CEC_CR_CECEN_Msk         (0x1UL << CEC_CR_CECEN_Pos)                   /*!< 0x00000001 */
#define CEC_CR_CECEN             CEC_CR_CECEN_Msk                              /*!< CEC Enable                                */
#define CEC_CR_TXSOM_Pos         (1U)
#define CEC_CR_TXSOM_Msk         (0x1UL << CEC_CR_TXSOM_Pos)                   /*!< 0x00000002 */
#define CEC_CR_TXSOM             CEC_CR_TXSOM_Msk                              /*!< CEC Tx Start Of Message                   */
#define CEC_CR_TXEOM_Pos         (2U)
#define CEC_CR_TXEOM_Msk         (0x1UL << CEC_CR_TXEOM_Pos)                   /*!< 0x00000004 */
#define CEC_CR_TXEOM             CEC_CR_TXEOM_Msk                              /*!< CEC Tx End Of Message                     */

/*******************  Bit definition for CEC_CFGR register  *******************/
#define CEC_CFGR_SFT_Pos         (0U)
#define CEC_CFGR_SFT_Msk         (0x7UL << CEC_CFGR_SFT_Pos)                   /*!< 0x00000007 */
#define CEC_CFGR_SFT             CEC_CFGR_SFT_Msk                              /*!< CEC Signal Free Time                      */
#define CEC_CFGR_RXTOL_Pos       (3U)
#define CEC_CFGR_RXTOL_Msk       (0x1UL << CEC_CFGR_RXTOL_Pos)                 /*!< 0x00000008 */
#define CEC_CFGR_RXTOL           CEC_CFGR_RXTOL_Msk                            /*!< CEC Tolerance                             */
#define CEC_CFGR_BRESTP_Pos      (4U)
#define CEC_CFGR_BRESTP_Msk      (0x1UL << CEC_CFGR_BRESTP_Pos)                /*!< 0x00000010 */
#define CEC_CFGR_BRESTP          CEC_CFGR_BRESTP_Msk                           /*!< CEC Rx Stop                               */
#define CEC_CFGR_BREGEN_Pos      (5U)
#define CEC_CFGR_BREGEN_Msk      (0x1UL << CEC_CFGR_BREGEN_Pos)                /*!< 0x00000020 */
#define CEC_CFGR_BREGEN          CEC_CFGR_BREGEN_Msk                           /*!< CEC Bit Rising Error generation           */
#define CEC_CFGR_LBPEGEN_Pos     (6U)
#define CEC_CFGR_LBPEGEN_Msk     (0x1UL << CEC_CFGR_LBPEGEN_Pos)               /*!< 0x00000040 */
#define CEC_CFGR_LBPEGEN         CEC_CFGR_LBPEGEN_Msk                          /*!< CEC Long Bit Period Error generation      */
#define CEC_CFGR_SFTOPT_Pos      (8U)
#define CEC_CFGR_SFTOPT_Msk      (0x1UL << CEC_CFGR_SFTOPT_Pos)                /*!< 0x00000100 */
#define CEC_CFGR_SFTOPT          CEC_CFGR_SFTOPT_Msk                           /*!< CEC Signal Free Time optional             */
#define CEC_CFGR_BRDNOGEN_Pos    (7U)
#define CEC_CFGR_BRDNOGEN_Msk    (0x1UL << CEC_CFGR_BRDNOGEN_Pos)              /*!< 0x00000080 */
#define CEC_CFGR_BRDNOGEN        CEC_CFGR_BRDNOGEN_Msk                         /*!< CEC Broadcast No error generation         */
#define CEC_CFGR_OAR_Pos         (16U)
#define CEC_CFGR_OAR_Msk         (0x7FFFUL << CEC_CFGR_OAR_Pos)                /*!< 0x7FFF0000 */
#define CEC_CFGR_OAR             CEC_CFGR_OAR_Msk                              /*!< CEC Own Address                           */
#define CEC_CFGR_LSTN_Pos        (31U)
#define CEC_CFGR_LSTN_Msk        (0x1UL << CEC_CFGR_LSTN_Pos)                  /*!< 0x80000000 */
#define CEC_CFGR_LSTN            CEC_CFGR_LSTN_Msk                             /*!< CEC Listen mode                           */

/*******************  Bit definition for CEC_TXDR register  *******************/
#define CEC_TXDR_TXD_Pos         (0U)
#define CEC_TXDR_TXD_Msk         (0xFFUL << CEC_TXDR_TXD_Pos)                  /*!< 0x000000FF */
#define CEC_TXDR_TXD             CEC_TXDR_TXD_Msk                              /*!< CEC Tx Data                               */

/*******************  Bit definition for CEC_RXDR register  *******************/
#define CEC_RXDR_RXD_Pos         (0U)
#define CEC_RXDR_RXD_Msk         (0xFFUL << CEC_RXDR_RXD_Pos)                  /*!< 0x000000FF */
#define CEC_RXDR_RXD             CEC_RXDR_RXD_Msk                              /*!< CEC Rx Data                               */

/*******************  Bit definition for CEC_ISR register  ********************/
#define CEC_ISR_RXBR_Pos         (0U)
#define CEC_ISR_RXBR_Msk         (0x1UL << CEC_ISR_RXBR_Pos)                   /*!< 0x00000001 */
#define CEC_ISR_RXBR             CEC_ISR_RXBR_Msk                              /*!< CEC Rx-Byte Received                      */
#define CEC_ISR_RXEND_Pos        (1U)
#define CEC_ISR_RXEND_Msk        (0x1UL << CEC_ISR_RXEND_Pos)                  /*!< 0x00000002 */
#define CEC_ISR_RXEND            CEC_ISR_RXEND_Msk                             /*!< CEC End Of Reception                      */
#define CEC_ISR_RXOVR_Pos        (2U)
#define CEC_ISR_RXOVR_Msk        (0x1UL << CEC_ISR_RXOVR_Pos)                  /*!< 0x00000004 */
#define CEC_ISR_RXOVR            CEC_ISR_RXOVR_Msk                             /*!< CEC Rx-Overrun                            */
#define CEC_ISR_BRE_Pos          (3U)
#define CEC_ISR_BRE_Msk          (0x1UL << CEC_ISR_BRE_Pos)                    /*!< 0x00000008 */
#define CEC_ISR_BRE              CEC_ISR_BRE_Msk                               /*!< CEC Rx Bit Rising Error                   */
#define CEC_ISR_SBPE_Pos         (4U)
#define CEC_ISR_SBPE_Msk         (0x1UL << CEC_ISR_SBPE_Pos)                   /*!< 0x00000010 */
#define CEC_ISR_SBPE             CEC_ISR_SBPE_Msk                              /*!< CEC Rx Short Bit period Error             */
#define CEC_ISR_LBPE_Pos         (5U)
#define CEC_ISR_LBPE_Msk         (0x1UL << CEC_ISR_LBPE_Pos)                   /*!< 0x00000020 */
#define CEC_ISR_LBPE             CEC_ISR_LBPE_Msk                              /*!< CEC Rx Long Bit period Error              */
#define CEC_ISR_RXACKE_Pos       (6U)
#define CEC_ISR_RXACKE_Msk       (0x1UL << CEC_ISR_RXACKE_Pos)                 /*!< 0x00000040 */
#define CEC_ISR_RXACKE           CEC_ISR_RXACKE_Msk                            /*!< CEC Rx Missing Acknowledge                */
#define CEC_ISR_ARBLST_Pos       (7U)
#define CEC_ISR_ARBLST_Msk       (0x1UL << CEC_ISR_ARBLST_Pos)                 /*!< 0x00000080 */
#define CEC_ISR_ARBLST           CEC_ISR_ARBLST_Msk                            /*!< CEC Arbitration Lost                      */
#define CEC_ISR_TXBR_Pos         (8U)
#define CEC_ISR_TXBR_Msk         (0x1UL << CEC_ISR_TXBR_Pos)                   /*!< 0x00000100 */
#define CEC_ISR_TXBR             CEC_ISR_TXBR_Msk                              /*!< CEC Tx Byte Request                       */
#define CEC_ISR_TXEND_Pos        (9U)
#define CEC_ISR_TXEND_Msk        (0x1UL << CEC_ISR_TXEND_Pos)                  /*!< 0x00000200 */
#define CEC_ISR_TXEND            CEC_ISR_TXEND_Msk                             /*!< CEC End of Transmission                   */
#define CEC_ISR_TXUDR_Pos        (10U)
#define CEC_ISR_TXUDR_Msk        (0x1UL << CEC_ISR_TXUDR_Pos)                  /*!< 0x00000400 */
#define CEC_ISR_TXUDR            CEC_ISR_TXUDR_Msk                             /*!< CEC Tx-Buffer Underrun                    */
#define CEC_ISR_TXERR_Pos        (11U)
#define CEC_ISR_TXERR_Msk        (0x1UL << CEC_ISR_TXERR_Pos)                  /*!< 0x00000800 */
#define CEC_ISR_TXERR            CEC_ISR_TXERR_Msk                             /*!< CEC Tx-Error                              */
#define CEC_ISR_TXACKE_Pos       (12U)
#define CEC_ISR_TXACKE_Msk       (0x1UL << CEC_ISR_TXACKE_Pos)                 /*!< 0x00001000 */
#define CEC_ISR_TXACKE           CEC_ISR_TXACKE_Msk                            /*!< CEC Tx Missing Acknowledge                */

/*******************  Bit definition for CEC_IER register  ********************/
#define CEC_IER_RXBRIE_Pos       (0U)
#define CEC_IER_RXBRIE_Msk       (0x1UL << CEC_IER_RXBRIE_Pos)                 /*!< 0x00000001 */
#define CEC_IER_RXBRIE           CEC_IER_RXBRIE_Msk                            /*!< CEC Rx-Byte Received IT Enable            */
#define CEC_IER_RXENDIE_Pos      (1U)
#define CEC_IER_RXENDIE_Msk      (0x1UL << CEC_IER_RXENDIE_Pos)                /*!< 0x00000002 */
#define CEC_IER_RXENDIE          CEC_IER_RXENDIE_Msk                           /*!< CEC End Of Reception IT Enable            */
#define CEC_IER_RXOVRIE_Pos      (2U)
#define CEC_IER_RXOVRIE_Msk      (0x1UL << CEC_IER_RXOVRIE_Pos)                /*!< 0x00000004 */
#define CEC_IER_RXOVRIE          CEC_IER_RXOVRIE_Msk                           /*!< CEC Rx-Overrun IT Enable                  */
#define CEC_IER_BREIE_Pos        (3U)
#define CEC_IER_BREIE_Msk        (0x1UL << CEC_IER_BREIE_Pos)                  /*!< 0x00000008 */
#define CEC_IER_BREIE            CEC_IER_BREIE_Msk                             /*!< CEC Rx Bit Rising Error IT Enable         */
#define CEC_IER_SBPEIE_Pos       (4U)
#define CEC_IER_SBPEIE_Msk       (0x1UL << CEC_IER_SBPEIE_Pos)                 /*!< 0x00000010 */
#define CEC_IER_SBPEIE           CEC_IER_SBPEIE_Msk                            /*!< CEC Rx Short Bit period Error IT Enable   */
#define CEC_IER_LBPEIE_Pos       (5U)
#define CEC_IER_LBPEIE_Msk       (0x1UL << CEC_IER_LBPEIE_Pos)                 /*!< 0x00000020 */
#define CEC_IER_LBPEIE           CEC_IER_LBPEIE_Msk                            /*!< CEC Rx Long Bit period Error IT Enable    */
#define CEC_IER_RXACKEIE_Pos     (6U)
#define CEC_IER_RXACKEIE_Msk     (0x1UL << CEC_IER_RXACKEIE_Pos)               /*!< 0x00000040 */
#define CEC_IER_RXACKEIE         CEC_IER_RXACKEIE_Msk                          /*!< CEC Rx Missing Acknowledge IT Enable      */
#define CEC_IER_ARBLSTIE_Pos     (7U)
#define CEC_IER_ARBLSTIE_Msk     (0x1UL << CEC_IER_ARBLSTIE_Pos)               /*!< 0x00000080 */
#define CEC_IER_ARBLSTIE         CEC_IER_ARBLSTIE_Msk                          /*!< CEC Arbitration Lost IT Enable            */
#define CEC_IER_TXBRIE_Pos       (8U)
#define CEC_IER_TXBRIE_Msk       (0x1UL << CEC_IER_TXBRIE_Pos)                 /*!< 0x00000100 */
#define CEC_IER_TXBRIE           CEC_IER_TXBRIE_Msk                            /*!< CEC Tx Byte Request  IT Enable            */
#define CEC_IER_TXENDIE_Pos      (9U)
#define CEC_IER_TXENDIE_Msk      (0x1UL << CEC_IER_TXENDIE_Pos)                /*!< 0x00000200 */
#define CEC_IER_TXENDIE          CEC_IER_TXENDIE_Msk                           /*!< CEC End of Transmission IT Enable         */
#define CEC_IER_TXUDRIE_Pos      (10U)
#define CEC_IER_TXUDRIE_Msk      (0x1UL << CEC_IER_TXUDRIE_Pos)                /*!< 0x00000400 */
#define CEC_IER_TXUDRIE          CEC_IER_TXUDRIE_Msk                           /*!< CEC Tx-Buffer Underrun IT Enable          */
#define CEC_IER_TXERRIE_Pos      (11U)
#define CEC_IER_TXERRIE_Msk      (0x1UL << CEC_IER_TXERRIE_Pos)                /*!< 0x00000800 */
#define CEC_IER_TXERRIE          CEC_IER_TXERRIE_Msk                           /*!< CEC Tx-Error IT Enable                    */
#define CEC_IER_TXACKEIE_Pos     (12U)
#define CEC_IER_TXACKEIE_Msk     (0x1UL << CEC_IER_TXACKEIE_Pos)               /*!< 0x00001000 */
#define CEC_IER_TXACKEIE         CEC_IER_TXACKEIE_Msk                          /*!< CEC Tx Missing Acknowledge IT Enable      */

/******************************************************************************/
/*                                                                            */
/*                          CORDIC calculation unit                           */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for CORDIC_CSR register  *****************/
#define CORDIC_CSR_FUNC_Pos      (0U)
#define CORDIC_CSR_FUNC_Msk      (0xFUL << CORDIC_CSR_FUNC_Pos)                /*!< 0x0000000F */
#define CORDIC_CSR_FUNC          CORDIC_CSR_FUNC_Msk                           /*!< Function */
#define CORDIC_CSR_FUNC_0        (0x1UL << CORDIC_CSR_FUNC_Pos)                /*!< 0x00000001 */
#define CORDIC_CSR_FUNC_1        (0x2UL << CORDIC_CSR_FUNC_Pos)                /*!< 0x00000002 */
#define CORDIC_CSR_FUNC_2        (0x4UL << CORDIC_CSR_FUNC_Pos)                /*!< 0x00000004 */
#define CORDIC_CSR_FUNC_3        (0x8UL << CORDIC_CSR_FUNC_Pos)                /*!< 0x00000008 */
#define CORDIC_CSR_PRECISION_Pos (4U)
#define CORDIC_CSR_PRECISION_Msk (0xFUL << CORDIC_CSR_PRECISION_Pos)           /*!< 0x000000F0 */
#define CORDIC_CSR_PRECISION     CORDIC_CSR_PRECISION_Msk                      /*!< Precision */
#define CORDIC_CSR_PRECISION_0   (0x1UL << CORDIC_CSR_PRECISION_Pos)           /*!< 0x00000010 */
#define CORDIC_CSR_PRECISION_1   (0x2UL << CORDIC_CSR_PRECISION_Pos)           /*!< 0x00000020 */
#define CORDIC_CSR_PRECISION_2   (0x4UL << CORDIC_CSR_PRECISION_Pos)           /*!< 0x00000040 */
#define CORDIC_CSR_PRECISION_3   (0x8UL << CORDIC_CSR_PRECISION_Pos)           /*!< 0x00000080 */
#define CORDIC_CSR_SCALE_Pos     (8U)
#define CORDIC_CSR_SCALE_Msk     (0x7UL << CORDIC_CSR_SCALE_Pos)               /*!< 0x00000700 */
#define CORDIC_CSR_SCALE         CORDIC_CSR_SCALE_Msk                          /*!< Scaling factor */
#define CORDIC_CSR_SCALE_0       (0x1UL << CORDIC_CSR_SCALE_Pos)               /*!< 0x00000100 */
#define CORDIC_CSR_SCALE_1       (0x2UL << CORDIC_CSR_SCALE_Pos)               /*!< 0x00000200 */
#define CORDIC_CSR_SCALE_2       (0x4UL << CORDIC_CSR_SCALE_Pos)               /*!< 0x00000400 */
#define CORDIC_CSR_IEN_Pos       (16U)
#define CORDIC_CSR_IEN_Msk       (0x1UL << CORDIC_CSR_IEN_Pos)                 /*!< 0x00010000 */
#define CORDIC_CSR_IEN           CORDIC_CSR_IEN_Msk                            /*!< Interrupt Enable */
#define CORDIC_CSR_DMAREN_Pos    (17U)
#define CORDIC_CSR_DMAREN_Msk    (0x1UL << CORDIC_CSR_DMAREN_Pos)              /*!< 0x00020000 */
#define CORDIC_CSR_DMAREN        CORDIC_CSR_DMAREN_Msk                         /*!< DMA Read channel Enable */
#define CORDIC_CSR_DMAWEN_Pos    (18U)
#define CORDIC_CSR_DMAWEN_Msk    (0x1UL << CORDIC_CSR_DMAWEN_Pos)              /*!< 0x00040000 */
#define CORDIC_CSR_DMAWEN        CORDIC_CSR_DMAWEN_Msk                         /*!< DMA Write channel Enable */
#define CORDIC_CSR_NRES_Pos      (19U)
#define CORDIC_CSR_NRES_Msk      (0x1UL << CORDIC_CSR_NRES_Pos)                /*!< 0x00080000 */
#define CORDIC_CSR_NRES          CORDIC_CSR_NRES_Msk                           /*!< Number of results in WDATA register */
#define CORDIC_CSR_NARGS_Pos     (20U)
#define CORDIC_CSR_NARGS_Msk     (0x1UL << CORDIC_CSR_NARGS_Pos)               /*!< 0x00100000 */
#define CORDIC_CSR_NARGS         CORDIC_CSR_NARGS_Msk                          /*!< Number of arguments in RDATA register */
#define CORDIC_CSR_RESSIZE_Pos   (21U)
#define CORDIC_CSR_RESSIZE_Msk   (0x1UL << CORDIC_CSR_RESSIZE_Pos)             /*!< 0x00200000 */
#define CORDIC_CSR_RESSIZE       CORDIC_CSR_RESSIZE_Msk                        /*!< Width of output data */
#define CORDIC_CSR_ARGSIZE_Pos   (22U)
#define CORDIC_CSR_ARGSIZE_Msk   (0x1UL << CORDIC_CSR_ARGSIZE_Pos)             /*!< 0x00400000 */
#define CORDIC_CSR_ARGSIZE       CORDIC_CSR_ARGSIZE_Msk                        /*!< Width of input data */
#define CORDIC_CSR_RRDY_Pos      (31U)
#define CORDIC_CSR_RRDY_Msk      (0x1UL << CORDIC_CSR_RRDY_Pos)                /*!< 0x80000000 */
#define CORDIC_CSR_RRDY          CORDIC_CSR_RRDY_Msk                           /*!< Result Ready Flag */

/*******************  Bit definition for CORDIC_WDATA register  ***************/
#define CORDIC_WDATA_ARG_Pos     (0U)
#define CORDIC_WDATA_ARG_Msk     (0xFFFFFFFFUL << CORDIC_WDATA_ARG_Pos)        /*!< 0xFFFFFFFF */
#define CORDIC_WDATA_ARG         CORDIC_WDATA_ARG_Msk                          /*!< Input Argument */

/*******************  Bit definition for CORDIC_RDATA register  ***************/
#define CORDIC_RDATA_RES_Pos     (0U)
#define CORDIC_RDATA_RES_Msk     (0xFFFFFFFFUL << CORDIC_RDATA_RES_Pos)        /*!< 0xFFFFFFFF */
#define CORDIC_RDATA_RES         CORDIC_RDATA_RES_Msk                          /*!< Output Result */

/******************************************************************************/
/*                                                                            */
/*                          CRC calculation unit                              */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for CRC_DR register  *********************/
#define CRC_DR_DR_Pos            (0U)
#define CRC_DR_DR_Msk            (0xFFFFFFFFUL << CRC_DR_DR_Pos)               /*!< 0xFFFFFFFF */
#define CRC_DR_DR                CRC_DR_DR_Msk                                 /*!< Data register bits */

/*******************  Bit definition for CRC_IDR register  ********************/
#define CRC_IDR_IDR_Pos          (0U)
#define CRC_IDR_IDR_Msk          (0xFFFFFFFFUL << CRC_IDR_IDR_Pos)             /*!< 0xFFFFFFFF */
#define CRC_IDR_IDR              CRC_IDR_IDR_Msk                               /*!< General-purpose 32-bit data register bits */

/********************  Bit definition for CRC_CR register  ********************/
#define CRC_CR_RESET_Pos         (0U)
#define CRC_CR_RESET_Msk         (0x1UL << CRC_CR_RESET_Pos)                   /*!< 0x00000001 */
#define CRC_CR_RESET             CRC_CR_RESET_Msk                              /*!< RESET the CRC computation unit bit */
#define CRC_CR_POLYSIZE_Pos      (3U)
#define CRC_CR_POLYSIZE_Msk      (0x3UL << CRC_CR_POLYSIZE_Pos)                /*!< 0x00000018 */
#define CRC_CR_POLYSIZE          CRC_CR_POLYSIZE_Msk                           /*!< Polynomial size bits */
#define CRC_CR_POLYSIZE_0        (0x1UL << CRC_CR_POLYSIZE_Pos)                 /*!< 0x00000008 */
#define CRC_CR_POLYSIZE_1        (0x2UL << CRC_CR_POLYSIZE_Pos)                 /*!< 0x00000010 */
#define CRC_CR_REV_IN_Pos        (5U)
#define CRC_CR_REV_IN_Msk        (0x3UL << CRC_CR_REV_IN_Pos)                  /*!< 0x00000060 */
#define CRC_CR_REV_IN            CRC_CR_REV_IN_Msk                             /*!< REV_IN Reverse Input Data bits */
#define CRC_CR_REV_IN_0          (0x1UL << CRC_CR_REV_IN_Pos)                   /*!< 0x00000020 */
#define CRC_CR_REV_IN_1          (0x2UL << CRC_CR_REV_IN_Pos)                   /*!< 0x00000040 */
#define CRC_CR_REV_OUT_Pos       (7U)
#define CRC_CR_REV_OUT_Msk       (0x1UL << CRC_CR_REV_OUT_Pos)                 /*!< 0x00000080 */
#define CRC_CR_REV_OUT           CRC_CR_REV_OUT_Msk                            /*!< REV_OUT Reverse Output Data bits */

/*******************  Bit definition for CRC_INIT register  *******************/
#define CRC_INIT_INIT_Pos        (0U)
#define CRC_INIT_INIT_Msk        (0xFFFFFFFFUL << CRC_INIT_INIT_Pos)           /*!< 0xFFFFFFFF */
#define CRC_INIT_INIT            CRC_INIT_INIT_Msk                             /*!< Initial CRC value bits */

/*******************  Bit definition for CRC_POL register  ********************/
#define CRC_POL_POL_Pos          (0U)
#define CRC_POL_POL_Msk          (0xFFFFFFFFUL << CRC_POL_POL_Pos)             /*!< 0xFFFFFFFF */
#define CRC_POL_POL              CRC_POL_POL_Msk                               /*!< Coefficients of the polynomial */

/******************************************************************************/
/*                                                                            */
/*                          CRS Clock Recovery System                         */
/******************************************************************************/

/*******************  Bit definition for CRS_CR register  *********************/
#define CRS_CR_SYNCOKIE_Pos       (0U)
#define CRS_CR_SYNCOKIE_Msk       (0x1UL << CRS_CR_SYNCOKIE_Pos)               /*!< 0x00000001 */
#define CRS_CR_SYNCOKIE           CRS_CR_SYNCOKIE_Msk                          /*!< SYNC event OK interrupt enable */
#define CRS_CR_SYNCWARNIE_Pos     (1U)
#define CRS_CR_SYNCWARNIE_Msk     (0x1UL << CRS_CR_SYNCWARNIE_Pos)             /*!< 0x00000002 */
#define CRS_CR_SYNCWARNIE         CRS_CR_SYNCWARNIE_Msk                        /*!< SYNC warning interrupt enable */
#define CRS_CR_ERRIE_Pos          (2U)
#define CRS_CR_ERRIE_Msk          (0x1UL << CRS_CR_ERRIE_Pos)                  /*!< 0x00000004 */
#define CRS_CR_ERRIE              CRS_CR_ERRIE_Msk                             /*!< SYNC error or trimming error interrupt enable */
#define CRS_CR_ESYNCIE_Pos        (3U)
#define CRS_CR_ESYNCIE_Msk        (0x1UL << CRS_CR_ESYNCIE_Pos)                /*!< 0x00000008 */
#define CRS_CR_ESYNCIE            CRS_CR_ESYNCIE_Msk                           /*!< Expected SYNC interrupt enable */
#define CRS_CR_CEN_Pos            (5U)
#define CRS_CR_CEN_Msk            (0x1UL << CRS_CR_CEN_Pos)                    /*!< 0x00000020 */
#define CRS_CR_CEN                CRS_CR_CEN_Msk                               /*!< Frequency error counter enable */
#define CRS_CR_AUTOTRIMEN_Pos     (6U)
#define CRS_CR_AUTOTRIMEN_Msk     (0x1UL << CRS_CR_AUTOTRIMEN_Pos)             /*!< 0x00000040 */
#define CRS_CR_AUTOTRIMEN         CRS_CR_AUTOTRIMEN_Msk                        /*!< Automatic trimming enable */
#define CRS_CR_SWSYNC_Pos         (7U)
#define CRS_CR_SWSYNC_Msk         (0x1UL << CRS_CR_SWSYNC_Pos)                 /*!< 0x00000080 */
#define CRS_CR_SWSYNC             CRS_CR_SWSYNC_Msk                            /*!< Generate software SYNC event */
#define CRS_CR_TRIM_Pos           (8U)
#define CRS_CR_TRIM_Msk           (0x3FUL << CRS_CR_TRIM_Pos)                  /*!< 0x00003F00 */
#define CRS_CR_TRIM               CRS_CR_TRIM_Msk                              /*!< HSI48 oscillator smooth trimming */

/*******************  Bit definition for CRS_CFGR register  *********************/
#define CRS_CFGR_RELOAD_Pos       (0U)
#define CRS_CFGR_RELOAD_Msk       (0xFFFFUL << CRS_CFGR_RELOAD_Pos)            /*!< 0x0000FFFF */
#define CRS_CFGR_RELOAD           CRS_CFGR_RELOAD_Msk                          /*!< Counter reload value */
#define CRS_CFGR_FELIM_Pos        (16U)
#define CRS_CFGR_FELIM_Msk        (0xFFUL << CRS_CFGR_FELIM_Pos)               /*!< 0x00FF0000 */
#define CRS_CFGR_FELIM            CRS_CFGR_FELIM_Msk                           /*!< Frequency error limit */

#define CRS_CFGR_SYNCDIV_Pos      (24U)
#define CRS_CFGR_SYNCDIV_Msk      (0x7UL << CRS_CFGR_SYNCDIV_Pos)              /*!< 0x07000000 */
#define CRS_CFGR_SYNCDIV          CRS_CFGR_SYNCDIV_Msk                         /*!< SYNC divider */
#define CRS_CFGR_SYNCDIV_0        (0x1UL << CRS_CFGR_SYNCDIV_Pos)               /*!< 0x01000000 */
#define CRS_CFGR_SYNCDIV_1        (0x2UL << CRS_CFGR_SYNCDIV_Pos)               /*!< 0x02000000 */
#define CRS_CFGR_SYNCDIV_2        (0x4UL << CRS_CFGR_SYNCDIV_Pos)               /*!< 0x04000000 */

#define CRS_CFGR_SYNCSRC_Pos      (28U)
#define CRS_CFGR_SYNCSRC_Msk      (0x3UL << CRS_CFGR_SYNCSRC_Pos)              /*!< 0x30000000 */
#define CRS_CFGR_SYNCSRC          CRS_CFGR_SYNCSRC_Msk                         /*!< SYNC signal source selection */
#define CRS_CFGR_SYNCSRC_0        (0x1UL << CRS_CFGR_SYNCSRC_Pos)               /*!< 0x10000000 */
#define CRS_CFGR_SYNCSRC_1        (0x2UL << CRS_CFGR_SYNCSRC_Pos)               /*!< 0x20000000 */

#define CRS_CFGR_SYNCPOL_Pos      (31U)
#define CRS_CFGR_SYNCPOL_Msk      (0x1UL << CRS_CFGR_SYNCPOL_Pos)              /*!< 0x80000000 */
#define CRS_CFGR_SYNCPOL          CRS_CFGR_SYNCPOL_Msk                         /*!< SYNC polarity selection */

/*******************  Bit definition for CRS_ISR register  *********************/
#define CRS_ISR_SYNCOKF_Pos       (0U)
#define CRS_ISR_SYNCOKF_Msk       (0x1UL << CRS_ISR_SYNCOKF_Pos)               /*!< 0x00000001 */
#define CRS_ISR_SYNCOKF           CRS_ISR_SYNCOKF_Msk                          /*!< SYNC event OK flag */
#define CRS_ISR_SYNCWARNF_Pos     (1U)
#define CRS_ISR_SYNCWARNF_Msk     (0x1UL << CRS_ISR_SYNCWARNF_Pos)             /*!< 0x00000002 */
#define CRS_ISR_SYNCWARNF         CRS_ISR_SYNCWARNF_Msk                        /*!< SYNC warning flag */
#define CRS_ISR_ERRF_Pos          (2U)
#define CRS_ISR_ERRF_Msk          (0x1UL << CRS_ISR_ERRF_Pos)                  /*!< 0x00000004 */
#define CRS_ISR_ERRF              CRS_ISR_ERRF_Msk                             /*!< Error flag */
#define CRS_ISR_ESYNCF_Pos        (3U)
#define CRS_ISR_ESYNCF_Msk        (0x1UL << CRS_ISR_ESYNCF_Pos)                /*!< 0x00000008 */
#define CRS_ISR_ESYNCF            CRS_ISR_ESYNCF_Msk                           /*!< Expected SYNC flag */
#define CRS_ISR_SYNCERR_Pos       (8U)
#define CRS_ISR_SYNCERR_Msk       (0x1UL << CRS_ISR_SYNCERR_Pos)               /*!< 0x00000100 */
#define CRS_ISR_SYNCERR           CRS_ISR_SYNCERR_Msk                          /*!< SYNC error */
#define CRS_ISR_SYNCMISS_Pos      (9U)
#define CRS_ISR_SYNCMISS_Msk      (0x1UL << CRS_ISR_SYNCMISS_Pos)              /*!< 0x00000200 */
#define CRS_ISR_SYNCMISS          CRS_ISR_SYNCMISS_Msk                         /*!< SYNC missed */
#define CRS_ISR_TRIMOVF_Pos       (10U)
#define CRS_ISR_TRIMOVF_Msk       (0x1UL << CRS_ISR_TRIMOVF_Pos)               /*!< 0x00000400 */
#define CRS_ISR_TRIMOVF           CRS_ISR_TRIMOVF_Msk                          /*!< Trimming overflow or underflow */
#define CRS_ISR_FEDIR_Pos         (15U)
#define CRS_ISR_FEDIR_Msk         (0x1UL << CRS_ISR_FEDIR_Pos)                 /*!< 0x00008000 */
#define CRS_ISR_FEDIR             CRS_ISR_FEDIR_Msk                            /*!< Frequency error direction */
#define CRS_ISR_FECAP_Pos         (16U)
#define CRS_ISR_FECAP_Msk         (0xFFFFUL << CRS_ISR_FECAP_Pos)              /*!< 0xFFFF0000 */
#define CRS_ISR_FECAP             CRS_ISR_FECAP_Msk                            /*!< Frequency error capture */

/*******************  Bit definition for CRS_ICR register  *********************/
#define CRS_ICR_SYNCOKC_Pos       (0U)
#define CRS_ICR_SYNCOKC_Msk       (0x1UL << CRS_ICR_SYNCOKC_Pos)               /*!< 0x00000001 */
#define CRS_ICR_SYNCOKC           CRS_ICR_SYNCOKC_Msk                          /*!< SYNC event OK clear flag */
#define CRS_ICR_SYNCWARNC_Pos     (1U)
#define CRS_ICR_SYNCWARNC_Msk     (0x1UL << CRS_ICR_SYNCWARNC_Pos)             /*!< 0x00000002 */
#define CRS_ICR_SYNCWARNC         CRS_ICR_SYNCWARNC_Msk                        /*!< SYNC warning clear flag */
#define CRS_ICR_ERRC_Pos          (2U)
#define CRS_ICR_ERRC_Msk          (0x1UL << CRS_ICR_ERRC_Pos)                  /*!< 0x00000004 */
#define CRS_ICR_ERRC              CRS_ICR_ERRC_Msk                             /*!< Error clear flag */
#define CRS_ICR_ESYNCC_Pos        (3U)
#define CRS_ICR_ESYNCC_Msk        (0x1UL << CRS_ICR_ESYNCC_Pos)                /*!< 0x00000008 */
#define CRS_ICR_ESYNCC            CRS_ICR_ESYNCC_Msk                           /*!< Expected SYNC clear flag */

/******************************************************************************/
/*                                                                            */
/*                            Crypto Processor                                */
/*                                                                            */
/******************************************************************************/
/********************************  CRYP VER  **********************************/
#define  CRYP_VER_2_2
/******************* Bits definition for CRYP_CR register  ********************/
#define CRYP_CR_ALGODIR_Pos              (2U)
#define CRYP_CR_ALGODIR_Msk              (0x1UL << CRYP_CR_ALGODIR_Pos)        /*!< 0x00000004 */
#define CRYP_CR_ALGODIR                  CRYP_CR_ALGODIR_Msk

#define CRYP_CR_ALGOMODE_Pos             (3U)
#define CRYP_CR_ALGOMODE_Msk             (0x10007UL << CRYP_CR_ALGOMODE_Pos)   /*!< 0x00080038 */
#define CRYP_CR_ALGOMODE                 CRYP_CR_ALGOMODE_Msk
#define CRYP_CR_ALGOMODE_0               (0x00001UL << CRYP_CR_ALGOMODE_Pos)    /*!< 0x00000008 */
#define CRYP_CR_ALGOMODE_1               (0x00002UL << CRYP_CR_ALGOMODE_Pos)    /*!< 0x00000010 */
#define CRYP_CR_ALGOMODE_2               (0x00004UL << CRYP_CR_ALGOMODE_Pos)    /*!< 0x00000020 */
#define CRYP_CR_ALGOMODE_TDES_ECB        ((uint32_t)0x00000000)
#define CRYP_CR_ALGOMODE_TDES_CBC_Pos    (3U)
#define CRYP_CR_ALGOMODE_TDES_CBC_Msk    (0x1UL << CRYP_CR_ALGOMODE_TDES_CBC_Pos) /*!< 0x00000008 */
#define CRYP_CR_ALGOMODE_TDES_CBC        CRYP_CR_ALGOMODE_TDES_CBC_Msk
#define CRYP_CR_ALGOMODE_DES_ECB_Pos     (4U)
#define CRYP_CR_ALGOMODE_DES_ECB_Msk     (0x1UL << CRYP_CR_ALGOMODE_DES_ECB_Pos) /*!< 0x00000010 */
#define CRYP_CR_ALGOMODE_DES_ECB         CRYP_CR_ALGOMODE_DES_ECB_Msk
#define CRYP_CR_ALGOMODE_DES_CBC_Pos     (3U)
#define CRYP_CR_ALGOMODE_DES_CBC_Msk     (0x3UL << CRYP_CR_ALGOMODE_DES_CBC_Pos) /*!< 0x00000018 */
#define CRYP_CR_ALGOMODE_DES_CBC         CRYP_CR_ALGOMODE_DES_CBC_Msk
#define CRYP_CR_ALGOMODE_AES_ECB_Pos     (5U)
#define CRYP_CR_ALGOMODE_AES_ECB_Msk     (0x1UL << CRYP_CR_ALGOMODE_AES_ECB_Pos) /*!< 0x00000020 */
#define CRYP_CR_ALGOMODE_AES_ECB         CRYP_CR_ALGOMODE_AES_ECB_Msk
#define CRYP_CR_ALGOMODE_AES_CBC_Pos     (3U)
#define CRYP_CR_ALGOMODE_AES_CBC_Msk     (0x5UL << CRYP_CR_ALGOMODE_AES_CBC_Pos) /*!< 0x00000028 */
#define CRYP_CR_ALGOMODE_AES_CBC         CRYP_CR_ALGOMODE_AES_CBC_Msk
#define CRYP_CR_ALGOMODE_AES_CTR_Pos     (4U)
#define CRYP_CR_ALGOMODE_AES_CTR_Msk     (0x3UL << CRYP_CR_ALGOMODE_AES_CTR_Pos) /*!< 0x00000030 */
#define CRYP_CR_ALGOMODE_AES_CTR         CRYP_CR_ALGOMODE_AES_CTR_Msk
#define CRYP_CR_ALGOMODE_AES_KEY_Pos     (3U)
#define CRYP_CR_ALGOMODE_AES_KEY_Msk     (0x7UL << CRYP_CR_ALGOMODE_AES_KEY_Pos) /*!< 0x00000038 */
#define CRYP_CR_ALGOMODE_AES_KEY         CRYP_CR_ALGOMODE_AES_KEY_Msk
#define CRYP_CR_ALGOMODE_AES_GCM_Pos     (19U)
#define CRYP_CR_ALGOMODE_AES_GCM_Msk     (0x1UL << CRYP_CR_ALGOMODE_AES_GCM_Pos) /*!< 0x00080000 */
#define CRYP_CR_ALGOMODE_AES_GCM         CRYP_CR_ALGOMODE_AES_GCM_Msk
#define CRYP_CR_ALGOMODE_AES_CCM_Pos     (3U)
#define CRYP_CR_ALGOMODE_AES_CCM_Msk     (0x10001UL << CRYP_CR_ALGOMODE_AES_CCM_Pos) /*!< 0x00080008 */
#define CRYP_CR_ALGOMODE_AES_CCM         CRYP_CR_ALGOMODE_AES_CCM_Msk

#define CRYP_CR_DATATYPE_Pos             (6U)
#define CRYP_CR_DATATYPE_Msk             (0x3UL << CRYP_CR_DATATYPE_Pos)       /*!< 0x000000C0 */
#define CRYP_CR_DATATYPE                 CRYP_CR_DATATYPE_Msk
#define CRYP_CR_DATATYPE_0               (0x1UL << CRYP_CR_DATATYPE_Pos)        /*!< 0x00000040 */
#define CRYP_CR_DATATYPE_1               (0x2UL << CRYP_CR_DATATYPE_Pos)        /*!< 0x00000080 */
#define CRYP_CR_KEYSIZE_Pos              (8U)
#define CRYP_CR_KEYSIZE_Msk              (0x3UL << CRYP_CR_KEYSIZE_Pos)        /*!< 0x00000300 */
#define CRYP_CR_KEYSIZE                  CRYP_CR_KEYSIZE_Msk
#define CRYP_CR_KEYSIZE_0                (0x1UL << CRYP_CR_KEYSIZE_Pos)         /*!< 0x00000100 */
#define CRYP_CR_KEYSIZE_1                (0x2UL << CRYP_CR_KEYSIZE_Pos)         /*!< 0x00000200 */
#define CRYP_CR_FFLUSH_Pos               (14U)
#define CRYP_CR_FFLUSH_Msk               (0x1UL << CRYP_CR_FFLUSH_Pos)         /*!< 0x00004000 */
#define CRYP_CR_FFLUSH                   CRYP_CR_FFLUSH_Msk
#define CRYP_CR_CRYPEN_Pos               (15U)
#define CRYP_CR_CRYPEN_Msk               (0x1UL << CRYP_CR_CRYPEN_Pos)         /*!< 0x00008000 */
#define CRYP_CR_CRYPEN                   CRYP_CR_CRYPEN_Msk

#define CRYP_CR_GCM_CCMPH_Pos            (16U)
#define CRYP_CR_GCM_CCMPH_Msk            (0x3UL << CRYP_CR_GCM_CCMPH_Pos)      /*!< 0x00030000 */
#define CRYP_CR_GCM_CCMPH                CRYP_CR_GCM_CCMPH_Msk
#define CRYP_CR_GCM_CCMPH_0              (0x1UL << CRYP_CR_GCM_CCMPH_Pos)       /*!< 0x00010000 */
#define CRYP_CR_GCM_CCMPH_1              (0x2UL << CRYP_CR_GCM_CCMPH_Pos)       /*!< 0x00020000 */
#define CRYP_CR_ALGOMODE_3               ((uint32_t)0x00080000)
#define CRYP_CR_NPBLB_Pos                (20U)
#define CRYP_CR_NPBLB_Msk                (0xFUL << CRYP_CR_NPBLB_Pos)          /*!< 0x00F00000 */
#define CRYP_CR_NPBLB                    CRYP_CR_NPBLB_Msk

/****************** Bits definition for CRYP_SR register  *********************/
#define CRYP_SR_IFEM_Pos                 (0U)
#define CRYP_SR_IFEM_Msk                 (0x1UL << CRYP_SR_IFEM_Pos)           /*!< 0x00000001 */
#define CRYP_SR_IFEM                     CRYP_SR_IFEM_Msk
#define CRYP_SR_IFNF_Pos                 (1U)
#define CRYP_SR_IFNF_Msk                 (0x1UL << CRYP_SR_IFNF_Pos)           /*!< 0x00000002 */
#define CRYP_SR_IFNF                     CRYP_SR_IFNF_Msk
#define CRYP_SR_OFNE_Pos                 (2U)
#define CRYP_SR_OFNE_Msk                 (0x1UL << CRYP_SR_OFNE_Pos)           /*!< 0x00000004 */
#define CRYP_SR_OFNE                     CRYP_SR_OFNE_Msk
#define CRYP_SR_OFFU_Pos                 (3U)
#define CRYP_SR_OFFU_Msk                 (0x1UL << CRYP_SR_OFFU_Pos)           /*!< 0x00000008 */
#define CRYP_SR_OFFU                     CRYP_SR_OFFU_Msk
#define CRYP_SR_BUSY_Pos                 (4U)
#define CRYP_SR_BUSY_Msk                 (0x1UL << CRYP_SR_BUSY_Pos)           /*!< 0x00000010 */
#define CRYP_SR_BUSY                     CRYP_SR_BUSY_Msk
/****************** Bits definition for CRYP_DMACR register  ******************/
#define CRYP_DMACR_DIEN_Pos              (0U)
#define CRYP_DMACR_DIEN_Msk              (0x1UL << CRYP_DMACR_DIEN_Pos)        /*!< 0x00000001 */
#define CRYP_DMACR_DIEN                  CRYP_DMACR_DIEN_Msk
#define CRYP_DMACR_DOEN_Pos              (1U)
#define CRYP_DMACR_DOEN_Msk              (0x1UL << CRYP_DMACR_DOEN_Pos)        /*!< 0x00000002 */
#define CRYP_DMACR_DOEN                  CRYP_DMACR_DOEN_Msk
/*****************  Bits definition for CRYP_IMSCR register  ******************/
#define CRYP_IMSCR_INIM_Pos              (0U)
#define CRYP_IMSCR_INIM_Msk              (0x1UL << CRYP_IMSCR_INIM_Pos)        /*!< 0x00000001 */
#define CRYP_IMSCR_INIM                  CRYP_IMSCR_INIM_Msk
#define CRYP_IMSCR_OUTIM_Pos             (1U)
#define CRYP_IMSCR_OUTIM_Msk             (0x1UL << CRYP_IMSCR_OUTIM_Pos)       /*!< 0x00000002 */
#define CRYP_IMSCR_OUTIM                 CRYP_IMSCR_OUTIM_Msk
/****************** Bits definition for CRYP_RISR register  *******************/
#define CRYP_RISR_INRIS_Pos              (0U)
#define CRYP_RISR_INRIS_Msk              (0x1UL << CRYP_RISR_INRIS_Pos)        /*!< 0x00000001 */
#define CRYP_RISR_INRIS                  CRYP_RISR_INRIS_Msk
#define CRYP_RISR_OUTRIS_Pos             (1U)
#define CRYP_RISR_OUTRIS_Msk             (0x1UL << CRYP_RISR_OUTRIS_Pos)       /*!< 0x00000002 */
#define CRYP_RISR_OUTRIS                 CRYP_RISR_OUTRIS_Msk
/****************** Bits definition for CRYP_MISR register  *******************/
#define CRYP_MISR_INMIS_Pos              (0U)
#define CRYP_MISR_INMIS_Msk              (0x1UL << CRYP_MISR_INMIS_Pos)        /*!< 0x00000001 */
#define CRYP_MISR_INMIS                  CRYP_MISR_INMIS_Msk
#define CRYP_MISR_OUTMIS_Pos             (1U)
#define CRYP_MISR_OUTMIS_Msk             (0x1UL << CRYP_MISR_OUTMIS_Pos)       /*!< 0x00000002 */
#define CRYP_MISR_OUTMIS                 CRYP_MISR_OUTMIS_Msk

/******************************************************************************/
/*                                                                            */
/*                      Digital to Analog Converter                           */
/*                                                                            */
/******************************************************************************/
/********************  Bit definition for DAC_CR register  ********************/
#define DAC_CR_EN1_Pos              (0U)
#define DAC_CR_EN1_Msk              (0x1UL << DAC_CR_EN1_Pos)                  /*!< 0x00000001 */
#define DAC_CR_EN1                  DAC_CR_EN1_Msk                             /*!<DAC channel1 enable */
#define DAC_CR_TEN1_Pos             (1U)
#define DAC_CR_TEN1_Msk             (0x1UL << DAC_CR_TEN1_Pos)                 /*!< 0x00000002 */
#define DAC_CR_TEN1                 DAC_CR_TEN1_Msk                            /*!<DAC channel1 Trigger enable */

#define DAC_CR_TSEL1_Pos            (2U)
#define DAC_CR_TSEL1_Msk            (0xFUL << DAC_CR_TSEL1_Pos)                /*!< 0x0000003C */
#define DAC_CR_TSEL1                DAC_CR_TSEL1_Msk                           /*!<TSEL1[2:0] (DAC channel1 Trigger selection) */
#define DAC_CR_TSEL1_0              (0x1UL << DAC_CR_TSEL1_Pos)                 /*!< 0x00000004 */
#define DAC_CR_TSEL1_1              (0x2UL << DAC_CR_TSEL1_Pos)                 /*!< 0x00000008 */
#define DAC_CR_TSEL1_2              (0x4UL << DAC_CR_TSEL1_Pos)                 /*!< 0x00000010 */
#define DAC_CR_TSEL1_3              (0x8UL << DAC_CR_TSEL1_Pos)                 /*!< 0x00000020 */


#define DAC_CR_WAVE1_Pos            (6U)
#define DAC_CR_WAVE1_Msk            (0x3UL << DAC_CR_WAVE1_Pos)                /*!< 0x000000C0 */
#define DAC_CR_WAVE1                DAC_CR_WAVE1_Msk                           /*!<WAVE1[1:0] (DAC channel1 noise/triangle wave generation enable) */
#define DAC_CR_WAVE1_0              (0x1UL << DAC_CR_WAVE1_Pos)                 /*!< 0x00000040 */
#define DAC_CR_WAVE1_1              (0x2UL << DAC_CR_WAVE1_Pos)                 /*!< 0x00000080 */

#define DAC_CR_MAMP1_Pos            (8U)
#define DAC_CR_MAMP1_Msk            (0xFUL << DAC_CR_MAMP1_Pos)                /*!< 0x00000F00 */
#define DAC_CR_MAMP1                DAC_CR_MAMP1_Msk                           /*!<MAMP1[3:0] (DAC channel1 Mask/Amplitude selector) */
#define DAC_CR_MAMP1_0              (0x1UL << DAC_CR_MAMP1_Pos)                 /*!< 0x00000100 */
#define DAC_CR_MAMP1_1              (0x2UL << DAC_CR_MAMP1_Pos)                 /*!< 0x00000200 */
#define DAC_CR_MAMP1_2              (0x4UL << DAC_CR_MAMP1_Pos)                 /*!< 0x00000400 */
#define DAC_CR_MAMP1_3              (0x8UL << DAC_CR_MAMP1_Pos)                 /*!< 0x00000800 */

#define DAC_CR_DMAEN1_Pos           (12U)
#define DAC_CR_DMAEN1_Msk           (0x1UL << DAC_CR_DMAEN1_Pos)               /*!< 0x00001000 */
#define DAC_CR_DMAEN1               DAC_CR_DMAEN1_Msk                          /*!<DAC channel1 DMA enable */
#define DAC_CR_DMAUDRIE1_Pos        (13U)
#define DAC_CR_DMAUDRIE1_Msk        (0x1UL << DAC_CR_DMAUDRIE1_Pos)            /*!< 0x00002000 */
#define DAC_CR_DMAUDRIE1            DAC_CR_DMAUDRIE1_Msk                       /*!<DAC channel 1 DMA underrun interrupt enable  >*/
#define DAC_CR_CEN1_Pos             (14U)
#define DAC_CR_CEN1_Msk             (0x1UL << DAC_CR_CEN1_Pos)                 /*!< 0x00004000 */
#define DAC_CR_CEN1                 DAC_CR_CEN1_Msk                            /*!<DAC channel 1 calibration enable >*/

#define DAC_CR_EN2_Pos              (16U)
#define DAC_CR_EN2_Msk              (0x1UL << DAC_CR_EN2_Pos)                  /*!< 0x00010000 */
#define DAC_CR_EN2                  DAC_CR_EN2_Msk                             /*!<DAC channel2 enable */
#define DAC_CR_TEN2_Pos             (17U)
#define DAC_CR_TEN2_Msk             (0x1UL << DAC_CR_TEN2_Pos)                 /*!< 0x00020000 */
#define DAC_CR_TEN2                 DAC_CR_TEN2_Msk                            /*!<DAC channel2 Trigger enable */

#define DAC_CR_TSEL2_Pos            (18U)
#define DAC_CR_TSEL2_Msk            (0xFUL << DAC_CR_TSEL2_Pos)                /*!< 0x003C0000 */
#define DAC_CR_TSEL2                DAC_CR_TSEL2_Msk                           /*!<TSEL2[2:0] (DAC channel2 Trigger selection) */
#define DAC_CR_TSEL2_0              (0x1UL << DAC_CR_TSEL2_Pos)                 /*!< 0x00040000 */
#define DAC_CR_TSEL2_1              (0x2UL << DAC_CR_TSEL2_Pos)                 /*!< 0x00080000 */
#define DAC_CR_TSEL2_2              (0x4UL << DAC_CR_TSEL2_Pos)                 /*!< 0x00100000 */
#define DAC_CR_TSEL2_3              (0x8UL << DAC_CR_TSEL2_Pos)                 /*!< 0x00200000 */


#define DAC_CR_WAVE2_Pos            (22U)
#define DAC_CR_WAVE2_Msk            (0x3UL << DAC_CR_WAVE2_Pos)                /*!< 0x00C00000 */
#define DAC_CR_WAVE2                DAC_CR_WAVE2_Msk                           /*!<WAVE2[1:0] (DAC channel2 noise/triangle wave generation enable) */
#define DAC_CR_WAVE2_0              (0x1UL << DAC_CR_WAVE2_Pos)                 /*!< 0x00400000 */
#define DAC_CR_WAVE2_1              (0x2UL << DAC_CR_WAVE2_Pos)                 /*!< 0x00800000 */

#define DAC_CR_MAMP2_Pos            (24U)
#define DAC_CR_MAMP2_Msk            (0xFUL << DAC_CR_MAMP2_Pos)                /*!< 0x0F000000 */
#define DAC_CR_MAMP2                DAC_CR_MAMP2_Msk                           /*!<MAMP2[3:0] (DAC channel2 Mask/Amplitude selector) */
#define DAC_CR_MAMP2_0              (0x1UL << DAC_CR_MAMP2_Pos)                 /*!< 0x01000000 */
#define DAC_CR_MAMP2_1              (0x2UL << DAC_CR_MAMP2_Pos)                 /*!< 0x02000000 */
#define DAC_CR_MAMP2_2              (0x4UL << DAC_CR_MAMP2_Pos)                 /*!< 0x04000000 */
#define DAC_CR_MAMP2_3              (0x8UL << DAC_CR_MAMP2_Pos)                 /*!< 0x08000000 */

#define DAC_CR_DMAEN2_Pos           (28U)
#define DAC_CR_DMAEN2_Msk           (0x1UL << DAC_CR_DMAEN2_Pos)               /*!< 0x10000000 */
#define DAC_CR_DMAEN2               DAC_CR_DMAEN2_Msk                          /*!<DAC channel2 DMA enabled */
#define DAC_CR_DMAUDRIE2_Pos        (29U)
#define DAC_CR_DMAUDRIE2_Msk        (0x1UL << DAC_CR_DMAUDRIE2_Pos)            /*!< 0x20000000 */
#define DAC_CR_DMAUDRIE2            DAC_CR_DMAUDRIE2_Msk                       /*!<DAC channel2 DMA underrun interrupt enable  >*/
#define DAC_CR_CEN2_Pos             (30U)
#define DAC_CR_CEN2_Msk             (0x1UL << DAC_CR_CEN2_Pos)                 /*!< 0x40000000 */
#define DAC_CR_CEN2                 DAC_CR_CEN2_Msk                            /*!<DAC channel2 calibration enable >*/

/*****************  Bit definition for DAC_SWTRIGR register  ******************/
#define DAC_SWTRIGR_SWTRIG1_Pos     (0U)
#define DAC_SWTRIGR_SWTRIG1_Msk     (0x1UL << DAC_SWTRIGR_SWTRIG1_Pos)         /*!< 0x00000001 */
#define DAC_SWTRIGR_SWTRIG1         DAC_SWTRIGR_SWTRIG1_Msk                    /*!<DAC channel1 software trigger */
#define DAC_SWTRIGR_SWTRIG2_Pos     (1U)
#define DAC_SWTRIGR_SWTRIG2_Msk     (0x1UL << DAC_SWTRIGR_SWTRIG2_Pos)         /*!< 0x00000002 */
#define DAC_SWTRIGR_SWTRIG2         DAC_SWTRIGR_SWTRIG2_Msk                    /*!<DAC channel2 software trigger */

/*****************  Bit definition for DAC_DHR12R1 register  ******************/
#define DAC_DHR12R1_DACC1DHR_Pos    (0U)
#define DAC_DHR12R1_DACC1DHR_Msk    (0xFFFUL << DAC_DHR12R1_DACC1DHR_Pos)      /*!< 0x00000FFF */
#define DAC_DHR12R1_DACC1DHR        DAC_DHR12R1_DACC1DHR_Msk                   /*!<DAC channel1 12-bit Right aligned data */

/*****************  Bit definition for DAC_DHR12L1 register  ******************/
#define DAC_DHR12L1_DACC1DHR_Pos    (4U)
#define DAC_DHR12L1_DACC1DHR_Msk    (0xFFFUL << DAC_DHR12L1_DACC1DHR_Pos)      /*!< 0x0000FFF0 */
#define DAC_DHR12L1_DACC1DHR        DAC_DHR12L1_DACC1DHR_Msk                   /*!<DAC channel1 12-bit Left aligned data */

/******************  Bit definition for DAC_DHR8R1 register  ******************/
#define DAC_DHR8R1_DACC1DHR_Pos     (0U)
#define DAC_DHR8R1_DACC1DHR_Msk     (0xFFUL << DAC_DHR8R1_DACC1DHR_Pos)        /*!< 0x000000FF */
#define DAC_DHR8R1_DACC1DHR         DAC_DHR8R1_DACC1DHR_Msk                    /*!<DAC channel1 8-bit Right aligned data */

/*****************  Bit definition for DAC_DHR12R2 register  ******************/
#define DAC_DHR12R2_DACC2DHR_Pos    (0U)
#define DAC_DHR12R2_DACC2DHR_Msk    (0xFFFUL << DAC_DHR12R2_DACC2DHR_Pos)      /*!< 0x00000FFF */
#define DAC_DHR12R2_DACC2DHR        DAC_DHR12R2_DACC2DHR_Msk                   /*!<DAC channel2 12-bit Right aligned data */

/*****************  Bit definition for DAC_DHR12L2 register  ******************/
#define DAC_DHR12L2_DACC2DHR_Pos    (4U)
#define DAC_DHR12L2_DACC2DHR_Msk    (0xFFFUL << DAC_DHR12L2_DACC2DHR_Pos)      /*!< 0x0000FFF0 */
#define DAC_DHR12L2_DACC2DHR        DAC_DHR12L2_DACC2DHR_Msk                   /*!<DAC channel2 12-bit Left aligned data */

/******************  Bit definition for DAC_DHR8R2 register  ******************/
#define DAC_DHR8R2_DACC2DHR_Pos     (0U)
#define DAC_DHR8R2_DACC2DHR_Msk     (0xFFUL << DAC_DHR8R2_DACC2DHR_Pos)        /*!< 0x000000FF */
#define DAC_DHR8R2_DACC2DHR         DAC_DHR8R2_DACC2DHR_Msk                    /*!<DAC channel2 8-bit Right aligned data */

/*****************  Bit definition for DAC_DHR12RD register  ******************/
#define DAC_DHR12RD_DACC1DHR_Pos    (0U)
#define DAC_DHR12RD_DACC1DHR_Msk    (0xFFFUL << DAC_DHR12RD_DACC1DHR_Pos)      /*!< 0x00000FFF */
#define DAC_DHR12RD_DACC1DHR        DAC_DHR12RD_DACC1DHR_Msk                   /*!<DAC channel1 12-bit Right aligned data */
#define DAC_DHR12RD_DACC2DHR_Pos    (16U)
#define DAC_DHR12RD_DACC2DHR_Msk    (0xFFFUL << DAC_DHR12RD_DACC2DHR_Pos)      /*!< 0x0FFF0000 */
#define DAC_DHR12RD_DACC2DHR        DAC_DHR12RD_DACC2DHR_Msk                   /*!<DAC channel2 12-bit Right aligned data */

/*****************  Bit definition for DAC_DHR12LD register  ******************/
#define DAC_DHR12LD_DACC1DHR_Pos    (4U)
#define DAC_DHR12LD_DACC1DHR_Msk    (0xFFFUL << DAC_DHR12LD_DACC1DHR_Pos)      /*!< 0x0000FFF0 */
#define DAC_DHR12LD_DACC1DHR        DAC_DHR12LD_DACC1DHR_Msk                   /*!<DAC channel1 12-bit Left aligned data */
#define DAC_DHR12LD_DACC2DHR_Pos    (20U)
#define DAC_DHR12LD_DACC2DHR_Msk    (0xFFFUL << DAC_DHR12LD_DACC2DHR_Pos)      /*!< 0xFFF00000 */
#define DAC_DHR12LD_DACC2DHR        DAC_DHR12LD_DACC2DHR_Msk                   /*!<DAC channel2 12-bit Left aligned data */

/******************  Bit definition for DAC_DHR8RD register  ******************/
#define DAC_DHR8RD_DACC1DHR_Pos     (0U)
#define DAC_DHR8RD_DACC1DHR_Msk     (0xFFUL << DAC_DHR8RD_DACC1DHR_Pos)        /*!< 0x000000FF */
#define DAC_DHR8RD_DACC1DHR         DAC_DHR8RD_DACC1DHR_Msk                    /*!<DAC channel1 8-bit Right aligned data */
#define DAC_DHR8RD_DACC2DHR_Pos     (8U)
#define DAC_DHR8RD_DACC2DHR_Msk     (0xFFUL << DAC_DHR8RD_DACC2DHR_Pos)        /*!< 0x0000FF00 */
#define DAC_DHR8RD_DACC2DHR         DAC_DHR8RD_DACC2DHR_Msk                    /*!<DAC channel2 8-bit Right aligned data */

/*******************  Bit definition for DAC_DOR1 register  *******************/
#define DAC_DOR1_DACC1DOR_Pos       (0U)
#define DAC_DOR1_DACC1DOR_Msk       (0xFFFUL << DAC_DOR1_DACC1DOR_Pos)         /*!< 0x00000FFF */
#define DAC_DOR1_DACC1DOR           DAC_DOR1_DACC1DOR_Msk                      /*!<DAC channel1 data output */

/*******************  Bit definition for DAC_DOR2 register  *******************/
#define DAC_DOR2_DACC2DOR_Pos       (0U)
#define DAC_DOR2_DACC2DOR_Msk       (0xFFFUL << DAC_DOR2_DACC2DOR_Pos)         /*!< 0x00000FFF */
#define DAC_DOR2_DACC2DOR           DAC_DOR2_DACC2DOR_Msk                      /*!<DAC channel2 data output */

/********************  Bit definition for DAC_SR register  ********************/
#define DAC_SR_DMAUDR1_Pos          (13U)
#define DAC_SR_DMAUDR1_Msk          (0x1UL << DAC_SR_DMAUDR1_Pos)              /*!< 0x00002000 */
#define DAC_SR_DMAUDR1              DAC_SR_DMAUDR1_Msk                         /*!<DAC channel1 DMA underrun flag */
#define DAC_SR_CAL_FLAG1_Pos        (14U)
#define DAC_SR_CAL_FLAG1_Msk        (0x1UL << DAC_SR_CAL_FLAG1_Pos)            /*!< 0x00004000 */
#define DAC_SR_CAL_FLAG1            DAC_SR_CAL_FLAG1_Msk                       /*!<DAC channel1 calibration offset status */
#define DAC_SR_BWST1_Pos            (15U)
#define DAC_SR_BWST1_Msk            (0x4001UL << DAC_SR_BWST1_Pos)             /*!< 0x20008000 */
#define DAC_SR_BWST1                DAC_SR_BWST1_Msk                           /*!<DAC channel1 busy writing sample time flag */

#define DAC_SR_DMAUDR2_Pos          (29U)
#define DAC_SR_DMAUDR2_Msk          (0x1UL << DAC_SR_DMAUDR2_Pos)              /*!< 0x20000000 */
#define DAC_SR_DMAUDR2              DAC_SR_DMAUDR2_Msk                         /*!<DAC channel2 DMA underrun flag */
#define DAC_SR_CAL_FLAG2_Pos        (30U)
#define DAC_SR_CAL_FLAG2_Msk        (0x1UL << DAC_SR_CAL_FLAG2_Pos)            /*!< 0x40000000 */
#define DAC_SR_CAL_FLAG2            DAC_SR_CAL_FLAG2_Msk                       /*!<DAC channel2 calibration offset status */
#define DAC_SR_BWST2_Pos            (31U)
#define DAC_SR_BWST2_Msk            (0x1UL << DAC_SR_BWST2_Pos)                /*!< 0x80000000 */
#define DAC_SR_BWST2                DAC_SR_BWST2_Msk                           /*!<DAC channel2 busy writing sample time flag */

/*******************  Bit definition for DAC_CCR register  ********************/
#define DAC_CCR_OTRIM1_Pos          (0U)
#define DAC_CCR_OTRIM1_Msk          (0x1FUL << DAC_CCR_OTRIM1_Pos)             /*!< 0x0000001F */
#define DAC_CCR_OTRIM1              DAC_CCR_OTRIM1_Msk                         /*!<DAC channel1 offset trimming value */
#define DAC_CCR_OTRIM2_Pos          (16U)
#define DAC_CCR_OTRIM2_Msk          (0x1FUL << DAC_CCR_OTRIM2_Pos)             /*!< 0x001F0000 */
#define DAC_CCR_OTRIM2              DAC_CCR_OTRIM2_Msk                         /*!<DAC channel2 offset trimming value */

/*******************  Bit definition for DAC_MCR register  *******************/
#define DAC_MCR_MODE1_Pos           (0U)
#define DAC_MCR_MODE1_Msk           (0x7UL << DAC_MCR_MODE1_Pos)               /*!< 0x00000007 */
#define DAC_MCR_MODE1               DAC_MCR_MODE1_Msk                          /*!<MODE1[2:0] (DAC channel1 mode) */
#define DAC_MCR_MODE1_0             (0x1UL << DAC_MCR_MODE1_Pos)                /*!< 0x00000001 */
#define DAC_MCR_MODE1_1             (0x2UL << DAC_MCR_MODE1_Pos)                /*!< 0x00000002 */
#define DAC_MCR_MODE1_2             (0x4UL << DAC_MCR_MODE1_Pos)                /*!< 0x00000004 */

#define DAC_MCR_MODE2_Pos           (16U)
#define DAC_MCR_MODE2_Msk           (0x7UL << DAC_MCR_MODE2_Pos)               /*!< 0x00070000 */
#define DAC_MCR_MODE2               DAC_MCR_MODE2_Msk                          /*!<MODE2[2:0] (DAC channel2 mode) */
#define DAC_MCR_MODE2_0             (0x1UL << DAC_MCR_MODE2_Pos)                /*!< 0x00010000 */
#define DAC_MCR_MODE2_1             (0x2UL << DAC_MCR_MODE2_Pos)                /*!< 0x00020000 */
#define DAC_MCR_MODE2_2             (0x4UL << DAC_MCR_MODE2_Pos)                /*!< 0x00040000 */

/******************  Bit definition for DAC_SHSR1 register  ******************/
#define DAC_SHSR1_TSAMPLE1_Pos      (0U)
#define DAC_SHSR1_TSAMPLE1_Msk      (0x3FFUL << DAC_SHSR1_TSAMPLE1_Pos)        /*!< 0x000003FF */
#define DAC_SHSR1_TSAMPLE1          DAC_SHSR1_TSAMPLE1_Msk                     /*!<DAC channel1 sample time */

/******************  Bit definition for DAC_SHSR2 register  ******************/
#define DAC_SHSR2_TSAMPLE2_Pos      (0U)
#define DAC_SHSR2_TSAMPLE2_Msk      (0x3FFUL << DAC_SHSR2_TSAMPLE2_Pos)        /*!< 0x000003FF */
#define DAC_SHSR2_TSAMPLE2          DAC_SHSR2_TSAMPLE2_Msk                     /*!<DAC channel2 sample time */

/******************  Bit definition for DAC_SHHR register  ******************/
#define DAC_SHHR_THOLD1_Pos         (0U)
#define DAC_SHHR_THOLD1_Msk         (0x3FFUL << DAC_SHHR_THOLD1_Pos)           /*!< 0x000003FF */
#define DAC_SHHR_THOLD1             DAC_SHHR_THOLD1_Msk                        /*!<DAC channel1 hold time */
#define DAC_SHHR_THOLD2_Pos         (16U)
#define DAC_SHHR_THOLD2_Msk         (0x3FFUL << DAC_SHHR_THOLD2_Pos)           /*!< 0x03FF0000 */
#define DAC_SHHR_THOLD2             DAC_SHHR_THOLD2_Msk                        /*!<DAC channel2 hold time */

/******************  Bit definition for DAC_SHRR register  ******************/
#define DAC_SHRR_TREFRESH1_Pos      (0U)
#define DAC_SHRR_TREFRESH1_Msk      (0xFFUL << DAC_SHRR_TREFRESH1_Pos)         /*!< 0x000000FF */
#define DAC_SHRR_TREFRESH1          DAC_SHRR_TREFRESH1_Msk                     /*!<DAC channel1 refresh time */
#define DAC_SHRR_TREFRESH2_Pos      (16U)
#define DAC_SHRR_TREFRESH2_Msk      (0xFFUL << DAC_SHRR_TREFRESH2_Pos)         /*!< 0x00FF0000 */
#define DAC_SHRR_TREFRESH2          DAC_SHRR_TREFRESH2_Msk                     /*!<DAC channel2 refresh time */

/******************************************************************************/
/*                                                                            */
/*                                    DCMI                                    */
/*                                                                            */
/******************************************************************************/
/********************  Bits definition for DCMI_CR register  ******************/
#define DCMI_CR_CAPTURE_Pos        (0U)
#define DCMI_CR_CAPTURE_Msk        (0x1UL << DCMI_CR_CAPTURE_Pos)              /*!< 0x00000001 */
#define DCMI_CR_CAPTURE            DCMI_CR_CAPTURE_Msk
#define DCMI_CR_CM_Pos             (1U)
#define DCMI_CR_CM_Msk             (0x1UL << DCMI_CR_CM_Pos)                   /*!< 0x00000002 */
#define DCMI_CR_CM                 DCMI_CR_CM_Msk
#define DCMI_CR_CROP_Pos           (2U)
#define DCMI_CR_CROP_Msk           (0x1UL << DCMI_CR_CROP_Pos)                 /*!< 0x00000004 */
#define DCMI_CR_CROP               DCMI_CR_CROP_Msk
#define DCMI_CR_JPEG_Pos           (3U)
#define DCMI_CR_JPEG_Msk           (0x1UL << DCMI_CR_JPEG_Pos)                 /*!< 0x00000008 */
#define DCMI_CR_JPEG               DCMI_CR_JPEG_Msk
#define DCMI_CR_ESS_Pos            (4U)
#define DCMI_CR_ESS_Msk            (0x1UL << DCMI_CR_ESS_Pos)                  /*!< 0x00000010 */
#define DCMI_CR_ESS                DCMI_CR_ESS_Msk
#define DCMI_CR_PCKPOL_Pos         (5U)
#define DCMI_CR_PCKPOL_Msk         (0x1UL << DCMI_CR_PCKPOL_Pos)               /*!< 0x00000020 */
#define DCMI_CR_PCKPOL             DCMI_CR_PCKPOL_Msk
#define DCMI_CR_HSPOL_Pos          (6U)
#define DCMI_CR_HSPOL_Msk          (0x1UL << DCMI_CR_HSPOL_Pos)                /*!< 0x00000040 */
#define DCMI_CR_HSPOL              DCMI_CR_HSPOL_Msk
#define DCMI_CR_VSPOL_Pos          (7U)
#define DCMI_CR_VSPOL_Msk          (0x1UL << DCMI_CR_VSPOL_Pos)                /*!< 0x00000080 */
#define DCMI_CR_VSPOL              DCMI_CR_VSPOL_Msk
#define DCMI_CR_FCRC_0             ((uint32_t)0x00000100U)
#define DCMI_CR_FCRC_1             ((uint32_t)0x00000200U)
#define DCMI_CR_EDM_0              ((uint32_t)0x00000400U)
#define DCMI_CR_EDM_1              ((uint32_t)0x00000800U)
#define DCMI_CR_CRE_Pos            (12U)
#define DCMI_CR_CRE_Msk            (0x1UL << DCMI_CR_CRE_Pos)                  /*!< 0x00001000 */
#define DCMI_CR_CRE                DCMI_CR_CRE_Msk
#define DCMI_CR_ENABLE_Pos         (14U)
#define DCMI_CR_ENABLE_Msk         (0x1UL << DCMI_CR_ENABLE_Pos)               /*!< 0x00004000 */
#define DCMI_CR_ENABLE             DCMI_CR_ENABLE_Msk
#define DCMI_CR_BSM_Pos            (16U)
#define DCMI_CR_BSM_Msk            (0x3UL << DCMI_CR_BSM_Pos)                  /*!< 0x00030000 */
#define DCMI_CR_BSM                DCMI_CR_BSM_Msk
#define DCMI_CR_BSM_0              (0x1UL << DCMI_CR_BSM_Pos)                   /*!< 0x00010000 */
#define DCMI_CR_BSM_1              (0x2UL << DCMI_CR_BSM_Pos)                   /*!< 0x00020000 */
#define DCMI_CR_OEBS_Pos           (18U)
#define DCMI_CR_OEBS_Msk           (0x1UL << DCMI_CR_OEBS_Pos)                 /*!< 0x00040000 */
#define DCMI_CR_OEBS               DCMI_CR_OEBS_Msk
#define DCMI_CR_LSM_Pos            (19U)
#define DCMI_CR_LSM_Msk            (0x1UL << DCMI_CR_LSM_Pos)                  /*!< 0x00080000 */
#define DCMI_CR_LSM                DCMI_CR_LSM_Msk
#define DCMI_CR_OELS_Pos           (20U)
#define DCMI_CR_OELS_Msk           (0x1UL << DCMI_CR_OELS_Pos)                 /*!< 0x00100000 */
#define DCMI_CR_OELS               DCMI_CR_OELS_Msk

/********************  Bits definition for DCMI_SR register  ******************/
#define DCMI_SR_HSYNC_Pos          (0U)
#define DCMI_SR_HSYNC_Msk          (0x1UL << DCMI_SR_HSYNC_Pos)                /*!< 0x00000001 */
#define DCMI_SR_HSYNC              DCMI_SR_HSYNC_Msk
#define DCMI_SR_VSYNC_Pos          (1U)
#define DCMI_SR_VSYNC_Msk          (0x1UL << DCMI_SR_VSYNC_Pos)                /*!< 0x00000002 */
#define DCMI_SR_VSYNC              DCMI_SR_VSYNC_Msk
#define DCMI_SR_FNE_Pos            (2U)
#define DCMI_SR_FNE_Msk            (0x1UL << DCMI_SR_FNE_Pos)                  /*!< 0x00000004 */
#define DCMI_SR_FNE                DCMI_SR_FNE_Msk

/********************  Bits definition for DCMI_RIS register   ****************/
#define DCMI_RIS_FRAME_RIS_Pos     (0U)
#define DCMI_RIS_FRAME_RIS_Msk     (0x1UL << DCMI_RIS_FRAME_RIS_Pos)           /*!< 0x00000001 */
#define DCMI_RIS_FRAME_RIS         DCMI_RIS_FRAME_RIS_Msk
#define DCMI_RIS_OVR_RIS_Pos       (1U)
#define DCMI_RIS_OVR_RIS_Msk       (0x1UL << DCMI_RIS_OVR_RIS_Pos)             /*!< 0x00000002 */
#define DCMI_RIS_OVR_RIS           DCMI_RIS_OVR_RIS_Msk
#define DCMI_RIS_ERR_RIS_Pos       (2U)
#define DCMI_RIS_ERR_RIS_Msk       (0x1UL << DCMI_RIS_ERR_RIS_Pos)             /*!< 0x00000004 */
#define DCMI_RIS_ERR_RIS           DCMI_RIS_ERR_RIS_Msk
#define DCMI_RIS_VSYNC_RIS_Pos     (3U)
#define DCMI_RIS_VSYNC_RIS_Msk     (0x1UL << DCMI_RIS_VSYNC_RIS_Pos)           /*!< 0x00000008 */
#define DCMI_RIS_VSYNC_RIS         DCMI_RIS_VSYNC_RIS_Msk
#define DCMI_RIS_LINE_RIS_Pos      (4U)
#define DCMI_RIS_LINE_RIS_Msk      (0x1UL << DCMI_RIS_LINE_RIS_Pos)            /*!< 0x00000010 */
#define DCMI_RIS_LINE_RIS          DCMI_RIS_LINE_RIS_Msk

/********************  Bits definition for DCMI_IER register  *****************/
#define DCMI_IER_FRAME_IE_Pos      (0U)
#define DCMI_IER_FRAME_IE_Msk      (0x1UL << DCMI_IER_FRAME_IE_Pos)            /*!< 0x00000001 */
#define DCMI_IER_FRAME_IE          DCMI_IER_FRAME_IE_Msk
#define DCMI_IER_OVR_IE_Pos        (1U)
#define DCMI_IER_OVR_IE_Msk        (0x1UL << DCMI_IER_OVR_IE_Pos)              /*!< 0x00000002 */
#define DCMI_IER_OVR_IE            DCMI_IER_OVR_IE_Msk
#define DCMI_IER_ERR_IE_Pos        (2U)
#define DCMI_IER_ERR_IE_Msk        (0x1UL << DCMI_IER_ERR_IE_Pos)              /*!< 0x00000004 */
#define DCMI_IER_ERR_IE            DCMI_IER_ERR_IE_Msk
#define DCMI_IER_VSYNC_IE_Pos      (3U)
#define DCMI_IER_VSYNC_IE_Msk      (0x1UL << DCMI_IER_VSYNC_IE_Pos)            /*!< 0x00000008 */
#define DCMI_IER_VSYNC_IE          DCMI_IER_VSYNC_IE_Msk
#define DCMI_IER_LINE_IE_Pos       (4U)
#define DCMI_IER_LINE_IE_Msk       (0x1UL << DCMI_IER_LINE_IE_Pos)             /*!< 0x00000010 */
#define DCMI_IER_LINE_IE           DCMI_IER_LINE_IE_Msk


/********************  Bits definition for DCMI_MIS register  *****************/
#define DCMI_MIS_FRAME_MIS_Pos     (0U)
#define DCMI_MIS_FRAME_MIS_Msk     (0x1UL << DCMI_MIS_FRAME_MIS_Pos)           /*!< 0x00000001 */
#define DCMI_MIS_FRAME_MIS         DCMI_MIS_FRAME_MIS_Msk
#define DCMI_MIS_OVR_MIS_Pos       (1U)
#define DCMI_MIS_OVR_MIS_Msk       (0x1UL << DCMI_MIS_OVR_MIS_Pos)             /*!< 0x00000002 */
#define DCMI_MIS_OVR_MIS           DCMI_MIS_OVR_MIS_Msk
#define DCMI_MIS_ERR_MIS_Pos       (2U)
#define DCMI_MIS_ERR_MIS_Msk       (0x1UL << DCMI_MIS_ERR_MIS_Pos)             /*!< 0x00000004 */
#define DCMI_MIS_ERR_MIS           DCMI_MIS_ERR_MIS_Msk
#define DCMI_MIS_VSYNC_MIS_Pos     (3U)
#define DCMI_MIS_VSYNC_MIS_Msk     (0x1UL << DCMI_MIS_VSYNC_MIS_Pos)           /*!< 0x00000008 */
#define DCMI_MIS_VSYNC_MIS         DCMI_MIS_VSYNC_MIS_Msk
#define DCMI_MIS_LINE_MIS_Pos      (4U)
#define DCMI_MIS_LINE_MIS_Msk      (0x1UL << DCMI_MIS_LINE_MIS_Pos)            /*!< 0x00000010 */
#define DCMI_MIS_LINE_MIS          DCMI_MIS_LINE_MIS_Msk


/********************  Bits definition for DCMI_ICR register  *****************/
#define DCMI_ICR_FRAME_ISC_Pos     (0U)
#define DCMI_ICR_FRAME_ISC_Msk     (0x1UL << DCMI_ICR_FRAME_ISC_Pos)           /*!< 0x00000001 */
#define DCMI_ICR_FRAME_ISC         DCMI_ICR_FRAME_ISC_Msk
#define DCMI_ICR_OVR_ISC_Pos       (1U)
#define DCMI_ICR_OVR_ISC_Msk       (0x1UL << DCMI_ICR_OVR_ISC_Pos)             /*!< 0x00000002 */
#define DCMI_ICR_OVR_ISC           DCMI_ICR_OVR_ISC_Msk
#define DCMI_ICR_ERR_ISC_Pos       (2U)
#define DCMI_ICR_ERR_ISC_Msk       (0x1UL << DCMI_ICR_ERR_ISC_Pos)             /*!< 0x00000004 */
#define DCMI_ICR_ERR_ISC           DCMI_ICR_ERR_ISC_Msk
#define DCMI_ICR_VSYNC_ISC_Pos     (3U)
#define DCMI_ICR_VSYNC_ISC_Msk     (0x1UL << DCMI_ICR_VSYNC_ISC_Pos)           /*!< 0x00000008 */
#define DCMI_ICR_VSYNC_ISC         DCMI_ICR_VSYNC_ISC_Msk
#define DCMI_ICR_LINE_ISC_Pos      (4U)
#define DCMI_ICR_LINE_ISC_Msk      (0x1UL << DCMI_ICR_LINE_ISC_Pos)            /*!< 0x00000010 */
#define DCMI_ICR_LINE_ISC          DCMI_ICR_LINE_ISC_Msk


/********************  Bits definition for DCMI_ESCR register  ******************/
#define DCMI_ESCR_FSC_Pos          (0U)
#define DCMI_ESCR_FSC_Msk          (0xFFUL << DCMI_ESCR_FSC_Pos)               /*!< 0x000000FF */
#define DCMI_ESCR_FSC              DCMI_ESCR_FSC_Msk
#define DCMI_ESCR_LSC_Pos          (8U)
#define DCMI_ESCR_LSC_Msk          (0xFFUL << DCMI_ESCR_LSC_Pos)               /*!< 0x0000FF00 */
#define DCMI_ESCR_LSC              DCMI_ESCR_LSC_Msk
#define DCMI_ESCR_LEC_Pos          (16U)
#define DCMI_ESCR_LEC_Msk          (0xFFUL << DCMI_ESCR_LEC_Pos)               /*!< 0x00FF0000 */
#define DCMI_ESCR_LEC              DCMI_ESCR_LEC_Msk
#define DCMI_ESCR_FEC_Pos          (24U)
#define DCMI_ESCR_FEC_Msk          (0xFFUL << DCMI_ESCR_FEC_Pos)               /*!< 0xFF000000 */
#define DCMI_ESCR_FEC              DCMI_ESCR_FEC_Msk

/********************  Bits definition for DCMI_ESUR register  ******************/
#define DCMI_ESUR_FSU_Pos          (0U)
#define DCMI_ESUR_FSU_Msk          (0xFFUL << DCMI_ESUR_FSU_Pos)               /*!< 0x000000FF */
#define DCMI_ESUR_FSU              DCMI_ESUR_FSU_Msk
#define DCMI_ESUR_LSU_Pos          (8U)
#define DCMI_ESUR_LSU_Msk          (0xFFUL << DCMI_ESUR_LSU_Pos)               /*!< 0x0000FF00 */
#define DCMI_ESUR_LSU              DCMI_ESUR_LSU_Msk
#define DCMI_ESUR_LEU_Pos          (16U)
#define DCMI_ESUR_LEU_Msk          (0xFFUL << DCMI_ESUR_LEU_Pos)               /*!< 0x00FF0000 */
#define DCMI_ESUR_LEU              DCMI_ESUR_LEU_Msk
#define DCMI_ESUR_FEU_Pos          (24U)
#define DCMI_ESUR_FEU_Msk          (0xFFUL << DCMI_ESUR_FEU_Pos)               /*!< 0xFF000000 */
#define DCMI_ESUR_FEU              DCMI_ESUR_FEU_Msk

/********************  Bits definition for DCMI_CWSTRT register  ******************/
#define DCMI_CWSTRT_HOFFCNT_Pos    (0U)
#define DCMI_CWSTRT_HOFFCNT_Msk    (0x3FFFUL << DCMI_CWSTRT_HOFFCNT_Pos)       /*!< 0x00003FFF */
#define DCMI_CWSTRT_HOFFCNT        DCMI_CWSTRT_HOFFCNT_Msk
#define DCMI_CWSTRT_VST_Pos        (16U)
#define DCMI_CWSTRT_VST_Msk        (0x1FFFUL << DCMI_CWSTRT_VST_Pos)           /*!< 0x1FFF0000 */
#define DCMI_CWSTRT_VST            DCMI_CWSTRT_VST_Msk

/********************  Bits definition for DCMI_CWSIZE register  ******************/
#define DCMI_CWSIZE_CAPCNT_Pos     (0U)
#define DCMI_CWSIZE_CAPCNT_Msk     (0x3FFFUL << DCMI_CWSIZE_CAPCNT_Pos)        /*!< 0x00003FFF */
#define DCMI_CWSIZE_CAPCNT         DCMI_CWSIZE_CAPCNT_Msk
#define DCMI_CWSIZE_VLINE_Pos      (16U)
#define DCMI_CWSIZE_VLINE_Msk      (0x3FFFUL << DCMI_CWSIZE_VLINE_Pos)         /*!< 0x3FFF0000 */
#define DCMI_CWSIZE_VLINE          DCMI_CWSIZE_VLINE_Msk

/********************  Bits definition for DCMI_DR register  ******************/
#define DCMI_DR_BYTE0_Pos          (0U)
#define DCMI_DR_BYTE0_Msk          (0xFFUL << DCMI_DR_BYTE0_Pos)               /*!< 0x000000FF */
#define DCMI_DR_BYTE0              DCMI_DR_BYTE0_Msk
#define DCMI_DR_BYTE1_Pos          (8U)
#define DCMI_DR_BYTE1_Msk          (0xFFUL << DCMI_DR_BYTE1_Pos)               /*!< 0x0000FF00 */
#define DCMI_DR_BYTE1              DCMI_DR_BYTE1_Msk
#define DCMI_DR_BYTE2_Pos          (16U)
#define DCMI_DR_BYTE2_Msk          (0xFFUL << DCMI_DR_BYTE2_Pos)               /*!< 0x00FF0000 */
#define DCMI_DR_BYTE2              DCMI_DR_BYTE2_Msk
#define DCMI_DR_BYTE3_Pos          (24U)
#define DCMI_DR_BYTE3_Msk          (0xFFUL << DCMI_DR_BYTE3_Pos)               /*!< 0xFF000000 */
#define DCMI_DR_BYTE3              DCMI_DR_BYTE3_Msk

/******************************************************************************/
/*                                                                            */
/*                 Digital Filter for Sigma Delta Modulators                  */
/*                                                                            */
/******************************************************************************/

/****************   DFSDM channel configuration registers  ********************/

/***************  Bit definition for DFSDM_CHCFGR1 register  ******************/
#define DFSDM_CHCFGR1_DFSDMEN_Pos       (31U)
#define DFSDM_CHCFGR1_DFSDMEN_Msk       (0x1UL << DFSDM_CHCFGR1_DFSDMEN_Pos)   /*!< 0x80000000 */
#define DFSDM_CHCFGR1_DFSDMEN           DFSDM_CHCFGR1_DFSDMEN_Msk              /*!< Global enable for DFSDM interface */
#define DFSDM_CHCFGR1_CKOUTSRC_Pos      (30U)
#define DFSDM_CHCFGR1_CKOUTSRC_Msk      (0x1UL << DFSDM_CHCFGR1_CKOUTSRC_Pos)  /*!< 0x40000000 */
#define DFSDM_CHCFGR1_CKOUTSRC          DFSDM_CHCFGR1_CKOUTSRC_Msk             /*!< Output serial clock source selection */
#define DFSDM_CHCFGR1_CKOUTDIV_Pos      (16U)
#define DFSDM_CHCFGR1_CKOUTDIV_Msk      (0xFFUL << DFSDM_CHCFGR1_CKOUTDIV_Pos) /*!< 0x00FF0000 */
#define DFSDM_CHCFGR1_CKOUTDIV          DFSDM_CHCFGR1_CKOUTDIV_Msk             /*!< CKOUTDIV[7:0] output serial clock divider */
#define DFSDM_CHCFGR1_DATPACK_Pos       (14U)
#define DFSDM_CHCFGR1_DATPACK_Msk       (0x3UL << DFSDM_CHCFGR1_DATPACK_Pos)   /*!< 0x0000C000 */
#define DFSDM_CHCFGR1_DATPACK           DFSDM_CHCFGR1_DATPACK_Msk              /*!< DATPACK[1:0] Data packing mode */
#define DFSDM_CHCFGR1_DATPACK_1         (0x2UL << DFSDM_CHCFGR1_DATPACK_Pos)    /*!< 0x00008000 */
#define DFSDM_CHCFGR1_DATPACK_0         (0x1UL << DFSDM_CHCFGR1_DATPACK_Pos)    /*!< 0x00004000 */
#define DFSDM_CHCFGR1_DATMPX_Pos        (12U)
#define DFSDM_CHCFGR1_DATMPX_Msk        (0x3UL << DFSDM_CHCFGR1_DATMPX_Pos)    /*!< 0x00003000 */
#define DFSDM_CHCFGR1_DATMPX            DFSDM_CHCFGR1_DATMPX_Msk               /*!< DATMPX[1:0] Input data multiplexer for channel y */
#define DFSDM_CHCFGR1_DATMPX_1          (0x2UL << DFSDM_CHCFGR1_DATMPX_Pos)     /*!< 0x00002000 */
#define DFSDM_CHCFGR1_DATMPX_0          (0x1UL << DFSDM_CHCFGR1_DATMPX_Pos)     /*!< 0x00001000 */
#define DFSDM_CHCFGR1_CHINSEL_Pos       (8U)
#define DFSDM_CHCFGR1_CHINSEL_Msk       (0x1UL << DFSDM_CHCFGR1_CHINSEL_Pos)   /*!< 0x00000100 */
#define DFSDM_CHCFGR1_CHINSEL           DFSDM_CHCFGR1_CHINSEL_Msk              /*!< Serial inputs selection for channel y */
#define DFSDM_CHCFGR1_CHEN_Pos          (7U)
#define DFSDM_CHCFGR1_CHEN_Msk          (0x1UL << DFSDM_CHCFGR1_CHEN_Pos)      /*!< 0x00000080 */
#define DFSDM_CHCFGR1_CHEN              DFSDM_CHCFGR1_CHEN_Msk                 /*!< Channel y enable */
#define DFSDM_CHCFGR1_CKABEN_Pos        (6U)
#define DFSDM_CHCFGR1_CKABEN_Msk        (0x1UL << DFSDM_CHCFGR1_CKABEN_Pos)    /*!< 0x00000040 */
#define DFSDM_CHCFGR1_CKABEN            DFSDM_CHCFGR1_CKABEN_Msk               /*!< Clock absence detector enable on channel y */
#define DFSDM_CHCFGR1_SCDEN_Pos         (5U)
#define DFSDM_CHCFGR1_SCDEN_Msk         (0x1UL << DFSDM_CHCFGR1_SCDEN_Pos)     /*!< 0x00000020 */
#define DFSDM_CHCFGR1_SCDEN             DFSDM_CHCFGR1_SCDEN_Msk                /*!< Short circuit detector enable on channel y */
#define DFSDM_CHCFGR1_SPICKSEL_Pos      (2U)
#define DFSDM_CHCFGR1_SPICKSEL_Msk      (0x3UL << DFSDM_CHCFGR1_SPICKSEL_Pos)  /*!< 0x0000000C */
#define DFSDM_CHCFGR1_SPICKSEL          DFSDM_CHCFGR1_SPICKSEL_Msk             /*!< SPICKSEL[1:0] SPI clock select for channel y */
#define DFSDM_CHCFGR1_SPICKSEL_1        (0x2UL << DFSDM_CHCFGR1_SPICKSEL_Pos)   /*!< 0x00000008 */
#define DFSDM_CHCFGR1_SPICKSEL_0        (0x1UL << DFSDM_CHCFGR1_SPICKSEL_Pos)   /*!< 0x00000004 */
#define DFSDM_CHCFGR1_SITP_Pos          (0U)
#define DFSDM_CHCFGR1_SITP_Msk          (0x3UL << DFSDM_CHCFGR1_SITP_Pos)      /*!< 0x00000003 */
#define DFSDM_CHCFGR1_SITP              DFSDM_CHCFGR1_SITP_Msk                 /*!< SITP[1:0] Serial interface type for channel y */
#define DFSDM_CHCFGR1_SITP_1            (0x2UL << DFSDM_CHCFGR1_SITP_Pos)       /*!< 0x00000002 */
#define DFSDM_CHCFGR1_SITP_0            (0x1UL << DFSDM_CHCFGR1_SITP_Pos)       /*!< 0x00000001 */

/***************  Bit definition for DFSDM_CHCFGR2 register  ******************/
#define DFSDM_CHCFGR2_OFFSET_Pos        (8U)
#define DFSDM_CHCFGR2_OFFSET_Msk        (0xFFFFFFUL << DFSDM_CHCFGR2_OFFSET_Pos) /*!< 0xFFFFFF00 */
#define DFSDM_CHCFGR2_OFFSET            DFSDM_CHCFGR2_OFFSET_Msk               /*!< OFFSET[23:0] 24-bit calibration offset for channel y */
#define DFSDM_CHCFGR2_DTRBS_Pos         (3U)
#define DFSDM_CHCFGR2_DTRBS_Msk         (0x1FUL << DFSDM_CHCFGR2_DTRBS_Pos)    /*!< 0x000000F8 */
#define DFSDM_CHCFGR2_DTRBS             DFSDM_CHCFGR2_DTRBS_Msk                /*!< DTRBS[4:0] Data right bit-shift for channel y */

/******************  Bit definition for DFSDM_CHAWSCDR register *****************/
#define DFSDM_CHAWSCDR_AWFORD_Pos       (22U)
#define DFSDM_CHAWSCDR_AWFORD_Msk       (0x3UL << DFSDM_CHAWSCDR_AWFORD_Pos)   /*!< 0x00C00000 */
#define DFSDM_CHAWSCDR_AWFORD           DFSDM_CHAWSCDR_AWFORD_Msk              /*!< AWFORD[1:0] Analog watchdog Sinc filter order on channel y */
#define DFSDM_CHAWSCDR_AWFORD_1         (0x2UL << DFSDM_CHAWSCDR_AWFORD_Pos)    /*!< 0x00800000 */
#define DFSDM_CHAWSCDR_AWFORD_0         (0x1UL << DFSDM_CHAWSCDR_AWFORD_Pos)    /*!< 0x00400000 */
#define DFSDM_CHAWSCDR_AWFOSR_Pos       (16U)
#define DFSDM_CHAWSCDR_AWFOSR_Msk       (0x1FUL << DFSDM_CHAWSCDR_AWFOSR_Pos)  /*!< 0x001F0000 */
#define DFSDM_CHAWSCDR_AWFOSR           DFSDM_CHAWSCDR_AWFOSR_Msk              /*!< AWFOSR[4:0] Analog watchdog filter oversampling ratio on channel y */
#define DFSDM_CHAWSCDR_BKSCD_Pos        (12U)
#define DFSDM_CHAWSCDR_BKSCD_Msk        (0xFUL << DFSDM_CHAWSCDR_BKSCD_Pos)    /*!< 0x0000F000 */
#define DFSDM_CHAWSCDR_BKSCD            DFSDM_CHAWSCDR_BKSCD_Msk               /*!< BKSCD[3:0] Break signal assignment for short circuit detector on channel y */
#define DFSDM_CHAWSCDR_SCDT_Pos         (0U)
#define DFSDM_CHAWSCDR_SCDT_Msk         (0xFFUL << DFSDM_CHAWSCDR_SCDT_Pos)    /*!< 0x000000FF */
#define DFSDM_CHAWSCDR_SCDT             DFSDM_CHAWSCDR_SCDT_Msk                /*!< SCDT[7:0] Short circuit detector threshold for channel y */

/****************  Bit definition for DFSDM_CHWDATR register *******************/
#define DFSDM_CHWDATR_WDATA_Pos         (0U)
#define DFSDM_CHWDATR_WDATA_Msk         (0xFFFFUL << DFSDM_CHWDATR_WDATA_Pos)  /*!< 0x0000FFFF */
#define DFSDM_CHWDATR_WDATA             DFSDM_CHWDATR_WDATA_Msk                /*!< WDATA[15:0] Input channel y watchdog data */

/****************  Bit definition for DFSDM_CHDATINR register *****************/
#define DFSDM_CHDATINR_INDAT0_Pos       (0U)
#define DFSDM_CHDATINR_INDAT0_Msk       (0xFFFFUL << DFSDM_CHDATINR_INDAT0_Pos) /*!< 0x0000FFFF */
#define DFSDM_CHDATINR_INDAT0           DFSDM_CHDATINR_INDAT0_Msk              /*!< INDAT0[31:16] Input data for channel y or channel (y+1) */
#define DFSDM_CHDATINR_INDAT1_Pos       (16U)
#define DFSDM_CHDATINR_INDAT1_Msk       (0xFFFFUL << DFSDM_CHDATINR_INDAT1_Pos) /*!< 0xFFFF0000 */
#define DFSDM_CHDATINR_INDAT1           DFSDM_CHDATINR_INDAT1_Msk              /*!< INDAT0[15:0] Input data for channel y */

/************************   DFSDM module registers  ****************************/

/********************  Bit definition for DFSDM_FLTCR1 register *******************/
#define DFSDM_FLTCR1_AWFSEL_Pos         (30U)
#define DFSDM_FLTCR1_AWFSEL_Msk         (0x1UL << DFSDM_FLTCR1_AWFSEL_Pos)     /*!< 0x40000000 */
#define DFSDM_FLTCR1_AWFSEL             DFSDM_FLTCR1_AWFSEL_Msk                /*!< Analog watchdog fast mode select */
#define DFSDM_FLTCR1_FAST_Pos           (29U)
#define DFSDM_FLTCR1_FAST_Msk           (0x1UL << DFSDM_FLTCR1_FAST_Pos)       /*!< 0x20000000 */
#define DFSDM_FLTCR1_FAST               DFSDM_FLTCR1_FAST_Msk                  /*!< Fast conversion mode selection */
#define DFSDM_FLTCR1_RCH_Pos            (24U)
#define DFSDM_FLTCR1_RCH_Msk            (0x7UL << DFSDM_FLTCR1_RCH_Pos)        /*!< 0x07000000 */
#define DFSDM_FLTCR1_RCH                DFSDM_FLTCR1_RCH_Msk                   /*!< RCH[2:0] Regular channel selection */
#define DFSDM_FLTCR1_RDMAEN_Pos         (21U)
#define DFSDM_FLTCR1_RDMAEN_Msk         (0x1UL << DFSDM_FLTCR1_RDMAEN_Pos)     /*!< 0x00200000 */
#define DFSDM_FLTCR1_RDMAEN             DFSDM_FLTCR1_RDMAEN_Msk                /*!< DMA channel enabled to read data for the regular conversion */
#define DFSDM_FLTCR1_RSYNC_Pos          (19U)
#define DFSDM_FLTCR1_RSYNC_Msk          (0x1UL << DFSDM_FLTCR1_RSYNC_Pos)      /*!< 0x00080000 */
#define DFSDM_FLTCR1_RSYNC              DFSDM_FLTCR1_RSYNC_Msk                 /*!< Launch regular conversion synchronously with DFSDMx */
#define DFSDM_FLTCR1_RCONT_Pos          (18U)
#define DFSDM_FLTCR1_RCONT_Msk          (0x1UL << DFSDM_FLTCR1_RCONT_Pos)      /*!< 0x00040000 */
#define DFSDM_FLTCR1_RCONT              DFSDM_FLTCR1_RCONT_Msk                 /*!< Continuous mode selection for regular conversions */
#define DFSDM_FLTCR1_RSWSTART_Pos       (17U)
#define DFSDM_FLTCR1_RSWSTART_Msk       (0x1UL << DFSDM_FLTCR1_RSWSTART_Pos)   /*!< 0x00020000 */
#define DFSDM_FLTCR1_RSWSTART           DFSDM_FLTCR1_RSWSTART_Msk              /*!< Software start of a conversion on the regular channel */
#define DFSDM_FLTCR1_JEXTEN_Pos         (13U)
#define DFSDM_FLTCR1_JEXTEN_Msk         (0x3UL << DFSDM_FLTCR1_JEXTEN_Pos)     /*!< 0x00006000 */
#define DFSDM_FLTCR1_JEXTEN             DFSDM_FLTCR1_JEXTEN_Msk                /*!< JEXTEN[1:0] Trigger enable and trigger edge selection for injected conversions */
#define DFSDM_FLTCR1_JEXTEN_1           (0x2UL << DFSDM_FLTCR1_JEXTEN_Pos)      /*!< 0x00004000 */
#define DFSDM_FLTCR1_JEXTEN_0           (0x1UL << DFSDM_FLTCR1_JEXTEN_Pos)      /*!< 0x00002000 */
#define DFSDM_FLTCR1_JEXTSEL_Pos        (8U)
#define DFSDM_FLTCR1_JEXTSEL_Msk        (0x1FUL << DFSDM_FLTCR1_JEXTSEL_Pos)   /*!< 0x00001F00 */
#define DFSDM_FLTCR1_JEXTSEL            DFSDM_FLTCR1_JEXTSEL_Msk               /*!< JEXTSEL[4:0]Trigger signal selection for launching injected conversions */
#define DFSDM_FLTCR1_JEXTSEL_0          (0x01UL << DFSDM_FLTCR1_JEXTSEL_Pos)    /*!< 0x00000100 */
#define DFSDM_FLTCR1_JEXTSEL_1          (0x02UL << DFSDM_FLTCR1_JEXTSEL_Pos)    /*!< 0x00000200 */
#define DFSDM_FLTCR1_JEXTSEL_2          (0x04UL << DFSDM_FLTCR1_JEXTSEL_Pos)    /*!< 0x00000400 */
#define DFSDM_FLTCR1_JEXTSEL_3          (0x08UL << DFSDM_FLTCR1_JEXTSEL_Pos)    /*!< 0x00000800 */
#define DFSDM_FLTCR1_JEXTSEL_4          (0x10UL << DFSDM_FLTCR1_JEXTSEL_Pos)    /*!< 0x00001000 */

#define DFSDM_FLTCR1_JDMAEN_Pos         (5U)
#define DFSDM_FLTCR1_JDMAEN_Msk         (0x1UL << DFSDM_FLTCR1_JDMAEN_Pos)     /*!< 0x00000020 */
#define DFSDM_FLTCR1_JDMAEN             DFSDM_FLTCR1_JDMAEN_Msk                /*!< DMA channel enabled to read data for the injected channel group */
#define DFSDM_FLTCR1_JSCAN_Pos          (4U)
#define DFSDM_FLTCR1_JSCAN_Msk          (0x1UL << DFSDM_FLTCR1_JSCAN_Pos)      /*!< 0x00000010 */
#define DFSDM_FLTCR1_JSCAN              DFSDM_FLTCR1_JSCAN_Msk                 /*!< Scanning conversion in continuous mode selection for injected conversions */
#define DFSDM_FLTCR1_JSYNC_Pos          (3U)
#define DFSDM_FLTCR1_JSYNC_Msk          (0x1UL << DFSDM_FLTCR1_JSYNC_Pos)      /*!< 0x00000008 */
#define DFSDM_FLTCR1_JSYNC              DFSDM_FLTCR1_JSYNC_Msk                 /*!< Launch an injected conversion synchronously with DFSDMx JSWSTART trigger  */
#define DFSDM_FLTCR1_JSWSTART_Pos       (1U)
#define DFSDM_FLTCR1_JSWSTART_Msk       (0x1UL << DFSDM_FLTCR1_JSWSTART_Pos)   /*!< 0x00000002 */
#define DFSDM_FLTCR1_JSWSTART           DFSDM_FLTCR1_JSWSTART_Msk              /*!< Start the conversion of the injected group of channels */
#define DFSDM_FLTCR1_DFEN_Pos           (0U)
#define DFSDM_FLTCR1_DFEN_Msk           (0x1UL << DFSDM_FLTCR1_DFEN_Pos)       /*!< 0x00000001 */
#define DFSDM_FLTCR1_DFEN               DFSDM_FLTCR1_DFEN_Msk                  /*!< DFSDM enable */

/********************  Bit definition for DFSDM_FLTCR2 register *******************/
#define DFSDM_FLTCR2_AWDCH_Pos          (16U)
#define DFSDM_FLTCR2_AWDCH_Msk          (0xFFUL << DFSDM_FLTCR2_AWDCH_Pos)     /*!< 0x00FF0000 */
#define DFSDM_FLTCR2_AWDCH              DFSDM_FLTCR2_AWDCH_Msk                 /*!< AWDCH[7:0] Analog watchdog channel selection */
#define DFSDM_FLTCR2_EXCH_Pos           (8U)
#define DFSDM_FLTCR2_EXCH_Msk           (0xFFUL << DFSDM_FLTCR2_EXCH_Pos)      /*!< 0x0000FF00 */
#define DFSDM_FLTCR2_EXCH               DFSDM_FLTCR2_EXCH_Msk                  /*!< EXCH[7:0] Extreme detector channel selection */
#define DFSDM_FLTCR2_CKABIE_Pos         (6U)
#define DFSDM_FLTCR2_CKABIE_Msk         (0x1UL << DFSDM_FLTCR2_CKABIE_Pos)     /*!< 0x00000040 */
#define DFSDM_FLTCR2_CKABIE             DFSDM_FLTCR2_CKABIE_Msk                /*!< Clock absence interrupt enable */
#define DFSDM_FLTCR2_SCDIE_Pos          (5U)
#define DFSDM_FLTCR2_SCDIE_Msk          (0x1UL << DFSDM_FLTCR2_SCDIE_Pos)      /*!< 0x00000020 */
#define DFSDM_FLTCR2_SCDIE              DFSDM_FLTCR2_SCDIE_Msk                 /*!< Short circuit detector interrupt enable */
#define DFSDM_FLTCR2_AWDIE_Pos          (4U)
#define DFSDM_FLTCR2_AWDIE_Msk          (0x1UL << DFSDM_FLTCR2_AWDIE_Pos)      /*!< 0x00000010 */
#define DFSDM_FLTCR2_AWDIE              DFSDM_FLTCR2_AWDIE_Msk                 /*!< Analog watchdog interrupt enable */
#define DFSDM_FLTCR2_ROVRIE_Pos         (3U)
#define DFSDM_FLTCR2_ROVRIE_Msk         (0x1UL << DFSDM_FLTCR2_ROVRIE_Pos)     /*!< 0x00000008 */
#define DFSDM_FLTCR2_ROVRIE             DFSDM_FLTCR2_ROVRIE_Msk                /*!< Regular data overrun interrupt enable */
#define DFSDM_FLTCR2_JOVRIE_Pos         (2U)
#define DFSDM_FLTCR2_JOVRIE_Msk         (0x1UL << DFSDM_FLTCR2_JOVRIE_Pos)     /*!< 0x00000004 */
#define DFSDM_FLTCR2_JOVRIE             DFSDM_FLTCR2_JOVRIE_Msk                /*!< Injected data overrun interrupt enable */
#define DFSDM_FLTCR2_REOCIE_Pos         (1U)
#define DFSDM_FLTCR2_REOCIE_Msk         (0x1UL << DFSDM_FLTCR2_REOCIE_Pos)     /*!< 0x00000002 */
#define DFSDM_FLTCR2_REOCIE             DFSDM_FLTCR2_REOCIE_Msk                /*!< Regular end of conversion interrupt enable */
#define DFSDM_FLTCR2_JEOCIE_Pos         (0U)
#define DFSDM_FLTCR2_JEOCIE_Msk         (0x1UL << DFSDM_FLTCR2_JEOCIE_Pos)     /*!< 0x00000001 */
#define DFSDM_FLTCR2_JEOCIE             DFSDM_FLTCR2_JEOCIE_Msk                /*!< Injected end of conversion interrupt enable */

/********************  Bit definition for DFSDM_FLTISR register *******************/
#define DFSDM_FLTISR_SCDF_Pos           (24U)
#define DFSDM_FLTISR_SCDF_Msk           (0xFFUL << DFSDM_FLTISR_SCDF_Pos)      /*!< 0xFF000000 */
#define DFSDM_FLTISR_SCDF               DFSDM_FLTISR_SCDF_Msk                  /*!< SCDF[7:0] Short circuit detector flag */
#define DFSDM_FLTISR_CKABF_Pos          (16U)
#define DFSDM_FLTISR_CKABF_Msk          (0xFFUL << DFSDM_FLTISR_CKABF_Pos)     /*!< 0x00FF0000 */
#define DFSDM_FLTISR_CKABF              DFSDM_FLTISR_CKABF_Msk                 /*!< CKABF[7:0] Clock absence flag */
#define DFSDM_FLTISR_RCIP_Pos           (14U)
#define DFSDM_FLTISR_RCIP_Msk           (0x1UL << DFSDM_FLTISR_RCIP_Pos)       /*!< 0x00004000 */
#define DFSDM_FLTISR_RCIP               DFSDM_FLTISR_RCIP_Msk                  /*!< Regular conversion in progress status */
#define DFSDM_FLTISR_JCIP_Pos           (13U)
#define DFSDM_FLTISR_JCIP_Msk           (0x1UL << DFSDM_FLTISR_JCIP_Pos)       /*!< 0x00002000 */
#define DFSDM_FLTISR_JCIP               DFSDM_FLTISR_JCIP_Msk                  /*!< Injected conversion in progress status */
#define DFSDM_FLTISR_AWDF_Pos           (4U)
#define DFSDM_FLTISR_AWDF_Msk           (0x1UL << DFSDM_FLTISR_AWDF_Pos)       /*!< 0x00000010 */
#define DFSDM_FLTISR_AWDF               DFSDM_FLTISR_AWDF_Msk                  /*!< Analog watchdog */
#define DFSDM_FLTISR_ROVRF_Pos          (3U)
#define DFSDM_FLTISR_ROVRF_Msk          (0x1UL << DFSDM_FLTISR_ROVRF_Pos)      /*!< 0x00000008 */
#define DFSDM_FLTISR_ROVRF              DFSDM_FLTISR_ROVRF_Msk                 /*!< Regular conversion overrun flag */
#define DFSDM_FLTISR_JOVRF_Pos          (2U)
#define DFSDM_FLTISR_JOVRF_Msk          (0x1UL << DFSDM_FLTISR_JOVRF_Pos)      /*!< 0x00000004 */
#define DFSDM_FLTISR_JOVRF              DFSDM_FLTISR_JOVRF_Msk                 /*!< Injected conversion overrun flag */
#define DFSDM_FLTISR_REOCF_Pos          (1U)
#define DFSDM_FLTISR_REOCF_Msk          (0x1UL << DFSDM_FLTISR_REOCF_Pos)      /*!< 0x00000002 */
#define DFSDM_FLTISR_REOCF              DFSDM_FLTISR_REOCF_Msk                 /*!< End of regular conversion flag */
#define DFSDM_FLTISR_JEOCF_Pos          (0U)
#define DFSDM_FLTISR_JEOCF_Msk          (0x1UL << DFSDM_FLTISR_JEOCF_Pos)      /*!< 0x00000001 */
#define DFSDM_FLTISR_JEOCF              DFSDM_FLTISR_JEOCF_Msk                 /*!< End of injected conversion flag */

/********************  Bit definition for DFSDM_FLTICR register *******************/
#define DFSDM_FLTICR_CLRSCDF_Pos        (24U)
#define DFSDM_FLTICR_CLRSCDF_Msk        (0xFFUL << DFSDM_FLTICR_CLRSCDF_Pos)   /*!< 0xFF000000 */
#define DFSDM_FLTICR_CLRSCDF            DFSDM_FLTICR_CLRSCDF_Msk               /*!< CLRSCSDF[7:0] Clear the short circuit detector flag */
#define DFSDM_FLTICR_CLRCKABF_Pos       (16U)
#define DFSDM_FLTICR_CLRCKABF_Msk       (0xFFUL << DFSDM_FLTICR_CLRCKABF_Pos)  /*!< 0x00FF0000 */
#define DFSDM_FLTICR_CLRCKABF           DFSDM_FLTICR_CLRCKABF_Msk              /*!< CLRCKABF[7:0] Clear the clock absence flag */
#define DFSDM_FLTICR_CLRROVRF_Pos       (3U)
#define DFSDM_FLTICR_CLRROVRF_Msk       (0x1UL << DFSDM_FLTICR_CLRROVRF_Pos)   /*!< 0x00000008 */
#define DFSDM_FLTICR_CLRROVRF           DFSDM_FLTICR_CLRROVRF_Msk              /*!< Clear the regular conversion overrun flag */
#define DFSDM_FLTICR_CLRJOVRF_Pos       (2U)
#define DFSDM_FLTICR_CLRJOVRF_Msk       (0x1UL << DFSDM_FLTICR_CLRJOVRF_Pos)   /*!< 0x00000004 */
#define DFSDM_FLTICR_CLRJOVRF           DFSDM_FLTICR_CLRJOVRF_Msk              /*!< Clear the injected conversion overrun flag */

/*******************  Bit definition for DFSDM_FLTJCHGR register ******************/
#define DFSDM_FLTJCHGR_JCHG_Pos         (0U)
#define DFSDM_FLTJCHGR_JCHG_Msk         (0xFFUL << DFSDM_FLTJCHGR_JCHG_Pos)    /*!< 0x000000FF */
#define DFSDM_FLTJCHGR_JCHG             DFSDM_FLTJCHGR_JCHG_Msk                /*!< JCHG[7:0] Injected channel group selection */

/********************  Bit definition for DFSDM_FLTFCR register *******************/
#define DFSDM_FLTFCR_FORD_Pos           (29U)
#define DFSDM_FLTFCR_FORD_Msk           (0x7UL << DFSDM_FLTFCR_FORD_Pos)       /*!< 0xE0000000 */
#define DFSDM_FLTFCR_FORD               DFSDM_FLTFCR_FORD_Msk                  /*!< FORD[2:0] Sinc filter order */
#define DFSDM_FLTFCR_FORD_2             (0x4UL << DFSDM_FLTFCR_FORD_Pos)        /*!< 0x80000000 */
#define DFSDM_FLTFCR_FORD_1             (0x2UL << DFSDM_FLTFCR_FORD_Pos)        /*!< 0x40000000 */
#define DFSDM_FLTFCR_FORD_0             (0x1UL << DFSDM_FLTFCR_FORD_Pos)        /*!< 0x20000000 */
#define DFSDM_FLTFCR_FOSR_Pos           (16U)
#define DFSDM_FLTFCR_FOSR_Msk           (0x3FFUL << DFSDM_FLTFCR_FOSR_Pos)     /*!< 0x03FF0000 */
#define DFSDM_FLTFCR_FOSR               DFSDM_FLTFCR_FOSR_Msk                  /*!< FOSR[9:0] Sinc filter oversampling ratio (decimation rate) */
#define DFSDM_FLTFCR_IOSR_Pos           (0U)
#define DFSDM_FLTFCR_IOSR_Msk           (0xFFUL << DFSDM_FLTFCR_IOSR_Pos)      /*!< 0x000000FF */
#define DFSDM_FLTFCR_IOSR               DFSDM_FLTFCR_IOSR_Msk                  /*!< IOSR[7:0] Integrator oversampling ratio (averaging length) */

/******************  Bit definition for DFSDM_FLTJDATAR register *****************/
#define DFSDM_FLTJDATAR_JDATA_Pos       (8U)
#define DFSDM_FLTJDATAR_JDATA_Msk       (0xFFFFFFUL << DFSDM_FLTJDATAR_JDATA_Pos) /*!< 0xFFFFFF00 */
#define DFSDM_FLTJDATAR_JDATA           DFSDM_FLTJDATAR_JDATA_Msk              /*!< JDATA[23:0] Injected group conversion data */
#define DFSDM_FLTJDATAR_JDATACH_Pos     (0U)
#define DFSDM_FLTJDATAR_JDATACH_Msk     (0x7UL << DFSDM_FLTJDATAR_JDATACH_Pos) /*!< 0x00000007 */
#define DFSDM_FLTJDATAR_JDATACH         DFSDM_FLTJDATAR_JDATACH_Msk            /*!< JDATACH[2:0] Injected channel most recently converted */

/******************  Bit definition for DFSDM_FLTRDATAR register *****************/
#define DFSDM_FLTRDATAR_RDATA_Pos       (8U)
#define DFSDM_FLTRDATAR_RDATA_Msk       (0xFFFFFFUL << DFSDM_FLTRDATAR_RDATA_Pos) /*!< 0xFFFFFF00 */
#define DFSDM_FLTRDATAR_RDATA           DFSDM_FLTRDATAR_RDATA_Msk              /*!< RDATA[23:0] Regular channel conversion data */
#define DFSDM_FLTRDATAR_RPEND_Pos       (4U)
#define DFSDM_FLTRDATAR_RPEND_Msk       (0x1UL << DFSDM_FLTRDATAR_RPEND_Pos)   /*!< 0x00000010 */
#define DFSDM_FLTRDATAR_RPEND           DFSDM_FLTRDATAR_RPEND_Msk              /*!< RPEND Regular channel pending data */
#define DFSDM_FLTRDATAR_RDATACH_Pos     (0U)
#define DFSDM_FLTRDATAR_RDATACH_Msk     (0x7UL << DFSDM_FLTRDATAR_RDATACH_Pos) /*!< 0x00000007 */
#define DFSDM_FLTRDATAR_RDATACH         DFSDM_FLTRDATAR_RDATACH_Msk            /*!< RDATACH[2:0] Regular channel most recently converted */

/******************  Bit definition for DFSDM_FLTAWHTR register ******************/
#define DFSDM_FLTAWHTR_AWHT_Pos         (8U)
#define DFSDM_FLTAWHTR_AWHT_Msk         (0xFFFFFFUL << DFSDM_FLTAWHTR_AWHT_Pos) /*!< 0xFFFFFF00 */
#define DFSDM_FLTAWHTR_AWHT             DFSDM_FLTAWHTR_AWHT_Msk                /*!< AWHT[23:0] Analog watchdog high threshold */
#define DFSDM_FLTAWHTR_BKAWH_Pos        (0U)
#define DFSDM_FLTAWHTR_BKAWH_Msk        (0xFUL << DFSDM_FLTAWHTR_BKAWH_Pos)    /*!< 0x0000000F */
#define DFSDM_FLTAWHTR_BKAWH            DFSDM_FLTAWHTR_BKAWH_Msk               /*!< BKAWH[3:0] Break signal assignment to analog watchdog high threshold event */

/******************  Bit definition for DFSDM_FLTAWLTR register ******************/
#define DFSDM_FLTAWLTR_AWLT_Pos         (8U)
#define DFSDM_FLTAWLTR_AWLT_Msk         (0xFFFFFFUL << DFSDM_FLTAWLTR_AWLT_Pos) /*!< 0xFFFFFF00 */
#define DFSDM_FLTAWLTR_AWLT             DFSDM_FLTAWLTR_AWLT_Msk                /*!< AWHT[23:0] Analog watchdog low threshold */
#define DFSDM_FLTAWLTR_BKAWL_Pos        (0U)
#define DFSDM_FLTAWLTR_BKAWL_Msk        (0xFUL << DFSDM_FLTAWLTR_BKAWL_Pos)    /*!< 0x0000000F */
#define DFSDM_FLTAWLTR_BKAWL            DFSDM_FLTAWLTR_BKAWL_Msk               /*!< BKAWL[3:0] Break signal assignment to analog watchdog low threshold event */

/******************  Bit definition for DFSDM_FLTAWSR register ******************/
#define DFSDM_FLTAWSR_AWHTF_Pos         (8U)
#define DFSDM_FLTAWSR_AWHTF_Msk         (0xFFUL << DFSDM_FLTAWSR_AWHTF_Pos)    /*!< 0x0000FF00 */
#define DFSDM_FLTAWSR_AWHTF             DFSDM_FLTAWSR_AWHTF_Msk                /*!< AWHTF[15:8] Analog watchdog high threshold error on given channels */
#define DFSDM_FLTAWSR_AWLTF_Pos         (0U)
#define DFSDM_FLTAWSR_AWLTF_Msk         (0xFFUL << DFSDM_FLTAWSR_AWLTF_Pos)    /*!< 0x000000FF */
#define DFSDM_FLTAWSR_AWLTF             DFSDM_FLTAWSR_AWLTF_Msk                /*!< AWLTF[7:0] Analog watchdog low threshold error on given channels */

/******************  Bit definition for DFSDM_FLTAWCFR) register *****************/
#define DFSDM_FLTAWCFR_CLRAWHTF_Pos     (8U)
#define DFSDM_FLTAWCFR_CLRAWHTF_Msk     (0xFFUL << DFSDM_FLTAWCFR_CLRAWHTF_Pos) /*!< 0x0000FF00 */
#define DFSDM_FLTAWCFR_CLRAWHTF         DFSDM_FLTAWCFR_CLRAWHTF_Msk            /*!< CLRAWHTF[15:8] Clear the Analog watchdog high threshold flag */
#define DFSDM_FLTAWCFR_CLRAWLTF_Pos     (0U)
#define DFSDM_FLTAWCFR_CLRAWLTF_Msk     (0xFFUL << DFSDM_FLTAWCFR_CLRAWLTF_Pos) /*!< 0x000000FF */
#define DFSDM_FLTAWCFR_CLRAWLTF         DFSDM_FLTAWCFR_CLRAWLTF_Msk            /*!< CLRAWLTF[7:0] Clear the Analog watchdog low threshold flag */

/******************  Bit definition for DFSDM_FLTEXMAX register ******************/
#define DFSDM_FLTEXMAX_EXMAX_Pos        (8U)
#define DFSDM_FLTEXMAX_EXMAX_Msk        (0xFFFFFFUL << DFSDM_FLTEXMAX_EXMAX_Pos) /*!< 0xFFFFFF00 */
#define DFSDM_FLTEXMAX_EXMAX            DFSDM_FLTEXMAX_EXMAX_Msk               /*!< EXMAX[23:0] Extreme detector maximum value */
#define DFSDM_FLTEXMAX_EXMAXCH_Pos      (0U)
#define DFSDM_FLTEXMAX_EXMAXCH_Msk      (0x7UL << DFSDM_FLTEXMAX_EXMAXCH_Pos)  /*!< 0x00000007 */
#define DFSDM_FLTEXMAX_EXMAXCH          DFSDM_FLTEXMAX_EXMAXCH_Msk             /*!< EXMAXCH[2:0] Extreme detector maximum data channel */

/******************  Bit definition for DFSDM_FLTEXMIN register ******************/
#define DFSDM_FLTEXMIN_EXMIN_Pos        (8U)
#define DFSDM_FLTEXMIN_EXMIN_Msk        (0xFFFFFFUL << DFSDM_FLTEXMIN_EXMIN_Pos) /*!< 0xFFFFFF00 */
#define DFSDM_FLTEXMIN_EXMIN            DFSDM_FLTEXMIN_EXMIN_Msk               /*!< EXMIN[23:0] Extreme detector minimum value */
#define DFSDM_FLTEXMIN_EXMINCH_Pos      (0U)
#define DFSDM_FLTEXMIN_EXMINCH_Msk      (0x7UL << DFSDM_FLTEXMIN_EXMINCH_Pos)  /*!< 0x00000007 */
#define DFSDM_FLTEXMIN_EXMINCH          DFSDM_FLTEXMIN_EXMINCH_Msk             /*!< EXMINCH[2:0] Extreme detector minimum data channel */

/******************  Bit definition for DFSDM_FLTCNVTIMR register ******************/
#define DFSDM_FLTCNVTIMR_CNVCNT_Pos     (4U)
#define DFSDM_FLTCNVTIMR_CNVCNT_Msk     (0xFFFFFFFUL << DFSDM_FLTCNVTIMR_CNVCNT_Pos) /*!< 0xFFFFFFF0 */
#define DFSDM_FLTCNVTIMR_CNVCNT         DFSDM_FLTCNVTIMR_CNVCNT_Msk            /*!< CNVCNT[27:0]: 28-bit timer counting conversion time */

/******************************************************************************/
/*                                                                            */
/*                           BDMA Controller                                  */
/*                                                                            */
/******************************************************************************/

/*******************  Bit definition for BDMA_ISR register  ********************/
#define BDMA_ISR_GIF0_Pos       (0U)
#define BDMA_ISR_GIF0_Msk       (0x1UL << BDMA_ISR_GIF0_Pos)                   /*!< 0x00000001 */
#define BDMA_ISR_GIF0           BDMA_ISR_GIF0_Msk                              /*!< Channel 0 Global interrupt flag */
#define BDMA_ISR_TCIF0_Pos      (1U)
#define BDMA_ISR_TCIF0_Msk      (0x1UL << BDMA_ISR_TCIF0_Pos)                  /*!< 0x00000002 */
#define BDMA_ISR_TCIF0          BDMA_ISR_TCIF0_Msk                             /*!< Channel 0 Transfer Complete flag */
#define BDMA_ISR_HTIF0_Pos      (2U)
#define BDMA_ISR_HTIF0_Msk      (0x1UL << BDMA_ISR_HTIF0_Pos)                  /*!< 0x00000004 */
#define BDMA_ISR_HTIF0          BDMA_ISR_HTIF0_Msk                             /*!< Channel 0 Half Transfer flag */
#define BDMA_ISR_TEIF0_Pos      (3U)
#define BDMA_ISR_TEIF0_Msk      (0x1UL << BDMA_ISR_TEIF0_Pos)                  /*!< 0x00000008 */
#define BDMA_ISR_TEIF0          BDMA_ISR_TEIF0_Msk                             /*!< Channel 0 Transfer Error flag */
#define BDMA_ISR_GIF1_Pos       (4U)
#define BDMA_ISR_GIF1_Msk       (0x1UL << BDMA_ISR_GIF1_Pos)                   /*!< 0x00000010 */
#define BDMA_ISR_GIF1           BDMA_ISR_GIF1_Msk                              /*!< Channel 1 Global interrupt flag */
#define BDMA_ISR_TCIF1_Pos      (5U)
#define BDMA_ISR_TCIF1_Msk      (0x1UL << BDMA_ISR_TCIF1_Pos)                  /*!< 0x00000020 */
#define BDMA_ISR_TCIF1          BDMA_ISR_TCIF1_Msk                             /*!< Channel 1 Transfer Complete flag */
#define BDMA_ISR_HTIF1_Pos      (6U)
#define BDMA_ISR_HTIF1_Msk      (0x1UL << BDMA_ISR_HTIF1_Pos)                  /*!< 0x00000040 */
#define BDMA_ISR_HTIF1          BDMA_ISR_HTIF1_Msk                             /*!< Channel 1 Half Transfer flag */
#define BDMA_ISR_TEIF1_Pos      (7U)
#define BDMA_ISR_TEIF1_Msk      (0x1UL << BDMA_ISR_TEIF1_Pos)                  /*!< 0x00000080 */
#define BDMA_ISR_TEIF1          BDMA_ISR_TEIF1_Msk                             /*!< Channel 1 Transfer Error flag */
#define BDMA_ISR_GIF2_Pos       (8U)
#define BDMA_ISR_GIF2_Msk       (0x1UL << BDMA_ISR_GIF2_Pos)                   /*!< 0x00000100 */
#define BDMA_ISR_GIF2           BDMA_ISR_GIF2_Msk                              /*!< Channel 2 Global interrupt flag */
#define BDMA_ISR_TCIF2_Pos      (9U)
#define BDMA_ISR_TCIF2_Msk      (0x1UL << BDMA_ISR_TCIF2_Pos)                  /*!< 0x00000200 */
#define BDMA_ISR_TCIF2          BDMA_ISR_TCIF2_Msk                             /*!< Channel 2 Transfer Complete flag */
#define BDMA_ISR_HTIF2_Pos      (10U)
#define BDMA_ISR_HTIF2_Msk      (0x1UL << BDMA_ISR_HTIF2_Pos)                  /*!< 0x00000400 */
#define BDMA_ISR_HTIF2          BDMA_ISR_HTIF2_Msk                             /*!< Channel 2 Half Transfer flag */
#define BDMA_ISR_TEIF2_Pos      (11U)
#define BDMA_ISR_TEIF2_Msk      (0x1UL << BDMA_ISR_TEIF2_Pos)                  /*!< 0x00000800 */
#define BDMA_ISR_TEIF2          BDMA_ISR_TEIF2_Msk                             /*!< Channel 2 Transfer Error flag */
#define BDMA_ISR_GIF3_Pos       (12U)
#define BDMA_ISR_GIF3_Msk       (0x1UL << BDMA_ISR_GIF3_Pos)                   /*!< 0x00001000 */
#define BDMA_ISR_GIF3           BDMA_ISR_GIF3_Msk                              /*!< Channel 3 Global interrupt flag */
#define BDMA_ISR_TCIF3_Pos      (13U)
#define BDMA_ISR_TCIF3_Msk      (0x1UL << BDMA_ISR_TCIF3_Pos)                  /*!< 0x00002000 */
#define BDMA_ISR_TCIF3          BDMA_ISR_TCIF3_Msk                             /*!< Channel 3 Transfer Complete flag */
#define BDMA_ISR_HTIF3_Pos      (14U)
#define BDMA_ISR_HTIF3_Msk      (0x1UL << BDMA_ISR_HTIF3_Pos)                  /*!< 0x00004000 */
#define BDMA_ISR_HTIF3          BDMA_ISR_HTIF3_Msk                             /*!< Channel 3 Half Transfer flag */
#define BDMA_ISR_TEIF3_Pos      (15U)
#define BDMA_ISR_TEIF3_Msk      (0x1UL << BDMA_ISR_TEIF3_Pos)                  /*!< 0x00008000 */
#define BDMA_ISR_TEIF3          BDMA_ISR_TEIF3_Msk                             /*!< Channel 3 Transfer Error flag */
#define BDMA_ISR_GIF4_Pos       (16U)
#define BDMA_ISR_GIF4_Msk       (0x1UL << BDMA_ISR_GIF4_Pos)                   /*!< 0x00010000 */
#define BDMA_ISR_GIF4           BDMA_ISR_GIF4_Msk                              /*!< Channel 4 Global interrupt flag */
#define BDMA_ISR_TCIF4_Pos      (17U)
#define BDMA_ISR_TCIF4_Msk      (0x1UL << BDMA_ISR_TCIF4_Pos)                  /*!< 0x00020000 */
#define BDMA_ISR_TCIF4          BDMA_ISR_TCIF4_Msk                             /*!< Channel 4 Transfer Complete flag */
#define BDMA_ISR_HTIF4_Pos      (18U)
#define BDMA_ISR_HTIF4_Msk      (0x1UL << BDMA_ISR_HTIF4_Pos)                  /*!< 0x00040000 */
#define BDMA_ISR_HTIF4          BDMA_ISR_HTIF4_Msk                             /*!< Channel 4 Half Transfer flag */
#define BDMA_ISR_TEIF4_Pos      (19U)
#define BDMA_ISR_TEIF4_Msk      (0x1UL << BDMA_ISR_TEIF4_Pos)                  /*!< 0x00080000 */
#define BDMA_ISR_TEIF4          BDMA_ISR_TEIF4_Msk                             /*!< Channel 4 Transfer Error flag */
#define BDMA_ISR_GIF5_Pos       (20U)
#define BDMA_ISR_GIF5_Msk       (0x1UL << BDMA_ISR_GIF5_Pos)                   /*!< 0x00100000 */
#define BDMA_ISR_GIF5           BDMA_ISR_GIF5_Msk                              /*!< Channel 5 Global interrupt flag */
#define BDMA_ISR_TCIF5_Pos      (21U)
#define BDMA_ISR_TCIF5_Msk      (0x1UL << BDMA_ISR_TCIF5_Pos)                  /*!< 0x00200000 */
#define BDMA_ISR_TCIF5          BDMA_ISR_TCIF5_Msk                             /*!< Channel 5 Transfer Complete flag */
#define BDMA_ISR_HTIF5_Pos      (22U)
#define BDMA_ISR_HTIF5_Msk      (0x1UL << BDMA_ISR_HTIF5_Pos)                  /*!< 0x00400000 */
#define BDMA_ISR_HTIF5          BDMA_ISR_HTIF5_Msk                             /*!< Channel 5 Half Transfer flag */
#define BDMA_ISR_TEIF5_Pos      (23U)
#define BDMA_ISR_TEIF5_Msk      (0x1UL << BDMA_ISR_TEIF5_Pos)                  /*!< 0x00800000 */
#define BDMA_ISR_TEIF5          BDMA_ISR_TEIF5_Msk                             /*!< Channel 5 Transfer Error flag */
#define BDMA_ISR_GIF6_Pos       (24U)
#define BDMA_ISR_GIF6_Msk       (0x1UL << BDMA_ISR_GIF6_Pos)                   /*!< 0x01000000 */
#define BDMA_ISR_GIF6           BDMA_ISR_GIF6_Msk                              /*!< Channel 6 Global interrupt flag */
#define BDMA_ISR_TCIF6_Pos      (25U)
#define BDMA_ISR_TCIF6_Msk      (0x1UL << BDMA_ISR_TCIF6_Pos)                  /*!< 0x02000000 */
#define BDMA_ISR_TCIF6          BDMA_ISR_TCIF6_Msk                             /*!< Channel 6 Transfer Complete flag */
#define BDMA_ISR_HTIF6_Pos      (26U)
#define BDMA_ISR_HTIF6_Msk      (0x1UL << BDMA_ISR_HTIF6_Pos)                  /*!< 0x04000000 */
#define BDMA_ISR_HTIF6          BDMA_ISR_HTIF6_Msk                             /*!< Channel 6 Half Transfer flag */
#define BDMA_ISR_TEIF6_Pos      (27U)
#define BDMA_ISR_TEIF6_Msk      (0x1UL << BDMA_ISR_TEIF6_Pos)                  /*!< 0x08000000 */
#define BDMA_ISR_TEIF6          BDMA_ISR_TEIF6_Msk                             /*!< Channel 6 Transfer Error flag */
#define BDMA_ISR_GIF7_Pos       (28U)
#define BDMA_ISR_GIF7_Msk       (0x1UL << BDMA_ISR_GIF7_Pos)                   /*!< 0x10000000 */
#define BDMA_ISR_GIF7           BDMA_ISR_GIF7_Msk                              /*!< Channel 7 Global interrupt flag */
#define BDMA_ISR_TCIF7_Pos      (29U)
#define BDMA_ISR_TCIF7_Msk      (0x1UL << BDMA_ISR_TCIF7_Pos)                  /*!< 0x20000000 */
#define BDMA_ISR_TCIF7          BDMA_ISR_TCIF7_Msk                             /*!< Channel 7 Transfer Complete flag */
#define BDMA_ISR_HTIF7_Pos      (30U)
#define BDMA_ISR_HTIF7_Msk      (0x1UL << BDMA_ISR_HTIF7_Pos)                  /*!< 0x40000000 */
#define BDMA_ISR_HTIF7          BDMA_ISR_HTIF7_Msk                             /*!< Channel 7 Half Transfer flag */
#define BDMA_ISR_TEIF7_Pos      (31U)
#define BDMA_ISR_TEIF7_Msk      (0x1UL << BDMA_ISR_TEIF7_Pos)                  /*!< 0x80000000 */
#define BDMA_ISR_TEIF7          BDMA_ISR_TEIF7_Msk                             /*!< Channel 7 Transfer Error flag */

/*******************  Bit definition for BDMA_IFCR register  *******************/
#define BDMA_IFCR_CGIF0_Pos     (0U)
#define BDMA_IFCR_CGIF0_Msk     (0x1UL << BDMA_IFCR_CGIF0_Pos)                 /*!< 0x00000001 */
#define BDMA_IFCR_CGIF0         BDMA_IFCR_CGIF0_Msk                            /*!< Channel 0 Global interrupt clearr */
#define BDMA_IFCR_CTCIF0_Pos    (1U)
#define BDMA_IFCR_CTCIF0_Msk    (0x1UL << BDMA_IFCR_CTCIF0_Pos)                /*!< 0x00000002 */
#define BDMA_IFCR_CTCIF0        BDMA_IFCR_CTCIF0_Msk                           /*!< Channel 0 Transfer Complete clear */
#define BDMA_IFCR_CHTIF0_Pos    (2U)
#define BDMA_IFCR_CHTIF0_Msk    (0x1UL << BDMA_IFCR_CHTIF0_Pos)                /*!< 0x00000004 */
#define BDMA_IFCR_CHTIF0        BDMA_IFCR_CHTIF0_Msk                           /*!< Channel 0 Half Transfer clear */
#define BDMA_IFCR_CTEIF0_Pos    (3U)
#define BDMA_IFCR_CTEIF0_Msk    (0x1UL << BDMA_IFCR_CTEIF0_Pos)                /*!< 0x00000008 */
#define BDMA_IFCR_CTEIF0        BDMA_IFCR_CTEIF0_Msk                           /*!< Channel 0 Transfer Error clear */
#define BDMA_IFCR_CGIF1_Pos     (4U)
#define BDMA_IFCR_CGIF1_Msk     (0x1UL << BDMA_IFCR_CGIF1_Pos)                 /*!< 0x00000010 */
#define BDMA_IFCR_CGIF1         BDMA_IFCR_CGIF1_Msk                            /*!< Channel 1 Global interrupt clear */
#define BDMA_IFCR_CTCIF1_Pos    (5U)
#define BDMA_IFCR_CTCIF1_Msk    (0x1UL << BDMA_IFCR_CTCIF1_Pos)                /*!< 0x00000020 */
#define BDMA_IFCR_CTCIF1        BDMA_IFCR_CTCIF1_Msk                           /*!< Channel 1 Transfer Complete clear */
#define BDMA_IFCR_CHTIF1_Pos    (6U)
#define BDMA_IFCR_CHTIF1_Msk    (0x1UL << BDMA_IFCR_CHTIF1_Pos)                /*!< 0x00000040 */
#define BDMA_IFCR_CHTIF1        BDMA_IFCR_CHTIF1_Msk                           /*!< Channel 1 Half Transfer clear */
#define BDMA_IFCR_CTEIF1_Pos    (7U)
#define BDMA_IFCR_CTEIF1_Msk    (0x1UL << BDMA_IFCR_CTEIF1_Pos)                /*!< 0x00000080 */
#define BDMA_IFCR_CTEIF1        BDMA_IFCR_CTEIF1_Msk                           /*!< Channel 1 Transfer Error clear */
#define BDMA_IFCR_CGIF2_Pos     (8U)
#define BDMA_IFCR_CGIF2_Msk     (0x1UL << BDMA_IFCR_CGIF2_Pos)                 /*!< 0x00000100 */
#define BDMA_IFCR_CGIF2         BDMA_IFCR_CGIF2_Msk                            /*!< Channel 2 Global interrupt clear */
#define BDMA_IFCR_CTCIF2_Pos    (9U)
#define BDMA_IFCR_CTCIF2_Msk    (0x1UL << BDMA_IFCR_CTCIF2_Pos)                /*!< 0x00000200 */
#define BDMA_IFCR_CTCIF2        BDMA_IFCR_CTCIF2_Msk                           /*!< Channel 2 Transfer Complete clear */
#define BDMA_IFCR_CHTIF2_Pos    (10U)
#define BDMA_IFCR_CHTIF2_Msk    (0x1UL << BDMA_IFCR_CHTIF2_Pos)                /*!< 0x00000400 */
#define BDMA_IFCR_CHTIF2        BDMA_IFCR_CHTIF2_Msk                           /*!< Channel 2 Half Transfer clear */
#define BDMA_IFCR_CTEIF2_Pos    (11U)
#define BDMA_IFCR_CTEIF2_Msk    (0x1UL << BDMA_IFCR_CTEIF2_Pos)                /*!< 0x00000800 */
#define BDMA_IFCR_CTEIF2        BDMA_IFCR_CTEIF2_Msk                           /*!< Channel 2 Transfer Error clear */
#define BDMA_IFCR_CGIF3_Pos     (12U)
#define BDMA_IFCR_CGIF3_Msk     (0x1UL << BDMA_IFCR_CGIF3_Pos)                 /*!< 0x00001000 */
#define BDMA_IFCR_CGIF3         BDMA_IFCR_CGIF3_Msk                            /*!< Channel 3 Global interrupt clear */
#define BDMA_IFCR_CTCIF3_Pos    (13U)
#define BDMA_IFCR_CTCIF3_Msk    (0x1UL << BDMA_IFCR_CTCIF3_Pos)                /*!< 0x00002000 */
#define BDMA_IFCR_CTCIF3        BDMA_IFCR_CTCIF3_Msk                           /*!< Channel 3 Transfer Complete clear */
#define BDMA_IFCR_CHTIF3_Pos    (14U)
#define BDMA_IFCR_CHTIF3_Msk    (0x1UL << BDMA_IFCR_CHTIF3_Pos)                /*!< 0x00004000 */
#define BDMA_IFCR_CHTIF3        BDMA_IFCR_CHTIF3_Msk                           /*!< Channel 3 Half Transfer clear */
#define BDMA_IFCR_CTEIF3_Pos    (15U)
#define BDMA_IFCR_CTEIF3_Msk    (0x1UL << BDMA_IFCR_CTEIF3_Pos)                /*!< 0x00008000 */
#define BDMA_IFCR_CTEIF3        BDMA_IFCR_CTEIF3_Msk                           /*!< Channel 3 Transfer Error clear */
#define BDMA_IFCR_CGIF4_Pos     (16U)
#define BDMA_IFCR_CGIF4_Msk     (0x1UL << BDMA_IFCR_CGIF4_Pos)                 /*!< 0x00010000 */
#define BDMA_IFCR_CGIF4         BDMA_IFCR_CGIF4_Msk                            /*!< Channel 4 Global interrupt clear */
#define BDMA_IFCR_CTCIF4_Pos    (17U)
#define BDMA_IFCR_CTCIF4_Msk    (0x1UL << BDMA_IFCR_CTCIF4_Pos)                /*!< 0x00020000 */
#define BDMA_IFCR_CTCIF4        BDMA_IFCR_CTCIF4_Msk                           /*!< Channel 4 Transfer Complete clear */
#define BDMA_IFCR_CHTIF4_Pos    (18U)
#define BDMA_IFCR_CHTIF4_Msk    (0x1UL << BDMA_IFCR_CHTIF4_Pos)                /*!< 0x00040000 */
#define BDMA_IFCR_CHTIF4        BDMA_IFCR_CHTIF4_Msk                           /*!< Channel 4 Half Transfer clear */
#define BDMA_IFCR_CTEIF4_Pos    (19U)
#define BDMA_IFCR_CTEIF4_Msk    (0x1UL << BDMA_IFCR_CTEIF4_Pos)                /*!< 0x00080000 */
#define BDMA_IFCR_CTEIF4        BDMA_IFCR_CTEIF4_Msk                           /*!< Channel 4 Transfer Error clear */
#define BDMA_IFCR_CGIF5_Pos     (20U)
#define BDMA_IFCR_CGIF5_Msk     (0x1UL << BDMA_IFCR_CGIF5_Pos)                 /*!< 0x00100000 */
#define BDMA_IFCR_CGIF5         BDMA_IFCR_CGIF5_Msk                            /*!< Channel 5 Global interrupt clear */
#define BDMA_IFCR_CTCIF5_Pos    (21U)
#define BDMA_IFCR_CTCIF5_Msk    (0x1UL << BDMA_IFCR_CTCIF5_Pos)                /*!< 0x00200000 */
#define BDMA_IFCR_CTCIF5        BDMA_IFCR_CTCIF5_Msk                           /*!< Channel 5 Transfer Complete clear */
#define BDMA_IFCR_CHTIF5_Pos    (22U)
#define BDMA_IFCR_CHTIF5_Msk    (0x1UL << BDMA_IFCR_CHTIF5_Pos)                /*!< 0x00400000 */
#define BDMA_IFCR_CHTIF5        BDMA_IFCR_CHTIF5_Msk                           /*!< Channel 5 Half Transfer clear */
#define BDMA_IFCR_CTEIF5_Pos    (23U)
#define BDMA_IFCR_CTEIF5_Msk    (0x1UL << BDMA_IFCR_CTEIF5_Pos)                /*!< 0x00800000 */
#define BDMA_IFCR_CTEIF5        BDMA_IFCR_CTEIF5_Msk                           /*!< Channel 5 Transfer Error clear */
#define BDMA_IFCR_CGIF6_Pos     (24U)
#define BDMA_IFCR_CGIF6_Msk     (0x1UL << BDMA_IFCR_CGIF6_Pos)                 /*!< 0x01000000 */
#define BDMA_IFCR_CGIF6         BDMA_IFCR_CGIF6_Msk                            /*!< Channel 6 Global interrupt clear */
#define BDMA_IFCR_CTCIF6_Pos    (25U)
#define BDMA_IFCR_CTCIF6_Msk    (0x1UL << BDMA_IFCR_CTCIF6_Pos)                /*!< 0x02000000 */
#define BDMA_IFCR_CTCIF6        BDMA_IFCR_CTCIF6_Msk                           /*!< Channel 6 Transfer Complete clear */
#define BDMA_IFCR_CHTIF6_Pos    (26U)
#define BDMA_IFCR_CHTIF6_Msk    (0x1UL << BDMA_IFCR_CHTIF6_Pos)                /*!< 0x04000000 */
#define BDMA_IFCR_CHTIF6        BDMA_IFCR_CHTIF6_Msk                           /*!< Channel 6 Half Transfer clear */
#define BDMA_IFCR_CTEIF6_Pos    (27U)
#define BDMA_IFCR_CTEIF6_Msk    (0x1UL << BDMA_IFCR_CTEIF6_Pos)                /*!< 0x08000000 */
#define BDMA_IFCR_CTEIF6        BDMA_IFCR_CTEIF6_Msk                           /*!< Channel 6 Transfer Error clear */
#define BDMA_IFCR_CGIF7_Pos     (28U)
#define BDMA_IFCR_CGIF7_Msk     (0x1UL << BDMA_IFCR_CGIF7_Pos)                 /*!< 0x10000000 */
#define BDMA_IFCR_CGIF7         BDMA_IFCR_CGIF7_Msk                            /*!< Channel 7 Global interrupt clear */
#define BDMA_IFCR_CTCIF7_Pos    (29U)
#define BDMA_IFCR_CTCIF7_Msk    (0x1UL << BDMA_IFCR_CTCIF7_Pos)                /*!< 0x20000000 */
#define BDMA_IFCR_CTCIF7        BDMA_IFCR_CTCIF7_Msk                           /*!< Channel 7 Transfer Complete clear */
#define BDMA_IFCR_CHTIF7_Pos    (30U)
#define BDMA_IFCR_CHTIF7_Msk    (0x1UL << BDMA_IFCR_CHTIF7_Pos)                /*!< 0x40000000 */
#define BDMA_IFCR_CHTIF7        BDMA_IFCR_CHTIF7_Msk                           /*!< Channel 7 Half Transfer clear */
#define BDMA_IFCR_CTEIF7_Pos    (31U)
#define BDMA_IFCR_CTEIF7_Msk    (0x1UL << BDMA_IFCR_CTEIF7_Pos)                /*!< 0x80000000 */
#define BDMA_IFCR_CTEIF7        BDMA_IFCR_CTEIF7_Msk                           /*!< Channel 7 Transfer Error clear */

/*******************  Bit definition for BDMA_CCR register  ********************/
#define BDMA_CCR_EN_Pos         (0U)
#define BDMA_CCR_EN_Msk         (0x1UL << BDMA_CCR_EN_Pos)                     /*!< 0x00000001 */
#define BDMA_CCR_EN             BDMA_CCR_EN_Msk                                /*!< Channel enable                      */
#define BDMA_CCR_TCIE_Pos       (1U)
#define BDMA_CCR_TCIE_Msk       (0x1UL << BDMA_CCR_TCIE_Pos)                   /*!< 0x00000002 */
#define BDMA_CCR_TCIE           BDMA_CCR_TCIE_Msk                              /*!< Transfer complete interrupt enable  */
#define BDMA_CCR_HTIE_Pos       (2U)
#define BDMA_CCR_HTIE_Msk       (0x1UL << BDMA_CCR_HTIE_Pos)                   /*!< 0x00000004 */
#define BDMA_CCR_HTIE           BDMA_CCR_HTIE_Msk                              /*!< Half Transfer interrupt enable      */
#define BDMA_CCR_TEIE_Pos       (3U)
#define BDMA_CCR_TEIE_Msk       (0x1UL << BDMA_CCR_TEIE_Pos)                   /*!< 0x00000008 */
#define BDMA_CCR_TEIE           BDMA_CCR_TEIE_Msk                              /*!< Transfer error interrupt enable     */
#define BDMA_CCR_DIR_Pos        (4U)
#define BDMA_CCR_DIR_Msk        (0x1UL << BDMA_CCR_DIR_Pos)                    /*!< 0x00000010 */
#define BDMA_CCR_DIR            BDMA_CCR_DIR_Msk                               /*!< Data transfer direction             */
#define BDMA_CCR_CIRC_Pos       (5U)
#define BDMA_CCR_CIRC_Msk       (0x1UL << BDMA_CCR_CIRC_Pos)                   /*!< 0x00000020 */
#define BDMA_CCR_CIRC           BDMA_CCR_CIRC_Msk                              /*!< Circular mode                       */
#define BDMA_CCR_PINC_Pos       (6U)
#define BDMA_CCR_PINC_Msk       (0x1UL << BDMA_CCR_PINC_Pos)                   /*!< 0x00000040 */
#define BDMA_CCR_PINC           BDMA_CCR_PINC_Msk                              /*!< Peripheral increment mode           */
#define BDMA_CCR_MINC_Pos       (7U)
#define BDMA_CCR_MINC_Msk       (0x1UL << BDMA_CCR_MINC_Pos)                   /*!< 0x00000080 */
#define BDMA_CCR_MINC           BDMA_CCR_MINC_Msk                              /*!< Memory increment mode               */

#define BDMA_CCR_PSIZE_Pos      (8U)
#define BDMA_CCR_PSIZE_Msk      (0x3UL << BDMA_CCR_PSIZE_Pos)                  /*!< 0x00000300 */
#define BDMA_CCR_PSIZE          BDMA_CCR_PSIZE_Msk                             /*!< PSIZE[1:0] bits (Peripheral size)   */
#define BDMA_CCR_PSIZE_0        (0x1UL << BDMA_CCR_PSIZE_Pos)                   /*!< 0x00000100 */
#define BDMA_CCR_PSIZE_1        (0x2UL << BDMA_CCR_PSIZE_Pos)                   /*!< 0x00000200 */

#define BDMA_CCR_MSIZE_Pos      (10U)
#define BDMA_CCR_MSIZE_Msk      (0x3UL << BDMA_CCR_MSIZE_Pos)                  /*!< 0x00000C00 */
#define BDMA_CCR_MSIZE          BDMA_CCR_MSIZE_Msk                             /*!< MSIZE[1:0] bits (Memory size)       */
#define BDMA_CCR_MSIZE_0        (0x1UL << BDMA_CCR_MSIZE_Pos)                   /*!< 0x00000400 */
#define BDMA_CCR_MSIZE_1        (0x2UL << BDMA_CCR_MSIZE_Pos)                   /*!< 0x00000800 */

#define BDMA_CCR_PL_Pos         (12U)
#define BDMA_CCR_PL_Msk         (0x3UL << BDMA_CCR_PL_Pos)                     /*!< 0x00003000 */
#define BDMA_CCR_PL             BDMA_CCR_PL_Msk                                /*!< PL[1:0] bits(Channel Priority level)*/
#define BDMA_CCR_PL_0           (0x1UL << BDMA_CCR_PL_Pos)                      /*!< 0x00001000 */
#define BDMA_CCR_PL_1           (0x2UL << BDMA_CCR_PL_Pos)                      /*!< 0x00002000 */

#define BDMA_CCR_MEM2MEM_Pos    (14U)
#define BDMA_CCR_MEM2MEM_Msk    (0x1UL << BDMA_CCR_MEM2MEM_Pos)                /*!< 0x00004000 */
#define BDMA_CCR_MEM2MEM        BDMA_CCR_MEM2MEM_Msk                           /*!< Memory to memory mode               */
#define BDMA_CCR_DBM_Pos        (15U)
#define BDMA_CCR_DBM_Msk        (0x1UL << BDMA_CCR_DBM_Pos)                    /*!< 0x0000A000 */
#define BDMA_CCR_DBM            BDMA_CCR_DBM_Msk                               /*!< Memory to memory mode               */
#define BDMA_CCR_CT_Pos         (16U)
#define BDMA_CCR_CT_Msk         (0x1UL << BDMA_CCR_CT_Pos)                     /*!< 0x00010000 */
#define BDMA_CCR_CT             BDMA_CCR_CT_Msk                                /*!< Memory to memory mode               */

/******************  Bit definition for BDMA_CNDTR register  *******************/
#define BDMA_CNDTR_NDT_Pos      (0U)
#define BDMA_CNDTR_NDT_Msk      (0xFFFFUL << BDMA_CNDTR_NDT_Pos)               /*!< 0x0000FFFF */
#define BDMA_CNDTR_NDT          BDMA_CNDTR_NDT_Msk                             /*!< Number of data to Transfer          */

/******************  Bit definition for BDMA_CPAR register  ********************/
#define BDMA_CPAR_PA_Pos        (0U)
#define BDMA_CPAR_PA_Msk        (0xFFFFFFFFUL << BDMA_CPAR_PA_Pos)             /*!< 0xFFFFFFFF */
#define BDMA_CPAR_PA            BDMA_CPAR_PA_Msk                               /*!< Peripheral Address                  */

/******************  Bit definition for BDMA_CM0AR register  ********************/
#define BDMA_CM0AR_MA_Pos        (0U)
#define BDMA_CM0AR_MA_Msk        (0xFFFFFFFFUL << BDMA_CM0AR_MA_Pos)             /*!< 0xFFFFFFFF */
#define BDMA_CM0AR_MA            BDMA_CM0AR_MA_Msk                               /*!< Memory Address                      */

/******************  Bit definition for BDMA_CM1AR register  ********************/
#define BDMA_CM1AR_MA_Pos        (0U)
#define BDMA_CM1AR_MA_Msk        (0xFFFFFFFFUL << BDMA_CM1AR_MA_Pos)             /*!< 0xFFFFFFFF */
#define BDMA_CM1AR_MA            BDMA_CM1AR_MA_Msk                               /*!< Memory Address                      */

/******************************************************************************/
/*                                                                            */
/*                Ethernet MAC Registers bits definitions                     */
/*                                                                            */
/******************************************************************************/
/* Bit definition for Ethernet MAC Configuration Register register */
#define ETH_MACCR_ARP_Pos                             (31U)
#define ETH_MACCR_ARP_Msk                             (0x1UL << ETH_MACCR_ARP_Pos) /*!< 0x80000000 */
#define ETH_MACCR_ARP                                 ETH_MACCR_ARP_Msk        /* ARP Offload Enable */
#define ETH_MACCR_SARC_Pos                            (28U)
#define ETH_MACCR_SARC_Msk                            (0x7UL << ETH_MACCR_SARC_Pos) /*!< 0x70000000 */
#define ETH_MACCR_SARC                                ETH_MACCR_SARC_Msk       /* Source Address Insertion or Replacement Control */
#define ETH_MACCR_SARC_MTIATI                         ((uint32_t)0x00000000)   /* The mti_sa_ctrl_i and ati_sa_ctrl_i input signals control the SA field generation. */
#define ETH_MACCR_SARC_INSADDR0_Pos                   (29U)
#define ETH_MACCR_SARC_INSADDR0_Msk                   (0x1UL << ETH_MACCR_SARC_INSADDR0_Pos) /*!< 0x20000000 */
#define ETH_MACCR_SARC_INSADDR0                       ETH_MACCR_SARC_INSADDR0_Msk /* Insert MAC Address0 in the SA field of all transmitted packets. */
#define ETH_MACCR_SARC_INSADDR1_Pos                   (29U)
#define ETH_MACCR_SARC_INSADDR1_Msk                   (0x3UL << ETH_MACCR_SARC_INSADDR1_Pos) /*!< 0x60000000 */
#define ETH_MACCR_SARC_INSADDR1                       ETH_MACCR_SARC_INSADDR1_Msk /* Insert MAC Address1 in the SA field of all transmitted packets. */
#define ETH_MACCR_SARC_REPADDR0_Pos                   (28U)
#define ETH_MACCR_SARC_REPADDR0_Msk                   (0x3UL << ETH_MACCR_SARC_REPADDR0_Pos) /*!< 0x30000000 */
#define ETH_MACCR_SARC_REPADDR0                       ETH_MACCR_SARC_REPADDR0_Msk /* Replace MAC Address0 in the SA field of all transmitted packets. */
#define ETH_MACCR_SARC_REPADDR1_Pos                   (28U)
#define ETH_MACCR_SARC_REPADDR1_Msk                   (0x7UL << ETH_MACCR_SARC_REPADDR1_Pos) /*!< 0x70000000 */
#define ETH_MACCR_SARC_REPADDR1                       ETH_MACCR_SARC_REPADDR1_Msk /* Replace MAC Address1 in the SA field of all transmitted packets. */
#define ETH_MACCR_IPC_Pos                             (27U)
#define ETH_MACCR_IPC_Msk                             (0x1UL << ETH_MACCR_IPC_Pos) /*!< 0x08000000 */
#define ETH_MACCR_IPC                                 ETH_MACCR_IPC_Msk        /* Checksum Offload */
#define ETH_MACCR_IPG_Pos                             (24U)
#define ETH_MACCR_IPG_Msk                             (0x7UL << ETH_MACCR_IPG_Pos) /*!< 0x07000000 */
#define ETH_MACCR_IPG                                 ETH_MACCR_IPG_Msk        /* Inter-Packet Gap */
#define ETH_MACCR_IPG_96BIT                           ((uint32_t)0x00000000)   /* Minimum IFG between Packets during transmission is 96Bit */
#define ETH_MACCR_IPG_88BIT                           ((uint32_t)0x01000000)   /* Minimum IFG between Packets during transmission is 88Bit */
#define ETH_MACCR_IPG_80BIT                           ((uint32_t)0x02000000)   /* Minimum IFG between Packets during transmission is 80Bit */
#define ETH_MACCR_IPG_72BIT                           ((uint32_t)0x03000000)   /* Minimum IFG between Packets during transmission is 72Bit */
#define ETH_MACCR_IPG_64BIT                           ((uint32_t)0x04000000)   /* Minimum IFG between Packets during transmission is 64Bit */
#define ETH_MACCR_IPG_56BIT                           ((uint32_t)0x05000000)   /* Minimum IFG between Packets during transmission is 56Bit */
#define ETH_MACCR_IPG_48BIT                           ((uint32_t)0x06000000)   /* Minimum IFG between Packets during transmission is 48Bit */
#define ETH_MACCR_IPG_40BIT                           ((uint32_t)0x07000000)   /* Minimum IFG between Packets during transmission is 40Bit */
#define ETH_MACCR_GPSLCE_Pos                          (23U)
#define ETH_MACCR_GPSLCE_Msk                          (0x1UL << ETH_MACCR_GPSLCE_Pos) /*!< 0x00800000 */
#define ETH_MACCR_GPSLCE                              ETH_MACCR_GPSLCE_Msk     /* Giant Packet Size Limit Control Enable */
#define ETH_MACCR_S2KP_Pos                            (22U)
#define ETH_MACCR_S2KP_Msk                            (0x1UL << ETH_MACCR_S2KP_Pos) /*!< 0x00400000 */
#define ETH_MACCR_S2KP                                ETH_MACCR_S2KP_Msk       /* IEEE 802.3as Support for 2K Packets */
#define ETH_MACCR_CST_Pos                             (21U)
#define ETH_MACCR_CST_Msk                             (0x1UL << ETH_MACCR_CST_Pos) /*!< 0x00200000 */
#define ETH_MACCR_CST                                 ETH_MACCR_CST_Msk        /* CRC stripping for Type packets */
#define ETH_MACCR_ACS_Pos                             (20U)
#define ETH_MACCR_ACS_Msk                             (0x1UL << ETH_MACCR_ACS_Pos) /*!< 0x00100000 */
#define ETH_MACCR_ACS                                 ETH_MACCR_ACS_Msk        /* Automatic Pad or CRC Stripping */
#define ETH_MACCR_WD_Pos                              (19U)
#define ETH_MACCR_WD_Msk                              (0x1UL << ETH_MACCR_WD_Pos) /*!< 0x00080000 */
#define ETH_MACCR_WD                                  ETH_MACCR_WD_Msk         /* Watchdog disable */
#define ETH_MACCR_JD_Pos                              (17U)
#define ETH_MACCR_JD_Msk                              (0x1UL << ETH_MACCR_JD_Pos) /*!< 0x00020000 */
#define ETH_MACCR_JD                                  ETH_MACCR_JD_Msk         /* Jabber disable */
#define ETH_MACCR_JE_Pos                              (16U)
#define ETH_MACCR_JE_Msk                              (0x1UL << ETH_MACCR_JE_Pos) /*!< 0x00010000 */
#define ETH_MACCR_JE                                  ETH_MACCR_JE_Msk         /* Jumbo Packet Enable */
#define ETH_MACCR_FES_Pos                             (14U)
#define ETH_MACCR_FES_Msk                             (0x1UL << ETH_MACCR_FES_Pos) /*!< 0x00004000 */
#define ETH_MACCR_FES                                 ETH_MACCR_FES_Msk        /* Fast ethernet speed */
#define ETH_MACCR_DM_Pos                              (13U)
#define ETH_MACCR_DM_Msk                              (0x1UL << ETH_MACCR_DM_Pos) /*!< 0x00002000 */
#define ETH_MACCR_DM                                  ETH_MACCR_DM_Msk         /* Duplex mode */
#define ETH_MACCR_LM_Pos                              (12U)
#define ETH_MACCR_LM_Msk                              (0x1UL << ETH_MACCR_LM_Pos) /*!< 0x00001000 */
#define ETH_MACCR_LM                                  ETH_MACCR_LM_Msk         /* loopback mode */
#define ETH_MACCR_ECRSFD_Pos                          (11U)
#define ETH_MACCR_ECRSFD_Msk                          (0x1UL << ETH_MACCR_ECRSFD_Pos) /*!< 0x00000800 */
#define ETH_MACCR_ECRSFD                              ETH_MACCR_ECRSFD_Msk     /* Enable Carrier Sense Before Transmission in Full-Duplex Mode */
#define ETH_MACCR_DO_Pos                              (10U)
#define ETH_MACCR_DO_Msk                              (0x1UL << ETH_MACCR_DO_Pos) /*!< 0x00000400 */
#define ETH_MACCR_DO                                  ETH_MACCR_DO_Msk         /* Disable Receive own  */
#define ETH_MACCR_DCRS_Pos                            (9U)
#define ETH_MACCR_DCRS_Msk                            (0x1UL << ETH_MACCR_DCRS_Pos) /*!< 0x00000200 */
#define ETH_MACCR_DCRS                                ETH_MACCR_DCRS_Msk       /* Disable Carrier Sense During Transmission */
#define ETH_MACCR_DR_Pos                              (8U)
#define ETH_MACCR_DR_Msk                              (0x1UL << ETH_MACCR_DR_Pos) /*!< 0x00000100 */
#define ETH_MACCR_DR                                  ETH_MACCR_DR_Msk         /* Disable Retry */
#define ETH_MACCR_BL_Pos                              (5U)
#define ETH_MACCR_BL_Msk                              (0x3UL << ETH_MACCR_BL_Pos) /*!< 0x00000060 */
#define ETH_MACCR_BL                                  ETH_MACCR_BL_Msk         /* Back-off limit mask */
#define ETH_MACCR_BL_10                               (0x0UL << ETH_MACCR_BL_Pos) /*!< 0x00000000 */
#define ETH_MACCR_BL_8                                (0x1UL << ETH_MACCR_BL_Pos) /*!< 0x00000020 */
#define ETH_MACCR_BL_4                                (0x2UL << ETH_MACCR_BL_Pos) /*!< 0x00000040 */
#define ETH_MACCR_BL_1                                (0x3UL << ETH_MACCR_BL_Pos) /*!< 0x00000060 */
#define ETH_MACCR_DC_Pos                              (4U)
#define ETH_MACCR_DC_Msk                              (0x1UL << ETH_MACCR_DC_Pos) /*!< 0x00000010 */
#define ETH_MACCR_DC                                  ETH_MACCR_DC_Msk         /* Defferal check */
#define ETH_MACCR_PRELEN_Pos                          (2U)
#define ETH_MACCR_PRELEN_Msk                          (0x3UL << ETH_MACCR_PRELEN_Pos) /*!< 0x0000000C */
#define ETH_MACCR_PRELEN                              ETH_MACCR_PRELEN_Msk     /* Preamble Length for Transmit packets */
#define ETH_MACCR_PRELEN_7                            (0x0UL << ETH_MACCR_PRELEN_Pos) /*!< 0x00000000 */
#define ETH_MACCR_PRELEN_5                            (0x1UL << ETH_MACCR_PRELEN_Pos) /*!< 0x00000004 */
#define ETH_MACCR_PRELEN_3                            (0x2UL << ETH_MACCR_PRELEN_Pos) /*!< 0x00000008 */
#define ETH_MACCR_TE_Pos                              (1U)
#define ETH_MACCR_TE_Msk                              (0x1UL << ETH_MACCR_TE_Pos) /*!< 0x00000002 */
#define ETH_MACCR_TE                                  ETH_MACCR_TE_Msk         /* Transmitter enable */
#define ETH_MACCR_RE_Pos                              (0U)
#define ETH_MACCR_RE_Msk                              (0x1UL << ETH_MACCR_RE_Pos) /*!< 0x00000001 */
#define ETH_MACCR_RE                                  ETH_MACCR_RE_Msk         /* Receiver enable */

/* Bit definition for Ethernet MAC Extended Configuration Register register */
#define ETH_MACECR_EIPG_Pos                           (25U)
#define ETH_MACECR_EIPG_Msk                           (0x1FUL << ETH_MACECR_EIPG_Pos) /*!< 0x3E000000 */
#define ETH_MACECR_EIPG                               ETH_MACECR_EIPG_Msk      /* Extended Inter-Packet Gap */
#define ETH_MACECR_EIPGEN_Pos                         (24U)
#define ETH_MACECR_EIPGEN_Msk                         (0x1UL << ETH_MACECR_EIPGEN_Pos) /*!< 0x01000000 */
#define ETH_MACECR_EIPGEN                             ETH_MACECR_EIPGEN_Msk    /* Extended Inter-Packet Gap Enable */
#define ETH_MACECR_USP_Pos                            (18U)
#define ETH_MACECR_USP_Msk                            (0x1UL << ETH_MACECR_USP_Pos) /*!< 0x00040000 */
#define ETH_MACECR_USP                                ETH_MACECR_USP_Msk       /* Unicast Slow Protocol Packet Detect */
#define ETH_MACECR_SPEN_Pos                           (17U)
#define ETH_MACECR_SPEN_Msk                           (0x1UL << ETH_MACECR_SPEN_Pos) /*!< 0x00020000 */
#define ETH_MACECR_SPEN                               ETH_MACECR_SPEN_Msk      /* Slow Protocol Detection Enable */
#define ETH_MACECR_DCRCC_Pos                          (16U)
#define ETH_MACECR_DCRCC_Msk                          (0x1UL << ETH_MACECR_DCRCC_Pos) /*!< 0x00010000 */
#define ETH_MACECR_DCRCC                              ETH_MACECR_DCRCC_Msk     /* Disable CRC Checking for Received Packets */
#define ETH_MACECR_GPSL_Pos                           (0U)
#define ETH_MACECR_GPSL_Msk                           (0x3FFFUL << ETH_MACECR_GPSL_Pos) /*!< 0x00003FFF */
#define ETH_MACECR_GPSL                               ETH_MACECR_GPSL_Msk      /* Giant Packet Size Limit */

/* Bit definition for Ethernet MAC Packet Filter Register */
#define ETH_MACPFR_RA_Pos                             (31U)
#define ETH_MACPFR_RA_Msk                             (0x1UL << ETH_MACPFR_RA_Pos) /*!< 0x80000000 */
#define ETH_MACPFR_RA                                 ETH_MACPFR_RA_Msk        /* Receive all */
#define ETH_MACPFR_DNTU_Pos                           (21U)
#define ETH_MACPFR_DNTU_Msk                           (0x1UL << ETH_MACPFR_DNTU_Pos) /*!< 0x00200000 */
#define ETH_MACPFR_DNTU                               ETH_MACPFR_DNTU_Msk      /* Drop Non-TCP/UDP over IP Packets */
#define ETH_MACPFR_IPFE_Pos                           (20U)
#define ETH_MACPFR_IPFE_Msk                           (0x1UL << ETH_MACPFR_IPFE_Pos) /*!< 0x00100000 */
#define ETH_MACPFR_IPFE                               ETH_MACPFR_IPFE_Msk      /* Layer 3 and Layer 4 Filter Enable */
#define ETH_MACPFR_VTFE_Pos                           (16U)
#define ETH_MACPFR_VTFE_Msk                           (0x1UL << ETH_MACPFR_VTFE_Pos) /*!< 0x00010000 */
#define ETH_MACPFR_VTFE                               ETH_MACPFR_VTFE_Msk      /* VLAN Tag Filter Enable */
#define ETH_MACPFR_HPF_Pos                            (10U)
#define ETH_MACPFR_HPF_Msk                            (0x1UL << ETH_MACPFR_HPF_Pos) /*!< 0x00000400 */
#define ETH_MACPFR_HPF                                ETH_MACPFR_HPF_Msk       /* Hash or perfect filter */
#define ETH_MACPFR_SAF_Pos                            (9U)
#define ETH_MACPFR_SAF_Msk                            (0x1UL << ETH_MACPFR_SAF_Pos) /*!< 0x00000200 */
#define ETH_MACPFR_SAF                                ETH_MACPFR_SAF_Msk       /* Source address filter enable */
#define ETH_MACPFR_SAIF_Pos                           (8U)
#define ETH_MACPFR_SAIF_Msk                           (0x1UL << ETH_MACPFR_SAIF_Pos) /*!< 0x00000100 */
#define ETH_MACPFR_SAIF                               ETH_MACPFR_SAIF_Msk      /* SA inverse filtering */
#define ETH_MACPFR_PCF_Pos                            (6U)
#define ETH_MACPFR_PCF_Msk                            (0x3UL << ETH_MACPFR_PCF_Pos) /*!< 0x000000C0 */
#define ETH_MACPFR_PCF                                ETH_MACPFR_PCF_Msk       /* Pass control frames: 4 cases */
#define ETH_MACPFR_PCF_BLOCKALL                       ((uint32_t)0x00000000)   /* MAC filters all control frames from reaching the application */
#define ETH_MACPFR_PCF_FORWARDALLEXCEPTPA_Pos         (6U)
#define ETH_MACPFR_PCF_FORWARDALLEXCEPTPA_Msk         (0x1UL << ETH_MACPFR_PCF_FORWARDALLEXCEPTPA_Pos) /*!< 0x00000040 */
#define ETH_MACPFR_PCF_FORWARDALLEXCEPTPA             ETH_MACPFR_PCF_FORWARDALLEXCEPTPA_Msk /* MAC forwards all control frames except Pause packets to application even if they fail the Address Filter */
#define ETH_MACPFR_PCF_FORWARDALL_Pos                 (7U)
#define ETH_MACPFR_PCF_FORWARDALL_Msk                 (0x1UL << ETH_MACPFR_PCF_FORWARDALL_Pos) /*!< 0x00000080 */
#define ETH_MACPFR_PCF_FORWARDALL                     ETH_MACPFR_PCF_FORWARDALL_Msk /* MAC forwards all control frames to application even if they fail the Address Filter */
#define ETH_MACPFR_PCF_FORWARDPASSEDADDRFILTER_Pos    (6U)
#define ETH_MACPFR_PCF_FORWARDPASSEDADDRFILTER_Msk    (0x3UL << ETH_MACPFR_PCF_FORWARDPASSEDADDRFILTER_Pos) /*!< 0x000000C0 */
#define ETH_MACPFR_PCF_FORWARDPASSEDADDRFILTER        ETH_MACPFR_PCF_FORWARDPASSEDADDRFILTER_Msk /* MAC forwards control frames that pass the Address Filter. */
#define ETH_MACPFR_DBF_Pos                            (5U)
#define ETH_MACPFR_DBF_Msk                            (0x1UL << ETH_MACPFR_DBF_Pos) /*!< 0x00000020 */
#define ETH_MACPFR_DBF                                ETH_MACPFR_DBF_Msk       /* Disable Broadcast Packets */
#define ETH_MACPFR_PM_Pos                             (4U)
#define ETH_MACPFR_PM_Msk                             (0x1UL << ETH_MACPFR_PM_Pos) /*!< 0x00000010 */
#define ETH_MACPFR_PM                                 ETH_MACPFR_PM_Msk        /* Pass all mutlicast */
#define ETH_MACPFR_DAIF_Pos                           (3U)
#define ETH_MACPFR_DAIF_Msk                           (0x1UL << ETH_MACPFR_DAIF_Pos) /*!< 0x00000008 */
#define ETH_MACPFR_DAIF                               ETH_MACPFR_DAIF_Msk      /* DA Inverse filtering */
#define ETH_MACPFR_HMC_Pos                            (2U)
#define ETH_MACPFR_HMC_Msk                            (0x1UL << ETH_MACPFR_HMC_Pos) /*!< 0x00000004 */
#define ETH_MACPFR_HMC                                ETH_MACPFR_HMC_Msk       /* Hash multicast */
#define ETH_MACPFR_HUC_Pos                            (1U)
#define ETH_MACPFR_HUC_Msk                            (0x1UL << ETH_MACPFR_HUC_Pos) /*!< 0x00000002 */
#define ETH_MACPFR_HUC                                ETH_MACPFR_HUC_Msk       /* Hash unicast */
#define ETH_MACPFR_PR_Pos                             (0U)
#define ETH_MACPFR_PR_Msk                             (0x1UL << ETH_MACPFR_PR_Pos) /*!< 0x00000001 */
#define ETH_MACPFR_PR                                 ETH_MACPFR_PR_Msk        /* Promiscuous mode */

/* Bit definition for Ethernet MAC Watchdog Timeout Register */
#define ETH_MACWTR_PWE_Pos                            (8U)
#define ETH_MACWTR_PWE_Msk                            (0x1UL << ETH_MACWTR_PWE_Pos) /*!< 0x00000100 */
#define ETH_MACWTR_PWE                                ETH_MACWTR_PWE_Msk       /* Programmable Watchdog Enable */
#define ETH_MACWTR_WTO_Pos                            (0U)
#define ETH_MACWTR_WTO_Msk                            (0xFUL << ETH_MACWTR_WTO_Pos) /*!< 0x0000000F */
#define ETH_MACWTR_WTO                                ETH_MACWTR_WTO_Msk       /* Watchdog Timeout */
#define ETH_MACWTR_WTO_2KB                            ((uint32_t)0x00000000)   /* Maximum received packet length 2KB*/
#define ETH_MACWTR_WTO_3KB                            ((uint32_t)0x00000001)   /* Maximum received packet length 3KB */
#define ETH_MACWTR_WTO_4KB                            ((uint32_t)0x00000002)   /* Maximum received packet length 4KB */
#define ETH_MACWTR_WTO_5KB                            ((uint32_t)0x00000003)   /* Maximum received packet length 5KB */
#define ETH_MACWTR_WTO_6KB                            ((uint32_t)0x00000004)   /* Maximum received packet length 6KB */
#define ETH_MACWTR_WTO_7KB                            ((uint32_t)0x00000005)   /* Maximum received packet length 7KB */
#define ETH_MACWTR_WTO_8KB                            ((uint32_t)0x00000006)   /* Maximum received packet length 8KB */
#define ETH_MACWTR_WTO_9KB                            ((uint32_t)0x00000007)   /* Maximum received packet length 9KB */
#define ETH_MACWTR_WTO_10KB                           ((uint32_t)0x00000008)   /* Maximum received packet length 10KB */
#define ETH_MACWTR_WTO_11KB                           ((uint32_t)0x00000009)   /* Maximum received packet length 11KB */
#define ETH_MACWTR_WTO_12KB                           ((uint32_t)0x0000000A)   /* Maximum received packet length 12KB */
#define ETH_MACWTR_WTO_13KB                           ((uint32_t)0x0000000B)   /* Maximum received packet length 13KB */
#define ETH_MACWTR_WTO_14KB                           ((uint32_t)0x0000000C)   /* Maximum received packet length 14KB */
#define ETH_MACWTR_WTO_15KB                           ((uint32_t)0x0000000D)   /* Maximum received packet length 15KB */
#define ETH_MACWTR_WTO_16KB                           ((uint32_t)0x0000000E)   /* Maximum received packet length 16KB */

/* Bit definition for Ethernet MAC Hash Table High Register */
#define ETH_MACHTHR_HTH_Pos                           (0U)
#define ETH_MACHTHR_HTH_Msk                           (0xFFFFFFFFUL << ETH_MACHTHR_HTH_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACHTHR_HTH                               ETH_MACHTHR_HTH_Msk      /* Hash table high */

/* Bit definition for Ethernet MAC Hash Table Low Register */
#define ETH_MACHTLR_HTL_Pos                           (0U)
#define ETH_MACHTLR_HTL_Msk                           (0xFFFFFFFFUL << ETH_MACHTLR_HTL_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACHTLR_HTL                               ETH_MACHTLR_HTL_Msk      /* Hash table low */

/* Bit definition for Ethernet MAC VLAN Tag Register */
#define ETH_MACVTR_EIVLRXS_Pos                        (31U)
#define ETH_MACVTR_EIVLRXS_Msk                        (0x1UL << ETH_MACVTR_EIVLRXS_Pos) /*!< 0x80000000 */
#define ETH_MACVTR_EIVLRXS                            ETH_MACVTR_EIVLRXS_Msk   /* Enable Inner VLAN Tag in Rx Status */
#define ETH_MACVTR_EIVLS_Pos                          (28U)
#define ETH_MACVTR_EIVLS_Msk                          (0x3UL << ETH_MACVTR_EIVLS_Pos) /*!< 0x30000000 */
#define ETH_MACVTR_EIVLS                              ETH_MACVTR_EIVLS_Msk     /* Enable Inner VLAN Tag Stripping on Receive */
#define ETH_MACVTR_EIVLS_DONOTSTRIP                   ((uint32_t)0x00000000)   /* Do not strip */
#define ETH_MACVTR_EIVLS_STRIPIFPASS_Pos              (28U)
#define ETH_MACVTR_EIVLS_STRIPIFPASS_Msk              (0x1UL << ETH_MACVTR_EIVLS_STRIPIFPASS_Pos) /*!< 0x10000000 */
#define ETH_MACVTR_EIVLS_STRIPIFPASS                  ETH_MACVTR_EIVLS_STRIPIFPASS_Msk /* Strip if VLAN filter passes */
#define ETH_MACVTR_EIVLS_STRIPIFFAILS_Pos             (29U)
#define ETH_MACVTR_EIVLS_STRIPIFFAILS_Msk             (0x1UL << ETH_MACVTR_EIVLS_STRIPIFFAILS_Pos) /*!< 0x20000000 */
#define ETH_MACVTR_EIVLS_STRIPIFFAILS                 ETH_MACVTR_EIVLS_STRIPIFFAILS_Msk /* Strip if VLAN filter fails */
#define ETH_MACVTR_EIVLS_ALWAYSSTRIP_Pos              (28U)
#define ETH_MACVTR_EIVLS_ALWAYSSTRIP_Msk              (0x3UL << ETH_MACVTR_EIVLS_ALWAYSSTRIP_Pos) /*!< 0x30000000 */
#define ETH_MACVTR_EIVLS_ALWAYSSTRIP                  ETH_MACVTR_EIVLS_ALWAYSSTRIP_Msk /* Always strip */
#define ETH_MACVTR_ERIVLT_Pos                         (27U)
#define ETH_MACVTR_ERIVLT_Msk                         (0x1UL << ETH_MACVTR_ERIVLT_Pos) /*!< 0x08000000 */
#define ETH_MACVTR_ERIVLT                             ETH_MACVTR_ERIVLT_Msk    /* Enable Inner VLAN Tag */
#define ETH_MACVTR_EDVLP_Pos                          (26U)
#define ETH_MACVTR_EDVLP_Msk                          (0x1UL << ETH_MACVTR_EDVLP_Pos) /*!< 0x04000000 */
#define ETH_MACVTR_EDVLP                              ETH_MACVTR_EDVLP_Msk     /* Enable Double VLAN Processing */
#define ETH_MACVTR_VTHM_Pos                           (25U)
#define ETH_MACVTR_VTHM_Msk                           (0x1UL << ETH_MACVTR_VTHM_Pos) /*!< 0x02000000 */
#define ETH_MACVTR_VTHM                               ETH_MACVTR_VTHM_Msk      /* VLAN Tag Hash Table Match Enable */
#define ETH_MACVTR_EVLRXS_Pos                         (24U)
#define ETH_MACVTR_EVLRXS_Msk                         (0x1UL << ETH_MACVTR_EVLRXS_Pos) /*!< 0x01000000 */
#define ETH_MACVTR_EVLRXS                             ETH_MACVTR_EVLRXS_Msk    /* Enable VLAN Tag in Rx status */
#define ETH_MACVTR_EVLS_Pos                           (21U)
#define ETH_MACVTR_EVLS_Msk                           (0x3UL << ETH_MACVTR_EVLS_Pos) /*!< 0x00600000 */
#define ETH_MACVTR_EVLS                               ETH_MACVTR_EVLS_Msk      /* Enable VLAN Tag Stripping on Receive */
#define ETH_MACVTR_EVLS_DONOTSTRIP                    ((uint32_t)0x00000000)   /* Do not strip */
#define ETH_MACVTR_EVLS_STRIPIFPASS_Pos               (21U)
#define ETH_MACVTR_EVLS_STRIPIFPASS_Msk               (0x1UL << ETH_MACVTR_EVLS_STRIPIFPASS_Pos) /*!< 0x00200000 */
#define ETH_MACVTR_EVLS_STRIPIFPASS                   ETH_MACVTR_EVLS_STRIPIFPASS_Msk /* Strip if VLAN filter passes */
#define ETH_MACVTR_EVLS_STRIPIFFAILS_Pos              (22U)
#define ETH_MACVTR_EVLS_STRIPIFFAILS_Msk              (0x1UL << ETH_MACVTR_EVLS_STRIPIFFAILS_Pos) /*!< 0x00400000 */
#define ETH_MACVTR_EVLS_STRIPIFFAILS                  ETH_MACVTR_EVLS_STRIPIFFAILS_Msk /* Strip if VLAN filter fails */
#define ETH_MACVTR_EVLS_ALWAYSSTRIP_Pos               (21U)
#define ETH_MACVTR_EVLS_ALWAYSSTRIP_Msk               (0x3UL << ETH_MACVTR_EVLS_ALWAYSSTRIP_Pos) /*!< 0x00600000 */
#define ETH_MACVTR_EVLS_ALWAYSSTRIP                   ETH_MACVTR_EVLS_ALWAYSSTRIP_Msk /* Always strip */
#define ETH_MACVTR_DOVLTC_Pos                         (20U)
#define ETH_MACVTR_DOVLTC_Msk                         (0x1UL << ETH_MACVTR_DOVLTC_Pos) /*!< 0x00100000 */
#define ETH_MACVTR_DOVLTC                             ETH_MACVTR_DOVLTC_Msk    /* Disable VLAN Type Check */
#define ETH_MACVTR_ERSVLM_Pos                         (19U)
#define ETH_MACVTR_ERSVLM_Msk                         (0x1UL << ETH_MACVTR_ERSVLM_Pos) /*!< 0x00080000 */
#define ETH_MACVTR_ERSVLM                             ETH_MACVTR_ERSVLM_Msk    /* Enable Receive S-VLAN Match */
#define ETH_MACVTR_ESVL_Pos                           (18U)
#define ETH_MACVTR_ESVL_Msk                           (0x1UL << ETH_MACVTR_ESVL_Pos) /*!< 0x00040000 */
#define ETH_MACVTR_ESVL                               ETH_MACVTR_ESVL_Msk      /* Enable S-VLAN */
#define ETH_MACVTR_VTIM_Pos                           (17U)
#define ETH_MACVTR_VTIM_Msk                           (0x1UL << ETH_MACVTR_VTIM_Pos) /*!< 0x00020000 */
#define ETH_MACVTR_VTIM                               ETH_MACVTR_VTIM_Msk      /* VLAN Tag Inverse Match Enable */
#define ETH_MACVTR_ETV_Pos                            (16U)
#define ETH_MACVTR_ETV_Msk                            (0x1UL << ETH_MACVTR_ETV_Pos) /*!< 0x00010000 */
#define ETH_MACVTR_ETV                                ETH_MACVTR_ETV_Msk       /* Enable 12-Bit VLAN Tag Comparison */
#define ETH_MACVTR_VL_Pos                             (0U)
#define ETH_MACVTR_VL_Msk                             (0xFFFFUL << ETH_MACVTR_VL_Pos) /*!< 0x0000FFFF */
#define ETH_MACVTR_VL                                 ETH_MACVTR_VL_Msk        /* VLAN Tag Identifier for Receive Packets */
#define ETH_MACVTR_VL_UP_Pos                          (13U)
#define ETH_MACVTR_VL_UP_Msk                          (0x7UL << ETH_MACVTR_VL_UP_Pos) /*!< 0x0000E000 */
#define ETH_MACVTR_VL_UP                              ETH_MACVTR_VL_UP_Msk     /* User Priority */
#define ETH_MACVTR_VL_CFIDEI_Pos                      (12U)
#define ETH_MACVTR_VL_CFIDEI_Msk                      (0x1UL << ETH_MACVTR_VL_CFIDEI_Pos) /*!< 0x00001000 */
#define ETH_MACVTR_VL_CFIDEI                          ETH_MACVTR_VL_CFIDEI_Msk /* Canonical Format Indicator or Drop Eligible Indicator */
#define ETH_MACVTR_VL_VID_Pos                         (0U)
#define ETH_MACVTR_VL_VID_Msk                         (0xFFFUL << ETH_MACVTR_VL_VID_Pos) /*!< 0x00000FFF */
#define ETH_MACVTR_VL_VID                             ETH_MACVTR_VL_VID_Msk    /* VLAN Identifier field of VLAN tag */

/* Bit definition for Ethernet MAC VLAN Hash Table Register */
#define ETH_MACVHTR_VLHT_Pos                          (0U)
#define ETH_MACVHTR_VLHT_Msk                          (0xFFFFUL << ETH_MACVHTR_VLHT_Pos) /*!< 0x0000FFFF */
#define ETH_MACVHTR_VLHT                              ETH_MACVHTR_VLHT_Msk     /* VLAN Hash Table */

/* Bit definition for Ethernet MAC VLAN Incl Register */
#define ETH_MACVIR_VLTI_Pos                           (20U)
#define ETH_MACVIR_VLTI_Msk                           (0x1UL << ETH_MACVIR_VLTI_Pos) /*!< 0x00100000 */
#define ETH_MACVIR_VLTI                               ETH_MACVIR_VLTI_Msk      /* VLAN Tag Input */
#define ETH_MACVIR_CSVL_Pos                           (19U)
#define ETH_MACVIR_CSVL_Msk                           (0x1UL << ETH_MACVIR_CSVL_Pos) /*!< 0x00080000 */
#define ETH_MACVIR_CSVL                               ETH_MACVIR_CSVL_Msk      /* C-VLAN or S-VLAN */
#define ETH_MACVIR_VLP_Pos                            (18U)
#define ETH_MACVIR_VLP_Msk                            (0x1UL << ETH_MACVIR_VLP_Pos) /*!< 0x00040000 */
#define ETH_MACVIR_VLP                                ETH_MACVIR_VLP_Msk       /* VLAN Priority Control */
#define ETH_MACVIR_VLC_Pos                            (16U)
#define ETH_MACVIR_VLC_Msk                            (0x3UL << ETH_MACVIR_VLC_Pos) /*!< 0x00030000 */
#define ETH_MACVIR_VLC                                ETH_MACVIR_VLC_Msk       /* VLAN Tag Control in Transmit Packets */
#define ETH_MACVIR_VLC_NOVLANTAG                      ((uint32_t)0x00000000)   /* No VLAN tag deletion, insertion, or replacement */
#define ETH_MACVIR_VLC_VLANTAGDELETE_Pos              (16U)
#define ETH_MACVIR_VLC_VLANTAGDELETE_Msk              (0x1UL << ETH_MACVIR_VLC_VLANTAGDELETE_Pos) /*!< 0x00010000 */
#define ETH_MACVIR_VLC_VLANTAGDELETE                  ETH_MACVIR_VLC_VLANTAGDELETE_Msk /* VLAN tag deletion */
#define ETH_MACVIR_VLC_VLANTAGINSERT_Pos              (17U)
#define ETH_MACVIR_VLC_VLANTAGINSERT_Msk              (0x1UL << ETH_MACVIR_VLC_VLANTAGINSERT_Pos) /*!< 0x00020000 */
#define ETH_MACVIR_VLC_VLANTAGINSERT                  ETH_MACVIR_VLC_VLANTAGINSERT_Msk /* VLAN tag insertion */
#define ETH_MACVIR_VLC_VLANTAGREPLACE_Pos             (16U)
#define ETH_MACVIR_VLC_VLANTAGREPLACE_Msk             (0x3UL << ETH_MACVIR_VLC_VLANTAGREPLACE_Pos) /*!< 0x00030000 */
#define ETH_MACVIR_VLC_VLANTAGREPLACE                 ETH_MACVIR_VLC_VLANTAGREPLACE_Msk /* VLAN tag replacement */
#define ETH_MACVIR_VLT_Pos                            (0U)
#define ETH_MACVIR_VLT_Msk                            (0xFFFFUL << ETH_MACVIR_VLT_Pos) /*!< 0x0000FFFF */
#define ETH_MACVIR_VLT                                ETH_MACVIR_VLT_Msk       /* VLAN Tag for Transmit Packets */
#define ETH_MACVIR_VLT_UP_Pos                         (13U)
#define ETH_MACVIR_VLT_UP_Msk                         (0x7UL << ETH_MACVIR_VLT_UP_Pos) /*!< 0x0000E000 */
#define ETH_MACVIR_VLT_UP                             ETH_MACVIR_VLT_UP_Msk    /* User Priority */
#define ETH_MACVIR_VLT_CFIDEI_Pos                     (12U)
#define ETH_MACVIR_VLT_CFIDEI_Msk                     (0x1UL << ETH_MACVIR_VLT_CFIDEI_Pos) /*!< 0x00001000 */
#define ETH_MACVIR_VLT_CFIDEI                         ETH_MACVIR_VLT_CFIDEI_Msk /* Canonical Format Indicator or Drop Eligible Indicator */
#define ETH_MACVIR_VLT_VID_Pos                        (0U)
#define ETH_MACVIR_VLT_VID_Msk                        (0xFFFUL << ETH_MACVIR_VLT_VID_Pos) /*!< 0x00000FFF */
#define ETH_MACVIR_VLT_VID                            ETH_MACVIR_VLT_VID_Msk   /* VLAN Identifier field of VLAN tag */

/* Bit definition for Ethernet MAC Inner_VLAN Incl Register */
#define ETH_MACIVIR_VLTI_Pos                          (20U)
#define ETH_MACIVIR_VLTI_Msk                          (0x1UL << ETH_MACIVIR_VLTI_Pos) /*!< 0x00100000 */
#define ETH_MACIVIR_VLTI                              ETH_MACIVIR_VLTI_Msk     /* VLAN Tag Input */
#define ETH_MACIVIR_CSVL_Pos                          (19U)
#define ETH_MACIVIR_CSVL_Msk                          (0x1UL << ETH_MACIVIR_CSVL_Pos) /*!< 0x00080000 */
#define ETH_MACIVIR_CSVL                              ETH_MACIVIR_CSVL_Msk     /* C-VLAN or S-VLAN */
#define ETH_MACIVIR_VLP_Pos                           (18U)
#define ETH_MACIVIR_VLP_Msk                           (0x1UL << ETH_MACIVIR_VLP_Pos) /*!< 0x00040000 */
#define ETH_MACIVIR_VLP                               ETH_MACIVIR_VLP_Msk      /* VLAN Priority Control */
#define ETH_MACIVIR_VLC_Pos                           (16U)
#define ETH_MACIVIR_VLC_Msk                           (0x3UL << ETH_MACIVIR_VLC_Pos) /*!< 0x00030000 */
#define ETH_MACIVIR_VLC                               ETH_MACIVIR_VLC_Msk      /* VLAN Tag Control in Transmit Packets */
#define ETH_MACIVIR_VLC_NOVLANTAG                     ((uint32_t)0x00000000)   /* No VLAN tag deletion, insertion, or replacement */
#define ETH_MACIVIR_VLC_VLANTAGDELETE_Pos             (16U)
#define ETH_MACIVIR_VLC_VLANTAGDELETE_Msk             (0x1UL << ETH_MACIVIR_VLC_VLANTAGDELETE_Pos) /*!< 0x00010000 */
#define ETH_MACIVIR_VLC_VLANTAGDELETE                 ETH_MACIVIR_VLC_VLANTAGDELETE_Msk /* VLAN tag deletion */
#define ETH_MACIVIR_VLC_VLANTAGINSERT_Pos             (17U)
#define ETH_MACIVIR_VLC_VLANTAGINSERT_Msk             (0x1UL << ETH_MACIVIR_VLC_VLANTAGINSERT_Pos) /*!< 0x00020000 */
#define ETH_MACIVIR_VLC_VLANTAGINSERT                 ETH_MACIVIR_VLC_VLANTAGINSERT_Msk /* VLAN tag insertion */
#define ETH_MACIVIR_VLC_VLANTAGREPLACE_Pos            (16U)
#define ETH_MACIVIR_VLC_VLANTAGREPLACE_Msk            (0x3UL << ETH_MACIVIR_VLC_VLANTAGREPLACE_Pos) /*!< 0x00030000 */
#define ETH_MACIVIR_VLC_VLANTAGREPLACE                ETH_MACIVIR_VLC_VLANTAGREPLACE_Msk /* VLAN tag replacement */
#define ETH_MACIVIR_VLT_Pos                           (0U)
#define ETH_MACIVIR_VLT_Msk                           (0xFFFFUL << ETH_MACIVIR_VLT_Pos) /*!< 0x0000FFFF */
#define ETH_MACIVIR_VLT                               ETH_MACIVIR_VLT_Msk      /* VLAN Tag for Transmit Packets */
#define ETH_MACIVIR_VLT_UP_Pos                        (13U)
#define ETH_MACIVIR_VLT_UP_Msk                        (0x7UL << ETH_MACIVIR_VLT_UP_Pos) /*!< 0x0000E000 */
#define ETH_MACIVIR_VLT_UP                            ETH_MACIVIR_VLT_UP_Msk   /* User Priority */
#define ETH_MACIVIR_VLT_CFIDEI_Pos                    (12U)
#define ETH_MACIVIR_VLT_CFIDEI_Msk                    (0x1UL << ETH_MACIVIR_VLT_CFIDEI_Pos) /*!< 0x00001000 */
#define ETH_MACIVIR_VLT_CFIDEI                        ETH_MACIVIR_VLT_CFIDEI_Msk /* Canonical Format Indicator or Drop Eligible Indicator */
#define ETH_MACIVIR_VLT_VID_Pos                       (0U)
#define ETH_MACIVIR_VLT_VID_Msk                       (0xFFFUL << ETH_MACIVIR_VLT_VID_Pos) /*!< 0x00000FFF */
#define ETH_MACIVIR_VLT_VID                           ETH_MACIVIR_VLT_VID_Msk  /* VLAN Identifier field of VLAN tag */

/* Bit definition for Ethernet MAC Tx Flow Ctrl Register */
#define ETH_MACTFCR_PT_Pos                            (16U)
#define ETH_MACTFCR_PT_Msk                            (0xFFFFUL << ETH_MACTFCR_PT_Pos) /*!< 0xFFFF0000 */
#define ETH_MACTFCR_PT                                ETH_MACTFCR_PT_Msk       /* Pause Time */
#define ETH_MACTFCR_DZPQ_Pos                          (7U)
#define ETH_MACTFCR_DZPQ_Msk                          (0x1UL << ETH_MACTFCR_DZPQ_Pos) /*!< 0x00000080 */
#define ETH_MACTFCR_DZPQ                              ETH_MACTFCR_DZPQ_Msk     /* Disable Zero-Quanta Pause */
#define ETH_MACTFCR_PLT_Pos                           (4U)
#define ETH_MACTFCR_PLT_Msk                           (0x7UL << ETH_MACTFCR_PLT_Pos) /*!< 0x00000070 */
#define ETH_MACTFCR_PLT                               ETH_MACTFCR_PLT_Msk      /* Pause Low Threshold */
#define ETH_MACTFCR_PLT_MINUS4                        ((uint32_t)0x00000000)   /* Pause time minus 4 slot times */
#define ETH_MACTFCR_PLT_MINUS28_Pos                   (4U)
#define ETH_MACTFCR_PLT_MINUS28_Msk                   (0x1UL << ETH_MACTFCR_PLT_MINUS28_Pos) /*!< 0x00000010 */
#define ETH_MACTFCR_PLT_MINUS28                       ETH_MACTFCR_PLT_MINUS28_Msk /* Pause time minus 28 slot times */
#define ETH_MACTFCR_PLT_MINUS36_Pos                   (5U)
#define ETH_MACTFCR_PLT_MINUS36_Msk                   (0x1UL << ETH_MACTFCR_PLT_MINUS36_Pos) /*!< 0x00000020 */
#define ETH_MACTFCR_PLT_MINUS36                       ETH_MACTFCR_PLT_MINUS36_Msk /* Pause time minus 36 slot times */
#define ETH_MACTFCR_PLT_MINUS144_Pos                  (4U)
#define ETH_MACTFCR_PLT_MINUS144_Msk                  (0x3UL << ETH_MACTFCR_PLT_MINUS144_Pos) /*!< 0x00000030 */
#define ETH_MACTFCR_PLT_MINUS144                      ETH_MACTFCR_PLT_MINUS144_Msk /* Pause time minus 144 slot times */
#define ETH_MACTFCR_PLT_MINUS256_Pos                  (6U)
#define ETH_MACTFCR_PLT_MINUS256_Msk                  (0x1UL << ETH_MACTFCR_PLT_MINUS256_Pos) /*!< 0x00000040 */
#define ETH_MACTFCR_PLT_MINUS256                      ETH_MACTFCR_PLT_MINUS256_Msk /* Pause time minus 256 slot times */
#define ETH_MACTFCR_PLT_MINUS512_Pos                  (4U)
#define ETH_MACTFCR_PLT_MINUS512_Msk                  (0x5UL << ETH_MACTFCR_PLT_MINUS512_Pos) /*!< 0x00000050 */
#define ETH_MACTFCR_PLT_MINUS512                      ETH_MACTFCR_PLT_MINUS512_Msk /* Pause time minus 512 slot times */
#define ETH_MACTFCR_TFE_Pos                           (1U)
#define ETH_MACTFCR_TFE_Msk                           (0x1UL << ETH_MACTFCR_TFE_Pos) /*!< 0x00000002 */
#define ETH_MACTFCR_TFE                               ETH_MACTFCR_TFE_Msk      /* Transmit Flow Control Enable */
#define ETH_MACTFCR_FCB_Pos                           (0U)
#define ETH_MACTFCR_FCB_Msk                           (0x1UL << ETH_MACTFCR_FCB_Pos) /*!< 0x00000001 */
#define ETH_MACTFCR_FCB                               ETH_MACTFCR_FCB_Msk      /* Flow Control Busy or Backpressure Activate */

/* Bit definition for Ethernet MAC Rx Flow Ctrl Register */
#define ETH_MACRFCR_UP_Pos                            (1U)
#define ETH_MACRFCR_UP_Msk                            (0x1UL << ETH_MACRFCR_UP_Pos) /*!< 0x00000002 */
#define ETH_MACRFCR_UP                                ETH_MACRFCR_UP_Msk       /* Unicast Pause Packet Detect */
#define ETH_MACRFCR_RFE_Pos                           (0U)
#define ETH_MACRFCR_RFE_Msk                           (0x1UL << ETH_MACRFCR_RFE_Pos) /*!< 0x00000001 */
#define ETH_MACRFCR_RFE                               ETH_MACRFCR_RFE_Msk      /* Receive Flow Control Enable */

/* Bit definition for Ethernet MAC Interrupt Status Register */
#define ETH_MACISR_RXSTSIS_Pos                        (14U)
#define ETH_MACISR_RXSTSIS_Msk                        (0x1UL << ETH_MACISR_RXSTSIS_Pos) /*!< 0x00004000 */
#define ETH_MACISR_RXSTSIS                            ETH_MACISR_RXSTSIS_Msk   /* Receive Status Interrupt */
#define ETH_MACISR_TXSTSIS_Pos                        (13U)
#define ETH_MACISR_TXSTSIS_Msk                        (0x1UL << ETH_MACISR_TXSTSIS_Pos) /*!< 0x00002000 */
#define ETH_MACISR_TXSTSIS                            ETH_MACISR_TXSTSIS_Msk   /* Transmit Status Interrupt */
#define ETH_MACISR_TSIS_Pos                           (12U)
#define ETH_MACISR_TSIS_Msk                           (0x1UL << ETH_MACISR_TSIS_Pos) /*!< 0x00001000 */
#define ETH_MACISR_TSIS                               ETH_MACISR_TSIS_Msk      /* Timestamp Interrupt Status */
#define ETH_MACISR_MMCTXIS_Pos                        (10U)
#define ETH_MACISR_MMCTXIS_Msk                        (0x1UL << ETH_MACISR_MMCTXIS_Pos) /*!< 0x00000400 */
#define ETH_MACISR_MMCTXIS                            ETH_MACISR_MMCTXIS_Msk   /* MMC Transmit Interrupt Status */
#define ETH_MACISR_MMCRXIS_Pos                        (9U)
#define ETH_MACISR_MMCRXIS_Msk                        (0x1UL << ETH_MACISR_MMCRXIS_Pos) /*!< 0x00000200 */
#define ETH_MACISR_MMCRXIS                            ETH_MACISR_MMCRXIS_Msk   /* MMC Receive Interrupt Status */
#define ETH_MACISR_MMCIS_Pos                          (8U)
#define ETH_MACISR_MMCIS_Msk                          (0x1UL << ETH_MACISR_MMCIS_Pos) /*!< 0x00000100 */
#define ETH_MACISR_MMCIS                              ETH_MACISR_MMCIS_Msk     /* MMC Interrupt Status */
#define ETH_MACISR_LPIIS_Pos                          (5U)
#define ETH_MACISR_LPIIS_Msk                          (0x1UL << ETH_MACISR_LPIIS_Pos) /*!< 0x00000020 */
#define ETH_MACISR_LPIIS                              ETH_MACISR_LPIIS_Msk     /* LPI Interrupt Status */
#define ETH_MACISR_PMTIS_Pos                          (4U)
#define ETH_MACISR_PMTIS_Msk                          (0x1UL << ETH_MACISR_PMTIS_Pos) /*!< 0x00000010 */
#define ETH_MACISR_PMTIS                              ETH_MACISR_PMTIS_Msk     /* PMT Interrupt Status */
#define ETH_MACISR_PHYIS_Pos                          (3U)
#define ETH_MACISR_PHYIS_Msk                          (0x1UL << ETH_MACISR_PHYIS_Pos) /*!< 0x00000008 */
#define ETH_MACISR_PHYIS                              ETH_MACISR_PHYIS_Msk     /* PHY Interrupt */

/* Bit definition for Ethernet MAC Interrupt Enable Register */
#define ETH_MACIER_RXSTSIE_Pos                        (14U)
#define ETH_MACIER_RXSTSIE_Msk                        (0x1UL << ETH_MACIER_RXSTSIE_Pos) /*!< 0x00004000 */
#define ETH_MACIER_RXSTSIE                            ETH_MACIER_RXSTSIE_Msk   /* Receive Status Interrupt Enable */
#define ETH_MACIER_TXSTSIE_Pos                        (13U)
#define ETH_MACIER_TXSTSIE_Msk                        (0x1UL << ETH_MACIER_TXSTSIE_Pos) /*!< 0x00002000 */
#define ETH_MACIER_TXSTSIE                            ETH_MACIER_TXSTSIE_Msk   /* Transmit Status Interrupt Enable */
#define ETH_MACIER_TSIE_Pos                           (12U)
#define ETH_MACIER_TSIE_Msk                           (0x1UL << ETH_MACIER_TSIE_Pos) /*!< 0x00001000 */
#define ETH_MACIER_TSIE                               ETH_MACIER_TSIE_Msk      /* Timestamp Interrupt Enable */
#define ETH_MACIER_LPIIE_Pos                          (5U)
#define ETH_MACIER_LPIIE_Msk                          (0x1UL << ETH_MACIER_LPIIE_Pos) /*!< 0x00000020 */
#define ETH_MACIER_LPIIE                              ETH_MACIER_LPIIE_Msk     /* LPI Interrupt Enable */
#define ETH_MACIER_PMTIE_Pos                          (4U)
#define ETH_MACIER_PMTIE_Msk                          (0x1UL << ETH_MACIER_PMTIE_Pos) /*!< 0x00000010 */
#define ETH_MACIER_PMTIE                              ETH_MACIER_PMTIE_Msk     /* PMT Interrupt Enable */
#define ETH_MACIER_PHYIE_Pos                          (3U)
#define ETH_MACIER_PHYIE_Msk                          (0x1UL << ETH_MACIER_PHYIE_Pos) /*!< 0x00000008 */
#define ETH_MACIER_PHYIE                              ETH_MACIER_PHYIE_Msk     /* PHY Interrupt Enable */

/* Bit definition for Ethernet MAC Rx Tx Status Register */
#define ETH_MACRXTXSR_RWT_Pos                         (8U)
#define ETH_MACRXTXSR_RWT_Msk                         (0x1UL << ETH_MACRXTXSR_RWT_Pos) /*!< 0x00000100 */
#define ETH_MACRXTXSR_RWT                             ETH_MACRXTXSR_RWT_Msk    /* Receive Watchdog Timeout */
#define ETH_MACRXTXSR_EXCOL_Pos                       (5U)
#define ETH_MACRXTXSR_EXCOL_Msk                       (0x1UL << ETH_MACRXTXSR_EXCOL_Pos) /*!< 0x00000020 */
#define ETH_MACRXTXSR_EXCOL                           ETH_MACRXTXSR_EXCOL_Msk  /* Excessive Collisions */
#define ETH_MACRXTXSR_LCOL_Pos                        (4U)
#define ETH_MACRXTXSR_LCOL_Msk                        (0x1UL << ETH_MACRXTXSR_LCOL_Pos) /*!< 0x00000010 */
#define ETH_MACRXTXSR_LCOL                            ETH_MACRXTXSR_LCOL_Msk   /* Late Collision */
#define ETH_MACRXTXSR_EXDEF_Pos                       (3U)
#define ETH_MACRXTXSR_EXDEF_Msk                       (0x1UL << ETH_MACRXTXSR_EXDEF_Pos) /*!< 0x00000008 */
#define ETH_MACRXTXSR_EXDEF                           ETH_MACRXTXSR_EXDEF_Msk  /* Excessive Deferral */
#define ETH_MACRXTXSR_LCARR_Pos                       (2U)
#define ETH_MACRXTXSR_LCARR_Msk                       (0x1UL << ETH_MACRXTXSR_LCARR_Pos) /*!< 0x00000004 */
#define ETH_MACRXTXSR_LCARR                           ETH_MACRXTXSR_LCARR_Msk  /* Loss of Carrier */
#define ETH_MACRXTXSR_NCARR_Pos                       (1U)
#define ETH_MACRXTXSR_NCARR_Msk                       (0x1UL << ETH_MACRXTXSR_NCARR_Pos) /*!< 0x00000002 */
#define ETH_MACRXTXSR_NCARR                           ETH_MACRXTXSR_NCARR_Msk  /* No Carrier */
#define ETH_MACRXTXSR_TJT_Pos                         (0U)
#define ETH_MACRXTXSR_TJT_Msk                         (0x1UL << ETH_MACRXTXSR_TJT_Pos) /*!< 0x00000001 */
#define ETH_MACRXTXSR_TJT                             ETH_MACRXTXSR_TJT_Msk    /* Transmit Jabber Timeout */

/* Bit definition for Ethernet MAC PMT Control Status Register */
#define ETH_MACPCSR_RWKFILTRST_Pos                    (31U)
#define ETH_MACPCSR_RWKFILTRST_Msk                    (0x1UL << ETH_MACPCSR_RWKFILTRST_Pos) /*!< 0x80000000 */
#define ETH_MACPCSR_RWKFILTRST                        ETH_MACPCSR_RWKFILTRST_Msk /* Remote Wake-Up Packet Filter Register Pointer Reset */
#define ETH_MACPCSR_RWKPTR_Pos                        (24U)
#define ETH_MACPCSR_RWKPTR_Msk                        (0x1FUL << ETH_MACPCSR_RWKPTR_Pos) /*!< 0x1F000000 */
#define ETH_MACPCSR_RWKPTR                            ETH_MACPCSR_RWKPTR_Msk   /* Remote Wake-up FIFO Pointer */
#define ETH_MACPCSR_RWKPFE_Pos                        (10U)
#define ETH_MACPCSR_RWKPFE_Msk                        (0x1UL << ETH_MACPCSR_RWKPFE_Pos) /*!< 0x00000400 */
#define ETH_MACPCSR_RWKPFE                            ETH_MACPCSR_RWKPFE_Msk   /* Remote Wake-up Packet Forwarding Enable */
#define ETH_MACPCSR_GLBLUCAST_Pos                     (9U)
#define ETH_MACPCSR_GLBLUCAST_Msk                     (0x1UL << ETH_MACPCSR_GLBLUCAST_Pos) /*!< 0x00000200 */
#define ETH_MACPCSR_GLBLUCAST                         ETH_MACPCSR_GLBLUCAST_Msk /* Global Unicast */
#define ETH_MACPCSR_RWKPRCVD_Pos                      (6U)
#define ETH_MACPCSR_RWKPRCVD_Msk                      (0x1UL << ETH_MACPCSR_RWKPRCVD_Pos) /*!< 0x00000040 */
#define ETH_MACPCSR_RWKPRCVD                          ETH_MACPCSR_RWKPRCVD_Msk /* Remote Wake-Up Packet Received */
#define ETH_MACPCSR_MGKPRCVD_Pos                      (5U)
#define ETH_MACPCSR_MGKPRCVD_Msk                      (0x1UL << ETH_MACPCSR_MGKPRCVD_Pos) /*!< 0x00000020 */
#define ETH_MACPCSR_MGKPRCVD                          ETH_MACPCSR_MGKPRCVD_Msk /* Magic Packet Received */
#define ETH_MACPCSR_RWKPKTEN_Pos                      (2U)
#define ETH_MACPCSR_RWKPKTEN_Msk                      (0x1UL << ETH_MACPCSR_RWKPKTEN_Pos) /*!< 0x00000004 */
#define ETH_MACPCSR_RWKPKTEN                          ETH_MACPCSR_RWKPKTEN_Msk /* Remote Wake-Up Packet Enable */
#define ETH_MACPCSR_MGKPKTEN_Pos                      (1U)
#define ETH_MACPCSR_MGKPKTEN_Msk                      (0x1UL << ETH_MACPCSR_MGKPKTEN_Pos) /*!< 0x00000002 */
#define ETH_MACPCSR_MGKPKTEN                          ETH_MACPCSR_MGKPKTEN_Msk /* Magic Packet Enable */
#define ETH_MACPCSR_PWRDWN_Pos                        (0U)
#define ETH_MACPCSR_PWRDWN_Msk                        (0x1UL << ETH_MACPCSR_PWRDWN_Pos) /*!< 0x00000001 */
#define ETH_MACPCSR_PWRDWN                            ETH_MACPCSR_PWRDWN_Msk   /* Power Down */

/* Bit definition for Ethernet MAC Remote Wake-Up Packet Filter Register */
#define ETH_MACRWUPFR_D_Pos                           (0U)
#define ETH_MACRWUPFR_D_Msk                           (0xFFFFFFFFUL << ETH_MACRWUPFR_D_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACRWUPFR_D                               ETH_MACRWUPFR_D_Msk      /* Wake-up Packet filter register data */

/* Bit definition for Ethernet MAC LPI Control Status Register */
#define ETH_MACLCSR_LPITCSE_Pos                       (21U)
#define ETH_MACLCSR_LPITCSE_Msk                       (0x1UL << ETH_MACLCSR_LPITCSE_Pos) /*!< 0x00200000 */
#define ETH_MACLCSR_LPITCSE                           ETH_MACLCSR_LPITCSE_Msk  /* LPI Tx Clock Stop Enable */
#define ETH_MACLCSR_LPITE_Pos                         (20U)
#define ETH_MACLCSR_LPITE_Msk                         (0x1UL << ETH_MACLCSR_LPITE_Pos) /*!< 0x00100000 */
#define ETH_MACLCSR_LPITE                             ETH_MACLCSR_LPITE_Msk    /* LPI Timer Enable */
#define ETH_MACLCSR_LPITXA_Pos                        (19U)
#define ETH_MACLCSR_LPITXA_Msk                        (0x1UL << ETH_MACLCSR_LPITXA_Pos) /*!< 0x00080000 */
#define ETH_MACLCSR_LPITXA                            ETH_MACLCSR_LPITXA_Msk   /* LPI Tx Automate */
#define ETH_MACLCSR_PLS_Pos                           (17U)
#define ETH_MACLCSR_PLS_Msk                           (0x1UL << ETH_MACLCSR_PLS_Pos) /*!< 0x00020000 */
#define ETH_MACLCSR_PLS                               ETH_MACLCSR_PLS_Msk      /* PHY Link Status */
#define ETH_MACLCSR_LPIEN_Pos                         (16U)
#define ETH_MACLCSR_LPIEN_Msk                         (0x1UL << ETH_MACLCSR_LPIEN_Pos) /*!< 0x00010000 */
#define ETH_MACLCSR_LPIEN                             ETH_MACLCSR_LPIEN_Msk    /* LPI Enable */
#define ETH_MACLCSR_RLPIST_Pos                        (9U)
#define ETH_MACLCSR_RLPIST_Msk                        (0x1UL << ETH_MACLCSR_RLPIST_Pos) /*!< 0x00000200 */
#define ETH_MACLCSR_RLPIST                            ETH_MACLCSR_RLPIST_Msk   /* Receive LPI State */
#define ETH_MACLCSR_TLPIST_Pos                        (8U)
#define ETH_MACLCSR_TLPIST_Msk                        (0x1UL << ETH_MACLCSR_TLPIST_Pos) /*!< 0x00000100 */
#define ETH_MACLCSR_TLPIST                            ETH_MACLCSR_TLPIST_Msk   /* Transmit LPI State */
#define ETH_MACLCSR_RLPIEX_Pos                        (3U)
#define ETH_MACLCSR_RLPIEX_Msk                        (0x1UL << ETH_MACLCSR_RLPIEX_Pos) /*!< 0x00000008 */
#define ETH_MACLCSR_RLPIEX                            ETH_MACLCSR_RLPIEX_Msk   /* Receive LPI Exit */
#define ETH_MACLCSR_RLPIEN_Pos                        (2U)
#define ETH_MACLCSR_RLPIEN_Msk                        (0x1UL << ETH_MACLCSR_RLPIEN_Pos) /*!< 0x00000004 */
#define ETH_MACLCSR_RLPIEN                            ETH_MACLCSR_RLPIEN_Msk   /* Receive LPI Entry */
#define ETH_MACLCSR_TLPIEX_Pos                        (1U)
#define ETH_MACLCSR_TLPIEX_Msk                        (0x1UL << ETH_MACLCSR_TLPIEX_Pos) /*!< 0x00000002 */
#define ETH_MACLCSR_TLPIEX                            ETH_MACLCSR_TLPIEX_Msk   /* Transmit LPI Exit */
#define ETH_MACLCSR_TLPIEN_Pos                        (0U)
#define ETH_MACLCSR_TLPIEN_Msk                        (0x1UL << ETH_MACLCSR_TLPIEN_Pos) /*!< 0x00000001 */
#define ETH_MACLCSR_TLPIEN                            ETH_MACLCSR_TLPIEN_Msk   /* Transmit LPI Entry */

/* Bit definition for Ethernet MAC LPI Timers Control Register */
#define ETH_MACLTCR_LST_Pos                           (16U)
#define ETH_MACLTCR_LST_Msk                           (0x3FFUL << ETH_MACLTCR_LST_Pos) /*!< 0x03FF0000 */
#define ETH_MACLTCR_LST                               ETH_MACLTCR_LST_Msk      /* LPI LS TIMER */
#define ETH_MACLTCR_TWT_Pos                           (0U)
#define ETH_MACLTCR_TWT_Msk                           (0xFFFFUL << ETH_MACLTCR_TWT_Pos) /*!< 0x0000FFFF */
#define ETH_MACLTCR_TWT                               ETH_MACLTCR_TWT_Msk      /* LPI TW TIMER */

/* Bit definition for Ethernet MAC LPI Entry Timer Register */
#define ETH_MACLETR_LPIET_Pos                         (0U)
#define ETH_MACLETR_LPIET_Msk                         (0xFFFFFUL << ETH_MACLETR_LPIET_Pos) /*!< 0x000FFFFF */
#define ETH_MACLETR_LPIET                             ETH_MACLETR_LPIET_Msk    /* LPI Entry Timer */

/* Bit definition for Ethernet MAC 1US Tic Counter Register */
#define ETH_MAC1USTCR_TIC1USCNTR_Pos                  (0U)
#define ETH_MAC1USTCR_TIC1USCNTR_Msk                  (0xFFFUL << ETH_MAC1USTCR_TIC1USCNTR_Pos) /*!< 0x00000FFF */
#define ETH_MAC1USTCR_TIC1USCNTR                      ETH_MAC1USTCR_TIC1USCNTR_Msk /* 1US TIC Counter */

/* Bit definition for Ethernet MAC Version Register */
#define ETH_MACVR_USERVER_Pos                         (8U)
#define ETH_MACVR_USERVER_Msk                         (0xFFUL << ETH_MACVR_USERVER_Pos) /*!< 0x0000FF00 */
#define ETH_MACVR_USERVER                             ETH_MACVR_USERVER_Msk    /* User-defined Version */
#define ETH_MACVR_SNPSVER_Pos                         (0U)
#define ETH_MACVR_SNPSVER_Msk                         (0xFFUL << ETH_MACVR_SNPSVER_Pos) /*!< 0x000000FF */
#define ETH_MACVR_SNPSVER                             ETH_MACVR_SNPSVER_Msk    /* Synopsys-defined Version */

/* Bit definition for Ethernet MAC Debug Register */
#define ETH_MACDR_TFCSTS_Pos                          (17U)
#define ETH_MACDR_TFCSTS_Msk                          (0x3UL << ETH_MACDR_TFCSTS_Pos) /*!< 0x00060000 */
#define ETH_MACDR_TFCSTS                              ETH_MACDR_TFCSTS_Msk     /* MAC Transmit Packet Controller Status */
#define ETH_MACDR_TFCSTS_IDLE                         ((uint32_t)0x00000000)   /* Idle state */
#define ETH_MACDR_TFCSTS_WAIT_Pos                     (17U)
#define ETH_MACDR_TFCSTS_WAIT_Msk                     (0x1UL << ETH_MACDR_TFCSTS_WAIT_Pos) /*!< 0x00020000 */
#define ETH_MACDR_TFCSTS_WAIT                         ETH_MACDR_TFCSTS_WAIT_Msk /* Waiting for status of the previous packet, IPG or backoff period to be over */
#define ETH_MACDR_TFCSTS_GENERATEPCP_Pos              (18U)
#define ETH_MACDR_TFCSTS_GENERATEPCP_Msk              (0x1UL << ETH_MACDR_TFCSTS_GENERATEPCP_Pos) /*!< 0x00040000 */
#define ETH_MACDR_TFCSTS_GENERATEPCP                  ETH_MACDR_TFCSTS_GENERATEPCP_Msk /* Generating and transmitting a Pause control packet */
#define ETH_MACDR_TFCSTS_TRASFERIP_Pos                (17U)
#define ETH_MACDR_TFCSTS_TRASFERIP_Msk                (0x3UL << ETH_MACDR_TFCSTS_TRASFERIP_Pos) /*!< 0x00060000 */
#define ETH_MACDR_TFCSTS_TRASFERIP                    ETH_MACDR_TFCSTS_TRASFERIP_Msk /* Transferring input packet for transmission */
#define ETH_MACDR_TPESTS_Pos                          (16U)
#define ETH_MACDR_TPESTS_Msk                          (0x1UL << ETH_MACDR_TPESTS_Pos) /*!< 0x00010000 */
#define ETH_MACDR_TPESTS                              ETH_MACDR_TPESTS_Msk     /* MAC Receive Packet Controller FIFO Status */
#define ETH_MACDR_RFCFCSTS_Pos                        (1U)
#define ETH_MACDR_RFCFCSTS_Msk                        (0x3UL << ETH_MACDR_RFCFCSTS_Pos) /*!< 0x00000006 */
#define ETH_MACDR_RFCFCSTS                            ETH_MACDR_RFCFCSTS_Msk   /* MAC MII Transmit Protocol Engine Status */
#define ETH_MACDR_RPESTS_Pos                          (0U)
#define ETH_MACDR_RPESTS_Msk                          (0x1UL << ETH_MACDR_RPESTS_Pos) /*!< 0x00000001 */
#define ETH_MACDR_RPESTS                              ETH_MACDR_RPESTS_Msk     /* MAC MII Receive Protocol Engine Status */

/* Bit definition for Ethernet MAC HW Feature0 Register */
#define ETH_MACHWF0R_ACTPHYSEL_Pos                    (28U)
#define ETH_MACHWF0R_ACTPHYSEL_Msk                    (0x7UL << ETH_MACHWF0R_ACTPHYSEL_Pos) /*!< 0x70000000 */
#define ETH_MACHWF0R_ACTPHYSEL                        ETH_MACHWF0R_ACTPHYSEL_Msk /* Active PHY Selected */
#define ETH_MACHWF0R_ACTPHYSEL_MII                    ((uint32_t)0x00000000)   /* MII */
#define ETH_MACHWF0R_ACTPHYSEL_RMII_Pos               (30U)
#define ETH_MACHWF0R_ACTPHYSEL_RMII_Msk               (0x1UL << ETH_MACHWF0R_ACTPHYSEL_RMII_Pos) /*!< 0x40000000 */
#define ETH_MACHWF0R_ACTPHYSEL_RMII                   ETH_MACHWF0R_ACTPHYSEL_RMII_Msk /* RMII */
#define ETH_MACHWF0R_ACTPHYSEL_REVMII_Pos             (28U)
#define ETH_MACHWF0R_ACTPHYSEL_REVMII_Msk             (0x7UL << ETH_MACHWF0R_ACTPHYSEL_REVMII_Pos) /*!< 0x70000000 */
#define ETH_MACHWF0R_ACTPHYSEL_REVMII                 ETH_MACHWF0R_ACTPHYSEL_REVMII_Msk /* RevMII */
#define ETH_MACHWF0R_SAVLANINS_Pos                    (27U)
#define ETH_MACHWF0R_SAVLANINS_Msk                    (0x1UL << ETH_MACHWF0R_SAVLANINS_Pos) /*!< 0x08000000 */
#define ETH_MACHWF0R_SAVLANINS                        ETH_MACHWF0R_SAVLANINS_Msk /* Source Address or VLAN Insertion Enable */
#define ETH_MACHWF0R_TSSTSSEL_Pos                     (25U)
#define ETH_MACHWF0R_TSSTSSEL_Msk                     (0x3UL << ETH_MACHWF0R_TSSTSSEL_Pos) /*!< 0x06000000 */
#define ETH_MACHWF0R_TSSTSSEL                         ETH_MACHWF0R_TSSTSSEL_Msk /* Timestamp System Time Source */
#define ETH_MACHWF0R_TSSTSSEL_INTERNAL_Pos            (25U)
#define ETH_MACHWF0R_TSSTSSEL_INTERNAL_Msk            (0x1UL << ETH_MACHWF0R_TSSTSSEL_INTERNAL_Pos) /*!< 0x02000000 */
#define ETH_MACHWF0R_TSSTSSEL_INTERNAL                ETH_MACHWF0R_TSSTSSEL_INTERNAL_Msk /* Timestamp System Time Source: Internal */
#define ETH_MACHWF0R_TSSTSSEL_EXTERNAL_Pos            (26U)
#define ETH_MACHWF0R_TSSTSSEL_EXTERNAL_Msk            (0x1UL << ETH_MACHWF0R_TSSTSSEL_EXTERNAL_Pos) /*!< 0x04000000 */
#define ETH_MACHWF0R_TSSTSSEL_EXTERNAL                ETH_MACHWF0R_TSSTSSEL_EXTERNAL_Msk /* Timestamp System Time Source: External */
#define ETH_MACHWF0R_TSSTSSEL_BOTH_Pos                (25U)
#define ETH_MACHWF0R_TSSTSSEL_BOTH_Msk                (0x3UL << ETH_MACHWF0R_TSSTSSEL_BOTH_Pos) /*!< 0x06000000 */
#define ETH_MACHWF0R_TSSTSSEL_BOTH                    ETH_MACHWF0R_TSSTSSEL_BOTH_Msk /* Timestamp System Time Source: Internal & External */
#define ETH_MACHWF0R_MACADR64SEL_Pos                  (24U)
#define ETH_MACHWF0R_MACADR64SEL_Msk                  (0x1UL << ETH_MACHWF0R_MACADR64SEL_Pos) /*!< 0x01000000 */
#define ETH_MACHWF0R_MACADR64SEL                      ETH_MACHWF0R_MACADR64SEL_Msk /* MAC Addresses 64-127 Selected */
#define ETH_MACHWF0R_MACADR32SEL_Pos                  (23U)
#define ETH_MACHWF0R_MACADR32SEL_Msk                  (0x1UL << ETH_MACHWF0R_MACADR32SEL_Pos) /*!< 0x00800000 */
#define ETH_MACHWF0R_MACADR32SEL                      ETH_MACHWF0R_MACADR32SEL_Msk /* MAC Addresses 32-63 Selected */
#define ETH_MACHWF0R_ADDMACADRSEL_Pos                 (18U)
#define ETH_MACHWF0R_ADDMACADRSEL_Msk                 (0x1FUL << ETH_MACHWF0R_ADDMACADRSEL_Pos) /*!< 0x007C0000 */
#define ETH_MACHWF0R_ADDMACADRSEL                     ETH_MACHWF0R_ADDMACADRSEL_Msk /* MAC Addresses 1- 31 Selected */
#define ETH_MACHWF0R_RXCOESEL_Pos                     (16U)
#define ETH_MACHWF0R_RXCOESEL_Msk                     (0x1UL << ETH_MACHWF0R_RXCOESEL_Pos) /*!< 0x00010000 */
#define ETH_MACHWF0R_RXCOESEL                         ETH_MACHWF0R_RXCOESEL_Msk /* Receive Checksum Offload Enabled */
#define ETH_MACHWF0R_TXCOESEL_Pos                     (14U)
#define ETH_MACHWF0R_TXCOESEL_Msk                     (0x1UL << ETH_MACHWF0R_TXCOESEL_Pos) /*!< 0x00004000 */
#define ETH_MACHWF0R_TXCOESEL                         ETH_MACHWF0R_TXCOESEL_Msk /* Transmit Checksum Offload Enabled */
#define ETH_MACHWF0R_EEESEL_Pos                       (13U)
#define ETH_MACHWF0R_EEESEL_Msk                       (0x1UL << ETH_MACHWF0R_EEESEL_Pos) /*!< 0x00002000 */
#define ETH_MACHWF0R_EEESEL                           ETH_MACHWF0R_EEESEL_Msk  /* Energy Efficient Ethernet Enabled */
#define ETH_MACHWF0R_TSSEL_Pos                        (12U)
#define ETH_MACHWF0R_TSSEL_Msk                        (0x1UL << ETH_MACHWF0R_TSSEL_Pos) /*!< 0x00001000 */
#define ETH_MACHWF0R_TSSEL                            ETH_MACHWF0R_TSSEL_Msk   /* IEEE 1588-2008 Timestamp Enabled */
#define ETH_MACHWF0R_ARPOFFSEL_Pos                    (9U)
#define ETH_MACHWF0R_ARPOFFSEL_Msk                    (0x1UL << ETH_MACHWF0R_ARPOFFSEL_Pos) /*!< 0x00000200 */
#define ETH_MACHWF0R_ARPOFFSEL                        ETH_MACHWF0R_ARPOFFSEL_Msk /* ARP Offload Enabled */
#define ETH_MACHWF0R_MMCSEL_Pos                       (8U)
#define ETH_MACHWF0R_MMCSEL_Msk                       (0x1UL << ETH_MACHWF0R_MMCSEL_Pos) /*!< 0x00000100 */
#define ETH_MACHWF0R_MMCSEL                           ETH_MACHWF0R_MMCSEL_Msk  /* RMON Module Enable */
#define ETH_MACHWF0R_MGKSEL_Pos                       (7U)
#define ETH_MACHWF0R_MGKSEL_Msk                       (0x1UL << ETH_MACHWF0R_MGKSEL_Pos) /*!< 0x00000080 */
#define ETH_MACHWF0R_MGKSEL                           ETH_MACHWF0R_MGKSEL_Msk  /* PMT Magic Packet Enable */
#define ETH_MACHWF0R_RWKSEL_Pos                       (6U)
#define ETH_MACHWF0R_RWKSEL_Msk                       (0x1UL << ETH_MACHWF0R_RWKSEL_Pos) /*!< 0x00000040 */
#define ETH_MACHWF0R_RWKSEL                           ETH_MACHWF0R_RWKSEL_Msk  /* PMT Remote Wake-up Packet Enable */
#define ETH_MACHWF0R_SMASEL_Pos                       (5U)
#define ETH_MACHWF0R_SMASEL_Msk                       (0x1UL << ETH_MACHWF0R_SMASEL_Pos) /*!< 0x00000020 */
#define ETH_MACHWF0R_SMASEL                           ETH_MACHWF0R_SMASEL_Msk  /* SMA (MDIO) Interface */
#define ETH_MACHWF0R_VLHASH_Pos                       (4U)
#define ETH_MACHWF0R_VLHASH_Msk                       (0x1UL << ETH_MACHWF0R_VLHASH_Pos) /*!< 0x00000010 */
#define ETH_MACHWF0R_VLHASH                           ETH_MACHWF0R_VLHASH_Msk  /* VLAN Hash Filter Selected */
#define ETH_MACHWF0R_PCSSEL_Pos                       (3U)
#define ETH_MACHWF0R_PCSSEL_Msk                       (0x1UL << ETH_MACHWF0R_PCSSEL_Pos) /*!< 0x00000008 */
#define ETH_MACHWF0R_PCSSEL                           ETH_MACHWF0R_PCSSEL_Msk  /* PCS Registers (TBI, SGMII, or RTBI PHY interface) */
#define ETH_MACHWF0R_HDSEL_Pos                        (2U)
#define ETH_MACHWF0R_HDSEL_Msk                        (0x1UL << ETH_MACHWF0R_HDSEL_Pos) /*!< 0x00000004 */
#define ETH_MACHWF0R_HDSEL                            ETH_MACHWF0R_HDSEL_Msk   /* Half-duplex Support */
#define ETH_MACHWF0R_GMIISEL_Pos                      (1U)
#define ETH_MACHWF0R_GMIISEL_Msk                      (0x1UL << ETH_MACHWF0R_GMIISEL_Pos) /*!< 0x00000002 */
#define ETH_MACHWF0R_GMIISEL                          ETH_MACHWF0R_GMIISEL_Msk /* 1000 Mbps Support */
#define ETH_MACHWF0R_MIISEL_Pos                       (0U)
#define ETH_MACHWF0R_MIISEL_Msk                       (0x1UL << ETH_MACHWF0R_MIISEL_Pos) /*!< 0x00000001 */
#define ETH_MACHWF0R_MIISEL                           ETH_MACHWF0R_MIISEL_Msk  /* 10 or 100 Mbps Support */

/* Bit definition for Ethernet MAC HW Feature1 Register */
#define ETH_MACHWF1R_L3L4FNUM_Pos                     (27U)
#define ETH_MACHWF1R_L3L4FNUM_Msk                     (0xFUL << ETH_MACHWF1R_L3L4FNUM_Pos) /*!< 0x78000000 */
#define ETH_MACHWF1R_L3L4FNUM                         ETH_MACHWF1R_L3L4FNUM_Msk /* Total number of L3 or L4 Filters */
#define ETH_MACHWF1R_HASHTBLSZ_Pos                    (24U)
#define ETH_MACHWF1R_HASHTBLSZ_Msk                    (0x3UL << ETH_MACHWF1R_HASHTBLSZ_Pos) /*!< 0x03000000 */
#define ETH_MACHWF1R_HASHTBLSZ                        ETH_MACHWF1R_HASHTBLSZ_Msk /* Hash Table Size */
#define ETH_MACHWF1R_AVSEL_Pos                        (20U)
#define ETH_MACHWF1R_AVSEL_Msk                        (0x1UL << ETH_MACHWF1R_AVSEL_Pos) /*!< 0x00100000 */
#define ETH_MACHWF1R_AVSEL                            ETH_MACHWF1R_AVSEL_Msk   /* AV Feature Enabled */
#define ETH_MACHWF1R_DBGMEMA_Pos                      (19U)
#define ETH_MACHWF1R_DBGMEMA_Msk                      (0x1UL << ETH_MACHWF1R_DBGMEMA_Pos) /*!< 0x00080000 */
#define ETH_MACHWF1R_DBGMEMA                          ETH_MACHWF1R_DBGMEMA_Msk /* Debug Memory Interface Enabled */
#define ETH_MACHWF1R_TSOEN_Pos                        (18U)
#define ETH_MACHWF1R_TSOEN_Msk                        (0x1UL << ETH_MACHWF1R_TSOEN_Pos) /*!< 0x00040000 */
#define ETH_MACHWF1R_TSOEN                            ETH_MACHWF1R_TSOEN_Msk   /* TCP Segmentation Offload Enable */
#define ETH_MACHWF1R_SPHEN_Pos                        (17U)
#define ETH_MACHWF1R_SPHEN_Msk                        (0x1UL << ETH_MACHWF1R_SPHEN_Pos) /*!< 0x00020000 */
#define ETH_MACHWF1R_SPHEN                            ETH_MACHWF1R_SPHEN_Msk   /* Split Header Feature Enable */
#define ETH_MACHWF1R_DCBEN_Pos                        (16U)
#define ETH_MACHWF1R_DCBEN_Msk                        (0x1UL << ETH_MACHWF1R_DCBEN_Pos) /*!< 0x00010000 */
#define ETH_MACHWF1R_DCBEN                            ETH_MACHWF1R_DCBEN_Msk   /* DCB Feature Enable */
#define ETH_MACHWF1R_ADDR64_Pos                       (14U)
#define ETH_MACHWF1R_ADDR64_Msk                       (0x3UL << ETH_MACHWF1R_ADDR64_Pos) /*!< 0x0000C000 */
#define ETH_MACHWF1R_ADDR64                           ETH_MACHWF1R_ADDR64_Msk  /* Address Width */
#define ETH_MACHWF1R_ADDR64_32                        (0x0UL << ETH_MACHWF1R_ADDR64_Pos) /*!< 0x00000000 */
#define ETH_MACHWF1R_ADDR64_40                        (0x1UL << ETH_MACHWF1R_ADDR64_Pos) /*!< 0x00004000 */
#define ETH_MACHWF1R_ADDR64_48                        (0x2UL << ETH_MACHWF1R_ADDR64_Pos) /*!< 0x00008000 */
#define ETH_MACHWF1R_ADVTHWORD_Pos                    (13U)
#define ETH_MACHWF1R_ADVTHWORD_Msk                    (0x1UL << ETH_MACHWF1R_ADVTHWORD_Pos) /*!< 0x00002000 */
#define ETH_MACHWF1R_ADVTHWORD                        ETH_MACHWF1R_ADVTHWORD_Msk /* IEEE 1588 High Word Register Enable */
#define ETH_MACHWF1R_PTOEN_Pos                        (12U)
#define ETH_MACHWF1R_PTOEN_Msk                        (0x1UL << ETH_MACHWF1R_PTOEN_Pos) /*!< 0x00001000 */
#define ETH_MACHWF1R_PTOEN                            ETH_MACHWF1R_PTOEN_Msk   /* PTP Offload Enable */
#define ETH_MACHWF1R_OSTEN_Pos                        (11U)
#define ETH_MACHWF1R_OSTEN_Msk                        (0x1UL << ETH_MACHWF1R_OSTEN_Pos) /*!< 0x00000800 */
#define ETH_MACHWF1R_OSTEN                            ETH_MACHWF1R_OSTEN_Msk   /* One-Step Timestamping Enable */
#define ETH_MACHWF1R_TXFIFOSIZE_Pos                   (6U)
#define ETH_MACHWF1R_TXFIFOSIZE_Msk                   (0x1FUL << ETH_MACHWF1R_TXFIFOSIZE_Pos) /*!< 0x000007C0 */
#define ETH_MACHWF1R_TXFIFOSIZE                       ETH_MACHWF1R_TXFIFOSIZE_Msk /* MTL Transmit FIFO Size */
#define ETH_MACHWF1R_RXFIFOSIZE_Pos                   (0U)
#define ETH_MACHWF1R_RXFIFOSIZE_Msk                   (0x1FUL << ETH_MACHWF1R_RXFIFOSIZE_Pos) /*!< 0x0000001F */
#define ETH_MACHWF1R_RXFIFOSIZE                       ETH_MACHWF1R_RXFIFOSIZE_Msk /* MTL Receive FIFO Size */

/* Bit definition for Ethernet MAC HW Feature2 Register */
#define ETH_MACHWF2R_AUXSNAPNUM_Pos                   (28U)
#define ETH_MACHWF2R_AUXSNAPNUM_Msk                   (0x7UL << ETH_MACHWF2R_AUXSNAPNUM_Pos) /*!< 0x70000000 */
#define ETH_MACHWF2R_AUXSNAPNUM                       ETH_MACHWF2R_AUXSNAPNUM_Msk /* Number of Auxiliary Snapshot Inputs */
#define ETH_MACHWF2R_PPSOUTNUM_Pos                    (24U)
#define ETH_MACHWF2R_PPSOUTNUM_Msk                    (0x7UL << ETH_MACHWF2R_PPSOUTNUM_Pos) /*!< 0x07000000 */
#define ETH_MACHWF2R_PPSOUTNUM                        ETH_MACHWF2R_PPSOUTNUM_Msk /*  Number of PPS Outputs */
#define ETH_MACHWF2R_TXCHCNT_Pos                      (18U)
#define ETH_MACHWF2R_TXCHCNT_Msk                      (0xFUL << ETH_MACHWF2R_TXCHCNT_Pos) /*!< 0x003C0000 */
#define ETH_MACHWF2R_TXCHCNT                          ETH_MACHWF2R_TXCHCNT_Msk /* Number of DMA Transmit Channels */
#define ETH_MACHWF2R_RXCHCNT_Pos                      (13U)
#define ETH_MACHWF2R_RXCHCNT_Msk                      (0x7UL << ETH_MACHWF2R_RXCHCNT_Pos) /*!< 0x0000E000 */
#define ETH_MACHWF2R_RXCHCNT                          ETH_MACHWF2R_RXCHCNT_Msk /* Number of DMA Receive Channels */
#define ETH_MACHWF2R_TXQCNT_Pos                       (6U)
#define ETH_MACHWF2R_TXQCNT_Msk                       (0xFUL << ETH_MACHWF2R_TXQCNT_Pos) /*!< 0x000003C0 */
#define ETH_MACHWF2R_TXQCNT                           ETH_MACHWF2R_TXQCNT_Msk  /* Number of MTL Transmit Queues */
#define ETH_MACHWF2R_RXQCNT_Pos                       (0U)
#define ETH_MACHWF2R_RXQCNT_Msk                       (0xFUL << ETH_MACHWF2R_RXQCNT_Pos) /*!< 0x0000000F */
#define ETH_MACHWF2R_RXQCNT                           ETH_MACHWF2R_RXQCNT_Msk  /* Number of MTL Receive Queues */

/* Bit definition for Ethernet MAC MDIO Address Register */
#define ETH_MACMDIOAR_PSE_Pos                         (27U)
#define ETH_MACMDIOAR_PSE_Msk                         (0x1UL << ETH_MACMDIOAR_PSE_Pos) /*!< 0x08000000 */
#define ETH_MACMDIOAR_PSE                             ETH_MACMDIOAR_PSE_Msk    /* Preamble Suppression Enable */
#define ETH_MACMDIOAR_BTB_Pos                         (26U)
#define ETH_MACMDIOAR_BTB_Msk                         (0x1UL << ETH_MACMDIOAR_BTB_Pos) /*!< 0x04000000 */
#define ETH_MACMDIOAR_BTB                             ETH_MACMDIOAR_BTB_Msk    /* Back to Back transactions */
#define ETH_MACMDIOAR_PA_Pos                          (21U)
#define ETH_MACMDIOAR_PA_Msk                          (0x1FUL << ETH_MACMDIOAR_PA_Pos) /*!< 0x03E00000 */
#define ETH_MACMDIOAR_PA                              ETH_MACMDIOAR_PA_Msk     /* Physical Layer Address */
#define ETH_MACMDIOAR_RDA_Pos                         (16U)
#define ETH_MACMDIOAR_RDA_Msk                         (0x1FUL << ETH_MACMDIOAR_RDA_Pos) /*!< 0x001F0000 */
#define ETH_MACMDIOAR_RDA                             ETH_MACMDIOAR_RDA_Msk    /* Register/Device Address */
#define ETH_MACMDIOAR_NTC_Pos                         (12U)
#define ETH_MACMDIOAR_NTC_Msk                         (0x7UL << ETH_MACMDIOAR_NTC_Pos) /*!< 0x00007000 */
#define ETH_MACMDIOAR_NTC                             ETH_MACMDIOAR_NTC_Msk    /* Number of Trailing Clocks */
#define ETH_MACMDIOAR_CR_Pos                          (8U)
#define ETH_MACMDIOAR_CR_Msk                          (0xFUL << ETH_MACMDIOAR_CR_Pos) /*!< 0x00000F00 */
#define ETH_MACMDIOAR_CR                              ETH_MACMDIOAR_CR_Msk     /* CSR Clock Range */
#define ETH_MACMDIOAR_CR_DIV42                        ((uint32_t)0x00000000)   /* CSR clock/42 */
#define ETH_MACMDIOAR_CR_DIV62_Pos                    (8U)
#define ETH_MACMDIOAR_CR_DIV62_Msk                    (0x1UL << ETH_MACMDIOAR_CR_DIV62_Pos) /*!< 0x00000100 */
#define ETH_MACMDIOAR_CR_DIV62                        ETH_MACMDIOAR_CR_DIV62_Msk /* CSR clock/62 */
#define ETH_MACMDIOAR_CR_DIV16_Pos                    (9U)
#define ETH_MACMDIOAR_CR_DIV16_Msk                    (0x1UL << ETH_MACMDIOAR_CR_DIV16_Pos) /*!< 0x00000200 */
#define ETH_MACMDIOAR_CR_DIV16                        ETH_MACMDIOAR_CR_DIV16_Msk /* CSR clock/16 */
#define ETH_MACMDIOAR_CR_DIV26_Pos                    (8U)
#define ETH_MACMDIOAR_CR_DIV26_Msk                    (0x3UL << ETH_MACMDIOAR_CR_DIV26_Pos) /*!< 0x00000300 */
#define ETH_MACMDIOAR_CR_DIV26                        ETH_MACMDIOAR_CR_DIV26_Msk /* CSR clock/26 */
#define ETH_MACMDIOAR_CR_DIV102_Pos                   (10U)
#define ETH_MACMDIOAR_CR_DIV102_Msk                   (0x1UL << ETH_MACMDIOAR_CR_DIV102_Pos) /*!< 0x00000400 */
#define ETH_MACMDIOAR_CR_DIV102                       ETH_MACMDIOAR_CR_DIV102_Msk /* CSR clock/102 */
#define ETH_MACMDIOAR_CR_DIV124_Pos                   (8U)
#define ETH_MACMDIOAR_CR_DIV124_Msk                   (0x5UL << ETH_MACMDIOAR_CR_DIV124_Pos) /*!< 0x00000500 */
#define ETH_MACMDIOAR_CR_DIV124                       ETH_MACMDIOAR_CR_DIV124_Msk /* CSR clock/124 */
#define ETH_MACMDIOAR_CR_DIV4AR_Pos                   (11U)
#define ETH_MACMDIOAR_CR_DIV4AR_Msk                   (0x1UL << ETH_MACMDIOAR_CR_DIV4AR_Pos) /*!< 0x00000800 */
#define ETH_MACMDIOAR_CR_DIV4AR                       ETH_MACMDIOAR_CR_DIV4AR_Msk /* CSR clock/4: MDC clock above range specified in IEEE */
#define ETH_MACMDIOAR_CR_DIV6AR_Pos                   (8U)
#define ETH_MACMDIOAR_CR_DIV6AR_Msk                   (0x9UL << ETH_MACMDIOAR_CR_DIV6AR_Pos) /*!< 0x00000900 */
#define ETH_MACMDIOAR_CR_DIV6AR                       ETH_MACMDIOAR_CR_DIV6AR_Msk /* CSR clock/6: MDC clock above range specified in IEEE */
#define ETH_MACMDIOAR_CR_DIV8AR_Pos                   (9U)
#define ETH_MACMDIOAR_CR_DIV8AR_Msk                   (0x5UL << ETH_MACMDIOAR_CR_DIV8AR_Pos) /*!< 0x00000A00 */
#define ETH_MACMDIOAR_CR_DIV8AR                       ETH_MACMDIOAR_CR_DIV8AR_Msk /* CSR clock/8: MDC clock above range specified in IEEE */
#define ETH_MACMDIOAR_CR_DIV10AR_Pos                  (8U)
#define ETH_MACMDIOAR_CR_DIV10AR_Msk                  (0xBUL << ETH_MACMDIOAR_CR_DIV10AR_Pos) /*!< 0x00000B00 */
#define ETH_MACMDIOAR_CR_DIV10AR                      ETH_MACMDIOAR_CR_DIV10AR_Msk /* CSR clock/10: MDC clock above range specified in IEEE */
#define ETH_MACMDIOAR_CR_DIV12AR_Pos                  (10U)
#define ETH_MACMDIOAR_CR_DIV12AR_Msk                  (0x3UL << ETH_MACMDIOAR_CR_DIV12AR_Pos) /*!< 0x00000C00 */
#define ETH_MACMDIOAR_CR_DIV12AR                      ETH_MACMDIOAR_CR_DIV12AR_Msk /* CSR clock/12: MDC clock above range specified in IEEE */
#define ETH_MACMDIOAR_CR_DIV14AR_Pos                  (8U)
#define ETH_MACMDIOAR_CR_DIV14AR_Msk                  (0xDUL << ETH_MACMDIOAR_CR_DIV14AR_Pos) /*!< 0x00000D00 */
#define ETH_MACMDIOAR_CR_DIV14AR                      ETH_MACMDIOAR_CR_DIV14AR_Msk /* CSR clock/14: MDC clock above range specified in IEEE */
#define ETH_MACMDIOAR_CR_DIV16AR_Pos                  (9U)
#define ETH_MACMDIOAR_CR_DIV16AR_Msk                  (0x7UL << ETH_MACMDIOAR_CR_DIV16AR_Pos) /*!< 0x00000E00 */
#define ETH_MACMDIOAR_CR_DIV16AR                      ETH_MACMDIOAR_CR_DIV16AR_Msk /* CSR clock/16: MDC clock above range specified in IEEE */
#define ETH_MACMDIOAR_CR_DIV18AR_Pos                  (8U)
#define ETH_MACMDIOAR_CR_DIV18AR_Msk                  (0xFUL << ETH_MACMDIOAR_CR_DIV18AR_Pos) /*!< 0x00000F00 */
#define ETH_MACMDIOAR_CR_DIV18AR                      ETH_MACMDIOAR_CR_DIV18AR_Msk /* CSR clock/18: MDC clock above range specified in IEEE */
#define ETH_MACMDIOAR_SKAP_Pos                        (4U)
#define ETH_MACMDIOAR_SKAP_Msk                        (0x1UL << ETH_MACMDIOAR_SKAP_Pos) /*!< 0x00000010 */
#define ETH_MACMDIOAR_SKAP                            ETH_MACMDIOAR_SKAP_Msk   /* Skip Address Packet */
#define ETH_MACMDIOAR_MOC_Pos                         (2U)
#define ETH_MACMDIOAR_MOC_Msk                         (0x3UL << ETH_MACMDIOAR_MOC_Pos) /*!< 0x0000000C */
#define ETH_MACMDIOAR_MOC                             ETH_MACMDIOAR_MOC_Msk    /* MII Operation Command */
#define ETH_MACMDIOAR_MOC_WR_Pos                      (2U)
#define ETH_MACMDIOAR_MOC_WR_Msk                      (0x1UL << ETH_MACMDIOAR_MOC_WR_Pos) /*!< 0x00000004 */
#define ETH_MACMDIOAR_MOC_WR                          ETH_MACMDIOAR_MOC_WR_Msk /* Write */
#define ETH_MACMDIOAR_MOC_PRDIA_Pos                   (3U)
#define ETH_MACMDIOAR_MOC_PRDIA_Msk                   (0x1UL << ETH_MACMDIOAR_MOC_PRDIA_Pos) /*!< 0x00000008 */
#define ETH_MACMDIOAR_MOC_PRDIA                       ETH_MACMDIOAR_MOC_PRDIA_Msk /* Post Read Increment Address for Clause 45 PHY */
#define ETH_MACMDIOAR_MOC_RD_Pos                      (2U)
#define ETH_MACMDIOAR_MOC_RD_Msk                      (0x3UL << ETH_MACMDIOAR_MOC_RD_Pos) /*!< 0x0000000C */
#define ETH_MACMDIOAR_MOC_RD                          ETH_MACMDIOAR_MOC_RD_Msk /* Read */
#define ETH_MACMDIOAR_C45E_Pos                        (1U)
#define ETH_MACMDIOAR_C45E_Msk                        (0x1UL << ETH_MACMDIOAR_C45E_Pos) /*!< 0x00000002 */
#define ETH_MACMDIOAR_C45E                            ETH_MACMDIOAR_C45E_Msk   /* Clause 45 PHY Enable */
#define ETH_MACMDIOAR_MB_Pos                          (0U)
#define ETH_MACMDIOAR_MB_Msk                          (0x1UL << ETH_MACMDIOAR_MB_Pos) /*!< 0x00000001 */
#define ETH_MACMDIOAR_MB                              ETH_MACMDIOAR_MB_Msk     /* MII Busy */

/* Bit definition for Ethernet MAC MDIO Data Register */
#define ETH_MACMDIODR_RA_Pos                          (16U)
#define ETH_MACMDIODR_RA_Msk                          (0xFFFFUL << ETH_MACMDIODR_RA_Pos) /*!< 0xFFFF0000 */
#define ETH_MACMDIODR_RA                              ETH_MACMDIODR_RA_Msk     /* Register Address */
#define ETH_MACMDIODR_MD_Pos                          (0U)
#define ETH_MACMDIODR_MD_Msk                          (0xFFFFUL << ETH_MACMDIODR_MD_Pos) /*!< 0x0000FFFF */
#define ETH_MACMDIODR_MD                              ETH_MACMDIODR_MD_Msk     /* MII Data */

/* Bit definition for Ethernet ARP Address Register */
#define ETH_MACARPAR_ARPPA_Pos                         (0U)
#define ETH_MACARPAR_ARPPA_Msk                         (0xFFFFFFFFUL << ETH_MACARPAR_ARPPA_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACARPAR_ARPPA                             ETH_MACARPAR_ARPPA_Msk     /* ARP Protocol Address */

/* Bit definition for Ethernet MAC Address 0 High Register */
#define ETH_MACA0HR_AE_Pos                            (31U)
#define ETH_MACA0HR_AE_Msk                            (0x1UL << ETH_MACA0HR_AE_Pos) /*!< 0x80000000 */
#define ETH_MACA0HR_AE                                ETH_MACA0HR_AE_Msk /* Address Enable*/
#define ETH_MACA0HR_ADDRHI_Pos                        (0U)
#define ETH_MACA0HR_ADDRHI_Msk                        (0xFFFFUL << ETH_MACA0HR_ADDRHI_Pos) /*!< 0x0000FFFF */
#define ETH_MACA0HR_ADDRHI                            ETH_MACA0HR_ADDRHI_Msk   /* MAC Address 0*/

/* Bit definition for Ethernet MAC Address 0 Low Register */
#define ETH_MACA0LR_ADDRLO_Pos                        (0U)
#define ETH_MACA0LR_ADDRLO_Msk                        (0xFFFFFFFFUL << ETH_MACA0LR_ADDRLO_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACA0LR_ADDRLO                            ETH_MACA0LR_ADDRLO_Msk   /* MAC Address 0*/

/* Bit definition for Ethernet MAC Address 1 High Register */
#define ETH_MACA1HR_AE_Pos                            (31U)
#define ETH_MACA1HR_AE_Msk                            (0x1UL << ETH_MACA1HR_AE_Pos) /*!< 0x80000000 */
#define ETH_MACA1HR_AE                                ETH_MACA1HR_AE_Msk /* Address Enable*/
#define ETH_MACA1HR_SA_Pos                            (30U)
#define ETH_MACA1HR_SA_Msk                            (0x1UL << ETH_MACA1HR_SA_Pos) /*!< 0x40000000 */
#define ETH_MACA1HR_SA                                ETH_MACA1HR_SA_Msk /* Source Address */
#define ETH_MACA1HR_MBC_Pos                           (24U)
#define ETH_MACA1HR_MBC_Msk                           (0x3FUL << ETH_MACA1HR_MBC_Pos) /*!< 0x3F000000 */
#define ETH_MACA1HR_MBC                               ETH_MACA1HR_MBC_Msk /* Mask Byte Control */
#define ETH_MACA1HR_ADDRHI_Pos                        (0U)
#define ETH_MACA1HR_ADDRHI_Msk                        (0xFFFFUL << ETH_MACA1HR_ADDRHI_Pos) /*!< 0x0000FFFF */
#define ETH_MACA1HR_ADDRHI                            ETH_MACA1HR_ADDRHI_Msk   /* MAC Address 1*/

/* Bit definition for Ethernet MAC Address 1 Low Register */
#define ETH_MACA1LR_ADDRLO_Pos                        (0U)
#define ETH_MACA1LR_ADDRLO_Msk                        (0xFFFFFFFFUL << ETH_MACA1LR_ADDRLO_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACA1LR_ADDRLO                            ETH_MACA1LR_ADDRLO_Msk   /* MAC Address 1*/

/* Bit definition for Ethernet MAC Address 2 High Register */
#define ETH_MACA2HR_AE_Pos                            (31U)
#define ETH_MACA2HR_AE_Msk                            (0x1UL << ETH_MACA2HR_AE_Pos) /*!< 0x80000000 */
#define ETH_MACA2HR_AE                                ETH_MACA2HR_AE_Msk /* Address Enable*/
#define ETH_MACA2HR_SA_Pos                            (30U)
#define ETH_MACA2HR_SA_Msk                            (0x1UL << ETH_MACA2HR_SA_Pos) /*!< 0x40000000 */
#define ETH_MACA2HR_SA                                ETH_MACA2HR_SA_Msk /* Source Address */
#define ETH_MACA2HR_MBC_Pos                           (24U)
#define ETH_MACA2HR_MBC_Msk                           (0x3FUL << ETH_MACA2HR_MBC_Pos) /*!< 0x3F000000 */
#define ETH_MACA2HR_MBC                               ETH_MACA2HR_MBC_Msk /* Mask Byte Control */
#define ETH_MACA2HR_ADDRHI_Pos                        (0U)
#define ETH_MACA2HR_ADDRHI_Msk                        (0xFFFFUL << ETH_MACA2HR_ADDRHI_Pos) /*!< 0x0000FFFF */
#define ETH_MACA2HR_ADDRHI                            ETH_MACA2HR_ADDRHI_Msk   /* MAC Address 1*/

/* Bit definition for Ethernet MAC Address 2 Low Register */
#define ETH_MACA2LR_ADDRLO_Pos                        (0U)
#define ETH_MACA2LR_ADDRLO_Msk                        (0xFFFFFFFFUL << ETH_MACA2LR_ADDRLO_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACA2LR_ADDRLO                            ETH_MACA2LR_ADDRLO_Msk   /* MAC Address 2*/

/* Bit definition for Ethernet MAC Address 3 High Register */
#define ETH_MACA3HR_AE_Pos                            (31U)
#define ETH_MACA3HR_AE_Msk                            (0x1UL << ETH_MACA3HR_AE_Pos) /*!< 0x80000000 */
#define ETH_MACA3HR_AE                                ETH_MACA3HR_AE_Msk /* Address Enable*/
#define ETH_MACA3HR_SA_Pos                            (30U)
#define ETH_MACA3HR_SA_Msk                            (0x1UL << ETH_MACA3HR_SA_Pos) /*!< 0x40000000 */
#define ETH_MACA3HR_SA                                ETH_MACA3HR_SA_Msk /* Source Address */
#define ETH_MACA3HR_MBC_Pos                           (24U)
#define ETH_MACA3HR_MBC_Msk                           (0x3FUL << ETH_MACA3HR_MBC_Pos) /*!< 0x3F000000 */
#define ETH_MACA3HR_MBC                               ETH_MACA3HR_MBC_Msk /* Mask Byte Control */
#define ETH_MACA3HR_ADDRHI_Pos                        (0U)
#define ETH_MACA3HR_ADDRHI_Msk                        (0xFFFFUL << ETH_MACA3HR_ADDRHI_Pos) /*!< 0x0000FFFF */
#define ETH_MACA3HR_ADDRHI                            ETH_MACA3HR_ADDRHI_Msk   /* MAC Address 1*/

/* Bit definition for Ethernet MAC Address 3 Low Register */
#define ETH_MACA3LR_ADDRLO_Pos                        (0U)
#define ETH_MACA3LR_ADDRLO_Msk                        (0xFFFFFFFFUL << ETH_MACA3LR_ADDRLO_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACA3LR_ADDRLO                            ETH_MACA3LR_ADDRLO_Msk   /* MAC Address 3*/

/* Bit definition for Ethernet MAC Address High Register */
#define ETH_MACAHR_AE_Pos                             (31U)
#define ETH_MACAHR_AE_Msk                             (0x1UL << ETH_MACAHR_AE_Pos) /*!< 0x80000000 */
#define ETH_MACAHR_AE                                 ETH_MACAHR_AE_Msk        /* Address enable */
#define ETH_MACAHR_SA_Pos                             (30U)
#define ETH_MACAHR_SA_Msk                             (0x1UL << ETH_MACAHR_SA_Pos) /*!< 0x40000000 */
#define ETH_MACAHR_SA                                 ETH_MACAHR_SA_Msk        /* Source address */
#define ETH_MACAHR_MBC_Pos                            (24U)
#define ETH_MACAHR_MBC_Msk                            (0x3FUL << ETH_MACAHR_MBC_Pos) /*!< 0x3F000000 */
#define ETH_MACAHR_MBC                                ETH_MACAHR_MBC_Msk       /* Mask byte control: bits to mask for comparison of the MAC Address bytes */
#define ETH_MACAHR_MBC_HBITS15_8                      ((uint32_t)0x20000000)   /* Mask MAC Address high reg bits [15:8] */
#define ETH_MACAHR_MBC_HBITS7_0                       ((uint32_t)0x10000000)   /* Mask MAC Address high reg bits [7:0] */
#define ETH_MACAHR_MBC_LBITS31_24                     ((uint32_t)0x08000000)   /* Mask MAC Address low reg bits [31:24] */
#define ETH_MACAHR_MBC_LBITS23_16                     ((uint32_t)0x04000000)   /* Mask MAC Address low reg bits [23:16] */
#define ETH_MACAHR_MBC_LBITS15_8                      ((uint32_t)0x02000000)   /* Mask MAC Address low reg bits [15:8] */
#define ETH_MACAHR_MBC_LBITS7_0                       ((uint32_t)0x01000000)   /* Mask MAC Address low reg bits [7:0] */
#define ETH_MACAHR_MACAH_Pos                          (0U)
#define ETH_MACAHR_MACAH_Msk                          (0xFFFFUL << ETH_MACAHR_MACAH_Pos) /*!< 0x0000FFFF */
#define ETH_MACAHR_MACAH                              ETH_MACAHR_MACAH_Msk     /* MAC address high */

/* Bit definition for Ethernet MAC Address Low Register */
#define ETH_MACALR_MACAL_Pos                          (0U)
#define ETH_MACALR_MACAL_Msk                          (0xFFFFFFFFUL << ETH_MACALR_MACAL_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACALR_MACAL                              ETH_MACALR_MACAL_Msk     /* MAC address low */

/* Bit definition for Ethernet MMC Control Register */
#define ETH_MMCCR_UCDBC_Pos                           (8U)
#define ETH_MMCCR_UCDBC_Msk                           (0x1UL << ETH_MMCCR_UCDBC_Pos) /*!< 0x00000100 */
#define ETH_MMCCR_UCDBC                               ETH_MMCCR_UCDBC_Msk  /* Update MMC Counters for Dropped Broadcast Packets */
#define ETH_MMCCR_CNTPRSTLVL_Pos                      (5U)
#define ETH_MMCCR_CNTPRSTLVL_Msk                      (0x1UL << ETH_MMCCR_CNTPRSTLVL_Pos) /*!< 0x00000020 */
#define ETH_MMCCR_CNTPRSTLVL                          ETH_MMCCR_CNTPRSTLVL_Msk  /* Full-Half Preset */
#define ETH_MMCCR_CNTPRST_Pos                         (4U)
#define ETH_MMCCR_CNTPRST_Msk                         (0x1UL << ETH_MMCCR_CNTPRST_Pos) /*!< 0x00000010 */
#define ETH_MMCCR_CNTPRST                             ETH_MMCCR_CNTPRST_Msk  /* Counters Reset */
#define ETH_MMCCR_CNTFREEZ_Pos                        (3U)
#define ETH_MMCCR_CNTFREEZ_Msk                        (0x1UL << ETH_MMCCR_CNTFREEZ_Pos) /*!< 0x00000008 */
#define ETH_MMCCR_CNTFREEZ                            ETH_MMCCR_CNTFREEZ_Msk  /* MMC Counter Freeze */
#define ETH_MMCCR_RSTONRD_Pos                         (2U)
#define ETH_MMCCR_RSTONRD_Msk                         (0x1UL << ETH_MMCCR_RSTONRD_Pos) /*!< 0x00000004 */
#define ETH_MMCCR_RSTONRD                             ETH_MMCCR_RSTONRD_Msk  /* Reset On Read */
#define ETH_MMCCR_CNTSTOPRO_Pos                       (1U)
#define ETH_MMCCR_CNTSTOPRO_Msk                       (0x1UL << ETH_MMCCR_CNTSTOPRO_Pos) /*!< 0x00000002 */
#define ETH_MMCCR_CNTSTOPRO                           ETH_MMCCR_CNTSTOPRO_Msk  /* Counter Stop Rollover */
#define ETH_MMCCR_CNTRST_Pos                          (0U)
#define ETH_MMCCR_CNTRST_Msk                          (0x1UL << ETH_MMCCR_CNTRST_Pos) /*!< 0x00000001 */
#define ETH_MMCCR_CNTRST                              ETH_MMCCR_CNTRST_Msk  /* Counters Reset */

/* Bit definition for Ethernet MMC Rx Interrupt Register */
#define ETH_MMCRIR_RXLPITRCIS_Pos                     (27U)
#define ETH_MMCRIR_RXLPITRCIS_Msk                     (0x1UL << ETH_MMCRIR_RXLPITRCIS_Pos) /*!< 0x08000000 */
#define ETH_MMCRIR_RXLPITRCIS                         ETH_MMCRIR_RXLPITRCIS_Msk  /* MMC Receive LPI transition counter interrupt status */
#define ETH_MMCRIR_RXLPIUSCIS_Pos                     (26U)
#define ETH_MMCRIR_RXLPIUSCIS_Msk                     (0x1UL << ETH_MMCRIR_RXLPIUSCIS_Pos) /*!< 0x04000000 */
#define ETH_MMCRIR_RXLPIUSCIS                         ETH_MMCRIR_RXLPIUSCIS_Msk  /* MMC Receive LPI microsecond counter interrupt status */
#define ETH_MMCRIR_RXUCGPIS_Pos                       (17U)
#define ETH_MMCRIR_RXUCGPIS_Msk                       (0x1UL << ETH_MMCRIR_RXUCGPIS_Pos) /*!< 0x00020000 */
#define ETH_MMCRIR_RXUCGPIS                           ETH_MMCRIR_RXUCGPIS_Msk  /* MMC Receive Unicast Good Packet Counter Interrupt Status */
#define ETH_MMCRIR_RXALGNERPIS_Pos                    (6U)
#define ETH_MMCRIR_RXALGNERPIS_Msk                    (0x1UL << ETH_MMCRIR_RXALGNERPIS_Pos) /*!< 0x00000040 */
#define ETH_MMCRIR_RXALGNERPIS                        ETH_MMCRIR_RXALGNERPIS_Msk  /* MMC Receive Alignment Error Packet Counter Interrupt Status */
#define ETH_MMCRIR_RXCRCERPIS_Pos                     (5U)
#define ETH_MMCRIR_RXCRCERPIS_Msk                     (0x1UL << ETH_MMCRIR_RXCRCERPIS_Pos) /*!< 0x00000020 */
#define ETH_MMCRIR_RXCRCERPIS                         ETH_MMCRIR_RXCRCERPIS_Msk  /* MMC Receive CRC Error Packet Counter Interrupt Status */

/* Bit definition for Ethernet MMC Tx Interrupt Register */
#define ETH_MMCTIR_TXLPITRCIS_Pos                     (27U)
#define ETH_MMCTIR_TXLPITRCIS_Msk                     (0x1UL << ETH_MMCTIR_TXLPITRCIS_Pos) /*!< 0x08000000 */
#define ETH_MMCTIR_TXLPITRCIS                         ETH_MMCTIR_TXLPITRCIS_Msk  /* MMC Transmit LPI transition counter interrupt status */
#define ETH_MMCTIR_TXLPIUSCIS_Pos                     (26U)
#define ETH_MMCTIR_TXLPIUSCIS_Msk                     (0x1UL << ETH_MMCTIR_TXLPIUSCIS_Pos) /*!< 0x04000000 */
#define ETH_MMCTIR_TXLPIUSCIS                         ETH_MMCTIR_TXLPIUSCIS_Msk  /* MMC Transmit LPI microsecond counter interrupt status */
#define ETH_MMCTIR_TXGPKTIS_Pos                       (21U)
#define ETH_MMCTIR_TXGPKTIS_Msk                       (0x1UL << ETH_MMCTIR_TXGPKTIS_Pos) /*!< 0x00200000 */
#define ETH_MMCTIR_TXGPKTIS                           ETH_MMCTIR_TXGPKTIS_Msk  /* MMC Transmit Good Packet Counter Interrupt Status */
#define ETH_MMCTIR_TXMCOLGPIS_Pos                     (15U)
#define ETH_MMCTIR_TXMCOLGPIS_Msk                     (0x1UL << ETH_MMCTIR_TXMCOLGPIS_Pos) /*!< 0x00008000 */
#define ETH_MMCTIR_TXMCOLGPIS                         ETH_MMCTIR_TXMCOLGPIS_Msk  /* MMC Transmit Multiple Collision Good Packet Counter Interrupt Status */
#define ETH_MMCTIR_TXSCOLGPIS_Pos                     (14U)
#define ETH_MMCTIR_TXSCOLGPIS_Msk                     (0x1UL << ETH_MMCTIR_TXSCOLGPIS_Pos) /*!< 0x00004000 */
#define ETH_MMCTIR_TXSCOLGPIS                         ETH_MMCTIR_TXSCOLGPIS_Msk  /* MMC Transmit Single Collision Good Packet Counter Interrupt Status */

/* Bit definition for Ethernet MMC Rx interrupt Mask register */
#define ETH_MMCRIMR_RXLPITRCIM_Pos                    (27U)
#define ETH_MMCRIMR_RXLPITRCIM_Msk                    (0x1UL << ETH_MMCRIMR_RXLPITRCIM_Pos) /*!< 0x08000000 */
#define ETH_MMCRIMR_RXLPITRCIM                        ETH_MMCRIMR_RXLPITRCIM_Msk  /* MMC Receive LPI transition counter interrupt Mask */
#define ETH_MMCRIMR_RXLPIUSCIM_Pos                    (26U)
#define ETH_MMCRIMR_RXLPIUSCIM_Msk                    (0x1UL << ETH_MMCRIMR_RXLPIUSCIM_Pos) /*!< 0x04000000 */
#define ETH_MMCRIMR_RXLPIUSCIM                        ETH_MMCRIMR_RXLPIUSCIM_Msk  /* MMC Receive LPI microsecond counter interrupt Mask */
#define ETH_MMCRIMR_RXUCGPIM_Pos                      (17U)
#define ETH_MMCRIMR_RXUCGPIM_Msk                      (0x1UL << ETH_MMCRIMR_RXUCGPIM_Pos) /*!< 0x00020000 */
#define ETH_MMCRIMR_RXUCGPIM                          ETH_MMCRIMR_RXUCGPIM_Msk  /* MMC Receive Unicast Good Packet Counter Interrupt Mask */
#define ETH_MMCRIMR_RXALGNERPIM_Pos                   (6U)
#define ETH_MMCRIMR_RXALGNERPIM_Msk                   (0x1UL << ETH_MMCRIMR_RXALGNERPIM_Pos) /*!< 0x00000040 */
#define ETH_MMCRIMR_RXALGNERPIM                       ETH_MMCRIMR_RXALGNERPIM_Msk  /* MMC Receive Alignment Error Packet Counter Interrupt Mask */
#define ETH_MMCRIMR_RXCRCERPIM_Pos                    (5U)
#define ETH_MMCRIMR_RXCRCERPIM_Msk                    (0x1UL << ETH_MMCRIMR_RXCRCERPIM_Pos) /*!< 0x00000020 */
#define ETH_MMCRIMR_RXCRCERPIM                        ETH_MMCRIMR_RXCRCERPIM_Msk  /* MMC Receive CRC Error Packet Counter Interrupt Mask */

/* Bit definition for Ethernet MMC Tx Interrupt Mask Register */
#define ETH_MMCTIMR_TXLPITRCIM_Pos                    (27U)
#define ETH_MMCTIMR_TXLPITRCIM_Msk                    (0x1UL << ETH_MMCTIMR_TXLPITRCIM_Pos) /*!< 0x08000000 */
#define ETH_MMCTIMR_TXLPITRCIM                        ETH_MMCTIMR_TXLPITRCIM_Msk  /* MMC Transmit LPI transition counter interrupt Mask*/
#define ETH_MMCTIMR_TXLPIUSCIM_Pos                    (26U)
#define ETH_MMCTIMR_TXLPIUSCIM_Msk                    (0x1UL << ETH_MMCTIMR_TXLPIUSCIM_Pos) /*!< 0x04000000 */
#define ETH_MMCTIMR_TXLPIUSCIM                        ETH_MMCTIMR_TXLPIUSCIM_Msk  /* MMC Transmit LPI microsecond counter interrupt Mask*/
#define ETH_MMCTIMR_TXGPKTIM_Pos                      (21U)
#define ETH_MMCTIMR_TXGPKTIM_Msk                      (0x1UL << ETH_MMCTIMR_TXGPKTIM_Pos) /*!< 0x00200000 */
#define ETH_MMCTIMR_TXGPKTIM                          ETH_MMCTIMR_TXGPKTIM_Msk  /* MMC Transmit Good Packet Counter Interrupt Mask*/
#define ETH_MMCTIMR_TXMCOLGPIM_Pos                    (15U)
#define ETH_MMCTIMR_TXMCOLGPIM_Msk                    (0x1UL << ETH_MMCTIMR_TXMCOLGPIM_Pos) /*!< 0x00008000 */
#define ETH_MMCTIMR_TXMCOLGPIM                        ETH_MMCTIMR_TXMCOLGPIM_Msk  /* MMC Transmit Multiple Collision Good Packet Counter Interrupt Mask */
#define ETH_MMCTIMR_TXSCOLGPIM_Pos                    (14U)
#define ETH_MMCTIMR_TXSCOLGPIM_Msk                    (0x1UL << ETH_MMCTIMR_TXSCOLGPIM_Pos) /*!< 0x00004000 */
#define ETH_MMCTIMR_TXSCOLGPIM                        ETH_MMCTIMR_TXSCOLGPIM_Msk  /* MMC Transmit Single Collision Good Packet Counter Interrupt Mask */

/* Bit definition for Ethernet MMC Tx Single Collision Good Packets Register */
#define ETH_MMCTSCGPR_TXSNGLCOLG_Pos                  (0U)
#define ETH_MMCTSCGPR_TXSNGLCOLG_msk                  (0xFFFFFFFFUL <<  ETH_MMCTSCGPR_TXSNGLCOLG_Pos) /*!< 0xFFFFFFFF */
#define ETH_MMCTSCGPR_TXSNGLCOLG                      ETH_MMCTSCGPR_TXSNGLCOLG_msk /* Tx Single Collision Good Packets */

/* Bit definition for Ethernet MMC Tx Multiple Collision Good Packets Register */
#define ETH_MMCTMCGPR_TXMULTCOLG_Pos                  (0U)
#define ETH_MMCTMCGPR_TXMULTCOLG_msk                  (0xFFFFFFFFUL <<  ETH_MMCTMCGPR_TXMULTCOLG_Pos) /*!< 0xFFFFFFFF */
#define ETH_MMCTMCGPR_TXMULTCOLG                      ETH_MMCTMCGPR_TXMULTCOLG_msk /* Tx Multiple Collision Good Packets */

/* Bit definition for Ethernet MMC Tx Packet Count Good Register */
#define ETH_MMCTPCGR_TXPKTG_Pos                       (0U)
#define ETH_MMCTPCGR_TXPKTG_msk                       (0xFFFFFFFFUL <<  ETH_MMCTPCGR_TXPKTG_Pos) /*!< 0xFFFFFFFF */
#define ETH_MMCTPCGR_TXPKTG                           ETH_MMCTPCGR_TXPKTG_msk /* Tx Packet Count Good */

/* Bit definition for Ethernet MMC Rx CRC Error Packets Register */
#define ETH_MMCRCRCEPR_RXCRCERR_Pos                   (0U)
#define ETH_MMCRCRCEPR_RXCRCERR_msk                   (0xFFFFFFFFUL <<  ETH_MMCRCRCEPR_RXCRCERR_Pos) /*!< 0xFFFFFFFF */
#define ETH_MMCRCRCEPR_RXCRCERR                       ETH_MMCRCRCEPR_RXCRCERR_msk /* Rx CRC Error Packets */

/* Bit definition for Ethernet MMC Rx alignment error packets register */
#define ETH_MMCRAEPR_RXALGNERR_Pos                    (0U)
#define ETH_MMCRAEPR_RXALGNERR_msk                    (0xFFFFFFFFUL <<  ETH_MMCRAEPR_RXALGNERR_Pos) /*!< 0xFFFFFFFF */
#define ETH_MMCRAEPR_RXALGNERR                        ETH_MMCRAEPR_RXALGNERR_msk /* Rx Alignment Error Packets */

/* Bit definition for Ethernet MMC Rx Unicast Packets Good Register */
#define ETH_MMCRUPGR_RXUCASTG_Pos                     (0U)
#define ETH_MMCRUPGR_RXUCASTG_msk                     (0xFFFFFFFFUL <<  ETH_MMCRUPGR_RXUCASTG_Pos) /*!< 0xFFFFFFFF */
#define ETH_MMCRUPGR_RXUCASTG                         ETH_MMCRUPGR_RXUCASTG_msk /* Rx Unicast Packets Good */

/* Bit definition for Ethernet MMC Tx LPI Microsecond Timer Register */
#define ETH_MMCTLPIMSTR_TXLPIUSC_Pos                  (0U)
#define ETH_MMCTLPIMSTR_TXLPIUSC_msk                  (0xFFFFFFFFUL <<  ETH_MMCTLPIMSTR_TXLPIUSC_Pos) /*!< 0xFFFFFFFF */
#define ETH_MMCTLPIMSTR_TXLPIUSC                      ETH_MMCTLPIMSTR_TXLPIUSC_msk /* Tx LPI Microseconds Counter */

/* Bit definition for Ethernet MMC Tx LPI Transition Counter Register */
#define ETH_MMCTLPITCR_TXLPITRC_Pos                   (0U)
#define ETH_MMCTLPITCR_TXLPITRC_msk                   (0xFFFFFFFFUL <<  ETH_MMCTLPITCR_TXLPITRC_Pos) /*!< 0xFFFFFFFF */
#define ETH_MMCTLPITCR_TXLPITRC                       ETH_MMCTLPITCR_TXLPITRC_msk /* Tx LPI Transition counter */

/* Bit definition for Ethernet MMC Rx LPI Microsecond Counter Register */
#define ETH_MMCRLPIMSTR_RXLPIUSC_Pos                  (0U)
#define ETH_MMCRLPIMSTR_RXLPIUSC_msk                  (0xFFFFFFFFUL <<  ETH_MMCRLPIMSTR_RXLPIUSC_Pos) /*!< 0xFFFFFFFF */
#define ETH_MMCRLPIMSTR_RXLPIUSC                      ETH_MMCRLPIMSTR_RXLPIUSC_msk /* Rx LPI Microseconds Counter */

/* Bit definition for Ethernet MMC Rx LPI Transition Counter Register */
#define ETH_MMCRLPITCR_RXLPITRC_Pos                   (0U)
#define ETH_MMCRLPITCR_RXLPITRC_msk                   (0xFFFFFFFFUL <<  ETH_MMCRLPITCR_RXLPITRC_Pos) /*!< 0xFFFFFFFF */
#define ETH_MMCRLPITCR_RXLPITRC                       ETH_MMCRLPITCR_RXLPITRC_msk /* Rx LPI Transition counter */

/* Bit definition for Ethernet MAC L3 L4 Control Register */
#define ETH_MACL3L4CR_L4DPIM_Pos                      (21U)
#define ETH_MACL3L4CR_L4DPIM_Msk                      (0x1UL << ETH_MACL3L4CR_L4DPIM_Pos) /*!< 0x00200000 */
#define ETH_MACL3L4CR_L4DPIM                          ETH_MACL3L4CR_L4DPIM_Msk /* Layer 4 Destination Port Inverse Match Enable */
#define ETH_MACL3L4CR_L4DPM_Pos                       (20U)
#define ETH_MACL3L4CR_L4DPM_Msk                       (0x1UL << ETH_MACL3L4CR_L4DPM_Pos) /*!< 0x00100000 */
#define ETH_MACL3L4CR_L4DPM                           ETH_MACL3L4CR_L4DPM_Msk  /* Layer 4 Destination Port Match Enable */
#define ETH_MACL3L4CR_L4SPIM_Pos                      (19U)
#define ETH_MACL3L4CR_L4SPIM_Msk                      (0x1UL << ETH_MACL3L4CR_L4SPIM_Pos) /*!< 0x00080000 */
#define ETH_MACL3L4CR_L4SPIM                          ETH_MACL3L4CR_L4SPIM_Msk /* Layer 4 Source Port Inverse Match Enable */
#define ETH_MACL3L4CR_L4SPM_Pos                       (18U)
#define ETH_MACL3L4CR_L4SPM_Msk                       (0x1UL << ETH_MACL3L4CR_L4SPM_Pos) /*!< 0x00040000 */
#define ETH_MACL3L4CR_L4SPM                           ETH_MACL3L4CR_L4SPM_Msk  /* Layer 4 Source Port Match Enable */
#define ETH_MACL3L4CR_L4PEN_Pos                       (16U)
#define ETH_MACL3L4CR_L4PEN_Msk                       (0x1UL << ETH_MACL3L4CR_L4PEN_Pos) /*!< 0x00010000 */
#define ETH_MACL3L4CR_L4PEN                           ETH_MACL3L4CR_L4PEN_Msk  /* Layer 4 Protocol Enable */
#define ETH_MACL3L4CR_L3HDBM_Pos                      (11U)
#define ETH_MACL3L4CR_L3HDBM_Msk                      (0x1FUL << ETH_MACL3L4CR_L3HDBM_Pos) /*!< 0x0000F800 */
#define ETH_MACL3L4CR_L3HDBM                          ETH_MACL3L4CR_L3HDBM_Msk /* Layer 3 IP DA Higher Bits Match */
#define ETH_MACL3L4CR_L3HSBM_Pos                      (6U)
#define ETH_MACL3L4CR_L3HSBM_Msk                      (0x1FUL << ETH_MACL3L4CR_L3HSBM_Pos) /*!< 0x000007C0 */
#define ETH_MACL3L4CR_L3HSBM                          ETH_MACL3L4CR_L3HSBM_Msk /* Layer 3 IP SA Higher Bits Match */
#define ETH_MACL3L4CR_L3DAIM_Pos                      (5U)
#define ETH_MACL3L4CR_L3DAIM_Msk                      (0x1UL << ETH_MACL3L4CR_L3DAIM_Pos) /*!< 0x00000020 */
#define ETH_MACL3L4CR_L3DAIM                          ETH_MACL3L4CR_L3DAIM_Msk /* Layer 3 IP DA Inverse Match Enable */
#define ETH_MACL3L4CR_L3DAM_Pos                       (4U)
#define ETH_MACL3L4CR_L3DAM_Msk                       (0x1UL << ETH_MACL3L4CR_L3DAM_Pos) /*!< 0x00000010 */
#define ETH_MACL3L4CR_L3DAM                           ETH_MACL3L4CR_L3DAM_Msk  /* Layer 3 IP DA Match Enable */
#define ETH_MACL3L4CR_L3SAIM_Pos                      (3U)
#define ETH_MACL3L4CR_L3SAIM_Msk                      (0x1UL << ETH_MACL3L4CR_L3SAIM_Pos) /*!< 0x00000008 */
#define ETH_MACL3L4CR_L3SAIM                          ETH_MACL3L4CR_L3SAIM_Msk /* Layer 3 IP SA Inverse Match Enable */
#define ETH_MACL3L4CR_L3SAM_Pos                       (2U)
#define ETH_MACL3L4CR_L3SAM_Msk                       (0x1UL << ETH_MACL3L4CR_L3SAM_Pos) /*!< 0x00000004 */
#define ETH_MACL3L4CR_L3SAM                           ETH_MACL3L4CR_L3SAM_Msk  /* Layer 3 IP SA Match Enable*/
#define ETH_MACL3L4CR_L3PEN_Pos                       (0U)
#define ETH_MACL3L4CR_L3PEN_Msk                       (0x1UL << ETH_MACL3L4CR_L3PEN_Pos) /*!< 0x00000001 */
#define ETH_MACL3L4CR_L3PEN                           ETH_MACL3L4CR_L3PEN_Msk  /* Layer 3 Protocol Enable */

/* Bit definition for Ethernet MAC L4 Address Register */
#define ETH_MACL4AR_L4DP_Pos                          (16U)
#define ETH_MACL4AR_L4DP_Msk                          (0xFFFFUL << ETH_MACL4AR_L4DP_Pos) /*!< 0xFFFF0000 */
#define ETH_MACL4AR_L4DP                              ETH_MACL4AR_L4DP_Msk     /* Layer 4 Destination Port Number Field */
#define ETH_MACL4AR_L4SP_Pos                          (0U)
#define ETH_MACL4AR_L4SP_Msk                          (0xFFFFUL << ETH_MACL4AR_L4SP_Pos) /*!< 0x0000FFFF */
#define ETH_MACL4AR_L4SP                              ETH_MACL4AR_L4SP_Msk     /* Layer 4 Source Port Number Field */

/* Bit definition for Ethernet MAC L3 Address0 Register */
#define ETH_MACL3A0R_L3A0_Pos                         (0U)
#define ETH_MACL3A0R_L3A0_Msk                         (0xFFFFFFFFUL << ETH_MACL3A0R_L3A0_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACL3A0R_L3A0                             ETH_MACL3A0R_L3A0_Msk    /* Layer 3 Address 0 Field */

/* Bit definition for Ethernet MAC L4 Address1 Register */
#define ETH_MACL3A1R_L3A1_Pos                         (0U)
#define ETH_MACL3A1R_L3A1_Msk                         (0xFFFFFFFFUL << ETH_MACL3A1R_L3A1_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACL3A1R_L3A1                             ETH_MACL3A1R_L3A1_Msk    /* Layer 3 Address 1 Field */

/* Bit definition for Ethernet MAC L4 Address2 Register */
#define ETH_MACL3A2R_L3A2_Pos                         (0U)
#define ETH_MACL3A2R_L3A2_Msk                         (0xFFFFFFFFUL << ETH_MACL3A2R_L3A2_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACL3A2R_L3A2                             ETH_MACL3A2R_L3A2_Msk    /* Layer 3 Address 2 Field */

/* Bit definition for Ethernet MAC L4 Address3 Register */
#define ETH_MACL3A3R_L3A3_Pos                         (0U)
#define ETH_MACL3A3R_L3A3_Msk                         (0xFFFFFFFFUL << ETH_MACL3A3R_L3A3_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACL3A3R_L3A3                             ETH_MACL3A3R_L3A3_Msk    /* Layer 3 Address 3 Field */

/* Bit definition for Ethernet MAC Timestamp Control Register */
#define ETH_MACTSCR_TXTSSTSM_Pos                      (24U)
#define ETH_MACTSCR_TXTSSTSM_Msk                      (0x1UL << ETH_MACTSCR_TXTSSTSM_Pos) /*!< 0x01000000 */
#define ETH_MACTSCR_TXTSSTSM                          ETH_MACTSCR_TXTSSTSM_Msk  /* Transmit Timestamp Status Mode */
#define ETH_MACTSCR_CSC_Pos                           (19U)
#define ETH_MACTSCR_CSC_Msk                           (0x1UL << ETH_MACTSCR_CSC_Pos) /*!< 0x00080000 */
#define ETH_MACTSCR_CSC                               ETH_MACTSCR_CSC_Msk  /* Enable checksum correction during OST for PTP over UDP/IPv4 packets */
#define ETH_MACTSCR_TSENMACADDR_Pos                   (18U)
#define ETH_MACTSCR_TSENMACADDR_Msk                   (0x1UL << ETH_MACTSCR_TSENMACADDR_Pos) /*!< 0x00040000 */
#define ETH_MACTSCR_TSENMACADDR                       ETH_MACTSCR_TSENMACADDR_Msk  /* Enable MAC Address for PTP Packet Filtering */
#define ETH_MACTSCR_SNAPTYPSEL_Pos                    (16U)
#define ETH_MACTSCR_SNAPTYPSEL_Msk                    (0x3UL << ETH_MACTSCR_SNAPTYPSEL_Pos) /*!< 0x00030000 */
#define ETH_MACTSCR_SNAPTYPSEL                        ETH_MACTSCR_SNAPTYPSEL_Msk  /* Select PTP packets for Taking Snapshots */
#define ETH_MACTSCR_TSMSTRENA_Pos                     (15U)
#define ETH_MACTSCR_TSMSTRENA_Msk                     (0x1UL << ETH_MACTSCR_TSMSTRENA_Pos) /*!< 0x00008000 */
#define ETH_MACTSCR_TSMSTRENA                         ETH_MACTSCR_TSMSTRENA_Msk  /* Enable Snapshot for Messages Relevant to Master */
#define ETH_MACTSCR_TSEVNTENA_Pos                     (14U)
#define ETH_MACTSCR_TSEVNTENA_Msk                     (0x1UL << ETH_MACTSCR_TSEVNTENA_Pos) /*!< 0x00004000 */
#define ETH_MACTSCR_TSEVNTENA                         ETH_MACTSCR_TSEVNTENA_Msk  /* Enable Timestamp Snapshot for Event Messages */
#define ETH_MACTSCR_TSIPV4ENA_Pos                     (13U)
#define ETH_MACTSCR_TSIPV4ENA_Msk                     (0x1UL << ETH_MACTSCR_TSIPV4ENA_Pos) /*!< 0x00002000 */
#define ETH_MACTSCR_TSIPV4ENA                         ETH_MACTSCR_TSIPV4ENA_Msk  /* Enable Processing of PTP Packets Sent over IPv4-UDP */
#define ETH_MACTSCR_TSIPV6ENA_Pos                     (12U)
#define ETH_MACTSCR_TSIPV6ENA_Msk                     (0x1UL << ETH_MACTSCR_TSIPV6ENA_Pos) /*!< 0x00001000 */
#define ETH_MACTSCR_TSIPV6ENA                         ETH_MACTSCR_TSIPV6ENA_Msk  /* Enable Processing of PTP Packets Sent over IPv6-UDP */
#define ETH_MACTSCR_TSIPENA_Pos                       (11U)
#define ETH_MACTSCR_TSIPENA_Msk                       (0x1UL << ETH_MACTSCR_TSIPENA_Pos) /*!< 0x00000800 */
#define ETH_MACTSCR_TSIPENA                           ETH_MACTSCR_TSIPENA_Msk  /* Enable Processing of PTP over Ethernet Packets */
#define ETH_MACTSCR_TSVER2ENA_Pos                     (10U)
#define ETH_MACTSCR_TSVER2ENA_Msk                     (0x1UL << ETH_MACTSCR_TSVER2ENA_Pos) /*!< 0x00000400 */
#define ETH_MACTSCR_TSVER2ENA                         ETH_MACTSCR_TSVER2ENA_Msk  /* Enable PTP Packet Processing for Version 2 Format */
#define ETH_MACTSCR_TSCTRLSSR_Pos                     (9U)
#define ETH_MACTSCR_TSCTRLSSR_Msk                     (0x1UL << ETH_MACTSCR_TSCTRLSSR_Pos) /*!< 0x00000200 */
#define ETH_MACTSCR_TSCTRLSSR                         ETH_MACTSCR_TSCTRLSSR_Msk  /* Timestamp Digital or Binary Rollover Control */
#define ETH_MACTSCR_TSENALL_Pos                       (8U)
#define ETH_MACTSCR_TSENALL_Msk                       (0x1UL << ETH_MACTSCR_TSENALL_Pos) /*!< 0x00000100 */
#define ETH_MACTSCR_TSENALL                           ETH_MACTSCR_TSENALL_Msk  /* Enable Timestamp for All Packets */
#define ETH_MACTSCR_TSADDREG_Pos                      (5U)
#define ETH_MACTSCR_TSADDREG_Msk                      (0x1UL << ETH_MACTSCR_TSADDREG_Pos) /*!< 0x00000020 */
#define ETH_MACTSCR_TSADDREG                          ETH_MACTSCR_TSADDREG_Msk  /* Update Addend Register */
#define ETH_MACTSCR_TSUPDT_Pos                        (3U)
#define ETH_MACTSCR_TSUPDT_Msk                        (0x1UL << ETH_MACTSCR_TSUPDT_Pos) /*!< 0x00000008 */
#define ETH_MACTSCR_TSUPDT                            ETH_MACTSCR_TSUPDT_Msk  /* Update Timestamp */
#define ETH_MACTSCR_TSINIT_Pos                        (2U)
#define ETH_MACTSCR_TSINIT_Msk                        (0x1UL << ETH_MACTSCR_TSINIT_Pos) /*!< 0x00000004 */
#define ETH_MACTSCR_TSINIT                             ETH_MACTSCR_TSINIT_Msk  /* Initialize Timestamp */
#define ETH_MACTSCR_TSCFUPDT_Pos                      (1U)
#define ETH_MACTSCR_TSCFUPDT_Msk                      (0x1UL << ETH_MACTSCR_TSCFUPDT_Pos) /*!< 0x00000002 */
#define ETH_MACTSCR_TSCFUPDT                          ETH_MACTSCR_TSCFUPDT_Msk  /* Fine or Coarse Timestamp Update*/
#define ETH_MACTSCR_TSENA_Pos                         (0U)
#define ETH_MACTSCR_TSENA_Msk                         (0x1UL << ETH_MACTSCR_TSENA_Pos) /*!< 0x00000001 */
#define ETH_MACTSCR_TSENA                             ETH_MACTSCR_TSENA_Msk  /* Enable Timestamp */

/* Bit definition for Ethernet MAC Sub-second Increment Register */
#define ETH_MACMACSSIR_SSINC_Pos                      (16U)
#define ETH_MACMACSSIR_SSINC_Msk                      (0xFFUL << ETH_MACMACSSIR_SSINC_Pos) /*!< 0x0000FF00 */
#define ETH_MACMACSSIR_SSINC                          ETH_MACMACSSIR_SSINC_Msk  /* Sub-second Increment Value */
#define ETH_MACMACSSIR_SNSINC_Pos                     (8U)
#define ETH_MACMACSSIR_SNSINC_Msk                     (0xFFUL << ETH_MACMACSSIR_SNSINC_Pos) /*!< 0x000000FF */
#define ETH_MACMACSSIR_SNSINC                         ETH_MACMACSSIR_SNSINC_Msk  /* Sub-nanosecond Increment Value */

/* Bit definition for Ethernet MAC System Time Seconds Register */
#define ETH_MACSTSR_TSS_Pos                           (0U)
#define ETH_MACSTSR_TSS_Msk                           (0xFFFFFFFFUL << ETH_MACSTSR_TSS_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACSTSR_TSS                               ETH_MACSTSR_TSS_Msk  /* Timestamp Second */

/* Bit definition for Ethernet MAC System Time Nanoseconds Register */
#define ETH_MACSTNR_TSSS_Pos                          (0U)
#define ETH_MACSTNR_TSSS_Msk                          (0x7FFFFFFFUL << ETH_MACSTNR_TSSS_Pos) /*!< 0x7FFFFFFF */
#define ETH_MACSTNR_TSSS                              ETH_MACSTNR_TSSS_Msk  /* Timestamp Sub-seconds */

/* Bit definition for Ethernet MAC System Time Seconds Update Register */
#define ETH_MACSTSUR_TSS_Pos                          (0U)
#define ETH_MACSTSUR_TSS_Msk                          (0xFFFFFFFFUL << ETH_MACSTSUR_TSS_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACSTSUR_TSS                              ETH_MACSTSUR_TSS_Msk  /* Timestamp Seconds */

/* Bit definition for Ethernet MAC System Time Nanoseconds Update Register */
#define ETH_MACSTNUR_ADDSUB_Pos                       (31U)
#define ETH_MACSTNUR_ADDSUB_Msk                       (0x1UL << ETH_MACSTNUR_ADDSUB_Pos) /*!< 0x80000000 */
#define ETH_MACSTNUR_ADDSUB                           ETH_MACSTNUR_ADDSUB_Msk  /* Add or Subtract Time */
#define ETH_MACSTNUR_TSSS_Pos                         (0U)
#define ETH_MACSTNUR_TSSS_Msk                         (0x7FFFFFFFUL << ETH_MACSTNUR_TSSS_Pos) /*!< 0x7FFFFFFF */
#define ETH_MACSTNUR_TSSS                             ETH_MACSTNUR_TSSS_Msk  /* Timestamp Sub-seconds */

/* Bit definition for Ethernet MAC Timestamp Addend Register */
#define ETH_MACTSAR_TSAR_Pos                          (0U)
#define ETH_MACTSAR_TSAR_Msk                          (0xFFFFFFFFUL << ETH_MACTSAR_TSAR_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACTSAR_TSAR                              ETH_MACTSAR_TSAR_Msk  /* Timestamp Addend Register */

/* Bit definition for Ethernet MAC Timestamp Status Register */
#define ETH_MACTSSR_ATSNS_Pos                         (25U)
#define ETH_MACTSSR_ATSNS_Msk                         (0x1FUL << ETH_MACTSSR_ATSNS_Pos) /*!< 0x3E000000 */
#define ETH_MACTSSR_ATSNS                             ETH_MACTSSR_ATSNS_Msk  /* Number of Auxiliary Timestamp Snapshots */
#define ETH_MACTSSR_ATSSTM_Pos                        (24U)
#define ETH_MACTSSR_ATSSTM_Msk                        (0x1UL << ETH_MACTSSR_ATSSTM_Pos) /*!< 0x01000000 */
#define ETH_MACTSSR_ATSSTM                            ETH_MACTSSR_ATSSTM_Msk  /* Auxiliary Timestamp Snapshot Trigger Missed */
#define ETH_MACTSSR_ATSSTN_Pos                        (16U)
#define ETH_MACTSSR_ATSSTN_Msk                        (0xFUL << ETH_MACTSSR_ATSSTN_Pos) /*!< 0x000F0000 */
#define ETH_MACTSSR_ATSSTN                            ETH_MACTSSR_ATSSTN_Msk  /* Auxiliary Timestamp Snapshot Trigger Identifier */
#define ETH_MACTSSR_TXTSSIS_Pos                       (15U)
#define ETH_MACTSSR_TXTSSIS_Msk                       (0x1UL << ETH_MACTSSR_TXTSSIS_Pos) /*!< 0x00008000 */
#define ETH_MACTSSR_TXTSSIS                           ETH_MACTSSR_TXTSSIS_Msk  /* Tx Timestamp Status Interrupt Status */
#define ETH_MACTSSR_TSTRGTERR0_Pos                    (3U)
#define ETH_MACTSSR_TSTRGTERR0_Msk                    (0x1UL << ETH_MACTSSR_TSTRGTERR0_Pos) /*!< 0x00000008 */
#define ETH_MACTSSR_TSTRGTERR0                        ETH_MACTSSR_TSTRGTERR0_Msk  /* Timestamp Target Time Error */
#define ETH_MACTSSR_AUXTSTRIG_Pos                     (2U)
#define ETH_MACTSSR_AUXTSTRIG_Msk                     (0x1UL << ETH_MACTSSR_AUXTSTRIG_Pos) /*!< 0x00000004 */
#define ETH_MACTSSR_AUXTSTRIG                         ETH_MACTSSR_AUXTSTRIG_Msk  /* Auxiliary Timestamp Trigger Snapshot*/
#define ETH_MACTSSR_TSTARGT0_Pos                      (1U)
#define ETH_MACTSSR_TSTARGT0_Msk                      (0x1UL << ETH_MACTSSR_TSTARGT0_Pos) /*!< 0x00000002 */
#define ETH_MACTSSR_TSTARGT0                          ETH_MACTSSR_TSTARGT0_Msk  /* Timestamp Target Time Reached */
#define ETH_MACTSSR_TSSOVF_Pos                        (0U)
#define ETH_MACTSSR_TSSOVF_Msk                        (0x1UL << ETH_MACTSSR_TSSOVF_Pos) /*!< 0x00000001 */
#define ETH_MACTSSR_TSSOVF                            ETH_MACTSSR_TSSOVF_Msk  /* Timestamp Seconds Overflow */

/* Bit definition for Ethernet MAC Tx Timestamp Status Nanoseconds Register */
#define ETH_MACTTSSNR_TXTSSMIS_Pos                    (31U)
#define ETH_MACTTSSNR_TXTSSMIS_Msk                    (0x1UL << ETH_MACTTSSNR_TXTSSMIS_Pos) /*!< 0x80000000 */
#define ETH_MACTTSSNR_TXTSSMIS                        ETH_MACTTSSNR_TXTSSMIS_Msk  /* Transmit Timestamp Status Missed */
#define ETH_MACTTSSNR_TXTSSLO_Pos                     (0U)
#define ETH_MACTTSSNR_TXTSSLO_Msk                     (0x7FFFFFFFUL << ETH_MACTTSSNR_TXTSSLO_Pos) /*!< 0x7FFFFFFF */
#define ETH_MACTTSSNR_TXTSSLO                         ETH_MACTTSSNR_TXTSSLO_Msk  /* Transmit Timestamp Status Low */

/* Bit definition for Ethernet MAC Tx Timestamp Status Seconds Register */
#define ETH_MACTTSSSR_TXTSSHI_Pos                     (0U)
#define ETH_MACTTSSSR_TXTSSHI_Msk                     (0xFFFFFFFFUL << ETH_MACTTSSSR_TXTSSHI_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACTTSSSR_TXTSSHI                         ETH_MACTTSSSR_TXTSSHI_Msk  /* Transmit Timestamp Status High */

/* Bit definition for Ethernet MAC Auxiliary Control Register*/
#define ETH_MACACR_ATSEN3_Pos                         (7U)
#define ETH_MACACR_ATSEN3_Msk                         (0x1UL << ETH_MACACR_ATSEN3_Pos) /*!< 0x00000080 */
#define ETH_MACACR_ATSEN3                             ETH_MACACR_ATSEN3_Msk  /* Auxiliary Snapshot 3 Enable */
#define ETH_MACACR_ATSEN2_Pos                         (6U)
#define ETH_MACACR_ATSEN2_Msk                         (0x1UL << ETH_MACACR_ATSEN2_Pos) /*!< 0x00000040 */
#define ETH_MACACR_ATSEN2                             ETH_MACACR_ATSEN2_Msk  /* Auxiliary Snapshot 2 Enable */
#define ETH_MACACR_ATSEN1_Pos                         (5U)
#define ETH_MACACR_ATSEN1_Msk                         (0x1UL << ETH_MACACR_ATSEN1_Pos) /*!< 0x00000020 */
#define ETH_MACACR_ATSEN1                             ETH_MACACR_ATSEN1_Msk  /* Auxiliary Snapshot 1 Enable */
#define ETH_MACACR_ATSEN0_Pos                         (4U)
#define ETH_MACACR_ATSEN0_Msk                         (0x1UL << ETH_MACACR_ATSEN0_Pos) /*!< 0x00000010 */
#define ETH_MACACR_ATSEN0                             ETH_MACACR_ATSEN0_Msk  /* Auxiliary Snapshot 0 Enable */
#define ETH_MACACR_ATSFC_Pos                          (0U)
#define ETH_MACACR_ATSFC_Msk                          (0x1UL << ETH_MACACR_ATSFC_Pos) /*!< 0x00000001 */
#define ETH_MACACR_ATSFC                              ETH_MACACR_ATSFC_Msk  /* Auxiliary Snapshot FIFO Clear */

/* Bit definition for Ethernet MAC Auxiliary Timestamp Nanoseconds Register */
#define ETH_MACATSNR_AUXTSLO_Pos                      (0U)
#define ETH_MACATSNR_AUXTSLO_Msk                      (0x7FFFFFFFUL << ETH_MACATSNR_AUXTSLO_Pos) /*!< 0x7FFFFFFF */
#define ETH_MACATSNR_AUXTSLO                          ETH_MACATSNR_AUXTSLO_Msk  /* Auxiliary Timestamp */

/* Bit definition for Ethernet MAC Auxiliary Timestamp Seconds Register */
#define ETH_MACATSSR_AUXTSHI_Pos                      (0U)
#define ETH_MACATSSR_AUXTSHI_Msk                      (0xFFFFFFFFUL << ETH_MACATSSR_AUXTSHI_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACATSSR_AUXTSHI                          ETH_MACATSSR_AUXTSHI_Msk  /* Auxiliary Timestamp */

/* Bit definition for Ethernet MAC Timestamp Ingress Asymmetric Correction Register */
#define ETH_MACTSIACR_OSTIAC_Pos                      (0U)
#define ETH_MACTSIACR_OSTIAC_Msk                      (0xFFFFFFFFUL << ETH_MACTSIACR_OSTIAC_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACTSIACR_OSTIAC                          ETH_MACTSIACR_OSTIAC_Msk  /* One-Step Timestamp Ingress Asymmetry Correction */

/* Bit definition for Ethernet MAC Timestamp Egress Asymmetric Correction Register */
#define ETH_MACTSEACR_OSTEAC_Pos                      (0U)
#define ETH_MACTSEACR_OSTEAC_Msk                      (0xFFFFFFFFUL << ETH_MACTSEACR_OSTEAC_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACTSEACR_OSTEAC                          ETH_MACTSEACR_OSTEAC_Msk  /* One-Step Timestamp Egress Asymmetry Correction */

/* Bit definition for Ethernet MAC Timestamp Ingress Correction Nanosecond Register */
#define ETH_MACTSICNR_TSIC_Pos                        (0U)
#define ETH_MACTSICNR_TSIC_Msk                        (0xFFFFFFFFUL << ETH_MACTSICNR_TSIC_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACTSICNR_TSIC                            ETH_MACTSICNR_TSIC_Msk  /* Timestamp Ingress Correction */

/* Bit definition for Ethernet MAC Timestamp Egress correction Nanosecond Register */
#define ETH_MACTSECNR_TSEC_Pos                        (0U)
#define ETH_MACTSECNR_TSEC_Msk                        (0xFFFFFFFFUL << ETH_MACTSECNR_TSEC_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACTSECNR_TSEC                            ETH_MACTSECNR_TSEC_Msk  /* Timestamp Egress Correction */

/* Bit definition for Ethernet MAC PPS Control Register */
#define ETH_MACPPSCR_TRGTMODSEL0_Pos                  (5U)
#define ETH_MACPPSCR_TRGTMODSEL0_Msk                  (0x3UL << ETH_MACPPSCR_TRGTMODSEL0_Pos) /*!< 0x00000060 */
#define ETH_MACPPSCR_TRGTMODSEL0                      ETH_MACPPSCR_TRGTMODSEL0_Msk  /* Target Time Register Mode for PPS Output */
#define ETH_MACPPSCR_PPSEN0_Pos                       (4U)
#define ETH_MACPPSCR_PPSEN0_Msk                       (0x1UL << ETH_MACPPSCR_PPSEN0_Pos) /*!< 0x00000010 */
#define ETH_MACPPSCR_PPSEN0                           ETH_MACPPSCR_PPSEN0_Msk  /* Flexible PPS Output Mode Enable */
#define ETH_MACPPSCR_PPSCTRL_Pos                      (0U)
#define ETH_MACPPSCR_PPSCTRL_Msk                      (0xFUL << ETH_MACPPSCR_PPSCTRL_Pos) /*!< 0x0000000F */
#define ETH_MACPPSCR_PPSCTRL                          ETH_MACPPSCR_PPSCTRL_Msk  /* PPS Output Frequency Control */

/* Bit definition for Ethernet MAC PPS Target Time Seconds Register */
#define ETH_MACPPSTTSR_TSTRH0_Pos                     (0U)
#define ETH_MACPPSTTSR_TSTRH0_Msk                     (0xFFFFFFFFUL << ETH_MACPPSTTSR_TSTRH0_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACPPSTTSR_TSTRH0                         ETH_MACPPSTTSR_TSTRH0_Msk  /* PPS Target Time Seconds Register */

/* Bit definition for Ethernet MAC PPS Target Time Nanoseconds Register */
#define ETH_MACPPSTTNR_TRGTBUSY0_Pos                  (31U)
#define ETH_MACPPSTTNR_TRGTBUSY0_Msk                  (0x1UL << ETH_MACPPSTTNR_TRGTBUSY0_Pos) /*!< 0x80000000 */
#define ETH_MACPPSTTNR_TRGTBUSY0                      ETH_MACPPSTTNR_TRGTBUSY0_Msk  /* PPS Target Time Register Busy */
#define ETH_MACPPSTTNR_TTSL0_Pos                      (0U)
#define ETH_MACPPSTTNR_TTSL0_Msk                      (0x7FFFFFFFUL << ETH_MACPPSTTNR_TTSL0_Pos) /*!< 0x7FFFFFFF */
#define ETH_MACPPSTTNR_TTSL0                          ETH_MACPPSTTNR_TTSL0_Msk  /* Target Time Low for PPS Register */

/* Bit definition for Ethernet MAC PPS Interval Register */
#define ETH_MACPPSIR_PPSINT0_Pos                      (0U)
#define ETH_MACPPSIR_PPSINT0_Msk                      (0xFFFFFFFFUL << ETH_MACPPSIR_PPSINT0_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACPPSIR_PPSINT0                          ETH_MACPPSIR_PPSINT0_Msk  /* PPS Output Signal Interval */

/* Bit definition for Ethernet MAC PPS Width Register */
#define ETH_MACPPSWR_PPSWIDTH0_Pos                    (0U)
#define ETH_MACPPSWR_PPSWIDTH0_Msk                    (0xFFFFFFFFUL << ETH_MACPPSWR_PPSWIDTH0_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACPPSWR_PPSWIDTH0                        ETH_MACPPSWR_PPSWIDTH0_Msk  /* PPS Output Signal Width */

/* Bit definition for Ethernet MAC PTP Offload Control Register */
#define ETH_MACPOCR_DN_Pos                            (8U)
#define ETH_MACPOCR_DN_Msk                            (0xFFUL << ETH_MACPOCR_DN_Pos) /*!< 0x0000FF00 */
#define ETH_MACPOCR_DN                                ETH_MACPOCR_DN_Msk  /* Domain Number */
#define ETH_MACPOCR_DRRDIS_Pos                        (6U)
#define ETH_MACPOCR_DRRDIS_Msk                        (0x1UL << ETH_MACPOCR_DRRDIS_Pos) /*!< 0x00000040 */
#define ETH_MACPOCR_DRRDIS                            ETH_MACPOCR_DRRDIS_Msk  /* Disable PTO Delay Request/Response response generation */
#define ETH_MACPOCR_APDREQTRIG_Pos                    (5U)
#define ETH_MACPOCR_APDREQTRIG_Msk                    (0x1UL << ETH_MACPOCR_APDREQTRIG_Pos) /*!< 0x00000020 */
#define ETH_MACPOCR_APDREQTRIG                        ETH_MACPOCR_APDREQTRIG_Msk  /* Automatic PTP Pdelay_Req message Trigger */
#define ETH_MACPOCR_ASYNCTRIG_Pos                     (4U)
#define ETH_MACPOCR_ASYNCTRIG_Msk                     (0x1UL << ETH_MACPOCR_ASYNCTRIG_Pos) /*!< 0x00000010 */
#define ETH_MACPOCR_ASYNCTRIG                         ETH_MACPOCR_ASYNCTRIG_Msk  /* Automatic PTP SYNC message Trigger */
#define ETH_MACPOCR_APDREQEN_Pos                      (2U)
#define ETH_MACPOCR_APDREQEN_Msk                      (0x1UL << ETH_MACPOCR_APDREQEN_Pos) /*!< 0x00000004 */
#define ETH_MACPOCR_APDREQEN                          ETH_MACPOCR_APDREQEN_Msk  /* Automatic PTP Pdelay_Req message Enable */
#define ETH_MACPOCR_ASYNCEN_Pos                       (1U)
#define ETH_MACPOCR_ASYNCEN_Msk                       (0x1UL << ETH_MACPOCR_ASYNCEN_Pos) /*!< 0x00000002 */
#define ETH_MACPOCR_ASYNCEN                           ETH_MACPOCR_ASYNCEN_Msk  /* Automatic PTP SYNC message Enable */
#define ETH_MACPOCR_PTOEN_Pos                         (0U)
#define ETH_MACPOCR_PTOEN_Msk                         (0x1UL << ETH_MACPOCR_PTOEN_Pos) /*!< 0x00000001 */
#define ETH_MACPOCR_PTOEN                             ETH_MACPOCR_PTOEN_Msk  /* PTP Offload Enable */

/* Bit definition for Ethernet MAC PTP Source Port Identity 0 Register */
#define ETH_MACSPI0R_SPI0_Pos                         (0U)
#define ETH_MACSPI0R_SPI0_Msk                         (0xFFFFFFFFUL << ETH_MACSPI0R_SPI0_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACSPI0R_SPI0                             ETH_MACSPI0R_SPI0_Msk  /* Source Port Identity 0 */

/* Bit definition for Ethernet MAC PTP Source Port Identity 1 Register */
#define ETH_MACSPI1R_SPI1_Pos                         (0U)
#define ETH_MACSPI1R_SPI1_Msk                         (0xFFFFFFFFUL << ETH_MACSPI1R_SPI1_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACSPI1R_SPI1                             ETH_MACSPI1R_SPI1_Msk  /* Source Port Identity 1 */

/* Bit definition for Ethernet MAC PTP Source Port Identity 2 Register */
#define ETH_MACSPI2R_SPI2_Pos                         (0U)
#define ETH_MACSPI2R_SPI2_Msk                         (0xFFFFUL << ETH_MACSPI2R_SPI2_Pos) /*!< 0x0000FFFF */
#define ETH_MACSPI2R_SPI2                             ETH_MACSPI2R_SPI2_Msk  /* Source Port Identity 2 */

/* Bit definition for Ethernet MAC Log Message Interval Register */
#define ETH_MACLMIR_LMPDRI_Pos                        (24U)
#define ETH_MACLMIR_LMPDRI_Msk                        (0xFFUL << ETH_MACLMIR_LMPDRI_Pos) /*!< 0xFF000000 */
#define ETH_MACLMIR_LMPDRI                             ETH_MACLMIR_LMPDRI_Msk  /* Log Min Pdelay_Req Interval */
#define ETH_MACLMIR_DRSYNCR_Pos                       (8U)
#define ETH_MACLMIR_DRSYNCR_Msk                       (0x7UL << ETH_MACLMIR_DRSYNCR_Pos) /*!< 0x00000700 */
#define ETH_MACLMIR_DRSYNCR                           ETH_MACLMIR_DRSYNCR_Msk  /* Delay_Req to SYNC Ratio */
#define ETH_MACLMIR_LSI_Pos                           (0U)
#define ETH_MACLMIR_LSI_Msk                           (0xFFUL << ETH_MACLMIR_LSI_Pos) /*!< 0x000000FF */
#define ETH_MACLMIR_LSI                               ETH_MACLMIR_LSI_Msk  /* Log Sync Interval */

/* Bit definition for Ethernet MTL Operation Mode Register */
#define ETH_MTLOMR_CNTCLR_Pos                         (9U)
#define ETH_MTLOMR_CNTCLR_Msk                         (0x1UL << ETH_MTLOMR_CNTCLR_Pos) /*!< 0x00000200 */
#define ETH_MTLOMR_CNTCLR                             ETH_MTLOMR_CNTCLR_Msk    /* Counters Reset */
#define ETH_MTLOMR_CNTPRST_Pos                        (8U)
#define ETH_MTLOMR_CNTPRST_Msk                        (0x1UL << ETH_MTLOMR_CNTPRST_Pos) /*!< 0x00000100 */
#define ETH_MTLOMR_CNTPRST                            ETH_MTLOMR_CNTPRST_Msk   /* Counters Preset */
#define ETH_MTLOMR_DTXSTS_Pos                         (1U)
#define ETH_MTLOMR_DTXSTS_Msk                         (0x1UL << ETH_MTLOMR_DTXSTS_Pos) /*!< 0x00000002 */
#define ETH_MTLOMR_DTXSTS                             ETH_MTLOMR_DTXSTS_Msk  /* Drop Transmit Status */

/* Bit definition for Ethernet MTL Interrupt Status Register */
#define ETH_MTLISR_MACIS_Pos                          (16U)
#define ETH_MTLISR_MACIS_Msk                          (0x1UL << ETH_MTLISR_MACIS_Pos) /*!< 0x00010000 */
#define ETH_MTLISR_MACIS                              ETH_MTLISR_MACIS_Msk     /* MAC Interrupt Status */
#define ETH_MTLISR_QIS_Pos                            (0U)
#define ETH_MTLISR_QIS_Msk                            (0x1UL << ETH_MTLISR_QIS_Pos) /*!< 0x00000001 */
#define ETH_MTLISR_QIS                                ETH_MTLISR_QIS_Msk       /* Queue Interrupt status */

/* Bit definition for Ethernet MTL Tx Queue Operation Mode Register */
#define ETH_MTLTQOMR_TTC_Pos                          (4U)
#define ETH_MTLTQOMR_TTC_Msk                          (0x7UL << ETH_MTLTQOMR_TTC_Pos) /*!< 0x00000070 */
#define ETH_MTLTQOMR_TTC                              ETH_MTLTQOMR_TTC_Msk     /* Transmit Threshold Control */
#define ETH_MTLTQOMR_TTC_32BITS                       ((uint32_t)0x00000000)   /* 32 bits Threshold */
#define ETH_MTLTQOMR_TTC_64BITS                       ((uint32_t)0x00000010)   /* 64  bits Threshold */
#define ETH_MTLTQOMR_TTC_96BITS                       ((uint32_t)0x00000020)   /* 96 bits Threshold */
#define ETH_MTLTQOMR_TTC_128BITS                      ((uint32_t)0x00000030)   /* 128 bits Threshold */
#define ETH_MTLTQOMR_TTC_192BITS                      ((uint32_t)0x00000040)   /* 192 bits Threshold */
#define ETH_MTLTQOMR_TTC_256BITS                      ((uint32_t)0x00000050)   /* 256 bits Threshold */
#define ETH_MTLTQOMR_TTC_384BITS                      ((uint32_t)0x00000060)   /* 384 bits Threshold */
#define ETH_MTLTQOMR_TTC_512BITS                      ((uint32_t)0x00000070)   /* 512 bits Threshold */
#define ETH_MTLTQOMR_TSF_Pos                          (1U)
#define ETH_MTLTQOMR_TSF_Msk                          (0x1UL << ETH_MTLTQOMR_TSF_Pos) /*!< 0x00000002 */
#define ETH_MTLTQOMR_TSF                              ETH_MTLTQOMR_TSF_Msk     /* Transmit Store and Forward */
#define ETH_MTLTQOMR_FTQ_Pos                          (0U)
#define ETH_MTLTQOMR_FTQ_Msk                          (0x1UL << ETH_MTLTQOMR_FTQ_Pos) /*!< 0x00000001 */
#define ETH_MTLTQOMR_FTQ                              ETH_MTLTQOMR_FTQ_Msk     /* Flush Transmit Queue */

/* Bit definition for Ethernet MTL Tx Queue Underflow Register */
#define ETH_MTLTQUR_UFCNTOVF_Pos                      (11U)
#define ETH_MTLTQUR_UFCNTOVF_Msk                      (0x1UL << ETH_MTLTQUR_UFCNTOVF_Pos) /*!< 0x00000800 */
#define ETH_MTLTQUR_UFCNTOVF                          ETH_MTLTQUR_UFCNTOVF_Msk /* Overflow Bit for Underflow Packet Counter */
#define ETH_MTLTQUR_UFPKTCNT_Pos                      (0U)
#define ETH_MTLTQUR_UFPKTCNT_Msk                      (0x7FFUL << ETH_MTLTQUR_UFPKTCNT_Pos) /*!< 0x000007FF */
#define ETH_MTLTQUR_UFPKTCNT                          ETH_MTLTQUR_UFPKTCNT_Msk /* Underflow Packet Counter */

/* Bit definition for Ethernet MTL Tx Queue Debug Register */
#define ETH_MTLTQDR_STXSTSF_Pos                       (20U)
#define ETH_MTLTQDR_STXSTSF_Msk                       (0x7UL << ETH_MTLTQDR_STXSTSF_Pos) /*!< 0x00700000 */
#define ETH_MTLTQDR_STXSTSF                           ETH_MTLTQDR_STXSTSF_Msk  /* Number of Status Words in the Tx Status FIFO of Queue */
#define ETH_MTLTQDR_PTXQ_Pos                          (16U)
#define ETH_MTLTQDR_PTXQ_Msk                          (0x7UL << ETH_MTLTQDR_PTXQ_Pos) /*!< 0x00070000 */
#define ETH_MTLTQDR_PTXQ                              ETH_MTLTQDR_PTXQ_Msk     /* Number of Packets in the Transmit Queue */
#define ETH_MTLTQDR_TXSTSFSTS_Pos                     (5U)
#define ETH_MTLTQDR_TXSTSFSTS_Msk                     (0x1UL << ETH_MTLTQDR_TXSTSFSTS_Pos) /*!< 0x00000020 */
#define ETH_MTLTQDR_TXSTSFSTS                         ETH_MTLTQDR_TXSTSFSTS_Msk /* MTL Tx Status FIFO Full Status */
#define ETH_MTLTQDR_TXQSTS_Pos                        (4U)
#define ETH_MTLTQDR_TXQSTS_Msk                        (0x1UL << ETH_MTLTQDR_TXQSTS_Pos) /*!< 0x00000010 */
#define ETH_MTLTQDR_TXQSTS                            ETH_MTLTQDR_TXQSTS_Msk   /* MTL Tx Queue Not Empty Status */
#define ETH_MTLTQDR_TWCSTS_Pos                        (3U)
#define ETH_MTLTQDR_TWCSTS_Msk                        (0x1UL << ETH_MTLTQDR_TWCSTS_Pos) /*!< 0x00000008 */
#define ETH_MTLTQDR_TWCSTS                            ETH_MTLTQDR_TWCSTS_Msk   /* MTL Tx Queue Write Controller Status */
#define ETH_MTLTQDR_TRCSTS_Pos                        (1U)
#define ETH_MTLTQDR_TRCSTS_Msk                        (0x3UL << ETH_MTLTQDR_TRCSTS_Pos) /*!< 0x00000006 */
#define ETH_MTLTQDR_TRCSTS                            ETH_MTLTQDR_TRCSTS_Msk  /* MTL Tx Queue Read Controller Status */
#define ETH_MTLTQDR_TRCSTS_IDLE                       ((uint32_t)0x00000000)  /* Idle state */
#define ETH_MTLTQDR_TRCSTS_READ                       ((uint32_t)0x00000002)  /* Read state (transferring data to the MAC transmitter) */
#define ETH_MTLTQDR_TRCSTS_WAITING                    ((uint32_t)0x00000004)  /* Waiting for pending Tx Status from the MAC transmitter */
#define ETH_MTLTQDR_TRCSTS_FLUSHING                   ((uint32_t)0x00000006)  /* Flushing the Tx queue because of the Packet Abort request from the MAC */
#define ETH_MTLTQDR_TXQPAUSED_Pos                     (0U)
#define ETH_MTLTQDR_TXQPAUSED_Msk                     (0x1UL << ETH_MTLTQDR_TXQPAUSED_Pos) /*!< 0x00000001 */
#define ETH_MTLTQDR_TXQPAUSED                         ETH_MTLTQDR_TXQPAUSED_Msk /* Transmit Queue in Pause */

/* Bit definition for Ethernet MTL Queue Interrupt Control Status Register */
#define ETH_MTLQICSR_RXOIE_Pos                        (24U)
#define ETH_MTLQICSR_RXOIE_Msk                        (0x1UL << ETH_MTLQICSR_RXOIE_Pos) /*!< 0x01000000 */
#define ETH_MTLQICSR_RXOIE                            ETH_MTLQICSR_RXOIE_Msk   /* Receive Queue Overflow Interrupt Enable */
#define ETH_MTLQICSR_RXOVFIS_Pos                      (16U)
#define ETH_MTLQICSR_RXOVFIS_Msk                      (0x1UL << ETH_MTLQICSR_RXOVFIS_Pos) /*!< 0x00010000 */
#define ETH_MTLQICSR_RXOVFIS                          ETH_MTLQICSR_RXOVFIS_Msk /* Receive Queue Overflow Interrupt Status */
#define ETH_MTLQICSR_TXUIE_Pos                        (8U)
#define ETH_MTLQICSR_TXUIE_Msk                        (0x1UL << ETH_MTLQICSR_TXUIE_Pos) /*!< 0x00000100 */
#define ETH_MTLQICSR_TXUIE                            ETH_MTLQICSR_TXUIE_Msk   /* Transmit Queue Underflow Interrupt Enable */
#define ETH_MTLQICSR_TXUNFIS_Pos                      (0U)
#define ETH_MTLQICSR_TXUNFIS_Msk                      (0x1UL << ETH_MTLQICSR_TXUNFIS_Pos) /*!< 0x00000001 */
#define ETH_MTLQICSR_TXUNFIS                          ETH_MTLQICSR_TXUNFIS_Msk /* Transmit Queue Underflow Interrupt Status */

/* Bit definition for Ethernet MTL Rx Queue Operation Mode Register */
#define ETH_MTLRQOMR_RQS_Pos                          (20U)
#define ETH_MTLRQOMR_RQS_Msk                          (0x7UL << ETH_MTLRQOMR_RQS_Pos) /*!< 0x00700000 */
#define ETH_MTLRQOMR_RQS                              ETH_MTLRQOMR_RQS_Msk /* Receive Queue Size */
#define ETH_MTLRQOMR_RFD_Pos                          (14U)
#define ETH_MTLRQOMR_RFD_Msk                          (0x7UL << ETH_MTLRQOMR_RFD_Pos) /*!< 0x0001C000 */
#define ETH_MTLRQOMR_RFD                              ETH_MTLRQOMR_RFD_Msk /* Threshold for Deactivating Flow Control (in half-duplex and full-duplex modes) */
#define ETH_MTLRQOMR_RFA_Pos                          (8U)
#define ETH_MTLRQOMR_RFA_Msk                          (0x7UL << ETH_MTLRQOMR_RFA_Pos) /*!< 0x00000700 */
#define ETH_MTLRQOMR_RFA                              ETH_MTLRQOMR_RFA_Msk /* Threshold for Activating Flow Control (in half-duplex and full-duplex */
#define ETH_MTLRQOMR_EHFC_Pos                         (7U)
#define ETH_MTLRQOMR_EHFC_Msk                         (0x1UL << ETH_MTLRQOMR_EHFC_Pos) /*!< 0x00000080 */
#define ETH_MTLRQOMR_EHFC                             ETH_MTLRQOMR_EHFC_Msk /* DEnable Hardware Flow Control */
#define ETH_MTLRQOMR_DISTCPEF_Pos                     (6U)
#define ETH_MTLRQOMR_DISTCPEF_Msk                     (0x1UL << ETH_MTLRQOMR_DISTCPEF_Pos) /*!< 0x00000040 */
#define ETH_MTLRQOMR_DISTCPEF                         ETH_MTLRQOMR_DISTCPEF_Msk /* Disable Dropping of TCP/IP Checksum Error Packets */
#define ETH_MTLRQOMR_RSF_Pos                          (5U)
#define ETH_MTLRQOMR_RSF_Msk                          (0x1UL << ETH_MTLRQOMR_RSF_Pos) /*!< 0x00000020 */
#define ETH_MTLRQOMR_RSF                              ETH_MTLRQOMR_RSF_Msk     /* Receive Queue Store and Forward */
#define ETH_MTLRQOMR_FEP_Pos                          (4U)
#define ETH_MTLRQOMR_FEP_Msk                          (0x1UL << ETH_MTLRQOMR_FEP_Pos) /*!< 0x00000010 */
#define ETH_MTLRQOMR_FEP                              ETH_MTLRQOMR_FEP_Msk     /* Forward Error Packets */
#define ETH_MTLRQOMR_FUP_Pos                          (3U)
#define ETH_MTLRQOMR_FUP_Msk                          (0x1UL << ETH_MTLRQOMR_FUP_Pos) /*!< 0x00000008 */
#define ETH_MTLRQOMR_FUP                              ETH_MTLRQOMR_FUP_Msk     /* Forward Undersized Good Packets */
#define ETH_MTLRQOMR_RTC_Pos                          (0U)
#define ETH_MTLRQOMR_RTC_Msk                          (0x3UL << ETH_MTLRQOMR_RTC_Pos) /*!< 0x00000003 */
#define ETH_MTLRQOMR_RTC                              ETH_MTLRQOMR_RTC_Msk     /* Receive Queue Threshold Control */
#define ETH_MTLRQOMR_RTC_64BITS                       ((uint32_t)0x00000000)   /* 64 bits Threshold */
#define ETH_MTLRQOMR_RTC_32BITS                       ((uint32_t)0x00000001)   /* 32 bits Threshold */
#define ETH_MTLRQOMR_RTC_96BITS                       ((uint32_t)0x00000002)   /* 96 bits Threshold */
#define ETH_MTLRQOMR_RTC_128BITS                      ((uint32_t)0x00000003)   /* 128 bits Threshold */

/* Bit definition for Ethernet MTL Rx Queue Missed Packet Overflow Cnt Register */
#define ETH_MTLRQMPOCR_MISCNTOVF_Pos                  (27U)
#define ETH_MTLRQMPOCR_MISCNTOVF_Msk                  (0x1UL << ETH_MTLRQMPOCR_MISCNTOVF_Pos) /*!< 0x08000000 */
#define ETH_MTLRQMPOCR_MISCNTOVF                      ETH_MTLRQMPOCR_MISCNTOVF_Msk /* Missed Packet Counter Overflow Bit */
#define ETH_MTLRQMPOCR_MISPKTCNT_Pos                  (16U)
#define ETH_MTLRQMPOCR_MISPKTCNT_Msk                  (0x7FFUL << ETH_MTLRQMPOCR_MISPKTCNT_Pos) /*!< 0x07FF0000 */
#define ETH_MTLRQMPOCR_MISPKTCNT                      ETH_MTLRQMPOCR_MISPKTCNT_Msk /* Missed Packet Counter */
#define ETH_MTLRQMPOCR_OVFCNTOVF_Pos                  (11U)
#define ETH_MTLRQMPOCR_OVFCNTOVF_Msk                  (0x1UL << ETH_MTLRQMPOCR_OVFCNTOVF_Pos) /*!< 0x00000800 */
#define ETH_MTLRQMPOCR_OVFCNTOVF                      ETH_MTLRQMPOCR_OVFCNTOVF_Msk /* Overflow Counter Overflow Bit */
#define ETH_MTLRQMPOCR_OVFPKTCNT_Pos                  (0U)
#define ETH_MTLRQMPOCR_OVFPKTCNT_Msk                  (0x7FFUL << ETH_MTLRQMPOCR_OVFPKTCNT_Pos) /*!< 0x000007FF */
#define ETH_MTLRQMPOCR_OVFPKTCNT                      ETH_MTLRQMPOCR_OVFPKTCNT_Msk /* Overflow Packet Counter */

/* Bit definition for Ethernet MTL Rx Queue Debug Register */
#define ETH_MTLRQDR_PRXQ_Pos                          (16U)
#define ETH_MTLRQDR_PRXQ_Msk                          (0x3FFFUL << ETH_MTLRQDR_PRXQ_Pos) /*!< 0x3FFF0000 */
#define ETH_MTLRQDR_PRXQ                              ETH_MTLRQDR_PRXQ_Msk     /* Number of Packets in Receive Queue */
#define ETH_MTLRQDR_RXQSTS_Pos                        (4U)
#define ETH_MTLRQDR_RXQSTS_Msk                        (0x3UL << ETH_MTLRQDR_RXQSTS_Pos) /*!< 0x00000030 */
#define ETH_MTLRQDR_RXQSTS                            ETH_MTLRQDR_RXQSTS_Msk   /* MTL Rx Queue Fill-Level Status */
#define ETH_MTLRQDR_RXQSTS_EMPTY                      ((uint32_t)0x00000000)   /* Rx Queue empty */
#define ETH_MTLRQDR_RXQSTS_BELOWTHRESHOLD_Pos         (4U)
#define ETH_MTLRQDR_RXQSTS_BELOWTHRESHOLD_Msk         (0x1UL << ETH_MTLRQDR_RXQSTS_BELOWTHRESHOLD_Pos) /*!< 0x00000010 */
#define ETH_MTLRQDR_RXQSTS_BELOWTHRESHOLD             ETH_MTLRQDR_RXQSTS_BELOWTHRESHOLD_Msk /* Rx Queue fill-level below flow-control deactivate threshold */
#define ETH_MTLRQDR_RXQSTS_ABOVETHRESHOLD_Pos         (5U)
#define ETH_MTLRQDR_RXQSTS_ABOVETHRESHOLD_Msk         (0x1UL << ETH_MTLRQDR_RXQSTS_ABOVETHRESHOLD_Pos) /*!< 0x00000020 */
#define ETH_MTLRQDR_RXQSTS_ABOVETHRESHOLD             ETH_MTLRQDR_RXQSTS_ABOVETHRESHOLD_Msk /* Rx Queue fill-level above flow-control activate threshold */
#define ETH_MTLRQDR_RXQSTS_FULL_Pos                   (4U)
#define ETH_MTLRQDR_RXQSTS_FULL_Msk                   (0x3UL << ETH_MTLRQDR_RXQSTS_FULL_Pos) /*!< 0x00000030 */
#define ETH_MTLRQDR_RXQSTS_FULL                       ETH_MTLRQDR_RXQSTS_FULL_Msk /* Rx Queue full */
#define ETH_MTLRQDR_RRCSTS_Pos                        (1U)
#define ETH_MTLRQDR_RRCSTS_Msk                        (0x3UL << ETH_MTLRQDR_RRCSTS_Pos) /*!< 0x00000006 */
#define ETH_MTLRQDR_RRCSTS                            ETH_MTLRQDR_RRCSTS_Msk   /* MTL Rx Queue Read Controller State */
#define ETH_MTLRQDR_RRCSTS_IDLE                       ((uint32_t)0x00000000)   /* Idle state */
#define ETH_MTLRQDR_RRCSTS_READINGDATA_Pos            (1U)
#define ETH_MTLRQDR_RRCSTS_READINGDATA_Msk            (0x1UL << ETH_MTLRQDR_RRCSTS_READINGDATA_Pos) /*!< 0x00000002 */
#define ETH_MTLRQDR_RRCSTS_READINGDATA                ETH_MTLRQDR_RRCSTS_READINGDATA_Msk /* Reading packet data */
#define ETH_MTLRQDR_RRCSTS_READINGSTATUS_Pos          (2U)
#define ETH_MTLRQDR_RRCSTS_READINGSTATUS_Msk          (0x1UL << ETH_MTLRQDR_RRCSTS_READINGSTATUS_Pos) /*!< 0x00000004 */
#define ETH_MTLRQDR_RRCSTS_READINGSTATUS              ETH_MTLRQDR_RRCSTS_READINGSTATUS_Msk /* Reading packet status (or timestamp) */
#define ETH_MTLRQDR_RRCSTS_FLUSHING_Pos               (1U)
#define ETH_MTLRQDR_RRCSTS_FLUSHING_Msk               (0x3UL << ETH_MTLRQDR_RRCSTS_FLUSHING_Pos) /*!< 0x00000006 */
#define ETH_MTLRQDR_RRCSTS_FLUSHING                   ETH_MTLRQDR_RRCSTS_FLUSHING_Msk /* Flushing the packet data and status */
#define ETH_MTLRQDR_RWCSTS_Pos                        (0U)
#define ETH_MTLRQDR_RWCSTS_Msk                        (0x1UL << ETH_MTLRQDR_RWCSTS_Pos) /*!< 0x00000001 */
#define ETH_MTLRQDR_RWCSTS                            ETH_MTLRQDR_RWCSTS_Msk   /* MTL Rx Queue Write Controller Active Status */

/* Bit definition for Ethernet MTL Rx Queue Control Register */
#define ETH_MTLRQCR_RQPA_Pos                          (3U)
#define ETH_MTLRQCR_RQPA_Msk                          (0x1UL << ETH_MTLRQCR_RQPA_Pos) /*!< 0x00000008 */
#define ETH_MTLRQCR_RQPA                              ETH_MTLRQCR_RQPA_Msk     /* Receive Queue Packet Arbitration */
#define ETH_MTLRQCR_RQW_Pos                           (0U)
#define ETH_MTLRQCR_RQW_Msk                           (0x7UL << ETH_MTLRQCR_RQW_Pos) /*!< 0x00000007 */
#define ETH_MTLRQCR_RQW                               ETH_MTLRQCR_RQW_Msk      /* Receive Queue Weight */

/* Bit definition for Ethernet DMA Mode Register */
#define ETH_DMAMR_INTM_Pos                            (16U)
#define ETH_DMAMR_INTM_Msk                            (0x3UL << ETH_DMAMR_INTM_Pos) /*!< 0x00030000 */
#define ETH_DMAMR_INTM                                ETH_DMAMR_INTM_Msk       /* This field defines the interrupt mode */
#define ETH_DMAMR_INTM_0                              (0x0UL << ETH_DMAMR_INTM_Pos) /*!< 0x00000000 */
#define ETH_DMAMR_INTM_1                              (0x1UL << ETH_DMAMR_INTM_Pos) /*!< 0x00010000 */
#define ETH_DMAMR_INTM_2                              (0x2UL << ETH_DMAMR_INTM_Pos) /*!< 0x00020000 */
#define ETH_DMAMR_PR_Pos                              (12U)
#define ETH_DMAMR_PR_Msk                              (0x7UL << ETH_DMAMR_PR_Pos) /*!< 0x00007000 */
#define ETH_DMAMR_PR                                  ETH_DMAMR_PR_Msk         /* Priority Ratio */
#define ETH_DMAMR_PR_1_1                              ((uint32_t)0x00000000)   /* The priority ratio is 1:1 */
#define ETH_DMAMR_PR_2_1                              ((uint32_t)0x00001000)   /* The priority ratio is 2:1 */
#define ETH_DMAMR_PR_3_1                              ((uint32_t)0x00002000)   /* The priority ratio is 3:1 */
#define ETH_DMAMR_PR_4_1                              ((uint32_t)0x00003000)   /* The priority ratio is 4:1 */
#define ETH_DMAMR_PR_5_1                              ((uint32_t)0x00004000)   /* The priority ratio is 5:1 */
#define ETH_DMAMR_PR_6_1                              ((uint32_t)0x00005000)   /* The priority ratio is 6:1 */
#define ETH_DMAMR_PR_7_1                              ((uint32_t)0x00006000)   /* The priority ratio is 7:1 */
#define ETH_DMAMR_PR_8_1                              ((uint32_t)0x00007000)   /* The priority ratio is 8:1 */
#define ETH_DMAMR_TXPR_Pos                            (11U)
#define ETH_DMAMR_TXPR_Msk                            (0x1UL << ETH_DMAMR_TXPR_Pos) /*!< 0x00000800 */
#define ETH_DMAMR_TXPR                                ETH_DMAMR_TXPR_Msk       /* Transmit Priority */
#define ETH_DMAMR_DA_Pos                              (1U)
#define ETH_DMAMR_DA_Msk                              (0x1UL << ETH_DMAMR_DA_Pos) /*!< 0x00000002 */
#define ETH_DMAMR_DA                                  ETH_DMAMR_DA_Msk         /* DMA Tx or Rx Arbitration Scheme */
#define ETH_DMAMR_SWR_Pos                             (0U)
#define ETH_DMAMR_SWR_Msk                             (0x1UL << ETH_DMAMR_SWR_Pos) /*!< 0x00000001 */
#define ETH_DMAMR_SWR                                 ETH_DMAMR_SWR_Msk        /* Software Reset */

/* Bit definition for Ethernet DMA SysBus Mode Register */
#define ETH_DMASBMR_RB_Pos                            (15U)
#define ETH_DMASBMR_RB_Msk                            (0x1UL << ETH_DMASBMR_RB_Pos) /*!< 0x00008000 */
#define ETH_DMASBMR_RB                                ETH_DMASBMR_RB_Msk       /* Rebuild INCRx Burst */
#define ETH_DMASBMR_MB_Pos                            (14U)
#define ETH_DMASBMR_MB_Msk                            (0x1UL << ETH_DMASBMR_MB_Pos) /*!< 0x00004000 */
#define ETH_DMASBMR_MB                                ETH_DMASBMR_MB_Msk       /* Mixed Burst */
#define ETH_DMASBMR_AAL_Pos                           (12U)
#define ETH_DMASBMR_AAL_Msk                           (0x1UL << ETH_DMASBMR_AAL_Pos) /*!< 0x00001000 */
#define ETH_DMASBMR_AAL                               ETH_DMASBMR_AAL_Msk      /* Address-Aligned Beats */
#define ETH_DMASBMR_FB_Pos                            (0U)
#define ETH_DMASBMR_FB_Msk                            (0x1UL << ETH_DMASBMR_FB_Pos) /*!< 0x00000001 */
#define ETH_DMASBMR_FB                                ETH_DMASBMR_FB_Msk       /* Fixed Burst Length */

/* Bit definition for Ethernet DMA Interrupt Status Register */
#define ETH_DMAISR_MACIS_Pos                          (17U)
#define ETH_DMAISR_MACIS_Msk                          (0x1UL << ETH_DMAISR_MACIS_Pos) /*!< 0x00020000 */
#define ETH_DMAISR_MACIS                              ETH_DMAISR_MACIS_Msk     /* MAC Interrupt Status */
#define ETH_DMAISR_MTLIS_Pos                          (16U)
#define ETH_DMAISR_MTLIS_Msk                          (0x1UL << ETH_DMAISR_MTLIS_Pos) /*!< 0x00010000 */
#define ETH_DMAISR_MTLIS                              ETH_DMAISR_MTLIS_Msk     /* MAC Interrupt Status */
#define ETH_DMAISR_DMACIS_Pos                         (0U)
#define ETH_DMAISR_DMACIS_Msk                         (0x1UL << ETH_DMAISR_DMACIS_Pos) /*!< 0x00000001 */
#define ETH_DMAISR_DMACIS                             ETH_DMAISR_DMACIS_Msk    /* DMA Channel Interrupt Status */

/* Bit definition for Ethernet DMA Debug Status Register */
#define ETH_DMADSR_TPS_Pos                            (12U)
#define ETH_DMADSR_TPS_Msk                            (0xFUL << ETH_DMADSR_TPS_Pos) /*!< 0x0000F000 */
#define ETH_DMADSR_TPS                                ETH_DMADSR_TPS_Msk       /* DMA Channel Transmit Process State */
#define ETH_DMADSR_TPS_STOPPED                        ((uint32_t)0x00000000)   /* Stopped (Reset or Stop Transmit Command issued) */
#define ETH_DMADSR_TPS_FETCHING_Pos                   (12U)
#define ETH_DMADSR_TPS_FETCHING_Msk                   (0x1UL << ETH_DMADSR_TPS_FETCHING_Pos) /*!< 0x00001000 */
#define ETH_DMADSR_TPS_FETCHING                       ETH_DMADSR_TPS_FETCHING_Msk /* Running (Fetching Tx Transfer Descriptor) */
#define ETH_DMADSR_TPS_WAITING_Pos                    (13U)
#define ETH_DMADSR_TPS_WAITING_Msk                    (0x1UL << ETH_DMADSR_TPS_WAITING_Pos) /*!< 0x00002000 */
#define ETH_DMADSR_TPS_WAITING                        ETH_DMADSR_TPS_WAITING_Msk /* Running (Waiting for status) */
#define ETH_DMADSR_TPS_READING_Pos                    (12U)
#define ETH_DMADSR_TPS_READING_Msk                    (0x3UL << ETH_DMADSR_TPS_READING_Pos) /*!< 0x00003000 */
#define ETH_DMADSR_TPS_READING                        ETH_DMADSR_TPS_READING_Msk /* Running (Reading Data from system memory buffer and queuing it to the Tx buffer (Tx FIFO)) */
#define ETH_DMADSR_TPS_TIMESTAMP_WR_Pos               (14U)
#define ETH_DMADSR_TPS_TIMESTAMP_WR_Msk               (0x1UL << ETH_DMADSR_TPS_TIMESTAMP_WR_Pos) /*!< 0x00004000 */
#define ETH_DMADSR_TPS_TIMESTAMP_WR                   ETH_DMADSR_TPS_TIMESTAMP_WR_Msk /* Timestamp write state */
#define ETH_DMADSR_TPS_SUSPENDED_Pos                  (13U)
#define ETH_DMADSR_TPS_SUSPENDED_Msk                  (0x3UL << ETH_DMADSR_TPS_SUSPENDED_Pos) /*!< 0x00006000 */
#define ETH_DMADSR_TPS_SUSPENDED                      ETH_DMADSR_TPS_SUSPENDED_Msk /* Suspended (Tx Descriptor Unavailable or Tx Buffer Underflow) */
#define ETH_DMADSR_TPS_CLOSING_Pos                    (12U)
#define ETH_DMADSR_TPS_CLOSING_Msk                    (0x7UL << ETH_DMADSR_TPS_CLOSING_Pos) /*!< 0x00007000 */
#define ETH_DMADSR_TPS_CLOSING                        ETH_DMADSR_TPS_CLOSING_Msk /* Running (Closing Tx Descriptor) */
#define ETH_DMADSR_RPS_Pos                            (8U)
#define ETH_DMADSR_RPS_Msk                            (0xFUL << ETH_DMADSR_RPS_Pos) /*!< 0x00000F00 */
#define ETH_DMADSR_RPS                                ETH_DMADSR_RPS_Msk       /* DMA Channel Receive Process State */
#define ETH_DMADSR_RPS_STOPPED                        ((uint32_t)0x00000000)   /* Stopped (Reset or Stop Receive Command issued) */
#define ETH_DMADSR_RPS_FETCHING_Pos                   (12U)
#define ETH_DMADSR_RPS_FETCHING_Msk                   (0x1UL << ETH_DMADSR_RPS_FETCHING_Pos) /*!< 0x00001000 */
#define ETH_DMADSR_RPS_FETCHING                       ETH_DMADSR_RPS_FETCHING_Msk /* Running (Fetching Rx Transfer Descriptor) */
#define ETH_DMADSR_RPS_WAITING_Pos                    (12U)
#define ETH_DMADSR_RPS_WAITING_Msk                    (0x3UL << ETH_DMADSR_RPS_WAITING_Pos) /*!< 0x00003000 */
#define ETH_DMADSR_RPS_WAITING                        ETH_DMADSR_RPS_WAITING_Msk /* Running (Waiting for status) */
#define ETH_DMADSR_RPS_SUSPENDED_Pos                  (14U)
#define ETH_DMADSR_RPS_SUSPENDED_Msk                  (0x1UL << ETH_DMADSR_RPS_SUSPENDED_Pos) /*!< 0x00004000 */
#define ETH_DMADSR_RPS_SUSPENDED                      ETH_DMADSR_RPS_SUSPENDED_Msk /* Suspended (Rx Descriptor Unavailable) */
#define ETH_DMADSR_RPS_CLOSING_Pos                    (12U)
#define ETH_DMADSR_RPS_CLOSING_Msk                    (0x5UL << ETH_DMADSR_RPS_CLOSING_Pos) /*!< 0x00005000 */
#define ETH_DMADSR_RPS_CLOSING                        ETH_DMADSR_RPS_CLOSING_Msk /* Running (Closing the Rx Descriptor) */
#define ETH_DMADSR_RPS_TIMESTAMP_WR_Pos               (13U)
#define ETH_DMADSR_RPS_TIMESTAMP_WR_Msk               (0x3UL << ETH_DMADSR_RPS_TIMESTAMP_WR_Pos) /*!< 0x00006000 */
#define ETH_DMADSR_RPS_TIMESTAMP_WR                   ETH_DMADSR_RPS_TIMESTAMP_WR_Msk /* Timestamp write state */
#define ETH_DMADSR_RPS_TRANSFERRING_Pos               (12U)
#define ETH_DMADSR_RPS_TRANSFERRING_Msk               (0x7UL << ETH_DMADSR_RPS_TRANSFERRING_Pos) /*!< 0x00007000 */
#define ETH_DMADSR_RPS_TRANSFERRING                   ETH_DMADSR_RPS_TRANSFERRING_Msk /* Running (Transferring the received packet data from the Rx buffer to the system memory) */

/* Bit definition for Ethernet DMA Channel Control Register */
#define ETH_DMACCR_DSL_Pos                            (18U)
#define ETH_DMACCR_DSL_Msk                            (0x7UL << ETH_DMACCR_DSL_Pos) /*!< 0x001C0000 */
#define ETH_DMACCR_DSL                                ETH_DMACCR_DSL_Msk       /* Descriptor Skip Length */
#define ETH_DMACCR_DSL_0BIT                           ((uint32_t)0x00000000)
#define ETH_DMACCR_DSL_32BIT                          ((uint32_t)0x00040000)
#define ETH_DMACCR_DSL_64BIT                          ((uint32_t)0x00080000)
#define ETH_DMACCR_DSL_128BIT                         ((uint32_t)0x00100000)
#define ETH_DMACCR_8PBL                               ((uint32_t)0x00010000)   /* 8xPBL mode */
#define ETH_DMACCR_MSS_Pos                            (0U)
#define ETH_DMACCR_MSS_Msk                            (0x3FFFUL << ETH_DMACCR_MSS_Pos) /*!< 0x00003FFF */
#define ETH_DMACCR_MSS                                ETH_DMACCR_MSS_Msk       /* Maximum Segment Size */

/* Bit definition for Ethernet DMA Channel Tx Control Register */
#define ETH_DMACTCR_TPBL_Pos                          (16U)
#define ETH_DMACTCR_TPBL_Msk                          (0x3FUL << ETH_DMACTCR_TPBL_Pos) /*!< 0x003F0000 */
#define ETH_DMACTCR_TPBL                              ETH_DMACTCR_TPBL_Msk     /* Transmit Programmable Burst Length */
#define ETH_DMACTCR_TPBL_1PBL                         ((uint32_t)0x00010000)   /* Transmit Programmable Burst Length 1 */
#define ETH_DMACTCR_TPBL_2PBL                         ((uint32_t)0x00020000)   /* Transmit Programmable Burst Length 2 */
#define ETH_DMACTCR_TPBL_4PBL                         ((uint32_t)0x00040000)   /* Transmit Programmable Burst Length 4 */
#define ETH_DMACTCR_TPBL_8PBL                         ((uint32_t)0x00080000)   /* Transmit Programmable Burst Length 8 */
#define ETH_DMACTCR_TPBL_16PBL                        ((uint32_t)0x00100000)   /* Transmit Programmable Burst Length 16 */
#define ETH_DMACTCR_TPBL_32PBL                        ((uint32_t)0x00200000)   /* Transmit Programmable Burst Length 32 */
#define ETH_DMACTCR_TSE_Pos                           (12U)
#define ETH_DMACTCR_TSE_Msk                           (0x1UL << ETH_DMACTCR_TSE_Pos) /*!< 0x00001000 */
#define ETH_DMACTCR_TSE                               ETH_DMACTCR_TSE_Msk      /* TCP Segmentation Enabled */
#define ETH_DMACTCR_OSP_Pos                           (4U)
#define ETH_DMACTCR_OSP_Msk                           (0x1UL << ETH_DMACTCR_OSP_Pos) /*!< 0x00000010 */
#define ETH_DMACTCR_OSP                               ETH_DMACTCR_OSP_Msk      /* Operate on Second Packet */
#define ETH_DMACTCR_ST_Pos                            (0U)
#define ETH_DMACTCR_ST_Msk                            (0x1UL << ETH_DMACTCR_ST_Pos) /*!< 0x00000001 */
#define ETH_DMACTCR_ST                                ETH_DMACTCR_ST_Msk       /* Start or Stop Transmission Command */

/* Bit definition for Ethernet DMA Channel Rx Control Register */
#define ETH_DMACRCR_RPF_Pos                           (31U)
#define ETH_DMACRCR_RPF_Msk                           (0x1UL << ETH_DMACRCR_RPF_Pos) /*!< 0x80000000 */
#define ETH_DMACRCR_RPF                               ETH_DMACRCR_RPF_Msk      /* Rx Packet Flush */
#define ETH_DMACRCR_RPBL_Pos                          (16U)
#define ETH_DMACRCR_RPBL_Msk                          (0x3FUL << ETH_DMACRCR_RPBL_Pos) /*!< 0x003F0000 */
#define ETH_DMACRCR_RPBL                              ETH_DMACRCR_RPBL_Msk     /* Receive Programmable Burst Length */
#define ETH_DMACRCR_RPBL_1PBL                         ((uint32_t)0x00010000)   /* Receive Programmable Burst Length 1 */
#define ETH_DMACRCR_RPBL_2PBL                         ((uint32_t)0x00020000)   /* Receive Programmable Burst Length 2 */
#define ETH_DMACRCR_RPBL_4PBL                         ((uint32_t)0x00040000)   /* Receive Programmable Burst Length 4 */
#define ETH_DMACRCR_RPBL_8PBL                         ((uint32_t)0x00080000)   /* Receive Programmable Burst Length 8 */
#define ETH_DMACRCR_RPBL_16PBL                        ((uint32_t)0x00100000)   /* Receive Programmable Burst Length 16 */
#define ETH_DMACRCR_RPBL_32PBL                        ((uint32_t)0x00200000)   /* Receive Programmable Burst Length 32 */
#define ETH_DMACRCR_RBSZ_Pos                          (1U)
#define ETH_DMACRCR_RBSZ_Msk                          (0x3FFFUL << ETH_DMACRCR_RBSZ_Pos) /*!< 0x00007FFE */
#define ETH_DMACRCR_RBSZ                              ETH_DMACRCR_RBSZ_Msk     /* Receive Buffer size */
#define ETH_DMACRCR_SR_Pos                            (0U)
#define ETH_DMACRCR_SR_Msk                            (0x1UL << ETH_DMACRCR_SR_Pos) /*!< 0x00000001 */
#define ETH_DMACRCR_SR                                ETH_DMACRCR_SR_Msk       /* Start or Stop Receive */

/* Bit definition for Ethernet DMA CH Tx Desc List Address Register */
#define ETH_DMACTDLAR_TDESLA_Pos                      (2U)
#define ETH_DMACTDLAR_TDESLA_Msk                      (0x3FFFFFFFUL << ETH_DMACTDLAR_TDESLA_Pos) /*!< 0xFFFFFFFC */
#define ETH_DMACTDLAR_TDESLA                          ETH_DMACTDLAR_TDESLA_Msk /* Start of Transmit List */

/* Bit definition for Ethernet DMA CH Rx Desc List Address Register */
#define ETH_DMACRDLAR_RDESLA_Pos                      (2U)
#define ETH_DMACRDLAR_RDESLA_Msk                      (0x3FFFFFFFUL << ETH_DMACRDLAR_RDESLA_Pos) /*!< 0xFFFFFFFC */
#define ETH_DMACRDLAR_RDESLA                          ETH_DMACRDLAR_RDESLA_Msk /* Start of Receive List */

/* Bit definition for Ethernet DMA CH Tx Desc Tail Pointer Register */
#define ETH_DMACTDTPR_TDT_Pos                         (2U)
#define ETH_DMACTDTPR_TDT_Msk                         (0x3FFFFFFFUL << ETH_DMACTDTPR_TDT_Pos) /*!< 0xFFFFFFFC */
#define ETH_DMACTDTPR_TDT                             ETH_DMACTDTPR_TDT_Msk    /* Transmit Descriptor Tail Pointer */

/* Bit definition for Ethernet DMA CH Rx Desc Tail Pointer Register */
#define ETH_DMACRDTPR_RDT_Pos                         (2U)
#define ETH_DMACRDTPR_RDT_Msk                         (0x3FFFFFFFUL << ETH_DMACRDTPR_RDT_Pos) /*!< 0xFFFFFFFC */
#define ETH_DMACRDTPR_RDT                             ETH_DMACRDTPR_RDT_Msk    /* Receive Descriptor Tail Pointer */

/* Bit definition for Ethernet DMA CH Tx Desc Ring Length Register */
#define ETH_DMACTDRLR_TDRL_Pos                        (0U)
#define ETH_DMACTDRLR_TDRL_Msk                        (0x3FFUL << ETH_DMACTDRLR_TDRL_Pos) /*!< 0x000003FF */
#define ETH_DMACTDRLR_TDRL                            ETH_DMACTDRLR_TDRL_Msk   /* Transmit Descriptor Ring Length */

/* Bit definition for Ethernet DMA CH Rx Desc Ring Length Register */
#define ETH_DMACRDRLR_RDRL_Pos                        (0U)
#define ETH_DMACRDRLR_RDRL_Msk                        (0x3FFUL << ETH_DMACRDRLR_RDRL_Pos) /*!< 0x000003FF */
#define ETH_DMACRDRLR_RDRL                            ETH_DMACRDRLR_RDRL_Msk   /* Receive Descriptor Ring Length */

/* Bit definition for Ethernet DMA Channel Interrupt Enable Register */
#define ETH_DMACIER_NIE_Pos                           (15U)
#define ETH_DMACIER_NIE_Msk                           (0x1UL << ETH_DMACIER_NIE_Pos) /*!< 0x00008000 */
#define ETH_DMACIER_NIE                               ETH_DMACIER_NIE_Msk      /* Normal Interrupt Summary Enable */
#define ETH_DMACIER_AIE_Pos                           (14U)
#define ETH_DMACIER_AIE_Msk                           (0x1UL << ETH_DMACIER_AIE_Pos) /*!< 0x00004000 */
#define ETH_DMACIER_AIE                               ETH_DMACIER_AIE_Msk      /* Abnormal Interrupt Summary Enable */
#define ETH_DMACIER_CDEE_Pos                          (13U)
#define ETH_DMACIER_CDEE_Msk                          (0x1UL << ETH_DMACIER_CDEE_Pos) /*!< 0x00002000 */
#define ETH_DMACIER_CDEE                              ETH_DMACIER_CDEE_Msk     /* Context Descriptor Error Enable */
#define ETH_DMACIER_FBEE_Pos                          (12U)
#define ETH_DMACIER_FBEE_Msk                          (0x1UL << ETH_DMACIER_FBEE_Pos) /*!< 0x00001000 */
#define ETH_DMACIER_FBEE                              ETH_DMACIER_FBEE_Msk     /* Fatal Bus Error Enable */
#define ETH_DMACIER_ERIE_Pos                          (11U)
#define ETH_DMACIER_ERIE_Msk                          (0x1UL << ETH_DMACIER_ERIE_Pos) /*!< 0x00000800 */
#define ETH_DMACIER_ERIE                              ETH_DMACIER_ERIE_Msk     /* Early Receive Interrupt Enable */
#define ETH_DMACIER_ETIE_Pos                          (10U)
#define ETH_DMACIER_ETIE_Msk                          (0x1UL << ETH_DMACIER_ETIE_Pos) /*!< 0x00000400 */
#define ETH_DMACIER_ETIE                              ETH_DMACIER_ETIE_Msk     /* Early Transmit Interrupt Enable */
#define ETH_DMACIER_RWTE_Pos                          (9U)
#define ETH_DMACIER_RWTE_Msk                          (0x1UL << ETH_DMACIER_RWTE_Pos) /*!< 0x00000200 */
#define ETH_DMACIER_RWTE                              ETH_DMACIER_RWTE_Msk     /* Receive Watchdog Timeout Enable */
#define ETH_DMACIER_RSE_Pos                           (8U)
#define ETH_DMACIER_RSE_Msk                           (0x1UL << ETH_DMACIER_RSE_Pos) /*!< 0x00000100 */
#define ETH_DMACIER_RSE                               ETH_DMACIER_RSE_Msk      /* Receive Stopped Enable */
#define ETH_DMACIER_RBUE_Pos                          (7U)
#define ETH_DMACIER_RBUE_Msk                          (0x1UL << ETH_DMACIER_RBUE_Pos) /*!< 0x00000080 */
#define ETH_DMACIER_RBUE                              ETH_DMACIER_RBUE_Msk     /* Receive Buffer Unavailable Enable */
#define ETH_DMACIER_RIE_Pos                           (6U)
#define ETH_DMACIER_RIE_Msk                           (0x1UL << ETH_DMACIER_RIE_Pos) /*!< 0x00000040 */
#define ETH_DMACIER_RIE                               ETH_DMACIER_RIE_Msk      /* Receive Interrupt Enable */
#define ETH_DMACIER_TBUE_Pos                          (2U)
#define ETH_DMACIER_TBUE_Msk                          (0x1UL << ETH_DMACIER_TBUE_Pos) /*!< 0x00000004 */
#define ETH_DMACIER_TBUE                              ETH_DMACIER_TBUE_Msk     /* Transmit Buffer Unavailable Enable */
#define ETH_DMACIER_TXSE_Pos                          (1U)
#define ETH_DMACIER_TXSE_Msk                          (0x1UL << ETH_DMACIER_TXSE_Pos) /*!< 0x00000002 */
#define ETH_DMACIER_TXSE                              ETH_DMACIER_TXSE_Msk     /* Transmit Stopped Enable */
#define ETH_DMACIER_TIE_Pos                           (0U)
#define ETH_DMACIER_TIE_Msk                           (0x1UL << ETH_DMACIER_TIE_Pos) /*!< 0x00000001 */
#define ETH_DMACIER_TIE                               ETH_DMACIER_TIE_Msk      /* Transmit Interrupt Enable */

/* Bit definition for Ethernet DMA Channel Rx Interrupt Watchdog Timer Register */
#define ETH_DMACRIWTR_RWT_Pos                         (0U)
#define ETH_DMACRIWTR_RWT_Msk                         (0xFFUL << ETH_DMACRIWTR_RWT_Pos) /*!< 0x000000FF */
#define ETH_DMACRIWTR_RWT                             ETH_DMACRIWTR_RWT_Msk    /* Receive Interrupt Watchdog Timer Count */

/* Bit definition for Ethernet DMA Channel Current App Tx Desc Register */
#define ETH_DMACCATDR_CURTDESAPTR_Pos                 (0U)
#define ETH_DMACCATDR_CURTDESAPTR_Msk                 (0xFFFFFFFFUL << ETH_DMACCATDR_CURTDESAPTR_Pos) /*!< 0xFFFFFFFF */
#define ETH_DMACCATDR_CURTDESAPTR                     ETH_DMACCATDR_CURTDESAPTR_Msk /* Application Transmit Descriptor Address Pointer */

/* Bit definition for Ethernet DMA Channel Current App Rx Desc Register */
#define ETH_DMACCARDR_CURRDESAPTR_Pos                 (0U)
#define ETH_DMACCARDR_CURRDESAPTR_Msk                 (0xFFFFFFFFUL << ETH_DMACCARDR_CURRDESAPTR_Pos) /*!< 0xFFFFFFFF */
#define ETH_DMACCARDR_CURRDESAPTR                     ETH_DMACCARDR_CURRDESAPTR_Msk /* Application Receive Descriptor Address Pointer */

/* Bit definition for Ethernet DMA Channel Current App Tx Buffer Register */
#define ETH_DMACCATBR_CURTBUFAPTR_Pos                 (0U)
#define ETH_DMACCATBR_CURTBUFAPTR_Msk                 (0xFFFFFFFFUL << ETH_DMACCATBR_CURTBUFAPTR_Pos) /*!< 0xFFFFFFFF */
#define ETH_DMACCATBR_CURTBUFAPTR                     ETH_DMACCATBR_CURTBUFAPTR_Msk /* Application Transmit Buffer Address Pointer */

/* Bit definition for Ethernet DMA Channel Current App Rx Buffer Register */
#define ETH_DMACCARBR_CURRBUFAPTR_Pos                 (0U)
#define ETH_DMACCARBR_CURRBUFAPTR_Msk                 (0xFFFFFFFFUL << ETH_DMACCARBR_CURRBUFAPTR_Pos) /*!< 0xFFFFFFFF */
#define ETH_DMACCARBR_CURRBUFAPTR                     ETH_DMACCARBR_CURRBUFAPTR_Msk /* Application Receive Buffer Address Pointer */

/* Bit definition for Ethernet DMA Channel Status Register */
#define ETH_DMACSR_REB_Pos                            (19U)
#define ETH_DMACSR_REB_Msk                            (0x7UL << ETH_DMACSR_REB_Pos) /*!< 0x00380000 */
#define ETH_DMACSR_REB                                ETH_DMACSR_REB_Msk       /* Rx DMA Error Bits */
#define ETH_DMACSR_TEB_Pos                            (16U)
#define ETH_DMACSR_TEB_Msk                            (0x7UL << ETH_DMACSR_TEB_Pos) /*!< 0x00070000 */
#define ETH_DMACSR_TEB                                ETH_DMACSR_TEB_Msk       /* Tx DMA Error Bits */
#define ETH_DMACSR_NIS_Pos                            (15U)
#define ETH_DMACSR_NIS_Msk                            (0x1UL << ETH_DMACSR_NIS_Pos) /*!< 0x00008000 */
#define ETH_DMACSR_NIS                                ETH_DMACSR_NIS_Msk       /* Normal Interrupt Summary */
#define ETH_DMACSR_AIS_Pos                            (14U)
#define ETH_DMACSR_AIS_Msk                            (0x1UL << ETH_DMACSR_AIS_Pos) /*!< 0x00004000 */
#define ETH_DMACSR_AIS                                ETH_DMACSR_AIS_Msk       /* Abnormal Interrupt Summary */
#define ETH_DMACSR_CDE_Pos                            (13U)
#define ETH_DMACSR_CDE_Msk                            (0x1UL << ETH_DMACSR_CDE_Pos) /*!< 0x00002000 */
#define ETH_DMACSR_CDE                                ETH_DMACSR_CDE_Msk       /* Context Descriptor Error */
#define ETH_DMACSR_FBE_Pos                            (12U)
#define ETH_DMACSR_FBE_Msk                            (0x1UL << ETH_DMACSR_FBE_Pos) /*!< 0x00001000 */
#define ETH_DMACSR_FBE                                ETH_DMACSR_FBE_Msk       /* Fatal Bus Error */
#define ETH_DMACSR_ERI_Pos                            (11U)
#define ETH_DMACSR_ERI_Msk                            (0x1UL << ETH_DMACSR_ERI_Pos) /*!< 0x00000800 */
#define ETH_DMACSR_ERI                                ETH_DMACSR_ERI_Msk       /* Early Receive Interrupt */
#define ETH_DMACSR_ETI_Pos                            (10U)
#define ETH_DMACSR_ETI_Msk                            (0x1UL << ETH_DMACSR_ETI_Pos) /*!< 0x00000400 */
#define ETH_DMACSR_ETI                                ETH_DMACSR_ETI_Msk       /* Early Transmit Interrupt */
#define ETH_DMACSR_RWT_Pos                            (9U)
#define ETH_DMACSR_RWT_Msk                            (0x1UL << ETH_DMACSR_RWT_Pos) /*!< 0x00000200 */
#define ETH_DMACSR_RWT                                ETH_DMACSR_RWT_Msk       /* Receive Watchdog Timeout */
#define ETH_DMACSR_RPS_Pos                            (8U)
#define ETH_DMACSR_RPS_Msk                            (0x1UL << ETH_DMACSR_RPS_Pos) /*!< 0x00000100 */
#define ETH_DMACSR_RPS                                ETH_DMACSR_RPS_Msk       /* Receive Process Stopped */
#define ETH_DMACSR_RBU_Pos                            (7U)
#define ETH_DMACSR_RBU_Msk                            (0x1UL << ETH_DMACSR_RBU_Pos) /*!< 0x00000080 */
#define ETH_DMACSR_RBU                                ETH_DMACSR_RBU_Msk       /* Receive Buffer Unavailable */
#define ETH_DMACSR_RI_Pos                             (6U)
#define ETH_DMACSR_RI_Msk                             (0x1UL << ETH_DMACSR_RI_Pos) /*!< 0x00000040 */
#define ETH_DMACSR_RI                                 ETH_DMACSR_RI_Msk        /* Receive Interrupt */
#define ETH_DMACSR_TBU_Pos                            (2U)
#define ETH_DMACSR_TBU_Msk                            (0x1UL << ETH_DMACSR_TBU_Pos) /*!< 0x00000004 */
#define ETH_DMACSR_TBU                                ETH_DMACSR_TBU_Msk       /* Transmit Buffer Unavailable */
#define ETH_DMACSR_TPS_Pos                            (1U)
#define ETH_DMACSR_TPS_Msk                            (0x1UL << ETH_DMACSR_TPS_Pos) /*!< 0x00000002 */
#define ETH_DMACSR_TPS                                ETH_DMACSR_TPS_Msk       /* Transmit Process Stopped */
#define ETH_DMACSR_TI_Pos                             (0U)
#define ETH_DMACSR_TI_Msk                             (0x1UL << ETH_DMACSR_TI_Pos) /*!< 0x00000001 */
#define ETH_DMACSR_TI                                 ETH_DMACSR_TI_Msk        /* Transmit Interrupt */

/* Bit definition for Ethernet DMA Channel missed frame count register */
#define ETH_DMACMFCR_MFCO_Pos                         (15U)
#define ETH_DMACMFCR_MFCO_Msk                         (0x1UL << ETH_DMACMFCR_MFCO_Pos) /*!< 0x00008000 */
#define ETH_DMACMFCR_MFCO                             ETH_DMACMFCR_MFCO_Msk    /* Overflow status of the MFC Counter */
#define ETH_DMACMFCR_MFC_Pos                          (0U)
#define ETH_DMACMFCR_MFC_Msk                          (0x7FFUL << ETH_DMACMFCR_MFC_Pos) /*!< 0x000007FF */
#define ETH_DMACMFCR_MFC                              ETH_DMACMFCR_MFC_Msk     /* The number of packet counters dropped by the DMA */

/******************************************************************************/
/*                                                                            */
/*                             DMA Controller                                 */
/*                                                                            */
/******************************************************************************/
/********************  Bits definition for DMA_SxCR register  *****************/
#define DMA_SxCR_MBURST_Pos      (23U)
#define DMA_SxCR_MBURST_Msk      (0x3UL << DMA_SxCR_MBURST_Pos)                /*!< 0x01800000 */
#define DMA_SxCR_MBURST          DMA_SxCR_MBURST_Msk                           /*!< Memory burst transfer configuration */
#define DMA_SxCR_MBURST_0        (0x1UL << DMA_SxCR_MBURST_Pos)                 /*!< 0x00800000 */
#define DMA_SxCR_MBURST_1        (0x2UL << DMA_SxCR_MBURST_Pos)                 /*!< 0x01000000 */
#define DMA_SxCR_PBURST_Pos      (21U)
#define DMA_SxCR_PBURST_Msk      (0x3UL << DMA_SxCR_PBURST_Pos)                /*!< 0x00600000 */
#define DMA_SxCR_PBURST          DMA_SxCR_PBURST_Msk                           /*!< Peripheral burst transfer configuration */
#define DMA_SxCR_PBURST_0        (0x1UL << DMA_SxCR_PBURST_Pos)                 /*!< 0x00200000 */
#define DMA_SxCR_PBURST_1        (0x2UL << DMA_SxCR_PBURST_Pos)                 /*!< 0x00400000 */
#define DMA_SxCR_TRBUFF_Pos      (20U)
#define DMA_SxCR_TRBUFF_Msk      (0x1UL << DMA_SxCR_TRBUFF_Pos)                 /*!< 0x00100000 */
#define DMA_SxCR_TRBUFF          DMA_SxCR_TRBUFF_Msk                            /*!< bufferable transfers enabled/disable */
#define DMA_SxCR_CT_Pos          (19U)
#define DMA_SxCR_CT_Msk          (0x1UL << DMA_SxCR_CT_Pos)                    /*!< 0x00080000 */
#define DMA_SxCR_CT              DMA_SxCR_CT_Msk                               /*!< Current target (only in double buffer mode) */
#define DMA_SxCR_DBM_Pos         (18U)
#define DMA_SxCR_DBM_Msk         (0x1UL << DMA_SxCR_DBM_Pos)                   /*!< 0x00040000 */
#define DMA_SxCR_DBM             DMA_SxCR_DBM_Msk                              /*!< Double buffer mode */
#define DMA_SxCR_PL_Pos          (16U)
#define DMA_SxCR_PL_Msk          (0x3UL << DMA_SxCR_PL_Pos)                    /*!< 0x00030000 */
#define DMA_SxCR_PL              DMA_SxCR_PL_Msk                               /*!< Priority level */
#define DMA_SxCR_PL_0            (0x1UL << DMA_SxCR_PL_Pos)                     /*!< 0x00010000 */
#define DMA_SxCR_PL_1            (0x2UL << DMA_SxCR_PL_Pos)                     /*!< 0x00020000 */
#define DMA_SxCR_PINCOS_Pos      (15U)
#define DMA_SxCR_PINCOS_Msk      (0x1UL << DMA_SxCR_PINCOS_Pos)                /*!< 0x00008000 */
#define DMA_SxCR_PINCOS          DMA_SxCR_PINCOS_Msk                           /*!< Peripheral increment offset size */
#define DMA_SxCR_MSIZE_Pos       (13U)
#define DMA_SxCR_MSIZE_Msk       (0x3UL << DMA_SxCR_MSIZE_Pos)                 /*!< 0x00006000 */
#define DMA_SxCR_MSIZE           DMA_SxCR_MSIZE_Msk                            /*!< Memory data size */
#define DMA_SxCR_MSIZE_0         (0x1UL << DMA_SxCR_MSIZE_Pos)                  /*!< 0x00002000 */
#define DMA_SxCR_MSIZE_1         (0x2UL << DMA_SxCR_MSIZE_Pos)                  /*!< 0x00004000 */
#define DMA_SxCR_PSIZE_Pos       (11U)
#define DMA_SxCR_PSIZE_Msk       (0x3UL << DMA_SxCR_PSIZE_Pos)                 /*!< 0x00001800 */
#define DMA_SxCR_PSIZE           DMA_SxCR_PSIZE_Msk                            /*< Peripheral data size */
#define DMA_SxCR_PSIZE_0         (0x1UL << DMA_SxCR_PSIZE_Pos)                  /*!< 0x00000800 */
#define DMA_SxCR_PSIZE_1         (0x2UL << DMA_SxCR_PSIZE_Pos)                  /*!< 0x00001000 */
#define DMA_SxCR_MINC_Pos        (10U)
#define DMA_SxCR_MINC_Msk        (0x1UL << DMA_SxCR_MINC_Pos)                  /*!< 0x00000400 */
#define DMA_SxCR_MINC            DMA_SxCR_MINC_Msk                             /*!< Memory increment mode */
#define DMA_SxCR_PINC_Pos        (9U)
#define DMA_SxCR_PINC_Msk        (0x1UL << DMA_SxCR_PINC_Pos)                  /*!< 0x00000200 */
#define DMA_SxCR_PINC            DMA_SxCR_PINC_Msk                             /*!< Peripheral increment mode */
#define DMA_SxCR_CIRC_Pos        (8U)
#define DMA_SxCR_CIRC_Msk        (0x1UL << DMA_SxCR_CIRC_Pos)                  /*!< 0x00000100 */
#define DMA_SxCR_CIRC            DMA_SxCR_CIRC_Msk                             /*!< Circular mode */
#define DMA_SxCR_DIR_Pos         (6U)
#define DMA_SxCR_DIR_Msk         (0x3UL << DMA_SxCR_DIR_Pos)                   /*!< 0x000000C0 */
#define DMA_SxCR_DIR             DMA_SxCR_DIR_Msk                              /*!< Data transfer direction */
#define DMA_SxCR_DIR_0           (0x1UL << DMA_SxCR_DIR_Pos)                    /*!< 0x00000040 */
#define DMA_SxCR_DIR_1           (0x2UL << DMA_SxCR_DIR_Pos)                    /*!< 0x00000080 */
#define DMA_SxCR_PFCTRL_Pos      (5U)
#define DMA_SxCR_PFCTRL_Msk      (0x1UL << DMA_SxCR_PFCTRL_Pos)                /*!< 0x00000020 */
#define DMA_SxCR_PFCTRL          DMA_SxCR_PFCTRL_Msk                           /*!< Peripheral flow controller */
#define DMA_SxCR_TCIE_Pos        (4U)
#define DMA_SxCR_TCIE_Msk        (0x1UL << DMA_SxCR_TCIE_Pos)                  /*!< 0x00000010 */
#define DMA_SxCR_TCIE            DMA_SxCR_TCIE_Msk                             /*!< Transfer complete interrupt enable */
#define DMA_SxCR_HTIE_Pos        (3U)
#define DMA_SxCR_HTIE_Msk        (0x1UL << DMA_SxCR_HTIE_Pos)                  /*!< 0x00000008 */
#define DMA_SxCR_HTIE            DMA_SxCR_HTIE_Msk                             /*!< Half transfer interrupt enable */
#define DMA_SxCR_TEIE_Pos        (2U)
#define DMA_SxCR_TEIE_Msk        (0x1UL << DMA_SxCR_TEIE_Pos)                  /*!< 0x00000004 */
#define DMA_SxCR_TEIE            DMA_SxCR_TEIE_Msk                             /*!< Transfer error interrupt enable */
#define DMA_SxCR_DMEIE_Pos       (1U)
#define DMA_SxCR_DMEIE_Msk       (0x1UL << DMA_SxCR_DMEIE_Pos)                 /*!< 0x00000002 */
#define DMA_SxCR_DMEIE           DMA_SxCR_DMEIE_Msk                            /*!< Direct mode error interrupt enable */
#define DMA_SxCR_EN_Pos          (0U)
#define DMA_SxCR_EN_Msk          (0x1UL << DMA_SxCR_EN_Pos)                    /*!< 0x00000001 */
#define DMA_SxCR_EN              DMA_SxCR_EN_Msk                               /*!< Stream enable / flag stream ready when read low */

/********************  Bits definition for DMA_SxCNDTR register  **************/
#define DMA_SxNDT_Pos            (0U)
#define DMA_SxNDT_Msk            (0xFFFFUL << DMA_SxNDT_Pos)                   /*!< 0x0000FFFF */
#define DMA_SxNDT                DMA_SxNDT_Msk                                 /*!< Number of data items to transfer */
#define DMA_SxNDT_0              (0x0001UL << DMA_SxNDT_Pos)                    /*!< 0x00000001 */
#define DMA_SxNDT_1              (0x0002UL << DMA_SxNDT_Pos)                    /*!< 0x00000002 */
#define DMA_SxNDT_2              (0x0004UL << DMA_SxNDT_Pos)                    /*!< 0x00000004 */
#define DMA_SxNDT_3              (0x0008UL << DMA_SxNDT_Pos)                    /*!< 0x00000008 */
#define DMA_SxNDT_4              (0x0010UL << DMA_SxNDT_Pos)                    /*!< 0x00000010 */
#define DMA_SxNDT_5              (0x0020UL << DMA_SxNDT_Pos)                    /*!< 0x00000020 */
#define DMA_SxNDT_6              (0x0040UL << DMA_SxNDT_Pos)                    /*!< 0x00000040 */
#define DMA_SxNDT_7              (0x0080UL << DMA_SxNDT_Pos)                    /*!< 0x00000080 */
#define DMA_SxNDT_8              (0x0100UL << DMA_SxNDT_Pos)                    /*!< 0x00000100 */
#define DMA_SxNDT_9              (0x0200UL << DMA_SxNDT_Pos)                    /*!< 0x00000200 */
#define DMA_SxNDT_10             (0x0400UL << DMA_SxNDT_Pos)                    /*!< 0x00000400 */
#define DMA_SxNDT_11             (0x0800UL << DMA_SxNDT_Pos)                    /*!< 0x00000800 */
#define DMA_SxNDT_12             (0x1000UL << DMA_SxNDT_Pos)                    /*!< 0x00001000 */
#define DMA_SxNDT_13             (0x2000UL << DMA_SxNDT_Pos)                    /*!< 0x00002000 */
#define DMA_SxNDT_14             (0x4000UL << DMA_SxNDT_Pos)                    /*!< 0x00004000 */
#define DMA_SxNDT_15             (0x8000UL << DMA_SxNDT_Pos)                    /*!< 0x00008000 */

/********************  Bits definition for DMA_SxFCR register  ****************/
#define DMA_SxFCR_FEIE_Pos       (7U)
#define DMA_SxFCR_FEIE_Msk       (0x1UL << DMA_SxFCR_FEIE_Pos)                 /*!< 0x00000080 */
#define DMA_SxFCR_FEIE           DMA_SxFCR_FEIE_Msk                            /*!< FIFO error interrupt enable */
#define DMA_SxFCR_FS_Pos         (3U)
#define DMA_SxFCR_FS_Msk         (0x7UL << DMA_SxFCR_FS_Pos)                   /*!< 0x00000038 */
#define DMA_SxFCR_FS             DMA_SxFCR_FS_Msk                              /*!< FIFO status */
#define DMA_SxFCR_FS_0           (0x1UL << DMA_SxFCR_FS_Pos)                    /*!< 0x00000008 */
#define DMA_SxFCR_FS_1           (0x2UL << DMA_SxFCR_FS_Pos)                    /*!< 0x00000010 */
#define DMA_SxFCR_FS_2           (0x4UL << DMA_SxFCR_FS_Pos)                    /*!< 0x00000020 */
#define DMA_SxFCR_DMDIS_Pos      (2U)
#define DMA_SxFCR_DMDIS_Msk      (0x1UL << DMA_SxFCR_DMDIS_Pos)                /*!< 0x00000004 */
#define DMA_SxFCR_DMDIS          DMA_SxFCR_DMDIS_Msk                           /*!< Direct mode disable */
#define DMA_SxFCR_FTH_Pos        (0U)
#define DMA_SxFCR_FTH_Msk        (0x3UL << DMA_SxFCR_FTH_Pos)                  /*!< 0x00000003 */
#define DMA_SxFCR_FTH            DMA_SxFCR_FTH_Msk                             /*!< FIFO threshold selection */
#define DMA_SxFCR_FTH_0          (0x1UL << DMA_SxFCR_FTH_Pos)                   /*!< 0x00000001 */
#define DMA_SxFCR_FTH_1          (0x2UL << DMA_SxFCR_FTH_Pos)                   /*!< 0x00000002 */

/********************  Bits definition for DMA_LISR register  *****************/
#define DMA_LISR_TCIF3_Pos       (27U)
#define DMA_LISR_TCIF3_Msk       (0x1UL << DMA_LISR_TCIF3_Pos)                 /*!< 0x08000000 */
#define DMA_LISR_TCIF3           DMA_LISR_TCIF3_Msk                            /*!<  Stream 3 transfer complete interrupt flag */
#define DMA_LISR_HTIF3_Pos       (26U)
#define DMA_LISR_HTIF3_Msk       (0x1UL << DMA_LISR_HTIF3_Pos)                 /*!< 0x04000000 */
#define DMA_LISR_HTIF3           DMA_LISR_HTIF3_Msk                            /*!<  Stream 3 half transfer interrupt flag */
#define DMA_LISR_TEIF3_Pos       (25U)
#define DMA_LISR_TEIF3_Msk       (0x1UL << DMA_LISR_TEIF3_Pos)                 /*!< 0x02000000 */
#define DMA_LISR_TEIF3           DMA_LISR_TEIF3_Msk                            /*!<  Stream 3 transfer error interrupt flag */
#define DMA_LISR_DMEIF3_Pos      (24U)
#define DMA_LISR_DMEIF3_Msk      (0x1UL << DMA_LISR_DMEIF3_Pos)                /*!< 0x01000000 */
#define DMA_LISR_DMEIF3          DMA_LISR_DMEIF3_Msk                           /*!<  Stream 3 direct mode error interrupt flag */
#define DMA_LISR_FEIF3_Pos       (22U)
#define DMA_LISR_FEIF3_Msk       (0x1UL << DMA_LISR_FEIF3_Pos)                 /*!< 0x00400000 */
#define DMA_LISR_FEIF3           DMA_LISR_FEIF3_Msk                            /*!<  Stream 3 FIFO error interrupt flag */
#define DMA_LISR_TCIF2_Pos       (21U)
#define DMA_LISR_TCIF2_Msk       (0x1UL << DMA_LISR_TCIF2_Pos)                 /*!< 0x00200000 */
#define DMA_LISR_TCIF2           DMA_LISR_TCIF2_Msk                            /*!<  Stream 2 transfer complete interrupt flag */
#define DMA_LISR_HTIF2_Pos       (20U)
#define DMA_LISR_HTIF2_Msk       (0x1UL << DMA_LISR_HTIF2_Pos)                 /*!< 0x00100000 */
#define DMA_LISR_HTIF2           DMA_LISR_HTIF2_Msk                            /*!<  Stream 2 half transfer interrupt flag */
#define DMA_LISR_TEIF2_Pos       (19U)
#define DMA_LISR_TEIF2_Msk       (0x1UL << DMA_LISR_TEIF2_Pos)                 /*!< 0x00080000 */
#define DMA_LISR_TEIF2           DMA_LISR_TEIF2_Msk                            /*!<  Stream 2 transfer error interrupt flag */
#define DMA_LISR_DMEIF2_Pos      (18U)
#define DMA_LISR_DMEIF2_Msk      (0x1UL << DMA_LISR_DMEIF2_Pos)                /*!< 0x00040000 */
#define DMA_LISR_DMEIF2          DMA_LISR_DMEIF2_Msk                           /*!<  Stream 2 direct mode error interrupt flag */
#define DMA_LISR_FEIF2_Pos       (16U)
#define DMA_LISR_FEIF2_Msk       (0x1UL << DMA_LISR_FEIF2_Pos)                 /*!< 0x00010000 */
#define DMA_LISR_FEIF2           DMA_LISR_FEIF2_Msk                            /*!<  Stream 2 FIFO error interrupt flag */
#define DMA_LISR_TCIF1_Pos       (11U)
#define DMA_LISR_TCIF1_Msk       (0x1UL << DMA_LISR_TCIF1_Pos)                 /*!< 0x00000800 */
#define DMA_LISR_TCIF1           DMA_LISR_TCIF1_Msk                            /*!<  Stream 1 transfer complete interrupt flag */
#define DMA_LISR_HTIF1_Pos       (10U)
#define DMA_LISR_HTIF1_Msk       (0x1UL << DMA_LISR_HTIF1_Pos)                 /*!< 0x00000400 */
#define DMA_LISR_HTIF1           DMA_LISR_HTIF1_Msk                            /*!<  Stream 1 half transfer interrupt flag */
#define DMA_LISR_TEIF1_Pos       (9U)
#define DMA_LISR_TEIF1_Msk       (0x1UL << DMA_LISR_TEIF1_Pos)                 /*!< 0x00000200 */
#define DMA_LISR_TEIF1           DMA_LISR_TEIF1_Msk                            /*!<  Stream 1 transfer error interrupt flag */
#define DMA_LISR_DMEIF1_Pos      (8U)
#define DMA_LISR_DMEIF1_Msk      (0x1UL << DMA_LISR_DMEIF1_Pos)                /*!< 0x00000100 */
#define DMA_LISR_DMEIF1          DMA_LISR_DMEIF1_Msk                           /*!<  Stream 1 direct mode error interrupt flag */
#define DMA_LISR_FEIF1_Pos       (6U)
#define DMA_LISR_FEIF1_Msk       (0x1UL << DMA_LISR_FEIF1_Pos)                 /*!< 0x00000040 */
#define DMA_LISR_FEIF1           DMA_LISR_FEIF1_Msk                            /*!<  Stream 1 FIFO error interrupt flag */
#define DMA_LISR_TCIF0_Pos       (5U)
#define DMA_LISR_TCIF0_Msk       (0x1UL << DMA_LISR_TCIF0_Pos)                 /*!< 0x00000020 */
#define DMA_LISR_TCIF0           DMA_LISR_TCIF0_Msk                            /*!<  Stream 0 transfer complete interrupt flag */
#define DMA_LISR_HTIF0_Pos       (4U)
#define DMA_LISR_HTIF0_Msk       (0x1UL << DMA_LISR_HTIF0_Pos)                 /*!< 0x00000010 */
#define DMA_LISR_HTIF0           DMA_LISR_HTIF0_Msk                            /*!<  Stream 0 half transfer interrupt flag */
#define DMA_LISR_TEIF0_Pos       (3U)
#define DMA_LISR_TEIF0_Msk       (0x1UL << DMA_LISR_TEIF0_Pos)                 /*!< 0x00000008 */
#define DMA_LISR_TEIF0           DMA_LISR_TEIF0_Msk                            /*!<  Stream 0 transfer error interrupt flag */
#define DMA_LISR_DMEIF0_Pos      (2U)
#define DMA_LISR_DMEIF0_Msk      (0x1UL << DMA_LISR_DMEIF0_Pos)                /*!< 0x00000004 */
#define DMA_LISR_DMEIF0          DMA_LISR_DMEIF0_Msk                           /*!<  Stream 0 direct mode error interrupt flag */
#define DMA_LISR_FEIF0_Pos       (0U)
#define DMA_LISR_FEIF0_Msk       (0x1UL << DMA_LISR_FEIF0_Pos)                 /*!< 0x00000001 */
#define DMA_LISR_FEIF0           DMA_LISR_FEIF0_Msk                            /*!<  Stream 0 FIFO error interrupt flag */

/********************  Bits definition for DMA_HISR register  *****************/
#define DMA_HISR_TCIF7_Pos       (27U)
#define DMA_HISR_TCIF7_Msk       (0x1UL << DMA_HISR_TCIF7_Pos)                 /*!< 0x08000000 */
#define DMA_HISR_TCIF7           DMA_HISR_TCIF7_Msk                            /*!<  Stream 7 transfer complete interrupt flag */
#define DMA_HISR_HTIF7_Pos       (26U)
#define DMA_HISR_HTIF7_Msk       (0x1UL << DMA_HISR_HTIF7_Pos)                 /*!< 0x04000000 */
#define DMA_HISR_HTIF7           DMA_HISR_HTIF7_Msk                            /*!<  Stream 7 half transfer interrupt flag */
#define DMA_HISR_TEIF7_Pos       (25U)
#define DMA_HISR_TEIF7_Msk       (0x1UL << DMA_HISR_TEIF7_Pos)                 /*!< 0x02000000 */
#define DMA_HISR_TEIF7           DMA_HISR_TEIF7_Msk                            /*!<  Stream 7 transfer error interrupt flag */
#define DMA_HISR_DMEIF7_Pos      (24U)
#define DMA_HISR_DMEIF7_Msk      (0x1UL << DMA_HISR_DMEIF7_Pos)                /*!< 0x01000000 */
#define DMA_HISR_DMEIF7          DMA_HISR_DMEIF7_Msk                           /*!<  Stream 7 direct mode error interrupt flag */
#define DMA_HISR_FEIF7_Pos       (22U)
#define DMA_HISR_FEIF7_Msk       (0x1UL << DMA_HISR_FEIF7_Pos)                 /*!< 0x00400000 */
#define DMA_HISR_FEIF7           DMA_HISR_FEIF7_Msk                            /*!<  Stream 7 FIFO error interrupt flag */
#define DMA_HISR_TCIF6_Pos       (21U)
#define DMA_HISR_TCIF6_Msk       (0x1UL << DMA_HISR_TCIF6_Pos)                 /*!< 0x00200000 */
#define DMA_HISR_TCIF6           DMA_HISR_TCIF6_Msk                            /*!<  Stream 6 transfer complete interrupt flag */
#define DMA_HISR_HTIF6_Pos       (20U)
#define DMA_HISR_HTIF6_Msk       (0x1UL << DMA_HISR_HTIF6_Pos)                 /*!< 0x00100000 */
#define DMA_HISR_HTIF6           DMA_HISR_HTIF6_Msk                            /*!<  Stream 6 half transfer interrupt flag */
#define DMA_HISR_TEIF6_Pos       (19U)
#define DMA_HISR_TEIF6_Msk       (0x1UL << DMA_HISR_TEIF6_Pos)                 /*!< 0x00080000 */
#define DMA_HISR_TEIF6           DMA_HISR_TEIF6_Msk                            /*!<  Stream 6 transfer error interrupt flag */
#define DMA_HISR_DMEIF6_Pos      (18U)
#define DMA_HISR_DMEIF6_Msk      (0x1UL << DMA_HISR_DMEIF6_Pos)                /*!< 0x00040000 */
#define DMA_HISR_DMEIF6          DMA_HISR_DMEIF6_Msk                           /*!<  Stream 6 direct mode error interrupt flag */
#define DMA_HISR_FEIF6_Pos       (16U)
#define DMA_HISR_FEIF6_Msk       (0x1UL << DMA_HISR_FEIF6_Pos)                 /*!< 0x00010000 */
#define DMA_HISR_FEIF6           DMA_HISR_FEIF6_Msk                            /*!<  Stream 6 FIFO error interrupt flag */
#define DMA_HISR_TCIF5_Pos       (11U)
#define DMA_HISR_TCIF5_Msk       (0x1UL << DMA_HISR_TCIF5_Pos)                 /*!< 0x00000800 */
#define DMA_HISR_TCIF5           DMA_HISR_TCIF5_Msk                            /*!<  Stream 5 transfer complete interrupt flag */
#define DMA_HISR_HTIF5_Pos       (10U)
#define DMA_HISR_HTIF5_Msk       (0x1UL << DMA_HISR_HTIF5_Pos)                 /*!< 0x00000400 */
#define DMA_HISR_HTIF5           DMA_HISR_HTIF5_Msk                            /*!<  Stream 5 half transfer interrupt flag */
#define DMA_HISR_TEIF5_Pos       (9U)
#define DMA_HISR_TEIF5_Msk       (0x1UL << DMA_HISR_TEIF5_Pos)                 /*!< 0x00000200 */
#define DMA_HISR_TEIF5           DMA_HISR_TEIF5_Msk                            /*!<  Stream 5 transfer error interrupt flag */
#define DMA_HISR_DMEIF5_Pos      (8U)
#define DMA_HISR_DMEIF5_Msk      (0x1UL << DMA_HISR_DMEIF5_Pos)                /*!< 0x00000100 */
#define DMA_HISR_DMEIF5          DMA_HISR_DMEIF5_Msk                           /*!<  Stream 5 direct mode error interrupt flag */
#define DMA_HISR_FEIF5_Pos       (6U)
#define DMA_HISR_FEIF5_Msk       (0x1UL << DMA_HISR_FEIF5_Pos)                 /*!< 0x00000040 */
#define DMA_HISR_FEIF5           DMA_HISR_FEIF5_Msk                            /*!<  Stream 5 FIFO error interrupt flag */
#define DMA_HISR_TCIF4_Pos       (5U)
#define DMA_HISR_TCIF4_Msk       (0x1UL << DMA_HISR_TCIF4_Pos)                 /*!< 0x00000020 */
#define DMA_HISR_TCIF4           DMA_HISR_TCIF4_Msk                            /*!<  Stream 4 transfer complete interrupt flag */
#define DMA_HISR_HTIF4_Pos       (4U)
#define DMA_HISR_HTIF4_Msk       (0x1UL << DMA_HISR_HTIF4_Pos)                 /*!< 0x00000010 */
#define DMA_HISR_HTIF4           DMA_HISR_HTIF4_Msk                            /*!<  Stream 4 half transfer interrupt flag */
#define DMA_HISR_TEIF4_Pos       (3U)
#define DMA_HISR_TEIF4_Msk       (0x1UL << DMA_HISR_TEIF4_Pos)                 /*!< 0x00000008 */
#define DMA_HISR_TEIF4           DMA_HISR_TEIF4_Msk                            /*!<  Stream 4 transfer error interrupt flag */
#define DMA_HISR_DMEIF4_Pos      (2U)
#define DMA_HISR_DMEIF4_Msk      (0x1UL << DMA_HISR_DMEIF4_Pos)                /*!< 0x00000004 */
#define DMA_HISR_DMEIF4          DMA_HISR_DMEIF4_Msk                           /*!<  Stream 4 direct mode error interrupt flag */
#define DMA_HISR_FEIF4_Pos       (0U)
#define DMA_HISR_FEIF4_Msk       (0x1UL << DMA_HISR_FEIF4_Pos)                 /*!< 0x00000001 */
#define DMA_HISR_FEIF4           DMA_HISR_FEIF4_Msk                            /*!<  Stream 4 FIFO error interrupt flag */

/********************  Bits definition for DMA_LIFCR register  ****************/
#define DMA_LIFCR_CTCIF3_Pos     (27U)
#define DMA_LIFCR_CTCIF3_Msk     (0x1UL << DMA_LIFCR_CTCIF3_Pos)               /*!< 0x08000000 */
#define DMA_LIFCR_CTCIF3         DMA_LIFCR_CTCIF3_Msk                          /*!<  Stream 3 clear transfer complete interrupt flag */
#define DMA_LIFCR_CHTIF3_Pos     (26U)
#define DMA_LIFCR_CHTIF3_Msk     (0x1UL << DMA_LIFCR_CHTIF3_Pos)               /*!< 0x04000000 */
#define DMA_LIFCR_CHTIF3         DMA_LIFCR_CHTIF3_Msk                          /*!<  Stream 3 clear half transfer interrupt flag */
#define DMA_LIFCR_CTEIF3_Pos     (25U)
#define DMA_LIFCR_CTEIF3_Msk     (0x1UL << DMA_LIFCR_CTEIF3_Pos)               /*!< 0x02000000 */
#define DMA_LIFCR_CTEIF3         DMA_LIFCR_CTEIF3_Msk                          /*!<  Stream 3 clear transfer error interrupt flag */
#define DMA_LIFCR_CDMEIF3_Pos    (24U)
#define DMA_LIFCR_CDMEIF3_Msk    (0x1UL << DMA_LIFCR_CDMEIF3_Pos)              /*!< 0x01000000 */
#define DMA_LIFCR_CDMEIF3        DMA_LIFCR_CDMEIF3_Msk                         /*!<  Stream 3 clear direct mode error interrupt flag */
#define DMA_LIFCR_CFEIF3_Pos     (22U)
#define DMA_LIFCR_CFEIF3_Msk     (0x1UL << DMA_LIFCR_CFEIF3_Pos)               /*!< 0x00400000 */
#define DMA_LIFCR_CFEIF3         DMA_LIFCR_CFEIF3_Msk                          /*!<  Stream 3 clear FIFO error interrupt flag */
#define DMA_LIFCR_CTCIF2_Pos     (21U)
#define DMA_LIFCR_CTCIF2_Msk     (0x1UL << DMA_LIFCR_CTCIF2_Pos)               /*!< 0x00200000 */
#define DMA_LIFCR_CTCIF2         DMA_LIFCR_CTCIF2_Msk                          /*!<  Stream 2 clear transfer complete interrupt flag */
#define DMA_LIFCR_CHTIF2_Pos     (20U)
#define DMA_LIFCR_CHTIF2_Msk     (0x1UL << DMA_LIFCR_CHTIF2_Pos)               /*!< 0x00100000 */
#define DMA_LIFCR_CHTIF2         DMA_LIFCR_CHTIF2_Msk                          /*!<  Stream 2 clear half transfer interrupt flag */
#define DMA_LIFCR_CTEIF2_Pos     (19U)
#define DMA_LIFCR_CTEIF2_Msk     (0x1UL << DMA_LIFCR_CTEIF2_Pos)               /*!< 0x00080000 */
#define DMA_LIFCR_CTEIF2         DMA_LIFCR_CTEIF2_Msk                          /*!<  Stream 2 clear transfer error interrupt flag */
#define DMA_LIFCR_CDMEIF2_Pos    (18U)
#define DMA_LIFCR_CDMEIF2_Msk    (0x1UL << DMA_LIFCR_CDMEIF2_Pos)              /*!< 0x00040000 */
#define DMA_LIFCR_CDMEIF2        DMA_LIFCR_CDMEIF2_Msk                         /*!<  Stream 2 clear direct mode error interrupt flag */
#define DMA_LIFCR_CFEIF2_Pos     (16U)
#define DMA_LIFCR_CFEIF2_Msk     (0x1UL << DMA_LIFCR_CFEIF2_Pos)               /*!< 0x00010000 */
#define DMA_LIFCR_CFEIF2         DMA_LIFCR_CFEIF2_Msk                          /*!<  Stream 2 clear FIFO error interrupt flag */
#define DMA_LIFCR_CTCIF1_Pos     (11U)
#define DMA_LIFCR_CTCIF1_Msk     (0x1UL << DMA_LIFCR_CTCIF1_Pos)               /*!< 0x00000800 */
#define DMA_LIFCR_CTCIF1         DMA_LIFCR_CTCIF1_Msk                          /*!<  Stream 1 clear transfer complete interrupt flag */
#define DMA_LIFCR_CHTIF1_Pos     (10U)
#define DMA_LIFCR_CHTIF1_Msk     (0x1UL << DMA_LIFCR_CHTIF1_Pos)               /*!< 0x00000400 */
#define DMA_LIFCR_CHTIF1         DMA_LIFCR_CHTIF1_Msk                          /*!<  Stream 1 clear half transfer interrupt flag */
#define DMA_LIFCR_CTEIF1_Pos     (9U)
#define DMA_LIFCR_CTEIF1_Msk     (0x1UL << DMA_LIFCR_CTEIF1_Pos)               /*!< 0x00000200 */
#define DMA_LIFCR_CTEIF1         DMA_LIFCR_CTEIF1_Msk                          /*!<  Stream 1 clear transfer error interrupt flag */
#define DMA_LIFCR_CDMEIF1_Pos    (8U)
#define DMA_LIFCR_CDMEIF1_Msk    (0x1UL << DMA_LIFCR_CDMEIF1_Pos)              /*!< 0x00000100 */
#define DMA_LIFCR_CDMEIF1        DMA_LIFCR_CDMEIF1_Msk                         /*!<  Stream 1 clear direct mode error interrupt flag */
#define DMA_LIFCR_CFEIF1_Pos     (6U)
#define DMA_LIFCR_CFEIF1_Msk     (0x1UL << DMA_LIFCR_CFEIF1_Pos)               /*!< 0x00000040 */
#define DMA_LIFCR_CFEIF1         DMA_LIFCR_CFEIF1_Msk                          /*!<  Stream 1 clear FIFO error interrupt flag */
#define DMA_LIFCR_CTCIF0_Pos     (5U)
#define DMA_LIFCR_CTCIF0_Msk     (0x1UL << DMA_LIFCR_CTCIF0_Pos)               /*!< 0x00000020 */
#define DMA_LIFCR_CTCIF0         DMA_LIFCR_CTCIF0_Msk                          /*!<  Stream 0 clear transfer complete interrupt flag */
#define DMA_LIFCR_CHTIF0_Pos     (4U)
#define DMA_LIFCR_CHTIF0_Msk     (0x1UL << DMA_LIFCR_CHTIF0_Pos)               /*!< 0x00000010 */
#define DMA_LIFCR_CHTIF0         DMA_LIFCR_CHTIF0_Msk                          /*!<  Stream 0 clear half transfer interrupt flag */
#define DMA_LIFCR_CTEIF0_Pos     (3U)
#define DMA_LIFCR_CTEIF0_Msk     (0x1UL << DMA_LIFCR_CTEIF0_Pos)               /*!< 0x00000008 */
#define DMA_LIFCR_CTEIF0         DMA_LIFCR_CTEIF0_Msk                          /*!<  Stream 0 clear transfer error interrupt flag */
#define DMA_LIFCR_CDMEIF0_Pos    (2U)
#define DMA_LIFCR_CDMEIF0_Msk    (0x1UL << DMA_LIFCR_CDMEIF0_Pos)              /*!< 0x00000004 */
#define DMA_LIFCR_CDMEIF0        DMA_LIFCR_CDMEIF0_Msk                         /*!<  Stream 0 clear direct mode error interrupt flag */
#define DMA_LIFCR_CFEIF0_Pos     (0U)
#define DMA_LIFCR_CFEIF0_Msk     (0x1UL << DMA_LIFCR_CFEIF0_Pos)               /*!< 0x00000001 */
#define DMA_LIFCR_CFEIF0         DMA_LIFCR_CFEIF0_Msk                          /*!<  Stream 0 clear FIFO error interrupt flag */

/********************  Bits definition for DMA_HIFCR  register  ****************/
#define DMA_HIFCR_CTCIF7_Pos     (27U)
#define DMA_HIFCR_CTCIF7_Msk     (0x1UL << DMA_HIFCR_CTCIF7_Pos)               /*!< 0x08000000 */
#define DMA_HIFCR_CTCIF7         DMA_HIFCR_CTCIF7_Msk                          /*!<  Stream 7 clear transfer complete interrupt flag */
#define DMA_HIFCR_CHTIF7_Pos     (26U)
#define DMA_HIFCR_CHTIF7_Msk     (0x1UL << DMA_HIFCR_CHTIF7_Pos)               /*!< 0x04000000 */
#define DMA_HIFCR_CHTIF7         DMA_HIFCR_CHTIF7_Msk                          /*!<  Stream 7 clear half transfer interrupt flag */
#define DMA_HIFCR_CTEIF7_Pos     (25U)
#define DMA_HIFCR_CTEIF7_Msk     (0x1UL << DMA_HIFCR_CTEIF7_Pos)               /*!< 0x02000000 */
#define DMA_HIFCR_CTEIF7         DMA_HIFCR_CTEIF7_Msk                          /*!<  Stream 7 clear transfer error interrupt flag */
#define DMA_HIFCR_CDMEIF7_Pos    (24U)
#define DMA_HIFCR_CDMEIF7_Msk    (0x1UL << DMA_HIFCR_CDMEIF7_Pos)              /*!< 0x01000000 */
#define DMA_HIFCR_CDMEIF7        DMA_HIFCR_CDMEIF7_Msk                         /*!<  Stream 7 clear direct mode error interrupt flag */
#define DMA_HIFCR_CFEIF7_Pos     (22U)
#define DMA_HIFCR_CFEIF7_Msk     (0x1UL << DMA_HIFCR_CFEIF7_Pos)               /*!< 0x00400000 */
#define DMA_HIFCR_CFEIF7         DMA_HIFCR_CFEIF7_Msk                          /*!<  Stream 7 clear FIFO error interrupt flag */
#define DMA_HIFCR_CTCIF6_Pos     (21U)
#define DMA_HIFCR_CTCIF6_Msk     (0x1UL << DMA_HIFCR_CTCIF6_Pos)               /*!< 0x00200000 */
#define DMA_HIFCR_CTCIF6         DMA_HIFCR_CTCIF6_Msk                          /*!<  Stream 6 clear transfer complete interrupt flag */
#define DMA_HIFCR_CHTIF6_Pos     (20U)
#define DMA_HIFCR_CHTIF6_Msk     (0x1UL << DMA_HIFCR_CHTIF6_Pos)               /*!< 0x00100000 */
#define DMA_HIFCR_CHTIF6         DMA_HIFCR_CHTIF6_Msk                          /*!<  Stream 6 clear half transfer interrupt flag */
#define DMA_HIFCR_CTEIF6_Pos     (19U)
#define DMA_HIFCR_CTEIF6_Msk     (0x1UL << DMA_HIFCR_CTEIF6_Pos)               /*!< 0x00080000 */
#define DMA_HIFCR_CTEIF6         DMA_HIFCR_CTEIF6_Msk                          /*!<  Stream 6 clear transfer error interrupt flag */
#define DMA_HIFCR_CDMEIF6_Pos    (18U)
#define DMA_HIFCR_CDMEIF6_Msk    (0x1UL << DMA_HIFCR_CDMEIF6_Pos)              /*!< 0x00040000 */
#define DMA_HIFCR_CDMEIF6        DMA_HIFCR_CDMEIF6_Msk                         /*!<  Stream 6 clear direct mode error interrupt flag */
#define DMA_HIFCR_CFEIF6_Pos     (16U)
#define DMA_HIFCR_CFEIF6_Msk     (0x1UL << DMA_HIFCR_CFEIF6_Pos)               /*!< 0x00010000 */
#define DMA_HIFCR_CFEIF6         DMA_HIFCR_CFEIF6_Msk                          /*!<  Stream 6 clear FIFO error interrupt flag */
#define DMA_HIFCR_CTCIF5_Pos     (11U)
#define DMA_HIFCR_CTCIF5_Msk     (0x1UL << DMA_HIFCR_CTCIF5_Pos)               /*!< 0x00000800 */
#define DMA_HIFCR_CTCIF5         DMA_HIFCR_CTCIF5_Msk                          /*!<  Stream 5 clear transfer complete interrupt flag */
#define DMA_HIFCR_CHTIF5_Pos     (10U)
#define DMA_HIFCR_CHTIF5_Msk     (0x1UL << DMA_HIFCR_CHTIF5_Pos)               /*!< 0x00000400 */
#define DMA_HIFCR_CHTIF5         DMA_HIFCR_CHTIF5_Msk                          /*!<  Stream 5 clear half transfer interrupt flag */
#define DMA_HIFCR_CTEIF5_Pos     (9U)
#define DMA_HIFCR_CTEIF5_Msk     (0x1UL << DMA_HIFCR_CTEIF5_Pos)               /*!< 0x00000200 */
#define DMA_HIFCR_CTEIF5         DMA_HIFCR_CTEIF5_Msk                          /*!<  Stream 5 clear transfer error interrupt flag */
#define DMA_HIFCR_CDMEIF5_Pos    (8U)
#define DMA_HIFCR_CDMEIF5_Msk    (0x1UL << DMA_HIFCR_CDMEIF5_Pos)              /*!< 0x00000100 */
#define DMA_HIFCR_CDMEIF5        DMA_HIFCR_CDMEIF5_Msk                         /*!<  Stream 5 clear direct mode error interrupt flag */
#define DMA_HIFCR_CFEIF5_Pos     (6U)
#define DMA_HIFCR_CFEIF5_Msk     (0x1UL << DMA_HIFCR_CFEIF5_Pos)               /*!< 0x00000040 */
#define DMA_HIFCR_CFEIF5         DMA_HIFCR_CFEIF5_Msk                          /*!<  Stream 5 clear FIFO error interrupt flag */
#define DMA_HIFCR_CTCIF4_Pos     (5U)
#define DMA_HIFCR_CTCIF4_Msk     (0x1UL << DMA_HIFCR_CTCIF4_Pos)               /*!< 0x00000020 */
#define DMA_HIFCR_CTCIF4         DMA_HIFCR_CTCIF4_Msk                          /*!<  Stream 4 clear transfer complete interrupt flag */
#define DMA_HIFCR_CHTIF4_Pos     (4U)
#define DMA_HIFCR_CHTIF4_Msk     (0x1UL << DMA_HIFCR_CHTIF4_Pos)               /*!< 0x00000010 */
#define DMA_HIFCR_CHTIF4         DMA_HIFCR_CHTIF4_Msk                          /*!<  Stream 4 clear half transfer interrupt flag */
#define DMA_HIFCR_CTEIF4_Pos     (3U)
#define DMA_HIFCR_CTEIF4_Msk     (0x1UL << DMA_HIFCR_CTEIF4_Pos)               /*!< 0x00000008 */
#define DMA_HIFCR_CTEIF4         DMA_HIFCR_CTEIF4_Msk                          /*!<  Stream 4 clear transfer error interrupt flag */
#define DMA_HIFCR_CDMEIF4_Pos    (2U)
#define DMA_HIFCR_CDMEIF4_Msk    (0x1UL << DMA_HIFCR_CDMEIF4_Pos)              /*!< 0x00000004 */
#define DMA_HIFCR_CDMEIF4        DMA_HIFCR_CDMEIF4_Msk                         /*!<  Stream 4 clear direct mode error interrupt flag */
#define DMA_HIFCR_CFEIF4_Pos     (0U)
#define DMA_HIFCR_CFEIF4_Msk     (0x1UL << DMA_HIFCR_CFEIF4_Pos)               /*!< 0x00000001 */
#define DMA_HIFCR_CFEIF4         DMA_HIFCR_CFEIF4_Msk                          /*!<  Stream 4 clear FIFO error interrupt flag */

/******************  Bit definition for DMA_SxPAR register  ********************/
#define DMA_SxPAR_PA_Pos         (0U)
#define DMA_SxPAR_PA_Msk         (0xFFFFFFFFUL << DMA_SxPAR_PA_Pos)            /*!< 0xFFFFFFFF */
#define DMA_SxPAR_PA             DMA_SxPAR_PA_Msk                              /*!< Peripheral Address */

/******************  Bit definition for DMA_SxM0AR register  ********************/
#define DMA_SxM0AR_M0A_Pos       (0U)
#define DMA_SxM0AR_M0A_Msk       (0xFFFFFFFFUL << DMA_SxM0AR_M0A_Pos)          /*!< 0xFFFFFFFF */
#define DMA_SxM0AR_M0A           DMA_SxM0AR_M0A_Msk                            /*!< Memory 0 Address */

/******************  Bit definition for DMA_SxM1AR register  ********************/
#define DMA_SxM1AR_M1A_Pos       (0U)
#define DMA_SxM1AR_M1A_Msk       (0xFFFFFFFFUL << DMA_SxM1AR_M1A_Pos)          /*!< 0xFFFFFFFF */
#define DMA_SxM1AR_M1A           DMA_SxM1AR_M1A_Msk                            /*!< Memory 1 Address */

/******************************************************************************/
/*                                                                            */
/*                             DMAMUX Controller                              */
/*                                                                            */
/******************************************************************************/
/********************  Bits definition for DMAMUX_CxCR register  **************/
#define DMAMUX_CxCR_DMAREQ_ID_Pos      (0U)
#define DMAMUX_CxCR_DMAREQ_ID_Msk      (0xFFUL << DMAMUX_CxCR_DMAREQ_ID_Pos)   /*!< 0x000000FF */
#define DMAMUX_CxCR_DMAREQ_ID          DMAMUX_CxCR_DMAREQ_ID_Msk               /*!<  DMA request identification */
#define DMAMUX_CxCR_DMAREQ_ID_0        (0x01UL << DMAMUX_CxCR_DMAREQ_ID_Pos)    /*!< 0x00000001 */
#define DMAMUX_CxCR_DMAREQ_ID_1        (0x02UL << DMAMUX_CxCR_DMAREQ_ID_Pos)    /*!< 0x00000002 */
#define DMAMUX_CxCR_DMAREQ_ID_2        (0x04UL << DMAMUX_CxCR_DMAREQ_ID_Pos)    /*!< 0x00000004 */
#define DMAMUX_CxCR_DMAREQ_ID_3        (0x08UL << DMAMUX_CxCR_DMAREQ_ID_Pos)    /*!< 0x00000008 */
#define DMAMUX_CxCR_DMAREQ_ID_4        (0x10UL << DMAMUX_CxCR_DMAREQ_ID_Pos)    /*!< 0x00000010 */
#define DMAMUX_CxCR_DMAREQ_ID_5        (0x20UL << DMAMUX_CxCR_DMAREQ_ID_Pos)    /*!< 0x00000020 */
#define DMAMUX_CxCR_DMAREQ_ID_6        (0x40UL << DMAMUX_CxCR_DMAREQ_ID_Pos)    /*!< 0x00000040 */
#define DMAMUX_CxCR_DMAREQ_ID_7        (0x80UL << DMAMUX_CxCR_DMAREQ_ID_Pos)    /*!< 0x00000080 */
#define DMAMUX_CxCR_SOIE_Pos           (8U)
#define DMAMUX_CxCR_SOIE_Msk           (0x1UL << DMAMUX_CxCR_SOIE_Pos)         /*!< 0x00000100 */
#define DMAMUX_CxCR_SOIE               DMAMUX_CxCR_SOIE_Msk                    /*!<  Synchronization overrun interrupt enable */
#define DMAMUX_CxCR_EGE_Pos            (9U)
#define DMAMUX_CxCR_EGE_Msk            (0x1UL << DMAMUX_CxCR_EGE_Pos)          /*!< 0x00000200 */
#define DMAMUX_CxCR_EGE                DMAMUX_CxCR_EGE_Msk                     /*!<  Event generation enable */
#define DMAMUX_CxCR_SE_Pos             (16U)
#define DMAMUX_CxCR_SE_Msk             (0x1UL << DMAMUX_CxCR_SE_Pos)           /*!< 0x00010000 */
#define DMAMUX_CxCR_SE                 DMAMUX_CxCR_SE_Msk                      /*!<  Synchronization enable */
#define DMAMUX_CxCR_SPOL_Pos           (17U)
#define DMAMUX_CxCR_SPOL_Msk           (0x3UL << DMAMUX_CxCR_SPOL_Pos)         /*!< 0x00060000 */
#define DMAMUX_CxCR_SPOL               DMAMUX_CxCR_SPOL_Msk                    /*!<  Synchronization polarity */
#define DMAMUX_CxCR_SPOL_0             (0x1UL << DMAMUX_CxCR_SPOL_Pos)          /*!< 0x00020000 */
#define DMAMUX_CxCR_SPOL_1             (0x2UL << DMAMUX_CxCR_SPOL_Pos)          /*!< 0x00040000 */
#define DMAMUX_CxCR_NBREQ_Pos          (19U)
#define DMAMUX_CxCR_NBREQ_Msk          (0x1FUL << DMAMUX_CxCR_NBREQ_Pos)       /*!< 0x00F80000 */
#define DMAMUX_CxCR_NBREQ              DMAMUX_CxCR_NBREQ_Msk                   /*!<  Number of DMA requests minus 1 to forward */
#define DMAMUX_CxCR_NBREQ_0            (0x01UL << DMAMUX_CxCR_NBREQ_Pos)        /*!< 0x00080000 */
#define DMAMUX_CxCR_NBREQ_1            (0x02UL << DMAMUX_CxCR_NBREQ_Pos)        /*!< 0x00100000 */
#define DMAMUX_CxCR_NBREQ_2            (0x04UL << DMAMUX_CxCR_NBREQ_Pos)        /*!< 0x00200000 */
#define DMAMUX_CxCR_NBREQ_3            (0x08UL << DMAMUX_CxCR_NBREQ_Pos)        /*!< 0x00400000 */
#define DMAMUX_CxCR_NBREQ_4            (0x10UL << DMAMUX_CxCR_NBREQ_Pos)        /*!< 0x00800000 */
#define DMAMUX_CxCR_SYNC_ID_Pos        (24U)
#define DMAMUX_CxCR_SYNC_ID_Msk        (0x1FUL << DMAMUX_CxCR_SYNC_ID_Pos)     /*!< 0x1F000000 */
#define DMAMUX_CxCR_SYNC_ID            DMAMUX_CxCR_SYNC_ID_Msk                 /*!<  Synchronization identification */
#define DMAMUX_CxCR_SYNC_ID_0          (0x01UL << DMAMUX_CxCR_SYNC_ID_Pos)      /*!< 0x01000000 */
#define DMAMUX_CxCR_SYNC_ID_1          (0x02UL << DMAMUX_CxCR_SYNC_ID_Pos)      /*!< 0x02000000 */
#define DMAMUX_CxCR_SYNC_ID_2          (0x04UL << DMAMUX_CxCR_SYNC_ID_Pos)      /*!< 0x04000000 */
#define DMAMUX_CxCR_SYNC_ID_3          (0x08UL << DMAMUX_CxCR_SYNC_ID_Pos)      /*!< 0x08000000 */
#define DMAMUX_CxCR_SYNC_ID_4          (0x10UL << DMAMUX_CxCR_SYNC_ID_Pos)      /*!< 0x10000000 */

/********************  Bits definition for DMAMUX_CSR register  **************/
#define DMAMUX_CSR_SOF0_Pos            (0U)
#define DMAMUX_CSR_SOF0_Msk            (0x1UL << DMAMUX_CSR_SOF0_Pos)          /*!< 0x00000001 */
#define DMAMUX_CSR_SOF0                DMAMUX_CSR_SOF0_Msk                     /*!< Channel 0 Synchronization overrun event flag */
#define DMAMUX_CSR_SOF1_Pos            (1U)
#define DMAMUX_CSR_SOF1_Msk            (0x1UL << DMAMUX_CSR_SOF1_Pos)          /*!< 0x00000002 */
#define DMAMUX_CSR_SOF1                DMAMUX_CSR_SOF1_Msk                     /*!< Channel 1 Synchronization overrun event flag */
#define DMAMUX_CSR_SOF2_Pos            (2U)
#define DMAMUX_CSR_SOF2_Msk            (0x1UL << DMAMUX_CSR_SOF2_Pos)          /*!< 0x00000004 */
#define DMAMUX_CSR_SOF2                DMAMUX_CSR_SOF2_Msk                     /*!< Channel 2 Synchronization overrun event flag */
#define DMAMUX_CSR_SOF3_Pos            (3U)
#define DMAMUX_CSR_SOF3_Msk            (0x1UL << DMAMUX_CSR_SOF3_Pos)          /*!< 0x00000008 */
#define DMAMUX_CSR_SOF3                DMAMUX_CSR_SOF3_Msk                     /*!< Channel 3 Synchronization overrun event flag */
#define DMAMUX_CSR_SOF4_Pos            (4U)
#define DMAMUX_CSR_SOF4_Msk            (0x1UL << DMAMUX_CSR_SOF4_Pos)          /*!< 0x00000010 */
#define DMAMUX_CSR_SOF4                DMAMUX_CSR_SOF4_Msk                     /*!< Channel 4 Synchronization overrun event flag */
#define DMAMUX_CSR_SOF5_Pos            (5U)
#define DMAMUX_CSR_SOF5_Msk            (0x1UL << DMAMUX_CSR_SOF5_Pos)          /*!< 0x00000020 */
#define DMAMUX_CSR_SOF5                DMAMUX_CSR_SOF5_Msk                     /*!< Channel 5 Synchronization overrun event flag */
#define DMAMUX_CSR_SOF6_Pos            (6U)
#define DMAMUX_CSR_SOF6_Msk            (0x1UL << DMAMUX_CSR_SOF6_Pos)          /*!< 0x00000040 */
#define DMAMUX_CSR_SOF6                DMAMUX_CSR_SOF6_Msk                     /*!< Channel 6 Synchronization overrun event flag */
#define DMAMUX_CSR_SOF7_Pos            (7U)
#define DMAMUX_CSR_SOF7_Msk            (0x1UL << DMAMUX_CSR_SOF7_Pos)          /*!< 0x00000080 */
#define DMAMUX_CSR_SOF7                DMAMUX_CSR_SOF7_Msk                     /*!< Channel 7 Synchronization overrun event flag */
#define DMAMUX_CSR_SOF8_Pos            (8U)
#define DMAMUX_CSR_SOF8_Msk            (0x1UL << DMAMUX_CSR_SOF8_Pos)          /*!< 0x00000100 */
#define DMAMUX_CSR_SOF8                DMAMUX_CSR_SOF8_Msk                     /*!< Channel 8 Synchronization overrun event flag */
#define DMAMUX_CSR_SOF9_Pos            (9U)
#define DMAMUX_CSR_SOF9_Msk            (0x1UL << DMAMUX_CSR_SOF9_Pos)          /*!< 0x00000200 */
#define DMAMUX_CSR_SOF9                DMAMUX_CSR_SOF9_Msk                     /*!< Channel 9 Synchronization overrun event flag */
#define DMAMUX_CSR_SOF10_Pos           (10U)
#define DMAMUX_CSR_SOF10_Msk           (0x1UL << DMAMUX_CSR_SOF10_Pos)         /*!< 0x00000400 */
#define DMAMUX_CSR_SOF10               DMAMUX_CSR_SOF10_Msk                    /*!< Channel 10 Synchronization overrun event flag */
#define DMAMUX_CSR_SOF11_Pos           (11U)
#define DMAMUX_CSR_SOF11_Msk           (0x1UL << DMAMUX_CSR_SOF11_Pos)         /*!< 0x00000800 */
#define DMAMUX_CSR_SOF11               DMAMUX_CSR_SOF11_Msk                    /*!< Channel 11 Synchronization overrun event flag */
#define DMAMUX_CSR_SOF12_Pos           (12U)
#define DMAMUX_CSR_SOF12_Msk           (0x1UL << DMAMUX_CSR_SOF12_Pos)         /*!< 0x00001000 */
#define DMAMUX_CSR_SOF12               DMAMUX_CSR_SOF12_Msk                    /*!< Channel 12 Synchronization overrun event flag */
#define DMAMUX_CSR_SOF13_Pos           (13U)
#define DMAMUX_CSR_SOF13_Msk           (0x1UL << DMAMUX_CSR_SOF13_Pos)         /*!< 0x00002000 */
#define DMAMUX_CSR_SOF13               DMAMUX_CSR_SOF13_Msk                    /*!< Channel 13 Synchronization overrun event flag */
#define DMAMUX_CSR_SOF14_Pos           (14U)
#define DMAMUX_CSR_SOF14_Msk           (0x1UL << DMAMUX_CSR_SOF14_Pos)         /*!< 0x00004000 */
#define DMAMUX_CSR_SOF14               DMAMUX_CSR_SOF14_Msk                    /*!< Channel 14 Synchronization overrun event flag */
#define DMAMUX_CSR_SOF15_Pos           (15U)
#define DMAMUX_CSR_SOF15_Msk           (0x1UL << DMAMUX_CSR_SOF15_Pos)         /*!< 0x00008000 */
#define DMAMUX_CSR_SOF15               DMAMUX_CSR_SOF15_Msk                    /*!< Channel 15 Synchronization overrun event flag */

/********************  Bits definition for DMAMUX_CFR register  **************/
#define DMAMUX_CFR_CSOF0_Pos           (0U)
#define DMAMUX_CFR_CSOF0_Msk           (0x1UL << DMAMUX_CFR_CSOF0_Pos)         /*!< 0x00000001 */
#define DMAMUX_CFR_CSOF0               DMAMUX_CFR_CSOF0_Msk                    /*!< Channel 0 Clear synchronization overrun event flag */
#define DMAMUX_CFR_CSOF1_Pos           (1U)
#define DMAMUX_CFR_CSOF1_Msk           (0x1UL << DMAMUX_CFR_CSOF1_Pos)         /*!< 0x00000002 */
#define DMAMUX_CFR_CSOF1               DMAMUX_CFR_CSOF1_Msk                    /*!< Channel 1 Clear synchronization overrun event flag */
#define DMAMUX_CFR_CSOF2_Pos           (2U)
#define DMAMUX_CFR_CSOF2_Msk           (0x1UL << DMAMUX_CFR_CSOF2_Pos)         /*!< 0x00000004 */
#define DMAMUX_CFR_CSOF2               DMAMUX_CFR_CSOF2_Msk                    /*!< Channel 2 Clear synchronization overrun event flag */
#define DMAMUX_CFR_CSOF3_Pos           (3U)
#define DMAMUX_CFR_CSOF3_Msk           (0x1UL << DMAMUX_CFR_CSOF3_Pos)         /*!< 0x00000008 */
#define DMAMUX_CFR_CSOF3               DMAMUX_CFR_CSOF3_Msk                    /*!< Channel 3 Clear synchronization overrun event flag */
#define DMAMUX_CFR_CSOF4_Pos           (4U)
#define DMAMUX_CFR_CSOF4_Msk           (0x1UL << DMAMUX_CFR_CSOF4_Pos)         /*!< 0x00000010 */
#define DMAMUX_CFR_CSOF4               DMAMUX_CFR_CSOF4_Msk                    /*!< Channel 4 Clear synchronization overrun event flag */
#define DMAMUX_CFR_CSOF5_Pos           (5U)
#define DMAMUX_CFR_CSOF5_Msk           (0x1UL << DMAMUX_CFR_CSOF5_Pos)         /*!< 0x00000020 */
#define DMAMUX_CFR_CSOF5               DMAMUX_CFR_CSOF5_Msk                    /*!< Channel 5 Clear synchronization overrun event flag */
#define DMAMUX_CFR_CSOF6_Pos           (6U)
#define DMAMUX_CFR_CSOF6_Msk           (0x1UL << DMAMUX_CFR_CSOF6_Pos)         /*!< 0x00000040 */
#define DMAMUX_CFR_CSOF6               DMAMUX_CFR_CSOF6_Msk                    /*!< Channel 6 Clear synchronization overrun event flag */
#define DMAMUX_CFR_CSOF7_Pos           (7U)
#define DMAMUX_CFR_CSOF7_Msk           (0x1UL << DMAMUX_CFR_CSOF7_Pos)         /*!< 0x00000080 */
#define DMAMUX_CFR_CSOF7               DMAMUX_CFR_CSOF7_Msk                    /*!< Channel 7 Clear synchronization overrun event flag */
#define DMAMUX_CFR_CSOF8_Pos           (8U)
#define DMAMUX_CFR_CSOF8_Msk           (0x1UL << DMAMUX_CFR_CSOF8_Pos)         /*!< 0x00000100 */
#define DMAMUX_CFR_CSOF8               DMAMUX_CFR_CSOF8_Msk                    /*!< Channel 8 Clear synchronization overrun event flag */
#define DMAMUX_CFR_CSOF9_Pos           (9U)
#define DMAMUX_CFR_CSOF9_Msk           (0x1UL << DMAMUX_CFR_CSOF9_Pos)         /*!< 0x00000200 */
#define DMAMUX_CFR_CSOF9               DMAMUX_CFR_CSOF9_Msk                    /*!< Channel 9 Clear synchronization overrun event flag */
#define DMAMUX_CFR_CSOF10_Pos          (10U)
#define DMAMUX_CFR_CSOF10_Msk          (0x1UL << DMAMUX_CFR_CSOF10_Pos)        /*!< 0x00000400 */
#define DMAMUX_CFR_CSOF10              DMAMUX_CFR_CSOF10_Msk                   /*!< Channel 10 Clear synchronization overrun event flag */
#define DMAMUX_CFR_CSOF11_Pos          (11U)
#define DMAMUX_CFR_CSOF11_Msk          (0x1UL << DMAMUX_CFR_CSOF11_Pos)        /*!< 0x00000800 */
#define DMAMUX_CFR_CSOF11              DMAMUX_CFR_CSOF11_Msk                   /*!< Channel 11 Clear synchronization overrun event flag */
#define DMAMUX_CFR_CSOF12_Pos          (12U)
#define DMAMUX_CFR_CSOF12_Msk          (0x1UL << DMAMUX_CFR_CSOF12_Pos)        /*!< 0x00001000 */
#define DMAMUX_CFR_CSOF12              DMAMUX_CFR_CSOF12_Msk                   /*!< Channel 12 Clear synchronization overrun event flag */
#define DMAMUX_CFR_CSOF13_Pos          (13U)
#define DMAMUX_CFR_CSOF13_Msk          (0x1UL << DMAMUX_CFR_CSOF13_Pos)        /*!< 0x00002000 */
#define DMAMUX_CFR_CSOF13              DMAMUX_CFR_CSOF13_Msk                   /*!< Channel 13 Clear synchronization overrun event flag */
#define DMAMUX_CFR_CSOF14_Pos          (14U)
#define DMAMUX_CFR_CSOF14_Msk          (0x1UL << DMAMUX_CFR_CSOF14_Pos)        /*!< 0x00004000 */
#define DMAMUX_CFR_CSOF14              DMAMUX_CFR_CSOF14_Msk                   /*!< Channel 14 Clear synchronization overrun event flag */
#define DMAMUX_CFR_CSOF15_Pos          (15U)
#define DMAMUX_CFR_CSOF15_Msk          (0x1UL << DMAMUX_CFR_CSOF15_Pos)        /*!< 0x00008000 */
#define DMAMUX_CFR_CSOF15              DMAMUX_CFR_CSOF15_Msk                   /*!< Channel 15 Clear synchronization overrun event flag */

/********************  Bits definition for DMAMUX_RGxCR register  ************/
#define DMAMUX_RGxCR_SIG_ID_Pos        (0U)
#define DMAMUX_RGxCR_SIG_ID_Msk        (0x1FUL << DMAMUX_RGxCR_SIG_ID_Pos)     /*!< 0x0000001F */
#define DMAMUX_RGxCR_SIG_ID            DMAMUX_RGxCR_SIG_ID_Msk                 /*!< Signal identification */
#define DMAMUX_RGxCR_SIG_ID_0          (0x01UL << DMAMUX_RGxCR_SIG_ID_Pos)      /*!< 0x00000001 */
#define DMAMUX_RGxCR_SIG_ID_1          (0x02UL << DMAMUX_RGxCR_SIG_ID_Pos)      /*!< 0x00000002 */
#define DMAMUX_RGxCR_SIG_ID_2          (0x04UL << DMAMUX_RGxCR_SIG_ID_Pos)      /*!< 0x00000004 */
#define DMAMUX_RGxCR_SIG_ID_3          (0x08UL << DMAMUX_RGxCR_SIG_ID_Pos)      /*!< 0x00000008 */
#define DMAMUX_RGxCR_SIG_ID_4          (0x10UL << DMAMUX_RGxCR_SIG_ID_Pos)      /*!< 0x00000010 */
#define DMAMUX_RGxCR_OIE_Pos           (8U)
#define DMAMUX_RGxCR_OIE_Msk           (0x1UL << DMAMUX_RGxCR_OIE_Pos)         /*!< 0x00000100 */
#define DMAMUX_RGxCR_OIE               DMAMUX_RGxCR_OIE_Msk                    /*!< Trigger overrun interrupt enable */
#define DMAMUX_RGxCR_GE_Pos            (16U)
#define DMAMUX_RGxCR_GE_Msk            (0x1UL << DMAMUX_RGxCR_GE_Pos)          /*!< 0x00010000 */
#define DMAMUX_RGxCR_GE                DMAMUX_RGxCR_GE_Msk                     /*!< DMA request generator enable */
#define DMAMUX_RGxCR_GPOL_Pos          (17U)
#define DMAMUX_RGxCR_GPOL_Msk          (0x3UL << DMAMUX_RGxCR_GPOL_Pos)        /*!< 0x00060000 */
#define DMAMUX_RGxCR_GPOL              DMAMUX_RGxCR_GPOL_Msk                   /*!< DMA request generator trigger polarity */
#define DMAMUX_RGxCR_GPOL_0            (0x1UL << DMAMUX_RGxCR_GPOL_Pos)         /*!< 0x00020000 */
#define DMAMUX_RGxCR_GPOL_1            (0x2UL << DMAMUX_RGxCR_GPOL_Pos)         /*!< 0x00040000 */
#define DMAMUX_RGxCR_GNBREQ_Pos        (19U)
#define DMAMUX_RGxCR_GNBREQ_Msk        (0x1FUL << DMAMUX_RGxCR_GNBREQ_Pos)     /*!< 0x00F80000 */
#define DMAMUX_RGxCR_GNBREQ            DMAMUX_RGxCR_GNBREQ_Msk                 /*!< Number of DMA requests to be generated */
#define DMAMUX_RGxCR_GNBREQ_0          (0x01UL << DMAMUX_RGxCR_GNBREQ_Pos)      /*!< 0x00080000 */
#define DMAMUX_RGxCR_GNBREQ_1          (0x02UL << DMAMUX_RGxCR_GNBREQ_Pos)      /*!< 0x00100000 */
#define DMAMUX_RGxCR_GNBREQ_2          (0x04UL << DMAMUX_RGxCR_GNBREQ_Pos)      /*!< 0x00200000 */
#define DMAMUX_RGxCR_GNBREQ_3          (0x08UL << DMAMUX_RGxCR_GNBREQ_Pos)      /*!< 0x00400000 */
#define DMAMUX_RGxCR_GNBREQ_4          (0x10UL << DMAMUX_RGxCR_GNBREQ_Pos)      /*!< 0x00800000 */

/********************  Bits definition for DMAMUX_RGSR register  **************/
#define DMAMUX_RGSR_OF0_Pos            (0U)
#define DMAMUX_RGSR_OF0_Msk            (0x1UL << DMAMUX_RGSR_OF0_Pos)          /*!< 0x00000001 */
#define DMAMUX_RGSR_OF0                DMAMUX_RGSR_OF0_Msk                     /*!< Request generator channel 0 Trigger overrun event flag */
#define DMAMUX_RGSR_OF1_Pos            (1U)
#define DMAMUX_RGSR_OF1_Msk            (0x1UL << DMAMUX_RGSR_OF1_Pos)          /*!< 0x00000002 */
#define DMAMUX_RGSR_OF1                DMAMUX_RGSR_OF1_Msk                     /*!< Request generator channel 1 Trigger overrun event flag */
#define DMAMUX_RGSR_OF2_Pos            (2U)
#define DMAMUX_RGSR_OF2_Msk            (0x1UL << DMAMUX_RGSR_OF2_Pos)          /*!< 0x00000004 */
#define DMAMUX_RGSR_OF2                DMAMUX_RGSR_OF2_Msk                     /*!< Request generator channel 2 Trigger overrun event flag */
#define DMAMUX_RGSR_OF3_Pos            (3U)
#define DMAMUX_RGSR_OF3_Msk            (0x1UL << DMAMUX_RGSR_OF3_Pos)          /*!< 0x00000008 */
#define DMAMUX_RGSR_OF3                DMAMUX_RGSR_OF3_Msk                     /*!< Request generator channel 3 Trigger overrun event flag */
#define DMAMUX_RGSR_OF4_Pos            (4U)
#define DMAMUX_RGSR_OF4_Msk            (0x1UL << DMAMUX_RGSR_OF4_Pos)          /*!< 0x00000010 */
#define DMAMUX_RGSR_OF4                DMAMUX_RGSR_OF4_Msk                     /*!< Request generator channel 4 Trigger overrun event flag */
#define DMAMUX_RGSR_OF5_Pos            (5U)
#define DMAMUX_RGSR_OF5_Msk            (0x1UL << DMAMUX_RGSR_OF5_Pos)          /*!< 0x00000020 */
#define DMAMUX_RGSR_OF5                DMAMUX_RGSR_OF5_Msk                     /*!< Request generator channel 5 Trigger overrun event flag */
#define DMAMUX_RGSR_OF6_Pos            (6U)
#define DMAMUX_RGSR_OF6_Msk            (0x1UL << DMAMUX_RGSR_OF6_Pos)          /*!< 0x00000040 */
#define DMAMUX_RGSR_OF6                DMAMUX_RGSR_OF6_Msk                     /*!< Request generator channel 6 Trigger overrun event flag */
#define DMAMUX_RGSR_OF7_Pos            (7U)
#define DMAMUX_RGSR_OF7_Msk            (0x1UL << DMAMUX_RGSR_OF7_Pos)          /*!< 0x00000080 */
#define DMAMUX_RGSR_OF7                DMAMUX_RGSR_OF7_Msk                     /*!< Request generator channel 7 Trigger overrun event flag */

/********************  Bits definition for DMAMUX_RGCFR register  **************/
#define DMAMUX_RGCFR_COF0_Pos          (0U)
#define DMAMUX_RGCFR_COF0_Msk          (0x1UL << DMAMUX_RGCFR_COF0_Pos)        /*!< 0x00000001 */
#define DMAMUX_RGCFR_COF0              DMAMUX_RGCFR_COF0_Msk                   /*!< Request generator channel 0 Clear trigger overrun event flag */
#define DMAMUX_RGCFR_COF1_Pos          (1U)
#define DMAMUX_RGCFR_COF1_Msk          (0x1UL << DMAMUX_RGCFR_COF1_Pos)        /*!< 0x00000002 */
#define DMAMUX_RGCFR_COF1              DMAMUX_RGCFR_COF1_Msk                   /*!< Request generator channel 1 Clear trigger overrun event flag */
#define DMAMUX_RGCFR_COF2_Pos          (2U)
#define DMAMUX_RGCFR_COF2_Msk          (0x1UL << DMAMUX_RGCFR_COF2_Pos)        /*!< 0x00000004 */
#define DMAMUX_RGCFR_COF2              DMAMUX_RGCFR_COF2_Msk                   /*!< Request generator channel 2 Clear trigger overrun event flag */
#define DMAMUX_RGCFR_COF3_Pos          (3U)
#define DMAMUX_RGCFR_COF3_Msk          (0x1UL << DMAMUX_RGCFR_COF3_Pos)        /*!< 0x00000008 */
#define DMAMUX_RGCFR_COF3              DMAMUX_RGCFR_COF3_Msk                   /*!< Request generator channel 3 Clear trigger overrun event flag */
#define DMAMUX_RGCFR_COF4_Pos          (4U)
#define DMAMUX_RGCFR_COF4_Msk          (0x1UL << DMAMUX_RGCFR_COF4_Pos)        /*!< 0x00000010 */
#define DMAMUX_RGCFR_COF4              DMAMUX_RGCFR_COF4_Msk                   /*!< Request generator channel 4 Clear trigger overrun event flag */
#define DMAMUX_RGCFR_COF5_Pos          (5U)
#define DMAMUX_RGCFR_COF5_Msk          (0x1UL << DMAMUX_RGCFR_COF5_Pos)        /*!< 0x00000020 */
#define DMAMUX_RGCFR_COF5              DMAMUX_RGCFR_COF5_Msk                   /*!< Request generator channel 5 Clear trigger overrun event flag */
#define DMAMUX_RGCFR_COF6_Pos          (6U)
#define DMAMUX_RGCFR_COF6_Msk          (0x1UL << DMAMUX_RGCFR_COF6_Pos)        /*!< 0x00000040 */
#define DMAMUX_RGCFR_COF6              DMAMUX_RGCFR_COF6_Msk                   /*!< Request generator channel 6 Clear trigger overrun event flag */
#define DMAMUX_RGCFR_COF7_Pos          (7U)
#define DMAMUX_RGCFR_COF7_Msk          (0x1UL << DMAMUX_RGCFR_COF7_Pos)        /*!< 0x00000080 */
#define DMAMUX_RGCFR_COF7              DMAMUX_RGCFR_COF7_Msk                   /*!< Request generator channel 7 Clear trigger overrun event flag */

/******************************************************************************/
/*                                                                            */
/*                         AHB Master DMA2D Controller (DMA2D)                */
/*                                                                            */
/******************************************************************************/

/********************  Bit definition for DMA2D_CR register  ******************/

#define DMA2D_CR_START_Pos         (0U)
#define DMA2D_CR_START_Msk         (0x1UL << DMA2D_CR_START_Pos)               /*!< 0x00000001 */
#define DMA2D_CR_START             DMA2D_CR_START_Msk                          /*!< Start transfer                          */
#define DMA2D_CR_SUSP_Pos          (1U)
#define DMA2D_CR_SUSP_Msk          (0x1UL << DMA2D_CR_SUSP_Pos)                /*!< 0x00000002 */
#define DMA2D_CR_SUSP              DMA2D_CR_SUSP_Msk                           /*!< Suspend transfer                        */
#define DMA2D_CR_ABORT_Pos         (2U)
#define DMA2D_CR_ABORT_Msk         (0x1UL << DMA2D_CR_ABORT_Pos)               /*!< 0x00000004 */
#define DMA2D_CR_ABORT             DMA2D_CR_ABORT_Msk                          /*!< Abort transfer                          */
#define DMA2D_CR_LOM_Pos           (6U)
#define DMA2D_CR_LOM_Msk           (0x1UL << DMA2D_CR_LOM_Pos)                 /*!< 0x00000040 */
#define DMA2D_CR_LOM               DMA2D_CR_LOM_Msk                            /*!< Line Offset Mode                         */
#define DMA2D_CR_TEIE_Pos          (8U)
#define DMA2D_CR_TEIE_Msk          (0x1UL << DMA2D_CR_TEIE_Pos)                /*!< 0x00000100 */
#define DMA2D_CR_TEIE              DMA2D_CR_TEIE_Msk                           /*!< Transfer Error Interrupt Enable         */
#define DMA2D_CR_TCIE_Pos          (9U)
#define DMA2D_CR_TCIE_Msk          (0x1UL << DMA2D_CR_TCIE_Pos)                /*!< 0x00000200 */
#define DMA2D_CR_TCIE              DMA2D_CR_TCIE_Msk                           /*!< Transfer Complete Interrupt Enable      */
#define DMA2D_CR_TWIE_Pos          (10U)
#define DMA2D_CR_TWIE_Msk          (0x1UL << DMA2D_CR_TWIE_Pos)                /*!< 0x00000400 */
#define DMA2D_CR_TWIE              DMA2D_CR_TWIE_Msk                           /*!< Transfer Watermark Interrupt Enable     */
#define DMA2D_CR_CAEIE_Pos         (11U)
#define DMA2D_CR_CAEIE_Msk         (0x1UL << DMA2D_CR_CAEIE_Pos)               /*!< 0x00000800 */
#define DMA2D_CR_CAEIE             DMA2D_CR_CAEIE_Msk                          /*!< CLUT Access Error Interrupt Enable      */
#define DMA2D_CR_CTCIE_Pos         (12U)
#define DMA2D_CR_CTCIE_Msk         (0x1UL << DMA2D_CR_CTCIE_Pos)               /*!< 0x00001000 */
#define DMA2D_CR_CTCIE             DMA2D_CR_CTCIE_Msk                          /*!< CLUT Transfer Complete Interrupt Enable */
#define DMA2D_CR_CEIE_Pos          (13U)
#define DMA2D_CR_CEIE_Msk          (0x1UL << DMA2D_CR_CEIE_Pos)                /*!< 0x00002000 */
#define DMA2D_CR_CEIE              DMA2D_CR_CEIE_Msk                           /*!< Configuration Error Interrupt Enable    */
#define DMA2D_CR_MODE_Pos          (16U)
#define DMA2D_CR_MODE_Msk          (0x7UL << DMA2D_CR_MODE_Pos)                /*!< 0x00070000 */
#define DMA2D_CR_MODE              DMA2D_CR_MODE_Msk                           /*!< DMA2D Mode[2:0]                         */
#define DMA2D_CR_MODE_0            (0x1UL << DMA2D_CR_MODE_Pos)                 /*!< 0x00010000 */
#define DMA2D_CR_MODE_1            (0x2UL << DMA2D_CR_MODE_Pos)                 /*!< 0x00020000 */
#define DMA2D_CR_MODE_2            (0x4UL << DMA2D_CR_MODE_Pos)                 /*!< 0x00040000 */

/********************  Bit definition for DMA2D_ISR register  *****************/

#define DMA2D_ISR_TEIF_Pos         (0U)
#define DMA2D_ISR_TEIF_Msk         (0x1UL << DMA2D_ISR_TEIF_Pos)               /*!< 0x00000001 */
#define DMA2D_ISR_TEIF             DMA2D_ISR_TEIF_Msk                          /*!< Transfer Error Interrupt Flag         */
#define DMA2D_ISR_TCIF_Pos         (1U)
#define DMA2D_ISR_TCIF_Msk         (0x1UL << DMA2D_ISR_TCIF_Pos)               /*!< 0x00000002 */
#define DMA2D_ISR_TCIF             DMA2D_ISR_TCIF_Msk                          /*!< Transfer Complete Interrupt Flag      */
#define DMA2D_ISR_TWIF_Pos         (2U)
#define DMA2D_ISR_TWIF_Msk         (0x1UL << DMA2D_ISR_TWIF_Pos)               /*!< 0x00000004 */
#define DMA2D_ISR_TWIF             DMA2D_ISR_TWIF_Msk                          /*!< Transfer Watermark Interrupt Flag     */
#define DMA2D_ISR_CAEIF_Pos        (3U)
#define DMA2D_ISR_CAEIF_Msk        (0x1UL << DMA2D_ISR_CAEIF_Pos)              /*!< 0x00000008 */
#define DMA2D_ISR_CAEIF            DMA2D_ISR_CAEIF_Msk                         /*!< CLUT Access Error Interrupt Flag      */
#define DMA2D_ISR_CTCIF_Pos        (4U)
#define DMA2D_ISR_CTCIF_Msk        (0x1UL << DMA2D_ISR_CTCIF_Pos)              /*!< 0x00000010 */
#define DMA2D_ISR_CTCIF            DMA2D_ISR_CTCIF_Msk                         /*!< CLUT Transfer Complete Interrupt Flag */
#define DMA2D_ISR_CEIF_Pos         (5U)
#define DMA2D_ISR_CEIF_Msk         (0x1UL << DMA2D_ISR_CEIF_Pos)               /*!< 0x00000020 */
#define DMA2D_ISR_CEIF             DMA2D_ISR_CEIF_Msk                          /*!< Configuration Error Interrupt Flag    */

/********************  Bit definition for DMA2D_IFCR register  ****************/

#define DMA2D_IFCR_CTEIF_Pos       (0U)
#define DMA2D_IFCR_CTEIF_Msk       (0x1UL << DMA2D_IFCR_CTEIF_Pos)             /*!< 0x00000001 */
#define DMA2D_IFCR_CTEIF           DMA2D_IFCR_CTEIF_Msk                        /*!< Clears Transfer Error Interrupt Flag         */
#define DMA2D_IFCR_CTCIF_Pos       (1U)
#define DMA2D_IFCR_CTCIF_Msk       (0x1UL << DMA2D_IFCR_CTCIF_Pos)             /*!< 0x00000002 */
#define DMA2D_IFCR_CTCIF           DMA2D_IFCR_CTCIF_Msk                        /*!< Clears Transfer Complete Interrupt Flag      */
#define DMA2D_IFCR_CTWIF_Pos       (2U)
#define DMA2D_IFCR_CTWIF_Msk       (0x1UL << DMA2D_IFCR_CTWIF_Pos)             /*!< 0x00000004 */
#define DMA2D_IFCR_CTWIF           DMA2D_IFCR_CTWIF_Msk                        /*!< Clears Transfer Watermark Interrupt Flag     */
#define DMA2D_IFCR_CAECIF_Pos      (3U)
#define DMA2D_IFCR_CAECIF_Msk      (0x1UL << DMA2D_IFCR_CAECIF_Pos)            /*!< 0x00000008 */
#define DMA2D_IFCR_CAECIF          DMA2D_IFCR_CAECIF_Msk                       /*!< Clears CLUT Access Error Interrupt Flag      */
#define DMA2D_IFCR_CCTCIF_Pos      (4U)
#define DMA2D_IFCR_CCTCIF_Msk      (0x1UL << DMA2D_IFCR_CCTCIF_Pos)            /*!< 0x00000010 */
#define DMA2D_IFCR_CCTCIF          DMA2D_IFCR_CCTCIF_Msk                       /*!< Clears CLUT Transfer Complete Interrupt Flag */
#define DMA2D_IFCR_CCEIF_Pos       (5U)
#define DMA2D_IFCR_CCEIF_Msk       (0x1UL << DMA2D_IFCR_CCEIF_Pos)             /*!< 0x00000020 */
#define DMA2D_IFCR_CCEIF           DMA2D_IFCR_CCEIF_Msk                        /*!< Clears Configuration Error Interrupt Flag    */

/********************  Bit definition for DMA2D_FGMAR register  ***************/

#define DMA2D_FGMAR_MA_Pos         (0U)
#define DMA2D_FGMAR_MA_Msk         (0xFFFFFFFFUL << DMA2D_FGMAR_MA_Pos)        /*!< 0xFFFFFFFF */
#define DMA2D_FGMAR_MA             DMA2D_FGMAR_MA_Msk                          /*!< Foreground Memory Address */

/********************  Bit definition for DMA2D_FGOR register  ****************/

#define DMA2D_FGOR_LO_Pos          (0U)
#define DMA2D_FGOR_LO_Msk          (0xFFFFUL << DMA2D_FGOR_LO_Pos)             /*!< 0x0000FFFF */
#define DMA2D_FGOR_LO              DMA2D_FGOR_LO_Msk                           /*!< Line Offset */

/********************  Bit definition for DMA2D_BGMAR register  ***************/

#define DMA2D_BGMAR_MA_Pos         (0U)
#define DMA2D_BGMAR_MA_Msk         (0xFFFFFFFFUL << DMA2D_BGMAR_MA_Pos)        /*!< 0xFFFFFFFF */
#define DMA2D_BGMAR_MA             DMA2D_BGMAR_MA_Msk                          /*!< Background Memory Address */

/********************  Bit definition for DMA2D_BGOR register  ****************/

#define DMA2D_BGOR_LO_Pos          (0U)
#define DMA2D_BGOR_LO_Msk          (0xFFFFUL << DMA2D_BGOR_LO_Pos)             /*!< 0x0000FFFF */
#define DMA2D_BGOR_LO              DMA2D_BGOR_LO_Msk                           /*!< Line Offset */

/********************  Bit definition for DMA2D_FGPFCCR register  *************/

#define DMA2D_FGPFCCR_CM_Pos       (0U)
#define DMA2D_FGPFCCR_CM_Msk       (0xFUL << DMA2D_FGPFCCR_CM_Pos)             /*!< 0x0000000F */
#define DMA2D_FGPFCCR_CM           DMA2D_FGPFCCR_CM_Msk                        /*!< Input color mode CM[3:0] */
#define DMA2D_FGPFCCR_CM_0         (0x1UL << DMA2D_FGPFCCR_CM_Pos)              /*!< 0x00000001 */
#define DMA2D_FGPFCCR_CM_1         (0x2UL << DMA2D_FGPFCCR_CM_Pos)              /*!< 0x00000002 */
#define DMA2D_FGPFCCR_CM_2         (0x4UL << DMA2D_FGPFCCR_CM_Pos)              /*!< 0x00000004 */
#define DMA2D_FGPFCCR_CM_3         (0x8UL << DMA2D_FGPFCCR_CM_Pos)              /*!< 0x00000008 */
#define DMA2D_FGPFCCR_CCM_Pos      (4U)
#define DMA2D_FGPFCCR_CCM_Msk      (0x1UL << DMA2D_FGPFCCR_CCM_Pos)            /*!< 0x00000010 */
#define DMA2D_FGPFCCR_CCM          DMA2D_FGPFCCR_CCM_Msk                       /*!< CLUT Color mode */
#define DMA2D_FGPFCCR_START_Pos    (5U)
#define DMA2D_FGPFCCR_START_Msk    (0x1UL << DMA2D_FGPFCCR_START_Pos)          /*!< 0x00000020 */
#define DMA2D_FGPFCCR_START        DMA2D_FGPFCCR_START_Msk                     /*!< Start */
#define DMA2D_FGPFCCR_CS_Pos       (8U)
#define DMA2D_FGPFCCR_CS_Msk       (0xFFUL << DMA2D_FGPFCCR_CS_Pos)            /*!< 0x0000FF00 */
#define DMA2D_FGPFCCR_CS           DMA2D_FGPFCCR_CS_Msk                        /*!< CLUT size */
#define DMA2D_FGPFCCR_AM_Pos       (16U)
#define DMA2D_FGPFCCR_AM_Msk       (0x3UL << DMA2D_FGPFCCR_AM_Pos)             /*!< 0x00030000 */
#define DMA2D_FGPFCCR_AM           DMA2D_FGPFCCR_AM_Msk                        /*!< Alpha mode AM[1:0] */
#define DMA2D_FGPFCCR_AM_0         (0x1UL << DMA2D_FGPFCCR_AM_Pos)              /*!< 0x00010000 */
#define DMA2D_FGPFCCR_AM_1         (0x2UL << DMA2D_FGPFCCR_AM_Pos)              /*!< 0x00020000 */
#define DMA2D_FGPFCCR_CSS_Pos      (18U)
#define DMA2D_FGPFCCR_CSS_Msk      (0x3UL << DMA2D_FGPFCCR_CSS_Pos)            /*!< 0x000C0000 */
#define DMA2D_FGPFCCR_CSS          DMA2D_FGPFCCR_CSS_Msk                       /* !< Chroma Sub-Sampling */
#define DMA2D_FGPFCCR_CSS_0        (0x1UL << DMA2D_FGPFCCR_CSS_Pos)             /*!< 0x00040000 */
#define DMA2D_FGPFCCR_CSS_1        (0x2UL << DMA2D_FGPFCCR_CSS_Pos)             /*!< 0x00080000 */
#define DMA2D_FGPFCCR_AI_Pos       (20U)
#define DMA2D_FGPFCCR_AI_Msk       (0x1UL << DMA2D_FGPFCCR_AI_Pos)             /*!< 0x00100000 */
#define DMA2D_FGPFCCR_AI           DMA2D_FGPFCCR_AI_Msk                        /*!< Foreground Input Alpha Inverted */
#define DMA2D_FGPFCCR_RBS_Pos      (21U)
#define DMA2D_FGPFCCR_RBS_Msk      (0x1UL << DMA2D_FGPFCCR_RBS_Pos)            /*!< 0x00200000 */
#define DMA2D_FGPFCCR_RBS          DMA2D_FGPFCCR_RBS_Msk                       /*!< Foreground Input Red Blue Swap */
#define DMA2D_FGPFCCR_ALPHA_Pos    (24U)
#define DMA2D_FGPFCCR_ALPHA_Msk    (0xFFUL << DMA2D_FGPFCCR_ALPHA_Pos)         /*!< 0xFF000000 */
#define DMA2D_FGPFCCR_ALPHA        DMA2D_FGPFCCR_ALPHA_Msk                     /*!< Alpha value */

/********************  Bit definition for DMA2D_FGCOLR register  **************/

#define DMA2D_FGCOLR_BLUE_Pos      (0U)
#define DMA2D_FGCOLR_BLUE_Msk      (0xFFUL << DMA2D_FGCOLR_BLUE_Pos)           /*!< 0x000000FF */
#define DMA2D_FGCOLR_BLUE          DMA2D_FGCOLR_BLUE_Msk                       /*!< Foreground Blue Value */
#define DMA2D_FGCOLR_GREEN_Pos     (8U)
#define DMA2D_FGCOLR_GREEN_Msk     (0xFFUL << DMA2D_FGCOLR_GREEN_Pos)          /*!< 0x0000FF00 */
#define DMA2D_FGCOLR_GREEN         DMA2D_FGCOLR_GREEN_Msk                      /*!< Foreground Green Value */
#define DMA2D_FGCOLR_RED_Pos       (16U)
#define DMA2D_FGCOLR_RED_Msk       (0xFFUL << DMA2D_FGCOLR_RED_Pos)            /*!< 0x00FF0000 */
#define DMA2D_FGCOLR_RED           DMA2D_FGCOLR_RED_Msk                        /*!< Foreground Red Value */

/********************  Bit definition for DMA2D_BGPFCCR register  *************/

#define DMA2D_BGPFCCR_CM_Pos       (0U)
#define DMA2D_BGPFCCR_CM_Msk       (0xFUL << DMA2D_BGPFCCR_CM_Pos)             /*!< 0x0000000F */
#define DMA2D_BGPFCCR_CM           DMA2D_BGPFCCR_CM_Msk                        /*!< Input color mode CM[3:0] */
#define DMA2D_BGPFCCR_CM_0         (0x1UL << DMA2D_BGPFCCR_CM_Pos)              /*!< 0x00000001 */
#define DMA2D_BGPFCCR_CM_1         (0x2UL << DMA2D_BGPFCCR_CM_Pos)              /*!< 0x00000002 */
#define DMA2D_BGPFCCR_CM_2         (0x4UL << DMA2D_BGPFCCR_CM_Pos)              /*!< 0x00000004 */
#define DMA2D_BGPFCCR_CM_3         (0x8UL << DMA2D_BGPFCCR_CM_Pos)              /*!< 0x00000008 */
#define DMA2D_BGPFCCR_CCM_Pos      (4U)
#define DMA2D_BGPFCCR_CCM_Msk      (0x1UL << DMA2D_BGPFCCR_CCM_Pos)            /*!< 0x00000010 */
#define DMA2D_BGPFCCR_CCM          DMA2D_BGPFCCR_CCM_Msk                       /*!< CLUT Color mode */
#define DMA2D_BGPFCCR_START_Pos    (5U)
#define DMA2D_BGPFCCR_START_Msk    (0x1UL << DMA2D_BGPFCCR_START_Pos)          /*!< 0x00000020 */
#define DMA2D_BGPFCCR_START        DMA2D_BGPFCCR_START_Msk                     /*!< Start */
#define DMA2D_BGPFCCR_CS_Pos       (8U)
#define DMA2D_BGPFCCR_CS_Msk       (0xFFUL << DMA2D_BGPFCCR_CS_Pos)            /*!< 0x0000FF00 */
#define DMA2D_BGPFCCR_CS           DMA2D_BGPFCCR_CS_Msk                        /*!< CLUT size */
#define DMA2D_BGPFCCR_AM_Pos       (16U)
#define DMA2D_BGPFCCR_AM_Msk       (0x3UL << DMA2D_BGPFCCR_AM_Pos)             /*!< 0x00030000 */
#define DMA2D_BGPFCCR_AM           DMA2D_BGPFCCR_AM_Msk                        /*!< Alpha mode AM[1:0] */
#define DMA2D_BGPFCCR_AM_0         (0x1UL << DMA2D_BGPFCCR_AM_Pos)              /*!< 0x00010000 */
#define DMA2D_BGPFCCR_AM_1         (0x2UL << DMA2D_BGPFCCR_AM_Pos)              /*!< 0x00020000 */
#define DMA2D_BGPFCCR_AI_Pos       (20U)
#define DMA2D_BGPFCCR_AI_Msk       (0x1UL << DMA2D_BGPFCCR_AI_Pos)             /*!< 0x00100000 */
#define DMA2D_BGPFCCR_AI           DMA2D_BGPFCCR_AI_Msk                        /*!< background Input Alpha Inverted */
#define DMA2D_BGPFCCR_RBS_Pos      (21U)
#define DMA2D_BGPFCCR_RBS_Msk      (0x1UL << DMA2D_BGPFCCR_RBS_Pos)            /*!< 0x00200000 */
#define DMA2D_BGPFCCR_RBS          DMA2D_BGPFCCR_RBS_Msk                       /*!< Background Input Red Blue Swap */
#define DMA2D_BGPFCCR_ALPHA_Pos    (24U)
#define DMA2D_BGPFCCR_ALPHA_Msk    (0xFFUL << DMA2D_BGPFCCR_ALPHA_Pos)         /*!< 0xFF000000 */
#define DMA2D_BGPFCCR_ALPHA        DMA2D_BGPFCCR_ALPHA_Msk                     /*!< background Input Alpha value */

/********************  Bit definition for DMA2D_BGCOLR register  **************/

#define DMA2D_BGCOLR_BLUE_Pos      (0U)
#define DMA2D_BGCOLR_BLUE_Msk      (0xFFUL << DMA2D_BGCOLR_BLUE_Pos)           /*!< 0x000000FF */
#define DMA2D_BGCOLR_BLUE          DMA2D_BGCOLR_BLUE_Msk                       /*!< Background Blue Value */
#define DMA2D_BGCOLR_GREEN_Pos     (8U)
#define DMA2D_BGCOLR_GREEN_Msk     (0xFFUL << DMA2D_BGCOLR_GREEN_Pos)          /*!< 0x0000FF00 */
#define DMA2D_BGCOLR_GREEN         DMA2D_BGCOLR_GREEN_Msk                      /*!< Background Green Value */
#define DMA2D_BGCOLR_RED_Pos       (16U)
#define DMA2D_BGCOLR_RED_Msk       (0xFFUL << DMA2D_BGCOLR_RED_Pos)            /*!< 0x00FF0000 */
#define DMA2D_BGCOLR_RED           DMA2D_BGCOLR_RED_Msk                        /*!< Background Red Value */

/********************  Bit definition for DMA2D_FGCMAR register  **************/

#define DMA2D_FGCMAR_MA_Pos        (0U)
#define DMA2D_FGCMAR_MA_Msk        (0xFFFFFFFFUL << DMA2D_FGCMAR_MA_Pos)       /*!< 0xFFFFFFFF */
#define DMA2D_FGCMAR_MA            DMA2D_FGCMAR_MA_Msk                         /*!< Foreground CLUT Memory Address */

/********************  Bit definition for DMA2D_BGCMAR register  **************/

#define DMA2D_BGCMAR_MA_Pos        (0U)
#define DMA2D_BGCMAR_MA_Msk        (0xFFFFFFFFUL << DMA2D_BGCMAR_MA_Pos)       /*!< 0xFFFFFFFF */
#define DMA2D_BGCMAR_MA            DMA2D_BGCMAR_MA_Msk                         /*!< Background CLUT Memory Address */

/********************  Bit definition for DMA2D_OPFCCR register  **************/

#define DMA2D_OPFCCR_CM_Pos        (0U)
#define DMA2D_OPFCCR_CM_Msk        (0x7UL << DMA2D_OPFCCR_CM_Pos)              /*!< 0x00000007 */
#define DMA2D_OPFCCR_CM            DMA2D_OPFCCR_CM_Msk                         /*!< Output Color mode CM[2:0] */
#define DMA2D_OPFCCR_CM_0          (0x1UL << DMA2D_OPFCCR_CM_Pos)              /*!< 0x00000001 */
#define DMA2D_OPFCCR_CM_1          (0x2UL << DMA2D_OPFCCR_CM_Pos)              /*!< 0x00000002 */
#define DMA2D_OPFCCR_CM_2          (0x4UL << DMA2D_OPFCCR_CM_Pos)              /*!< 0x00000004 */
#define DMA2D_OPFCCR_SB_Pos        (8U)
#define DMA2D_OPFCCR_SB_Msk        (0x1UL << DMA2D_OPFCCR_SB_Pos)              /*!< 0x00000100 */
#define DMA2D_OPFCCR_SB            DMA2D_OPFCCR_SB_Msk                         /*!< Swap Bytes */
#define DMA2D_OPFCCR_AI_Pos        (20U)
#define DMA2D_OPFCCR_AI_Msk        (0x1UL << DMA2D_OPFCCR_AI_Pos)              /*!< 0x00100000 */
#define DMA2D_OPFCCR_AI            DMA2D_OPFCCR_AI_Msk                         /*!< Output Alpha Inverted */
#define DMA2D_OPFCCR_RBS_Pos       (21U)
#define DMA2D_OPFCCR_RBS_Msk       (0x1UL << DMA2D_OPFCCR_RBS_Pos)             /*!< 0x00200000 */
#define DMA2D_OPFCCR_RBS           DMA2D_OPFCCR_RBS_Msk                        /*!< Output Red Blue Swap */

/********************  Bit definition for DMA2D_OCOLR register  ***************/

/*!<Mode_ARGB8888/RGB888 */

#define DMA2D_OCOLR_BLUE_1_Pos     (0U)
#define DMA2D_OCOLR_BLUE_1_Msk     (0xFFUL <<DMA2D_OCOLR_BLUE_1_Pos)            /*0x000000FFU*/
#define DMA2D_OCOLR_BLUE_1         DMA2D_OCOLR_BLUE_1_Msk                      /*!< Output BLUE Value */
#define DMA2D_OCOLR_GREEN_1_Pos    (8U)
#define DMA2D_OCOLR_GREEN_1_Msk    (0xFFUL<<DMA2D_OCOLR_GREEN_1_Pos)            /*0x0000FF00U)*/
#define DMA2D_OCOLR_GREEN_1        DMA2D_OCOLR_GREEN_1_Msk                     /*!< Output GREEN Value  */
#define DMA2D_OCOLR_RED_1_Pos      (16U)
#define DMA2D_OCOLR_RED_1_Msk      (0xFFUL << DMA2D_OCOLR_RED_1_Pos)            /*0x00FF0000U */
#define DMA2D_OCOLR_RED_1          DMA2D_OCOLR_RED_1_Msk                       /*!< Output Red Value */
#define DMA2D_OCOLR_ALPHA_1_Pos    (24U)
#define DMA2D_OCOLR_ALPHA_1_Msk    (0xFFUL << DMA2D_OCOLR_ALPHA_1_Pos)          /*0xFF000000U*/
#define DMA2D_OCOLR_ALPHA_1        DMA2D_OCOLR_ALPHA_1_Msk                     /*!< Output Alpha Channel Value */

/*!<Mode_RGB565 */
#define DMA2D_OCOLR_BLUE_2_Pos     (0U)
#define DMA2D_OCOLR_BLUE_2_Msk     (0x1FUL <<DMA2D_OCOLR_BLUE_2_Pos)            /*0x0000001FU*/
#define DMA2D_OCOLR_BLUE_2         DMA2D_OCOLR_BLUE_2_Msk                      /*!< Output BLUE Value */
#define DMA2D_OCOLR_GREEN_2_Pos    (5U)
#define DMA2D_OCOLR_GREEN_2_Msk    (0x7EUL << DMA2D_OCOLR_GREEN_2_Pos)          /* 0x000007E0U */
#define DMA2D_OCOLR_GREEN_2        DMA2D_OCOLR_GREEN_2_Msk                     /*!< Output GREEN Value  */
#define DMA2D_OCOLR_RED_2_Pos      (11U)
#define DMA2D_OCOLR_RED_2_Msk      (0xF8UL<<DMA2D_OCOLR_RED_2_Pos)              /*0x0000F800U*/
#define DMA2D_OCOLR_RED_2          DMA2D_OCOLR_RED_2_Msk                       /*!< Output Red Value */

/*!<Mode_ARGB1555 */
#define DMA2D_OCOLR_BLUE_3_Pos     (0U)
#define DMA2D_OCOLR_BLUE_3_Msk     (0x1FUL << DMA2D_OCOLR_BLUE_3_Pos)           /*0x0000001FU*/
#define DMA2D_OCOLR_BLUE_3         DMA2D_OCOLR_BLUE_3_Msk                      /*!< Output BLUE Value */
#define DMA2D_OCOLR_GREEN_3_Pos    (5U)
#define DMA2D_OCOLR_GREEN_3_Msk    (0x3EUL << DMA2D_OCOLR_GREEN_3_Pos)          /*0x000003E0U*/
#define DMA2D_OCOLR_GREEN_3        DMA2D_OCOLR_GREEN_3_Msk                     /*!< Output GREEN Value  */
#define DMA2D_OCOLR_RED_3_Pos      (10U)
#define DMA2D_OCOLR_RED_3_Msk      (0x7CUL << DMA2D_OCOLR_RED_3_Pos)            /* 0x00007C00U*/
#define DMA2D_OCOLR_RED_3          DMA2D_OCOLR_RED_3_Msk                       /*!< Output Red Value */
#define DMA2D_OCOLR_ALPHA_3_Pos    (15U)
#define DMA2D_OCOLR_ALPHA_3_Msk    (0x1UL << DMA2D_OCOLR_ALPHA_3_Pos)           /*0x00008000U*/
#define DMA2D_OCOLR_ALPHA_3        DMA2D_OCOLR_ALPHA_3_Msk                     /*!< Output Alpha Channel Value */

/*!<Mode_ARGB4444 */
#define DMA2D_OCOLR_BLUE_4_Pos     (0U)
#define DMA2D_OCOLR_BLUE_4_Msk     (0xFUL << DMA2D_OCOLR_BLUE_4_Pos)            /*0x0000000FU*/
#define DMA2D_OCOLR_BLUE_4         DMA2D_OCOLR_BLUE_4_Msk                      /*!< Output BLUE Value */
#define DMA2D_OCOLR_GREEN_4_Pos    (4U)
#define DMA2D_OCOLR_GREEN_4_Msk    (0xFUL << DMA2D_OCOLR_GREEN_4_Pos)           /*0x000000F0U*/
#define DMA2D_OCOLR_GREEN_4        DMA2D_OCOLR_GREEN_4_Msk                     /*!< Output GREEN Value  */
#define DMA2D_OCOLR_RED_4_Pos      (8U)
#define DMA2D_OCOLR_RED_4_Msk      (0xFUL << DMA2D_OCOLR_RED_4_Pos)             /*0x00000F00U*/
#define DMA2D_OCOLR_RED_4          DMA2D_OCOLR_RED_4_Msk                       /*!< Output Red Value */
#define DMA2D_OCOLR_ALPHA_4_Pos    (12U)
#define DMA2D_OCOLR_ALPHA_4_Msk    (0xFUL << DMA2D_OCOLR_ALPHA_4_Pos)            /*0x0000F000U*/
#define DMA2D_OCOLR_ALPHA_4        DMA2D_OCOLR_ALPHA_4_Msk                     /*!< Output Alpha Channel Value */

/********************  Bit definition for DMA2D_OMAR register  ****************/

#define DMA2D_OMAR_MA_Pos          (0U)
#define DMA2D_OMAR_MA_Msk          (0xFFFFFFFFUL << DMA2D_OMAR_MA_Pos)         /*!< 0xFFFFFFFF */
#define DMA2D_OMAR_MA              DMA2D_OMAR_MA_Msk                           /*!< Output Memory Address */

/********************  Bit definition for DMA2D_OOR register  *****************/

#define DMA2D_OOR_LO_Pos           (0U)
#define DMA2D_OOR_LO_Msk           (0xFFFFUL << DMA2D_OOR_LO_Pos)              /*!< 0x0000FFFF */
#define DMA2D_OOR_LO               DMA2D_OOR_LO_Msk                            /*!< Output Line Offset */

/********************  Bit definition for DMA2D_NLR register  *****************/

#define DMA2D_NLR_NL_Pos           (0U)
#define DMA2D_NLR_NL_Msk           (0xFFFFUL << DMA2D_NLR_NL_Pos)              /*!< 0x0000FFFF */
#define DMA2D_NLR_NL               DMA2D_NLR_NL_Msk                            /*!< Number of Lines */
#define DMA2D_NLR_PL_Pos           (16U)
#define DMA2D_NLR_PL_Msk           (0x3FFFUL << DMA2D_NLR_PL_Pos)              /*!< 0x3FFF0000 */
#define DMA2D_NLR_PL               DMA2D_NLR_PL_Msk                            /*!< Pixel per Lines */

/********************  Bit definition for DMA2D_LWR register  *****************/

#define DMA2D_LWR_LW_Pos           (0U)
#define DMA2D_LWR_LW_Msk           (0xFFFFUL << DMA2D_LWR_LW_Pos)              /*!< 0x0000FFFF */
#define DMA2D_LWR_LW               DMA2D_LWR_LW_Msk                            /*!< Line Watermark */

/********************  Bit definition for DMA2D_AMTCR register  ***************/

#define DMA2D_AMTCR_EN_Pos         (0U)
#define DMA2D_AMTCR_EN_Msk         (0x1UL << DMA2D_AMTCR_EN_Pos)               /*!< 0x00000001 */
#define DMA2D_AMTCR_EN             DMA2D_AMTCR_EN_Msk                          /*!< Enable */
#define DMA2D_AMTCR_DT_Pos         (8U)
#define DMA2D_AMTCR_DT_Msk         (0xFFUL << DMA2D_AMTCR_DT_Pos)              /*!< 0x0000FF00 */
#define DMA2D_AMTCR_DT             DMA2D_AMTCR_DT_Msk                          /*!< Dead Time */


/********************  Bit definition for DMA2D_FGCLUT register  **************/

/********************  Bit definition for DMA2D_BGCLUT register  **************/


/******************************************************************************/
/*                                                                            */
/*                    External Interrupt/Event Controller                     */
/*                                                                            */
/******************************************************************************/
/******************  Bit definition for EXTI_RTSR1 register  *******************/
#define EXTI_RTSR1_TR_Pos          (0U)
#define EXTI_RTSR1_TR_Msk          (0x3FFFFFUL << EXTI_RTSR1_TR_Pos)           /*!< 0x003FFFFF */
#define EXTI_RTSR1_TR              EXTI_RTSR1_TR_Msk                           /*!< Rising trigger event configuration bit */
#define EXTI_RTSR1_TR0_Pos         (0U)
#define EXTI_RTSR1_TR0_Msk         (0x1UL << EXTI_RTSR1_TR0_Pos)               /*!< 0x00000001 */
#define EXTI_RTSR1_TR0             EXTI_RTSR1_TR0_Msk                          /*!< Rising trigger event configuration bit of line 0 */
#define EXTI_RTSR1_TR1_Pos         (1U)
#define EXTI_RTSR1_TR1_Msk         (0x1UL << EXTI_RTSR1_TR1_Pos)               /*!< 0x00000002 */
#define EXTI_RTSR1_TR1             EXTI_RTSR1_TR1_Msk                          /*!< Rising trigger event configuration bit of line 1 */
#define EXTI_RTSR1_TR2_Pos         (2U)
#define EXTI_RTSR1_TR2_Msk         (0x1UL << EXTI_RTSR1_TR2_Pos)               /*!< 0x00000004 */
#define EXTI_RTSR1_TR2             EXTI_RTSR1_TR2_Msk                          /*!< Rising trigger event configuration bit of line 2 */
#define EXTI_RTSR1_TR3_Pos         (3U)
#define EXTI_RTSR1_TR3_Msk         (0x1UL << EXTI_RTSR1_TR3_Pos)               /*!< 0x00000008 */
#define EXTI_RTSR1_TR3             EXTI_RTSR1_TR3_Msk                          /*!< Rising trigger event configuration bit of line 3 */
#define EXTI_RTSR1_TR4_Pos         (4U)
#define EXTI_RTSR1_TR4_Msk         (0x1UL << EXTI_RTSR1_TR4_Pos)               /*!< 0x00000010 */
#define EXTI_RTSR1_TR4             EXTI_RTSR1_TR4_Msk                          /*!< Rising trigger event configuration bit of line 4 */
#define EXTI_RTSR1_TR5_Pos         (5U)
#define EXTI_RTSR1_TR5_Msk         (0x1UL << EXTI_RTSR1_TR5_Pos)               /*!< 0x00000020 */
#define EXTI_RTSR1_TR5             EXTI_RTSR1_TR5_Msk                          /*!< Rising trigger event configuration bit of line 5 */
#define EXTI_RTSR1_TR6_Pos         (6U)
#define EXTI_RTSR1_TR6_Msk         (0x1UL << EXTI_RTSR1_TR6_Pos)               /*!< 0x00000040 */
#define EXTI_RTSR1_TR6             EXTI_RTSR1_TR6_Msk                          /*!< Rising trigger event configuration bit of line 6 */
#define EXTI_RTSR1_TR7_Pos         (7U)
#define EXTI_RTSR1_TR7_Msk         (0x1UL << EXTI_RTSR1_TR7_Pos)               /*!< 0x00000080 */
#define EXTI_RTSR1_TR7             EXTI_RTSR1_TR7_Msk                          /*!< Rising trigger event configuration bit of line 7 */
#define EXTI_RTSR1_TR8_Pos         (8U)
#define EXTI_RTSR1_TR8_Msk         (0x1UL << EXTI_RTSR1_TR8_Pos)               /*!< 0x00000100 */
#define EXTI_RTSR1_TR8             EXTI_RTSR1_TR8_Msk                          /*!< Rising trigger event configuration bit of line 8 */
#define EXTI_RTSR1_TR9_Pos         (9U)
#define EXTI_RTSR1_TR9_Msk         (0x1UL << EXTI_RTSR1_TR9_Pos)               /*!< 0x00000200 */
#define EXTI_RTSR1_TR9             EXTI_RTSR1_TR9_Msk                          /*!< Rising trigger event configuration bit of line 9 */
#define EXTI_RTSR1_TR10_Pos        (10U)
#define EXTI_RTSR1_TR10_Msk        (0x1UL << EXTI_RTSR1_TR10_Pos)              /*!< 0x00000400 */
#define EXTI_RTSR1_TR10            EXTI_RTSR1_TR10_Msk                         /*!< Rising trigger event configuration bit of line 10 */
#define EXTI_RTSR1_TR11_Pos        (11U)
#define EXTI_RTSR1_TR11_Msk        (0x1UL << EXTI_RTSR1_TR11_Pos)              /*!< 0x00000800 */
#define EXTI_RTSR1_TR11            EXTI_RTSR1_TR11_Msk                         /*!< Rising trigger event configuration bit of line 11 */
#define EXTI_RTSR1_TR12_Pos        (12U)
#define EXTI_RTSR1_TR12_Msk        (0x1UL << EXTI_RTSR1_TR12_Pos)              /*!< 0x00001000 */
#define EXTI_RTSR1_TR12            EXTI_RTSR1_TR12_Msk                         /*!< Rising trigger event configuration bit of line 12 */
#define EXTI_RTSR1_TR13_Pos        (13U)
#define EXTI_RTSR1_TR13_Msk        (0x1UL << EXTI_RTSR1_TR13_Pos)              /*!< 0x00002000 */
#define EXTI_RTSR1_TR13            EXTI_RTSR1_TR13_Msk                         /*!< Rising trigger event configuration bit of line 13 */
#define EXTI_RTSR1_TR14_Pos        (14U)
#define EXTI_RTSR1_TR14_Msk        (0x1UL << EXTI_RTSR1_TR14_Pos)              /*!< 0x00004000 */
#define EXTI_RTSR1_TR14            EXTI_RTSR1_TR14_Msk                         /*!< Rising trigger event configuration bit of line 14 */
#define EXTI_RTSR1_TR15_Pos        (15U)
#define EXTI_RTSR1_TR15_Msk        (0x1UL << EXTI_RTSR1_TR15_Pos)              /*!< 0x00008000 */
#define EXTI_RTSR1_TR15            EXTI_RTSR1_TR15_Msk                         /*!< Rising trigger event configuration bit of line 15 */
#define EXTI_RTSR1_TR16_Pos        (16U)
#define EXTI_RTSR1_TR16_Msk        (0x1UL << EXTI_RTSR1_TR16_Pos)              /*!< 0x00010000 */
#define EXTI_RTSR1_TR16            EXTI_RTSR1_TR16_Msk                         /*!< Rising trigger event configuration bit of line 16 */
#define EXTI_RTSR1_TR17_Pos        (17U)
#define EXTI_RTSR1_TR17_Msk        (0x1UL << EXTI_RTSR1_TR17_Pos)              /*!< 0x00020000 */
#define EXTI_RTSR1_TR17            EXTI_RTSR1_TR17_Msk                         /*!< Rising trigger event configuration bit of line 17 */
#define EXTI_RTSR1_TR18_Pos        (18U)
#define EXTI_RTSR1_TR18_Msk        (0x1UL << EXTI_RTSR1_TR18_Pos)              /*!< 0x00040000 */
#define EXTI_RTSR1_TR18            EXTI_RTSR1_TR18_Msk                         /*!< Rising trigger event configuration bit of line 18 */
#define EXTI_RTSR1_TR19_Pos        (19U)
#define EXTI_RTSR1_TR19_Msk        (0x1UL << EXTI_RTSR1_TR19_Pos)              /*!< 0x00080000 */
#define EXTI_RTSR1_TR19            EXTI_RTSR1_TR19_Msk                         /*!< Rising trigger event configuration bit of line 19 */
#define EXTI_RTSR1_TR20_Pos        (20U)
#define EXTI_RTSR1_TR20_Msk        (0x1UL << EXTI_RTSR1_TR20_Pos)              /*!< 0x00100000 */
#define EXTI_RTSR1_TR20            EXTI_RTSR1_TR20_Msk                         /*!< Rising trigger event configuration bit of line 20 */
#define EXTI_RTSR1_TR21_Pos        (21U)
#define EXTI_RTSR1_TR21_Msk        (0x1UL << EXTI_RTSR1_TR21_Pos)              /*!< 0x00200000 */
#define EXTI_RTSR1_TR21            EXTI_RTSR1_TR21_Msk                         /*!< Rising trigger event configuration bit of line 21 */

/******************  Bit definition for EXTI_FTSR1 register  *******************/
#define EXTI_FTSR1_TR_Pos          (0U)
#define EXTI_FTSR1_TR_Msk          (0x3FFFFFUL << EXTI_FTSR1_TR_Pos)           /*!< 0x003FFFFF */
#define EXTI_FTSR1_TR              EXTI_FTSR1_TR_Msk                           /*!< Falling trigger event configuration bit */
#define EXTI_FTSR1_TR0_Pos         (0U)
#define EXTI_FTSR1_TR0_Msk         (0x1UL << EXTI_FTSR1_TR0_Pos)               /*!< 0x00000001 */
#define EXTI_FTSR1_TR0             EXTI_FTSR1_TR0_Msk                          /*!< Falling trigger event configuration bit of line 0 */
#define EXTI_FTSR1_TR1_Pos         (1U)
#define EXTI_FTSR1_TR1_Msk         (0x1UL << EXTI_FTSR1_TR1_Pos)               /*!< 0x00000002 */
#define EXTI_FTSR1_TR1             EXTI_FTSR1_TR1_Msk                          /*!< Falling trigger event configuration bit of line 1 */
#define EXTI_FTSR1_TR2_Pos         (2U)
#define EXTI_FTSR1_TR2_Msk         (0x1UL << EXTI_FTSR1_TR2_Pos)               /*!< 0x00000004 */
#define EXTI_FTSR1_TR2             EXTI_FTSR1_TR2_Msk                          /*!< Falling trigger event configuration bit of line 2 */
#define EXTI_FTSR1_TR3_Pos         (3U)
#define EXTI_FTSR1_TR3_Msk         (0x1UL << EXTI_FTSR1_TR3_Pos)               /*!< 0x00000008 */
#define EXTI_FTSR1_TR3             EXTI_FTSR1_TR3_Msk                          /*!< Falling trigger event configuration bit of line 3 */
#define EXTI_FTSR1_TR4_Pos         (4U)
#define EXTI_FTSR1_TR4_Msk         (0x1UL << EXTI_FTSR1_TR4_Pos)               /*!< 0x00000010 */
#define EXTI_FTSR1_TR4             EXTI_FTSR1_TR4_Msk                          /*!< Falling trigger event configuration bit of line 4 */
#define EXTI_FTSR1_TR5_Pos         (5U)
#define EXTI_FTSR1_TR5_Msk         (0x1UL << EXTI_FTSR1_TR5_Pos)               /*!< 0x00000020 */
#define EXTI_FTSR1_TR5             EXTI_FTSR1_TR5_Msk                          /*!< Falling trigger event configuration bit of line 5 */
#define EXTI_FTSR1_TR6_Pos         (6U)
#define EXTI_FTSR1_TR6_Msk         (0x1UL << EXTI_FTSR1_TR6_Pos)               /*!< 0x00000040 */
#define EXTI_FTSR1_TR6             EXTI_FTSR1_TR6_Msk                          /*!< Falling trigger event configuration bit of line 6 */
#define EXTI_FTSR1_TR7_Pos         (7U)
#define EXTI_FTSR1_TR7_Msk         (0x1UL << EXTI_FTSR1_TR7_Pos)               /*!< 0x00000080 */
#define EXTI_FTSR1_TR7             EXTI_FTSR1_TR7_Msk                          /*!< Falling trigger event configuration bit of line 7 */
#define EXTI_FTSR1_TR8_Pos         (8U)
#define EXTI_FTSR1_TR8_Msk         (0x1UL << EXTI_FTSR1_TR8_Pos)               /*!< 0x00000100 */
#define EXTI_FTSR1_TR8             EXTI_FTSR1_TR8_Msk                          /*!< Falling trigger event configuration bit of line 8 */
#define EXTI_FTSR1_TR9_Pos         (9U)
#define EXTI_FTSR1_TR9_Msk         (0x1UL << EXTI_FTSR1_TR9_Pos)               /*!< 0x00000200 */
#define EXTI_FTSR1_TR9             EXTI_FTSR1_TR9_Msk                          /*!< Falling trigger event configuration bit of line 9 */
#define EXTI_FTSR1_TR10_Pos        (10U)
#define EXTI_FTSR1_TR10_Msk        (0x1UL << EXTI_FTSR1_TR10_Pos)              /*!< 0x00000400 */
#define EXTI_FTSR1_TR10            EXTI_FTSR1_TR10_Msk                         /*!< Falling trigger event configuration bit of line 10 */
#define EXTI_FTSR1_TR11_Pos        (11U)
#define EXTI_FTSR1_TR11_Msk        (0x1UL << EXTI_FTSR1_TR11_Pos)              /*!< 0x00000800 */
#define EXTI_FTSR1_TR11            EXTI_FTSR1_TR11_Msk                         /*!< Falling trigger event configuration bit of line 11 */
#define EXTI_FTSR1_TR12_Pos        (12U)
#define EXTI_FTSR1_TR12_Msk        (0x1UL << EXTI_FTSR1_TR12_Pos)              /*!< 0x00001000 */
#define EXTI_FTSR1_TR12            EXTI_FTSR1_TR12_Msk                         /*!< Falling trigger event configuration bit of line 12 */
#define EXTI_FTSR1_TR13_Pos        (13U)
#define EXTI_FTSR1_TR13_Msk        (0x1UL << EXTI_FTSR1_TR13_Pos)              /*!< 0x00002000 */
#define EXTI_FTSR1_TR13            EXTI_FTSR1_TR13_Msk                         /*!< Falling trigger event configuration bit of line 13 */
#define EXTI_FTSR1_TR14_Pos        (14U)
#define EXTI_FTSR1_TR14_Msk        (0x1UL << EXTI_FTSR1_TR14_Pos)              /*!< 0x00004000 */
#define EXTI_FTSR1_TR14            EXTI_FTSR1_TR14_Msk                         /*!< Falling trigger event configuration bit of line 14 */
#define EXTI_FTSR1_TR15_Pos        (15U)
#define EXTI_FTSR1_TR15_Msk        (0x1UL << EXTI_FTSR1_TR15_Pos)              /*!< 0x00008000 */
#define EXTI_FTSR1_TR15            EXTI_FTSR1_TR15_Msk                         /*!< Falling trigger event configuration bit of line 15 */
#define EXTI_FTSR1_TR16_Pos        (16U)
#define EXTI_FTSR1_TR16_Msk        (0x1UL << EXTI_FTSR1_TR16_Pos)              /*!< 0x00010000 */
#define EXTI_FTSR1_TR16            EXTI_FTSR1_TR16_Msk                         /*!< Falling trigger event configuration bit of line 16 */
#define EXTI_FTSR1_TR17_Pos        (17U)
#define EXTI_FTSR1_TR17_Msk        (0x1UL << EXTI_FTSR1_TR17_Pos)              /*!< 0x00020000 */
#define EXTI_FTSR1_TR17            EXTI_FTSR1_TR17_Msk                         /*!< Falling trigger event configuration bit of line 17 */
#define EXTI_FTSR1_TR18_Pos        (18U)
#define EXTI_FTSR1_TR18_Msk        (0x1UL << EXTI_FTSR1_TR18_Pos)              /*!< 0x00040000 */
#define EXTI_FTSR1_TR18            EXTI_FTSR1_TR18_Msk                         /*!< Falling trigger event configuration bit of line 18 */
#define EXTI_FTSR1_TR19_Pos        (19U)
#define EXTI_FTSR1_TR19_Msk        (0x1UL << EXTI_FTSR1_TR19_Pos)              /*!< 0x00080000 */
#define EXTI_FTSR1_TR19            EXTI_FTSR1_TR19_Msk                         /*!< Falling trigger event configuration bit of line 19 */
#define EXTI_FTSR1_TR20_Pos        (20U)
#define EXTI_FTSR1_TR20_Msk        (0x1UL << EXTI_FTSR1_TR20_Pos)              /*!< 0x00100000 */
#define EXTI_FTSR1_TR20            EXTI_FTSR1_TR20_Msk                         /*!< Falling trigger event configuration bit of line 20 */
#define EXTI_FTSR1_TR21_Pos        (21U)
#define EXTI_FTSR1_TR21_Msk        (0x1UL << EXTI_FTSR1_TR21_Pos)              /*!< 0x00200000 */
#define EXTI_FTSR1_TR21            EXTI_FTSR1_TR21_Msk                         /*!< Falling trigger event configuration bit of line 21 */

/******************  Bit definition for EXTI_SWIER1 register  ******************/
#define EXTI_SWIER1_SWIER0_Pos     (0U)
#define EXTI_SWIER1_SWIER0_Msk     (0x1UL << EXTI_SWIER1_SWIER0_Pos)           /*!< 0x00000001 */
#define EXTI_SWIER1_SWIER0         EXTI_SWIER1_SWIER0_Msk                      /*!< Software Interrupt on line 0 */
#define EXTI_SWIER1_SWIER1_Pos     (1U)
#define EXTI_SWIER1_SWIER1_Msk     (0x1UL << EXTI_SWIER1_SWIER1_Pos)           /*!< 0x00000002 */
#define EXTI_SWIER1_SWIER1         EXTI_SWIER1_SWIER1_Msk                      /*!< Software Interrupt on line 1 */
#define EXTI_SWIER1_SWIER2_Pos     (2U)
#define EXTI_SWIER1_SWIER2_Msk     (0x1UL << EXTI_SWIER1_SWIER2_Pos)           /*!< 0x00000004 */
#define EXTI_SWIER1_SWIER2         EXTI_SWIER1_SWIER2_Msk                      /*!< Software Interrupt on line 2 */
#define EXTI_SWIER1_SWIER3_Pos     (3U)
#define EXTI_SWIER1_SWIER3_Msk     (0x1UL << EXTI_SWIER1_SWIER3_Pos)           /*!< 0x00000008 */
#define EXTI_SWIER1_SWIER3         EXTI_SWIER1_SWIER3_Msk                      /*!< Software Interrupt on line 3 */
#define EXTI_SWIER1_SWIER4_Pos     (4U)
#define EXTI_SWIER1_SWIER4_Msk     (0x1UL << EXTI_SWIER1_SWIER4_Pos)           /*!< 0x00000010 */
#define EXTI_SWIER1_SWIER4         EXTI_SWIER1_SWIER4_Msk                      /*!< Software Interrupt on line 4 */
#define EXTI_SWIER1_SWIER5_Pos     (5U)
#define EXTI_SWIER1_SWIER5_Msk     (0x1UL << EXTI_SWIER1_SWIER5_Pos)           /*!< 0x00000020 */
#define EXTI_SWIER1_SWIER5         EXTI_SWIER1_SWIER5_Msk                      /*!< Software Interrupt on line 5 */
#define EXTI_SWIER1_SWIER6_Pos     (6U)
#define EXTI_SWIER1_SWIER6_Msk     (0x1UL << EXTI_SWIER1_SWIER6_Pos)           /*!< 0x00000040 */
#define EXTI_SWIER1_SWIER6         EXTI_SWIER1_SWIER6_Msk                      /*!< Software Interrupt on line 6 */
#define EXTI_SWIER1_SWIER7_Pos     (7U)
#define EXTI_SWIER1_SWIER7_Msk     (0x1UL << EXTI_SWIER1_SWIER7_Pos)           /*!< 0x00000080 */
#define EXTI_SWIER1_SWIER7         EXTI_SWIER1_SWIER7_Msk                      /*!< Software Interrupt on line 7 */
#define EXTI_SWIER1_SWIER8_Pos     (8U)
#define EXTI_SWIER1_SWIER8_Msk     (0x1UL << EXTI_SWIER1_SWIER8_Pos)           /*!< 0x00000100 */
#define EXTI_SWIER1_SWIER8         EXTI_SWIER1_SWIER8_Msk                      /*!< Software Interrupt on line 8 */
#define EXTI_SWIER1_SWIER9_Pos     (9U)
#define EXTI_SWIER1_SWIER9_Msk     (0x1UL << EXTI_SWIER1_SWIER9_Pos)           /*!< 0x00000200 */
#define EXTI_SWIER1_SWIER9         EXTI_SWIER1_SWIER9_Msk                      /*!< Software Interrupt on line 9 */
#define EXTI_SWIER1_SWIER10_Pos    (10U)
#define EXTI_SWIER1_SWIER10_Msk    (0x1UL << EXTI_SWIER1_SWIER10_Pos)          /*!< 0x00000400 */
#define EXTI_SWIER1_SWIER10        EXTI_SWIER1_SWIER10_Msk                     /*!< Software Interrupt on line 10 */
#define EXTI_SWIER1_SWIER11_Pos    (11U)
#define EXTI_SWIER1_SWIER11_Msk    (0x1UL << EXTI_SWIER1_SWIER11_Pos)          /*!< 0x00000800 */
#define EXTI_SWIER1_SWIER11        EXTI_SWIER1_SWIER11_Msk                     /*!< Software Interrupt on line 11 */
#define EXTI_SWIER1_SWIER12_Pos    (12U)
#define EXTI_SWIER1_SWIER12_Msk    (0x1UL << EXTI_SWIER1_SWIER12_Pos)          /*!< 0x00001000 */
#define EXTI_SWIER1_SWIER12        EXTI_SWIER1_SWIER12_Msk                     /*!< Software Interrupt on line 12 */
#define EXTI_SWIER1_SWIER13_Pos    (13U)
#define EXTI_SWIER1_SWIER13_Msk    (0x1UL << EXTI_SWIER1_SWIER13_Pos)          /*!< 0x00002000 */
#define EXTI_SWIER1_SWIER13        EXTI_SWIER1_SWIER13_Msk                     /*!< Software Interrupt on line 13 */
#define EXTI_SWIER1_SWIER14_Pos    (14U)
#define EXTI_SWIER1_SWIER14_Msk    (0x1UL << EXTI_SWIER1_SWIER14_Pos)          /*!< 0x00004000 */
#define EXTI_SWIER1_SWIER14        EXTI_SWIER1_SWIER14_Msk                     /*!< Software Interrupt on line 14 */
#define EXTI_SWIER1_SWIER15_Pos    (15U)
#define EXTI_SWIER1_SWIER15_Msk    (0x1UL << EXTI_SWIER1_SWIER15_Pos)          /*!< 0x00008000 */
#define EXTI_SWIER1_SWIER15        EXTI_SWIER1_SWIER15_Msk                     /*!< Software Interrupt on line 15 */
#define EXTI_SWIER1_SWIER16_Pos    (16U)
#define EXTI_SWIER1_SWIER16_Msk    (0x1UL << EXTI_SWIER1_SWIER16_Pos)          /*!< 0x00010000 */
#define EXTI_SWIER1_SWIER16        EXTI_SWIER1_SWIER16_Msk                     /*!< Software Interrupt on line 16 */
#define EXTI_SWIER1_SWIER17_Pos    (17U)
#define EXTI_SWIER1_SWIER17_Msk    (0x1UL << EXTI_SWIER1_SWIER17_Pos)          /*!< 0x00020000 */
#define EXTI_SWIER1_SWIER17        EXTI_SWIER1_SWIER17_Msk                     /*!< Software Interrupt on line 17 */
#define EXTI_SWIER1_SWIER18_Pos    (18U)
#define EXTI_SWIER1_SWIER18_Msk    (0x1UL << EXTI_SWIER1_SWIER18_Pos)          /*!< 0x00040000 */
#define EXTI_SWIER1_SWIER18        EXTI_SWIER1_SWIER18_Msk                     /*!< Software Interrupt on line 18 */
#define EXTI_SWIER1_SWIER19_Pos    (19U)
#define EXTI_SWIER1_SWIER19_Msk    (0x1UL << EXTI_SWIER1_SWIER19_Pos)          /*!< 0x00080000 */
#define EXTI_SWIER1_SWIER19        EXTI_SWIER1_SWIER19_Msk                     /*!< Software Interrupt on line 19 */
#define EXTI_SWIER1_SWIER20_Pos    (20U)
#define EXTI_SWIER1_SWIER20_Msk    (0x1UL << EXTI_SWIER1_SWIER20_Pos)          /*!< 0x00100000 */
#define EXTI_SWIER1_SWIER20        EXTI_SWIER1_SWIER20_Msk                     /*!< Software Interrupt on line 20 */
#define EXTI_SWIER1_SWIER21_Pos    (21U)
#define EXTI_SWIER1_SWIER21_Msk    (0x1UL << EXTI_SWIER1_SWIER21_Pos)          /*!< 0x00200000 */
#define EXTI_SWIER1_SWIER21        EXTI_SWIER1_SWIER21_Msk                     /*!< Software Interrupt on line 21 */

/******************  Bit definition for EXTI_D3PMR1 register  ******************/
#define EXTI_D3PMR1_MR0_Pos        (0U)
#define EXTI_D3PMR1_MR0_Msk        (0x1UL << EXTI_D3PMR1_MR0_Pos)              /*!< 0x00000001 */
#define EXTI_D3PMR1_MR0            EXTI_D3PMR1_MR0_Msk                         /*!< Pending Mask Event for line 0  */
#define EXTI_D3PMR1_MR1_Pos        (1U)
#define EXTI_D3PMR1_MR1_Msk        (0x1UL << EXTI_D3PMR1_MR1_Pos)              /*!< 0x00000002 */
#define EXTI_D3PMR1_MR1            EXTI_D3PMR1_MR1_Msk                         /*!< Pending Mask Event for line 1  */
#define EXTI_D3PMR1_MR2_Pos        (2U)
#define EXTI_D3PMR1_MR2_Msk        (0x1UL << EXTI_D3PMR1_MR2_Pos)              /*!< 0x00000004 */
#define EXTI_D3PMR1_MR2            EXTI_D3PMR1_MR2_Msk                         /*!< Pending Mask Event for line 2  */
#define EXTI_D3PMR1_MR3_Pos        (3U)
#define EXTI_D3PMR1_MR3_Msk        (0x1UL << EXTI_D3PMR1_MR3_Pos)              /*!< 0x00000008 */
#define EXTI_D3PMR1_MR3            EXTI_D3PMR1_MR3_Msk                         /*!< Pending Mask Event for line 3  */
#define EXTI_D3PMR1_MR4_Pos        (4U)
#define EXTI_D3PMR1_MR4_Msk        (0x1UL << EXTI_D3PMR1_MR4_Pos)              /*!< 0x00000010 */
#define EXTI_D3PMR1_MR4            EXTI_D3PMR1_MR4_Msk                         /*!< Pending Mask Event for line 4  */
#define EXTI_D3PMR1_MR5_Pos        (5U)
#define EXTI_D3PMR1_MR5_Msk        (0x1UL << EXTI_D3PMR1_MR5_Pos)              /*!< 0x00000020 */
#define EXTI_D3PMR1_MR5            EXTI_D3PMR1_MR5_Msk                         /*!< Pending Mask Event for line 5  */
#define EXTI_D3PMR1_MR6_Pos        (6U)
#define EXTI_D3PMR1_MR6_Msk        (0x1UL << EXTI_D3PMR1_MR6_Pos)              /*!< 0x00000040 */
#define EXTI_D3PMR1_MR6            EXTI_D3PMR1_MR6_Msk                         /*!< Pending Mask Event for line 6  */
#define EXTI_D3PMR1_MR7_Pos        (7U)
#define EXTI_D3PMR1_MR7_Msk        (0x1UL << EXTI_D3PMR1_MR7_Pos)              /*!< 0x00000080 */
#define EXTI_D3PMR1_MR7            EXTI_D3PMR1_MR7_Msk                         /*!< Pending Mask Event for line 7  */
#define EXTI_D3PMR1_MR8_Pos        (8U)
#define EXTI_D3PMR1_MR8_Msk        (0x1UL << EXTI_D3PMR1_MR8_Pos)              /*!< 0x00000100 */
#define EXTI_D3PMR1_MR8            EXTI_D3PMR1_MR8_Msk                         /*!< Pending Mask Event for line 8  */
#define EXTI_D3PMR1_MR9_Pos        (9U)
#define EXTI_D3PMR1_MR9_Msk        (0x1UL << EXTI_D3PMR1_MR9_Pos)              /*!< 0x00000200 */
#define EXTI_D3PMR1_MR9            EXTI_D3PMR1_MR9_Msk                         /*!< Pending Mask Event for line 9  */
#define EXTI_D3PMR1_MR10_Pos       (10U)
#define EXTI_D3PMR1_MR10_Msk       (0x1UL << EXTI_D3PMR1_MR10_Pos)             /*!< 0x00000400 */
#define EXTI_D3PMR1_MR10           EXTI_D3PMR1_MR10_Msk                        /*!< Pending Mask Event for line 10 */
#define EXTI_D3PMR1_MR11_Pos       (11U)
#define EXTI_D3PMR1_MR11_Msk       (0x1UL << EXTI_D3PMR1_MR11_Pos)             /*!< 0x00000800 */
#define EXTI_D3PMR1_MR11           EXTI_D3PMR1_MR11_Msk                        /*!< Pending Mask Event for line 11 */
#define EXTI_D3PMR1_MR12_Pos       (12U)
#define EXTI_D3PMR1_MR12_Msk       (0x1UL << EXTI_D3PMR1_MR12_Pos)             /*!< 0x00001000 */
#define EXTI_D3PMR1_MR12           EXTI_D3PMR1_MR12_Msk                        /*!< Pending Mask Event for line 12 */
#define EXTI_D3PMR1_MR13_Pos       (13U)
#define EXTI_D3PMR1_MR13_Msk       (0x1UL << EXTI_D3PMR1_MR13_Pos)             /*!< 0x00002000 */
#define EXTI_D3PMR1_MR13           EXTI_D3PMR1_MR13_Msk                        /*!< Pending Mask Event for line 13 */
#define EXTI_D3PMR1_MR14_Pos       (14U)
#define EXTI_D3PMR1_MR14_Msk       (0x1UL << EXTI_D3PMR1_MR14_Pos)             /*!< 0x00004000 */
#define EXTI_D3PMR1_MR14           EXTI_D3PMR1_MR14_Msk                        /*!< Pending Mask Event for line 14 */
#define EXTI_D3PMR1_MR15_Pos       (15U)
#define EXTI_D3PMR1_MR15_Msk       (0x1UL << EXTI_D3PMR1_MR15_Pos)             /*!< 0x00008000 */
#define EXTI_D3PMR1_MR15           EXTI_D3PMR1_MR15_Msk                        /*!< Pending Mask Event for line 15 */
#define EXTI_D3PMR1_MR19_Pos       (19U)
#define EXTI_D3PMR1_MR19_Msk       (0x1UL << EXTI_D3PMR1_MR19_Pos)             /*!< 0x00080000 */
#define EXTI_D3PMR1_MR19           EXTI_D3PMR1_MR19_Msk                        /*!< Pending Mask Event for line 19 */
#define EXTI_D3PMR1_MR20_Pos       (20U)
#define EXTI_D3PMR1_MR20_Msk       (0x1UL << EXTI_D3PMR1_MR20_Pos)             /*!< 0x00100000 */
#define EXTI_D3PMR1_MR20           EXTI_D3PMR1_MR20_Msk                        /*!< Pending Mask Event for line 20 */
#define EXTI_D3PMR1_MR21_Pos       (21U)
#define EXTI_D3PMR1_MR21_Msk       (0x1UL << EXTI_D3PMR1_MR21_Pos)             /*!< 0x00200000 */
#define EXTI_D3PMR1_MR21           EXTI_D3PMR1_MR21_Msk                        /*!< Pending Mask Event for line 21 */
#define EXTI_D3PMR1_MR25_Pos       (24U)
#define EXTI_D3PMR1_MR25_Msk       (0x1UL << EXTI_D3PMR1_MR25_Pos)             /*!< 0x01000000 */
#define EXTI_D3PMR1_MR25           EXTI_D3PMR1_MR25_Msk                        /*!< Pending Mask Event for line 25 */

/*******************  Bit definition for EXTI_D3PCR1L register  ****************/
#define EXTI_D3PCR1L_PCS0_Pos       (0U)
#define EXTI_D3PCR1L_PCS0_Msk       (0x3UL << EXTI_D3PCR1L_PCS0_Pos)           /*!< 0x00000003 */
#define EXTI_D3PCR1L_PCS0           EXTI_D3PCR1L_PCS0_Msk                      /*!< D3 Pending request clear input signal selection on line 0 */
#define EXTI_D3PCR1L_PCS1_Pos       (2U)
#define EXTI_D3PCR1L_PCS1_Msk       (0x3UL << EXTI_D3PCR1L_PCS1_Pos)           /*!< 0x000000C0 */
#define EXTI_D3PCR1L_PCS1           EXTI_D3PCR1L_PCS1_Msk                      /*!< D3 Pending request clear input signal selection on line 1 */
#define EXTI_D3PCR1L_PCS2_Pos       (4U)
#define EXTI_D3PCR1L_PCS2_Msk       (0x3UL << EXTI_D3PCR1L_PCS2_Pos)           /*!< 0x00000030 */
#define EXTI_D3PCR1L_PCS2           EXTI_D3PCR1L_PCS2_Msk                      /*!< D3 Pending request clear input signal selection on line 2 */
#define EXTI_D3PCR1L_PCS3_Pos       (6U)
#define EXTI_D3PCR1L_PCS3_Msk       (0x3UL << EXTI_D3PCR1L_PCS3_Pos)           /*!< 0x000000C0 */
#define EXTI_D3PCR1L_PCS3           EXTI_D3PCR1L_PCS3_Msk                      /*!< D3 Pending request clear input signal selection on line 3 */
#define EXTI_D3PCR1L_PCS4_Pos       (8U)
#define EXTI_D3PCR1L_PCS4_Msk       (0x3UL << EXTI_D3PCR1L_PCS4_Pos)           /*!< 0x00000300 */
#define EXTI_D3PCR1L_PCS4           EXTI_D3PCR1L_PCS4_Msk                      /*!< D3 Pending request clear input signal selection on line 4 */
#define EXTI_D3PCR1L_PCS5_Pos       (10U)
#define EXTI_D3PCR1L_PCS5_Msk       (0x3UL << EXTI_D3PCR1L_PCS5_Pos)           /*!< 0x00000C00 */
#define EXTI_D3PCR1L_PCS5           EXTI_D3PCR1L_PCS5_Msk                      /*!< D3 Pending request clear input signal selection on line 5 */
#define EXTI_D3PCR1L_PCS6_Pos       (12U)
#define EXTI_D3PCR1L_PCS6_Msk       (0x3UL << EXTI_D3PCR1L_PCS6_Pos)           /*!< 0x00003000 */
#define EXTI_D3PCR1L_PCS6           EXTI_D3PCR1L_PCS6_Msk                      /*!< D3 Pending request clear input signal selection on line 6 */
#define EXTI_D3PCR1L_PCS7_Pos       (14U)
#define EXTI_D3PCR1L_PCS7_Msk       (0x3UL << EXTI_D3PCR1L_PCS7_Pos)           /*!< 0x0000C000 */
#define EXTI_D3PCR1L_PCS7           EXTI_D3PCR1L_PCS7_Msk                      /*!< D3 Pending request clear input signal selection on line 7 */
#define EXTI_D3PCR1L_PCS8_Pos       (16U)
#define EXTI_D3PCR1L_PCS8_Msk       (0x3UL << EXTI_D3PCR1L_PCS8_Pos)           /*!< 0x00030000 */
#define EXTI_D3PCR1L_PCS8           EXTI_D3PCR1L_PCS8_Msk                      /*!< D3 Pending request clear input signal selection on line 8 */
#define EXTI_D3PCR1L_PCS9_Pos       (18U)
#define EXTI_D3PCR1L_PCS9_Msk       (0x3UL << EXTI_D3PCR1L_PCS9_Pos)           /*!< 0x000C0000 */
#define EXTI_D3PCR1L_PCS9           EXTI_D3PCR1L_PCS9_Msk                      /*!< D3 Pending request clear input signal selection on line 9 */
#define EXTI_D3PCR1L_PCS10_Pos      (20U)
#define EXTI_D3PCR1L_PCS10_Msk      (0x3UL << EXTI_D3PCR1L_PCS10_Pos)          /*!< 0x00300000 */
#define EXTI_D3PCR1L_PCS10          EXTI_D3PCR1L_PCS10_Msk                     /*!< D3 Pending request clear input signal selection on line 10*/
#define EXTI_D3PCR1L_PCS11_Pos      (22U)
#define EXTI_D3PCR1L_PCS11_Msk      (0x3UL << EXTI_D3PCR1L_PCS11_Pos)          /*!< 0x00C00000 */
#define EXTI_D3PCR1L_PCS11          EXTI_D3PCR1L_PCS11_Msk                     /*!< D3 Pending request clear input signal selection on line 11*/
#define EXTI_D3PCR1L_PCS12_Pos      (24U)
#define EXTI_D3PCR1L_PCS12_Msk      (0x3UL << EXTI_D3PCR1L_PCS12_Pos)          /*!< 0x03000000 */
#define EXTI_D3PCR1L_PCS12          EXTI_D3PCR1L_PCS12_Msk                     /*!< D3 Pending request clear input signal selection on line 12*/
#define EXTI_D3PCR1L_PCS13_Pos      (26U)
#define EXTI_D3PCR1L_PCS13_Msk      (0x3UL << EXTI_D3PCR1L_PCS13_Pos)          /*!< 0x0C000000 */
#define EXTI_D3PCR1L_PCS13          EXTI_D3PCR1L_PCS13_Msk                     /*!< D3 Pending request clear input signal selection on line 13*/
#define EXTI_D3PCR1L_PCS14_Pos      (28U)
#define EXTI_D3PCR1L_PCS14_Msk      (0x3UL << EXTI_D3PCR1L_PCS14_Pos)          /*!< 0x30000000 */
#define EXTI_D3PCR1L_PCS14          EXTI_D3PCR1L_PCS14_Msk                     /*!< D3 Pending request clear input signal selection on line 14*/
#define EXTI_D3PCR1L_PCS15_Pos      (30U)
#define EXTI_D3PCR1L_PCS15_Msk      (0x3UL << EXTI_D3PCR1L_PCS15_Pos)          /*!< 0xC0000000 */
#define EXTI_D3PCR1L_PCS15          EXTI_D3PCR1L_PCS15_Msk                     /*!< D3 Pending request clear input signal selection on line 15*/

/*******************  Bit definition for EXTI_D3PCR1H register  ****************/
#define EXTI_D3PCR1H_PCS19_Pos       (6U)
#define EXTI_D3PCR1H_PCS19_Msk       (0x3UL << EXTI_D3PCR1H_PCS19_Pos)         /*!< 0x000000C0 */
#define EXTI_D3PCR1H_PCS19           EXTI_D3PCR1H_PCS19_Msk                    /*!< D3 Pending request clear input signal selection on line 19 */
#define EXTI_D3PCR1H_PCS20_Pos       (8U)
#define EXTI_D3PCR1H_PCS20_Msk       (0x3UL << EXTI_D3PCR1H_PCS20_Pos)         /*!< 0x00000300 */
#define EXTI_D3PCR1H_PCS20           EXTI_D3PCR1H_PCS20_Msk                    /*!< D3 Pending request clear input signal selection on line 20 */
#define EXTI_D3PCR1H_PCS21_Pos       (10U)
#define EXTI_D3PCR1H_PCS21_Msk       (0x3UL << EXTI_D3PCR1H_PCS21_Pos)         /*!< 0x00000C00 */
#define EXTI_D3PCR1H_PCS21           EXTI_D3PCR1H_PCS21_Msk                    /*!< D3 Pending request clear input signal selection on line 21 */
#define EXTI_D3PCR1H_PCS25_Pos       (18U)
#define EXTI_D3PCR1H_PCS25_Msk       (0x3UL << EXTI_D3PCR1H_PCS25_Pos)         /*!< 0x000C0000 */
#define EXTI_D3PCR1H_PCS25           EXTI_D3PCR1H_PCS25_Msk                    /*!< D3 Pending request clear input signal selection on line 25 */

/******************  Bit definition for EXTI_RTSR2 register  *******************/
#define EXTI_RTSR2_TR_Pos          (17U)
#define EXTI_RTSR2_TR_Msk          (0x5UL << EXTI_RTSR2_TR_Pos)                /*!< 0x000A0000 */
#define EXTI_RTSR2_TR              EXTI_RTSR2_TR_Msk                           /*!< Rising trigger event configuration bit */
#define EXTI_RTSR2_TR49_Pos        (17U)
#define EXTI_RTSR2_TR49_Msk        (0x1UL << EXTI_RTSR2_TR49_Pos)              /*!< 0x00020000 */
#define EXTI_RTSR2_TR49            EXTI_RTSR2_TR49_Msk                         /*!< Rising trigger event configuration bit of line 49 */
#define EXTI_RTSR2_TR51_Pos        (19U)
#define EXTI_RTSR2_TR51_Msk        (0x1UL << EXTI_RTSR2_TR51_Pos)              /*!< 0x00080000 */
#define EXTI_RTSR2_TR51            EXTI_RTSR2_TR51_Msk                         /*!< Rising trigger event configuration bit of line 51 */

/******************  Bit definition for EXTI_FTSR2 register  *******************/
#define EXTI_FTSR2_TR_Pos          (17U)
#define EXTI_FTSR2_TR_Msk          (0x5UL << EXTI_FTSR2_TR_Pos)                /*!< 0x000A0000 */
#define EXTI_FTSR2_TR              EXTI_FTSR2_TR_Msk                           /*!< Falling trigger event configuration bit */
#define EXTI_FTSR2_TR49_Pos        (17U)
#define EXTI_FTSR2_TR49_Msk        (0x1UL << EXTI_FTSR2_TR49_Pos)              /*!< 0x00020000 */
#define EXTI_FTSR2_TR49            EXTI_FTSR2_TR49_Msk                         /*!< Falling trigger event configuration bit of line 49 */
#define EXTI_FTSR2_TR51_Pos        (19U)
#define EXTI_FTSR2_TR51_Msk        (0x1UL << EXTI_FTSR2_TR51_Pos)              /*!< 0x00080000 */
#define EXTI_FTSR2_TR51            EXTI_FTSR2_TR51_Msk                         /*!< Falling trigger event configuration bit of line 51 */

/******************  Bit definition for EXTI_SWIER2 register  ******************/
#define EXTI_SWIER2_SWIER49_Pos    (17U)
#define EXTI_SWIER2_SWIER49_Msk    (0x1UL << EXTI_SWIER2_SWIER49_Pos)          /*!< 0x00020000 */
#define EXTI_SWIER2_SWIER49        EXTI_SWIER2_SWIER49_Msk                     /*!< Software Interrupt on line 49 */
#define EXTI_SWIER2_SWIER51_Pos    (19U)
#define EXTI_SWIER2_SWIER51_Msk    (0x1UL << EXTI_SWIER2_SWIER51_Pos)          /*!< 0x00080000 */
#define EXTI_SWIER2_SWIER51        EXTI_SWIER2_SWIER51_Msk                     /*!< Software Interrupt on line 51 */

/******************  Bit definition for EXTI_D3PMR2 register  ******************/
#define EXTI_D3PMR2_MR34_Pos       (2U)
#define EXTI_D3PMR2_MR34_Msk       (0x1UL << EXTI_D3PMR2_MR34_Pos)             /*!< 0x00000004 */
#define EXTI_D3PMR2_MR34           EXTI_D3PMR2_MR34_Msk                        /*!< Pending Mask Event for line 34  */
#define EXTI_D3PMR2_MR35_Pos       (3U)
#define EXTI_D3PMR2_MR35_Msk       (0x1UL << EXTI_D3PMR2_MR35_Pos)             /*!< 0x00000008 */
#define EXTI_D3PMR2_MR35           EXTI_D3PMR2_MR35_Msk                        /*!< Pending Mask Event for line 35  */
#define EXTI_D3PMR2_MR41_Pos       (9U)
#define EXTI_D3PMR2_MR41_Msk       (0x1UL << EXTI_D3PMR2_MR41_Pos)             /*!< 0x00000200 */
#define EXTI_D3PMR2_MR41           EXTI_D3PMR2_MR41_Msk                        /*!< Pending Mask Event for line 41  */
#define EXTI_D3PMR2_MR48_Pos       (16U)
#define EXTI_D3PMR2_MR48_Msk       (0x1UL << EXTI_D3PMR2_MR48_Pos)             /*!< 0x00010000 */
#define EXTI_D3PMR2_MR48           EXTI_D3PMR2_MR48_Msk                        /*!< Pending Mask Event for line 48  */
#define EXTI_D3PMR2_MR49_Pos       (17U)
#define EXTI_D3PMR2_MR49_Msk       (0x1UL << EXTI_D3PMR2_MR49_Pos)             /*!< 0x00020000 */
#define EXTI_D3PMR2_MR49           EXTI_D3PMR2_MR49_Msk                        /*!< Pending Mask Event for line 49  */
#define EXTI_D3PMR2_MR50_Pos       (18U)
#define EXTI_D3PMR2_MR50_Msk       (0x1UL << EXTI_D3PMR2_MR50_Pos)             /*!< 0x00040000 */
#define EXTI_D3PMR2_MR50           EXTI_D3PMR2_MR50_Msk                        /*!< Pending Mask Event for line 50  */
#define EXTI_D3PMR2_MR51_Pos       (19U)
#define EXTI_D3PMR2_MR51_Msk       (0x1UL << EXTI_D3PMR2_MR51_Pos)             /*!< 0x00080000 */
#define EXTI_D3PMR2_MR51           EXTI_D3PMR2_MR51_Msk                        /*!< Pending Mask Event for line 51  */
#define EXTI_D3PMR2_MR52_Pos       (20U)
#define EXTI_D3PMR2_MR52_Msk       (0x1UL << EXTI_D3PMR2_MR52_Pos)             /*!< 0x00100000 */
#define EXTI_D3PMR2_MR52           EXTI_D3PMR2_MR52_Msk                        /*!< Pending Mask Event for line 52  */
#define EXTI_D3PMR2_MR53_Pos       (21U)
#define EXTI_D3PMR2_MR53_Msk       (0x1UL << EXTI_D3PMR2_MR53_Pos)             /*!< 0x00200000 */
#define EXTI_D3PMR2_MR53           EXTI_D3PMR2_MR53_Msk                        /*!< Pending Mask Event for line 53  */
/*******************  Bit definition for EXTI_D3PCR2L register  ****************/
#define EXTI_D3PCR2L_PCS34_Pos       (4U)
#define EXTI_D3PCR2L_PCS34_Msk       (0x3UL << EXTI_D3PCR2L_PCS34_Pos)         /*!< 0x00000030 */
#define EXTI_D3PCR2L_PCS34           EXTI_D3PCR2L_PCS34_Msk                    /*!< D3 Pending request clear input signal selection on line 34 */
#define EXTI_D3PCR2L_PCS35_Pos       (6U)
#define EXTI_D3PCR2L_PCS35_Msk       (0x3UL << EXTI_D3PCR2L_PCS35_Pos)         /*!< 0x000000C0 */
#define EXTI_D3PCR2L_PCS35           EXTI_D3PCR2L_PCS35_Msk                    /*!< D3 Pending request clear input signal selection on line 35 */
#define EXTI_D3PCR2L_PCS41_Pos       (18U)
#define EXTI_D3PCR2L_PCS41_Msk       (0x3UL << EXTI_D3PCR2L_PCS41_Pos)         /*!< 0x000C0000 */
#define EXTI_D3PCR2L_PCS41           EXTI_D3PCR2L_PCS41_Msk                    /*!< D3 Pending request clear input signal selection on line 41 */


/*******************  Bit definition for EXTI_D3PCR2H register  ****************/
#define EXTI_D3PCR2H_PCS48_Pos       (0U)
#define EXTI_D3PCR2H_PCS48_Msk       (0x3UL << EXTI_D3PCR2H_PCS48_Pos)         /*!< 0x00000003 */
#define EXTI_D3PCR2H_PCS48           EXTI_D3PCR2H_PCS48_Msk                    /*!< D3 Pending request clear input signal selection on line 48 */
#define EXTI_D3PCR2H_PCS49_Pos       (2U)
#define EXTI_D3PCR2H_PCS49_Msk       (0x3UL << EXTI_D3PCR2H_PCS49_Pos)         /*!< 0x0000000C */
#define EXTI_D3PCR2H_PCS49           EXTI_D3PCR2H_PCS49_Msk                    /*!< D3 Pending request clear input signal selection on line 49 */
#define EXTI_D3PCR2H_PCS50_Pos       (4U)
#define EXTI_D3PCR2H_PCS50_Msk       (0x3UL << EXTI_D3PCR2H_PCS50_Pos)         /*!< 0x00000030 */
#define EXTI_D3PCR2H_PCS50           EXTI_D3PCR2H_PCS50_Msk                    /*!< D3 Pending request clear input signal selection on line 50 */
#define EXTI_D3PCR2H_PCS51_Pos       (6U)
#define EXTI_D3PCR2H_PCS51_Msk       (0x3UL << EXTI_D3PCR2H_PCS51_Pos)         /*!< 0x000000C0 */
#define EXTI_D3PCR2H_PCS51           EXTI_D3PCR2H_PCS51_Msk                    /*!< D3 Pending request clear input signal selection on line 51 */
#define EXTI_D3PCR2H_PCS52_Pos       (8U)
#define EXTI_D3PCR2H_PCS52_Msk       (0x3UL << EXTI_D3PCR2H_PCS52_Pos)         /*!< 0x00000300 */
#define EXTI_D3PCR2H_PCS52           EXTI_D3PCR2H_PCS52_Msk                    /*!< D3 Pending request clear input signal selection on line 52 */
#define EXTI_D3PCR2H_PCS53_Pos       (10U)
#define EXTI_D3PCR2H_PCS53_Msk       (0x3UL << EXTI_D3PCR2H_PCS53_Pos)         /*!< 0x00000C00 */
#define EXTI_D3PCR2H_PCS53           EXTI_D3PCR2H_PCS53_Msk                    /*!< D3 Pending request clear input signal selection on line 53 */
/******************  Bit definition for EXTI_RTSR3 register  *******************/
#define EXTI_RTSR3_TR_Pos          (21U)
#define EXTI_RTSR3_TR_Msk          (0x3UL << EXTI_RTSR3_TR_Pos)                /*!< 0x00600000 */
#define EXTI_RTSR3_TR              EXTI_RTSR3_TR_Msk                           /*!< Rising trigger event configuration bit */
#define EXTI_RTSR3_TR85_Pos        (21U)
#define EXTI_RTSR3_TR85_Msk        (0x1UL << EXTI_RTSR3_TR85_Pos)              /*!< 0x00200000 */
#define EXTI_RTSR3_TR85            EXTI_RTSR3_TR85_Msk                         /*!< Rising trigger event configuration bit of line 85 */
#define EXTI_RTSR3_TR86_Pos        (22U)
#define EXTI_RTSR3_TR86_Msk        (0x1UL << EXTI_RTSR3_TR86_Pos)              /*!< 0x00400000 */
#define EXTI_RTSR3_TR86            EXTI_RTSR3_TR86_Msk                         /*!< Rising trigger event configuration bit of line 86 */

/******************  Bit definition for EXTI_FTSR3 register  *******************/
#define EXTI_FTSR3_TR_Pos          (21U)
#define EXTI_FTSR3_TR_Msk          (0x3UL << EXTI_FTSR3_TR_Pos)               /*!< 0x00600000 */
#define EXTI_FTSR3_TR              EXTI_FTSR3_TR_Msk                           /*!< Falling trigger event configuration bit */
#define EXTI_FTSR3_TR85_Pos        (21U)
#define EXTI_FTSR3_TR85_Msk        (0x1UL << EXTI_FTSR3_TR85_Pos)              /*!< 0x00200000 */
#define EXTI_FTSR3_TR85            EXTI_FTSR3_TR85_Msk                         /*!< Falling trigger event configuration bit of line 85 */
#define EXTI_FTSR3_TR86_Pos        (22U)
#define EXTI_FTSR3_TR86_Msk        (0x1UL << EXTI_FTSR3_TR86_Pos)              /*!< 0x00400000 */
#define EXTI_FTSR3_TR86            EXTI_FTSR3_TR86_Msk                         /*!< Falling trigger event configuration bit of line 86 */

/******************  Bit definition for EXTI_SWIER3 register  ******************/
#define EXTI_SWIER3_SWI_Pos        (21U)
#define EXTI_SWIER3_SWI_Msk        (0x3UL << EXTI_SWIER3_SWI_Pos)             /*!< 0x00600000 */
#define EXTI_SWIER3_SWI            EXTI_SWIER3_SWI_Msk                         /*!< Software Interrupt event bit */
#define EXTI_SWIER3_SWIER85_Pos    (21U)
#define EXTI_SWIER3_SWIER85_Msk    (0x1UL << EXTI_SWIER3_SWIER85_Pos)          /*!< 0x00200000 */
#define EXTI_SWIER3_SWIER85        EXTI_SWIER3_SWIER85_Msk                     /*!< Software Interrupt on line 85 */
#define EXTI_SWIER3_SWIER86_Pos    (22U)
#define EXTI_SWIER3_SWIER86_Msk    (0x1UL << EXTI_SWIER3_SWIER86_Pos)          /*!< 0x00400000 */
#define EXTI_SWIER3_SWIER86        EXTI_SWIER3_SWIER86_Msk                     /*!< Software Interrupt on line 86 */

/******************  Bit definition for EXTI_D3PMR3 register  ******************/
#define EXTI_D3PMR3_MR88_Pos       (24U)
#define EXTI_D3PMR3_MR88_Msk       (0x1UL << EXTI_D3PMR3_MR88_Pos)             /*!< 0x01000000 */
#define EXTI_D3PMR3_MR88           EXTI_D3PMR3_MR88_Msk                        /*!< Pending Mask Event for line 88  */

/*******************  Bit definition for EXTI_D3PCR3H register  ****************/
#define EXTI_D3PCR3H_PCS88_Pos       (16U)
#define EXTI_D3PCR3H_PCS88_Msk       (0x3UL << EXTI_D3PCR3H_PCS88_Pos)         /*!< 0x00030000 */
#define EXTI_D3PCR3H_PCS88           EXTI_D3PCR3H_PCS88_Msk                    /*!< D3 Pending request clear input signal selection on line 88 */

/*******************  Bit definition for EXTI_IMR1 register  *******************/
#define EXTI_IMR1_IM_Pos           (0U)
#define EXTI_IMR1_IM_Msk           (0xFFFFFFFFUL << EXTI_IMR1_IM_Pos)          /*!< 0xFFFFFFFF */
#define EXTI_IMR1_IM               EXTI_IMR1_IM_Msk                            /*!< Interrupt Mask */
#define EXTI_IMR1_IM0_Pos          (0U)
#define EXTI_IMR1_IM0_Msk          (0x1UL << EXTI_IMR1_IM0_Pos)                /*!< 0x00000001 */
#define EXTI_IMR1_IM0              EXTI_IMR1_IM0_Msk                           /*!< Interrupt Mask on line 0 */
#define EXTI_IMR1_IM1_Pos          (1U)
#define EXTI_IMR1_IM1_Msk          (0x1UL << EXTI_IMR1_IM1_Pos)                /*!< 0x00000002 */
#define EXTI_IMR1_IM1              EXTI_IMR1_IM1_Msk                           /*!< Interrupt Mask on line 1 */
#define EXTI_IMR1_IM2_Pos          (2U)
#define EXTI_IMR1_IM2_Msk          (0x1UL << EXTI_IMR1_IM2_Pos)                /*!< 0x00000004 */
#define EXTI_IMR1_IM2              EXTI_IMR1_IM2_Msk                           /*!< Interrupt Mask on line 2 */
#define EXTI_IMR1_IM3_Pos          (3U)
#define EXTI_IMR1_IM3_Msk          (0x1UL << EXTI_IMR1_IM3_Pos)                /*!< 0x00000008 */
#define EXTI_IMR1_IM3              EXTI_IMR1_IM3_Msk                           /*!< Interrupt Mask on line 3 */
#define EXTI_IMR1_IM4_Pos          (4U)
#define EXTI_IMR1_IM4_Msk          (0x1UL << EXTI_IMR1_IM4_Pos)                /*!< 0x00000010 */
#define EXTI_IMR1_IM4              EXTI_IMR1_IM4_Msk                           /*!< Interrupt Mask on line 4 */
#define EXTI_IMR1_IM5_Pos          (5U)
#define EXTI_IMR1_IM5_Msk          (0x1UL << EXTI_IMR1_IM5_Pos)                /*!< 0x00000020 */
#define EXTI_IMR1_IM5              EXTI_IMR1_IM5_Msk                           /*!< Interrupt Mask on line 5 */
#define EXTI_IMR1_IM6_Pos          (6U)
#define EXTI_IMR1_IM6_Msk          (0x1UL << EXTI_IMR1_IM6_Pos)                /*!< 0x00000040 */
#define EXTI_IMR1_IM6              EXTI_IMR1_IM6_Msk                           /*!< Interrupt Mask on line 6 */
#define EXTI_IMR1_IM7_Pos          (7U)
#define EXTI_IMR1_IM7_Msk          (0x1UL << EXTI_IMR1_IM7_Pos)                /*!< 0x00000080 */
#define EXTI_IMR1_IM7              EXTI_IMR1_IM7_Msk                           /*!< Interrupt Mask on line 7 */
#define EXTI_IMR1_IM8_Pos          (8U)
#define EXTI_IMR1_IM8_Msk          (0x1UL << EXTI_IMR1_IM8_Pos)                /*!< 0x00000100 */
#define EXTI_IMR1_IM8              EXTI_IMR1_IM8_Msk                           /*!< Interrupt Mask on line 8 */
#define EXTI_IMR1_IM9_Pos          (9U)
#define EXTI_IMR1_IM9_Msk          (0x1UL << EXTI_IMR1_IM9_Pos)                /*!< 0x00000200 */
#define EXTI_IMR1_IM9              EXTI_IMR1_IM9_Msk                           /*!< Interrupt Mask on line 9 */
#define EXTI_IMR1_IM10_Pos         (10U)
#define EXTI_IMR1_IM10_Msk         (0x1UL << EXTI_IMR1_IM10_Pos)               /*!< 0x00000400 */
#define EXTI_IMR1_IM10             EXTI_IMR1_IM10_Msk                          /*!< Interrupt Mask on line 10 */
#define EXTI_IMR1_IM11_Pos         (11U)
#define EXTI_IMR1_IM11_Msk         (0x1UL << EXTI_IMR1_IM11_Pos)               /*!< 0x00000800 */
#define EXTI_IMR1_IM11             EXTI_IMR1_IM11_Msk                          /*!< Interrupt Mask on line 11 */
#define EXTI_IMR1_IM12_Pos         (12U)
#define EXTI_IMR1_IM12_Msk         (0x1UL << EXTI_IMR1_IM12_Pos)               /*!< 0x00001000 */
#define EXTI_IMR1_IM12             EXTI_IMR1_IM12_Msk                          /*!< Interrupt Mask on line 12 */
#define EXTI_IMR1_IM13_Pos         (13U)
#define EXTI_IMR1_IM13_Msk         (0x1UL << EXTI_IMR1_IM13_Pos)               /*!< 0x00002000 */
#define EXTI_IMR1_IM13             EXTI_IMR1_IM13_Msk                          /*!< Interrupt Mask on line 13 */
#define EXTI_IMR1_IM14_Pos         (14U)
#define EXTI_IMR1_IM14_Msk         (0x1UL << EXTI_IMR1_IM14_Pos)               /*!< 0x00004000 */
#define EXTI_IMR1_IM14             EXTI_IMR1_IM14_Msk                          /*!< Interrupt Mask on line 14 */
#define EXTI_IMR1_IM15_Pos         (15U)
#define EXTI_IMR1_IM15_Msk         (0x1UL << EXTI_IMR1_IM15_Pos)               /*!< 0x00008000 */
#define EXTI_IMR1_IM15             EXTI_IMR1_IM15_Msk                          /*!< Interrupt Mask on line 15 */
#define EXTI_IMR1_IM16_Pos         (16U)
#define EXTI_IMR1_IM16_Msk         (0x1UL << EXTI_IMR1_IM16_Pos)               /*!< 0x00010000 */
#define EXTI_IMR1_IM16             EXTI_IMR1_IM16_Msk                          /*!< Interrupt Mask on line 16 */
#define EXTI_IMR1_IM17_Pos         (17U)
#define EXTI_IMR1_IM17_Msk         (0x1UL << EXTI_IMR1_IM17_Pos)               /*!< 0x00020000 */
#define EXTI_IMR1_IM17             EXTI_IMR1_IM17_Msk                          /*!< Interrupt Mask on line 17 */
#define EXTI_IMR1_IM18_Pos         (18U)
#define EXTI_IMR1_IM18_Msk         (0x1UL << EXTI_IMR1_IM18_Pos)               /*!< 0x00040000 */
#define EXTI_IMR1_IM18             EXTI_IMR1_IM18_Msk                          /*!< Interrupt Mask on line 18 */
#define EXTI_IMR1_IM19_Pos         (19U)
#define EXTI_IMR1_IM19_Msk         (0x1UL << EXTI_IMR1_IM19_Pos)               /*!< 0x00080000 */
#define EXTI_IMR1_IM19             EXTI_IMR1_IM19_Msk                          /*!< Interrupt Mask on line 19 */
#define EXTI_IMR1_IM20_Pos         (20U)
#define EXTI_IMR1_IM20_Msk         (0x1UL << EXTI_IMR1_IM20_Pos)               /*!< 0x00100000 */
#define EXTI_IMR1_IM20             EXTI_IMR1_IM20_Msk                          /*!< Interrupt Mask on line 20 */
#define EXTI_IMR1_IM21_Pos         (21U)
#define EXTI_IMR1_IM21_Msk         (0x1UL << EXTI_IMR1_IM21_Pos)               /*!< 0x00200000 */
#define EXTI_IMR1_IM21             EXTI_IMR1_IM21_Msk                          /*!< Interrupt Mask on line 21 */
#define EXTI_IMR1_IM22_Pos         (22U)
#define EXTI_IMR1_IM22_Msk         (0x1UL << EXTI_IMR1_IM22_Pos)               /*!< 0x00400000 */
#define EXTI_IMR1_IM22             EXTI_IMR1_IM22_Msk                          /*!< Interrupt Mask on line 22 */
#define EXTI_IMR1_IM23_Pos         (23U)
#define EXTI_IMR1_IM23_Msk         (0x1UL << EXTI_IMR1_IM23_Pos)               /*!< 0x00800000 */
#define EXTI_IMR1_IM23             EXTI_IMR1_IM23_Msk                          /*!< Interrupt Mask on line 23 */
#define EXTI_IMR1_IM24_Pos         (24U)
#define EXTI_IMR1_IM24_Msk         (0x1UL << EXTI_IMR1_IM24_Pos)               /*!< 0x01000000 */
#define EXTI_IMR1_IM24             EXTI_IMR1_IM24_Msk                          /*!< Interrupt Mask on line 24 */
#define EXTI_IMR1_IM25_Pos         (25U)
#define EXTI_IMR1_IM25_Msk         (0x1UL << EXTI_IMR1_IM25_Pos)               /*!< 0x02000000 */
#define EXTI_IMR1_IM25             EXTI_IMR1_IM25_Msk                          /*!< Interrupt Mask on line 25 */
#define EXTI_IMR1_IM26_Pos         (26U)
#define EXTI_IMR1_IM26_Msk         (0x1UL << EXTI_IMR1_IM26_Pos)               /*!< 0x04000000 */
#define EXTI_IMR1_IM26             EXTI_IMR1_IM26_Msk                          /*!< Interrupt Mask on line 26 */
#define EXTI_IMR1_IM27_Pos         (27U)
#define EXTI_IMR1_IM27_Msk         (0x1UL << EXTI_IMR1_IM27_Pos)               /*!< 0x08000000 */
#define EXTI_IMR1_IM27             EXTI_IMR1_IM27_Msk                          /*!< Interrupt Mask on line 27 */
#define EXTI_IMR1_IM28_Pos         (28U)
#define EXTI_IMR1_IM28_Msk         (0x1UL << EXTI_IMR1_IM28_Pos)               /*!< 0x10000000 */
#define EXTI_IMR1_IM28             EXTI_IMR1_IM28_Msk                          /*!< Interrupt Mask on line 28 */
#define EXTI_IMR1_IM29_Pos         (29U)
#define EXTI_IMR1_IM29_Msk         (0x1UL << EXTI_IMR1_IM29_Pos)               /*!< 0x20000000 */
#define EXTI_IMR1_IM29             EXTI_IMR1_IM29_Msk                          /*!< Interrupt Mask on line 29 */
#define EXTI_IMR1_IM30_Pos         (30U)
#define EXTI_IMR1_IM30_Msk         (0x1UL << EXTI_IMR1_IM30_Pos)               /*!< 0x40000000 */
#define EXTI_IMR1_IM30             EXTI_IMR1_IM30_Msk                          /*!< Interrupt Mask on line 30 */
#define EXTI_IMR1_IM31_Pos         (31U)
#define EXTI_IMR1_IM31_Msk         (0x1UL << EXTI_IMR1_IM31_Pos)               /*!< 0x80000000 */
#define EXTI_IMR1_IM31             EXTI_IMR1_IM31_Msk                          /*!< Interrupt Mask on line 31 */

/*******************  Bit definition for EXTI_EMR1 register  *******************/
#define EXTI_EMR1_EM_Pos           (0U)
#define EXTI_EMR1_EM_Msk           (0xFFFFFFFFUL << EXTI_EMR1_EM_Pos)          /*!< 0xFFFFFFFF */
#define EXTI_EMR1_EM               EXTI_EMR1_EM_Msk                            /*!< Event Mask */
#define EXTI_EMR1_EM0_Pos          (0U)
#define EXTI_EMR1_EM0_Msk          (0x1UL << EXTI_EMR1_EM0_Pos)                /*!< 0x00000001 */
#define EXTI_EMR1_EM0              EXTI_EMR1_EM0_Msk                           /*!< Event Mask on line 0 */
#define EXTI_EMR1_EM1_Pos          (1U)
#define EXTI_EMR1_EM1_Msk          (0x1UL << EXTI_EMR1_EM1_Pos)                /*!< 0x00000002 */
#define EXTI_EMR1_EM1              EXTI_EMR1_EM1_Msk                           /*!< Event Mask on line 1 */
#define EXTI_EMR1_EM2_Pos          (2U)
#define EXTI_EMR1_EM2_Msk          (0x1UL << EXTI_EMR1_EM2_Pos)                /*!< 0x00000004 */
#define EXTI_EMR1_EM2              EXTI_EMR1_EM2_Msk                           /*!< Event Mask on line 2 */
#define EXTI_EMR1_EM3_Pos          (3U)
#define EXTI_EMR1_EM3_Msk          (0x1UL << EXTI_EMR1_EM3_Pos)                /*!< 0x00000008 */
#define EXTI_EMR1_EM3              EXTI_EMR1_EM3_Msk                           /*!< Event Mask on line 3 */
#define EXTI_EMR1_EM4_Pos          (4U)
#define EXTI_EMR1_EM4_Msk          (0x1UL << EXTI_EMR1_EM4_Pos)                /*!< 0x00000010 */
#define EXTI_EMR1_EM4              EXTI_EMR1_EM4_Msk                           /*!< Event Mask on line 4 */
#define EXTI_EMR1_EM5_Pos          (5U)
#define EXTI_EMR1_EM5_Msk          (0x1UL << EXTI_EMR1_EM5_Pos)                /*!< 0x00000020 */
#define EXTI_EMR1_EM5              EXTI_EMR1_EM5_Msk                           /*!< Event Mask on line 5 */
#define EXTI_EMR1_EM6_Pos          (6U)
#define EXTI_EMR1_EM6_Msk          (0x1UL << EXTI_EMR1_EM6_Pos)                /*!< 0x00000040 */
#define EXTI_EMR1_EM6              EXTI_EMR1_EM6_Msk                           /*!< Event Mask on line 6 */
#define EXTI_EMR1_EM7_Pos          (7U)
#define EXTI_EMR1_EM7_Msk          (0x1UL << EXTI_EMR1_EM7_Pos)                /*!< 0x00000080 */
#define EXTI_EMR1_EM7              EXTI_EMR1_EM7_Msk                           /*!< Event Mask on line 7 */
#define EXTI_EMR1_EM8_Pos          (8U)
#define EXTI_EMR1_EM8_Msk          (0x1UL << EXTI_EMR1_EM8_Pos)                /*!< 0x00000100 */
#define EXTI_EMR1_EM8              EXTI_EMR1_EM8_Msk                           /*!< Event Mask on line 8 */
#define EXTI_EMR1_EM9_Pos          (9U)
#define EXTI_EMR1_EM9_Msk          (0x1UL << EXTI_EMR1_EM9_Pos)                /*!< 0x00000200 */
#define EXTI_EMR1_EM9              EXTI_EMR1_EM9_Msk                           /*!< Event Mask on line 9 */
#define EXTI_EMR1_EM10_Pos         (10U)
#define EXTI_EMR1_EM10_Msk         (0x1UL << EXTI_EMR1_EM10_Pos)               /*!< 0x00000400 */
#define EXTI_EMR1_EM10             EXTI_EMR1_EM10_Msk                          /*!< Event Mask on line 10 */
#define EXTI_EMR1_EM11_Pos         (11U)
#define EXTI_EMR1_EM11_Msk         (0x1UL << EXTI_EMR1_EM11_Pos)               /*!< 0x00000800 */
#define EXTI_EMR1_EM11             EXTI_EMR1_EM11_Msk                          /*!< Event Mask on line 11 */
#define EXTI_EMR1_EM12_Pos         (12U)
#define EXTI_EMR1_EM12_Msk         (0x1UL << EXTI_EMR1_EM12_Pos)               /*!< 0x00001000 */
#define EXTI_EMR1_EM12             EXTI_EMR1_EM12_Msk                          /*!< Event Mask on line 12 */
#define EXTI_EMR1_EM13_Pos         (13U)
#define EXTI_EMR1_EM13_Msk         (0x1UL << EXTI_EMR1_EM13_Pos)               /*!< 0x00002000 */
#define EXTI_EMR1_EM13             EXTI_EMR1_EM13_Msk                          /*!< Event Mask on line 13 */
#define EXTI_EMR1_EM14_Pos         (14U)
#define EXTI_EMR1_EM14_Msk         (0x1UL << EXTI_EMR1_EM14_Pos)               /*!< 0x00004000 */
#define EXTI_EMR1_EM14             EXTI_EMR1_EM14_Msk                          /*!< Event Mask on line 14 */
#define EXTI_EMR1_EM15_Pos         (15U)
#define EXTI_EMR1_EM15_Msk         (0x1UL << EXTI_EMR1_EM15_Pos)               /*!< 0x00008000 */
#define EXTI_EMR1_EM15             EXTI_EMR1_EM15_Msk                          /*!< Event Mask on line 15 */
#define EXTI_EMR1_EM16_Pos         (16U)
#define EXTI_EMR1_EM16_Msk         (0x1UL << EXTI_EMR1_EM16_Pos)               /*!< 0x00010000 */
#define EXTI_EMR1_EM16             EXTI_EMR1_EM16_Msk                          /*!< Event Mask on line 16 */
#define EXTI_EMR1_EM17_Pos         (17U)
#define EXTI_EMR1_EM17_Msk         (0x1UL << EXTI_EMR1_EM17_Pos)               /*!< 0x00020000 */
#define EXTI_EMR1_EM17             EXTI_EMR1_EM17_Msk                          /*!< Event Mask on line 17 */
#define EXTI_EMR1_EM18_Pos         (18U)
#define EXTI_EMR1_EM18_Msk         (0x1UL << EXTI_EMR1_EM18_Pos)               /*!< 0x00040000 */
#define EXTI_EMR1_EM18             EXTI_EMR1_EM18_Msk                          /*!< Event Mask on line 18 */
#define EXTI_EMR1_EM20_Pos         (20U)
#define EXTI_EMR1_EM20_Msk         (0x1UL << EXTI_EMR1_EM20_Pos)               /*!< 0x00100000 */
#define EXTI_EMR1_EM20             EXTI_EMR1_EM20_Msk                          /*!< Event Mask on line 20 */
#define EXTI_EMR1_EM21_Pos         (21U)
#define EXTI_EMR1_EM21_Msk         (0x1UL << EXTI_EMR1_EM21_Pos)               /*!< 0x00200000 */
#define EXTI_EMR1_EM21             EXTI_EMR1_EM21_Msk                          /*!< Event Mask on line 21 */
#define EXTI_EMR1_EM22_Pos         (22U)
#define EXTI_EMR1_EM22_Msk         (0x1UL << EXTI_EMR1_EM22_Pos)               /*!< 0x00400000 */
#define EXTI_EMR1_EM22             EXTI_EMR1_EM22_Msk                          /*!< Event Mask on line 22 */
#define EXTI_EMR1_EM23_Pos         (23U)
#define EXTI_EMR1_EM23_Msk         (0x1UL << EXTI_EMR1_EM23_Pos)               /*!< 0x00800000 */
#define EXTI_EMR1_EM23             EXTI_EMR1_EM23_Msk                          /*!< Event Mask on line 23 */
#define EXTI_EMR1_EM24_Pos         (24U)
#define EXTI_EMR1_EM24_Msk         (0x1UL << EXTI_EMR1_EM24_Pos)               /*!< 0x01000000 */
#define EXTI_EMR1_EM24             EXTI_EMR1_EM24_Msk                          /*!< Event Mask on line 24 */
#define EXTI_EMR1_EM25_Pos         (25U)
#define EXTI_EMR1_EM25_Msk         (0x1UL << EXTI_EMR1_EM25_Pos)               /*!< 0x02000000 */
#define EXTI_EMR1_EM25             EXTI_EMR1_EM25_Msk                          /*!< Event Mask on line 25 */
#define EXTI_EMR1_EM26_Pos         (26U)
#define EXTI_EMR1_EM26_Msk         (0x1UL << EXTI_EMR1_EM26_Pos)               /*!< 0x04000000 */
#define EXTI_EMR1_EM26             EXTI_EMR1_EM26_Msk                          /*!< Event Mask on line 26 */
#define EXTI_EMR1_EM27_Pos         (27U)
#define EXTI_EMR1_EM27_Msk         (0x1UL << EXTI_EMR1_EM27_Pos)               /*!< 0x08000000 */
#define EXTI_EMR1_EM27             EXTI_EMR1_EM27_Msk                          /*!< Event Mask on line 27 */
#define EXTI_EMR1_EM28_Pos         (28U)
#define EXTI_EMR1_EM28_Msk         (0x1UL << EXTI_EMR1_EM28_Pos)               /*!< 0x10000000 */
#define EXTI_EMR1_EM28             EXTI_EMR1_EM28_Msk                          /*!< Event Mask on line 28 */
#define EXTI_EMR1_EM29_Pos         (29U)
#define EXTI_EMR1_EM29_Msk         (0x1UL << EXTI_EMR1_EM29_Pos)               /*!< 0x20000000 */
#define EXTI_EMR1_EM29             EXTI_EMR1_EM29_Msk                          /*!< Event Mask on line 29 */
#define EXTI_EMR1_EM30_Pos         (30U)
#define EXTI_EMR1_EM30_Msk         (0x1UL << EXTI_EMR1_EM30_Pos)               /*!< 0x40000000 */
#define EXTI_EMR1_EM30             EXTI_EMR1_EM30_Msk                          /*!< Event Mask on line 30 */
#define EXTI_EMR1_EM31_Pos         (31U)
#define EXTI_EMR1_EM31_Msk         (0x1UL << EXTI_EMR1_EM31_Pos)               /*!< 0x80000000 */
#define EXTI_EMR1_EM31             EXTI_EMR1_EM31_Msk                          /*!< Event Mask on line 31 */

/*******************  Bit definition for EXTI_PR1 register  ********************/
#define EXTI_PR1_PR_Pos            (0U)
#define EXTI_PR1_PR_Msk            (0x3FFFFFUL << EXTI_PR1_PR_Pos)             /*!< 0x003FFFFF */
#define EXTI_PR1_PR                EXTI_PR1_PR_Msk                             /*!< Pending bit */
#define EXTI_PR1_PR0_Pos           (0U)
#define EXTI_PR1_PR0_Msk           (0x1UL << EXTI_PR1_PR0_Pos)                 /*!< 0x00000001 */
#define EXTI_PR1_PR0               EXTI_PR1_PR0_Msk                            /*!< Pending bit for line 0 */
#define EXTI_PR1_PR1_Pos           (1U)
#define EXTI_PR1_PR1_Msk           (0x1UL << EXTI_PR1_PR1_Pos)                 /*!< 0x00000002 */
#define EXTI_PR1_PR1               EXTI_PR1_PR1_Msk                            /*!< Pending bit for line 1 */
#define EXTI_PR1_PR2_Pos           (2U)
#define EXTI_PR1_PR2_Msk           (0x1UL << EXTI_PR1_PR2_Pos)                 /*!< 0x00000004 */
#define EXTI_PR1_PR2               EXTI_PR1_PR2_Msk                            /*!< Pending bit for line 2 */
#define EXTI_PR1_PR3_Pos           (3U)
#define EXTI_PR1_PR3_Msk           (0x1UL << EXTI_PR1_PR3_Pos)                 /*!< 0x00000008 */
#define EXTI_PR1_PR3               EXTI_PR1_PR3_Msk                            /*!< Pending bit for line 3 */
#define EXTI_PR1_PR4_Pos           (4U)
#define EXTI_PR1_PR4_Msk           (0x1UL << EXTI_PR1_PR4_Pos)                 /*!< 0x00000010 */
#define EXTI_PR1_PR4               EXTI_PR1_PR4_Msk                            /*!< Pending bit for line 4 */
#define EXTI_PR1_PR5_Pos           (5U)
#define EXTI_PR1_PR5_Msk           (0x1UL << EXTI_PR1_PR5_Pos)                 /*!< 0x00000020 */
#define EXTI_PR1_PR5               EXTI_PR1_PR5_Msk                            /*!< Pending bit for line 5 */
#define EXTI_PR1_PR6_Pos           (6U)
#define EXTI_PR1_PR6_Msk           (0x1UL << EXTI_PR1_PR6_Pos)                 /*!< 0x00000040 */
#define EXTI_PR1_PR6               EXTI_PR1_PR6_Msk                            /*!< Pending bit for line 6 */
#define EXTI_PR1_PR7_Pos           (7U)
#define EXTI_PR1_PR7_Msk           (0x1UL << EXTI_PR1_PR7_Pos)                 /*!< 0x00000080 */
#define EXTI_PR1_PR7               EXTI_PR1_PR7_Msk                            /*!< Pending bit for line 7 */
#define EXTI_PR1_PR8_Pos           (8U)
#define EXTI_PR1_PR8_Msk           (0x1UL << EXTI_PR1_PR8_Pos)                 /*!< 0x00000100 */
#define EXTI_PR1_PR8               EXTI_PR1_PR8_Msk                            /*!< Pending bit for line 8 */
#define EXTI_PR1_PR9_Pos           (9U)
#define EXTI_PR1_PR9_Msk           (0x1UL << EXTI_PR1_PR9_Pos)                 /*!< 0x00000200 */
#define EXTI_PR1_PR9               EXTI_PR1_PR9_Msk                            /*!< Pending bit for line 9 */
#define EXTI_PR1_PR10_Pos          (10U)
#define EXTI_PR1_PR10_Msk          (0x1UL << EXTI_PR1_PR10_Pos)                /*!< 0x00000400 */
#define EXTI_PR1_PR10              EXTI_PR1_PR10_Msk                           /*!< Pending bit for line 10 */
#define EXTI_PR1_PR11_Pos          (11U)
#define EXTI_PR1_PR11_Msk          (0x1UL << EXTI_PR1_PR11_Pos)                /*!< 0x00000800 */
#define EXTI_PR1_PR11              EXTI_PR1_PR11_Msk                           /*!< Pending bit for line 11 */
#define EXTI_PR1_PR12_Pos          (12U)
#define EXTI_PR1_PR12_Msk          (0x1UL << EXTI_PR1_PR12_Pos)                /*!< 0x00001000 */
#define EXTI_PR1_PR12              EXTI_PR1_PR12_Msk                           /*!< Pending bit for line 12 */
#define EXTI_PR1_PR13_Pos          (13U)
#define EXTI_PR1_PR13_Msk          (0x1UL << EXTI_PR1_PR13_Pos)                /*!< 0x00002000 */
#define EXTI_PR1_PR13              EXTI_PR1_PR13_Msk                           /*!< Pending bit for line 13 */
#define EXTI_PR1_PR14_Pos          (14U)
#define EXTI_PR1_PR14_Msk          (0x1UL << EXTI_PR1_PR14_Pos)                /*!< 0x00004000 */
#define EXTI_PR1_PR14              EXTI_PR1_PR14_Msk                           /*!< Pending bit for line 14 */
#define EXTI_PR1_PR15_Pos          (15U)
#define EXTI_PR1_PR15_Msk          (0x1UL << EXTI_PR1_PR15_Pos)                /*!< 0x00008000 */
#define EXTI_PR1_PR15              EXTI_PR1_PR15_Msk                           /*!< Pending bit for line 15 */
#define EXTI_PR1_PR16_Pos          (16U)
#define EXTI_PR1_PR16_Msk          (0x1UL << EXTI_PR1_PR16_Pos)                /*!< 0x00010000 */
#define EXTI_PR1_PR16              EXTI_PR1_PR16_Msk                           /*!< Pending bit for line 16 */
#define EXTI_PR1_PR17_Pos          (17U)
#define EXTI_PR1_PR17_Msk          (0x1UL << EXTI_PR1_PR17_Pos)                /*!< 0x00020000 */
#define EXTI_PR1_PR17              EXTI_PR1_PR17_Msk                           /*!< Pending bit for line 17 */
#define EXTI_PR1_PR18_Pos          (18U)
#define EXTI_PR1_PR18_Msk          (0x1UL << EXTI_PR1_PR18_Pos)                /*!< 0x00040000 */
#define EXTI_PR1_PR18              EXTI_PR1_PR18_Msk                           /*!< Pending bit for line 18 */
#define EXTI_PR1_PR19_Pos          (19U)
#define EXTI_PR1_PR19_Msk          (0x1UL << EXTI_PR1_PR19_Pos)                /*!< 0x00080000 */
#define EXTI_PR1_PR19              EXTI_PR1_PR19_Msk                           /*!< Pending bit for line 19 */
#define EXTI_PR1_PR20_Pos          (20U)
#define EXTI_PR1_PR20_Msk          (0x1UL << EXTI_PR1_PR20_Pos)                /*!< 0x00100000 */
#define EXTI_PR1_PR20              EXTI_PR1_PR20_Msk                           /*!< Pending bit for line 20 */
#define EXTI_PR1_PR21_Pos          (21U)
#define EXTI_PR1_PR21_Msk          (0x1UL << EXTI_PR1_PR21_Pos)                /*!< 0x00200000 */
#define EXTI_PR1_PR21              EXTI_PR1_PR21_Msk                           /*!< Pending bit for line 21 */

/*******************  Bit definition for EXTI_IMR2 register  *******************/
#define EXTI_IMR2_IM_Pos           (0U)
#define EXTI_IMR2_IM_Msk           (0xFFFFDFFFUL << EXTI_IMR2_IM_Pos)          /*!< 0xFFFFDFFF */
#define EXTI_IMR2_IM               EXTI_IMR2_IM_Msk                            /*!< Interrupt Mask */
#define EXTI_IMR2_IM32_Pos         (0U)
#define EXTI_IMR2_IM32_Msk         (0x1UL << EXTI_IMR2_IM32_Pos)               /*!< 0x00000001 */
#define EXTI_IMR2_IM32             EXTI_IMR2_IM32_Msk                          /*!< Interrupt Mask on line 32 */
#define EXTI_IMR2_IM33_Pos         (1U)
#define EXTI_IMR2_IM33_Msk         (0x1UL << EXTI_IMR2_IM33_Pos)               /*!< 0x00000002 */
#define EXTI_IMR2_IM33             EXTI_IMR2_IM33_Msk                          /*!< Interrupt Mask on line 33 */
#define EXTI_IMR2_IM34_Pos         (2U)
#define EXTI_IMR2_IM34_Msk         (0x1UL << EXTI_IMR2_IM34_Pos)               /*!< 0x00000004 */
#define EXTI_IMR2_IM34             EXTI_IMR2_IM34_Msk                          /*!< Interrupt Mask on line 34 */
#define EXTI_IMR2_IM35_Pos         (3U)
#define EXTI_IMR2_IM35_Msk         (0x1UL << EXTI_IMR2_IM35_Pos)               /*!< 0x00000008 */
#define EXTI_IMR2_IM35             EXTI_IMR2_IM35_Msk                          /*!< Interrupt Mask on line 35 */
#define EXTI_IMR2_IM36_Pos         (4U)
#define EXTI_IMR2_IM36_Msk         (0x1UL << EXTI_IMR2_IM36_Pos)               /*!< 0x00000010 */
#define EXTI_IMR2_IM36             EXTI_IMR2_IM36_Msk                          /*!< Interrupt Mask on line 36 */
#define EXTI_IMR2_IM37_Pos         (5U)
#define EXTI_IMR2_IM37_Msk         (0x1UL << EXTI_IMR2_IM37_Pos)               /*!< 0x00000020 */
#define EXTI_IMR2_IM37             EXTI_IMR2_IM37_Msk                          /*!< Interrupt Mask on line 37 */
#define EXTI_IMR2_IM38_Pos         (6U)
#define EXTI_IMR2_IM38_Msk         (0x1UL << EXTI_IMR2_IM38_Pos)               /*!< 0x00000040 */
#define EXTI_IMR2_IM38             EXTI_IMR2_IM38_Msk                          /*!< Interrupt Mask on line 38 */
#define EXTI_IMR2_IM39_Pos         (7U)
#define EXTI_IMR2_IM39_Msk         (0x1UL << EXTI_IMR2_IM39_Pos)               /*!< 0x00000080 */
#define EXTI_IMR2_IM39             EXTI_IMR2_IM39_Msk                          /*!< Interrupt Mask on line 39 */
#define EXTI_IMR2_IM40_Pos         (8U)
#define EXTI_IMR2_IM40_Msk         (0x1UL << EXTI_IMR2_IM40_Pos)               /*!< 0x00000100 */
#define EXTI_IMR2_IM40             EXTI_IMR2_IM40_Msk                          /*!< Interrupt Mask on line 40 */
#define EXTI_IMR2_IM41_Pos         (9U)
#define EXTI_IMR2_IM41_Msk         (0x1UL << EXTI_IMR2_IM41_Pos)               /*!< 0x00000200 */
#define EXTI_IMR2_IM41             EXTI_IMR2_IM41_Msk                          /*!< Interrupt Mask on line 41 */
#define EXTI_IMR2_IM42_Pos         (10U)
#define EXTI_IMR2_IM42_Msk         (0x1UL << EXTI_IMR2_IM42_Pos)               /*!< 0x00000400 */
#define EXTI_IMR2_IM42             EXTI_IMR2_IM42_Msk                          /*!< Interrupt Mask on line 42 */
#define EXTI_IMR2_IM43_Pos         (11U)
#define EXTI_IMR2_IM43_Msk         (0x1UL << EXTI_IMR2_IM43_Pos)               /*!< 0x00000800 */
#define EXTI_IMR2_IM43             EXTI_IMR2_IM43_Msk                          /*!< Interrupt Mask on line 43 */
#define EXTI_IMR2_IM47_Pos         (15U)
#define EXTI_IMR2_IM47_Msk         (0x1UL << EXTI_IMR2_IM47_Pos)               /*!< 0x00008000 */
#define EXTI_IMR2_IM47             EXTI_IMR2_IM47_Msk                          /*!< Interrupt Mask on line 47 */
#define EXTI_IMR2_IM48_Pos         (16U)
#define EXTI_IMR2_IM48_Msk         (0x1UL << EXTI_IMR2_IM48_Pos)               /*!< 0x00010000 */
#define EXTI_IMR2_IM48             EXTI_IMR2_IM48_Msk                          /*!< Interrupt Mask on line 48 */
#define EXTI_IMR2_IM49_Pos         (17U)
#define EXTI_IMR2_IM49_Msk         (0x1UL << EXTI_IMR2_IM49_Pos)               /*!< 0x00020000 */
#define EXTI_IMR2_IM49             EXTI_IMR2_IM49_Msk                          /*!< Interrupt Mask on line 49 */
#define EXTI_IMR2_IM50_Pos         (18U)
#define EXTI_IMR2_IM50_Msk         (0x1UL << EXTI_IMR2_IM50_Pos)               /*!< 0x00040000 */
#define EXTI_IMR2_IM50             EXTI_IMR2_IM50_Msk                          /*!< Interrupt Mask on line 50 */
#define EXTI_IMR2_IM51_Pos         (19U)
#define EXTI_IMR2_IM51_Msk         (0x1UL << EXTI_IMR2_IM51_Pos)               /*!< 0x00080000 */
#define EXTI_IMR2_IM51             EXTI_IMR2_IM51_Msk                          /*!< Interrupt Mask on line 51 */
#define EXTI_IMR2_IM52_Pos         (20U)
#define EXTI_IMR2_IM52_Msk         (0x1UL << EXTI_IMR2_IM52_Pos)               /*!< 0x00100000 */
#define EXTI_IMR2_IM52             EXTI_IMR2_IM52_Msk                          /*!< Interrupt Mask on line 52 */
#define EXTI_IMR2_IM53_Pos         (21U)
#define EXTI_IMR2_IM53_Msk         (0x1UL << EXTI_IMR2_IM53_Pos)               /*!< 0x00200000 */
#define EXTI_IMR2_IM53             EXTI_IMR2_IM53_Msk                          /*!< Interrupt Mask on line 53 */
#define EXTI_IMR2_IM54_Pos         (22U)
#define EXTI_IMR2_IM54_Msk         (0x1UL << EXTI_IMR2_IM54_Pos)               /*!< 0x00400000 */
#define EXTI_IMR2_IM54             EXTI_IMR2_IM54_Msk                          /*!< Interrupt Mask on line 54 */
#define EXTI_IMR2_IM55_Pos         (23U)
#define EXTI_IMR2_IM55_Msk         (0x1UL << EXTI_IMR2_IM55_Pos)               /*!< 0x00800000 */
#define EXTI_IMR2_IM55             EXTI_IMR2_IM55_Msk                          /*!< Interrupt Mask on line 55 */
#define EXTI_IMR2_IM56_Pos         (24U)
#define EXTI_IMR2_IM56_Msk         (0x1UL << EXTI_IMR2_IM56_Pos)               /*!< 0x01000000 */
#define EXTI_IMR2_IM56             EXTI_IMR2_IM56_Msk                          /*!< Interrupt Mask on line 56 */
#define EXTI_IMR2_IM58_Pos         (26U)
#define EXTI_IMR2_IM58_Msk         (0x1UL << EXTI_IMR2_IM58_Pos)               /*!< 0x04000000 */
#define EXTI_IMR2_IM58             EXTI_IMR2_IM58_Msk                          /*!< Interrupt Mask on line 58 */
#define EXTI_IMR2_IM60_Pos         (28U)
#define EXTI_IMR2_IM60_Msk         (0x1UL << EXTI_IMR2_IM60_Pos)               /*!< 0x10000000 */
#define EXTI_IMR2_IM60             EXTI_IMR2_IM60_Msk                          /*!< Interrupt Mask on line 60 */
#define EXTI_IMR2_IM61_Pos         (29U)
#define EXTI_IMR2_IM61_Msk         (0x1UL << EXTI_IMR2_IM61_Pos)               /*!< 0x20000000 */
#define EXTI_IMR2_IM61             EXTI_IMR2_IM61_Msk                          /*!< Interrupt Mask on line 61 */
#define EXTI_IMR2_IM62_Pos         (30U)
#define EXTI_IMR2_IM62_Msk         (0x1UL << EXTI_IMR2_IM62_Pos)               /*!< 0x40000000 */
#define EXTI_IMR2_IM62             EXTI_IMR2_IM62_Msk                          /*!< Interrupt Mask on line 62 */
#define EXTI_IMR2_IM63_Pos         (31U)
#define EXTI_IMR2_IM63_Msk         (0x1UL << EXTI_IMR2_IM63_Pos)               /*!< 0x80000000 */
#define EXTI_IMR2_IM63             EXTI_IMR2_IM63_Msk                          /*!< Interrupt Mask on line 63 */

/*******************  Bit definition for EXTI_EMR2 register  *******************/
#define EXTI_EMR2_EM_Pos           (0U)
#define EXTI_EMR2_EM_Msk           (0xFFFFDFFFUL << EXTI_EMR2_EM_Pos)          /*!< 0xFFFFDFFF */
#define EXTI_EMR2_EM               EXTI_EMR2_EM_Msk                            /*!< Event Mask */
#define EXTI_EMR2_EM32_Pos         (0U)
#define EXTI_EMR2_EM32_Msk         (0x1UL << EXTI_EMR2_EM32_Pos)               /*!< 0x00000001 */
#define EXTI_EMR2_EM32             EXTI_EMR2_EM32_Msk                          /*!< Event Mask on line 32*/
#define EXTI_EMR2_EM33_Pos         (1U)
#define EXTI_EMR2_EM33_Msk         (0x1UL << EXTI_EMR2_EM33_Pos)               /*!< 0x00000002 */
#define EXTI_EMR2_EM33             EXTI_EMR2_EM33_Msk                          /*!< Event Mask on line 33*/
#define EXTI_EMR2_EM34_Pos         (2U)
#define EXTI_EMR2_EM34_Msk         (0x1UL << EXTI_EMR2_EM34_Pos)               /*!< 0x00000004 */
#define EXTI_EMR2_EM34             EXTI_EMR2_EM34_Msk                          /*!< Event Mask on line 34*/
#define EXTI_EMR2_EM35_Pos         (3U)
#define EXTI_EMR2_EM35_Msk         (0x1UL << EXTI_EMR2_EM35_Pos)               /*!< 0x00000008 */
#define EXTI_EMR2_EM35             EXTI_EMR2_EM35_Msk                          /*!< Event Mask on line 35*/
#define EXTI_EMR2_EM36_Pos         (4U)
#define EXTI_EMR2_EM36_Msk         (0x1UL << EXTI_EMR2_EM36_Pos)               /*!< 0x00000010 */
#define EXTI_EMR2_EM36             EXTI_EMR2_EM36_Msk                          /*!< Event Mask on line 36*/
#define EXTI_EMR2_EM37_Pos         (5U)
#define EXTI_EMR2_EM37_Msk         (0x1UL << EXTI_EMR2_EM37_Pos)               /*!< 0x00000020 */
#define EXTI_EMR2_EM37             EXTI_EMR2_EM37_Msk                          /*!< Event Mask on line 37*/
#define EXTI_EMR2_EM38_Pos         (6U)
#define EXTI_EMR2_EM38_Msk         (0x1UL << EXTI_EMR2_EM38_Pos)               /*!< 0x00000040 */
#define EXTI_EMR2_EM38             EXTI_EMR2_EM38_Msk                          /*!< Event Mask on line 38*/
#define EXTI_EMR2_EM39_Pos         (7U)
#define EXTI_EMR2_EM39_Msk         (0x1UL << EXTI_EMR2_EM39_Pos)               /*!< 0x00000080 */
#define EXTI_EMR2_EM39             EXTI_EMR2_EM39_Msk                          /*!< Event Mask on line 39*/
#define EXTI_EMR2_EM40_Pos         (8U)
#define EXTI_EMR2_EM40_Msk         (0x1UL << EXTI_EMR2_EM40_Pos)               /*!< 0x00000100 */
#define EXTI_EMR2_EM40             EXTI_EMR2_EM40_Msk                          /*!< Event Mask on line 40*/
#define EXTI_EMR2_EM41_Pos         (9U)
#define EXTI_EMR2_EM41_Msk         (0x1UL << EXTI_EMR2_EM41_Pos)               /*!< 0x00000200 */
#define EXTI_EMR2_EM41             EXTI_EMR2_EM41_Msk                          /*!< Event Mask on line 41*/
#define EXTI_EMR2_EM42_Pos         (10U)
#define EXTI_EMR2_EM42_Msk         (0x1UL << EXTI_EMR2_EM42_Pos)               /*!< 0x00000400 */
#define EXTI_EMR2_EM42             EXTI_EMR2_EM42_Msk                          /*!< Event Mask on line 42 */
#define EXTI_EMR2_EM43_Pos         (11U)
#define EXTI_EMR2_EM43_Msk         (0x1UL << EXTI_EMR2_EM43_Pos)               /*!< 0x00000800 */
#define EXTI_EMR2_EM43             EXTI_EMR2_EM43_Msk                          /*!< Event Mask on line 43 */
#define EXTI_EMR2_EM47_Pos         (15U)
#define EXTI_EMR2_EM47_Msk         (0x1UL << EXTI_EMR2_EM47_Pos)               /*!< 0x00008000 */
#define EXTI_EMR2_EM47             EXTI_EMR2_EM47_Msk                          /*!< Event Mask on line 47 */
#define EXTI_EMR2_EM48_Pos         (16U)
#define EXTI_EMR2_EM48_Msk         (0x1UL << EXTI_EMR2_EM48_Pos)               /*!< 0x00010000 */
#define EXTI_EMR2_EM48             EXTI_EMR2_EM48_Msk                          /*!< Event Mask on line 48 */
#define EXTI_EMR2_EM49_Pos         (17U)
#define EXTI_EMR2_EM49_Msk         (0x1UL << EXTI_EMR2_EM49_Pos)               /*!< 0x00020000 */
#define EXTI_EMR2_EM49             EXTI_EMR2_EM49_Msk                          /*!< Event Mask on line 49 */
#define EXTI_EMR2_EM50_Pos         (18U)
#define EXTI_EMR2_EM50_Msk         (0x1UL << EXTI_EMR2_EM50_Pos)               /*!< 0x00040000 */
#define EXTI_EMR2_EM50             EXTI_EMR2_EM50_Msk                          /*!< Event Mask on line 50 */
#define EXTI_EMR2_EM51_Pos         (19U)
#define EXTI_EMR2_EM51_Msk         (0x1UL << EXTI_EMR2_EM51_Pos)               /*!< 0x00080000 */
#define EXTI_EMR2_EM51             EXTI_EMR2_EM51_Msk                          /*!< Event Mask on line 51 */
#define EXTI_EMR2_EM52_Pos         (20U)
#define EXTI_EMR2_EM52_Msk         (0x1UL << EXTI_EMR2_EM52_Pos)               /*!< 0x00100000 */
#define EXTI_EMR2_EM52             EXTI_EMR2_EM52_Msk                          /*!< Event Mask on line 52 */
#define EXTI_EMR2_EM53_Pos         (21U)
#define EXTI_EMR2_EM53_Msk         (0x1UL << EXTI_EMR2_EM53_Pos)               /*!< 0x00200000 */
#define EXTI_EMR2_EM53             EXTI_EMR2_EM53_Msk                          /*!< Event Mask on line 53 */
#define EXTI_EMR2_EM54_Pos         (22U)
#define EXTI_EMR2_EM54_Msk         (0x1UL << EXTI_EMR2_EM54_Pos)               /*!< 0x00400000 */
#define EXTI_EMR2_EM54             EXTI_EMR2_EM54_Msk                          /*!< Event Mask on line 54 */
#define EXTI_EMR2_EM55_Pos         (23U)
#define EXTI_EMR2_EM55_Msk         (0x1UL << EXTI_EMR2_EM55_Pos)               /*!< 0x00800000 */
#define EXTI_EMR2_EM55             EXTI_EMR2_EM55_Msk                          /*!< Event Mask on line 55 */
#define EXTI_EMR2_EM56_Pos         (24U)
#define EXTI_EMR2_EM56_Msk         (0x1UL << EXTI_EMR2_EM56_Pos)               /*!< 0x01000000 */
#define EXTI_EMR2_EM56             EXTI_EMR2_EM56_Msk                          /*!< Event Mask on line 56 */
#define EXTI_EMR2_EM58_Pos         (26U)
#define EXTI_EMR2_EM58_Msk         (0x1UL << EXTI_EMR2_EM58_Pos)               /*!< 0x04000000 */
#define EXTI_EMR2_EM58             EXTI_EMR2_EM58_Msk                          /*!< Event Mask on line 58 */
#define EXTI_EMR2_EM60_Pos         (28U)
#define EXTI_EMR2_EM60_Msk         (0x1UL << EXTI_EMR2_EM60_Pos)               /*!< 0x10000000 */
#define EXTI_EMR2_EM60             EXTI_EMR2_EM60_Msk                          /*!< Event Mask on line 60 */
#define EXTI_EMR2_EM61_Pos         (29U)
#define EXTI_EMR2_EM61_Msk         (0x1UL << EXTI_EMR2_EM61_Pos)               /*!< 0x20000000 */
#define EXTI_EMR2_EM61             EXTI_EMR2_EM61_Msk                          /*!< Event Mask on line 61 */
#define EXTI_EMR2_EM62_Pos         (30U)
#define EXTI_EMR2_EM62_Msk         (0x1UL << EXTI_EMR2_EM62_Pos)               /*!< 0x40000000 */
#define EXTI_EMR2_EM62             EXTI_EMR2_EM62_Msk                          /*!< Event Mask on line 62 */
#define EXTI_EMR2_EM63_Pos         (31U)
#define EXTI_EMR2_EM63_Msk         (0x1UL << EXTI_EMR2_EM63_Pos)               /*!< 0x80000000 */
#define EXTI_EMR2_EM63             EXTI_EMR2_EM63_Msk                          /*!< Event Mask on line 63 */

/*******************  Bit definition for EXTI_PR2 register  ********************/
#define EXTI_PR2_PR_Pos            (17U)
#define EXTI_PR2_PR_Msk            (0x5UL << EXTI_PR2_PR_Pos)                  /*!< 0x000A0000 */
#define EXTI_PR2_PR                EXTI_PR2_PR_Msk                             /*!< Pending bit */
#define EXTI_PR2_PR49_Pos          (17U)
#define EXTI_PR2_PR49_Msk          (0x1UL << EXTI_PR2_PR49_Pos)                /*!< 0x00020000 */
#define EXTI_PR2_PR49              EXTI_PR2_PR49_Msk                           /*!< Pending bit for line 49 */
#define EXTI_PR2_PR51_Pos          (19U)
#define EXTI_PR2_PR51_Msk          (0x1UL << EXTI_PR2_PR51_Pos)                /*!< 0x00080000 */
#define EXTI_PR2_PR51              EXTI_PR2_PR51_Msk                           /*!< Pending bit for line 51 */

/*******************  Bit definition for EXTI_IMR3 register  *******************/
#define EXTI_IMR3_IM_Pos           (0U)
#define EXTI_IMR3_IM_Msk           (0x0FE17FFFUL << EXTI_IMR3_IM_Pos)          /*!< 0x0FE17FFF */
#define EXTI_IMR3_IM               EXTI_IMR3_IM_Msk                            /*!< Interrupt Mask            */
#define EXTI_IMR3_IM64_Pos         (0U)
#define EXTI_IMR3_IM64_Msk         (0x1UL << EXTI_IMR3_IM64_Pos)               /*!< 0x00000001 */
#define EXTI_IMR3_IM64             EXTI_IMR3_IM64_Msk                          /*!< Interrupt Mask on line 64 */
#define EXTI_IMR3_IM65_Pos         (1U)
#define EXTI_IMR3_IM65_Msk         (0x1UL << EXTI_IMR3_IM65_Pos)               /*!< 0x00000002 */
#define EXTI_IMR3_IM65             EXTI_IMR3_IM65_Msk                          /*!< Interrupt Mask on line 65 */
#define EXTI_IMR3_IM66_Pos         (2U)
#define EXTI_IMR3_IM66_Msk         (0x1UL << EXTI_IMR3_IM66_Pos)               /*!< 0x00000004 */
#define EXTI_IMR3_IM66             EXTI_IMR3_IM66_Msk                          /*!< Interrupt Mask on line 66 */
#define EXTI_IMR3_IM67_Pos         (3U)
#define EXTI_IMR3_IM67_Msk         (0x1UL << EXTI_IMR3_IM67_Pos)               /*!< 0x00000008 */
#define EXTI_IMR3_IM67             EXTI_IMR3_IM67_Msk                          /*!< Interrupt Mask on line 67 */
#define EXTI_IMR3_IM68_Pos         (4U)
#define EXTI_IMR3_IM68_Msk         (0x1UL << EXTI_IMR3_IM68_Pos)               /*!< 0x00000010 */
#define EXTI_IMR3_IM68             EXTI_IMR3_IM68_Msk                          /*!< Interrupt Mask on line 68 */
#define EXTI_IMR3_IM69_Pos         (5U)
#define EXTI_IMR3_IM69_Msk         (0x1UL << EXTI_IMR3_IM69_Pos)               /*!< 0x00000020 */
#define EXTI_IMR3_IM69             EXTI_IMR3_IM69_Msk                          /*!< Interrupt Mask on line 69 */
#define EXTI_IMR3_IM70_Pos         (6U)
#define EXTI_IMR3_IM70_Msk         (0x1UL << EXTI_IMR3_IM70_Pos)               /*!< 0x00000040 */
#define EXTI_IMR3_IM70             EXTI_IMR3_IM70_Msk                          /*!< Interrupt Mask on line 70 */
#define EXTI_IMR3_IM71_Pos         (7U)
#define EXTI_IMR3_IM71_Msk         (0x1UL << EXTI_IMR3_IM71_Pos)               /*!< 0x00000080 */
#define EXTI_IMR3_IM71             EXTI_IMR3_IM71_Msk                          /*!< Interrupt Mask on line 71 */
#define EXTI_IMR3_IM72_Pos         (8U)
#define EXTI_IMR3_IM72_Msk         (0x1UL << EXTI_IMR3_IM72_Pos)               /*!< 0x00000100 */
#define EXTI_IMR3_IM72             EXTI_IMR3_IM72_Msk                          /*!< Interrupt Mask on line 72 */
#define EXTI_IMR3_IM73_Pos         (9U)
#define EXTI_IMR3_IM73_Msk         (0x1UL << EXTI_IMR3_IM73_Pos)               /*!< 0x00000200 */
#define EXTI_IMR3_IM73             EXTI_IMR3_IM73_Msk                          /*!< Interrupt Mask on line 73 */
#define EXTI_IMR3_IM74_Pos         (10U)
#define EXTI_IMR3_IM74_Msk         (0x1UL << EXTI_IMR3_IM74_Pos)               /*!< 0x00000400 */
#define EXTI_IMR3_IM74             EXTI_IMR3_IM74_Msk                          /*!< Interrupt Mask on line 74 */
#define EXTI_IMR3_IM75_Pos         (11U)
#define EXTI_IMR3_IM75_Msk         (0x1UL << EXTI_IMR3_IM75_Pos)               /*!< 0x00000800 */
#define EXTI_IMR3_IM75             EXTI_IMR3_IM75_Msk                          /*!< Interrupt Mask on line 75 */
#define EXTI_IMR3_IM76_Pos         (12U)
#define EXTI_IMR3_IM76_Msk         (0x1UL << EXTI_IMR3_IM76_Pos)               /*!< 0x00001000 */
#define EXTI_IMR3_IM76             EXTI_IMR3_IM76_Msk                          /*!< Interrupt Mask on line 76 */
#define EXTI_IMR3_IM77_Pos         (13U)
#define EXTI_IMR3_IM77_Msk         (0x1UL << EXTI_IMR3_IM77_Pos)               /*!< 0x00002000 */
#define EXTI_IMR3_IM77             EXTI_IMR3_IM77_Msk                          /*!< Interrupt Mask on line 77 */
#define EXTI_IMR3_IM78_Pos         (14U)
#define EXTI_IMR3_IM78_Msk         (0x1UL << EXTI_IMR3_IM78_Pos)               /*!< 0x00004000 */
#define EXTI_IMR3_IM78             EXTI_IMR3_IM78_Msk                          /*!< Interrupt Mask on line 78 */
#define EXTI_IMR3_IM80_Pos         (16U)
#define EXTI_IMR3_IM80_Msk         (0x1UL << EXTI_IMR3_IM80_Pos)               /*!< 0x00010000 */
#define EXTI_IMR3_IM80             EXTI_IMR3_IM80_Msk                          /*!< Interrupt Mask on line 80 */
#define EXTI_IMR3_IM85_Pos         (21U)
#define EXTI_IMR3_IM85_Msk         (0x1UL << EXTI_IMR3_IM85_Pos)               /*!< 0x00200000 */
#define EXTI_IMR3_IM85             EXTI_IMR3_IM85_Msk                          /*!< Interrupt Mask on line 85 */
#define EXTI_IMR3_IM86_Pos         (22U)
#define EXTI_IMR3_IM86_Msk         (0x1UL << EXTI_IMR3_IM86_Pos)               /*!< 0x00400000 */
#define EXTI_IMR3_IM86             EXTI_IMR3_IM86_Msk                          /*!< Interrupt Mask on line 86 */
#define EXTI_IMR3_IM87_Pos         (23U)
#define EXTI_IMR3_IM87_Msk         (0x1UL << EXTI_IMR3_IM87_Pos)               /*!< 0x00800000 */
#define EXTI_IMR3_IM87             EXTI_IMR3_IM87_Msk                          /*!< Interrupt Mask on line 87 */


#define EXTI_IMR3_IM88_Pos         (24U)
#define EXTI_IMR3_IM88_Msk         (0x1UL << EXTI_IMR3_IM88_Pos)               /*!< 0x01000000 */
#define EXTI_IMR3_IM88             EXTI_IMR3_IM88_Msk                          /*!< Interrupt Mask on line 88 */

#define EXTI_IMR3_IM89_Pos         (25U)
#define EXTI_IMR3_IM89_Msk         (0x1UL << EXTI_IMR3_IM89_Pos)               /*!< 0x0200000 */
#define EXTI_IMR3_IM89             EXTI_IMR3_IM89_Msk                          /*!< Interrupt Mask on line 89 */
#define EXTI_IMR3_IM90_Pos         (26U)
#define EXTI_IMR3_IM90_Msk         (0x1UL << EXTI_IMR3_IM90_Pos)               /*!< 0x0400000 */
#define EXTI_IMR3_IM90             EXTI_IMR3_IM90_Msk                          /*!< Interrupt Mask on line 90 */
#define EXTI_IMR3_IM91_Pos         (27U)
#define EXTI_IMR3_IM91_Msk         (0x1UL << EXTI_IMR3_IM91_Pos)               /*!< 0x0800000 */
#define EXTI_IMR3_IM91             EXTI_IMR3_IM91_Msk                          /*!< Interrupt Mask on line 91 */

/*******************  Bit definition for EXTI_EMR3 register  *******************/
#define EXTI_EMR3_EM_Pos           (0U)
#define EXTI_EMR3_EM_Msk           (0x0FE17FFFUL << EXTI_EMR3_EM_Pos)          /*!< 0x0FE17FFF */
#define EXTI_EMR3_EM               EXTI_EMR3_EM_Msk                            /*!< Interrupt Mask            */
#define EXTI_EMR3_EM64_Pos         (0U)
#define EXTI_EMR3_EM64_Msk         (0x1UL << EXTI_EMR3_EM64_Pos)               /*!< 0x00000001 */
#define EXTI_EMR3_EM64             EXTI_EMR3_EM64_Msk                          /*!< Event Mask on line 64*/
#define EXTI_EMR3_EM65_Pos         (1U)
#define EXTI_EMR3_EM65_Msk         (0x1UL << EXTI_EMR3_EM65_Pos)               /*!< 0x00000002 */
#define EXTI_EMR3_EM65             EXTI_EMR3_EM65_Msk                          /*!< Event Mask on line 65*/
#define EXTI_EMR3_EM66_Pos         (2U)
#define EXTI_EMR3_EM66_Msk         (0x1UL << EXTI_EMR3_EM66_Pos)               /*!< 0x00000004 */
#define EXTI_EMR3_EM66             EXTI_EMR3_EM66_Msk                          /*!< Event Mask on line 66*/
#define EXTI_EMR3_EM67_Pos         (3U)
#define EXTI_EMR3_EM67_Msk         (0x1UL << EXTI_EMR3_EM67_Pos)               /*!< 0x00000008 */
#define EXTI_EMR3_EM67             EXTI_EMR3_EM67_Msk                          /*!< Event Mask on line 67*/
#define EXTI_EMR3_EM68_Pos         (4U)
#define EXTI_EMR3_EM68_Msk         (0x1UL << EXTI_EMR3_EM68_Pos)               /*!< 0x00000010 */
#define EXTI_EMR3_EM68             EXTI_EMR3_EM68_Msk                          /*!< Event Mask on line 68*/
#define EXTI_EMR3_EM69_Pos         (5U)
#define EXTI_EMR3_EM69_Msk         (0x1UL << EXTI_EMR3_EM69_Pos)               /*!< 0x00000020 */
#define EXTI_EMR3_EM69             EXTI_EMR3_EM69_Msk                          /*!< Event Mask on line 69*/
#define EXTI_EMR3_EM70_Pos         (6U)
#define EXTI_EMR3_EM70_Msk         (0x1UL << EXTI_EMR3_EM70_Pos)               /*!< 0x00000040 */
#define EXTI_EMR3_EM70             EXTI_EMR3_EM70_Msk                          /*!< Event Mask on line 70*/
#define EXTI_EMR3_EM71_Pos         (7U)
#define EXTI_EMR3_EM71_Msk         (0x1UL << EXTI_EMR3_EM71_Pos)               /*!< 0x00000080 */
#define EXTI_EMR3_EM71             EXTI_EMR3_EM71_Msk                          /*!< Event Mask on line 71*/
#define EXTI_EMR3_EM72_Pos         (8U)
#define EXTI_EMR3_EM72_Msk         (0x1UL << EXTI_EMR3_EM72_Pos)               /*!< 0x00000100 */
#define EXTI_EMR3_EM72             EXTI_EMR3_EM72_Msk                          /*!< Event Mask on line 72*/
#define EXTI_EMR3_EM73_Pos         (9U)
#define EXTI_EMR3_EM73_Msk         (0x1UL << EXTI_EMR3_EM73_Pos)               /*!< 0x00000200 */
#define EXTI_EMR3_EM73             EXTI_EMR3_EM73_Msk                          /*!< Event Mask on line 73*/
#define EXTI_EMR3_EM74_Pos         (10U)
#define EXTI_EMR3_EM74_Msk         (0x1UL << EXTI_EMR3_EM74_Pos)               /*!< 0x00000400 */
#define EXTI_EMR3_EM74             EXTI_EMR3_EM74_Msk                          /*!< Event Mask on line 74 */
#define EXTI_EMR3_EM75_Pos         (11U)
#define EXTI_EMR3_EM75_Msk         (0x1UL << EXTI_EMR3_EM75_Pos)               /*!< 0x00000800 */
#define EXTI_EMR3_EM75             EXTI_EMR3_EM75_Msk                          /*!< Event Mask on line 75 */
#define EXTI_EMR3_EM76_Pos         (12U)
#define EXTI_EMR3_EM76_Msk         (0x1UL << EXTI_EMR3_EM76_Pos)               /*!< 0x00001000 */
#define EXTI_EMR3_EM76             EXTI_EMR3_EM76_Msk                          /*!< Event Mask on line 76 */
#define EXTI_EMR3_EM77_Pos         (13U)
#define EXTI_EMR3_EM77_Msk         (0x1UL << EXTI_EMR3_EM77_Pos)               /*!< 0x00002000 */
#define EXTI_EMR3_EM77             EXTI_EMR3_EM77_Msk                          /*!< Event Mask on line 77 */
#define EXTI_EMR3_EM78_Pos         (14U)
#define EXTI_EMR3_EM78_Msk         (0x1UL << EXTI_EMR3_EM78_Pos)               /*!< 0x00004000 */
#define EXTI_EMR3_EM78             EXTI_EMR3_EM78_Msk                          /*!< Event Mask on line 78 */
#define EXTI_EMR3_EM80_Pos         (16U)
#define EXTI_EMR3_EM80_Msk         (0x1UL << EXTI_EMR3_EM80_Pos)               /*!< 0x00010000 */
#define EXTI_EMR3_EM80             EXTI_EMR3_EM80_Msk                          /*!< Event Mask on line 80 */
#define EXTI_EMR3_EM85_Pos         (21U)
#define EXTI_EMR3_EM85_Msk         (0x1UL << EXTI_EMR3_EM85_Pos)               /*!< 0x00200000 */
#define EXTI_EMR3_EM85             EXTI_EMR3_EM85_Msk                          /*!< Event Mask on line 85 */
#define EXTI_EMR3_EM86_Pos         (22U)
#define EXTI_EMR3_EM86_Msk         (0x1UL << EXTI_EMR3_EM86_Pos)               /*!< 0x00400000 */
#define EXTI_EMR3_EM86             EXTI_EMR3_EM86_Msk                          /*!< Event Mask on line 86 */
#define EXTI_EMR3_EM87_Pos         (23U)
#define EXTI_EMR3_EM87_Msk         (0x1UL << EXTI_EMR3_EM87_Pos)               /*!< 0x00800000 */
#define EXTI_EMR3_EM87             EXTI_EMR3_EM87_Msk                          /*!< Event Mask on line 87 */

#define EXTI_EMR3_EM88_Pos         (24U)
#define EXTI_EMR3_EM88_Msk         (0x1UL << EXTI_EMR3_EM88_Pos)               /*!< 0x01000000 */
#define EXTI_EMR3_EM88             EXTI_EMR3_EM88_Msk                          /*!< Event Mask on line 88 */

#define EXTI_EMR3_EM89_Pos         (25U)
#define EXTI_EMR3_EM89_Msk         (0x1UL << EXTI_EMR3_EM89_Pos)               /*!< 0x0200000 */
#define EXTI_EMR3_EM89             EXTI_EMR3_EM89_Msk                          /*!< Interrupt Mask on line 89 */
#define EXTI_EMR3_EM90_Pos         (26U)
#define EXTI_EMR3_EM90_Msk         (0x1UL << EXTI_EMR3_EM90_Pos)               /*!< 0x0400000 */
#define EXTI_EMR3_EM90             EXTI_EMR3_EM90_Msk                          /*!< Interrupt Mask on line 90 */
#define EXTI_EMR3_EM91_Pos         (27U)
#define EXTI_EMR3_EM91_Msk         (0x1UL << EXTI_EMR3_EM91_Pos)               /*!< 0x0800000 */
#define EXTI_EMR3_EM91             EXTI_EMR3_EM91_Msk                          /*!< Interrupt Mask on line 91 */

/*******************  Bit definition for EXTI_PR3 register  ********************/
#define EXTI_PR3_PR_Pos            (20U)
#define EXTI_PR3_PR_Msk            (0x7UL << EXTI_PR3_PR_Pos)                  /*!< 0x00700000 */
#define EXTI_PR3_PR                EXTI_PR3_PR_Msk                             /*!< Pending bit             */
#define EXTI_PR3_PR84_Pos          (20U)
#define EXTI_PR3_PR84_Msk          (0x1UL << EXTI_PR3_PR84_Pos)                /*!< 0x00100000 */
#define EXTI_PR3_PR84              EXTI_PR3_PR84_Msk                           /*!< Pending bit for line 84 */
#define EXTI_PR3_PR85_Pos          (21U)
#define EXTI_PR3_PR85_Msk          (0x1UL << EXTI_PR3_PR85_Pos)                /*!< 0x00200000 */
#define EXTI_PR3_PR85              EXTI_PR3_PR85_Msk                           /*!< Pending bit for line 85 */
#define EXTI_PR3_PR86_Pos          (22U)
#define EXTI_PR3_PR86_Msk          (0x1UL << EXTI_PR3_PR86_Pos)                /*!< 0x00400000 */
#define EXTI_PR3_PR86              EXTI_PR3_PR86_Msk                           /*!< Pending bit for line 86 */
/******************************************************************************/
/*                                                                            */
/*                                    FLASH                                   */
/*                                                                            */
/******************************************************************************/
/*
* @brief FLASH Global Defines
*/
#define FLASH_SECTOR_TOTAL                   8U                    /* 8 sectors */
#define FLASH_SIZE                           0x00100000UL          /* 1 MB   */
#define FLASH_BANK_SIZE                      FLASH_SIZE            /* 1 MB   */
#define FLASH_SECTOR_SIZE                    0x00020000UL          /* 128 KB */
#define FLASH_LATENCY_DEFAULT                FLASH_ACR_LATENCY_7WS /* FLASH Seven Latency cycles */
#define FLASH_NB_32BITWORD_IN_FLASHWORD      8U                    /* 256 bits */

/*******************  Bits definition for FLASH_ACR register  **********************/
#define FLASH_ACR_LATENCY_Pos                (0U)
#define FLASH_ACR_LATENCY_Msk                (0xFUL << FLASH_ACR_LATENCY_Pos)  /*!< 0x0000000F */
#define FLASH_ACR_LATENCY                    FLASH_ACR_LATENCY_Msk             /*!< Read Latency */
#define FLASH_ACR_LATENCY_0WS                (0x00000000UL)
#define FLASH_ACR_LATENCY_1WS                (0x00000001UL)
#define FLASH_ACR_LATENCY_2WS                (0x00000002UL)
#define FLASH_ACR_LATENCY_3WS                (0x00000003UL)
#define FLASH_ACR_LATENCY_4WS                (0x00000004UL)
#define FLASH_ACR_LATENCY_5WS                (0x00000005UL)
#define FLASH_ACR_LATENCY_6WS                (0x00000006UL)
#define FLASH_ACR_LATENCY_7WS                (0x00000007UL)
#define FLASH_ACR_LATENCY_8WS                (0x00000008UL)
#define FLASH_ACR_LATENCY_9WS                (0x00000009UL)
#define FLASH_ACR_LATENCY_10WS               (0x0000000AUL)
#define FLASH_ACR_LATENCY_11WS               (0x0000000BUL)
#define FLASH_ACR_LATENCY_12WS               (0x0000000CUL)
#define FLASH_ACR_LATENCY_13WS               (0x0000000DUL)
#define FLASH_ACR_LATENCY_14WS               (0x0000000EUL)
#define FLASH_ACR_LATENCY_15WS               (0x0000000FUL)
#define FLASH_ACR_WRHIGHFREQ_Pos             (4U)
#define FLASH_ACR_WRHIGHFREQ_Msk             (0x3UL << FLASH_ACR_WRHIGHFREQ_Pos)  /*!< 0x00000030 */
#define FLASH_ACR_WRHIGHFREQ                 FLASH_ACR_WRHIGHFREQ_Msk             /*!< Flash signal delay */
#define FLASH_ACR_WRHIGHFREQ_0               (0x1UL << FLASH_ACR_WRHIGHFREQ_Pos)  /*!< 0x00000010 */
#define FLASH_ACR_WRHIGHFREQ_1               (0x2UL << FLASH_ACR_WRHIGHFREQ_Pos)  /*!< 0x00000020 */

/*******************  Bits definition for FLASH_CR register  ***********************/
#define FLASH_CR_LOCK_Pos                    (0U)
#define FLASH_CR_LOCK_Msk                    (0x1UL << FLASH_CR_LOCK_Pos)      /*!< 0x00000001 */
#define FLASH_CR_LOCK                        FLASH_CR_LOCK_Msk                 /*!< Configuration lock bit */
#define FLASH_CR_PG_Pos                      (1U)
#define FLASH_CR_PG_Msk                      (0x1UL << FLASH_CR_PG_Pos)        /*!< 0x00000002 */
#define FLASH_CR_PG                          FLASH_CR_PG_Msk                   /*!< Internal buffer control bit */
#define FLASH_CR_SER_Pos                     (2U)
#define FLASH_CR_SER_Msk                     (0x1UL << FLASH_CR_SER_Pos)       /*!< 0x00000004 */
#define FLASH_CR_SER                         FLASH_CR_SER_Msk                  /*!< Sector erase request */
#define FLASH_CR_BER_Pos                     (3U)
#define FLASH_CR_BER_Msk                     (0x1UL << FLASH_CR_BER_Pos)       /*!< 0x00000008 */
#define FLASH_CR_BER                         FLASH_CR_BER_Msk                  /*!< Bank erase request */
#define FLASH_CR_PSIZE_Pos                   (4U)
#define FLASH_CR_PSIZE_Msk                   (0x3UL << FLASH_CR_PSIZE_Pos)     /*!< 0x00000030 */
#define FLASH_CR_PSIZE                       FLASH_CR_PSIZE_Msk                /*!< Program size */
#define FLASH_CR_PSIZE_0                     (0x1UL << FLASH_CR_PSIZE_Pos)     /*!< 0x00000010 */
#define FLASH_CR_PSIZE_1                     (0x2UL << FLASH_CR_PSIZE_Pos)     /*!< 0x00000020 */
#define FLASH_CR_FW_Pos                      (6U)
#define FLASH_CR_FW_Msk                      (0x1UL << FLASH_CR_FW_Pos)        /*!< 0x00000040 */
#define FLASH_CR_FW                          FLASH_CR_FW_Msk                   /*!< Write forcing control bit */
#define FLASH_CR_START_Pos                   (7U)
#define FLASH_CR_START_Msk                   (0x1UL << FLASH_CR_START_Pos)     /*!< 0x00000080 */
#define FLASH_CR_START                       FLASH_CR_START_Msk                /*!< Erase start control bit */
#define FLASH_CR_SNB_Pos                     (8U)
#define FLASH_CR_SNB_Msk                     (0x7UL << FLASH_CR_SNB_Pos)       /*!< 0x00000700 */
#define FLASH_CR_SNB                         FLASH_CR_SNB_Msk                  /*!< Sector erase selection number */
#define FLASH_CR_SNB_0                       (0x1UL << FLASH_CR_SNB_Pos)       /*!< 0x00000100 */
#define FLASH_CR_SNB_1                       (0x2UL << FLASH_CR_SNB_Pos)       /*!< 0x00000200 */
#define FLASH_CR_SNB_2                       (0x4UL << FLASH_CR_SNB_Pos)       /*!< 0x00000400 */
#define FLASH_CR_CRC_EN_Pos                  (15U)
#define FLASH_CR_CRC_EN_Msk                  (0x1UL << FLASH_CR_CRC_EN_Pos)    /*!< 0x00008000 */
#define FLASH_CR_CRC_EN                      FLASH_CR_CRC_EN_Msk               /*!< CRC control bit */
#define FLASH_CR_EOPIE_Pos                   (16U)
#define FLASH_CR_EOPIE_Msk                   (0x1UL << FLASH_CR_EOPIE_Pos)     /*!< 0x00010000 */
#define FLASH_CR_EOPIE                       FLASH_CR_EOPIE_Msk                /*!< End-of-program interrupt control bit */
#define FLASH_CR_WRPERRIE_Pos                (17U)
#define FLASH_CR_WRPERRIE_Msk                (0x1UL << FLASH_CR_WRPERRIE_Pos)  /*!< 0x00020000 */
#define FLASH_CR_WRPERRIE                    FLASH_CR_WRPERRIE_Msk             /*!< Write protection error interrupt enable bit */
#define FLASH_CR_PGSERRIE_Pos                (18U)
#define FLASH_CR_PGSERRIE_Msk                (0x1UL << FLASH_CR_PGSERRIE_Pos)  /*!< 0x00040000 */
#define FLASH_CR_PGSERRIE                    FLASH_CR_PGSERRIE_Msk             /*!< Programming sequence error interrupt enable bit */
#define FLASH_CR_STRBERRIE_Pos               (19U)
#define FLASH_CR_STRBERRIE_Msk               (0x1UL << FLASH_CR_STRBERRIE_Pos) /*!< 0x00080000 */
#define FLASH_CR_STRBERRIE                   FLASH_CR_STRBERRIE_Msk            /*!< Strobe error interrupt enable bit */
#define FLASH_CR_INCERRIE_Pos                (21U)
#define FLASH_CR_INCERRIE_Msk                (0x1UL << FLASH_CR_INCERRIE_Pos)  /*!< 0x00200000 */
#define FLASH_CR_INCERRIE                    FLASH_CR_INCERRIE_Msk             /*!< Inconsistency error interrupt enable bit */
#define FLASH_CR_OPERRIE_Pos                 (22U)
#define FLASH_CR_OPERRIE_Msk                 (0x1UL << FLASH_CR_OPERRIE_Pos)   /*!< 0x00400000 */
#define FLASH_CR_OPERRIE                     FLASH_CR_OPERRIE_Msk              /*!< Write/erase error interrupt enable bit */
#define FLASH_CR_RDPERRIE_Pos                (23U)
#define FLASH_CR_RDPERRIE_Msk                (0x1UL << FLASH_CR_RDPERRIE_Pos)  /*!< 0x00800000 */
#define FLASH_CR_RDPERRIE                    FLASH_CR_RDPERRIE_Msk             /*!< Read protection error interrupt enable bit */
#define FLASH_CR_RDSERRIE_Pos                (24U)
#define FLASH_CR_RDSERRIE_Msk                (0x1UL << FLASH_CR_RDSERRIE_Pos)  /*!< 0x01000000 */
#define FLASH_CR_RDSERRIE                    FLASH_CR_RDSERRIE_Msk             /*!< Secure error interrupt enable bit */
#define FLASH_CR_SNECCERRIE_Pos              (25U)
#define FLASH_CR_SNECCERRIE_Msk              (0x1UL << FLASH_CR_SNECCERRIE_Pos) /*!< 0x02000000 */
#define FLASH_CR_SNECCERRIE                  FLASH_CR_SNECCERRIE_Msk            /*!< ECC single correction error interrupt enable bit */
#define FLASH_CR_DBECCERRIE_Pos              (26U)
#define FLASH_CR_DBECCERRIE_Msk              (0x1UL << FLASH_CR_DBECCERRIE_Pos) /*!< 0x04000000 */
#define FLASH_CR_DBECCERRIE                  FLASH_CR_DBECCERRIE_Msk            /*!< ECC double detection error interrupt enable bit */
#define FLASH_CR_CRCENDIE_Pos                (27U)
#define FLASH_CR_CRCENDIE_Msk                (0x1UL << FLASH_CR_CRCENDIE_Pos)  /*!< 0x08000000 */
#define FLASH_CR_CRCENDIE                    FLASH_CR_CRCENDIE_Msk             /*!< CRC end of calculation interrupt enable bit */
#define FLASH_CR_CRCRDERRIE_Pos              (28U)
#define FLASH_CR_CRCRDERRIE_Msk              (0x1UL << FLASH_CR_CRCRDERRIE_Pos) /*!< 0x10000000 */
#define FLASH_CR_CRCRDERRIE                  FLASH_CR_CRCRDERRIE_Msk            /*!< CRC read error interrupt enable bit */

/*******************  Bits definition for FLASH_SR register  ***********************/
#define FLASH_SR_BSY_Pos                     (0U)
#define FLASH_SR_BSY_Msk                     (0x1UL << FLASH_SR_BSY_Pos)       /*!< 0x00000001 */
#define FLASH_SR_BSY                         FLASH_SR_BSY_Msk                  /*!< Busy flag */
#define FLASH_SR_WBNE_Pos                    (1U)
#define FLASH_SR_WBNE_Msk                    (0x1UL << FLASH_SR_WBNE_Pos)      /*!< 0x00000002 */
#define FLASH_SR_WBNE                        FLASH_SR_WBNE_Msk                 /*!< Write buffer not empty flag */
#define FLASH_SR_QW_Pos                      (2U)
#define FLASH_SR_QW_Msk                      (0x1UL << FLASH_SR_QW_Pos)        /*!< 0x00000004 */
#define FLASH_SR_QW                          FLASH_SR_QW_Msk                   /*!< Wait queue flag */
#define FLASH_SR_CRC_BUSY_Pos                (3U)
#define FLASH_SR_CRC_BUSY_Msk                (0x1UL << FLASH_SR_CRC_BUSY_Pos)  /*!< 0x00000008 */
#define FLASH_SR_CRC_BUSY                    FLASH_SR_CRC_BUSY_Msk             /*!< CRC busy flag */
#define FLASH_SR_EOP_Pos                     (16U)
#define FLASH_SR_EOP_Msk                     (0x1UL << FLASH_SR_EOP_Pos)       /*!< 0x00010000 */
#define FLASH_SR_EOP                         FLASH_SR_EOP_Msk                  /*!< End-of-program flag */
#define FLASH_SR_WRPERR_Pos                  (17U)
#define FLASH_SR_WRPERR_Msk                  (0x1UL << FLASH_SR_WRPERR_Pos)    /*!< 0x00020000 */
#define FLASH_SR_WRPERR                      FLASH_SR_WRPERR_Msk               /*!< Write protection error flag */
#define FLASH_SR_PGSERR_Pos                  (18U)
#define FLASH_SR_PGSERR_Msk                  (0x1UL << FLASH_SR_PGSERR_Pos)    /*!< 0x00040000 */
#define FLASH_SR_PGSERR                      FLASH_SR_PGSERR_Msk               /*!< Programming sequence error flag */
#define FLASH_SR_STRBERR_Pos                 (19U)
#define FLASH_SR_STRBERR_Msk                 (0x1UL << FLASH_SR_STRBERR_Pos)   /*!< 0x00080000 */
#define FLASH_SR_STRBERR                     FLASH_SR_STRBERR_Msk              /*!< Strobe error flag */
#define FLASH_SR_INCERR_Pos                  (21U)
#define FLASH_SR_INCERR_Msk                  (0x1UL << FLASH_SR_INCERR_Pos)    /*!< 0x00200000 */
#define FLASH_SR_INCERR                      FLASH_SR_INCERR_Msk               /*!< Inconsistency error flag */
#define FLASH_SR_OPERR_Pos                   (22U)
#define FLASH_SR_OPERR_Msk                   (0x1UL << FLASH_SR_OPERR_Pos)     /*!< 0x00400000 */
#define FLASH_SR_OPERR                       FLASH_SR_OPERR_Msk                /*!< Write/erase error flag */
#define FLASH_SR_RDPERR_Pos                  (23U)
#define FLASH_SR_RDPERR_Msk                  (0x1UL << FLASH_SR_RDPERR_Pos)    /*!< 0x00800000 */
#define FLASH_SR_RDPERR                      FLASH_SR_RDPERR_Msk               /*!< Read protection error flag */
#define FLASH_SR_RDSERR_Pos                  (24U)
#define FLASH_SR_RDSERR_Msk                  (0x1UL << FLASH_SR_RDSERR_Pos)    /*!< 0x01000000 */
#define FLASH_SR_RDSERR                      FLASH_SR_RDSERR_Msk               /*!< Secure error flag */
#define FLASH_SR_SNECCERR_Pos                (25U)
#define FLASH_SR_SNECCERR_Msk                (0x1UL << FLASH_SR_SNECCERR_Pos)  /*!< 0x02000000 */
#define FLASH_SR_SNECCERR                    FLASH_SR_SNECCERR_Msk             /*!< Single correction error flag */
#define FLASH_SR_DBECCERR_Pos                (26U)
#define FLASH_SR_DBECCERR_Msk                (0x1UL << FLASH_SR_DBECCERR_Pos)  /*!< 0x04000000 */
#define FLASH_SR_DBECCERR                    FLASH_SR_DBECCERR_Msk             /*!< ECC double detection error flag */
#define FLASH_SR_CRCEND_Pos                  (27U)
#define FLASH_SR_CRCEND_Msk                  (0x1UL << FLASH_SR_CRCEND_Pos)    /*!< 0x08000000 */
#define FLASH_SR_CRCEND                      FLASH_SR_CRCEND_Msk               /*!< CRC end of calculation flag */
#define FLASH_SR_CRCRDERR_Pos                (28U)
#define FLASH_SR_CRCRDERR_Msk                (0x1UL << FLASH_SR_CRCRDERR_Pos)  /*!< 0x10000000 */
#define FLASH_SR_CRCRDERR                    FLASH_SR_CRCRDERR_Msk             /*!< CRC read error flag */

/*******************  Bits definition for FLASH_CCR register  *******************/
#define FLASH_CCR_CLR_EOP_Pos                (16U)
#define FLASH_CCR_CLR_EOP_Msk                (0x1UL << FLASH_CCR_CLR_EOP_Pos)  /*!< 0x00010000 */
#define FLASH_CCR_CLR_EOP                    FLASH_CCR_CLR_EOP_Msk             /*!< EOP flag clear bit */
#define FLASH_CCR_CLR_WRPERR_Pos             (17U)
#define FLASH_CCR_CLR_WRPERR_Msk             (0x1UL << FLASH_CCR_CLR_WRPERR_Pos) /*!< 0x00020000 */
#define FLASH_CCR_CLR_WRPERR                 FLASH_CCR_CLR_WRPERR_Msk            /*!< WRPERR flag clear bit */
#define FLASH_CCR_CLR_PGSERR_Pos             (18U)
#define FLASH_CCR_CLR_PGSERR_Msk             (0x1UL << FLASH_CCR_CLR_PGSERR_Pos) /*!< 0x00040000 */
#define FLASH_CCR_CLR_PGSERR                 FLASH_CCR_CLR_PGSERR_Msk            /*!< PGSERR flag clear bit */
#define FLASH_CCR_CLR_STRBERR_Pos            (19U)
#define FLASH_CCR_CLR_STRBERR_Msk            (0x1UL << FLASH_CCR_CLR_STRBERR_Pos) /*!< 0x00080000 */
#define FLASH_CCR_CLR_STRBERR                FLASH_CCR_CLR_STRBERR_Msk            /*!< STRBERR flag clear bit */
#define FLASH_CCR_CLR_INCERR_Pos             (21U)
#define FLASH_CCR_CLR_INCERR_Msk             (0x1UL << FLASH_CCR_CLR_INCERR_Pos) /*!< 0x00200000 */
#define FLASH_CCR_CLR_INCERR                 FLASH_CCR_CLR_INCERR_Msk            /*!< INCERR flag clear bit */
#define FLASH_CCR_CLR_OPERR_Pos              (22U)
#define FLASH_CCR_CLR_OPERR_Msk              (0x1UL << FLASH_CCR_CLR_OPERR_Pos) /*!< 0x00400000 */
#define FLASH_CCR_CLR_OPERR                  FLASH_CCR_CLR_OPERR_Msk            /*!< OPERR flag clear bit */
#define FLASH_CCR_CLR_RDPERR_Pos             (23U)
#define FLASH_CCR_CLR_RDPERR_Msk             (0x1UL << FLASH_CCR_CLR_RDPERR_Pos) /*!< 0x00800000 */
#define FLASH_CCR_CLR_RDPERR                 FLASH_CCR_CLR_RDPERR_Msk            /*!< RDPERR flag clear bit */
#define FLASH_CCR_CLR_RDSERR_Pos             (24U)
#define FLASH_CCR_CLR_RDSERR_Msk             (0x1UL << FLASH_CCR_CLR_RDSERR_Pos) /*!< 0x01000000 */
#define FLASH_CCR_CLR_RDSERR                 FLASH_CCR_CLR_RDSERR_Msk            /*!< RDSERR flag clear bit */
#define FLASH_CCR_CLR_SNECCERR_Pos           (25U)
#define FLASH_CCR_CLR_SNECCERR_Msk           (0x1UL << FLASH_CCR_CLR_SNECCERR_Pos) /*!< 0x02000000 */
#define FLASH_CCR_CLR_SNECCERR               FLASH_CCR_CLR_SNECCERR_Msk            /*!< SNECCERR flag clear bit */
#define FLASH_CCR_CLR_DBECCERR_Pos           (26U)
#define FLASH_CCR_CLR_DBECCERR_Msk           (0x1UL << FLASH_CCR_CLR_DBECCERR_Pos) /*!< 0x04000000 */
#define FLASH_CCR_CLR_DBECCERR               FLASH_CCR_CLR_DBECCERR_Msk            /*!< DBECCERR flag clear bit */
#define FLASH_CCR_CLR_CRCEND_Pos             (27U)
#define FLASH_CCR_CLR_CRCEND_Msk             (0x1UL << FLASH_CCR_CLR_CRCEND_Pos) /*!< 0x08000000 */
#define FLASH_CCR_CLR_CRCEND                 FLASH_CCR_CLR_CRCEND_Msk            /*!< CRCEND flag clear bit */
#define FLASH_CCR_CLR_CRCRDERR_Pos           (28U)
#define FLASH_CCR_CLR_CRCRDERR_Msk           (0x1UL << FLASH_CCR_CLR_CRCRDERR_Pos) /*!< 0x10000000 */
#define FLASH_CCR_CLR_CRCRDERR               FLASH_CCR_CLR_CRCRDERR_Msk            /*!< CRCRDERR flag clear bit */

/*******************  Bits definition for FLASH_OPTCR register  *******************/
#define FLASH_OPTCR_OPTLOCK_Pos              (0U)
#define FLASH_OPTCR_OPTLOCK_Msk              (0x1UL << FLASH_OPTCR_OPTLOCK_Pos)  /*!< 0x00000001 */
#define FLASH_OPTCR_OPTLOCK                  FLASH_OPTCR_OPTLOCK_Msk             /*!< FLASH_OPTCR lock option configuration bit */
#define FLASH_OPTCR_OPTSTART_Pos             (1U)
#define FLASH_OPTCR_OPTSTART_Msk             (0x1UL << FLASH_OPTCR_OPTSTART_Pos) /*!< 0x00000002 */
#define FLASH_OPTCR_OPTSTART                 FLASH_OPTCR_OPTSTART_Msk            /*!< Option byte start change option configuration bit */
#define FLASH_OPTCR_OPTCHANGEERRIE_Pos       (30U)
#define FLASH_OPTCR_OPTCHANGEERRIE_Msk       (0x1UL << FLASH_OPTCR_OPTCHANGEERRIE_Pos) /*!< 0x40000000 */
#define FLASH_OPTCR_OPTCHANGEERRIE           FLASH_OPTCR_OPTCHANGEERRIE_Msk            /*!< Option byte change error interrupt enable bit */

/*******************  Bits definition for FLASH_OPTSR register  ***************/
#define FLASH_OPTSR_OPT_BUSY_Pos             (0U)
#define FLASH_OPTSR_OPT_BUSY_Msk             (0x1UL << FLASH_OPTSR_OPT_BUSY_Pos) /*!< 0x00000001 */
#define FLASH_OPTSR_OPT_BUSY                 FLASH_OPTSR_OPT_BUSY_Msk            /*!< Option byte change ongoing flag */
#define FLASH_OPTSR_BOR_LEV_Pos              (2U)
#define FLASH_OPTSR_BOR_LEV_Msk              (0x3UL << FLASH_OPTSR_BOR_LEV_Pos) /*!< 0x0000000C */
#define FLASH_OPTSR_BOR_LEV                  FLASH_OPTSR_BOR_LEV_Msk            /*!< Brownout level option status bit */
#define FLASH_OPTSR_BOR_LEV_0                (0x1UL << FLASH_OPTSR_BOR_LEV_Pos) /*!< 0x00000004 */
#define FLASH_OPTSR_BOR_LEV_1                (0x2UL << FLASH_OPTSR_BOR_LEV_Pos) /*!< 0x00000008 */
#define FLASH_OPTSR_IWDG1_SW_Pos             (4U)
#define FLASH_OPTSR_IWDG1_SW_Msk             (0x1UL << FLASH_OPTSR_IWDG1_SW_Pos) /*!< 0x00000010 */
#define FLASH_OPTSR_IWDG1_SW                 FLASH_OPTSR_IWDG1_SW_Msk            /*!< IWDG1 control mode option status bit */
#define FLASH_OPTSR_NRST_STOP_D1_Pos         (6U)
#define FLASH_OPTSR_NRST_STOP_D1_Msk         (0x1UL << FLASH_OPTSR_NRST_STOP_D1_Pos) /*!< 0x00000040 */
#define FLASH_OPTSR_NRST_STOP_D1             FLASH_OPTSR_NRST_STOP_D1_Msk            /*!< D1 domain DStop entry reset option status bit */
#define FLASH_OPTSR_NRST_STBY_D1_Pos         (7U)
#define FLASH_OPTSR_NRST_STBY_D1_Msk         (0x1UL << FLASH_OPTSR_NRST_STBY_D1_Pos) /*!< 0x00000080 */
#define FLASH_OPTSR_NRST_STBY_D1             FLASH_OPTSR_NRST_STBY_D1_Msk            /*!< D1 domain DStandby entry reset option status bit */
#define FLASH_OPTSR_RDP_Pos                  (8U)
#define FLASH_OPTSR_RDP_Msk                  (0xFFUL << FLASH_OPTSR_RDP_Pos)   /*!< 0x0000FF00 */
#define FLASH_OPTSR_RDP                      FLASH_OPTSR_RDP_Msk               /*!< Readout protection level option status byte */
#define FLASH_OPTSR_FZ_IWDG_STOP_Pos         (17U)
#define FLASH_OPTSR_FZ_IWDG_STOP_Msk         (0x1UL << FLASH_OPTSR_FZ_IWDG_STOP_Pos) /*!< 0x00020000 */
#define FLASH_OPTSR_FZ_IWDG_STOP             FLASH_OPTSR_FZ_IWDG_STOP_Msk            /*!< IWDG Stop mode freeze option status bit */
#define FLASH_OPTSR_FZ_IWDG_SDBY_Pos         (18U)
#define FLASH_OPTSR_FZ_IWDG_SDBY_Msk         (0x1UL << FLASH_OPTSR_FZ_IWDG_SDBY_Pos) /*!< 0x00040000 */
#define FLASH_OPTSR_FZ_IWDG_SDBY             FLASH_OPTSR_FZ_IWDG_SDBY_Msk            /*!< IWDG Standby mode freeze option status bit */
#define FLASH_OPTSR_ST_RAM_SIZE_Pos          (19U)
#define FLASH_OPTSR_ST_RAM_SIZE_Msk          (0x3UL << FLASH_OPTSR_ST_RAM_SIZE_Pos) /*!< 0x00180000 */
#define FLASH_OPTSR_ST_RAM_SIZE              FLASH_OPTSR_ST_RAM_SIZE_Msk            /*!< ST RAM size option status */
#define FLASH_OPTSR_ST_RAM_SIZE_0            (0x1UL << FLASH_OPTSR_ST_RAM_SIZE_Pos) /*!< 0x00080000 */
#define FLASH_OPTSR_ST_RAM_SIZE_1            (0x2UL << FLASH_OPTSR_ST_RAM_SIZE_Pos) /*!< 0x00100000 */
#define FLASH_OPTSR_SECURITY_Pos             (21U)
#define FLASH_OPTSR_SECURITY_Msk             (0x1UL << FLASH_OPTSR_SECURITY_Pos) /*!< 0x00200000 */
#define FLASH_OPTSR_SECURITY                 FLASH_OPTSR_SECURITY_Msk            /*!< Security enable option status bit */
#define FLASH_OPTSR_NRST_STOP_D2_Pos         (24U)
#define FLASH_OPTSR_NRST_STOP_D2_Msk         (0x1UL << FLASH_OPTSR_NRST_STOP_D2_Pos) /*!< 0x01000000 */
#define FLASH_OPTSR_NRST_STOP_D2             FLASH_OPTSR_NRST_STOP_D2_Msk            /*!< D2 domain DStop entry reset option status bit */
#define FLASH_OPTSR_NRST_STBY_D2_Pos         (25U)
#define FLASH_OPTSR_NRST_STBY_D2_Msk         (0x1UL << FLASH_OPTSR_NRST_STBY_D2_Pos) /*!< 0x02000000 */
#define FLASH_OPTSR_NRST_STBY_D2             FLASH_OPTSR_NRST_STBY_D2_Msk            /*!< D2 domain DStandby entry reset option status bit */
#define FLASH_OPTSR_IO_HSLV_Pos              (29U)
#define FLASH_OPTSR_IO_HSLV_Msk              (0x1UL << FLASH_OPTSR_IO_HSLV_Pos) /*!< 0x20000000 */
#define FLASH_OPTSR_IO_HSLV                  FLASH_OPTSR_IO_HSLV_Msk            /*!< I/O high-speed at low-voltage status bit */
#define FLASH_OPTSR_OPTCHANGEERR_Pos         (30U)
#define FLASH_OPTSR_OPTCHANGEERR_Msk         (0x1UL << FLASH_OPTSR_OPTCHANGEERR_Pos) /*!< 0x40000000 */
#define FLASH_OPTSR_OPTCHANGEERR             FLASH_OPTSR_OPTCHANGEERR_Msk            /*!< Option byte change error flag */

/*******************  Bits definition for FLASH_OPTCCR register  *******************/
#define FLASH_OPTCCR_CLR_OPTCHANGEERR_Pos    (30U)
#define FLASH_OPTCCR_CLR_OPTCHANGEERR_Msk    (0x1UL << FLASH_OPTCCR_CLR_OPTCHANGEERR_Pos) /*!< 0x40000000 */
#define FLASH_OPTCCR_CLR_OPTCHANGEERR        FLASH_OPTCCR_CLR_OPTCHANGEERR_Msk            /*!< OPTCHANGEERR reset bit */

/*******************  Bits definition for FLASH_PRAR register  *********************/
#define FLASH_PRAR_PROT_AREA_START_Pos       (0U)
#define FLASH_PRAR_PROT_AREA_START_Msk       (0xFFFUL << FLASH_PRAR_PROT_AREA_START_Pos) /*!< 0x00000FFF */
#define FLASH_PRAR_PROT_AREA_START           FLASH_PRAR_PROT_AREA_START_Msk              /*!< PCROP area start status bits */
#define FLASH_PRAR_PROT_AREA_END_Pos         (16U)
#define FLASH_PRAR_PROT_AREA_END_Msk         (0xFFFUL << FLASH_PRAR_PROT_AREA_END_Pos) /*!< 0x0FFF0000 */
#define FLASH_PRAR_PROT_AREA_END             FLASH_PRAR_PROT_AREA_END_Msk              /*!< PCROP area end status bits */
#define FLASH_PRAR_DMEP_Pos                  (31U)
#define FLASH_PRAR_DMEP_Msk                  (0x1UL << FLASH_PRAR_DMEP_Pos)    /*!< 0x80000000 */
#define FLASH_PRAR_DMEP                      FLASH_PRAR_DMEP_Msk               /*!< PCROP protected erase enable option status bit */

/*******************  Bits definition for FLASH_SCAR register  *********************/
#define FLASH_SCAR_SEC_AREA_START_Pos        (0U)
#define FLASH_SCAR_SEC_AREA_START_Msk        (0xFFFUL << FLASH_SCAR_SEC_AREA_START_Pos) /*!< 0x00000FFF */
#define FLASH_SCAR_SEC_AREA_START            FLASH_SCAR_SEC_AREA_START_Msk              /*!< Secure-only area start status bits */
#define FLASH_SCAR_SEC_AREA_END_Pos          (16U)
#define FLASH_SCAR_SEC_AREA_END_Msk          (0xFFFUL << FLASH_SCAR_SEC_AREA_END_Pos) /*!< 0x0FFF0000 */
#define FLASH_SCAR_SEC_AREA_END              FLASH_SCAR_SEC_AREA_END_Msk              /*!< Secure-only area end status bits */
#define FLASH_SCAR_DMES_Pos                  (31U)
#define FLASH_SCAR_DMES_Msk                  (0x1UL << FLASH_SCAR_DMES_Pos)    /*!< 0x80000000 */
#define FLASH_SCAR_DMES                      FLASH_SCAR_DMES_Msk               /*!< Secure access protected erase enable option status bit */

/*******************  Bits definition for FLASH_WPSN register  *********************/
#define FLASH_WPSN_WRPSN_Pos                 (0U)
#define FLASH_WPSN_WRPSN_Msk                 (0xFFUL << FLASH_WPSN_WRPSN_Pos)  /*!< 0x000000FF */
#define FLASH_WPSN_WRPSN                     FLASH_WPSN_WRPSN_Msk              /*!< Sector write protection option status byte */

/*******************  Bits definition for FLASH_BOOT_CUR register  ****************/
#define FLASH_BOOT_ADD0_Pos                  (0U)
#define FLASH_BOOT_ADD0_Msk                  (0xFFFFUL << FLASH_BOOT_ADD0_Pos) /*!< 0x0000FFFF */
#define FLASH_BOOT_ADD0                      FLASH_BOOT_ADD0_Msk               /*!< Arm Cortex-M7 boot address 0 */
#define FLASH_BOOT_ADD1_Pos                  (16U)
#define FLASH_BOOT_ADD1_Msk                  (0xFFFFUL << FLASH_BOOT_ADD1_Pos) /*!< 0xFFFF0000 */
#define FLASH_BOOT_ADD1                      FLASH_BOOT_ADD1_Msk               /*!< Arm Cortex-M7 boot address 1 */


/*******************  Bits definition for FLASH_CRCCR register  ********************/
#define FLASH_CRCCR_CRC_SECT_Pos             (0U)
#define FLASH_CRCCR_CRC_SECT_Msk             (0x7UL << FLASH_CRCCR_CRC_SECT_Pos) /*!< 0x00000007 */
#define FLASH_CRCCR_CRC_SECT                 FLASH_CRCCR_CRC_SECT_Msk            /*!< CRC sector number */
#define FLASH_CRCCR_CRC_BY_SECT_Pos          (8U)
#define FLASH_CRCCR_CRC_BY_SECT_Msk          (0x1UL << FLASH_CRCCR_CRC_BY_SECT_Pos) /*!< 0x00000100 */
#define FLASH_CRCCR_CRC_BY_SECT              FLASH_CRCCR_CRC_BY_SECT_Msk            /*!< CRC sector mode select bit */
#define FLASH_CRCCR_ADD_SECT_Pos             (9U)
#define FLASH_CRCCR_ADD_SECT_Msk             (0x1UL << FLASH_CRCCR_ADD_SECT_Pos) /*!< 0x00000200 */
#define FLASH_CRCCR_ADD_SECT                 FLASH_CRCCR_ADD_SECT_Msk            /*!< CRC sector select bit */
#define FLASH_CRCCR_CLEAN_SECT_Pos           (10U)
#define FLASH_CRCCR_CLEAN_SECT_Msk           (0x1UL << FLASH_CRCCR_CLEAN_SECT_Pos) /*!< 0x00000400 */
#define FLASH_CRCCR_CLEAN_SECT               FLASH_CRCCR_CLEAN_SECT_Msk            /*!< CRC sector list clear bit */
#define FLASH_CRCCR_START_CRC_Pos            (16U)
#define FLASH_CRCCR_START_CRC_Msk            (0x1UL << FLASH_CRCCR_START_CRC_Pos) /*!< 0x00010000 */
#define FLASH_CRCCR_START_CRC                FLASH_CRCCR_START_CRC_Msk            /*!< CRC start bit */
#define FLASH_CRCCR_CLEAN_CRC_Pos            (17U)
#define FLASH_CRCCR_CLEAN_CRC_Msk            (0x1UL << FLASH_CRCCR_CLEAN_CRC_Pos) /*!< 0x00020000 */
#define FLASH_CRCCR_CLEAN_CRC                FLASH_CRCCR_CLEAN_CRC_Msk            /*!< CRC clear bit */
#define FLASH_CRCCR_CRC_BURST_Pos            (20U)
#define FLASH_CRCCR_CRC_BURST_Msk            (0x3UL << FLASH_CRCCR_CRC_BURST_Pos) /*!< 0x00300000 */
#define FLASH_CRCCR_CRC_BURST                FLASH_CRCCR_CRC_BURST_Msk            /*!< CRC burst size */
#define FLASH_CRCCR_CRC_BURST_0              (0x1UL << FLASH_CRCCR_CRC_BURST_Pos) /*!< 0x00100000 */
#define FLASH_CRCCR_CRC_BURST_1              (0x2UL << FLASH_CRCCR_CRC_BURST_Pos) /*!< 0x00200000 */
#define FLASH_CRCCR_ALL_BANK_Pos             (22U)
#define FLASH_CRCCR_ALL_BANK_Msk             (0x1UL << FLASH_CRCCR_ALL_BANK_Pos) /*!< 0x00400000 */
#define FLASH_CRCCR_ALL_BANK                 FLASH_CRCCR_ALL_BANK_Msk            /*!< CRC select bit */

/*******************  Bits definition for FLASH_CRCSADD register  ****************/
#define FLASH_CRCSADD_CRC_START_ADDR_Pos     (0U)
#define FLASH_CRCSADD_CRC_START_ADDR_Msk     (0xFFFFFFFFUL << FLASH_CRCSADD_CRC_START_ADDR_Pos) /*!< 0xFFFFFFFF */
#define FLASH_CRCSADD_CRC_START_ADDR         FLASH_CRCSADD_CRC_START_ADDR_Msk                   /*!< CRC start address */

/*******************  Bits definition for FLASH_CRCEADD register  ****************/
#define FLASH_CRCEADD_CRC_END_ADDR_Pos       (0U)
#define FLASH_CRCEADD_CRC_END_ADDR_Msk       (0xFFFFFFFFUL << FLASH_CRCEADD_CRC_END_ADDR_Pos) /*!< 0xFFFFFFFF */
#define FLASH_CRCEADD_CRC_END_ADDR           FLASH_CRCEADD_CRC_END_ADDR_Msk                   /*!< CRC end address */

/*******************  Bits definition for FLASH_CRCDATA register  ***************/
#define FLASH_CRCDATA_CRC_DATA_Pos           (0U)
#define FLASH_CRCDATA_CRC_DATA_Msk           (0xFFFFFFFFUL << FLASH_CRCDATA_CRC_DATA_Pos) /*!< 0xFFFFFFFF */
#define FLASH_CRCDATA_CRC_DATA               FLASH_CRCDATA_CRC_DATA_Msk                   /*!< CRC result */

/*******************  Bits definition for FLASH_ECC_FA register  *******************/
#define FLASH_ECC_FA_FAIL_ECC_ADDR_Pos       (0U)
#define FLASH_ECC_FA_FAIL_ECC_ADDR_Msk       (0x7FFFUL << FLASH_ECC_FA_FAIL_ECC_ADDR_Pos) /*!< 0x00007FFF */
#define FLASH_ECC_FA_FAIL_ECC_ADDR           FLASH_ECC_FA_FAIL_ECC_ADDR_Msk               /*!< ECC error address */

/*******************  Bits definition for FLASH_OPTSR2 register  *******************/
#define FLASH_OPTSR2_TCM_AXI_SHARED_Pos      (0U)
#define FLASH_OPTSR2_TCM_AXI_SHARED_Msk      (0x3UL << FLASH_OPTSR2_TCM_AXI_SHARED_Pos) /*!< 0x00000003 */
#define FLASH_OPTSR2_TCM_AXI_SHARED          FLASH_OPTSR2_TCM_AXI_SHARED_Msk            /*!< TCM RAM shared */
#define FLASH_OPTSR2_TCM_AXI_SHARED_0        (0x1UL << FLASH_OPTSR2_TCM_AXI_SHARED_Pos) /*!< 0x00000001 */
#define FLASH_OPTSR2_TCM_AXI_SHARED_1        (0x2UL << FLASH_OPTSR2_TCM_AXI_SHARED_Pos) /*!< 0x00000002 */
#define FLASH_OPTSR2_CPUFREQ_BOOST_Pos       (2U)
#define FLASH_OPTSR2_CPUFREQ_BOOST_Msk       (0x1UL << FLASH_OPTSR2_CPUFREQ_BOOST_Pos) /*!< 0x00000004 */
#define FLASH_OPTSR2_CPUFREQ_BOOST           FLASH_OPTSR2_CPUFREQ_BOOST_Msk            /*!< CPU frequency boost */

/******************************************************************************/
/*                                                                            */
/*                Filter Mathematical ACcelerator unit (FMAC)                 */
/*                                                                            */
/******************************************************************************/
/*****************  Bit definition for FMAC_X1BUFCFG register  ****************/
#define FMAC_X1BUFCFG_X1_BASE_Pos     (0U)
#define FMAC_X1BUFCFG_X1_BASE_Msk     (0xFFUL << FMAC_X1BUFCFG_X1_BASE_Pos)    /*!< 0x000000FF */
#define FMAC_X1BUFCFG_X1_BASE         FMAC_X1BUFCFG_X1_BASE_Msk                /*!< Base address of X1 buffer */
#define FMAC_X1BUFCFG_X1_BUF_SIZE_Pos (8U)
#define FMAC_X1BUFCFG_X1_BUF_SIZE_Msk (0xFFUL << FMAC_X1BUFCFG_X1_BUF_SIZE_Pos)/*!< 0x0000FF00 */
#define FMAC_X1BUFCFG_X1_BUF_SIZE     FMAC_X1BUFCFG_X1_BUF_SIZE_Msk            /*!< Allocated size of X1 buffer in 16-bit words */
#define FMAC_X1BUFCFG_FULL_WM_Pos     (24U)
#define FMAC_X1BUFCFG_FULL_WM_Msk     (0x3UL  << FMAC_X1BUFCFG_FULL_WM_Pos)    /*!< 0x03000000 */
#define FMAC_X1BUFCFG_FULL_WM         FMAC_X1BUFCFG_FULL_WM_Msk                /*!< Watermark for buffer full flag */
/*****************  Bit definition for FMAC_X2BUFCFG register  ****************/
#define FMAC_X2BUFCFG_X2_BASE_Pos     (0U)
#define FMAC_X2BUFCFG_X2_BASE_Msk     (0xFFUL << FMAC_X2BUFCFG_X2_BASE_Pos)    /*!< 0x000000FF */
#define FMAC_X2BUFCFG_X2_BASE         FMAC_X2BUFCFG_X2_BASE_Msk                /*!< Base address of X2 buffer */
#define FMAC_X2BUFCFG_X2_BUF_SIZE_Pos (8U)
#define FMAC_X2BUFCFG_X2_BUF_SIZE_Msk (0xFFUL << FMAC_X2BUFCFG_X2_BUF_SIZE_Pos)/*!< 0x0000FF00 */
#define FMAC_X2BUFCFG_X2_BUF_SIZE     FMAC_X2BUFCFG_X2_BUF_SIZE_Msk            /*!< Size of X2 buffer in 16-bit words */
/*****************  Bit definition for FMAC_YBUFCFG register  *****************/
#define FMAC_YBUFCFG_Y_BASE_Pos       (0U)
#define FMAC_YBUFCFG_Y_BASE_Msk       (0xFFUL << FMAC_YBUFCFG_Y_BASE_Pos)      /*!< 0x000000FF */
#define FMAC_YBUFCFG_Y_BASE           FMAC_YBUFCFG_Y_BASE_Msk                  /*!< Base address of Y buffer */
#define FMAC_YBUFCFG_Y_BUF_SIZE_Pos   (8U)
#define FMAC_YBUFCFG_Y_BUF_SIZE_Msk   (0xFFUL << FMAC_YBUFCFG_Y_BUF_SIZE_Pos)  /*!< 0x0000FF00 */
#define FMAC_YBUFCFG_Y_BUF_SIZE       FMAC_YBUFCFG_Y_BUF_SIZE_Msk              /*!< Size of Y buffer in 16-bit words */
#define FMAC_YBUFCFG_EMPTY_WM_Pos     (24U)
#define FMAC_YBUFCFG_EMPTY_WM_Msk     (0x3UL  << FMAC_YBUFCFG_EMPTY_WM_Pos)    /*!< 0x03000000 */
#define FMAC_YBUFCFG_EMPTY_WM         FMAC_YBUFCFG_EMPTY_WM_Msk                /*!< Watermark for buffer empty flag */
/******************  Bit definition for FMAC_PARAM register  ******************/
#define FMAC_PARAM_P_Pos              (0U)
#define FMAC_PARAM_P_Msk              (0xFFUL << FMAC_PARAM_P_Pos)             /*!< 0x000000FF */
#define FMAC_PARAM_P                  FMAC_PARAM_P_Msk                         /*!< Input parameter P */
#define FMAC_PARAM_Q_Pos              (8U)
#define FMAC_PARAM_Q_Msk              (0xFFUL << FMAC_PARAM_Q_Pos)             /*!< 0x0000FF00 */
#define FMAC_PARAM_Q                  FMAC_PARAM_Q_Msk                         /*!< Input parameter Q */
#define FMAC_PARAM_R_Pos              (16U)
#define FMAC_PARAM_R_Msk              (0xFFUL << FMAC_PARAM_R_Pos)             /*!< 0x00FF0000 */
#define FMAC_PARAM_R                  FMAC_PARAM_R_Msk                         /*!< Input parameter R */
#define FMAC_PARAM_FUNC_Pos           (24U)
#define FMAC_PARAM_FUNC_Msk           (0x7FUL << FMAC_PARAM_FUNC_Pos)          /*!< 0x7F000000 */
#define FMAC_PARAM_FUNC               FMAC_PARAM_FUNC_Msk                      /*!< Function */
#define FMAC_PARAM_FUNC_0             (0x1UL  << FMAC_PARAM_FUNC_Pos)          /*!< 0x01000000 */
#define FMAC_PARAM_FUNC_1             (0x2UL  << FMAC_PARAM_FUNC_Pos)          /*!< 0x02000000 */
#define FMAC_PARAM_FUNC_2             (0x4UL  << FMAC_PARAM_FUNC_Pos)          /*!< 0x04000000 */
#define FMAC_PARAM_FUNC_3             (0x8UL  << FMAC_PARAM_FUNC_Pos)          /*!< 0x08000000 */
#define FMAC_PARAM_FUNC_4             (0x10UL << FMAC_PARAM_FUNC_Pos)          /*!< 0x10000000 */
#define FMAC_PARAM_FUNC_5             (0x20UL << FMAC_PARAM_FUNC_Pos)          /*!< 0x20000000 */
#define FMAC_PARAM_FUNC_6             (0x40UL << FMAC_PARAM_FUNC_Pos)          /*!< 0x40000000 */
#define FMAC_PARAM_START_Pos          (31U)
#define FMAC_PARAM_START_Msk          (0x1UL  << FMAC_PARAM_START_Pos)         /*!< 0x80000000 */
#define FMAC_PARAM_START              FMAC_PARAM_START_Msk                     /*!< Enable execution */
/********************  Bit definition for FMAC_CR register  *******************/
#define FMAC_CR_RIEN_Pos              (0U)
#define FMAC_CR_RIEN_Msk              (0x1UL  << FMAC_CR_RIEN_Pos)             /*!< 0x00000001 */
#define FMAC_CR_RIEN                  FMAC_CR_RIEN_Msk                         /*!< Enable read interrupt */
#define FMAC_CR_WIEN_Pos              (1U)
#define FMAC_CR_WIEN_Msk              (0x1UL  << FMAC_CR_WIEN_Pos)             /*!< 0x00000002 */
#define FMAC_CR_WIEN                  FMAC_CR_WIEN_Msk                         /*!< Enable write interrupt */
#define FMAC_CR_OVFLIEN_Pos           (2U)
#define FMAC_CR_OVFLIEN_Msk           (0x1UL  << FMAC_CR_OVFLIEN_Pos)          /*!< 0x00000004 */
#define FMAC_CR_OVFLIEN               FMAC_CR_OVFLIEN_Msk                      /*!< Enable overflow error interrupts */
#define FMAC_CR_UNFLIEN_Pos           (3U)
#define FMAC_CR_UNFLIEN_Msk           (0x1UL  << FMAC_CR_UNFLIEN_Pos)          /*!< 0x00000008 */
#define FMAC_CR_UNFLIEN               FMAC_CR_UNFLIEN_Msk                      /*!< Enable underflow error interrupts */
#define FMAC_CR_SATIEN_Pos            (4U)
#define FMAC_CR_SATIEN_Msk            (0x1UL  << FMAC_CR_SATIEN_Pos)           /*!< 0x00000010 */
#define FMAC_CR_SATIEN                FMAC_CR_SATIEN_Msk                       /*!< Enable saturation error interrupts */
#define FMAC_CR_DMAREN_Pos            (8U)
#define FMAC_CR_DMAREN_Msk            (0x1UL  << FMAC_CR_DMAREN_Pos)           /*!< 0x00000100 */
#define FMAC_CR_DMAREN                FMAC_CR_DMAREN_Msk                       /*!< Enable DMA read channel requests */
#define FMAC_CR_DMAWEN_Pos            (9U)
#define FMAC_CR_DMAWEN_Msk            (0x1UL  << FMAC_CR_DMAWEN_Pos)           /*!< 0x00000200 */
#define FMAC_CR_DMAWEN                FMAC_CR_DMAWEN_Msk                       /*!< Enable DMA write channel requests */
#define FMAC_CR_CLIPEN_Pos            (15U)
#define FMAC_CR_CLIPEN_Msk            (0x1UL  << FMAC_CR_CLIPEN_Pos)           /*!< 0x00008000 */
#define FMAC_CR_CLIPEN                FMAC_CR_CLIPEN_Msk                       /*!< Enable clipping */
#define FMAC_CR_RESET_Pos             (16U)
#define FMAC_CR_RESET_Msk             (0x1UL  << FMAC_CR_RESET_Pos)            /*!< 0x00010000 */
#define FMAC_CR_RESET                 FMAC_CR_RESET_Msk                        /*!< Reset filter mathematical accelerator unit */
/*******************  Bit definition for FMAC_SR register  ********************/
#define FMAC_SR_YEMPTY_Pos            (0U)
#define FMAC_SR_YEMPTY_Msk            (0x1UL  << FMAC_SR_YEMPTY_Pos)           /*!< 0x00000001 */
#define FMAC_SR_YEMPTY                FMAC_SR_YEMPTY_Msk                       /*!< Y buffer empty flag */
#define FMAC_SR_X1FULL_Pos            (1U)
#define FMAC_SR_X1FULL_Msk            (0x1UL  << FMAC_SR_X1FULL_Pos)           /*!< 0x00000002 */
#define FMAC_SR_X1FULL                FMAC_SR_X1FULL_Msk                       /*!< X1 buffer full flag */
#define FMAC_SR_OVFL_Pos              (8U)
#define FMAC_SR_OVFL_Msk              (0x1UL  << FMAC_SR_OVFL_Pos)             /*!< 0x00000100 */
#define FMAC_SR_OVFL                  FMAC_SR_OVFL_Msk                         /*!< Overflow error flag */
#define FMAC_SR_UNFL_Pos              (9U)
#define FMAC_SR_UNFL_Msk              (0x1UL  << FMAC_SR_UNFL_Pos)             /*!< 0x00000200 */
#define FMAC_SR_UNFL                  FMAC_SR_UNFL_Msk                         /*!< Underflow error flag */
#define FMAC_SR_SAT_Pos               (10U)
#define FMAC_SR_SAT_Msk               (0x1UL  << FMAC_SR_SAT_Pos)              /*!< 0x00000400 */
#define FMAC_SR_SAT                   FMAC_SR_SAT_Msk                          /*!< Saturation error flag */
/******************  Bit definition for FMAC_WDATA register  ******************/
#define FMAC_WDATA_WDATA_Pos          (0U)
#define FMAC_WDATA_WDATA_Msk          (0xFFFFUL << FMAC_WDATA_WDATA_Pos)       /*!< 0x0000FFFF */
#define FMAC_WDATA_WDATA              FMAC_WDATA_WDATA_Msk                     /*!< Write data */
/******************  Bit definition for FMACX_RDATA register  *****************/
#define FMAC_RDATA_RDATA_Pos          (0U)
#define FMAC_RDATA_RDATA_Msk          (0xFFFFUL << FMAC_RDATA_RDATA_Pos)       /*!< 0x0000FFFF */
#define FMAC_RDATA_RDATA              FMAC_RDATA_RDATA_Msk                     /*!< Read data */

/******************************************************************************/
/*                                                                            */
/*                          Flexible Memory Controller                        */
/*                                                                            */
/******************************************************************************/
/******************  Bit definition for FMC_BCR1 register  *******************/
#define FMC_BCR1_CCLKEN_Pos        (20U)
#define FMC_BCR1_CCLKEN_Msk        (0x1UL << FMC_BCR1_CCLKEN_Pos)              /*!< 0x00100000 */
#define FMC_BCR1_CCLKEN            FMC_BCR1_CCLKEN_Msk                         /*!<Continous clock enable     */
#define FMC_BCR1_WFDIS_Pos         (21U)
#define FMC_BCR1_WFDIS_Msk         (0x1UL << FMC_BCR1_WFDIS_Pos)               /*!< 0x00200000 */
#define FMC_BCR1_WFDIS             FMC_BCR1_WFDIS_Msk                          /*!<Write FIFO Disable         */

#define FMC_BCR1_BMAP_Pos          (24U)
#define FMC_BCR1_BMAP_Msk          (0x3UL << FMC_BCR1_BMAP_Pos)                /*!< 0x03000000 */
#define FMC_BCR1_BMAP              FMC_BCR1_BMAP_Msk                           /*!<BMAP[1:0] FMC bank mapping */
#define FMC_BCR1_BMAP_0            (0x1UL << FMC_BCR1_BMAP_Pos)                 /*!< 0x01000000 */
#define FMC_BCR1_BMAP_1            (0x2UL << FMC_BCR1_BMAP_Pos)                 /*!< 0x02000000 */

#define FMC_BCR1_FMCEN_Pos         (31U)
#define FMC_BCR1_FMCEN_Msk         (0x1UL << FMC_BCR1_FMCEN_Pos)               /*!< 0x80000000 */
#define FMC_BCR1_FMCEN             FMC_BCR1_FMCEN_Msk                          /*!<FMC controller Enable */
/******************  Bit definition for FMC_BCRx registers (x=1..4)  *********/
#define FMC_BCRx_MBKEN_Pos         (0U)
#define FMC_BCRx_MBKEN_Msk         (0x1UL << FMC_BCRx_MBKEN_Pos)               /*!< 0x00000001 */
#define FMC_BCRx_MBKEN             FMC_BCRx_MBKEN_Msk                          /*!<Memory bank enable bit                 */
#define FMC_BCRx_MUXEN_Pos         (1U)
#define FMC_BCRx_MUXEN_Msk         (0x1UL << FMC_BCRx_MUXEN_Pos)               /*!< 0x00000002 */
#define FMC_BCRx_MUXEN             FMC_BCRx_MUXEN_Msk                          /*!<Address/data multiplexing enable bit   */

#define FMC_BCRx_MTYP_Pos          (2U)
#define FMC_BCRx_MTYP_Msk          (0x3UL << FMC_BCRx_MTYP_Pos)                /*!< 0x0000000C */
#define FMC_BCRx_MTYP              FMC_BCRx_MTYP_Msk                           /*!<MTYP[1:0] bits (Memory type)           */
#define FMC_BCRx_MTYP_0            (0x1UL << FMC_BCRx_MTYP_Pos)                 /*!< 0x00000004 */
#define FMC_BCRx_MTYP_1            (0x2UL << FMC_BCRx_MTYP_Pos)                 /*!< 0x00000008 */

#define FMC_BCRx_MWID_Pos          (4U)
#define FMC_BCRx_MWID_Msk          (0x3UL << FMC_BCRx_MWID_Pos)                /*!< 0x00000030 */
#define FMC_BCRx_MWID              FMC_BCRx_MWID_Msk                           /*!<MWID[1:0] bits (Memory data bus width) */
#define FMC_BCRx_MWID_0            (0x1UL << FMC_BCRx_MWID_Pos)                 /*!< 0x00000010 */
#define FMC_BCRx_MWID_1            (0x2UL << FMC_BCRx_MWID_Pos)                 /*!< 0x00000020 */

#define FMC_BCRx_FACCEN_Pos        (6U)
#define FMC_BCRx_FACCEN_Msk        (0x1UL << FMC_BCRx_FACCEN_Pos)              /*!< 0x00000040 */
#define FMC_BCRx_FACCEN            FMC_BCRx_FACCEN_Msk                         /*!<Flash access enable        */
#define FMC_BCRx_BURSTEN_Pos       (8U)
#define FMC_BCRx_BURSTEN_Msk       (0x1UL << FMC_BCRx_BURSTEN_Pos)             /*!< 0x00000100 */
#define FMC_BCRx_BURSTEN           FMC_BCRx_BURSTEN_Msk                        /*!<Burst enable bit           */
#define FMC_BCRx_WAITPOL_Pos       (9U)
#define FMC_BCRx_WAITPOL_Msk       (0x1UL << FMC_BCRx_WAITPOL_Pos)             /*!< 0x00000200 */
#define FMC_BCRx_WAITPOL           FMC_BCRx_WAITPOL_Msk                        /*!<Wait signal polarity bit   */
#define FMC_BCRx_WAITCFG_Pos       (11U)
#define FMC_BCRx_WAITCFG_Msk       (0x1UL << FMC_BCRx_WAITCFG_Pos)             /*!< 0x00000800 */
#define FMC_BCRx_WAITCFG           FMC_BCRx_WAITCFG_Msk                        /*!<Wait timing configuration  */
#define FMC_BCRx_WREN_Pos          (12U)
#define FMC_BCRx_WREN_Msk          (0x1UL << FMC_BCRx_WREN_Pos)                /*!< 0x00001000 */
#define FMC_BCRx_WREN              FMC_BCRx_WREN_Msk                           /*!<Write enable bit           */
#define FMC_BCRx_WAITEN_Pos        (13U)
#define FMC_BCRx_WAITEN_Msk        (0x1UL << FMC_BCRx_WAITEN_Pos)              /*!< 0x00002000 */
#define FMC_BCRx_WAITEN            FMC_BCRx_WAITEN_Msk                         /*!<Wait enable bit            */
#define FMC_BCRx_EXTMOD_Pos        (14U)
#define FMC_BCRx_EXTMOD_Msk        (0x1UL << FMC_BCRx_EXTMOD_Pos)              /*!< 0x00004000 */
#define FMC_BCRx_EXTMOD            FMC_BCRx_EXTMOD_Msk                         /*!<Extended mode enable       */
#define FMC_BCRx_ASYNCWAIT_Pos     (15U)
#define FMC_BCRx_ASYNCWAIT_Msk     (0x1UL << FMC_BCRx_ASYNCWAIT_Pos)           /*!< 0x00008000 */
#define FMC_BCRx_ASYNCWAIT         FMC_BCRx_ASYNCWAIT_Msk                      /*!<Asynchronous wait          */

#define FMC_BCRx_CPSIZE_Pos        (16U)
#define FMC_BCRx_CPSIZE_Msk        (0x7UL << FMC_BCRx_CPSIZE_Pos)              /*!< 0x00070000 */
#define FMC_BCRx_CPSIZE            FMC_BCRx_CPSIZE_Msk                         /*!<PSIZE[2:0] bits CRAM Page Size */
#define FMC_BCRx_CPSIZE_0          (0x1UL << FMC_BCRx_CPSIZE_Pos)               /*!< 0x00010000 */
#define FMC_BCRx_CPSIZE_1          (0x2UL << FMC_BCRx_CPSIZE_Pos)               /*!< 0x00020000 */
#define FMC_BCRx_CPSIZE_2          (0x4UL << FMC_BCRx_CPSIZE_Pos)               /*!< 0x00040000 */

#define FMC_BCRx_CBURSTRW_Pos      (19U)
#define FMC_BCRx_CBURSTRW_Msk      (0x1UL << FMC_BCRx_CBURSTRW_Pos)            /*!< 0x00080000 */
#define FMC_BCRx_CBURSTRW          FMC_BCRx_CBURSTRW_Msk                       /*!<Write burst enable         */

/******************  Bit definition for FMC_BTRx registers (x=1..4)  *********/
#define FMC_BTRx_ADDSET_Pos        (0U)
#define FMC_BTRx_ADDSET_Msk        (0xFUL << FMC_BTRx_ADDSET_Pos)              /*!< 0x0000000F */
#define FMC_BTRx_ADDSET            FMC_BTRx_ADDSET_Msk                         /*!<ADDSET[3:0] bits (Address setup phase duration) */
#define FMC_BTRx_ADDSET_0          (0x1UL << FMC_BTRx_ADDSET_Pos)               /*!< 0x00000001 */
#define FMC_BTRx_ADDSET_1          (0x2UL << FMC_BTRx_ADDSET_Pos)               /*!< 0x00000002 */
#define FMC_BTRx_ADDSET_2          (0x4UL << FMC_BTRx_ADDSET_Pos)               /*!< 0x00000004 */
#define FMC_BTRx_ADDSET_3          (0x8UL << FMC_BTRx_ADDSET_Pos)               /*!< 0x00000008 */

#define FMC_BTRx_ADDHLD_Pos        (4U)
#define FMC_BTRx_ADDHLD_Msk        (0xFUL << FMC_BTRx_ADDHLD_Pos)              /*!< 0x000000F0 */
#define FMC_BTRx_ADDHLD            FMC_BTRx_ADDHLD_Msk                         /*!<ADDHLD[3:0] bits (Address-hold phase duration)  */
#define FMC_BTRx_ADDHLD_0          (0x1UL << FMC_BTRx_ADDHLD_Pos)               /*!< 0x00000010 */
#define FMC_BTRx_ADDHLD_1          (0x2UL << FMC_BTRx_ADDHLD_Pos)               /*!< 0x00000020 */
#define FMC_BTRx_ADDHLD_2          (0x4UL << FMC_BTRx_ADDHLD_Pos)               /*!< 0x00000040 */
#define FMC_BTRx_ADDHLD_3          (0x8UL << FMC_BTRx_ADDHLD_Pos)               /*!< 0x00000080 */

#define FMC_BTRx_DATAST_Pos        (8U)
#define FMC_BTRx_DATAST_Msk        (0xFFUL << FMC_BTRx_DATAST_Pos)             /*!< 0x0000FF00 */
#define FMC_BTRx_DATAST            FMC_BTRx_DATAST_Msk                         /*!<DATAST [3:0] bits (Data-phase duration) */
#define FMC_BTRx_DATAST_0          (0x01UL << FMC_BTRx_DATAST_Pos)              /*!< 0x00000100 */
#define FMC_BTRx_DATAST_1          (0x02UL << FMC_BTRx_DATAST_Pos)              /*!< 0x00000200 */
#define FMC_BTRx_DATAST_2          (0x04UL << FMC_BTRx_DATAST_Pos)              /*!< 0x00000400 */
#define FMC_BTRx_DATAST_3          (0x08UL << FMC_BTRx_DATAST_Pos)              /*!< 0x00000800 */
#define FMC_BTRx_DATAST_4          (0x10UL << FMC_BTRx_DATAST_Pos)              /*!< 0x00001000 */
#define FMC_BTRx_DATAST_5          (0x20UL << FMC_BTRx_DATAST_Pos)              /*!< 0x00002000 */
#define FMC_BTRx_DATAST_6          (0x40UL << FMC_BTRx_DATAST_Pos)              /*!< 0x00004000 */
#define FMC_BTRx_DATAST_7          (0x80UL << FMC_BTRx_DATAST_Pos)              /*!< 0x00008000 */

#define FMC_BTRx_BUSTURN_Pos       (16U)
#define FMC_BTRx_BUSTURN_Msk       (0xFUL << FMC_BTRx_BUSTURN_Pos)             /*!< 0x000F0000 */
#define FMC_BTRx_BUSTURN           FMC_BTRx_BUSTURN_Msk                        /*!<BUSTURN[3:0] bits (Bus turnaround phase duration) */
#define FMC_BTRx_BUSTURN_0         (0x1UL << FMC_BTRx_BUSTURN_Pos)              /*!< 0x00010000 */
#define FMC_BTRx_BUSTURN_1         (0x2UL << FMC_BTRx_BUSTURN_Pos)              /*!< 0x00020000 */
#define FMC_BTRx_BUSTURN_2         (0x4UL << FMC_BTRx_BUSTURN_Pos)              /*!< 0x00040000 */
#define FMC_BTRx_BUSTURN_3         (0x8UL << FMC_BTRx_BUSTURN_Pos)              /*!< 0x00080000 */

#define FMC_BTRx_CLKDIV_Pos        (20U)
#define FMC_BTRx_CLKDIV_Msk        (0xFUL << FMC_BTRx_CLKDIV_Pos)              /*!< 0x00F00000 */
#define FMC_BTRx_CLKDIV            FMC_BTRx_CLKDIV_Msk                         /*!<CLKDIV[3:0] bits (Clock divide ratio) */
#define FMC_BTRx_CLKDIV_0          (0x1UL << FMC_BTRx_CLKDIV_Pos)               /*!< 0x00100000 */
#define FMC_BTRx_CLKDIV_1          (0x2UL << FMC_BTRx_CLKDIV_Pos)               /*!< 0x00200000 */
#define FMC_BTRx_CLKDIV_2          (0x4UL << FMC_BTRx_CLKDIV_Pos)               /*!< 0x00400000 */
#define FMC_BTRx_CLKDIV_3          (0x8UL << FMC_BTRx_CLKDIV_Pos)               /*!< 0x00800000 */

#define FMC_BTRx_DATLAT_Pos        (24U)
#define FMC_BTRx_DATLAT_Msk        (0xFUL << FMC_BTRx_DATLAT_Pos)              /*!< 0x0F000000 */
#define FMC_BTRx_DATLAT            FMC_BTRx_DATLAT_Msk                         /*!<DATLA[3:0] bits (Data latency) */
#define FMC_BTRx_DATLAT_0          (0x1UL << FMC_BTRx_DATLAT_Pos)               /*!< 0x01000000 */
#define FMC_BTRx_DATLAT_1          (0x2UL << FMC_BTRx_DATLAT_Pos)               /*!< 0x02000000 */
#define FMC_BTRx_DATLAT_2          (0x4UL << FMC_BTRx_DATLAT_Pos)               /*!< 0x04000000 */
#define FMC_BTRx_DATLAT_3          (0x8UL << FMC_BTRx_DATLAT_Pos)               /*!< 0x08000000 */

#define FMC_BTRx_ACCMOD_Pos        (28U)
#define FMC_BTRx_ACCMOD_Msk        (0x3UL << FMC_BTRx_ACCMOD_Pos)              /*!< 0x30000000 */
#define FMC_BTRx_ACCMOD            FMC_BTRx_ACCMOD_Msk                         /*!<ACCMOD[1:0] bits (Access mode) */
#define FMC_BTRx_ACCMOD_0          (0x1UL << FMC_BTRx_ACCMOD_Pos)               /*!< 0x10000000 */
#define FMC_BTRx_ACCMOD_1          (0x2UL << FMC_BTRx_ACCMOD_Pos)               /*!< 0x20000000 */

/******************  Bit definition for FMC_BWTRx registers (x=1..4)  *********/
#define FMC_BWTRx_ADDSET_Pos       (0U)
#define FMC_BWTRx_ADDSET_Msk       (0xFUL << FMC_BWTRx_ADDSET_Pos)             /*!< 0x0000000F */
#define FMC_BWTRx_ADDSET           FMC_BWTRx_ADDSET_Msk                        /*!<ADDSET[3:0] bits (Address setup phase duration) */
#define FMC_BWTRx_ADDSET_0         (0x1UL << FMC_BWTRx_ADDSET_Pos)              /*!< 0x00000001 */
#define FMC_BWTRx_ADDSET_1         (0x2UL << FMC_BWTRx_ADDSET_Pos)              /*!< 0x00000002 */
#define FMC_BWTRx_ADDSET_2         (0x4UL << FMC_BWTRx_ADDSET_Pos)              /*!< 0x00000004 */
#define FMC_BWTRx_ADDSET_3         (0x8UL << FMC_BWTRx_ADDSET_Pos)              /*!< 0x00000008 */

#define FMC_BWTRx_ADDHLD_Pos       (4U)
#define FMC_BWTRx_ADDHLD_Msk       (0xFUL << FMC_BWTRx_ADDHLD_Pos)             /*!< 0x000000F0 */
#define FMC_BWTRx_ADDHLD           FMC_BWTRx_ADDHLD_Msk                        /*!<ADDHLD[3:0] bits (Address-hold phase duration) */
#define FMC_BWTRx_ADDHLD_0         (0x1UL << FMC_BWTRx_ADDHLD_Pos)              /*!< 0x00000010 */
#define FMC_BWTRx_ADDHLD_1         (0x2UL << FMC_BWTRx_ADDHLD_Pos)              /*!< 0x00000020 */
#define FMC_BWTRx_ADDHLD_2         (0x4UL << FMC_BWTRx_ADDHLD_Pos)              /*!< 0x00000040 */
#define FMC_BWTRx_ADDHLD_3         (0x8UL << FMC_BWTRx_ADDHLD_Pos)              /*!< 0x00000080 */

#define FMC_BWTRx_DATAST_Pos       (8U)
#define FMC_BWTRx_DATAST_Msk       (0xFFUL << FMC_BWTRx_DATAST_Pos)            /*!< 0x0000FF00 */
#define FMC_BWTRx_DATAST           FMC_BWTRx_DATAST_Msk                        /*!<DATAST [3:0] bits (Data-phase duration) */
#define FMC_BWTRx_DATAST_0         (0x01UL << FMC_BWTRx_DATAST_Pos)             /*!< 0x00000100 */
#define FMC_BWTRx_DATAST_1         (0x02UL << FMC_BWTRx_DATAST_Pos)             /*!< 0x00000200 */
#define FMC_BWTRx_DATAST_2         (0x04UL << FMC_BWTRx_DATAST_Pos)             /*!< 0x00000400 */
#define FMC_BWTRx_DATAST_3         (0x08UL << FMC_BWTRx_DATAST_Pos)             /*!< 0x00000800 */
#define FMC_BWTRx_DATAST_4         (0x10UL << FMC_BWTRx_DATAST_Pos)             /*!< 0x00001000 */
#define FMC_BWTRx_DATAST_5         (0x20UL << FMC_BWTRx_DATAST_Pos)             /*!< 0x00002000 */
#define FMC_BWTRx_DATAST_6         (0x40UL << FMC_BWTRx_DATAST_Pos)             /*!< 0x00004000 */
#define FMC_BWTRx_DATAST_7         (0x80UL << FMC_BWTRx_DATAST_Pos)             /*!< 0x00008000 */

#define FMC_BWTRx_BUSTURN_Pos      (16U)
#define FMC_BWTRx_BUSTURN_Msk      (0xFUL << FMC_BWTRx_BUSTURN_Pos)            /*!< 0x000F0000 */
#define FMC_BWTRx_BUSTURN          FMC_BWTRx_BUSTURN_Msk                       /*!<BUSTURN[3:0] bits (Bus turnaround phase duration) */
#define FMC_BWTRx_BUSTURN_0        (0x1UL << FMC_BWTRx_BUSTURN_Pos)             /*!< 0x00010000 */
#define FMC_BWTRx_BUSTURN_1        (0x2UL << FMC_BWTRx_BUSTURN_Pos)             /*!< 0x00020000 */
#define FMC_BWTRx_BUSTURN_2        (0x4UL << FMC_BWTRx_BUSTURN_Pos)             /*!< 0x00040000 */
#define FMC_BWTRx_BUSTURN_3        (0x8UL << FMC_BWTRx_BUSTURN_Pos)             /*!< 0x00080000 */

#define FMC_BWTRx_ACCMOD_Pos       (28U)
#define FMC_BWTRx_ACCMOD_Msk       (0x3UL << FMC_BWTRx_ACCMOD_Pos)             /*!< 0x30000000 */
#define FMC_BWTRx_ACCMOD           FMC_BWTRx_ACCMOD_Msk                        /*!<ACCMOD[1:0] bits (Access mode) */
#define FMC_BWTRx_ACCMOD_0         (0x1UL << FMC_BWTRx_ACCMOD_Pos)              /*!< 0x10000000 */
#define FMC_BWTRx_ACCMOD_1         (0x2UL << FMC_BWTRx_ACCMOD_Pos)              /*!< 0x20000000 */

/******************  Bit definition for FMC_PCR register  *******************/
#define FMC_PCR_PWAITEN_Pos        (1U)
#define FMC_PCR_PWAITEN_Msk        (0x1UL << FMC_PCR_PWAITEN_Pos)              /*!< 0x00000002 */
#define FMC_PCR_PWAITEN            FMC_PCR_PWAITEN_Msk                         /*!<Wait feature enable bit                   */
#define FMC_PCR_PBKEN_Pos          (2U)
#define FMC_PCR_PBKEN_Msk          (0x1UL << FMC_PCR_PBKEN_Pos)                /*!< 0x00000004 */
#define FMC_PCR_PBKEN              FMC_PCR_PBKEN_Msk                           /*!<NAND Flash memory bank enable bit */

#define FMC_PCR_PWID_Pos           (4U)
#define FMC_PCR_PWID_Msk           (0x3UL << FMC_PCR_PWID_Pos)                 /*!< 0x00000030 */
#define FMC_PCR_PWID               FMC_PCR_PWID_Msk                            /*!<PWID[1:0] bits (NAND Flash databus width) */
#define FMC_PCR_PWID_0             (0x1UL << FMC_PCR_PWID_Pos)                  /*!< 0x00000010 */
#define FMC_PCR_PWID_1             (0x2UL << FMC_PCR_PWID_Pos)                  /*!< 0x00000020 */

#define FMC_PCR_ECCEN_Pos          (6U)
#define FMC_PCR_ECCEN_Msk          (0x1UL << FMC_PCR_ECCEN_Pos)                /*!< 0x00000040 */
#define FMC_PCR_ECCEN              FMC_PCR_ECCEN_Msk                           /*!<ECC computation logic enable bit          */

#define FMC_PCR_TCLR_Pos           (9U)
#define FMC_PCR_TCLR_Msk           (0xFUL << FMC_PCR_TCLR_Pos)                 /*!< 0x00001E00 */
#define FMC_PCR_TCLR               FMC_PCR_TCLR_Msk                            /*!<TCLR[3:0] bits (CLE to RE delay)          */
#define FMC_PCR_TCLR_0             (0x1UL << FMC_PCR_TCLR_Pos)                  /*!< 0x00000200 */
#define FMC_PCR_TCLR_1             (0x2UL << FMC_PCR_TCLR_Pos)                  /*!< 0x00000400 */
#define FMC_PCR_TCLR_2             (0x4UL << FMC_PCR_TCLR_Pos)                  /*!< 0x00000800 */
#define FMC_PCR_TCLR_3             (0x8UL << FMC_PCR_TCLR_Pos)                  /*!< 0x00001000 */

#define FMC_PCR_TAR_Pos            (13U)
#define FMC_PCR_TAR_Msk            (0xFUL << FMC_PCR_TAR_Pos)                  /*!< 0x0001E000 */
#define FMC_PCR_TAR                FMC_PCR_TAR_Msk                             /*!<TAR[3:0] bits (ALE to RE delay)           */
#define FMC_PCR_TAR_0              (0x1UL << FMC_PCR_TAR_Pos)                   /*!< 0x00002000 */
#define FMC_PCR_TAR_1              (0x2UL << FMC_PCR_TAR_Pos)                   /*!< 0x00004000 */
#define FMC_PCR_TAR_2              (0x4UL << FMC_PCR_TAR_Pos)                   /*!< 0x00008000 */
#define FMC_PCR_TAR_3              (0x8UL << FMC_PCR_TAR_Pos)                   /*!< 0x00010000 */

#define FMC_PCR_ECCPS_Pos          (17U)
#define FMC_PCR_ECCPS_Msk          (0x7UL << FMC_PCR_ECCPS_Pos)                /*!< 0x000E0000 */
#define FMC_PCR_ECCPS              FMC_PCR_ECCPS_Msk                           /*!<ECCPS[1:0] bits (ECC page size)           */
#define FMC_PCR_ECCPS_0            (0x1UL << FMC_PCR_ECCPS_Pos)                 /*!< 0x00020000 */
#define FMC_PCR_ECCPS_1            (0x2UL << FMC_PCR_ECCPS_Pos)                 /*!< 0x00040000 */
#define FMC_PCR_ECCPS_2            (0x4UL << FMC_PCR_ECCPS_Pos)                 /*!< 0x00080000 */

/*******************  Bit definition for FMC_SR register  *******************/
#define FMC_SR_IRS_Pos             (0U)
#define FMC_SR_IRS_Msk             (0x1UL << FMC_SR_IRS_Pos)                   /*!< 0x00000001 */
#define FMC_SR_IRS                 FMC_SR_IRS_Msk                              /*!<Interrupt Rising Edge status                */
#define FMC_SR_ILS_Pos             (1U)
#define FMC_SR_ILS_Msk             (0x1UL << FMC_SR_ILS_Pos)                   /*!< 0x00000002 */
#define FMC_SR_ILS                 FMC_SR_ILS_Msk                              /*!<Interrupt Level status                      */
#define FMC_SR_IFS_Pos             (2U)
#define FMC_SR_IFS_Msk             (0x1UL << FMC_SR_IFS_Pos)                   /*!< 0x00000004 */
#define FMC_SR_IFS                 FMC_SR_IFS_Msk                              /*!<Interrupt Falling Edge status               */
#define FMC_SR_IREN_Pos            (3U)
#define FMC_SR_IREN_Msk            (0x1UL << FMC_SR_IREN_Pos)                  /*!< 0x00000008 */
#define FMC_SR_IREN                FMC_SR_IREN_Msk                             /*!<Interrupt Rising Edge detection Enable bit  */
#define FMC_SR_ILEN_Pos            (4U)
#define FMC_SR_ILEN_Msk            (0x1UL << FMC_SR_ILEN_Pos)                  /*!< 0x00000010 */
#define FMC_SR_ILEN                FMC_SR_ILEN_Msk                             /*!<Interrupt Level detection Enable bit        */
#define FMC_SR_IFEN_Pos            (5U)
#define FMC_SR_IFEN_Msk            (0x1UL << FMC_SR_IFEN_Pos)                  /*!< 0x00000020 */
#define FMC_SR_IFEN                FMC_SR_IFEN_Msk                             /*!<Interrupt Falling Edge detection Enable bit */
#define FMC_SR_FEMPT_Pos           (6U)
#define FMC_SR_FEMPT_Msk           (0x1UL << FMC_SR_FEMPT_Pos)                 /*!< 0x00000040 */
#define FMC_SR_FEMPT               FMC_SR_FEMPT_Msk                            /*!<FIFO empty                                  */

/******************  Bit definition for FMC_PMEM register  ******************/
#define FMC_PMEM_MEMSET_Pos       (0U)
#define FMC_PMEM_MEMSET_Msk       (0xFFUL << FMC_PMEM_MEMSET_Pos)            /*!< 0x000000FF */
#define FMC_PMEM_MEMSET           FMC_PMEM_MEMSET_Msk                        /*!<MEMSET[7:0] bits (Common memory setup time) */
#define FMC_PMEM_MEMSET_0         (0x01UL << FMC_PMEM_MEMSET_Pos)             /*!< 0x00000001 */
#define FMC_PMEM_MEMSET_1         (0x02UL << FMC_PMEM_MEMSET_Pos)             /*!< 0x00000002 */
#define FMC_PMEM_MEMSET_2         (0x04UL << FMC_PMEM_MEMSET_Pos)             /*!< 0x00000004 */
#define FMC_PMEM_MEMSET_3         (0x08UL << FMC_PMEM_MEMSET_Pos)             /*!< 0x00000008 */
#define FMC_PMEM_MEMSET_4         (0x10UL << FMC_PMEM_MEMSET_Pos)             /*!< 0x00000010 */
#define FMC_PMEM_MEMSET_5         (0x20UL << FMC_PMEM_MEMSET_Pos)             /*!< 0x00000020 */
#define FMC_PMEM_MEMSET_6         (0x40UL << FMC_PMEM_MEMSET_Pos)             /*!< 0x00000040 */
#define FMC_PMEM_MEMSET_7         (0x80UL << FMC_PMEM_MEMSET_Pos)             /*!< 0x00000080 */

#define FMC_PMEM_MEMWAIT_Pos      (8U)
#define FMC_PMEM_MEMWAIT_Msk      (0xFFUL << FMC_PMEM_MEMWAIT_Pos)           /*!< 0x0000FF00 */
#define FMC_PMEM_MEMWAIT          FMC_PMEM_MEMWAIT_Msk                       /*!<MEMWAIT[7:0] bits (Common memory wait time) */
#define FMC_PMEM_MEMWAIT_0        (0x01UL << FMC_PMEM_MEMWAIT_Pos)            /*!< 0x00000100 */
#define FMC_PMEM_MEMWAIT_1        (0x02UL << FMC_PMEM_MEMWAIT_Pos)            /*!< 0x00000200 */
#define FMC_PMEM_MEMWAIT_2        (0x04UL << FMC_PMEM_MEMWAIT_Pos)            /*!< 0x00000400 */
#define FMC_PMEM_MEMWAIT_3        (0x08UL << FMC_PMEM_MEMWAIT_Pos)            /*!< 0x00000800 */
#define FMC_PMEM_MEMWAIT_4        (0x10UL << FMC_PMEM_MEMWAIT_Pos)            /*!< 0x00001000 */
#define FMC_PMEM_MEMWAIT_5        (0x20UL << FMC_PMEM_MEMWAIT_Pos)            /*!< 0x00002000 */
#define FMC_PMEM_MEMWAIT_6        (0x40UL << FMC_PMEM_MEMWAIT_Pos)            /*!< 0x00004000 */
#define FMC_PMEM_MEMWAIT_7        (0x80UL << FMC_PMEM_MEMWAIT_Pos)            /*!< 0x00008000 */

#define FMC_PMEM_MEMHOLD_Pos      (16U)
#define FMC_PMEM_MEMHOLD_Msk      (0xFFUL << FMC_PMEM_MEMHOLD_Pos)           /*!< 0x00FF0000 */
#define FMC_PMEM_MEMHOLD          FMC_PMEM_MEMHOLD_Msk                       /*!<MEMHOLD[7:0] bits (Common memory hold time) */
#define FMC_PMEM_MEMHOLD_0        (0x01UL << FMC_PMEM_MEMHOLD_Pos)            /*!< 0x00010000 */
#define FMC_PMEM_MEMHOLD_1        (0x02UL << FMC_PMEM_MEMHOLD_Pos)            /*!< 0x00020000 */
#define FMC_PMEM_MEMHOLD_2        (0x04UL << FMC_PMEM_MEMHOLD_Pos)            /*!< 0x00040000 */
#define FMC_PMEM_MEMHOLD_3        (0x08UL << FMC_PMEM_MEMHOLD_Pos)            /*!< 0x00080000 */
#define FMC_PMEM_MEMHOLD_4        (0x10UL << FMC_PMEM_MEMHOLD_Pos)            /*!< 0x00100000 */
#define FMC_PMEM_MEMHOLD_5        (0x20UL << FMC_PMEM_MEMHOLD_Pos)            /*!< 0x00200000 */
#define FMC_PMEM_MEMHOLD_6        (0x40UL << FMC_PMEM_MEMHOLD_Pos)            /*!< 0x00400000 */
#define FMC_PMEM_MEMHOLD_7        (0x80UL << FMC_PMEM_MEMHOLD_Pos)            /*!< 0x00800000 */

#define FMC_PMEM_MEMHIZ_Pos       (24U)
#define FMC_PMEM_MEMHIZ_Msk       (0xFFUL << FMC_PMEM_MEMHIZ_Pos)            /*!< 0xFF000000 */
#define FMC_PMEM_MEMHIZ           FMC_PMEM_MEMHIZ_Msk                        /*!<MEMHIZ[7:0] bits (Common memory databus HiZ time) */
#define FMC_PMEM_MEMHIZ_0         (0x01UL << FMC_PMEM_MEMHIZ_Pos)             /*!< 0x01000000 */
#define FMC_PMEM_MEMHIZ_1         (0x02UL << FMC_PMEM_MEMHIZ_Pos)             /*!< 0x02000000 */
#define FMC_PMEM_MEMHIZ_2         (0x04UL << FMC_PMEM_MEMHIZ_Pos)             /*!< 0x04000000 */
#define FMC_PMEM_MEMHIZ_3         (0x08UL << FMC_PMEM_MEMHIZ_Pos)             /*!< 0x08000000 */
#define FMC_PMEM_MEMHIZ_4         (0x10UL << FMC_PMEM_MEMHIZ_Pos)             /*!< 0x10000000 */
#define FMC_PMEM_MEMHIZ_5         (0x20UL << FMC_PMEM_MEMHIZ_Pos)             /*!< 0x20000000 */
#define FMC_PMEM_MEMHIZ_6         (0x40UL << FMC_PMEM_MEMHIZ_Pos)             /*!< 0x40000000 */
#define FMC_PMEM_MEMHIZ_7         (0x80UL << FMC_PMEM_MEMHIZ_Pos)             /*!< 0x80000000 */

/******************  Bit definition for FMC_PATT register  ******************/
#define FMC_PATT_ATTSET_Pos       (0U)
#define FMC_PATT_ATTSET_Msk       (0xFFUL << FMC_PATT_ATTSET_Pos)            /*!< 0x000000FF */
#define FMC_PATT_ATTSET           FMC_PATT_ATTSET_Msk                        /*!<ATTSET[7:0] bits (Attribute memory setup time) */
#define FMC_PATT_ATTSET_0         (0x01UL << FMC_PATT_ATTSET_Pos)             /*!< 0x00000001 */
#define FMC_PATT_ATTSET_1         (0x02UL << FMC_PATT_ATTSET_Pos)             /*!< 0x00000002 */
#define FMC_PATT_ATTSET_2         (0x04UL << FMC_PATT_ATTSET_Pos)             /*!< 0x00000004 */
#define FMC_PATT_ATTSET_3         (0x08UL << FMC_PATT_ATTSET_Pos)             /*!< 0x00000008 */
#define FMC_PATT_ATTSET_4         (0x10UL << FMC_PATT_ATTSET_Pos)             /*!< 0x00000010 */
#define FMC_PATT_ATTSET_5         (0x20UL << FMC_PATT_ATTSET_Pos)             /*!< 0x00000020 */
#define FMC_PATT_ATTSET_6         (0x40UL << FMC_PATT_ATTSET_Pos)             /*!< 0x00000040 */
#define FMC_PATT_ATTSET_7         (0x80UL << FMC_PATT_ATTSET_Pos)             /*!< 0x00000080 */

#define FMC_PATT_ATTWAIT_Pos      (8U)
#define FMC_PATT_ATTWAIT_Msk      (0xFFUL << FMC_PATT_ATTWAIT_Pos)           /*!< 0x0000FF00 */
#define FMC_PATT_ATTWAIT          FMC_PATT_ATTWAIT_Msk                       /*!<ATTWAIT[7:0] bits (Attribute memory wait time) */
#define FMC_PATT_ATTWAIT_0        (0x01UL << FMC_PATT_ATTWAIT_Pos)            /*!< 0x00000100 */
#define FMC_PATT_ATTWAIT_1        (0x02UL << FMC_PATT_ATTWAIT_Pos)            /*!< 0x00000200 */
#define FMC_PATT_ATTWAIT_2        (0x04UL << FMC_PATT_ATTWAIT_Pos)            /*!< 0x00000400 */
#define FMC_PATT_ATTWAIT_3        (0x08UL << FMC_PATT_ATTWAIT_Pos)            /*!< 0x00000800 */
#define FMC_PATT_ATTWAIT_4        (0x10UL << FMC_PATT_ATTWAIT_Pos)            /*!< 0x00001000 */
#define FMC_PATT_ATTWAIT_5        (0x20UL << FMC_PATT_ATTWAIT_Pos)            /*!< 0x00002000 */
#define FMC_PATT_ATTWAIT_6        (0x40UL << FMC_PATT_ATTWAIT_Pos)            /*!< 0x00004000 */
#define FMC_PATT_ATTWAIT_7        (0x80UL << FMC_PATT_ATTWAIT_Pos)            /*!< 0x00008000 */

#define FMC_PATT_ATTHOLD_Pos      (16U)
#define FMC_PATT_ATTHOLD_Msk      (0xFFUL << FMC_PATT_ATTHOLD_Pos)           /*!< 0x00FF0000 */
#define FMC_PATT_ATTHOLD          FMC_PATT_ATTHOLD_Msk                       /*!<ATTHOLD[7:0] bits (Attribute memory hold time) */
#define FMC_PATT_ATTHOLD_0        (0x01UL << FMC_PATT_ATTHOLD_Pos)            /*!< 0x00010000 */
#define FMC_PATT_ATTHOLD_1        (0x02UL << FMC_PATT_ATTHOLD_Pos)            /*!< 0x00020000 */
#define FMC_PATT_ATTHOLD_2        (0x04UL << FMC_PATT_ATTHOLD_Pos)            /*!< 0x00040000 */
#define FMC_PATT_ATTHOLD_3        (0x08UL << FMC_PATT_ATTHOLD_Pos)            /*!< 0x00080000 */
#define FMC_PATT_ATTHOLD_4        (0x10UL << FMC_PATT_ATTHOLD_Pos)            /*!< 0x00100000 */
#define FMC_PATT_ATTHOLD_5        (0x20UL << FMC_PATT_ATTHOLD_Pos)            /*!< 0x00200000 */
#define FMC_PATT_ATTHOLD_6        (0x40UL << FMC_PATT_ATTHOLD_Pos)            /*!< 0x00400000 */
#define FMC_PATT_ATTHOLD_7        (0x80UL << FMC_PATT_ATTHOLD_Pos)            /*!< 0x00800000 */

#define FMC_PATT_ATTHIZ_Pos       (24U)
#define FMC_PATT_ATTHIZ_Msk       (0xFFUL << FMC_PATT_ATTHIZ_Pos)            /*!< 0xFF000000 */
#define FMC_PATT_ATTHIZ           FMC_PATT_ATTHIZ_Msk                        /*!<ATTHIZ[7:0] bits (Attribute memory databus HiZ time) */
#define FMC_PATT_ATTHIZ_0         (0x01UL << FMC_PATT_ATTHIZ_Pos)             /*!< 0x01000000 */
#define FMC_PATT_ATTHIZ_1         (0x02UL << FMC_PATT_ATTHIZ_Pos)             /*!< 0x02000000 */
#define FMC_PATT_ATTHIZ_2         (0x04UL << FMC_PATT_ATTHIZ_Pos)             /*!< 0x04000000 */
#define FMC_PATT_ATTHIZ_3         (0x08UL << FMC_PATT_ATTHIZ_Pos)             /*!< 0x08000000 */
#define FMC_PATT_ATTHIZ_4         (0x10UL << FMC_PATT_ATTHIZ_Pos)             /*!< 0x10000000 */
#define FMC_PATT_ATTHIZ_5         (0x20UL << FMC_PATT_ATTHIZ_Pos)             /*!< 0x20000000 */
#define FMC_PATT_ATTHIZ_6         (0x40UL << FMC_PATT_ATTHIZ_Pos)             /*!< 0x40000000 */
#define FMC_PATT_ATTHIZ_7         (0x80UL << FMC_PATT_ATTHIZ_Pos)             /*!< 0x80000000 */

/******************  Bit definition for FMC_ECCR3 register  ******************/
#define FMC_ECCR3_ECC3_Pos         (0U)
#define FMC_ECCR3_ECC3_Msk         (0xFFFFFFFFUL << FMC_ECCR3_ECC3_Pos)        /*!< 0xFFFFFFFF */
#define FMC_ECCR3_ECC3             FMC_ECCR3_ECC3_Msk                          /*!<ECC result */

/******************  Bit definition for FMC_SDCRx registers (x=1..4)  *********/
#define FMC_SDCRx_NC_Pos           (0U)
#define FMC_SDCRx_NC_Msk           (0x3UL << FMC_SDCRx_NC_Pos)                 /*!< 0x00000003 */
#define FMC_SDCRx_NC               FMC_SDCRx_NC_Msk                            /*!<NC[1:0] bits (Number of column bits) */
#define FMC_SDCRx_NC_0             (0x1UL << FMC_SDCRx_NC_Pos)                  /*!< 0x00000001 */
#define FMC_SDCRx_NC_1             (0x2UL << FMC_SDCRx_NC_Pos)                  /*!< 0x00000002 */

#define FMC_SDCRx_NR_Pos           (2U)
#define FMC_SDCRx_NR_Msk           (0x3UL << FMC_SDCRx_NR_Pos)                 /*!< 0x0000000C */
#define FMC_SDCRx_NR               FMC_SDCRx_NR_Msk                            /*!<NR[1:0] bits (Number of row bits) */
#define FMC_SDCRx_NR_0             (0x1UL << FMC_SDCRx_NR_Pos)                  /*!< 0x00000004 */
#define FMC_SDCRx_NR_1             (0x2UL << FMC_SDCRx_NR_Pos)                  /*!< 0x00000008 */

#define FMC_SDCRx_MWID_Pos         (4U)
#define FMC_SDCRx_MWID_Msk         (0x3UL << FMC_SDCRx_MWID_Pos)               /*!< 0x00000030 */
#define FMC_SDCRx_MWID             FMC_SDCRx_MWID_Msk                          /*!<NR[1:0] bits (Number of row bits) */
#define FMC_SDCRx_MWID_0           (0x1UL << FMC_SDCRx_MWID_Pos)                /*!< 0x00000010 */
#define FMC_SDCRx_MWID_1           (0x2UL << FMC_SDCRx_MWID_Pos)                /*!< 0x00000020 */

#define FMC_SDCRx_NB_Pos           (6U)
#define FMC_SDCRx_NB_Msk           (0x1UL << FMC_SDCRx_NB_Pos)                 /*!< 0x00000040 */
#define FMC_SDCRx_NB               FMC_SDCRx_NB_Msk                            /*!<Number of internal bank */

#define FMC_SDCRx_CAS_Pos          (7U)
#define FMC_SDCRx_CAS_Msk          (0x3UL << FMC_SDCRx_CAS_Pos)                /*!< 0x00000180 */
#define FMC_SDCRx_CAS              FMC_SDCRx_CAS_Msk                           /*!<CAS[1:0] bits (CAS latency) */
#define FMC_SDCRx_CAS_0            (0x1UL << FMC_SDCRx_CAS_Pos)                 /*!< 0x00000080 */
#define FMC_SDCRx_CAS_1            (0x2UL << FMC_SDCRx_CAS_Pos)                 /*!< 0x00000100 */

#define FMC_SDCRx_WP_Pos           (9U)
#define FMC_SDCRx_WP_Msk           (0x1UL << FMC_SDCRx_WP_Pos)                 /*!< 0x00000200 */
#define FMC_SDCRx_WP               FMC_SDCRx_WP_Msk                            /*!<Write protection */

#define FMC_SDCRx_SDCLK_Pos        (10U)
#define FMC_SDCRx_SDCLK_Msk        (0x3UL << FMC_SDCRx_SDCLK_Pos)              /*!< 0x00000C00 */
#define FMC_SDCRx_SDCLK            FMC_SDCRx_SDCLK_Msk                         /*!<SDRAM clock configuration */
#define FMC_SDCRx_SDCLK_0          (0x1UL << FMC_SDCRx_SDCLK_Pos)               /*!< 0x00000400 */
#define FMC_SDCRx_SDCLK_1          (0x2UL << FMC_SDCRx_SDCLK_Pos)               /*!< 0x00000800 */

#define FMC_SDCRx_RBURST_Pos       (12U)
#define FMC_SDCRx_RBURST_Msk       (0x1UL << FMC_SDCRx_RBURST_Pos)             /*!< 0x00001000 */
#define FMC_SDCRx_RBURST           FMC_SDCRx_RBURST_Msk                        /*!<Read burst */

#define FMC_SDCRx_RPIPE_Pos        (13U)
#define FMC_SDCRx_RPIPE_Msk        (0x3UL << FMC_SDCRx_RPIPE_Pos)              /*!< 0x00006000 */
#define FMC_SDCRx_RPIPE            FMC_SDCRx_RPIPE_Msk                         /*!<Write protection */
#define FMC_SDCRx_RPIPE_0          (0x1UL << FMC_SDCRx_RPIPE_Pos)               /*!< 0x00002000 */
#define FMC_SDCRx_RPIPE_1          (0x2UL << FMC_SDCRx_RPIPE_Pos)               /*!< 0x00004000 */

/******************  Bit definition for FMC_SDTRx(1,2) register  ******************/
#define FMC_SDTRx_TMRD_Pos         (0U)
#define FMC_SDTRx_TMRD_Msk         (0xFUL << FMC_SDTRx_TMRD_Pos)               /*!< 0x0000000F */
#define FMC_SDTRx_TMRD             FMC_SDTRx_TMRD_Msk                          /*!<TMRD[3:0] bits (Load mode register to active) */
#define FMC_SDTRx_TMRD_0           (0x1UL << FMC_SDTRx_TMRD_Pos)                /*!< 0x00000001 */
#define FMC_SDTRx_TMRD_1           (0x2UL << FMC_SDTRx_TMRD_Pos)                /*!< 0x00000002 */
#define FMC_SDTRx_TMRD_2           (0x4UL << FMC_SDTRx_TMRD_Pos)                /*!< 0x00000004 */
#define FMC_SDTRx_TMRD_3           (0x8UL << FMC_SDTRx_TMRD_Pos)                /*!< 0x00000008 */

#define FMC_SDTRx_TXSR_Pos         (4U)
#define FMC_SDTRx_TXSR_Msk         (0xFUL << FMC_SDTRx_TXSR_Pos)               /*!< 0x000000F0 */
#define FMC_SDTRx_TXSR             FMC_SDTRx_TXSR_Msk                          /*!<TXSR[3:0] bits (Exit self refresh) */
#define FMC_SDTRx_TXSR_0           (0x1UL << FMC_SDTRx_TXSR_Pos)                /*!< 0x00000010 */
#define FMC_SDTRx_TXSR_1           (0x2UL << FMC_SDTRx_TXSR_Pos)                /*!< 0x00000020 */
#define FMC_SDTRx_TXSR_2           (0x4UL << FMC_SDTRx_TXSR_Pos)                /*!< 0x00000040 */
#define FMC_SDTRx_TXSR_3           (0x8UL << FMC_SDTRx_TXSR_Pos)                /*!< 0x00000080 */

#define FMC_SDTRx_TRAS_Pos         (8U)
#define FMC_SDTRx_TRAS_Msk         (0xFUL << FMC_SDTRx_TRAS_Pos)               /*!< 0x00000F00 */
#define FMC_SDTRx_TRAS             FMC_SDTRx_TRAS_Msk                          /*!<TRAS[3:0] bits (Self refresh time) */
#define FMC_SDTRx_TRAS_0           (0x1UL << FMC_SDTRx_TRAS_Pos)                /*!< 0x00000100 */
#define FMC_SDTRx_TRAS_1           (0x2UL << FMC_SDTRx_TRAS_Pos)                /*!< 0x00000200 */
#define FMC_SDTRx_TRAS_2           (0x4UL << FMC_SDTRx_TRAS_Pos)                /*!< 0x00000400 */
#define FMC_SDTRx_TRAS_3           (0x8UL << FMC_SDTRx_TRAS_Pos)                /*!< 0x00000800 */

#define FMC_SDTRx_TRC_Pos          (12U)
#define FMC_SDTRx_TRC_Msk          (0xFUL << FMC_SDTRx_TRC_Pos)                /*!< 0x0000F000 */
#define FMC_SDTRx_TRC              FMC_SDTRx_TRC_Msk                           /*!<TRC[2:0] bits (Row cycle delay) */
#define FMC_SDTRx_TRC_0            (0x1UL << FMC_SDTRx_TRC_Pos)                 /*!< 0x00001000 */
#define FMC_SDTRx_TRC_1            (0x2UL << FMC_SDTRx_TRC_Pos)                 /*!< 0x00002000 */
#define FMC_SDTRx_TRC_2            (0x4UL << FMC_SDTRx_TRC_Pos)                 /*!< 0x00004000 */

#define FMC_SDTRx_TWR_Pos          (16U)
#define FMC_SDTRx_TWR_Msk          (0xFUL << FMC_SDTRx_TWR_Pos)                /*!< 0x000F0000 */
#define FMC_SDTRx_TWR              FMC_SDTRx_TWR_Msk                           /*!<TRC[2:0] bits (Write recovery delay) */
#define FMC_SDTRx_TWR_0            (0x1UL << FMC_SDTRx_TWR_Pos)                 /*!< 0x00010000 */
#define FMC_SDTRx_TWR_1            (0x2UL << FMC_SDTRx_TWR_Pos)                 /*!< 0x00020000 */
#define FMC_SDTRx_TWR_2            (0x4UL << FMC_SDTRx_TWR_Pos)                 /*!< 0x00040000 */

#define FMC_SDTRx_TRP_Pos          (20U)
#define FMC_SDTRx_TRP_Msk          (0xFUL << FMC_SDTRx_TRP_Pos)                /*!< 0x00F00000 */
#define FMC_SDTRx_TRP              FMC_SDTRx_TRP_Msk                           /*!<TRP[2:0] bits (Row precharge delay) */
#define FMC_SDTRx_TRP_0            (0x1UL << FMC_SDTRx_TRP_Pos)                 /*!< 0x00100000 */
#define FMC_SDTRx_TRP_1            (0x2UL << FMC_SDTRx_TRP_Pos)                 /*!< 0x00200000 */
#define FMC_SDTRx_TRP_2            (0x4UL << FMC_SDTRx_TRP_Pos)                 /*!< 0x00400000 */

#define FMC_SDTRx_TRCD_Pos         (24U)
#define FMC_SDTRx_TRCD_Msk         (0xFUL << FMC_SDTRx_TRCD_Pos)               /*!< 0x0F000000 */
#define FMC_SDTRx_TRCD             FMC_SDTRx_TRCD_Msk                          /*!<TRP[2:0] bits (Row to column delay) */
#define FMC_SDTRx_TRCD_0           (0x1UL << FMC_SDTRx_TRCD_Pos)                /*!< 0x01000000 */
#define FMC_SDTRx_TRCD_1           (0x2UL << FMC_SDTRx_TRCD_Pos)                /*!< 0x02000000 */
#define FMC_SDTRx_TRCD_2           (0x4UL << FMC_SDTRx_TRCD_Pos)                /*!< 0x04000000 */

/******************  Bit definition for FMC_SDCMR register  ******************/
#define FMC_SDCMR_MODE_Pos         (0U)
#define FMC_SDCMR_MODE_Msk         (0x7UL << FMC_SDCMR_MODE_Pos)               /*!< 0x00000007 */
#define FMC_SDCMR_MODE             FMC_SDCMR_MODE_Msk                          /*!<MODE[2:0] bits (Command mode) */
#define FMC_SDCMR_MODE_0           (0x1UL << FMC_SDCMR_MODE_Pos)                /*!< 0x00000001 */
#define FMC_SDCMR_MODE_1           (0x2UL << FMC_SDCMR_MODE_Pos)                /*!< 0x00000002 */
#define FMC_SDCMR_MODE_2           (0x3UL << FMC_SDCMR_MODE_Pos)                /*!< 0x00000003 */

#define FMC_SDCMR_CTB2_Pos         (3U)
#define FMC_SDCMR_CTB2_Msk         (0x1UL << FMC_SDCMR_CTB2_Pos)               /*!< 0x00000008 */
#define FMC_SDCMR_CTB2             FMC_SDCMR_CTB2_Msk                          /*!<Command target 2 */

#define FMC_SDCMR_CTB1_Pos         (4U)
#define FMC_SDCMR_CTB1_Msk         (0x1UL << FMC_SDCMR_CTB1_Pos)               /*!< 0x00000010 */
#define FMC_SDCMR_CTB1             FMC_SDCMR_CTB1_Msk                          /*!<Command target 1 */

#define FMC_SDCMR_NRFS_Pos         (5U)
#define FMC_SDCMR_NRFS_Msk         (0xFUL << FMC_SDCMR_NRFS_Pos)               /*!< 0x000001E0 */
#define FMC_SDCMR_NRFS             FMC_SDCMR_NRFS_Msk                          /*!<NRFS[3:0] bits (Number of auto-refresh) */
#define FMC_SDCMR_NRFS_0           (0x1UL << FMC_SDCMR_NRFS_Pos)                /*!< 0x00000020 */
#define FMC_SDCMR_NRFS_1           (0x2UL << FMC_SDCMR_NRFS_Pos)                /*!< 0x00000040 */
#define FMC_SDCMR_NRFS_2           (0x4UL << FMC_SDCMR_NRFS_Pos)                /*!< 0x00000080 */
#define FMC_SDCMR_NRFS_3           (0x8UL << FMC_SDCMR_NRFS_Pos)                /*!< 0x00000100 */

#define FMC_SDCMR_MRD_Pos          (9U)
#define FMC_SDCMR_MRD_Msk          (0x1FFFUL << FMC_SDCMR_MRD_Pos)             /*!< 0x003FFE00 */
#define FMC_SDCMR_MRD              FMC_SDCMR_MRD_Msk                           /*!<MRD[12:0] bits (Mode register definition) */

/******************  Bit definition for FMC_SDRTR register  ******************/
#define FMC_SDRTR_CRE_Pos          (0U)
#define FMC_SDRTR_CRE_Msk          (0x1UL << FMC_SDRTR_CRE_Pos)                /*!< 0x00000001 */
#define FMC_SDRTR_CRE              FMC_SDRTR_CRE_Msk                           /*!<Clear refresh error flag */

#define FMC_SDRTR_COUNT_Pos        (1U)
#define FMC_SDRTR_COUNT_Msk        (0x1FFFUL << FMC_SDRTR_COUNT_Pos)           /*!< 0x00003FFE */
#define FMC_SDRTR_COUNT            FMC_SDRTR_COUNT_Msk                         /*!<COUNT[12:0] bits (Refresh timer count) */

#define FMC_SDRTR_REIE_Pos         (14U)
#define FMC_SDRTR_REIE_Msk         (0x1UL << FMC_SDRTR_REIE_Pos)               /*!< 0x00004000 */
#define FMC_SDRTR_REIE             FMC_SDRTR_REIE_Msk                          /*!<RES interupt enable */

/******************  Bit definition for FMC_SDSR register  ******************/
#define FMC_SDSR_RE_Pos            (0U)
#define FMC_SDSR_RE_Msk            (0x1UL << FMC_SDSR_RE_Pos)                  /*!< 0x00000001 */
#define FMC_SDSR_RE                FMC_SDSR_RE_Msk                             /*!<Refresh error flag */

#define FMC_SDSR_MODES1_Pos        (1U)
#define FMC_SDSR_MODES1_Msk        (0x3UL << FMC_SDSR_MODES1_Pos)              /*!< 0x00000006 */
#define FMC_SDSR_MODES1            FMC_SDSR_MODES1_Msk                         /*!<MODES1[1:0]bits (Status mode for bank 1) */
#define FMC_SDSR_MODES1_0          (0x1UL << FMC_SDSR_MODES1_Pos)               /*!< 0x00000002 */
#define FMC_SDSR_MODES1_1          (0x2UL << FMC_SDSR_MODES1_Pos)               /*!< 0x00000004 */

#define FMC_SDSR_MODES2_Pos        (3U)
#define FMC_SDSR_MODES2_Msk        (0x3UL << FMC_SDSR_MODES2_Pos)              /*!< 0x00000018 */
#define FMC_SDSR_MODES2            FMC_SDSR_MODES2_Msk                         /*!<MODES2[1:0]bits (Status mode for bank 2) */
#define FMC_SDSR_MODES2_0          (0x1UL << FMC_SDSR_MODES2_Pos)               /*!< 0x00000008 */
#define FMC_SDSR_MODES2_1          (0x2UL << FMC_SDSR_MODES2_Pos)               /*!< 0x00000010 */

/******************************************************************************/
/*                                                                            */
/*                            General Purpose I/O                             */
/*                                                                            */
/******************************************************************************/
/******************  Bits definition for GPIO_MODER register  *****************/
#define GPIO_MODER_MODE0_Pos           (0U)
#define GPIO_MODER_MODE0_Msk           (0x3UL << GPIO_MODER_MODE0_Pos)         /*!< 0x00000003 */
#define GPIO_MODER_MODE0               GPIO_MODER_MODE0_Msk
#define GPIO_MODER_MODE0_0             (0x1UL << GPIO_MODER_MODE0_Pos)          /*!< 0x00000001 */
#define GPIO_MODER_MODE0_1             (0x2UL << GPIO_MODER_MODE0_Pos)          /*!< 0x00000002 */

#define GPIO_MODER_MODE1_Pos           (2U)
#define GPIO_MODER_MODE1_Msk           (0x3UL << GPIO_MODER_MODE1_Pos)         /*!< 0x0000000C */
#define GPIO_MODER_MODE1               GPIO_MODER_MODE1_Msk
#define GPIO_MODER_MODE1_0             (0x1UL << GPIO_MODER_MODE1_Pos)          /*!< 0x00000004 */
#define GPIO_MODER_MODE1_1             (0x2UL << GPIO_MODER_MODE1_Pos)          /*!< 0x00000008 */

#define GPIO_MODER_MODE2_Pos           (4U)
#define GPIO_MODER_MODE2_Msk           (0x3UL << GPIO_MODER_MODE2_Pos)         /*!< 0x00000030 */
#define GPIO_MODER_MODE2               GPIO_MODER_MODE2_Msk
#define GPIO_MODER_MODE2_0             (0x1UL << GPIO_MODER_MODE2_Pos)          /*!< 0x00000010 */
#define GPIO_MODER_MODE2_1             (0x2UL << GPIO_MODER_MODE2_Pos)          /*!< 0x00000020 */

#define GPIO_MODER_MODE3_Pos           (6U)
#define GPIO_MODER_MODE3_Msk           (0x3UL << GPIO_MODER_MODE3_Pos)         /*!< 0x000000C0 */
#define GPIO_MODER_MODE3               GPIO_MODER_MODE3_Msk
#define GPIO_MODER_MODE3_0             (0x1UL << GPIO_MODER_MODE3_Pos)          /*!< 0x00000040 */
#define GPIO_MODER_MODE3_1             (0x2UL << GPIO_MODER_MODE3_Pos)          /*!< 0x00000080 */

#define GPIO_MODER_MODE4_Pos           (8U)
#define GPIO_MODER_MODE4_Msk           (0x3UL << GPIO_MODER_MODE4_Pos)         /*!< 0x00000300 */
#define GPIO_MODER_MODE4               GPIO_MODER_MODE4_Msk
#define GPIO_MODER_MODE4_0             (0x1UL << GPIO_MODER_MODE4_Pos)          /*!< 0x00000100 */
#define GPIO_MODER_MODE4_1             (0x2UL << GPIO_MODER_MODE4_Pos)          /*!< 0x00000200 */

#define GPIO_MODER_MODE5_Pos           (10U)
#define GPIO_MODER_MODE5_Msk           (0x3UL << GPIO_MODER_MODE5_Pos)         /*!< 0x00000C00 */
#define GPIO_MODER_MODE5               GPIO_MODER_MODE5_Msk
#define GPIO_MODER_MODE5_0             (0x1UL << GPIO_MODER_MODE5_Pos)          /*!< 0x00000400 */
#define GPIO_MODER_MODE5_1             (0x2UL << GPIO_MODER_MODE5_Pos)          /*!< 0x00000800 */

#define GPIO_MODER_MODE6_Pos           (12U)
#define GPIO_MODER_MODE6_Msk           (0x3UL << GPIO_MODER_MODE6_Pos)         /*!< 0x00003000 */
#define GPIO_MODER_MODE6               GPIO_MODER_MODE6_Msk
#define GPIO_MODER_MODE6_0             (0x1UL << GPIO_MODER_MODE6_Pos)          /*!< 0x00001000 */
#define GPIO_MODER_MODE6_1             (0x2UL << GPIO_MODER_MODE6_Pos)          /*!< 0x00002000 */

#define GPIO_MODER_MODE7_Pos           (14U)
#define GPIO_MODER_MODE7_Msk           (0x3UL << GPIO_MODER_MODE7_Pos)         /*!< 0x0000C000 */
#define GPIO_MODER_MODE7               GPIO_MODER_MODE7_Msk
#define GPIO_MODER_MODE7_0             (0x1UL << GPIO_MODER_MODE7_Pos)          /*!< 0x00004000 */
#define GPIO_MODER_MODE7_1             (0x2UL << GPIO_MODER_MODE7_Pos)          /*!< 0x00008000 */

#define GPIO_MODER_MODE8_Pos           (16U)
#define GPIO_MODER_MODE8_Msk           (0x3UL << GPIO_MODER_MODE8_Pos)         /*!< 0x00030000 */
#define GPIO_MODER_MODE8               GPIO_MODER_MODE8_Msk
#define GPIO_MODER_MODE8_0             (0x1UL << GPIO_MODER_MODE8_Pos)          /*!< 0x00010000 */
#define GPIO_MODER_MODE8_1             (0x2UL << GPIO_MODER_MODE8_Pos)          /*!< 0x00020000 */

#define GPIO_MODER_MODE9_Pos           (18U)
#define GPIO_MODER_MODE9_Msk           (0x3UL << GPIO_MODER_MODE9_Pos)         /*!< 0x000C0000 */
#define GPIO_MODER_MODE9               GPIO_MODER_MODE9_Msk
#define GPIO_MODER_MODE9_0             (0x1UL << GPIO_MODER_MODE9_Pos)          /*!< 0x00040000 */
#define GPIO_MODER_MODE9_1             (0x2UL << GPIO_MODER_MODE9_Pos)          /*!< 0x00080000 */

#define GPIO_MODER_MODE10_Pos          (20U)
#define GPIO_MODER_MODE10_Msk          (0x3UL << GPIO_MODER_MODE10_Pos)        /*!< 0x00300000 */
#define GPIO_MODER_MODE10              GPIO_MODER_MODE10_Msk
#define GPIO_MODER_MODE10_0            (0x1UL << GPIO_MODER_MODE10_Pos)         /*!< 0x00100000 */
#define GPIO_MODER_MODE10_1            (0x2UL << GPIO_MODER_MODE10_Pos)         /*!< 0x00200000 */

#define GPIO_MODER_MODE11_Pos          (22U)
#define GPIO_MODER_MODE11_Msk          (0x3UL << GPIO_MODER_MODE11_Pos)        /*!< 0x00C00000 */
#define GPIO_MODER_MODE11              GPIO_MODER_MODE11_Msk
#define GPIO_MODER_MODE11_0            (0x1UL << GPIO_MODER_MODE11_Pos)         /*!< 0x00400000 */
#define GPIO_MODER_MODE11_1            (0x2UL << GPIO_MODER_MODE11_Pos)         /*!< 0x00800000 */

#define GPIO_MODER_MODE12_Pos          (24U)
#define GPIO_MODER_MODE12_Msk          (0x3UL << GPIO_MODER_MODE12_Pos)        /*!< 0x03000000 */
#define GPIO_MODER_MODE12              GPIO_MODER_MODE12_Msk
#define GPIO_MODER_MODE12_0            (0x1UL << GPIO_MODER_MODE12_Pos)         /*!< 0x01000000 */
#define GPIO_MODER_MODE12_1            (0x2UL << GPIO_MODER_MODE12_Pos)         /*!< 0x02000000 */

#define GPIO_MODER_MODE13_Pos          (26U)
#define GPIO_MODER_MODE13_Msk          (0x3UL << GPIO_MODER_MODE13_Pos)        /*!< 0x0C000000 */
#define GPIO_MODER_MODE13              GPIO_MODER_MODE13_Msk
#define GPIO_MODER_MODE13_0            (0x1UL << GPIO_MODER_MODE13_Pos)         /*!< 0x04000000 */
#define GPIO_MODER_MODE13_1            (0x2UL << GPIO_MODER_MODE13_Pos)         /*!< 0x08000000 */

#define GPIO_MODER_MODE14_Pos          (28U)
#define GPIO_MODER_MODE14_Msk          (0x3UL << GPIO_MODER_MODE14_Pos)        /*!< 0x30000000 */
#define GPIO_MODER_MODE14              GPIO_MODER_MODE14_Msk
#define GPIO_MODER_MODE14_0            (0x1UL << GPIO_MODER_MODE14_Pos)         /*!< 0x10000000 */
#define GPIO_MODER_MODE14_1            (0x2UL << GPIO_MODER_MODE14_Pos)         /*!< 0x20000000 */

#define GPIO_MODER_MODE15_Pos          (30U)
#define GPIO_MODER_MODE15_Msk          (0x3UL << GPIO_MODER_MODE15_Pos)        /*!< 0xC0000000 */
#define GPIO_MODER_MODE15              GPIO_MODER_MODE15_Msk
#define GPIO_MODER_MODE15_0            (0x1UL << GPIO_MODER_MODE15_Pos)         /*!< 0x40000000 */
#define GPIO_MODER_MODE15_1            (0x2UL << GPIO_MODER_MODE15_Pos)         /*!< 0x80000000 */

/******************  Bits definition for GPIO_OTYPER register  ****************/
#define GPIO_OTYPER_OT0_Pos            (0U)
#define GPIO_OTYPER_OT0_Msk            (0x1UL << GPIO_OTYPER_OT0_Pos)          /*!< 0x00000001 */
#define GPIO_OTYPER_OT0                GPIO_OTYPER_OT0_Msk
#define GPIO_OTYPER_OT1_Pos            (1U)
#define GPIO_OTYPER_OT1_Msk            (0x1UL << GPIO_OTYPER_OT1_Pos)          /*!< 0x00000002 */
#define GPIO_OTYPER_OT1                GPIO_OTYPER_OT1_Msk
#define GPIO_OTYPER_OT2_Pos            (2U)
#define GPIO_OTYPER_OT2_Msk            (0x1UL << GPIO_OTYPER_OT2_Pos)          /*!< 0x00000004 */
#define GPIO_OTYPER_OT2                GPIO_OTYPER_OT2_Msk
#define GPIO_OTYPER_OT3_Pos            (3U)
#define GPIO_OTYPER_OT3_Msk            (0x1UL << GPIO_OTYPER_OT3_Pos)          /*!< 0x00000008 */
#define GPIO_OTYPER_OT3                GPIO_OTYPER_OT3_Msk
#define GPIO_OTYPER_OT4_Pos            (4U)
#define GPIO_OTYPER_OT4_Msk            (0x1UL << GPIO_OTYPER_OT4_Pos)          /*!< 0x00000010 */
#define GPIO_OTYPER_OT4                GPIO_OTYPER_OT4_Msk
#define GPIO_OTYPER_OT5_Pos            (5U)
#define GPIO_OTYPER_OT5_Msk            (0x1UL << GPIO_OTYPER_OT5_Pos)          /*!< 0x00000020 */
#define GPIO_OTYPER_OT5                GPIO_OTYPER_OT5_Msk
#define GPIO_OTYPER_OT6_Pos            (6U)
#define GPIO_OTYPER_OT6_Msk            (0x1UL << GPIO_OTYPER_OT6_Pos)          /*!< 0x00000040 */
#define GPIO_OTYPER_OT6                GPIO_OTYPER_OT6_Msk
#define GPIO_OTYPER_OT7_Pos            (7U)
#define GPIO_OTYPER_OT7_Msk            (0x1UL << GPIO_OTYPER_OT7_Pos)          /*!< 0x00000080 */
#define GPIO_OTYPER_OT7                GPIO_OTYPER_OT7_Msk
#define GPIO_OTYPER_OT8_Pos            (8U)
#define GPIO_OTYPER_OT8_Msk            (0x1UL << GPIO_OTYPER_OT8_Pos)          /*!< 0x00000100 */
#define GPIO_OTYPER_OT8                GPIO_OTYPER_OT8_Msk
#define GPIO_OTYPER_OT9_Pos            (9U)
#define GPIO_OTYPER_OT9_Msk            (0x1UL << GPIO_OTYPER_OT9_Pos)          /*!< 0x00000200 */
#define GPIO_OTYPER_OT9                GPIO_OTYPER_OT9_Msk
#define GPIO_OTYPER_OT10_Pos           (10U)
#define GPIO_OTYPER_OT10_Msk           (0x1UL << GPIO_OTYPER_OT10_Pos)         /*!< 0x00000400 */
#define GPIO_OTYPER_OT10               GPIO_OTYPER_OT10_Msk
#define GPIO_OTYPER_OT11_Pos           (11U)
#define GPIO_OTYPER_OT11_Msk           (0x1UL << GPIO_OTYPER_OT11_Pos)         /*!< 0x00000800 */
#define GPIO_OTYPER_OT11               GPIO_OTYPER_OT11_Msk
#define GPIO_OTYPER_OT12_Pos           (12U)
#define GPIO_OTYPER_OT12_Msk           (0x1UL << GPIO_OTYPER_OT12_Pos)         /*!< 0x00001000 */
#define GPIO_OTYPER_OT12               GPIO_OTYPER_OT12_Msk
#define GPIO_OTYPER_OT13_Pos           (13U)
#define GPIO_OTYPER_OT13_Msk           (0x1UL << GPIO_OTYPER_OT13_Pos)         /*!< 0x00002000 */
#define GPIO_OTYPER_OT13               GPIO_OTYPER_OT13_Msk
#define GPIO_OTYPER_OT14_Pos           (14U)
#define GPIO_OTYPER_OT14_Msk           (0x1UL << GPIO_OTYPER_OT14_Pos)         /*!< 0x00004000 */
#define GPIO_OTYPER_OT14               GPIO_OTYPER_OT14_Msk
#define GPIO_OTYPER_OT15_Pos           (15U)
#define GPIO_OTYPER_OT15_Msk           (0x1UL << GPIO_OTYPER_OT15_Pos)         /*!< 0x00008000 */
#define GPIO_OTYPER_OT15               GPIO_OTYPER_OT15_Msk

/******************  Bits definition for GPIO_OSPEEDR register  ***************/
#define GPIO_OSPEEDR_OSPEED0_Pos       (0U)
#define GPIO_OSPEEDR_OSPEED0_Msk       (0x3UL << GPIO_OSPEEDR_OSPEED0_Pos)     /*!< 0x00000003 */
#define GPIO_OSPEEDR_OSPEED0           GPIO_OSPEEDR_OSPEED0_Msk
#define GPIO_OSPEEDR_OSPEED0_0         (0x1UL << GPIO_OSPEEDR_OSPEED0_Pos)      /*!< 0x00000001 */
#define GPIO_OSPEEDR_OSPEED0_1         (0x2UL << GPIO_OSPEEDR_OSPEED0_Pos)      /*!< 0x00000002 */

#define GPIO_OSPEEDR_OSPEED1_Pos       (2U)
#define GPIO_OSPEEDR_OSPEED1_Msk       (0x3UL << GPIO_OSPEEDR_OSPEED1_Pos)     /*!< 0x0000000C */
#define GPIO_OSPEEDR_OSPEED1           GPIO_OSPEEDR_OSPEED1_Msk
#define GPIO_OSPEEDR_OSPEED1_0         (0x1UL << GPIO_OSPEEDR_OSPEED1_Pos)      /*!< 0x00000004 */
#define GPIO_OSPEEDR_OSPEED1_1         (0x2UL << GPIO_OSPEEDR_OSPEED1_Pos)      /*!< 0x00000008 */

#define GPIO_OSPEEDR_OSPEED2_Pos       (4U)
#define GPIO_OSPEEDR_OSPEED2_Msk       (0x3UL << GPIO_OSPEEDR_OSPEED2_Pos)     /*!< 0x00000030 */
#define GPIO_OSPEEDR_OSPEED2           GPIO_OSPEEDR_OSPEED2_Msk
#define GPIO_OSPEEDR_OSPEED2_0         (0x1UL << GPIO_OSPEEDR_OSPEED2_Pos)      /*!< 0x00000010 */
#define GPIO_OSPEEDR_OSPEED2_1         (0x2UL << GPIO_OSPEEDR_OSPEED2_Pos)      /*!< 0x00000020 */

#define GPIO_OSPEEDR_OSPEED3_Pos       (6U)
#define GPIO_OSPEEDR_OSPEED3_Msk       (0x3UL << GPIO_OSPEEDR_OSPEED3_Pos)     /*!< 0x000000C0 */
#define GPIO_OSPEEDR_OSPEED3           GPIO_OSPEEDR_OSPEED3_Msk
#define GPIO_OSPEEDR_OSPEED3_0         (0x1UL << GPIO_OSPEEDR_OSPEED3_Pos)      /*!< 0x00000040 */
#define GPIO_OSPEEDR_OSPEED3_1         (0x2UL << GPIO_OSPEEDR_OSPEED3_Pos)      /*!< 0x00000080 */

#define GPIO_OSPEEDR_OSPEED4_Pos       (8U)
#define GPIO_OSPEEDR_OSPEED4_Msk       (0x3UL << GPIO_OSPEEDR_OSPEED4_Pos)     /*!< 0x00000300 */
#define GPIO_OSPEEDR_OSPEED4           GPIO_OSPEEDR_OSPEED4_Msk
#define GPIO_OSPEEDR_OSPEED4_0         (0x1UL << GPIO_OSPEEDR_OSPEED4_Pos)      /*!< 0x00000100 */
#define GPIO_OSPEEDR_OSPEED4_1         (0x2UL << GPIO_OSPEEDR_OSPEED4_Pos)      /*!< 0x00000200 */

#define GPIO_OSPEEDR_OSPEED5_Pos       (10U)
#define GPIO_OSPEEDR_OSPEED5_Msk       (0x3UL << GPIO_OSPEEDR_OSPEED5_Pos)     /*!< 0x00000C00 */
#define GPIO_OSPEEDR_OSPEED5           GPIO_OSPEEDR_OSPEED5_Msk
#define GPIO_OSPEEDR_OSPEED5_0         (0x1UL << GPIO_OSPEEDR_OSPEED5_Pos)      /*!< 0x00000400 */
#define GPIO_OSPEEDR_OSPEED5_1         (0x2UL << GPIO_OSPEEDR_OSPEED5_Pos)      /*!< 0x00000800 */

#define GPIO_OSPEEDR_OSPEED6_Pos       (12U)
#define GPIO_OSPEEDR_OSPEED6_Msk       (0x3UL << GPIO_OSPEEDR_OSPEED6_Pos)     /*!< 0x00003000 */
#define GPIO_OSPEEDR_OSPEED6           GPIO_OSPEEDR_OSPEED6_Msk
#define GPIO_OSPEEDR_OSPEED6_0         (0x1UL << GPIO_OSPEEDR_OSPEED6_Pos)      /*!< 0x00001000 */
#define GPIO_OSPEEDR_OSPEED6_1         (0x2UL << GPIO_OSPEEDR_OSPEED6_Pos)      /*!< 0x00002000 */

#define GPIO_OSPEEDR_OSPEED7_Pos       (14U)
#define GPIO_OSPEEDR_OSPEED7_Msk       (0x3UL << GPIO_OSPEEDR_OSPEED7_Pos)     /*!< 0x0000C000 */
#define GPIO_OSPEEDR_OSPEED7           GPIO_OSPEEDR_OSPEED7_Msk
#define GPIO_OSPEEDR_OSPEED7_0         (0x1UL << GPIO_OSPEEDR_OSPEED7_Pos)      /*!< 0x00004000 */
#define GPIO_OSPEEDR_OSPEED7_1         (0x2UL << GPIO_OSPEEDR_OSPEED7_Pos)      /*!< 0x00008000 */

#define GPIO_OSPEEDR_OSPEED8_Pos       (16U)
#define GPIO_OSPEEDR_OSPEED8_Msk       (0x3UL << GPIO_OSPEEDR_OSPEED8_Pos)     /*!< 0x00030000 */
#define GPIO_OSPEEDR_OSPEED8           GPIO_OSPEEDR_OSPEED8_Msk
#define GPIO_OSPEEDR_OSPEED8_0         (0x1UL << GPIO_OSPEEDR_OSPEED8_Pos)      /*!< 0x00010000 */
#define GPIO_OSPEEDR_OSPEED8_1         (0x2UL << GPIO_OSPEEDR_OSPEED8_Pos)      /*!< 0x00020000 */

#define GPIO_OSPEEDR_OSPEED9_Pos       (18U)
#define GPIO_OSPEEDR_OSPEED9_Msk       (0x3UL << GPIO_OSPEEDR_OSPEED9_Pos)     /*!< 0x000C0000 */
#define GPIO_OSPEEDR_OSPEED9           GPIO_OSPEEDR_OSPEED9_Msk
#define GPIO_OSPEEDR_OSPEED9_0         (0x1UL << GPIO_OSPEEDR_OSPEED9_Pos)      /*!< 0x00040000 */
#define GPIO_OSPEEDR_OSPEED9_1         (0x2UL << GPIO_OSPEEDR_OSPEED9_Pos)      /*!< 0x00080000 */

#define GPIO_OSPEEDR_OSPEED10_Pos      (20U)
#define GPIO_OSPEEDR_OSPEED10_Msk      (0x3UL << GPIO_OSPEEDR_OSPEED10_Pos)    /*!< 0x00300000 */
#define GPIO_OSPEEDR_OSPEED10          GPIO_OSPEEDR_OSPEED10_Msk
#define GPIO_OSPEEDR_OSPEED10_0        (0x1UL << GPIO_OSPEEDR_OSPEED10_Pos)     /*!< 0x00100000 */
#define GPIO_OSPEEDR_OSPEED10_1        (0x2UL << GPIO_OSPEEDR_OSPEED10_Pos)     /*!< 0x00200000 */

#define GPIO_OSPEEDR_OSPEED11_Pos      (22U)
#define GPIO_OSPEEDR_OSPEED11_Msk      (0x3UL << GPIO_OSPEEDR_OSPEED11_Pos)    /*!< 0x00C00000 */
#define GPIO_OSPEEDR_OSPEED11          GPIO_OSPEEDR_OSPEED11_Msk
#define GPIO_OSPEEDR_OSPEED11_0        (0x1UL << GPIO_OSPEEDR_OSPEED11_Pos)     /*!< 0x00400000 */
#define GPIO_OSPEEDR_OSPEED11_1        (0x2UL << GPIO_OSPEEDR_OSPEED11_Pos)     /*!< 0x00800000 */

#define GPIO_OSPEEDR_OSPEED12_Pos      (24U)
#define GPIO_OSPEEDR_OSPEED12_Msk      (0x3UL << GPIO_OSPEEDR_OSPEED12_Pos)    /*!< 0x03000000 */
#define GPIO_OSPEEDR_OSPEED12          GPIO_OSPEEDR_OSPEED12_Msk
#define GPIO_OSPEEDR_OSPEED12_0        (0x1UL << GPIO_OSPEEDR_OSPEED12_Pos)     /*!< 0x01000000 */
#define GPIO_OSPEEDR_OSPEED12_1        (0x2UL << GPIO_OSPEEDR_OSPEED12_Pos)     /*!< 0x02000000 */

#define GPIO_OSPEEDR_OSPEED13_Pos      (26U)
#define GPIO_OSPEEDR_OSPEED13_Msk      (0x3UL << GPIO_OSPEEDR_OSPEED13_Pos)    /*!< 0x0C000000 */
#define GPIO_OSPEEDR_OSPEED13          GPIO_OSPEEDR_OSPEED13_Msk
#define GPIO_OSPEEDR_OSPEED13_0        (0x1UL << GPIO_OSPEEDR_OSPEED13_Pos)     /*!< 0x04000000 */
#define GPIO_OSPEEDR_OSPEED13_1        (0x2UL << GPIO_OSPEEDR_OSPEED13_Pos)     /*!< 0x08000000 */

#define GPIO_OSPEEDR_OSPEED14_Pos      (28U)
#define GPIO_OSPEEDR_OSPEED14_Msk      (0x3UL << GPIO_OSPEEDR_OSPEED14_Pos)    /*!< 0x30000000 */
#define GPIO_OSPEEDR_OSPEED14          GPIO_OSPEEDR_OSPEED14_Msk
#define GPIO_OSPEEDR_OSPEED14_0        (0x1UL << GPIO_OSPEEDR_OSPEED14_Pos)     /*!< 0x10000000 */
#define GPIO_OSPEEDR_OSPEED14_1        (0x2UL << GPIO_OSPEEDR_OSPEED14_Pos)     /*!< 0x20000000 */

#define GPIO_OSPEEDR_OSPEED15_Pos      (30U)
#define GPIO_OSPEEDR_OSPEED15_Msk      (0x3UL << GPIO_OSPEEDR_OSPEED15_Pos)    /*!< 0xC0000000 */
#define GPIO_OSPEEDR_OSPEED15          GPIO_OSPEEDR_OSPEED15_Msk
#define GPIO_OSPEEDR_OSPEED15_0        (0x1UL << GPIO_OSPEEDR_OSPEED15_Pos)     /*!< 0x40000000 */
#define GPIO_OSPEEDR_OSPEED15_1        (0x2UL << GPIO_OSPEEDR_OSPEED15_Pos)     /*!< 0x80000000 */

/******************  Bits definition for GPIO_PUPDR register  *****************/
#define GPIO_PUPDR_PUPD0_Pos           (0U)
#define GPIO_PUPDR_PUPD0_Msk           (0x3UL << GPIO_PUPDR_PUPD0_Pos)         /*!< 0x00000003 */
#define GPIO_PUPDR_PUPD0               GPIO_PUPDR_PUPD0_Msk
#define GPIO_PUPDR_PUPD0_0             (0x1UL << GPIO_PUPDR_PUPD0_Pos)          /*!< 0x00000001 */
#define GPIO_PUPDR_PUPD0_1             (0x2UL << GPIO_PUPDR_PUPD0_Pos)          /*!< 0x00000002 */

#define GPIO_PUPDR_PUPD1_Pos           (2U)
#define GPIO_PUPDR_PUPD1_Msk           (0x3UL << GPIO_PUPDR_PUPD1_Pos)         /*!< 0x0000000C */
#define GPIO_PUPDR_PUPD1               GPIO_PUPDR_PUPD1_Msk
#define GPIO_PUPDR_PUPD1_0             (0x1UL << GPIO_PUPDR_PUPD1_Pos)          /*!< 0x00000004 */
#define GPIO_PUPDR_PUPD1_1             (0x2UL << GPIO_PUPDR_PUPD1_Pos)          /*!< 0x00000008 */

#define GPIO_PUPDR_PUPD2_Pos           (4U)
#define GPIO_PUPDR_PUPD2_Msk           (0x3UL << GPIO_PUPDR_PUPD2_Pos)         /*!< 0x00000030 */
#define GPIO_PUPDR_PUPD2               GPIO_PUPDR_PUPD2_Msk
#define GPIO_PUPDR_PUPD2_0             (0x1UL << GPIO_PUPDR_PUPD2_Pos)          /*!< 0x00000010 */
#define GPIO_PUPDR_PUPD2_1             (0x2UL << GPIO_PUPDR_PUPD2_Pos)          /*!< 0x00000020 */

#define GPIO_PUPDR_PUPD3_Pos           (6U)
#define GPIO_PUPDR_PUPD3_Msk           (0x3UL << GPIO_PUPDR_PUPD3_Pos)         /*!< 0x000000C0 */
#define GPIO_PUPDR_PUPD3               GPIO_PUPDR_PUPD3_Msk
#define GPIO_PUPDR_PUPD3_0             (0x1UL << GPIO_PUPDR_PUPD3_Pos)          /*!< 0x00000040 */
#define GPIO_PUPDR_PUPD3_1             (0x2UL << GPIO_PUPDR_PUPD3_Pos)          /*!< 0x00000080 */

#define GPIO_PUPDR_PUPD4_Pos           (8U)
#define GPIO_PUPDR_PUPD4_Msk           (0x3UL << GPIO_PUPDR_PUPD4_Pos)         /*!< 0x00000300 */
#define GPIO_PUPDR_PUPD4               GPIO_PUPDR_PUPD4_Msk
#define GPIO_PUPDR_PUPD4_0             (0x1UL << GPIO_PUPDR_PUPD4_Pos)          /*!< 0x00000100 */
#define GPIO_PUPDR_PUPD4_1             (0x2UL << GPIO_PUPDR_PUPD4_Pos)          /*!< 0x00000200 */

#define GPIO_PUPDR_PUPD5_Pos           (10U)
#define GPIO_PUPDR_PUPD5_Msk           (0x3UL << GPIO_PUPDR_PUPD5_Pos)         /*!< 0x00000C00 */
#define GPIO_PUPDR_PUPD5               GPIO_PUPDR_PUPD5_Msk
#define GPIO_PUPDR_PUPD5_0             (0x1UL << GPIO_PUPDR_PUPD5_Pos)          /*!< 0x00000400 */
#define GPIO_PUPDR_PUPD5_1             (0x2UL << GPIO_PUPDR_PUPD5_Pos)          /*!< 0x00000800 */

#define GPIO_PUPDR_PUPD6_Pos           (12U)
#define GPIO_PUPDR_PUPD6_Msk           (0x3UL << GPIO_PUPDR_PUPD6_Pos)         /*!< 0x00003000 */
#define GPIO_PUPDR_PUPD6               GPIO_PUPDR_PUPD6_Msk
#define GPIO_PUPDR_PUPD6_0             (0x1UL << GPIO_PUPDR_PUPD6_Pos)          /*!< 0x00001000 */
#define GPIO_PUPDR_PUPD6_1             (0x2UL << GPIO_PUPDR_PUPD6_Pos)          /*!< 0x00002000 */

#define GPIO_PUPDR_PUPD7_Pos           (14U)
#define GPIO_PUPDR_PUPD7_Msk           (0x3UL << GPIO_PUPDR_PUPD7_Pos)         /*!< 0x0000C000 */
#define GPIO_PUPDR_PUPD7               GPIO_PUPDR_PUPD7_Msk
#define GPIO_PUPDR_PUPD7_0             (0x1UL << GPIO_PUPDR_PUPD7_Pos)          /*!< 0x00004000 */
#define GPIO_PUPDR_PUPD7_1             (0x2UL << GPIO_PUPDR_PUPD7_Pos)          /*!< 0x00008000 */

#define GPIO_PUPDR_PUPD8_Pos           (16U)
#define GPIO_PUPDR_PUPD8_Msk           (0x3UL << GPIO_PUPDR_PUPD8_Pos)         /*!< 0x00030000 */
#define GPIO_PUPDR_PUPD8               GPIO_PUPDR_PUPD8_Msk
#define GPIO_PUPDR_PUPD8_0             (0x1UL << GPIO_PUPDR_PUPD8_Pos)          /*!< 0x00010000 */
#define GPIO_PUPDR_PUPD8_1             (0x2UL << GPIO_PUPDR_PUPD8_Pos)          /*!< 0x00020000 */

#define GPIO_PUPDR_PUPD9_Pos           (18U)
#define GPIO_PUPDR_PUPD9_Msk           (0x3UL << GPIO_PUPDR_PUPD9_Pos)         /*!< 0x000C0000 */
#define GPIO_PUPDR_PUPD9               GPIO_PUPDR_PUPD9_Msk
#define GPIO_PUPDR_PUPD9_0             (0x1UL << GPIO_PUPDR_PUPD9_Pos)          /*!< 0x00040000 */
#define GPIO_PUPDR_PUPD9_1             (0x2UL << GPIO_PUPDR_PUPD9_Pos)          /*!< 0x00080000 */

#define GPIO_PUPDR_PUPD10_Pos          (20U)
#define GPIO_PUPDR_PUPD10_Msk          (0x3UL << GPIO_PUPDR_PUPD10_Pos)        /*!< 0x00300000 */
#define GPIO_PUPDR_PUPD10              GPIO_PUPDR_PUPD10_Msk
#define GPIO_PUPDR_PUPD10_0            (0x1UL << GPIO_PUPDR_PUPD10_Pos)         /*!< 0x00100000 */
#define GPIO_PUPDR_PUPD10_1            (0x2UL << GPIO_PUPDR_PUPD10_Pos)         /*!< 0x00200000 */

#define GPIO_PUPDR_PUPD11_Pos          (22U)
#define GPIO_PUPDR_PUPD11_Msk          (0x3UL << GPIO_PUPDR_PUPD11_Pos)        /*!< 0x00C00000 */
#define GPIO_PUPDR_PUPD11              GPIO_PUPDR_PUPD11_Msk
#define GPIO_PUPDR_PUPD11_0            (0x1UL << GPIO_PUPDR_PUPD11_Pos)         /*!< 0x00400000 */
#define GPIO_PUPDR_PUPD11_1            (0x2UL << GPIO_PUPDR_PUPD11_Pos)         /*!< 0x00800000 */

#define GPIO_PUPDR_PUPD12_Pos          (24U)
#define GPIO_PUPDR_PUPD12_Msk          (0x3UL << GPIO_PUPDR_PUPD12_Pos)        /*!< 0x03000000 */
#define GPIO_PUPDR_PUPD12              GPIO_PUPDR_PUPD12_Msk
#define GPIO_PUPDR_PUPD12_0            (0x1UL << GPIO_PUPDR_PUPD12_Pos)         /*!< 0x01000000 */
#define GPIO_PUPDR_PUPD12_1            (0x2UL << GPIO_PUPDR_PUPD12_Pos)         /*!< 0x02000000 */

#define GPIO_PUPDR_PUPD13_Pos          (26U)
#define GPIO_PUPDR_PUPD13_Msk          (0x3UL << GPIO_PUPDR_PUPD13_Pos)        /*!< 0x0C000000 */
#define GPIO_PUPDR_PUPD13              GPIO_PUPDR_PUPD13_Msk
#define GPIO_PUPDR_PUPD13_0            (0x1UL << GPIO_PUPDR_PUPD13_Pos)         /*!< 0x04000000 */
#define GPIO_PUPDR_PUPD13_1            (0x2UL << GPIO_PUPDR_PUPD13_Pos)         /*!< 0x08000000 */

#define GPIO_PUPDR_PUPD14_Pos          (28U)
#define GPIO_PUPDR_PUPD14_Msk          (0x3UL << GPIO_PUPDR_PUPD14_Pos)        /*!< 0x30000000 */
#define GPIO_PUPDR_PUPD14              GPIO_PUPDR_PUPD14_Msk
#define GPIO_PUPDR_PUPD14_0            (0x1UL << GPIO_PUPDR_PUPD14_Pos)         /*!< 0x10000000 */
#define GPIO_PUPDR_PUPD14_1            (0x2UL << GPIO_PUPDR_PUPD14_Pos)         /*!< 0x20000000 */

#define GPIO_PUPDR_PUPD15_Pos          (30U)
#define GPIO_PUPDR_PUPD15_Msk          (0x3UL << GPIO_PUPDR_PUPD15_Pos)        /*!< 0xC0000000 */
#define GPIO_PUPDR_PUPD15              GPIO_PUPDR_PUPD15_Msk
#define GPIO_PUPDR_PUPD15_0            (0x1UL << GPIO_PUPDR_PUPD15_Pos)         /*!< 0x40000000 */
#define GPIO_PUPDR_PUPD15_1            (0x2UL << GPIO_PUPDR_PUPD15_Pos)         /*!< 0x80000000 */

/******************  Bits definition for GPIO_IDR register  *******************/
#define GPIO_IDR_ID0_Pos               (0U)
#define GPIO_IDR_ID0_Msk               (0x1UL << GPIO_IDR_ID0_Pos)             /*!< 0x00000001 */
#define GPIO_IDR_ID0                   GPIO_IDR_ID0_Msk
#define GPIO_IDR_ID1_Pos               (1U)
#define GPIO_IDR_ID1_Msk               (0x1UL << GPIO_IDR_ID1_Pos)             /*!< 0x00000002 */
#define GPIO_IDR_ID1                   GPIO_IDR_ID1_Msk
#define GPIO_IDR_ID2_Pos               (2U)
#define GPIO_IDR_ID2_Msk               (0x1UL << GPIO_IDR_ID2_Pos)             /*!< 0x00000004 */
#define GPIO_IDR_ID2                   GPIO_IDR_ID2_Msk
#define GPIO_IDR_ID3_Pos               (3U)
#define GPIO_IDR_ID3_Msk               (0x1UL << GPIO_IDR_ID3_Pos)             /*!< 0x00000008 */
#define GPIO_IDR_ID3                   GPIO_IDR_ID3_Msk
#define GPIO_IDR_ID4_Pos               (4U)
#define GPIO_IDR_ID4_Msk               (0x1UL << GPIO_IDR_ID4_Pos)             /*!< 0x00000010 */
#define GPIO_IDR_ID4                   GPIO_IDR_ID4_Msk
#define GPIO_IDR_ID5_Pos               (5U)
#define GPIO_IDR_ID5_Msk               (0x1UL << GPIO_IDR_ID5_Pos)             /*!< 0x00000020 */
#define GPIO_IDR_ID5                   GPIO_IDR_ID5_Msk
#define GPIO_IDR_ID6_Pos               (6U)
#define GPIO_IDR_ID6_Msk               (0x1UL << GPIO_IDR_ID6_Pos)             /*!< 0x00000040 */
#define GPIO_IDR_ID6                   GPIO_IDR_ID6_Msk
#define GPIO_IDR_ID7_Pos               (7U)
#define GPIO_IDR_ID7_Msk               (0x1UL << GPIO_IDR_ID7_Pos)             /*!< 0x00000080 */
#define GPIO_IDR_ID7                   GPIO_IDR_ID7_Msk
#define GPIO_IDR_ID8_Pos               (8U)
#define GPIO_IDR_ID8_Msk               (0x1UL << GPIO_IDR_ID8_Pos)             /*!< 0x00000100 */
#define GPIO_IDR_ID8                   GPIO_IDR_ID8_Msk
#define GPIO_IDR_ID9_Pos               (9U)
#define GPIO_IDR_ID9_Msk               (0x1UL << GPIO_IDR_ID9_Pos)             /*!< 0x00000200 */
#define GPIO_IDR_ID9                   GPIO_IDR_ID9_Msk
#define GPIO_IDR_ID10_Pos              (10U)
#define GPIO_IDR_ID10_Msk              (0x1UL << GPIO_IDR_ID10_Pos)            /*!< 0x00000400 */
#define GPIO_IDR_ID10                  GPIO_IDR_ID10_Msk
#define GPIO_IDR_ID11_Pos              (11U)
#define GPIO_IDR_ID11_Msk              (0x1UL << GPIO_IDR_ID11_Pos)            /*!< 0x00000800 */
#define GPIO_IDR_ID11                  GPIO_IDR_ID11_Msk
#define GPIO_IDR_ID12_Pos              (12U)
#define GPIO_IDR_ID12_Msk              (0x1UL << GPIO_IDR_ID12_Pos)            /*!< 0x00001000 */
#define GPIO_IDR_ID12                  GPIO_IDR_ID12_Msk
#define GPIO_IDR_ID13_Pos              (13U)
#define GPIO_IDR_ID13_Msk              (0x1UL << GPIO_IDR_ID13_Pos)            /*!< 0x00002000 */
#define GPIO_IDR_ID13                  GPIO_IDR_ID13_Msk
#define GPIO_IDR_ID14_Pos              (14U)
#define GPIO_IDR_ID14_Msk              (0x1UL << GPIO_IDR_ID14_Pos)            /*!< 0x00004000 */
#define GPIO_IDR_ID14                  GPIO_IDR_ID14_Msk
#define GPIO_IDR_ID15_Pos              (15U)
#define GPIO_IDR_ID15_Msk              (0x1UL << GPIO_IDR_ID15_Pos)            /*!< 0x00008000 */
#define GPIO_IDR_ID15                  GPIO_IDR_ID15_Msk

/******************  Bits definition for GPIO_ODR register  *******************/
#define GPIO_ODR_OD0_Pos               (0U)
#define GPIO_ODR_OD0_Msk               (0x1UL << GPIO_ODR_OD0_Pos)             /*!< 0x00000001 */
#define GPIO_ODR_OD0                   GPIO_ODR_OD0_Msk
#define GPIO_ODR_OD1_Pos               (1U)
#define GPIO_ODR_OD1_Msk               (0x1UL << GPIO_ODR_OD1_Pos)             /*!< 0x00000002 */
#define GPIO_ODR_OD1                   GPIO_ODR_OD1_Msk
#define GPIO_ODR_OD2_Pos               (2U)
#define GPIO_ODR_OD2_Msk               (0x1UL << GPIO_ODR_OD2_Pos)             /*!< 0x00000004 */
#define GPIO_ODR_OD2                   GPIO_ODR_OD2_Msk
#define GPIO_ODR_OD3_Pos               (3U)
#define GPIO_ODR_OD3_Msk               (0x1UL << GPIO_ODR_OD3_Pos)             /*!< 0x00000008 */
#define GPIO_ODR_OD3                   GPIO_ODR_OD3_Msk
#define GPIO_ODR_OD4_Pos               (4U)
#define GPIO_ODR_OD4_Msk               (0x1UL << GPIO_ODR_OD4_Pos)             /*!< 0x00000010 */
#define GPIO_ODR_OD4                   GPIO_ODR_OD4_Msk
#define GPIO_ODR_OD5_Pos               (5U)
#define GPIO_ODR_OD5_Msk               (0x1UL << GPIO_ODR_OD5_Pos)             /*!< 0x00000020 */
#define GPIO_ODR_OD5                   GPIO_ODR_OD5_Msk
#define GPIO_ODR_OD6_Pos               (6U)
#define GPIO_ODR_OD6_Msk               (0x1UL << GPIO_ODR_OD6_Pos)             /*!< 0x00000040 */
#define GPIO_ODR_OD6                   GPIO_ODR_OD6_Msk
#define GPIO_ODR_OD7_Pos               (7U)
#define GPIO_ODR_OD7_Msk               (0x1UL << GPIO_ODR_OD7_Pos)             /*!< 0x00000080 */
#define GPIO_ODR_OD7                   GPIO_ODR_OD7_Msk
#define GPIO_ODR_OD8_Pos               (8U)
#define GPIO_ODR_OD8_Msk               (0x1UL << GPIO_ODR_OD8_Pos)             /*!< 0x00000100 */
#define GPIO_ODR_OD8                   GPIO_ODR_OD8_Msk
#define GPIO_ODR_OD9_Pos               (9U)
#define GPIO_ODR_OD9_Msk               (0x1UL << GPIO_ODR_OD9_Pos)             /*!< 0x00000200 */
#define GPIO_ODR_OD9                   GPIO_ODR_OD9_Msk
#define GPIO_ODR_OD10_Pos              (10U)
#define GPIO_ODR_OD10_Msk              (0x1UL << GPIO_ODR_OD10_Pos)            /*!< 0x00000400 */
#define GPIO_ODR_OD10                  GPIO_ODR_OD10_Msk
#define GPIO_ODR_OD11_Pos              (11U)
#define GPIO_ODR_OD11_Msk              (0x1UL << GPIO_ODR_OD11_Pos)            /*!< 0x00000800 */
#define GPIO_ODR_OD11                  GPIO_ODR_OD11_Msk
#define GPIO_ODR_OD12_Pos              (12U)
#define GPIO_ODR_OD12_Msk              (0x1UL << GPIO_ODR_OD12_Pos)            /*!< 0x00001000 */
#define GPIO_ODR_OD12                  GPIO_ODR_OD12_Msk
#define GPIO_ODR_OD13_Pos              (13U)
#define GPIO_ODR_OD13_Msk              (0x1UL << GPIO_ODR_OD13_Pos)            /*!< 0x00002000 */
#define GPIO_ODR_OD13                  GPIO_ODR_OD13_Msk
#define GPIO_ODR_OD14_Pos              (14U)
#define GPIO_ODR_OD14_Msk              (0x1UL << GPIO_ODR_OD14_Pos)            /*!< 0x00004000 */
#define GPIO_ODR_OD14                  GPIO_ODR_OD14_Msk
#define GPIO_ODR_OD15_Pos              (15U)
#define GPIO_ODR_OD15_Msk              (0x1UL << GPIO_ODR_OD15_Pos)            /*!< 0x00008000 */
#define GPIO_ODR_OD15                  GPIO_ODR_OD15_Msk

/******************  Bits definition for GPIO_BSRR register  ******************/
#define GPIO_BSRR_BS0_Pos              (0U)
#define GPIO_BSRR_BS0_Msk              (0x1UL << GPIO_BSRR_BS0_Pos)            /*!< 0x00000001 */
#define GPIO_BSRR_BS0                  GPIO_BSRR_BS0_Msk
#define GPIO_BSRR_BS1_Pos              (1U)
#define GPIO_BSRR_BS1_Msk              (0x1UL << GPIO_BSRR_BS1_Pos)            /*!< 0x00000002 */
#define GPIO_BSRR_BS1                  GPIO_BSRR_BS1_Msk
#define GPIO_BSRR_BS2_Pos              (2U)
#define GPIO_BSRR_BS2_Msk              (0x1UL << GPIO_BSRR_BS2_Pos)            /*!< 0x00000004 */
#define GPIO_BSRR_BS2                  GPIO_BSRR_BS2_Msk
#define GPIO_BSRR_BS3_Pos              (3U)
#define GPIO_BSRR_BS3_Msk              (0x1UL << GPIO_BSRR_BS3_Pos)            /*!< 0x00000008 */
#define GPIO_BSRR_BS3                  GPIO_BSRR_BS3_Msk
#define GPIO_BSRR_BS4_Pos              (4U)
#define GPIO_BSRR_BS4_Msk              (0x1UL << GPIO_BSRR_BS4_Pos)            /*!< 0x00000010 */
#define GPIO_BSRR_BS4                  GPIO_BSRR_BS4_Msk
#define GPIO_BSRR_BS5_Pos              (5U)
#define GPIO_BSRR_BS5_Msk              (0x1UL << GPIO_BSRR_BS5_Pos)            /*!< 0x00000020 */
#define GPIO_BSRR_BS5                  GPIO_BSRR_BS5_Msk
#define GPIO_BSRR_BS6_Pos              (6U)
#define GPIO_BSRR_BS6_Msk              (0x1UL << GPIO_BSRR_BS6_Pos)            /*!< 0x00000040 */
#define GPIO_BSRR_BS6                  GPIO_BSRR_BS6_Msk
#define GPIO_BSRR_BS7_Pos              (7U)
#define GPIO_BSRR_BS7_Msk              (0x1UL << GPIO_BSRR_BS7_Pos)            /*!< 0x00000080 */
#define GPIO_BSRR_BS7                  GPIO_BSRR_BS7_Msk
#define GPIO_BSRR_BS8_Pos              (8U)
#define GPIO_BSRR_BS8_Msk              (0x1UL << GPIO_BSRR_BS8_Pos)            /*!< 0x00000100 */
#define GPIO_BSRR_BS8                  GPIO_BSRR_BS8_Msk
#define GPIO_BSRR_BS9_Pos              (9U)
#define GPIO_BSRR_BS9_Msk              (0x1UL << GPIO_BSRR_BS9_Pos)            /*!< 0x00000200 */
#define GPIO_BSRR_BS9                  GPIO_BSRR_BS9_Msk
#define GPIO_BSRR_BS10_Pos             (10U)
#define GPIO_BSRR_BS10_Msk             (0x1UL << GPIO_BSRR_BS10_Pos)           /*!< 0x00000400 */
#define GPIO_BSRR_BS10                 GPIO_BSRR_BS10_Msk
#define GPIO_BSRR_BS11_Pos             (11U)
#define GPIO_BSRR_BS11_Msk             (0x1UL << GPIO_BSRR_BS11_Pos)           /*!< 0x00000800 */
#define GPIO_BSRR_BS11                 GPIO_BSRR_BS11_Msk
#define GPIO_BSRR_BS12_Pos             (12U)
#define GPIO_BSRR_BS12_Msk             (0x1UL << GPIO_BSRR_BS12_Pos)           /*!< 0x00001000 */
#define GPIO_BSRR_BS12                 GPIO_BSRR_BS12_Msk
#define GPIO_BSRR_BS13_Pos             (13U)
#define GPIO_BSRR_BS13_Msk             (0x1UL << GPIO_BSRR_BS13_Pos)           /*!< 0x00002000 */
#define GPIO_BSRR_BS13                 GPIO_BSRR_BS13_Msk
#define GPIO_BSRR_BS14_Pos             (14U)
#define GPIO_BSRR_BS14_Msk             (0x1UL << GPIO_BSRR_BS14_Pos)           /*!< 0x00004000 */
#define GPIO_BSRR_BS14                 GPIO_BSRR_BS14_Msk
#define GPIO_BSRR_BS15_Pos             (15U)
#define GPIO_BSRR_BS15_Msk             (0x1UL << GPIO_BSRR_BS15_Pos)           /*!< 0x00008000 */
#define GPIO_BSRR_BS15                 GPIO_BSRR_BS15_Msk
#define GPIO_BSRR_BR0_Pos              (16U)
#define GPIO_BSRR_BR0_Msk              (0x1UL << GPIO_BSRR_BR0_Pos)            /*!< 0x00010000 */
#define GPIO_BSRR_BR0                  GPIO_BSRR_BR0_Msk
#define GPIO_BSRR_BR1_Pos              (17U)
#define GPIO_BSRR_BR1_Msk              (0x1UL << GPIO_BSRR_BR1_Pos)            /*!< 0x00020000 */
#define GPIO_BSRR_BR1                  GPIO_BSRR_BR1_Msk
#define GPIO_BSRR_BR2_Pos              (18U)
#define GPIO_BSRR_BR2_Msk              (0x1UL << GPIO_BSRR_BR2_Pos)            /*!< 0x00040000 */
#define GPIO_BSRR_BR2                  GPIO_BSRR_BR2_Msk
#define GPIO_BSRR_BR3_Pos              (19U)
#define GPIO_BSRR_BR3_Msk              (0x1UL << GPIO_BSRR_BR3_Pos)            /*!< 0x00080000 */
#define GPIO_BSRR_BR3                  GPIO_BSRR_BR3_Msk
#define GPIO_BSRR_BR4_Pos              (20U)
#define GPIO_BSRR_BR4_Msk              (0x1UL << GPIO_BSRR_BR4_Pos)            /*!< 0x00100000 */
#define GPIO_BSRR_BR4                  GPIO_BSRR_BR4_Msk
#define GPIO_BSRR_BR5_Pos              (21U)
#define GPIO_BSRR_BR5_Msk              (0x1UL << GPIO_BSRR_BR5_Pos)            /*!< 0x00200000 */
#define GPIO_BSRR_BR5                  GPIO_BSRR_BR5_Msk
#define GPIO_BSRR_BR6_Pos              (22U)
#define GPIO_BSRR_BR6_Msk              (0x1UL << GPIO_BSRR_BR6_Pos)            /*!< 0x00400000 */
#define GPIO_BSRR_BR6                  GPIO_BSRR_BR6_Msk
#define GPIO_BSRR_BR7_Pos              (23U)
#define GPIO_BSRR_BR7_Msk              (0x1UL << GPIO_BSRR_BR7_Pos)            /*!< 0x00800000 */
#define GPIO_BSRR_BR7                  GPIO_BSRR_BR7_Msk
#define GPIO_BSRR_BR8_Pos              (24U)
#define GPIO_BSRR_BR8_Msk              (0x1UL << GPIO_BSRR_BR8_Pos)            /*!< 0x01000000 */
#define GPIO_BSRR_BR8                  GPIO_BSRR_BR8_Msk
#define GPIO_BSRR_BR9_Pos              (25U)
#define GPIO_BSRR_BR9_Msk              (0x1UL << GPIO_BSRR_BR9_Pos)            /*!< 0x02000000 */
#define GPIO_BSRR_BR9                  GPIO_BSRR_BR9_Msk
#define GPIO_BSRR_BR10_Pos             (26U)
#define GPIO_BSRR_BR10_Msk             (0x1UL << GPIO_BSRR_BR10_Pos)           /*!< 0x04000000 */
#define GPIO_BSRR_BR10                 GPIO_BSRR_BR10_Msk
#define GPIO_BSRR_BR11_Pos             (27U)
#define GPIO_BSRR_BR11_Msk             (0x1UL << GPIO_BSRR_BR11_Pos)           /*!< 0x08000000 */
#define GPIO_BSRR_BR11                 GPIO_BSRR_BR11_Msk
#define GPIO_BSRR_BR12_Pos             (28U)
#define GPIO_BSRR_BR12_Msk             (0x1UL << GPIO_BSRR_BR12_Pos)           /*!< 0x10000000 */
#define GPIO_BSRR_BR12                 GPIO_BSRR_BR12_Msk
#define GPIO_BSRR_BR13_Pos             (29U)
#define GPIO_BSRR_BR13_Msk             (0x1UL << GPIO_BSRR_BR13_Pos)           /*!< 0x20000000 */
#define GPIO_BSRR_BR13                 GPIO_BSRR_BR13_Msk
#define GPIO_BSRR_BR14_Pos             (30U)
#define GPIO_BSRR_BR14_Msk             (0x1UL << GPIO_BSRR_BR14_Pos)           /*!< 0x40000000 */
#define GPIO_BSRR_BR14                 GPIO_BSRR_BR14_Msk
#define GPIO_BSRR_BR15_Pos             (31U)
#define GPIO_BSRR_BR15_Msk             (0x1UL << GPIO_BSRR_BR15_Pos)           /*!< 0x80000000 */
#define GPIO_BSRR_BR15                 GPIO_BSRR_BR15_Msk

/****************** Bit definition for GPIO_LCKR register *********************/
#define GPIO_LCKR_LCK0_Pos             (0U)
#define GPIO_LCKR_LCK0_Msk             (0x1UL << GPIO_LCKR_LCK0_Pos)           /*!< 0x00000001 */
#define GPIO_LCKR_LCK0                 GPIO_LCKR_LCK0_Msk
#define GPIO_LCKR_LCK1_Pos             (1U)
#define GPIO_LCKR_LCK1_Msk             (0x1UL << GPIO_LCKR_LCK1_Pos)           /*!< 0x00000002 */
#define GPIO_LCKR_LCK1                 GPIO_LCKR_LCK1_Msk
#define GPIO_LCKR_LCK2_Pos             (2U)
#define GPIO_LCKR_LCK2_Msk             (0x1UL << GPIO_LCKR_LCK2_Pos)           /*!< 0x00000004 */
#define GPIO_LCKR_LCK2                 GPIO_LCKR_LCK2_Msk
#define GPIO_LCKR_LCK3_Pos             (3U)
#define GPIO_LCKR_LCK3_Msk             (0x1UL << GPIO_LCKR_LCK3_Pos)           /*!< 0x00000008 */
#define GPIO_LCKR_LCK3                 GPIO_LCKR_LCK3_Msk
#define GPIO_LCKR_LCK4_Pos             (4U)
#define GPIO_LCKR_LCK4_Msk             (0x1UL << GPIO_LCKR_LCK4_Pos)           /*!< 0x00000010 */
#define GPIO_LCKR_LCK4                 GPIO_LCKR_LCK4_Msk
#define GPIO_LCKR_LCK5_Pos             (5U)
#define GPIO_LCKR_LCK5_Msk             (0x1UL << GPIO_LCKR_LCK5_Pos)           /*!< 0x00000020 */
#define GPIO_LCKR_LCK5                 GPIO_LCKR_LCK5_Msk
#define GPIO_LCKR_LCK6_Pos             (6U)
#define GPIO_LCKR_LCK6_Msk             (0x1UL << GPIO_LCKR_LCK6_Pos)           /*!< 0x00000040 */
#define GPIO_LCKR_LCK6                 GPIO_LCKR_LCK6_Msk
#define GPIO_LCKR_LCK7_Pos             (7U)
#define GPIO_LCKR_LCK7_Msk             (0x1UL << GPIO_LCKR_LCK7_Pos)           /*!< 0x00000080 */
#define GPIO_LCKR_LCK7                 GPIO_LCKR_LCK7_Msk
#define GPIO_LCKR_LCK8_Pos             (8U)
#define GPIO_LCKR_LCK8_Msk             (0x1UL << GPIO_LCKR_LCK8_Pos)           /*!< 0x00000100 */
#define GPIO_LCKR_LCK8                 GPIO_LCKR_LCK8_Msk
#define GPIO_LCKR_LCK9_Pos             (9U)
#define GPIO_LCKR_LCK9_Msk             (0x1UL << GPIO_LCKR_LCK9_Pos)           /*!< 0x00000200 */
#define GPIO_LCKR_LCK9                 GPIO_LCKR_LCK9_Msk
#define GPIO_LCKR_LCK10_Pos            (10U)
#define GPIO_LCKR_LCK10_Msk            (0x1UL << GPIO_LCKR_LCK10_Pos)          /*!< 0x00000400 */
#define GPIO_LCKR_LCK10                GPIO_LCKR_LCK10_Msk
#define GPIO_LCKR_LCK11_Pos            (11U)
#define GPIO_LCKR_LCK11_Msk            (0x1UL << GPIO_LCKR_LCK11_Pos)          /*!< 0x00000800 */
#define GPIO_LCKR_LCK11                GPIO_LCKR_LCK11_Msk
#define GPIO_LCKR_LCK12_Pos            (12U)
#define GPIO_LCKR_LCK12_Msk            (0x1UL << GPIO_LCKR_LCK12_Pos)          /*!< 0x00001000 */
#define GPIO_LCKR_LCK12                GPIO_LCKR_LCK12_Msk
#define GPIO_LCKR_LCK13_Pos            (13U)
#define GPIO_LCKR_LCK13_Msk            (0x1UL << GPIO_LCKR_LCK13_Pos)          /*!< 0x00002000 */
#define GPIO_LCKR_LCK13                GPIO_LCKR_LCK13_Msk
#define GPIO_LCKR_LCK14_Pos            (14U)
#define GPIO_LCKR_LCK14_Msk            (0x1UL << GPIO_LCKR_LCK14_Pos)          /*!< 0x00004000 */
#define GPIO_LCKR_LCK14                GPIO_LCKR_LCK14_Msk
#define GPIO_LCKR_LCK15_Pos            (15U)
#define GPIO_LCKR_LCK15_Msk            (0x1UL << GPIO_LCKR_LCK15_Pos)          /*!< 0x00008000 */
#define GPIO_LCKR_LCK15                GPIO_LCKR_LCK15_Msk
#define GPIO_LCKR_LCKK_Pos             (16U)
#define GPIO_LCKR_LCKK_Msk             (0x1UL << GPIO_LCKR_LCKK_Pos)           /*!< 0x00010000 */
#define GPIO_LCKR_LCKK                 GPIO_LCKR_LCKK_Msk

/****************** Bit definition for GPIO_AFRL register  ********************/
#define GPIO_AFRL_AFSEL0_Pos           (0U)
#define GPIO_AFRL_AFSEL0_Msk           (0xFUL << GPIO_AFRL_AFSEL0_Pos)         /*!< 0x0000000F */
#define GPIO_AFRL_AFSEL0               GPIO_AFRL_AFSEL0_Msk
#define GPIO_AFRL_AFSEL0_0             (0x1UL << GPIO_AFRL_AFSEL0_Pos)          /*!< 0x00000001 */
#define GPIO_AFRL_AFSEL0_1             (0x2UL << GPIO_AFRL_AFSEL0_Pos)          /*!< 0x00000002 */
#define GPIO_AFRL_AFSEL0_2             (0x4UL << GPIO_AFRL_AFSEL0_Pos)          /*!< 0x00000004 */
#define GPIO_AFRL_AFSEL0_3             (0x8UL << GPIO_AFRL_AFSEL0_Pos)          /*!< 0x00000008 */
#define GPIO_AFRL_AFSEL1_Pos           (4U)
#define GPIO_AFRL_AFSEL1_Msk           (0xFUL << GPIO_AFRL_AFSEL1_Pos)         /*!< 0x000000F0 */
#define GPIO_AFRL_AFSEL1               GPIO_AFRL_AFSEL1_Msk
#define GPIO_AFRL_AFSEL1_0             (0x1UL << GPIO_AFRL_AFSEL1_Pos)          /*!< 0x00000010 */
#define GPIO_AFRL_AFSEL1_1             (0x2UL << GPIO_AFRL_AFSEL1_Pos)          /*!< 0x00000020 */
#define GPIO_AFRL_AFSEL1_2             (0x4UL << GPIO_AFRL_AFSEL1_Pos)          /*!< 0x00000040 */
#define GPIO_AFRL_AFSEL1_3             (0x8UL << GPIO_AFRL_AFSEL1_Pos)          /*!< 0x00000080 */
#define GPIO_AFRL_AFSEL2_Pos           (8U)
#define GPIO_AFRL_AFSEL2_Msk           (0xFUL << GPIO_AFRL_AFSEL2_Pos)         /*!< 0x00000F00 */
#define GPIO_AFRL_AFSEL2               GPIO_AFRL_AFSEL2_Msk
#define GPIO_AFRL_AFSEL2_0             (0x1UL << GPIO_AFRL_AFSEL2_Pos)          /*!< 0x00000100 */
#define GPIO_AFRL_AFSEL2_1             (0x2UL << GPIO_AFRL_AFSEL2_Pos)          /*!< 0x00000200 */
#define GPIO_AFRL_AFSEL2_2             (0x4UL << GPIO_AFRL_AFSEL2_Pos)          /*!< 0x00000400 */
#define GPIO_AFRL_AFSEL2_3             (0x8UL << GPIO_AFRL_AFSEL2_Pos)          /*!< 0x00000800 */
#define GPIO_AFRL_AFSEL3_Pos           (12U)
#define GPIO_AFRL_AFSEL3_Msk           (0xFUL << GPIO_AFRL_AFSEL3_Pos)         /*!< 0x0000F000 */
#define GPIO_AFRL_AFSEL3               GPIO_AFRL_AFSEL3_Msk
#define GPIO_AFRL_AFSEL3_0             (0x1UL << GPIO_AFRL_AFSEL3_Pos)          /*!< 0x00001000 */
#define GPIO_AFRL_AFSEL3_1             (0x2UL << GPIO_AFRL_AFSEL3_Pos)          /*!< 0x00002000 */
#define GPIO_AFRL_AFSEL3_2             (0x4UL << GPIO_AFRL_AFSEL3_Pos)          /*!< 0x00004000 */
#define GPIO_AFRL_AFSEL3_3             (0x8UL << GPIO_AFRL_AFSEL3_Pos)          /*!< 0x00008000 */
#define GPIO_AFRL_AFSEL4_Pos           (16U)
#define GPIO_AFRL_AFSEL4_Msk           (0xFUL << GPIO_AFRL_AFSEL4_Pos)         /*!< 0x000F0000 */
#define GPIO_AFRL_AFSEL4               GPIO_AFRL_AFSEL4_Msk
#define GPIO_AFRL_AFSEL4_0             (0x1UL << GPIO_AFRL_AFSEL4_Pos)          /*!< 0x00010000 */
#define GPIO_AFRL_AFSEL4_1             (0x2UL << GPIO_AFRL_AFSEL4_Pos)          /*!< 0x00020000 */
#define GPIO_AFRL_AFSEL4_2             (0x4UL << GPIO_AFRL_AFSEL4_Pos)          /*!< 0x00040000 */
#define GPIO_AFRL_AFSEL4_3             (0x8UL << GPIO_AFRL_AFSEL4_Pos)          /*!< 0x00080000 */
#define GPIO_AFRL_AFSEL5_Pos           (20U)
#define GPIO_AFRL_AFSEL5_Msk           (0xFUL << GPIO_AFRL_AFSEL5_Pos)         /*!< 0x00F00000 */
#define GPIO_AFRL_AFSEL5               GPIO_AFRL_AFSEL5_Msk
#define GPIO_AFRL_AFSEL5_0             (0x1UL << GPIO_AFRL_AFSEL5_Pos)          /*!< 0x00100000 */
#define GPIO_AFRL_AFSEL5_1             (0x2UL << GPIO_AFRL_AFSEL5_Pos)          /*!< 0x00200000 */
#define GPIO_AFRL_AFSEL5_2             (0x4UL << GPIO_AFRL_AFSEL5_Pos)          /*!< 0x00400000 */
#define GPIO_AFRL_AFSEL5_3             (0x8UL << GPIO_AFRL_AFSEL5_Pos)          /*!< 0x00800000 */
#define GPIO_AFRL_AFSEL6_Pos           (24U)
#define GPIO_AFRL_AFSEL6_Msk           (0xFUL << GPIO_AFRL_AFSEL6_Pos)         /*!< 0x0F000000 */
#define GPIO_AFRL_AFSEL6               GPIO_AFRL_AFSEL6_Msk
#define GPIO_AFRL_AFSEL6_0             (0x1UL << GPIO_AFRL_AFSEL6_Pos)          /*!< 0x01000000 */
#define GPIO_AFRL_AFSEL6_1             (0x2UL << GPIO_AFRL_AFSEL6_Pos)          /*!< 0x02000000 */
#define GPIO_AFRL_AFSEL6_2             (0x4UL << GPIO_AFRL_AFSEL6_Pos)          /*!< 0x04000000 */
#define GPIO_AFRL_AFSEL6_3             (0x8UL << GPIO_AFRL_AFSEL6_Pos)          /*!< 0x08000000 */
#define GPIO_AFRL_AFSEL7_Pos           (28U)
#define GPIO_AFRL_AFSEL7_Msk           (0xFUL << GPIO_AFRL_AFSEL7_Pos)         /*!< 0xF0000000 */
#define GPIO_AFRL_AFSEL7               GPIO_AFRL_AFSEL7_Msk
#define GPIO_AFRL_AFSEL7_0             (0x1UL << GPIO_AFRL_AFSEL7_Pos)          /*!< 0x10000000 */
#define GPIO_AFRL_AFSEL7_1             (0x2UL << GPIO_AFRL_AFSEL7_Pos)          /*!< 0x20000000 */
#define GPIO_AFRL_AFSEL7_2             (0x4UL << GPIO_AFRL_AFSEL7_Pos)          /*!< 0x40000000 */
#define GPIO_AFRL_AFSEL7_3             (0x8UL << GPIO_AFRL_AFSEL7_Pos)          /*!< 0x80000000 */

/* Legacy defines */
#define GPIO_AFRL_AFRL0                      GPIO_AFRL_AFSEL0
#define GPIO_AFRL_AFRL1                      GPIO_AFRL_AFSEL1
#define GPIO_AFRL_AFRL2                      GPIO_AFRL_AFSEL2
#define GPIO_AFRL_AFRL3                      GPIO_AFRL_AFSEL3
#define GPIO_AFRL_AFRL4                      GPIO_AFRL_AFSEL4
#define GPIO_AFRL_AFRL5                      GPIO_AFRL_AFSEL5
#define GPIO_AFRL_AFRL6                      GPIO_AFRL_AFSEL6
#define GPIO_AFRL_AFRL7                      GPIO_AFRL_AFSEL7

/****************** Bit definition for GPIO_AFRH register  ********************/
#define GPIO_AFRH_AFSEL8_Pos           (0U)
#define GPIO_AFRH_AFSEL8_Msk           (0xFUL << GPIO_AFRH_AFSEL8_Pos)         /*!< 0x0000000F */
#define GPIO_AFRH_AFSEL8               GPIO_AFRH_AFSEL8_Msk
#define GPIO_AFRH_AFSEL8_0             (0x1UL << GPIO_AFRH_AFSEL8_Pos)          /*!< 0x00000001 */
#define GPIO_AFRH_AFSEL8_1             (0x2UL << GPIO_AFRH_AFSEL8_Pos)          /*!< 0x00000002 */
#define GPIO_AFRH_AFSEL8_2             (0x4UL << GPIO_AFRH_AFSEL8_Pos)          /*!< 0x00000004 */
#define GPIO_AFRH_AFSEL8_3             (0x8UL << GPIO_AFRH_AFSEL8_Pos)          /*!< 0x00000008 */
#define GPIO_AFRH_AFSEL9_Pos           (4U)
#define GPIO_AFRH_AFSEL9_Msk           (0xFUL << GPIO_AFRH_AFSEL9_Pos)         /*!< 0x000000F0 */
#define GPIO_AFRH_AFSEL9               GPIO_AFRH_AFSEL9_Msk
#define GPIO_AFRH_AFSEL9_0             (0x1UL << GPIO_AFRH_AFSEL9_Pos)          /*!< 0x00000010 */
#define GPIO_AFRH_AFSEL9_1             (0x2UL << GPIO_AFRH_AFSEL9_Pos)          /*!< 0x00000020 */
#define GPIO_AFRH_AFSEL9_2             (0x4UL << GPIO_AFRH_AFSEL9_Pos)          /*!< 0x00000040 */
#define GPIO_AFRH_AFSEL9_3             (0x8UL << GPIO_AFRH_AFSEL9_Pos)          /*!< 0x00000080 */
#define GPIO_AFRH_AFSEL10_Pos          (8U)
#define GPIO_AFRH_AFSEL10_Msk          (0xFUL << GPIO_AFRH_AFSEL10_Pos)        /*!< 0x00000F00 */
#define GPIO_AFRH_AFSEL10              GPIO_AFRH_AFSEL10_Msk
#define GPIO_AFRH_AFSEL10_0            (0x1UL << GPIO_AFRH_AFSEL10_Pos)         /*!< 0x00000100 */
#define GPIO_AFRH_AFSEL10_1            (0x2UL << GPIO_AFRH_AFSEL10_Pos)         /*!< 0x00000200 */
#define GPIO_AFRH_AFSEL10_2            (0x4UL << GPIO_AFRH_AFSEL10_Pos)         /*!< 0x00000400 */
#define GPIO_AFRH_AFSEL10_3            (0x8UL << GPIO_AFRH_AFSEL10_Pos)         /*!< 0x00000800 */
#define GPIO_AFRH_AFSEL11_Pos          (12U)
#define GPIO_AFRH_AFSEL11_Msk          (0xFUL << GPIO_AFRH_AFSEL11_Pos)        /*!< 0x0000F000 */
#define GPIO_AFRH_AFSEL11              GPIO_AFRH_AFSEL11_Msk
#define GPIO_AFRH_AFSEL11_0            (0x1UL << GPIO_AFRH_AFSEL11_Pos)         /*!< 0x00001000 */
#define GPIO_AFRH_AFSEL11_1            (0x2UL << GPIO_AFRH_AFSEL11_Pos)         /*!< 0x00002000 */
#define GPIO_AFRH_AFSEL11_2            (0x4UL << GPIO_AFRH_AFSEL11_Pos)         /*!< 0x00004000 */
#define GPIO_AFRH_AFSEL11_3            (0x8UL << GPIO_AFRH_AFSEL11_Pos)         /*!< 0x00008000 */
#define GPIO_AFRH_AFSEL12_Pos          (16U)
#define GPIO_AFRH_AFSEL12_Msk          (0xFUL << GPIO_AFRH_AFSEL12_Pos)        /*!< 0x000F0000 */
#define GPIO_AFRH_AFSEL12              GPIO_AFRH_AFSEL12_Msk
#define GPIO_AFRH_AFSEL12_0            (0x1UL << GPIO_AFRH_AFSEL12_Pos)         /*!< 0x00010000 */
#define GPIO_AFRH_AFSEL12_1            (0x2UL << GPIO_AFRH_AFSEL12_Pos)         /*!< 0x00020000 */
#define GPIO_AFRH_AFSEL12_2            (0x4UL << GPIO_AFRH_AFSEL12_Pos)         /*!< 0x00040000 */
#define GPIO_AFRH_AFSEL12_3            (0x8UL << GPIO_AFRH_AFSEL12_Pos)         /*!< 0x00080000 */
#define GPIO_AFRH_AFSEL13_Pos          (20U)
#define GPIO_AFRH_AFSEL13_Msk          (0xFUL << GPIO_AFRH_AFSEL13_Pos)        /*!< 0x00F00000 */
#define GPIO_AFRH_AFSEL13              GPIO_AFRH_AFSEL13_Msk
#define GPIO_AFRH_AFSEL13_0            (0x1UL << GPIO_AFRH_AFSEL13_Pos)         /*!< 0x00100000 */
#define GPIO_AFRH_AFSEL13_1            (0x2UL << GPIO_AFRH_AFSEL13_Pos)         /*!< 0x00200000 */
#define GPIO_AFRH_AFSEL13_2            (0x4UL << GPIO_AFRH_AFSEL13_Pos)         /*!< 0x00400000 */
#define GPIO_AFRH_AFSEL13_3            (0x8UL << GPIO_AFRH_AFSEL13_Pos)         /*!< 0x00800000 */
#define GPIO_AFRH_AFSEL14_Pos          (24U)
#define GPIO_AFRH_AFSEL14_Msk          (0xFUL << GPIO_AFRH_AFSEL14_Pos)        /*!< 0x0F000000 */
#define GPIO_AFRH_AFSEL14              GPIO_AFRH_AFSEL14_Msk
#define GPIO_AFRH_AFSEL14_0            (0x1UL << GPIO_AFRH_AFSEL14_Pos)         /*!< 0x01000000 */
#define GPIO_AFRH_AFSEL14_1            (0x2UL << GPIO_AFRH_AFSEL14_Pos)         /*!< 0x02000000 */
#define GPIO_AFRH_AFSEL14_2            (0x4UL << GPIO_AFRH_AFSEL14_Pos)         /*!< 0x04000000 */
#define GPIO_AFRH_AFSEL14_3            (0x8UL << GPIO_AFRH_AFSEL14_Pos)         /*!< 0x08000000 */
#define GPIO_AFRH_AFSEL15_Pos          (28U)
#define GPIO_AFRH_AFSEL15_Msk          (0xFUL << GPIO_AFRH_AFSEL15_Pos)        /*!< 0xF0000000 */
#define GPIO_AFRH_AFSEL15              GPIO_AFRH_AFSEL15_Msk
#define GPIO_AFRH_AFSEL15_0            (0x1UL << GPIO_AFRH_AFSEL15_Pos)         /*!< 0x10000000 */
#define GPIO_AFRH_AFSEL15_1            (0x2UL << GPIO_AFRH_AFSEL15_Pos)         /*!< 0x20000000 */
#define GPIO_AFRH_AFSEL15_2            (0x4UL << GPIO_AFRH_AFSEL15_Pos)         /*!< 0x40000000 */
#define GPIO_AFRH_AFSEL15_3            (0x8UL << GPIO_AFRH_AFSEL15_Pos)         /*!< 0x80000000 */

/* Legacy defines */
#define GPIO_AFRH_AFRH0                      GPIO_AFRH_AFSEL8
#define GPIO_AFRH_AFRH1                      GPIO_AFRH_AFSEL9
#define GPIO_AFRH_AFRH2                      GPIO_AFRH_AFSEL10
#define GPIO_AFRH_AFRH3                      GPIO_AFRH_AFSEL11
#define GPIO_AFRH_AFRH4                      GPIO_AFRH_AFSEL12
#define GPIO_AFRH_AFRH5                      GPIO_AFRH_AFSEL13
#define GPIO_AFRH_AFRH6                      GPIO_AFRH_AFSEL14
#define GPIO_AFRH_AFRH7                      GPIO_AFRH_AFSEL15

/******************************************************************************/
/*                                                                            */
/*                        HSEM HW Semaphore                                   */
/*                                                                            */
/******************************************************************************/
/********************  Bit definition for HSEM_R register  ********************/
#define HSEM_R_PROCID_Pos         (0U)
#define HSEM_R_PROCID_Msk         (0xFFUL << HSEM_R_PROCID_Pos)                /*!< 0x000000FF */
#define HSEM_R_PROCID             HSEM_R_PROCID_Msk                            /*!<Semaphore ProcessID */
#define HSEM_R_COREID_Pos         (8U)
#define HSEM_R_COREID_Msk         (0xFFUL << HSEM_R_COREID_Pos)                /*!< 0x0000FF00 */
#define HSEM_R_COREID             HSEM_R_COREID_Msk                            /*!<Semaphore CoreID.   */
#define HSEM_R_LOCK_Pos           (31U)
#define HSEM_R_LOCK_Msk           (0x1UL << HSEM_R_LOCK_Pos)                   /*!< 0x80000000 */
#define HSEM_R_LOCK               HSEM_R_LOCK_Msk                              /*!<Lock indication.    */

/********************  Bit definition for HSEM_RLR register  ******************/
#define HSEM_RLR_PROCID_Pos       (0U)
#define HSEM_RLR_PROCID_Msk       (0xFFUL << HSEM_RLR_PROCID_Pos)              /*!< 0x000000FF */
#define HSEM_RLR_PROCID           HSEM_RLR_PROCID_Msk                          /*!<Semaphore ProcessID */
#define HSEM_RLR_COREID_Pos       (8U)
#define HSEM_RLR_COREID_Msk       (0xFFUL << HSEM_RLR_COREID_Pos)              /*!< 0x0000FF00 */
#define HSEM_RLR_COREID           HSEM_RLR_COREID_Msk                          /*!<Semaphore CoreID.   */
#define HSEM_RLR_LOCK_Pos         (31U)
#define HSEM_RLR_LOCK_Msk         (0x1UL << HSEM_RLR_LOCK_Pos)                 /*!< 0x80000000 */
#define HSEM_RLR_LOCK             HSEM_RLR_LOCK_Msk                            /*!<Lock indication.    */

/********************  Bit definition for HSEM_C1IER register  *****************/
#define HSEM_C1IER_ISE0_Pos       (0U)
#define HSEM_C1IER_ISE0_Msk       (0x1UL << HSEM_C1IER_ISE0_Pos)               /*!< 0x00000001 */
#define HSEM_C1IER_ISE0           HSEM_C1IER_ISE0_Msk                          /*!<semaphore 0 , interrupt 0 enable bit.  */
#define HSEM_C1IER_ISE1_Pos       (1U)
#define HSEM_C1IER_ISE1_Msk       (0x1UL << HSEM_C1IER_ISE1_Pos)               /*!< 0x00000002 */
#define HSEM_C1IER_ISE1           HSEM_C1IER_ISE1_Msk                          /*!<semaphore 1 , interrupt 0 enable bit.  */
#define HSEM_C1IER_ISE2_Pos       (2U)
#define HSEM_C1IER_ISE2_Msk       (0x1UL << HSEM_C1IER_ISE2_Pos)               /*!< 0x00000004 */
#define HSEM_C1IER_ISE2           HSEM_C1IER_ISE2_Msk                          /*!<semaphore 2 , interrupt 0 enable bit.  */
#define HSEM_C1IER_ISE3_Pos       (3U)
#define HSEM_C1IER_ISE3_Msk       (0x1UL << HSEM_C1IER_ISE3_Pos)               /*!< 0x00000008 */
#define HSEM_C1IER_ISE3           HSEM_C1IER_ISE3_Msk                          /*!<semaphore 3 , interrupt 0 enable bit.  */
#define HSEM_C1IER_ISE4_Pos       (4U)
#define HSEM_C1IER_ISE4_Msk       (0x1UL << HSEM_C1IER_ISE4_Pos)               /*!< 0x00000010 */
#define HSEM_C1IER_ISE4           HSEM_C1IER_ISE4_Msk                          /*!<semaphore 4 , interrupt 0 enable bit.  */
#define HSEM_C1IER_ISE5_Pos       (5U)
#define HSEM_C1IER_ISE5_Msk       (0x1UL << HSEM_C1IER_ISE5_Pos)               /*!< 0x00000020 */
#define HSEM_C1IER_ISE5           HSEM_C1IER_ISE5_Msk                          /*!<semaphore 5 interrupt 0 enable bit.    */
#define HSEM_C1IER_ISE6_Pos       (6U)
#define HSEM_C1IER_ISE6_Msk       (0x1UL << HSEM_C1IER_ISE6_Pos)               /*!< 0x00000040 */
#define HSEM_C1IER_ISE6           HSEM_C1IER_ISE6_Msk                          /*!<semaphore 6 interrupt 0 enable bit.    */
#define HSEM_C1IER_ISE7_Pos       (7U)
#define HSEM_C1IER_ISE7_Msk       (0x1UL << HSEM_C1IER_ISE7_Pos)               /*!< 0x00000080 */
#define HSEM_C1IER_ISE7           HSEM_C1IER_ISE7_Msk                          /*!<semaphore 7 interrupt 0 enable bit.    */
#define HSEM_C1IER_ISE8_Pos       (8U)
#define HSEM_C1IER_ISE8_Msk       (0x1UL << HSEM_C1IER_ISE8_Pos)               /*!< 0x00000100 */
#define HSEM_C1IER_ISE8           HSEM_C1IER_ISE8_Msk                          /*!<semaphore 8 interrupt 0 enable bit.    */
#define HSEM_C1IER_ISE9_Pos       (9U)
#define HSEM_C1IER_ISE9_Msk       (0x1UL << HSEM_C1IER_ISE9_Pos)               /*!< 0x00000200 */
#define HSEM_C1IER_ISE9           HSEM_C1IER_ISE9_Msk                          /*!<semaphore 9 interrupt 0 enable bit.    */
#define HSEM_C1IER_ISE10_Pos      (10U)
#define HSEM_C1IER_ISE10_Msk      (0x1UL << HSEM_C1IER_ISE10_Pos)              /*!< 0x00000400 */
#define HSEM_C1IER_ISE10          HSEM_C1IER_ISE10_Msk                         /*!<semaphore 10 interrupt 0 enable bit.   */
#define HSEM_C1IER_ISE11_Pos      (11U)
#define HSEM_C1IER_ISE11_Msk      (0x1UL << HSEM_C1IER_ISE11_Pos)              /*!< 0x00000800 */
#define HSEM_C1IER_ISE11          HSEM_C1IER_ISE11_Msk                         /*!<semaphore 11 interrupt 0 enable bit.   */
#define HSEM_C1IER_ISE12_Pos      (12U)
#define HSEM_C1IER_ISE12_Msk      (0x1UL << HSEM_C1IER_ISE12_Pos)              /*!< 0x00001000 */
#define HSEM_C1IER_ISE12          HSEM_C1IER_ISE12_Msk                         /*!<semaphore 12 interrupt 0 enable bit.   */
#define HSEM_C1IER_ISE13_Pos      (13U)
#define HSEM_C1IER_ISE13_Msk      (0x1UL << HSEM_C1IER_ISE13_Pos)              /*!< 0x00002000 */
#define HSEM_C1IER_ISE13          HSEM_C1IER_ISE13_Msk                         /*!<semaphore 13 interrupt 0 enable bit.   */
#define HSEM_C1IER_ISE14_Pos      (14U)
#define HSEM_C1IER_ISE14_Msk      (0x1UL << HSEM_C1IER_ISE14_Pos)              /*!< 0x00004000 */
#define HSEM_C1IER_ISE14          HSEM_C1IER_ISE14_Msk                         /*!<semaphore 14 interrupt 0 enable bit.   */
#define HSEM_C1IER_ISE15_Pos      (15U)
#define HSEM_C1IER_ISE15_Msk      (0x1UL << HSEM_C1IER_ISE15_Pos)              /*!< 0x00008000 */
#define HSEM_C1IER_ISE15          HSEM_C1IER_ISE15_Msk                         /*!<semaphore 15 interrupt 0 enable bit. */
#define HSEM_C1IER_ISE16_Pos      (16U)
#define HSEM_C1IER_ISE16_Msk      (0x1UL << HSEM_C1IER_ISE16_Pos)              /*!< 0x00010000 */
#define HSEM_C1IER_ISE16          HSEM_C1IER_ISE16_Msk                         /*!<semaphore 16 interrupt 0 enable bit. */
#define HSEM_C1IER_ISE17_Pos      (17U)
#define HSEM_C1IER_ISE17_Msk      (0x1UL << HSEM_C1IER_ISE17_Pos)              /*!< 0x00020000 */
#define HSEM_C1IER_ISE17          HSEM_C1IER_ISE17_Msk                         /*!<semaphore 17 interrupt 0 enable bit. */
#define HSEM_C1IER_ISE18_Pos      (18U)
#define HSEM_C1IER_ISE18_Msk      (0x1UL << HSEM_C1IER_ISE18_Pos)              /*!< 0x00040000 */
#define HSEM_C1IER_ISE18          HSEM_C1IER_ISE18_Msk                         /*!<semaphore 18 interrupt 0 enable bit. */
#define HSEM_C1IER_ISE19_Pos      (19U)
#define HSEM_C1IER_ISE19_Msk      (0x1UL << HSEM_C1IER_ISE19_Pos)              /*!< 0x00080000 */
#define HSEM_C1IER_ISE19          HSEM_C1IER_ISE19_Msk                         /*!<semaphore 19 interrupt 0 enable bit. */
#define HSEM_C1IER_ISE20_Pos      (20U)
#define HSEM_C1IER_ISE20_Msk      (0x1UL << HSEM_C1IER_ISE20_Pos)              /*!< 0x00100000 */
#define HSEM_C1IER_ISE20          HSEM_C1IER_ISE20_Msk                         /*!<semaphore 20 interrupt 0 enable bit. */
#define HSEM_C1IER_ISE21_Pos      (21U)
#define HSEM_C1IER_ISE21_Msk      (0x1UL << HSEM_C1IER_ISE21_Pos)              /*!< 0x00200000 */
#define HSEM_C1IER_ISE21          HSEM_C1IER_ISE21_Msk                         /*!<semaphore 21 interrupt 0 enable bit. */
#define HSEM_C1IER_ISE22_Pos      (22U)
#define HSEM_C1IER_ISE22_Msk      (0x1UL << HSEM_C1IER_ISE22_Pos)              /*!< 0x00400000 */
#define HSEM_C1IER_ISE22          HSEM_C1IER_ISE22_Msk                         /*!<semaphore 22 interrupt 0 enable bit. */
#define HSEM_C1IER_ISE23_Pos      (23U)
#define HSEM_C1IER_ISE23_Msk      (0x1UL << HSEM_C1IER_ISE23_Pos)              /*!< 0x00800000 */
#define HSEM_C1IER_ISE23          HSEM_C1IER_ISE23_Msk                         /*!<semaphore 23 interrupt 0 enable bit. */
#define HSEM_C1IER_ISE24_Pos      (24U)
#define HSEM_C1IER_ISE24_Msk      (0x1UL << HSEM_C1IER_ISE24_Pos)              /*!< 0x01000000 */
#define HSEM_C1IER_ISE24          HSEM_C1IER_ISE24_Msk                         /*!<semaphore 24 interrupt 0 enable bit. */
#define HSEM_C1IER_ISE25_Pos      (25U)
#define HSEM_C1IER_ISE25_Msk      (0x1UL << HSEM_C1IER_ISE25_Pos)              /*!< 0x02000000 */
#define HSEM_C1IER_ISE25          HSEM_C1IER_ISE25_Msk                         /*!<semaphore 25 interrupt 0 enable bit. */
#define HSEM_C1IER_ISE26_Pos      (26U)
#define HSEM_C1IER_ISE26_Msk      (0x1UL << HSEM_C1IER_ISE26_Pos)              /*!< 0x04000000 */
#define HSEM_C1IER_ISE26          HSEM_C1IER_ISE26_Msk                         /*!<semaphore 26 interrupt 0 enable bit. */
#define HSEM_C1IER_ISE27_Pos      (27U)
#define HSEM_C1IER_ISE27_Msk      (0x1UL << HSEM_C1IER_ISE27_Pos)              /*!< 0x08000000 */
#define HSEM_C1IER_ISE27          HSEM_C1IER_ISE27_Msk                         /*!<semaphore 27 interrupt 0 