/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.intermediate.LongEdgeSplitter;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.EdgeLabelPlacement;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class LabelDummyInserter
implements ILayoutProcessor<LGraph> {
    private static final Predicate<LLabel> CENTER_LABEL = new Predicate<LLabel>(){

        @Override
        public boolean apply(LLabel label) {
            return label.getProperty(LayeredOptions.EDGE_LABELS_PLACEMENT) == EdgeLabelPlacement.CENTER;
        }
    };

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Label dummy insertions", 1.0f);
        ArrayList<LNode> newDummyNodes = Lists.newArrayList();
        double edgeLabelSpacing = layeredGraph.getProperty(LayeredOptions.SPACING_EDGE_LABEL);
        double labelLabelSpacing = layeredGraph.getProperty(LayeredOptions.SPACING_LABEL_LABEL);
        Direction layoutDirection = layeredGraph.getProperty(LayeredOptions.DIRECTION);
        for (LNode node : layeredGraph.getLayerlessNodes()) {
            for (LEdge edge : node.getOutgoingEdges()) {
                if (!this.edgeNeedsToBeProcessed(edge)) continue;
                double thickness = this.retrieveThickness(edge);
                ArrayList<LLabel> representedLabels = Lists.newArrayListWithCapacity(edge.getLabels().size());
                LNode dummyNode = this.createLabelDummy(layeredGraph, edge, thickness, representedLabels);
                newDummyNodes.add(dummyNode);
                KVector dummySize = dummyNode.getSize();
                ListIterator<LLabel> iterator = edge.getLabels().listIterator();
                while (iterator.hasNext()) {
                    LLabel label = iterator.next();
                    if (label.getProperty(LayeredOptions.EDGE_LABELS_PLACEMENT) != EdgeLabelPlacement.CENTER) continue;
                    if (layoutDirection.isVertical()) {
                        dummySize.x += label.getSize().x + labelLabelSpacing;
                        dummySize.y = Math.max(dummySize.y, label.getSize().y);
                    } else {
                        dummySize.x = Math.max(dummySize.x, label.getSize().x);
                        dummySize.y += label.getSize().y + labelLabelSpacing;
                    }
                    representedLabels.add(label);
                    iterator.remove();
                }
                if (layoutDirection.isVertical()) {
                    dummySize.x -= labelLabelSpacing;
                    dummySize.y += edgeLabelSpacing + thickness;
                    continue;
                }
                dummySize.y += edgeLabelSpacing - labelLabelSpacing + thickness;
            }
        }
        layeredGraph.getLayerlessNodes().addAll(newDummyNodes);
        monitor.done();
    }

    private boolean edgeNeedsToBeProcessed(LEdge edge) {
        return edge.getSource().getNode() != edge.getTarget().getNode() && Iterables.any(edge.getLabels(), CENTER_LABEL);
    }

    private double retrieveThickness(LEdge edge) {
        double thickness = edge.getProperty(LayeredOptions.EDGE_THICKNESS);
        if (thickness < 0.0) {
            thickness = 0.0;
            edge.setProperty(LayeredOptions.EDGE_THICKNESS, (Object)thickness);
        }
        return thickness;
    }

    private LNode createLabelDummy(LGraph layeredGraph, LEdge edge, double thickness, List<LLabel> representedLabels) {
        LNode dummyNode = new LNode(layeredGraph);
        dummyNode.setType(LNode.NodeType.LABEL);
        dummyNode.setProperty(InternalProperties.ORIGIN, edge);
        dummyNode.setProperty(InternalProperties.REPRESENTED_LABELS, representedLabels);
        dummyNode.setProperty(LayeredOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_POS);
        dummyNode.setProperty(InternalProperties.LONG_EDGE_SOURCE, edge.getSource());
        dummyNode.setProperty(InternalProperties.LONG_EDGE_TARGET, edge.getTarget());
        LongEdgeSplitter.splitEdge(edge, dummyNode);
        double portPos = Math.floor(thickness / 2.0);
        for (LPort dummyPort : dummyNode.getPorts()) {
            dummyPort.getPosition().y = portPos;
        }
        return dummyNode;
    }
}

